/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CCONSOLEWINDOW_H
#define CCONSOLEWINDOW_H

#include <qvariant.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qstatusbar.h>
#include <qapplication.h>
#include <qsplitter.h>
#include <qwidgetstack.h>
#include <qdockwindow.h>

#include "CMyWindow.h"
#include "CAboutBox.h"
#include "Config.h"
#include "CDatabaseTree.h"
#include "CConnectionDialog.h"
#include "CDatabaseTreeItem.h"
#include "CSharedMenus.h"

class QVBoxLayout; 
class QAction;
class QActionGroup;
class QToolBar;
class QPopupMenu;
class CDatabaseTree;
class QWidgetStack;


class privateTreePanel : public QDockWindow
{
  Q_OBJECT

public:
  privateTreePanel( Place p = InDock, QWidget * parent = 0, const char * name = 0, WFlags f = 0)
    :QDockWindow(p, parent, name, f)
  {
    if (!name)
      setName("privateTreePanel");
    setMovingEnabled (true);
    setResizeEnabled (true);
    setHorizontallyStretchable (true);
    setVerticallyStretchable (true);
    setOpaqueMoving (false);
    setCloseMode(CMessageWindow::Always);
    canClose = false;
    setNewLine(true);
  }  

  ~privateTreePanel()
  {
#ifdef DEBUG
    qDebug("~privateTreePanel()");
#endif
  }

  void setCanClose(bool b) { canClose = b; }

  void closeEvent ( QCloseEvent * e )
  {
    if (canClose)
    {
#ifdef DEBUG
      qDebug("privateTreePanel - Closed");
#endif
      e->accept();
    }
    else
    {
      e->ignore();
      hide();
#ifdef DEBUG
      qDebug("privateTreePanel - Hiden");
#endif
    }
  }

private:
  bool canClose;  
};

class CConsoleWindow : public CMyWindow
{ 
  Q_OBJECT
    
public:
  CConsoleWindow( QWidget* parent = 0, const char* name = 0, WFlags fl = WType_TopLevel, CDatabaseTreeItem * itemRoot = 0, bool destroy=false);  
  ~CConsoleWindow();
  privateTreePanel * treePanel;
  CDatabaseTree*	m_pDatabaseTree;
  QWidgetStack*	m_pConsoleStack;
  bool getCanClose();
  virtual void setCaption ( const QString &caption );
  bool loadWindowSettings(bool b=false);
  void saveWindowSettings();  
  bool canClose;
  QWidget *defaultWidget;
  void beforeClose();

  static CSqlDebugPanel *sqlDebugPanel;

signals:
  void hideMe();
   
private:
  QVBoxLayout* CConsoleWindowLayout;  
  void closeEvent (QCloseEvent *e);  
  void p_saveWindowSettings(QDockWindow *dw, const QString &c, CConfig *cfg);
  bool p_loadWindowSettings(bool r, QDockWindow *dw, const QString &c, CConfig *cfg);

private slots:
  void UndockWindows();
};

#endif // CCONSOLEWINDOW_H

