/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CCONNECTIONDIALOG_H
#define CCONNECTIONDIALOG_H

#include <qvariant.h>
#include <qwidget.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qfile.h>
#include "CConfigDialog.h"
#include "CDatabaseTreeItem.h"
#include "CMySQLConnection.h"
#include "CConnectionDialog.h"

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QCheckBox;
class QGroupBox;
class QLabel;
class QLineEdit;
class QPushButton;
class QSpinBox;
class privateTabConfig;

class p_SaveOptions : public privateTabConfig
{ 
  Q_OBJECT
      
public:
  p_SaveOptions(QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
  void setDefaultValues(CConfig *conn=0);
  bool save(CConfig *conn);  
  
private:
  QLineEdit* Separated;
  QLineEdit* Terminated;
  QLabel* separateLable;
  QLabel* enclosedLabel;
  QLabel* terminatedLabel;
  QLabel* replaceEmptyLabel;
  QLineEdit* ReplaceEmpty;
  QLineEdit* Enclosed;
  QLabel* TextLabel4;
  QVBoxLayout* p_SaveOptionsLayout;
  QGridLayout* Layout20;
};

class p_GeneralConnection : public privateTabConfig
{ 
  Q_OBJECT
    
public:
  p_GeneralConnection(bool isediting, QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );  
  void setDefaultValues(CConfig *Settings);
  bool save(CConfig *conn);  
  QString validate();

  CMySQLConnection *mysql;  

  QSpinBox* PortBox;
  QLineEdit* ConnectionNameBox;    
  QLineEdit* HostNameBox;
  QLineEdit* PasswordBox;
  QSpinBox* connectTimeout;    
  QLineEdit* UserNameBox;
  QGroupBox* Options;
  QCheckBox* blockingCheckBox;    
  QLineEdit* socketFile;
  QPushButton* socketBrowse;
  QCheckBox* oneConnectionCheckBox;
  QCheckBox* enableCompletionCheckBox;
  QCheckBox* compressCheckBox;
  QCheckBox* promptPasswordCheckBox;
  QButtonGroup* tableRetrievalGroup;
  QRadioButton* retrieveShowTableStatus;
  QRadioButton* retrieveShowTables;
  
private slots:
  void setSocketFile();

private:
  void init();
  QLabel* connectionLabel;
  QLabel* portLabel;
  QLabel* passwordLabel;
  QLabel* timeOutLabel;
  QLabel* userNameLabel;
  QLabel* hostLabel;
  QLabel* socketLabel;
  QGridLayout* tableRetrievalGroupLayout;
  QVBoxLayout* p_GeneralConnectionLayout;
  QGridLayout* Layout15;
  QGridLayout* OptionsLayout;
  bool isEditing;
};

class CConnectionDialog : public CConfigDialog
{ 
  Q_OBJECT
    
public:
  CConnectionDialog(CMyWindow *consoleWindow, QWidget* parent, const char* name, CMySQLConnection *conn, CDatabaseTreeItem *it, int serverid);
  CConnectionDialog(CMyWindow *consoleWindow, QWidget* parent,  const char* name);
  ~CConnectionDialog();  
  p_GeneralConnection * General;
  
signals:
  void connectionRenamed(CDatabaseTreeItem *, const QString &);
  void newConnection(bool);

private slots:
  void testConnection();

private:
  void initConnectionDialog(CMyWindow *consoleWindow);
  void okButtonClicked();   
  bool validate();
  bool save(CConfig *conn);

  CMyWindow *ConsoleWindow;
  CMySQLConnection *mysql;
  CDatabaseTreeItem *item;
  bool isEditing;
  int serverID;
  QString cfgname;
};

#endif // CCONNECTIONDIALOG_H
