/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CCONFIGDIALOG_H
#define CCONFIGDIALOG_H

#include <qvariant.h>
#include <qwidget.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include "CMyWindow.h"
#include "Config.h"
#include "CConfig.h"

class CConfig;
class QVBoxLayout; 
class QHBoxLayout; 
class QPushButton;
class QTabWidget;

class privateTabConfig : public QWidget
{
  Q_OBJECT
public:
  privateTabConfig(QWidget* parent = 0,  const char* name = 0, WFlags fl = 0)
    : QWidget(parent, name, fl) {} ;
  ~privateTabConfig() {};  
  friend class CConfigDialog;

protected:
  virtual bool save(CConfig *) { return false; }
  virtual QString validate() { return QString::null; }
  virtual void setDefaultValues(CConfig *) {}
};

class CConfigDialog : public CMyWindow
{ 
  Q_OBJECT
    
public:  
  CConfigDialog(QWidget* parent,  const char* name);
  ~CConfigDialog();
  void insertTab (QWidget * child, int index = -1);
  void insertTab (QWidget * child, const QIconSet & iconset, int index = -1);

protected slots:
  virtual void okButtonClicked() {};

protected:  
  void init();
  QString validate();
  void setDefaultValues(CConfig *conn);

  bool save(CConfig *conn, bool doflush=true);
  
  QTabWidget* Tab;
  QPushButton* PushButton4;
  QPushButton* customButton;
  QPushButton* okPushButton;
  QPushButton* cancelPushButton;
  QVBoxLayout* CConfigDialogLayout;
  QHBoxLayout* Layout44;
};

#endif //CCONFIGDIALOG_H