/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CADMINISTRATIONPANEL_H
#define CADMINISTRATIONPANEL_H

#include <qvariant.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qimage.h>
#include <qhbox.h>
#include <qspinbox.h>
#include <qlabel.h>
#include <qtimer.h>
#include <qtabwidget.h>
#include <qtoolbutton.h>
#include <qstyle.h>
#include <qpainter.h>
#include <qcheckbox.h>
#include <qtable.h>

#include "CMyWindow.h"
#include "CMySQLConnection.h"
#include "CMySQLQuery.h"
#include "Config.h"
#include "CSqlTable.h"
#include "CListViewProperties.h"

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QAction;
class QActionGroup;
class QToolBar;
class QPopupMenu;
class CSqlTable;
class QTabWidget;

class privateVariables : public CListViewProperties
{
  Q_OBJECT
    
public:
  privateVariables(QWidget* parent, const QString & caption, const QString & sql, CMySQLConnection *m);
  ~privateVariables() {};

public slots:
  void refresh();
  
private:  
  void insertData();
  QString m_Sql;
  QString m_Caption;
};

class privateGrid : public CSqlTable
{
  Q_OBJECT

public:
  privateGrid(QWidget * parent, CMySQLConnection *conn);
  ~privateGrid();
  void exec(const QString & qry);
  void finishEdit();
  void setServerID(int serverid) { serverID = serverid; };

public slots:
  void reset();  

private:
  int serverID;
  void processMenu(int, int, int) {};
  void ContextMenuRequested(int, int, const QPoint &) {};  
  int displayMenu(const QPoint &) { return -1; };
  void DoubleClicked ( int, int, int, const QPoint &);
  QIntDict<int> columnSizes;
  bool create;

};

class privateStatus : public CSqlTable
{
  Q_OBJECT

public:
  privateStatus(QWidget * parent, CMySQLConnection *conn);
  ~privateStatus();
  void exec();
  void reset();
  void setTraditionalMode(bool t, bool r = true);  
  bool isTraditionalMode() { return m_traditional; }  

private:
  void processMenu(int res, int, int);
  int displayMenu(const QPoint &pos);
  void DoubleClicked ( int, int, int, const QPoint &) {};
  bool m_firstTime;
  bool m_traditional;
};

class CAdministrationPanel : public CMyWindow
{ 
  Q_OBJECT
    
public:
  CAdministrationPanel(QWidget* parent, int type, CMySQLConnection *m, int serverid=-1);
  ~CAdministrationPanel();
  QSpinBox *delay;
  void enableTimer(bool e);  
  static void FlushMenu(QPopupMenu *p_flushTypeMenu);
  static bool inRange (int res);
  static void processMenu(CMyWindow *parent, int res, CMySQLConnection *m);
  static void Ping(CMyWindow *parent, CMySQLConnection *m);
  static bool Shutdown(CMyWindow *parent, CMySQLConnection *m);
  static void Flush_Hosts(CMyWindow *parent, CMySQLConnection *m);
  static void Flush_Logs(CMyWindow *parent, CMySQLConnection *m);
  static void Flush_Privileges(CMyWindow *parent, CMySQLConnection *m);
  static void Flush_Tables(CMyWindow *parent, CMySQLConnection *m);  
  static void Flush_Status(CMyWindow *parent, CMySQLConnection *m);
  
public slots:
  void s_ProcessMenu(int);
  void s_Ping();
  void s_Shutdown();
  void ExecuteQuery();
  void Toggled(bool);
  void Refresh();
  void KillProcess();
  void TabChanged(QWidget *);
  void ProcessListMenu(int row, int, const QPoint &pos);
  void RefreshProcessList();
  void doSave(int);

private slots:
  void processShowMessagesSlot();

private:  
  QHBoxLayout * processListLayout;
  QHBoxLayout * variablesLayout;
  QHBoxLayout * statusLayout;
  QTabWidget* TabWidget;
  QWidget* processList;
  QWidget* status;
  QWidget* variables;
  QPopupMenu* flushTypeMenu;
  QToolButton * flushTypeButton;
  QPopupMenu* saveTypeMenu;
  QToolButton * saveTypeButton;
  QTimer *Timer;  
  QAction * timerAction;
  QAction * flushAction;
  QAction * saveAction;
  QAction * pingAction;
  QAction * shutdownAction;
  QAction * refreshAction;
  QAction * killProcessAction;
  QAction * showMessagesAction;
  QLabel * delayLabel;
  CMySQLConnection *mysql;
  privateGrid *ProcessList;
  privateStatus *Status;
  privateVariables *Variables;
  QHBoxLayout* CAdministrationPanelLayout;
  QMenuBar *menubar;
  QPopupMenu *actionMenu;
  QPopupMenu *commandMenu;
  QToolBar *toolBar;  //refreshToolbar
  QToolBar *commandToolBar;
  QAction* actionCloseAction;
  int m_type;  
  QString m_query;
  QString cfgname;
  QString tmpFileName;
  void init();
};

#endif // CADMINISTRATIONPANEL_H

