#!/usr/bin/perl

####################################################################
#
#This software is released under the GPL.  Please
#see the included LICENSE file.
#
#Copyright (C) 2001  Michael Spiceland
#Copyright (C) 2001  Jay Kline
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#Use this script at your own risk!  I make no 
#warranties that it is hack proof!
#
#
# This script is part of Mike's Perl Script Archive at
# www.mikespice.com/perl/
#
# Edited by Jay Kline www.slushpupie.com
#
####################################################################


use CGI qw(:standard);
require "../common.pl";
require "../sitevariables.pl";

############ BEGIN MAIN PROGRAM ################################
$cur = CGI->new();
$mode = "default";
if($cur->param("mode")) {
	$mode = $cur->param("mode");
}
$day = $cur->param("day");
$month = $cur->param("month");
$year = $cur->param("year");
$help = $cur->param("help");

printstarthtml();

@pretty_months = ("","January","Febuary","March","April","May","June","July","August","September","October","November","December");
$page .= "<table width=100% border=0><tr><td width=50%><a href=\"../index.cgi?month=$month&year=$year\"><-- back to calendar</a></td>";
if ($help eq "yes") {
	$page .= "<td width=50% align=right>&nbsp;</td></tr></table>";
} else {
	$page .= "<td width=50% align=right><a href=update.cgi?day=$day&month=$month&year=$year&help=yes>Help</a></td></tr></table>";
}

if($cur->param("delete")){
	$page .= delete_appointment($day,$month,$year,$cur->param('delete'));
}

$page .= print_form();
if($cur->param("day") && $cur->param("month") && $cur->param("year") && $cur->param("info") ){
	$page .= update_day();
}
$page .= display_appointments($day,$month,$year);

if ($help eq "yes") {
	$page .= "\n\n<p><center><table bgcolor=$edittitlebg cellpadding=0 cellspacing=1 border=0><tr><td>
	<table bgcolor=$editborder cellpadding=4 width=375>
	<tr bgcolor=$edittitlebg><td><font color=$edittitlefont>Help</font></td></tr>
	<tr width=375><td width=375 bgcolor=$editbg><font color=$editfont>$edit_help";
	$page .= "</td></tr></table></center>";
}

print $page;



printendhtml();

############ BEGIN SUBROUTINES #################################

sub print_form {
	my $return;
	my ($sec,$min,$hr,$mday,$mon,$year_localtime,$wday,$yday,$isdst) = localtime(time());
	my $current_year = $year_localtime + 1900;
	my $current_month = $mon + 1;

	$return .= "
<center>
<form method=post>
<table bgcolor=$edittitlebg cellpadding=0 cellspacing=1 border=0><tr><td>
<table bgcolor=$editborder cellpadding=4 width=375>
<tr bgcolor=$edittitlebg><td><font color=$edittitlefont>add an event/appointment</font></td></tr>
<tr><td>
<select name=month>";
	for($index=1;$index < 13;$index++){
		if($month){$current_month=$month;}
		if($current_month==$index){
			$return .="<option value=$index selected>$pretty_months[$index]</option>\n";
		}else{
			$return .="<option value=$index>$pretty_months[$index]</option>\n";
		}
	}
	$return .= "
</select>, <select name=day>";
	for($index=1;$index < 32;$index++){
		if($day){$mday=$day;}
		if($index == $mday){
			$return .="<option value=$index selected>$index</option>\n";
		}else{
			$return .="<option value=$index>$index</option>\n";
		}
	}
	$return .= "
</select> &nbsp;&nbsp;&nbsp;&nbsp; <select name=year>";
	if($year){$current_year = $year;}
	for($index=$current_year-5;$index < $current_year+5;$index++){
		if($current_year==$index){
			$return .="<option value=\"$index\" selected>$index</option>\n";
		}else{
			$return .="<option value=$index>$index</option>\n";
		}
	}
	$return .= "
</select>
<br>
<input type=radio name=type value=once checked>one time on the above date<br>
<input type=radio name=type value=weekly>every week<br>
<input type=radio name=type value=biweekly>every week<br>
<input type=radio name=type value=monthly>once a month on they above day<br>
<input type=radio name=type value=yearly>once a year on the above day<br>
appointment info:<br>
<textarea name=info rows=4 cols=40></textarea><br>
<input type=submit value=add>
</td></tr>
</table>
</td></tr></table>
</form>
</center>
";
	return $return;
}

###############################################################################################
# get appointments giving a month and year and store them in the global ahs %apps ###############
###############################################################################################
sub get_appointments ($$){
	my $app_day;
	my $app;
	my %apps;
if (open(INFILE, "../$_[0]-$_[1].txt")){
		while(<INFILE>){
			chomp;
			($app_day,$app) = split(/\t/,"$_");
			$apps{"$app_day"} = "$app";
		}
		close INFILE;
	}

	return %apps;
}

# uses get_appointments to create a hash then parses through it and displays them
# needs day month, then year
sub display_appointments($$$){
	my $return;
	my $day = $_[0];
	my $month = $_[1];
	my $year = $_[2];
	my %apps = get_appointments($month,$year);
	my $appointment_text;
	my $appointments;
	my $appointment;
	my @appointments_arry;

	$appointment_text .= "<p><center><table bgcolor=$edittitlebg cellpadding=1 cellspacing=0 border=0><tr><td>
	<table bgcolor=$editborder cellpadding=4 border=0 width=375>
	<tr bgcolor=$edittitlebg><td colspan=2><font color=$edittitlefont>current events/appointments</font></td></tr>";

	$appointments = "$apps{$day}";
	@appointments_array = split(/##/,$appointments);
	foreach $appointment (@appointments_array){
	#	($appointment) = /(.{0,5})/; #get only the first 100chars
		$appointment_text .="<tr>
		<td valign=top><form method=post>
		<input type=hidden name=delete value=\"$appointment\">
		<input type=hidden name=day value=\"$day\">
		<input type=hidden name=month value=\"$month\">
		<input type=hidden name=year value=\"$year\">
		<input type=submit value=delete></form></td>
		<td valign=top>$appointment</td></tr>";
	}
	
	$appointment_text .= "<tr><td>&nbsp;</td><td>&nbsp</td></table></td></tr></table></center>";
	$return .= $appointment_text;

	return $return;
}

sub update_day{
	my $return;
	my $update_day = $cur->param("day");
	my $update_month= $cur->param("month");
	my $update_year = $cur->param("year");
	my $update_info = stripBadHtml($cur->param("info"));
	my %apps = get_appointments($update_month,$update_year);
	my $previous_apps;
	my @appointments_array;
	my $appointment_text;
	my $appointment;

	$previous_apps = $apps{"$update_day"};
	$previous_apps .= "$update_info##";
	$apps{"$update_day"} = "$previous_apps";

	if(open(OUTFILE, ">../$update_month-$update_year.txt")){
		foreach $key (sort keys %apps){
			$updatedata = $apps{"$key"};
			$updatedata =~ s/\n//g;
			print OUTFILE "$key\t$updatedata\n";	
		}
		close OUTFILE;
	}else{
		$return .= "ERROR: Could not write to the data file $update_month-$update_year.txt.  Please
		see the CGI how-to at http://www.fuzzymonkey.org/perl/ for more info on file permissions and CGI
		scripts.  Your script probably doesn't have permissions to write to this file or directory.";
	}
	
	return $return;
}

sub delete_appointment(){
	my $day = $_[0];
	my $month = $_[1];
	my $year = $_[2];
	my $appointment_to_delete = $_[3];
	my $return;
	my %apps = get_appointments($month,$year);
	my $previous_apps = $apps{"$day"};
	$previous_apps =~ s/$appointment_to_delete##//gi;
	$apps{"$day"} = "$previous_apps";
	
	if(open(OUTFILE, ">../$month-$year.txt")){
		foreach $key (sort keys %apps){
			$updatedata = $apps{"$key"};
			$updatedata =~ s/\n//g;
			print OUTFILE "$key\t$updatedata\n";	
		}
		close OUTFILE;
	}else{
		$return .= "ERROR: Could not write to the data file $update_month-$update_year.txt.  Please
		see the CGI how-to at http://www.fuzzymonkey.org/perl/ for more info on file permissions and CGI
		scripts.  Your script probably doesn't have permissions to write to this file or directory.";
	}
	
	return $return;
}




#####################################################3
#subs from slashdot to remove bad html
#####################################################
# Thanks to Slashdot for these
# Approved HTML tags for HTML posting
@approvedtags = (
        'B','I','P .*','P','A',
        'LI','OL','UL','EM','BR',
        'STRONG','BLOCKQUOTE',
        'HR','DIV .*','DIV','TT'
        );

sub stripBadHtml
{
        my ($str) = @_;

        $str =~ s/(\S{90})/$1 /g;
        $str =~ s/<(?!.*?>)//;
        $str =~ s/<(.*?)>/approvetag($1,@approvedtags)/sge; #replace
tags with approved ones
        return $str;
}

sub approvetag
{
        my ($tag,@apptag) = @_;

        $tag =~ s/^\s*?(.*)\s*?$/$1/e; #trim leading and trailing spaces

        if (uc(substr ($tag, 0, 2)) eq 'A ')
        {
                $tag =~ s/^.*?href="?(.*?)"?$/A HREF="$1"/i; #enforce "s
                return "<" . $tag . ">";
        }

        foreach my $goodtag (@apptag)
        {
                $tag = uc $tag;
                if ($tag eq $goodtag || $tag eq '/' . $goodtag)
                        {return "<" . $tag . ">";}
                #check against my list of tags
        }
        return "";
}

