#!/usr/bin/perl

####################################################################
#
#This software is released under the GPL.  Please
#see the included LICENSE file.
#
#Copyright (C) 2001  Michael Spiceland
#Copyright (C) 2001  Jay Kline
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#Use this script at your own risk!  I make no 
#warranties that it is hack proof!
#
#
# This script is part of Mike's Perl Script Archive at
# www.mikespice.com/perl/
#
# Edited by Jay Kline www.slushpupie.com
#
####################################################################


use CGI qw(:standard);
require "common.pl";
require "sitevariables.pl";
############ BEGIN MAIN PROGRAM ################################
$cur = CGI->new();
$mode = "default";
if($cur->param("mode")) {
	$mode = $cur->param("mode");
}
$help = $cur->param("help");




if($cur->param("month") && $cur->param("year")){
	$month = $cur->param("month");
	unless($month =~ /^[0-9]{1,2}$/i){
		printstarthtml();
		dienice("Possible hack detected!  Should I report your IP?");
	}
	$year = $cur->param("year");
	unless($year=~ /^[0-9]{4,4}$/i){
		printstarthtml();
		dienice("Possible hack detected!  Should I report your IP?");
	}
	($sec,$min,$hr,$mday,$mon,$year_localtime,$wday,$yday,$isdst) = localtime(time());
}else{
	($sec,$min,$hr,$mday,$mon,$year_localtime,$wday,$yday,$isdst) = localtime(time());
	$year = $year_localtime + 1900;
	$month = $mon + 1;
}

@pretty_months = ("","January","Febuary","March","April","May","June","July","August","September","October","November","December");
%apps = get_appointments($month,$year);


printstarthtml();

if($cur->param("day")){
	$day = $cur->param("day");
	unless($day =~ /^[0-9]{1,2}$/i){
		dienice("Possible hack detected!  Should I report your IP?");
	}
	print print_full_day($month,$day);
} else {
	print print_month($month,$day);
}

printendhtml();

############ BEGIN SUBROUTINES #################################

# Print the calendar
#

sub print_month($$) {
	my $return;
	my $month = $_[0];
	my $day = $_[1];


	$calendar = '';
	$calendar .= "<table width=100% border=0><tr><td width=14% align=left>";

	#create previous month button
	$month_button = $month-1;
	if($month_button == 0){
		$month_button = 12;
		$year_button = $year-1;
	}else{
		$year_button = $year;
	}

	$calendar .= "<a href=index.cgi?month=$month_button&year=$year_button> <--$pretty_months[$month_button], $year_button</a>";

	$calendar .= "</td><td align=center>";

	#create "today" button
	$month_button = $mon + 1;
	$year_button = $year_localtime + 1900;
	$calendar .= "<center><a href=index.cgi?month=$month_button&year=$year_button>Today</a></center>";

	$calendar .= "</td><td width=14% align=right>";

	#create next month button
	$month_button = $month+1;
	if($month_button == 13){
		$month_button = 1;
		$year_button = $year+1;
	}else{
		$year_button = $year;
	}
	$calendar .= "<a href=index.cgi?month=$month_button&year=$year_button>$pretty_months[$month_button], $year_button --></a>";

	$calendar .= "</td></tr></table>";

	$cal = `cal $month $year`;
	@weeks= split(/\n/,"$cal");
	shift @weeks; shift @weeks;
	$calendar .= "<table bgcolor=#FFFFFF cellspacing=1 border=0 width=100%>";
	$calendar .= "<tr bgcolor=#0D33A5>
			<td align=middle width=14%><font color=$weekdayfont><b>Sunday</b></font></td>
			<td align=middle width=14%><font color=$weekdayfont><b>Monday</b></font></td>
			<td align=middle width=14%><font color=$weekdayfont><b>Tuesday</b></font></td>
			<td align=middle width=14%><font color=$weekdayfont><b>Wednesday</b></font></td>
			<td align=middle width=14%><font color=$weekdayfont><b>Thursday</b></font></td>
			<td align=middle width=14%><font color=$weekdayfont><b>Friday</b></font></td>
			<td align=middle width=14%><font color=$weekdayfont><b>Saturday</b></font></td>
		</tr>";
	foreach $week (@weeks){
		$calendar .= "<tr height=20%>";
		@days= split " ",$week;

		# Pad @days with leading blanks if it's the first week
		if ($days[0] == 1) {
			foreach (0 .. (6 - $days[-1])) {
	        		$calendar .= "<td width=14% height=20% bgcolor=$blankday>&nbsp;</td>";
			}
		}

		foreach my $day (@days){
			$calendar .= print_day($month,$day);
		}
		unless($days[0] ==1){
			$left = 7-@days;
			until ($left == 0){
	        		$calendar .= "<td bgcolor=$blankday>&nbsp;</td>";
				$left--;
			}
		}

		$calendar .= "</tr>";
	}
	$calendar .= "<tr bgcolor=$weekdaybg>
			<td align=middle width=14%><font color=$weekdayfont><b>Sunday</b></font></td>
			<td align=middle width=14%><font color=$weekdayfont><b>Monday</b></font></td>
			<td align=middle width=14%><font color=$weekdayfont><b>Tuesday</b></font></td>
			<td align=middle width=14%><font color=$weekdayfont><b>Wednesday</b></font></td>
			<td align=middle width=14%><font color=$weekdayfont><b>Thursday</b></font></td>
			<td align=middle width=14%><font color=$weekdayfont><b>Friday</b></font></td>
			<td align=middle width=14%><font color=$weekdayfont><b>Saturday</b></font></td>
		</tr>";

	$calendar .= "</table>";

	$return .= "<table width=100% border=0><tr><td width=50 align=left>&nbsp;</td><td><center><font size=4>$title for $pretty_months[$month], $year</font></center></td>";
	if ($help eq "yes") {
		$return .= "<td width=50 align=right>&nbsp;</td></tr></table>\n";
	} else {
		$return .= "<td width=50 align=right><a href=index.cgi?month=$month&year=$year&help=yes>Help</a></td></tr></table>\n";
	}
	$return .= $calendar;
	if ($help eq "yes") {
		$return .= "<p><center><table witdth=375 border=0><tr><td bgcolor=$weekdaybg><center><font color=$weekdayfont><b>Help</b></font></center></td></tr>
			<tr width=375><td width=375 bgcolor=$daybg><font color=$dayfont>$month_help</td></tr></table></center>";
	}

	return $return;


}


# Print one day at a time
#
sub print_full_day($$) {
	my $return;
	my $month = $_[0];
	my $day = $_[1];
	my $appointment;
	my $appointment_text;
	my @appointment_array;
	if(($year == ($year_localtime+1900)) && ($mon == ($month-1)) && ($mday == $day)){
		$color = "$todaybg";
	}else{
		$color = "$daybg";
	}
	$appointments = "$apps{$day}";
	@appointments_array = split(/##/,$appointments);
	foreach $appointment (@appointments_array){
	#	($appointment) = /(.{0,5})/; #get only the first 100chars
		$appointment_text .="<tr><td bgcolor=$color><ul><font color=$dayfont>$appointment</font></ul></td></tr>\n";
	}

	$return .= "<table width=100% border=0><tr><td align=left width=14%><a href=index.cgi?month=$month&year=$year><-- Full Month</a></td>
		<td><center><font size=4>$title for $pretty_months[$month],$day $year</font></center></td>
		<td align=right width=14%><a href=protected/update.cgi?day=$day&month=$month&year=$year>Add / Delete Events</a></td></tr></table>\n
		<p><center><table border=0 cellspacing=1 width=375>
		<tr><td bgcolor=$weekdaybg><center><font color=$weekdayfont><b>Today\'s Events</b></font></center></td></tr>
		$appointment_text
		<tr><td bgcolor=$color>&nbsp;</td></tr>
		</table></center>";

	$return .= "<p><center><table witdth=375 border=0><tr><td bgcolor=$weekdaybg><center><font color=$weekdayfont><b>Help</b></font></center></td></tr>
		<tr width=375><td width=375 bgcolor=$daybg><font color=$dayfont>$full_day_help</td></tr></table></center>";

	return $return;

}

sub print_day($$) {
	my $return;
	my $month = $_[0];
	my $day = $_[1];
	my $appointment;
	my $appointment_text;
	my @appointment_array;

	
	$appointments = "$apps{$day}";
	@appointments_array = split(/##/,$appointments);
	$numapps=0;
	foreach $appointment (@appointments_array){
		$numapps++;
		if ($numapps > 3) {
			$appointment_text .= "...";
			last;
		}
		$_ = $appointment;
		$count = tr///c; #dont display more than 20 chars
		if ($count > 20) {
			$appointment = substr($appointment,0,20) . "...";
   		}
		$appointment_text .="$appointment<br>";
	}

	if(($year == ($year_localtime+1900)) && ($mon == ($month-1)) && ($mday == $day)){
		$color = "$todaybg";
	} elsif ("$appointment_text") {
		$color = "$busydaybg";
	} else {
		$color = "$daybg";
	}
	
	$return .= "<td bgcolor=$color width=14% height=100 valign=top>
		<table border=0 width=100% height=5><tr><td><font color=$dayfont><a href=index.cgi?day=$day&month=$month&year=$year>$day</a></font></td><td align=right><font size=-2><a href=\"protected/update.cgi?day=$day&month=$month&year=$year\">+/-</a></td></tr></table>
		<font color=$dayfont size=-2>
		<br>$appointment_text
		</font></td>";

	return $return;

}

###############################################################################################
# get appointments giving a month and year and store them in the global ahs %apps ###############
###############################################################################################
sub get_appointments ($$){
	my $app_day;
	my $app;
	my %apps;
	if (open(INFILE, "$_[0]-$_[1].txt")){
		while(<INFILE>){
			chomp;
			($app_day,$app) = split(/\t/,"$_");
			$apps{"$app_day"} = "$app";
		}
		close INFILE;
	}

	return %apps;
}


#####################################################
#subs from slashdot to remove bad html
#####################################################
# Thanks to Slashdot for these
# Approved HTML tags for HTML posting
@approvedtags = (
        'B','I','P .*','P','A',
        'LI','OL','UL','EM','BR',
        'STRONG','BLOCKQUOTE',
        'HR','DIV .*','DIV','TT'
        );

sub stripBadHtml
{
        my ($str) = @_;

        $str =~ s/(\S{90})/$1 /g;
        $str =~ s/<(?!.*?>)//;
        $str =~ s/<(.*?)>/approvetag($1,@approvedtags)/sge; #replace
tags with approved ones
        return $str;
}

sub approvetag
{
        my ($tag,@apptag) = @_;

        $tag =~ s/^\s*?(.*)\s*?$/$1/e; #trim leading and trailing spaces

        if (uc(substr ($tag, 0, 2)) eq 'A ')
        {
                $tag =~ s/^.*?href="?(.*?)"?$/A HREF="$1"/i; #enforce "s
                return "<" . $tag . ">";
        }

        foreach my $goodtag (@apptag)
        {
                $tag = uc $tag;
                if ($tag eq $goodtag || $tag eq '/' . $goodtag)
                        {return "<" . $tag . ">";}
                #check against my list of tags
        }
        return "";
}

