/*+*****************************************************************************
*                                                                              *
* File: xu.h                                                                   *
*                                                                              *
**-****************************************************************************/

/*
 * @(#)xu.h	1.5	02/18/99	Written by Lionel Cons
 */

#ifndef _xu_h_
#define _xu_h_

/******* Include Files ********************************************************/

#include "xmd.h"

#include <X11/Intrinsic.h>

/******* Constants ************************************************************/

/******* Macros ***************************************************************/

/******* Types ****************************************************************/

typedef struct WININFO_ {
  Window id;			/* window ID */
  char *name;			/* name given by XFetchName */
  char geom[32];		/* geometry specs */
} WININFO;

typedef struct ANSWER_ {
  char *text;			/* button text */
  XtCallbackProc callback;	/* associated callback */
  XtPointer data;		/* associated data */
} ANSWER;

/******* Variables ************************************************************/

extern WININFO xu_window_info[]; /* window information returned by xu_scan */
extern Window  xu_root_window;	 /* the root window of the display */
extern Window  xu_motif_window;	 /* the Motif window of the display */

/******* Functions ************************************************************/

char  *xu_atom_name(Atom);
void   xu_dismiss(Widget, XtPointer);
int    xu_scan(U32BITS, U32BITS);
Widget xu_ask(char *, ANSWER *, ANSWER *, ANSWER *);
Widget xu_info(char *, ANSWER *);
Widget xu_error(char *);
void   xu_text(Widget, char *);
void   xu_raise(Widget);
void   xu_setup(Widget);

#endif /* _xu_h_ */
/* DON'T ADD ANYTHING AFTER THIS LINE */
