/*+*****************************************************************************
*                                                                              *
* File: xn.c                                                                   *
*                                                                              *
* Description: names of some X constants                                       *
*                                                                              *
**-****************************************************************************/

#ifndef __lint
char xn_vers[] = "@(#)xn.c	1.7	02/02/99	Written by Lionel Cons";
#endif /* __lint */

/******* Include Files ********************************************************/

#include "xn.h"
#include "util.h"

/******* Constants ************************************************************/

/******* Macros ***************************************************************/

/******* External Stuff *******************************************************/

/******* Local Stuff **********************************************************/

static char *xn_unknown = "???"; /* what to return if the result is unknown */

/*+++***************************************************************************
*                                                                              *
* Window attributes names from X.h                                             *
*                                                                              *
**---**************************************************************************/

#define XN_MIN_WATTR 0
#define XN_MAX_WATTR 14

static char *wattr_name[] = {
  "BackPixmap",
  "BackPixel",
  "BorderPixmap",
  "BorderPixel",
  "BitGravity",
  "WinGravity",
  "BackingStore",
  "BackingPlanes",
  "BackingPixel",
  "OverrideRedirect",
  "SaveUnder",
  "EventMask",
  "DontPropagate",
  "Colormap",
  "Cursor" /* 14 */
};

char *xn_wattr_name(int n)
{
  if (n >= XN_MIN_WATTR && n <= XN_MAX_WATTR) return(wattr_name[n]);
  return(xn_unknown);
}

/*+++***************************************************************************
*                                                                              *
* Error names from X.h                                                         *
*                                                                              *
**---**************************************************************************/

#define XN_MIN_ERROR 0
#define XN_MAX_ERROR 17

static char *error_name[] = {
  "Success",
  "BadRequest",
  "BadValue",
  "BadWindow",
  "BadPixmap",
  "BadAtom",
  "BadCursor",
  "BadFont",
  "BadMatch",
  "BadDrawable",
  "BadAccess",
  "BadAlloc",
  "BadColor",
  "BadGC",
  "BadIDChoice",
  "BadName",
  "BadLength",
  "BadImplementation" /* 17 */
};

char *xn_error_name(int n)
{
  if (n >= XN_MIN_ERROR && n <= XN_MAX_ERROR) return(error_name[n]);
  return(xn_unknown);
}

/*+++***************************************************************************
*                                                                              *
* Event names from X.h                                                         *
*                                                                              *
**---**************************************************************************/

#define XN_MIN_EVENT 2
#define XN_MAX_EVENT 34

static char *event_name[] = {
  "", "",
  "KeyPress",
  "KeyRelease",
  "ButtonPress",
  "ButtonRelease",
  "MotionNotify",
  "EnterNotify",
  "LeaveNotify",
  "FocusIn",
  "FocusOut",
  "KeymapNotify",
  "Expose",
  "GraphicsExpose",
  "NoExpose",
  "VisibilityNotify",
  "CreateNotify",
  "DestroyNotify",
  "UnmapNotify",
  "MapNotify",
  "MapRequest",
  "ReparentNotify",
  "ConfigureNotify",
  "ConfigureRequest",
  "GravityNotify",
  "ResizeRequest",
  "CirculateNotify",
  "CirculateRequest",
  "PropertyNotify",
  "SelectionClear",
  "SelectionRequest",
  "SelectionNotify",
  "ColormapNotify",
  "ClientMessage",
  "MappingNotify" /* 34 */
};

char *xn_event_name(int n)
{
  if (n >= XN_MIN_EVENT && n <= XN_MAX_EVENT) return(event_name[n]);
  return(xn_unknown);
}

/*+++***************************************************************************
*                                                                              *
* Request names from Xproto.h (with a leading * if a reply is expected)        *
*                                                                              *
**---**************************************************************************/

#define XN_MIN_REQUEST 1
#define XN_MAX_REQUEST 127

static char *request_name[] = {
  "",
  "CreateWindow",
  "ChangeWindowAttributes",
  "*GetWindowAttributes",
  "DestroyWindow",
  "DestroySubwindows",
  "ChangeSaveSet",
  "ReparentWindow",
  "MapWindow",
  "MapSubwindows",
  "UnmapWindow",
  "UnmapSubwindows",
  "ConfigureWindow",
  "CirculateWindow",
  "*GetGeometry",
  "*QueryTree",
  "*InternAtom",
  "*GetAtomName",
  "ChangeProperty",
  "DeleteProperty",
  "*GetProperty",
  "*ListProperties",
  "SetSelectionOwner",
  "*GetSelectionOwner",
  "ConvertSelection",
  "SendEvent",
  "*GrabPointer",
  "UngrabPointer",
  "GrabButton",
  "UngrabButton",
  "ChangeActivePointerGrab",
  "*GrabKeyboard",
  "UngrabKeyboard",
  "GrabKey",
  "UngrabKey",
  "AllowEvents",
  "GrabServer",
  "UngrabServer",
  "*QueryPointer",
  "*GetMotionEvents",
  "*TranslateCoords",
  "WarpPointer",
  "SetInputFocus",
  "*GetInputFocus",
  "*QueryKeymap",
  "OpenFont",
  "CloseFont",
  "*QueryFont",
  "*QueryTextExtents",
  "*ListFonts",
  "*ListFontsWithInfo",
  "SetFontPath",
  "*GetFontPath",
  "CreatePixmap",
  "FreePixmap",
  "CreateGC",
  "ChangeGC",
  "CopyGC",
  "SetDashes",
  "SetClipRectangles",
  "FreeGC",
  "ClearArea",
  "CopyArea",
  "CopyPlane",
  "PolyPoint",
  "PolyLine",
  "PolySegment",
  "PolyRectangle",
  "PolyArc",
  "FillPoly",
  "PolyFillRectangle",
  "PolyFillArc",
  "PutImage",
  "*GetImage",
  "PolyText8",
  "PolyText16",
  "ImageText8",
  "ImageText16",
  "CreateColormap",
  "FreeColormap",
  "CopyColormapAndFree",
  "InstallColormap",
  "UninstallColormap",
  "*ListInstalledColormaps",
  "*AllocColor",
  "*AllocNamedColor",
  "*AllocColorCells",
  "*AllocColorPlanes",
  "FreeColors",
  "StoreColors",
  "StoreNamedColor",
  "*QueryColors",
  "*LookupColor",
  "CreateCursor",
  "CreateGlyphCursor",
  "FreeCursor",
  "RecolorCursor",
  "*QueryBestSize",
  "*QueryExtension",
  "*ListExtensions",
  "ChangeKeyboardMapping",
  "*GetKeyboardMapping",
  "ChangeKeyboardControl",
  "*GetKeyboardControl",
  "Bell",
  "ChangePointerControl",
  "*GetPointerControl",
  "SetScreenSaver",
  "*GetScreenSaver",
  "ChangeHosts",
  "*ListHosts",
  "SetAccessControl",
  "SetCloseDownMode",
  "KillClient",
  "RotateProperties",
  "ForceScreenSaver",
  "*SetPointerMapping",
  "*GetPointerMapping",
  "*SetModifierMapping",
  "*GetModifierMapping", /* 119 */
  "", "", "", "", "", "", "",
  "NoOperation" /* 127 */
};

#define XN_MIN_EXTENSION 128
#define XN_MAX_EXTENSION 255
static char *request_extension[] = {
  "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
  "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
  "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
  "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
  "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
  "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
  "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
  "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""
};

char *xn_request_name(int n)
{
  if (n >= XN_MIN_REQUEST && n <= XN_MAX_REQUEST) {
    /* empty names are invalid requests! */
    if (*(request_name[n]) == '\0') return(xn_unknown);
    else return(request_name[n]);
  }
  if (n >= XN_MIN_EXTENSION && n <= XN_MAX_EXTENSION) {
    n -= XN_MIN_EXTENSION;
    /* empty names are invalid requests! */
    if (*(request_extension[n]) == '\0') return(xn_unknown);
    else return(request_extension[n]);
  }
  return(xn_unknown);
}

void xn_record_extension(int opcode, char *name)
{
  if (opcode < XN_MIN_EXTENSION || opcode > XN_MAX_EXTENSION) return;
  opcode -= XN_MIN_EXTENSION;
  request_extension[opcode] = (char *)safe_malloc(strlen(name) + 2);
  sprintf(request_extension[opcode], "+%s", name);
}
