/*+*****************************************************************************
*                                                                              *
* File: util.h                                                                 *
*                                                                              *
**-****************************************************************************/

/*
 * @(#)util.h	1.11	02/18/99	Written by Lionel Cons
 */

#ifndef _util_h_
#define _util_h_

/******* Include Files ********************************************************/

/*
 * frequently used include files
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <errno.h>
#include <unistd.h>

/******* Constants ************************************************************/

/*
 * debugging flags
 */
#define DBG_WARNING	(1 <<  0) /* warnings */
#define DBG_ERROR	(1 <<  1) /* non-fatal error messages */
#define DBG_MISC	(1 <<  2) /* miscellaneous other things */
#define DBG_CONN	(1 <<  3) /* connections (high level) */
#define DBG_UI		(1 <<  4) /* user interface */
#define DBG_X		(1 <<  5) /* X protocol information */
#define DBG_FSA		(1 <<  6) /* connections (finite state automaton) */
#define DBG_IO		(1 <<  7) /* I/O operations (high level) */
#define DBG_IO_READ	(1 <<  8) /* dump all data read */
#define DBG_IO_WRITE	(1 <<  9) /* dump all data written */
#define DBG_STATS	(1 << 10) /* connection statistics */
#define DBG_LOG		(1 << 11) /* log major events with a timestamp */
#define DBG_MC		(1 << 12) /* memory chunk information */
#define DBG_ALERT	(1 << 13) /* alerts */
#define DBG_DISPATCH	(1 << 14) /* input dispatching */
#define DBG_CONFIG	(1 << 15) /* configuration file parsing */
#define DBG_IDENT	(1 << 16) /* IDENT lookups */
#define DBG_ALL		0xFFFFFF

/******* Macros ***************************************************************/

/*
 * memory handling
 */
#define NEW(t)		((t *)safe_malloc(sizeof(t)))
#define OLD(p)		free((void *)p)
#define str_free(s)	free((void *)s)

/*
 * bit handling
 */
#define BITSET(v,b)	(v |=  (b))
#define BITCLR(v,b)	(v &= ~(b))
#define BITCHG(v,b)	(v ^=  (b))
#define BITTST(v,b)	(v &   (b))

/*
 * SunOS 4 support for strerror and memmove
 */
#if defined(sun) && !defined(SOLARIS) && !defined(__GLIBC__)
extern char *sys_errlist[];
extern int   sys_nerr;
#define strerror(n) \
    (((n) >= 0 && (n) < sys_nerr) ? sys_errlist[n] : "unknown error")
#define memmove(dst,src,len) bcopy(src,dst,len)
#endif

/*
 * misc
 */
#define ERROR		strerror(errno)
#ifdef DEBUG
#define DEBUGGING(x)	(debug & x)
#endif

/******* Types ****************************************************************/

/******* Variables ************************************************************/

#ifdef DEBUG
extern int debug;
extern char *timetag;
#endif

/******* Functions ************************************************************/

#ifdef DEBUG
void hexdump(char *, int);
#ifdef __linux__
/* argh! some Linuxes have a dprintf() defined in <stdio.h> */
#define dprintf my_dprintf
#endif
void dprintf(char *, char *, ...);
#endif
void die(char *, ...);
void *safe_malloc(int);
char *str_ncopy(char *, int);
char *str_copy(char *);
void util_setup(char *);

#endif /* _util_h_ */
/* DON'T ADD ANYTHING AFTER THIS LINE */
