/*+*****************************************************************************
*                                                                              *
* File: ui.c                                                                   *
*                                                                              *
* Description: user interface data                                             *
*                                                                              *
**-****************************************************************************/

#ifndef __lint
char ui_vers[] = "@(#)ui.c	1.5	01/05/98	Written by Lionel Cons";
#endif /* __lint */

/******* Include Files ********************************************************/

#include "ui.h"

/******* Constants ************************************************************/

/******* Macros ***************************************************************/

/******* External Stuff *******************************************************/

/******* Local Stuff **********************************************************/

/*
 * initialise a user interface structure
 */
void ui_init(UI *uip)
{
  /* input ids */
  uip->cid.in  = NO_INPUT_ID;
  uip->cid.out = NO_INPUT_ID;
  uip->sid.in  = NO_INPUT_ID;
  uip->sid.out = NO_INPUT_ID;
  /* widgets */
  uip->alert = NULL;
  uip->info  = NULL;
  uip->menu  = NULL;
  /* submenu widgets are not used directly */
}

/*
 * discard a user interface structure
 */
void ui_close(UI *uip)
{
  /* input ids */
  if (uip->cid.in  != NO_INPUT_ID) XtRemoveInput(uip->cid.in);
  if (uip->cid.out != NO_INPUT_ID) XtRemoveInput(uip->cid.out);
  if (uip->sid.in  != NO_INPUT_ID) XtRemoveInput(uip->sid.in);
  if (uip->sid.out != NO_INPUT_ID) XtRemoveInput(uip->sid.out);
  /* widgets */
  if (uip->alert != NULL) XtDestroyWidget(uip->alert);
  if (uip->info  != NULL) XtDestroyWidget(uip->info);
  if (uip->menu  != NULL) XtDestroyWidget(uip->menu);
  /* submenu widgets will be destroyed automatically */
}
