/*+*****************************************************************************
*                                                                              *
* File: sb.c                                                                   *
*                                                                              *
* Description: static buffer for message/string building                       *
*                                                                              *
**-****************************************************************************/

#ifndef __lint
char sb_vers[] = "@(#)sb.c	1.2	02/18/99	Written by Lionel Cons";
#endif /* __lint */

/******* Include Files ********************************************************/

#include "sb.h"
#include "util.h"

#include <stdarg.h>

/******* Constants ************************************************************/

#define SB_BUFFER_LENGTH	2048    /* buffer length */

/******* Macros ***************************************************************/

/******* External Stuff *******************************************************/

char sb_line[SB_LINE_LENGTH];
char sb_buffer[SB_BUFFER_LENGTH];

/******* Local Stuff **********************************************************/

static int sb_length = 0;

/*
 * discard the contents of the buffer
 */
void sb_discard()
{
  sb_length = 0;
}

/*
 * add a string to the buffer, checking overflows
 */
void sb_add_string(char *str)
{
  int len;
  
  /* check if the buffer is already full */
  if (sb_length + 1 == SB_BUFFER_LENGTH) return;
  /* check if we indeed have something to add */
  len = strlen(str);
  if (len == 0) return;
  /* check if the new string fits in */
  if (sb_length + len < SB_BUFFER_LENGTH) {
    strcpy(&sb_buffer[sb_length], str);
    sb_length += len;
    /* strcpy() did copy the null byte */
    return;
  }
  /* handle the overflow nicely */
  len = SB_BUFFER_LENGTH - sb_length - 2;
  strncpy(&sb_buffer[sb_length], str, len);
  sb_length += len;
  /* add an "overflow" byte and a null byte */
  sb_buffer[sb_length] = '\244';
  sb_length++;
  sb_buffer[sb_length] = '\000';
}

/*
 * add multiple strings to the buffer, must be NULL terminated
 */
void sb_add_strings(char *args, ...)
{
  va_list ap;
  char *cp;

  va_start(ap, args);
  cp = args;
  while (cp) {
    sb_add_string(cp);
    cp = va_arg(ap, char *);
  }
  va_end(ap);
}
