/*+*****************************************************************************
*                                                                              *
* File: opt.h                                                                  *
*                                                                              *
**-****************************************************************************/

/*
 * @(#)opt.h	1.9	07/22/99	Written by Lionel Cons
 */

#ifndef _opt_h_
#define _opt_h_

/******* Include Files ********************************************************/

#include <X11/Intrinsic.h>

/******* Constants ************************************************************/

/******* Macros ***************************************************************/

/******* Types ****************************************************************/

/*
 * structure holding all the user selectable options
 */
typedef struct MXCONNS_OPTS_ {
  Boolean verbose;		/* should I print the display? */
  Boolean hunt;			/* should I hunt for a display? */
  Boolean fork;			/* should I fork? */
  Boolean ident;		/* should I use the IDENT protocol? */
  int     dispno;		/* which display to use */
#ifdef DEBUG
  int     debug;		/* debug flags */
  String  debug_s;		/* idem but as a string */
#endif
  int     icf;			/* initial connection flags */
  String  icf_s;		/* idem but as a string */
  String  iname;		/* icon name */
  String  config;		/* path of the configuration file to use */
  String  xsock;		/* path for the X UNIX sockets */
  int     xflags;		/* X socket flags */
  String  xflags_s;		/* idem but as a string */
} MXCONNS_OPTS;

/******* Variables ************************************************************/

extern MXCONNS_OPTS opt;

/******* Functions ************************************************************/

Widget opt_init(int, char **);

#endif /* _opt_h_ */
/* DON'T ADD ANYTHING AFTER THIS LINE */
