.\" @(#)mxconns.man	1.5	02/01/99 Written by lionel.cons@cern.ch
.TH mxconns 1

.SH NAME
mxconns \- an X11 connection monitor

.SH SYNOPSIS
.B mxconns [options]

.SH DESCRIPTION
\fBmxconns\fP is an X11 proxy, i.e., a virtual X11 server (or
"display") which can be used as a protective front end for your real
X11 server. Each time an X11 application connects to this virtual
display, \fBmxconns\fP asks you if the new connection should be
accepted. If so, \fBmxconns\fP relays the connection through to your
real X11 display.

\fBmxconns\fP can optionally inspect the X requests sent by the X
client and prompt the user when it detects dangerous ones (like spying
the keyboard). It can also silently replace these dangerous requests
by inoffensive ones (NoOp).

.SH USAGE
\fBmxconns\fP can easily be used to enhance the security of your X
server. To do so, secure your display with xhost(1) and/or xauth(1),
start \fBmxconns\fP and use only the virtual display that it created
when you start remote and/or untrusted X clients.

\fBmxconns\fP does not send anything on its standard output (stdout)
except when the \fI\-verbose\fP option is used. In this case, it prints
the virtual display that it created. All the other messages (errors,
debugging) go to stderr.

\fBmxconns\fP can be started automatically by putting in your
\fI~/.xsession\fP file something like:
.sp .1i
.nf
.RS 5
XDISPLAY=`mxconns  \-verbose  \-fork  \-hunt`
export XDISPLAY
.RE
.fi
.sp .1i
You can then use $XDISPLAY to start untrusted X clients and the error
(and debugging) messages will go to the Xsession log file...

.SH USER INTERFACE
\fBmxconns\fP displays the list of all the X11 connections being
relayed in a scrollable window.  You can close an active connection by
double-clicking on it (you'll be asked for a confirmation).
\fBWarning\fP: if you close the \fBmxconns\fP window you kill the
program but you also close all the active connections!

You can also select a connection by clicking on it and change its
flags with the help of a popup menu that is available when pressing
the right mouse button. The menu also allows you to get some
information about a connection: start time, number of X packets
relayed, names of the windows opened by this X client...

.SH CONNECTION FLAGS
Each connection has its own set of flags, telling \fBmxconns\fP what
to do.  The initial flags are set by the \fI\-icf\fP option and/or the
configuration file and can be changed by hand later using the user
interface.

The recognised flags are:
.TP 15
.I Frozen
no input/output is performed, the X client is blocked
.TP
.I Checked
all X client requests are inspected for dangerous things,
the user is prompted when potential harmful requests are found
.TP
.I Safe
all X client requests are inspected and the "safe" action
(usually replacing the request by a NoOp) is performed by default,
without bothering the user

.SH OPTIONS
\fBmxconns\fP supports the following command line options:
.TP 15
\f(BI\-config\fP \fIpath\fP
use the given configuration file
.TP
\f(BI\-debug\fP \fIstring\fP
set the debugging flags according to the given string (not yet documented)
.TP
\f(BI\-dispno\fP \fInumber\fP
specify the display number of the virtual display to be created; the default is 5
.TP
\f(BI\-fork\fP
put itself in the background
.TP
\f(BI\-hunt\fP
try all display numbers starting with the value given to \fI\-dispno\fP
until one free display is found
.TP
\f(BI\-icf\fP \fIstring\fP
set the initial connection flags according to the given string, that can contain
any combination of "f" for \fIFrozen\fP, "c" for \fIChecked\fP and "s" for \fISafe\fP
.TP
\f(BI\-ident\fP
try to use the IDENT protocol (RFC-1413) to find out which user started
the X client; this information is then displayed by \fBmxconns\fP and can
be used in the configuration file
.TP
\f(BI\-iname\fP \fIstring\fP
set the icon name accordingly
.TP
\f(BI\-verbose\fP
print the virtual display that is created; this useful with the \fI\-hunt\fP option
.TP
\f(BI\-xsock\fP
use the given path to create UNIX sockets; the path \fBmust\fP contain a "%d" that
will be replaced by the actual display number (this can be needed for instance on Solaris
where a recent patch moved the X UNIX sockets to "/var/X/.X11-unix/X%d"...)
.SH
These options (as well as some standard X options) can also be set
using X resources. For instance, you can put in your \fI~/.Xresources\fP
something like:
.sp .1i
.nf
.RS 5
Mxconns*fork:		True
Mxconns*dispno:		1
Mxconns*geometry:	+0-0
.RE
.fi

.SH CONFIGURATION FILE
\fBmxconns\fP can be given the path of a configuration file, using the
\fI\-config\fP option.

Each line of the configuration file should contain:
.sp .02i
.nf
.RS 5
\fIhost\fP [\fIaction\fP] [\fIflag\fP...]
.RE
.fi
.sp .02i
where
.TP 8
.I host
can be a name (foo.bar.org), a name regexp (*.bar.org),
an IP name (123.456.78.90), an IP regexp (123.456.*.2??),
an address/mask (123.456.0.0/255.255.0.0) or any of these with
a user name or name regexp in front (joe@foo or r??t@*.mil)
.TP
.I action
can be 'ask' (default), 'allow' or 'deny'
.TP
.I flag
can be 'none' (default), 'frozen', 'checked' or 'safe';
the flags are ORed starting with the initial connection flag specified
by the \fI\-icf\fP option;
the 'none' keyword resets the flags to 0
.SH
Empty lines and lines starting with # are ignored.

The configuration file is parsed each time a new connection is detected.
The corresponding flags are set for the connection and the corresponding
action is taken.

\fBWarning\fP: because the 'allow' action will give access to your X
server without any confirmation, \fBmxconns\fP will make sure that at
least the 'safe' flag is on.

.SH SEE ALSO
X(1), Xsecurity(1), xauth(1), xhost(1).

.SH CREDITS AND HISTORY
The original code and ideas came from "der Mouse" (mouse@collatz.mcrcim.mcgill.edu),
with his programs \fBxconns\fP and \fBxc\fP.

Vaughan Clarkson (vaughan@ewd.dsto.gov.au) modified \fBxconns\fP to use Xt and Motif
(both for the user interface and for the internal loop). The result is
\fBmxconns\fP version 1.*.

Lionel Cons (lionel.cons@cern.ch) enhanced \fBmxconns\fP for its use at CERN,
this gave \fBmxconns\fP version 2.*.

The version 3.* of \fBmxconns\fP is a complete rewrite from scratch
using ideas from the programs above as well as other similar ones like
\fBxmon\fP or \fBxroute\fP.

.SH AUTHOR
Lionel Cons <lionel.cons@cern.ch>.

.SH COPYRIGHT
This program belongs to CERN (http://www.cern.ch), see the COPYRIGHT
file included in the \fBmxconns\fP distribution for more information
(http://wwwinfo.cern.ch/dis/security/x/mxconns/COPYRIGHT).
