/*+*****************************************************************************
*                                                                              *
* File: mc.c                                                                   *
*                                                                              *
* Description: memory chunk handling                                           *
*                                                                              *
**-****************************************************************************/

#ifndef __lint
char mc_vers[] = "@(#)mc.c	1.6	03/02/99	Written by Lionel Cons";
#endif /* __lint */

/******* Include Files ********************************************************/

#include "mc.h"
#include "util.h"
#include "xmd.h"

/******* Constants ************************************************************/

/*
 * usable buffer size of a static memory chunk
 */
#ifdef LONGIS64BITS
#define MC_MIN_SIZE	68	/* minimum + 4 for alignment */
#else
#define MC_MIN_SIZE	64	/* minimum */
#endif

/******* Macros ***************************************************************/

/******* External Stuff *******************************************************/

/******* Local Stuff **********************************************************/

/*
 * static memory chunk
 */
typedef struct MCS_ {
  /* same as MC */
  struct MC_ *next;
  char *base;
  unsigned int type:1;
  unsigned int len:31;
  /* static buffer */
  char buf[MC_MIN_SIZE];	/* ready-to-use buffer */
} MCS;

/*
 * dynamic memory chunk
 */
typedef struct MCD_ {
  /* same as MC */
  struct MC_ *next;
  char *base;
  unsigned int type:1;
  unsigned int len:31;
  /* dynamic buffer */
  char pad[MC_MIN_SIZE - sizeof(char *)];
  char *buf;			/* malloc'ed buffer */
} MCD;

static MC *mc_first = NULL;	/* linked list of free memory chunks */
#ifdef DEBUG
static int mc_count = 0;	/* number of memory chunks allocated */
#endif

/*
 * give a new memory chunk of the given size
 */
MC *mc_new(int need)
{
  MC *mcp;

  /*
   * find a chunk
   */
  if (mc_first) {
    /* we have a free chunk */
    mcp = mc_first;
    mc_first = mcp->next;
  } else {
    /* we must allocate one */
    mcp = (MC *)NEW(MCS);
#ifdef DEBUG
    if (DEBUGGING(DBG_MC))
      dprintf("mc  ", "new memory chunk allocated: %d", ++mc_count);
#endif
  }

  /*
   * initialise the chunk
   */
  mcp->len = need;
  mcp->next = NULL;

  /*
   * check buffer size
   */
  if (need > MC_MIN_SIZE) {
    /* we need a dynamic memory chunk */
    MCD *mcdp = (MCD *)mcp;
    mcdp->buf = (char *)safe_malloc(need);
    mcp->type = 1;
    mcp->base = mcdp->buf;
#ifdef DEBUG
    if (DEBUGGING(DBG_MC))
      dprintf("mc  ", "dynamic memory chunk for %d bytes", need);
#endif
  } else {
    /* a static memory chunk is enough */
    MCS *mcsp = (MCS *)mcp;
    mcp->type = 0;
    mcp->base = mcsp->buf;
#ifdef DEBUG
    if (DEBUGGING(DBG_MC))
      dprintf("mc  ", "static memory chunk for %d bytes", need);
#endif
  }

  /*
   * return it
   */
  return(mcp);
}

/*
 * get rid of a memory chunk
 */
void mc_old(MC *mcp)
{

  /*
   * free the malloc'ed data if any
   */
  if (mcp->type) {
    MCD *mcdp = (MCD *)mcp;
    free(mcdp->buf);
  }

  /*
   * queue the chunk
   */
  mcp->next = mc_first;
  mc_first = mcp;
}
