/*+*****************************************************************************
*                                                                              *
* File: iconn.h                                                                *
*                                                                              *
**-****************************************************************************/

/*
 * @(#)iconn.h	1.5	01/13/98	Written by Lionel Cons
 */

#ifndef _iconn_h_
#define _iconn_h_

/******* Include Files ********************************************************/

#include "host.h"

/******* Constants ************************************************************/

/******* Macros ***************************************************************/

/******* Types ****************************************************************/

typedef struct ICONN_ {
  int fd;			/* incomming connection socket */
  HOST *host;			/* source host */
  char *name;			/* source user name */
  int local;			/* does it come from a local socket? */
  int icf;			/* initial connection flags */
  struct ICONN_ *prev;		/* previous ICONN in list */
  struct ICONN_ *next;		/* next ICONN in list */
} ICONN;

/******* Variables ************************************************************/

/******* Functions ************************************************************/

ICONN *iconn_create(int, int);
void   iconn_destroy(ICONN *);
void   iconn_refuse(ICONN *, char *);

#endif /* _iconn_h_ */
/* DON'T ADD ANYTHING AFTER THIS LINE */
