/*+*****************************************************************************
*                                                                              *
* File: err.c                                                                  *
*                                                                              *
* Description: error handling                                                  *
*                                                                              *
**-****************************************************************************/

#ifndef __lint
char err_vers[] = "@(#)err.c	1.2	02/18/99	Written by Lionel Cons";
#endif /* __lint */

/******* Include Files ********************************************************/

#include "err.h"
#include "xu.h"
#include "util.h"
#include "sb.h"

#include <stdarg.h>

/******* Constants ************************************************************/

/******* Macros ***************************************************************/

/******* External Stuff *******************************************************/

/******* Local Stuff **********************************************************/

void err_report(char *tag, ...)
{
  va_list ap;
  char *cp;

  /* build the message */
  sb_discard();
  if (tag) sb_add_strings(tag, ": ", 0);
  va_start(ap, tag);
  while ((cp = va_arg(ap, char *)) != 0)
    sb_add_string(cp);
  va_end(ap);

  /* log it if trapped */
#ifdef DEBUG
  if (DEBUGGING(DBG_ERROR)) {
    cp = (tag ? NULL : "err ");
    dprintf(cp, "%s", sb_buffer);
    return;
  }
#endif

  /* report it to the user otherwise */
  (void)xu_error(sb_buffer);
}
