/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 tstring.cpp  -  STL-like string class, for portability.
 
    begin                : Wed Aug 1 2001
    copyright            : (C) 2001 by 
    email                : maksik@gmx.co.uk
 ***************************************************************************/
 
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

//#include <iostream.h>
#include "tstring.h"
#include "string.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

// partial specializations for "traits"
template<>
char TString<char>::_null = '\0';

template<>
int TString<char>::_strlen(LPCT psz) {
	if (!psz) return 0;
	return strlen(psz);
}

template<>
int TString<char>::_strstr(LPCT stack, LPCT needle) { // returns position of the first occurence, or -1
	if (!stack || !needle) return -1;
	LPCT psz = strstr(stack, needle);
	if (!psz) return -1;
	return (psz - stack);
}

template<>
int TString<char>::_strchr(LPCT stack, char needle) {
	if (!stack) return -1;
	LPCT psz = strchr(stack, needle);
	if (!psz) return -1;
	return (psz - stack);
}

template<>
int TString<char>::_strrstr(LPCT stack, LPCT needle) {
	if (!stack || !needle) return -1;
	int nSLen = strlen(stack);
	int nNLen = strlen(needle);
	for (int pos = nSLen-nNLen; pos>=0; --pos)
		if (0==strncmp(stack+pos, needle, nNLen)) return pos;
	return -1;
}

template<>
int TString<char>::_strrchr(LPCT stack, char needle) {
	if (!stack) return -1;
	LPCT psz = strrchr(stack, needle);
	if (!psz) return -1;
	return (psz - stack);
}

template<>
int TString<char>::_strcmp(LPCT left, LPCT right) { // returns -1, 0 or 1
	if (!left)
		if (!right)
			return 0;
		else
			return -1;
	else
		if (!right)
			return 1;
	return strcmp(left, right);
}

template<>
void TString<char>::_makelower(LPT str, int n){
	for (--n; n>=0; --n)
	{
		if (str[n]>='A' && str[n]<='Z')
			str[n]+= 'a' - 'A';
	}

}

template<>
void TString<char>::_makeupper(LPT str, int n){
	for (--n; n>=0; --n)
	{
		if (str[n]>='a' && str[n]<='z')
			str[n]-= 'a' - 'A';
	}
}

template<>
int TString<char>::_vsnprintf(LPT str, int size, const char *format, va_list ap){
	return vsnprintf(str, size, format, ap);
}

