/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 preferences.cpp  -  Application preferences and associated classes.
 
 the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)                             
    begin                : Tue May 29 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "mutella.h"

#include "basicstruct.h"
#include "property.h"
#include "preferences.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

MGnuPreferences::MGnuPreferences(MController* pController) : m_ipnetsetBlackList(&m_mutex), m_setWordFilter(&m_mutex)
{
	m_pController = pController;
	
	m_pContainer = new MPropertyContainer;
	ASSERT(m_pContainer);

	// Default Settings
	// Local
	m_pContainer->AddSection("LocalHost");
	m_pContainer->AddProperty("LocalIP",         &m_ipLocalHost,      MakeIP(127,0,0,1));
	m_pContainer->AddProperty("ForceIP",         &m_ipForcedHost,     MakeIP(0,0,0,0));
	m_pContainer->AddProperty("DynDnsFirewall",  m_szDynDnsFirewall,  MAX_URL, "");
	m_pContainer->AddProperty("AcceptRemoteIpHeader", &m_bAcceptRemoteIpHeader, true);
	m_pContainer->AddProperty("LocalPort",       &m_dwLocalPort,      6346);
	m_pContainer->AddProperty("ForcePort",       &m_dwForcedPort,     0);
	m_pContainer->AddProperty("SpeedStatic",     &m_dwSpeedStat,      33);
	m_pContainer->AddProperty("SpeedDynamic",    &m_dwSpeedDyn,       33);
	m_pContainer->AddProperty("SaveStatePeriod", &m_nSaveStatePeriod, 10); // auto save state period in minutes
	// Local Firewall
	m_pContainer->AddProperty("Firewall",         &m_bBehindFirewall,   true); // this flag will be automatically reset on incoming connection
	m_pContainer->AddProperty("ReachableForPush", &m_bReachableForPush, true);

	// Connect
	m_pContainer->AddSection("Connections");
	m_pContainer->AddProperty("QuietMode",           &m_bQuietMode,   false);
	m_pContainer->AddProperty("MinConnections",      &m_nMinConnects, 4);
	m_pContainer->AddProperty("MaxConnections",      &m_nMaxConnects, 10);
	m_pContainer->AddProperty("MaxIncomingConns",    &m_nMaxIncomingConns, -1);
	m_pContainer->AddProperty("MaxConnPerSubnetA",   &m_nMaxConnPerSubnetA, -1);
	m_pContainer->AddProperty("MaxConnPerSubnetB",   &m_nMaxConnPerSubnetB, 4);
	m_pContainer->AddProperty("MaxConnPerSubnetC",   &m_nMaxConnPerSubnetC, 2);
	m_pContainer->AddProperty("LeafModeConnects",    &m_nLeafModeConnects, 8);
	m_pContainer->AddProperty("EnableUltrapeerMode", &m_bEnableSuperNodeMode, true);
	m_pContainer->AddProperty("ForceUltrapeerMode",  &m_bForceSuperNodeMode, false);
	m_pContainer->AddProperty("MaxLeaves",           &m_nMaxLeaves, 16);

	// Initial Gnu Web Caches
	m_pContainer->AddSection("GWebCaches");
	m_pContainer->AddProperty("GWebCache1", m_szGWebCache1, MAX_URL, "http://www.gnucleus.net/gcache/gcache.php");
	m_pContainer->AddProperty("GWebCache2", m_szGWebCache2, MAX_URL, "http://cache.mynapster.com/index.php");
	m_pContainer->AddProperty("GWebCache3", m_szGWebCache3, MAX_URL, "http://gwebcache.bearshare.net/gcache.php");

	// Connect Screen
	//m_pContainer->AddProperty("", &m_ScreenedNodes);
	
	// Timeouts
	m_pContainer->AddSection("Timeouts");
	m_pContainer->AddProperty("ConnectTimeout",  &m_dwConnectTimeout,  30);
	m_pContainer->AddProperty("PushTimeout",     &m_dwPushTimeout,     60);
	m_pContainer->AddProperty("SpeedTimeout",    &m_dwSpeedTimeout,    60);
	m_pContainer->AddProperty("TransferTimeout", &m_dwTransferTimeout, 60);
	
	// paths
	m_pContainer->AddSection("Paths");
	m_pContainer->AddProperty("DownloadPath", m_szDownloadPath, MAX_PATH, GetDefaultDir().c_str());
	m_pContainer->AddProperty("SharePath", m_szSharePath, MAX_PATH, ""); //TODO: make it to be a list of directories

	// Search
	m_pContainer->AddSection("SearchOptions");
	m_pContainer->AddProperty("StrictSearch",      &m_bStrictSearch,        false);
	m_pContainer->AddProperty("GroupFuzzy",        &m_bGroupbyFuzzyRules,   true);
	m_pContainer->AddProperty("ScreenBusy",        &m_bScreenBusy,          false);
	m_pContainer->AddProperty("MinFileSize",       &m_nMinFileKSize,        1024); //1M
	m_pContainer->AddProperty("MaxFileSize",       &m_nMaxFileKSize,        2097152); //2G (spam protection)
	m_pContainer->AddProperty("ResubmitTime",      &m_nResubmitSearches,    60); // resubmit all the searches in 60 secs
	m_pContainer->AddProperty("MaxSearches",       &m_nMaxSearches,         64); // performance limitations
	m_pContainer->AddProperty("MaxResults",        &m_nMaxPerSearchResults, 256);// performance limitations
	m_pContainer->AddProperty("SaveSearches",      &m_bSaveSearches,        true);// save/load searches between sessions

	// Search Screen
	m_pContainer->AddSection("SearchFilters");
	m_pContainer->AddProperty("BlackListActive",   &m_bBlackListActive,  true);
	m_pContainer->AddSet("BlackList",  &m_ipnetsetBlackList); // put spammers in there
	m_pContainer->AddProperty("WordFilterActive",  &m_bWordFilterActive, true);
	m_pContainer->AddSet("WordFilter", &m_setWordFilter);  // list bad words you dont whant to see in your results

	// Share
	m_pContainer->AddSection("ShareOptions");
	m_pContainer->AddProperty("ShareFilter",   m_szShareFilter,   MAX_PATH, "");
	m_pContainer->AddProperty("ReplyFilePath", &m_bReplyFilePath, true); // include relative path to the share names
	m_pContainer->AddProperty("MaxReplies",    &m_nMaxReplies,    64);
	m_pContainer->AddProperty("ReplyIfAvail",  &m_bSendOnlyAvail, true); // makes sense if sharing only big files
	m_pContainer->AddProperty("ShareDownloadDir", &m_bShareDownloadDir, true);
	m_pContainer->AddProperty("ShareDotFiles", &m_bShareDotFiles, false);

	// Transfer
	m_pContainer->AddSection("TransferOptions");
	m_pContainer->AddProperty("MaxDownloads",        &m_nMaxDownloads,        20);
	m_pContainer->AddProperty("MaxUploads",          &m_nMaxUploads,          10);
	m_pContainer->AddProperty("RetryDelay",          &m_nRetryWait,           10); // delay between download retries
	m_pContainer->AddProperty("MaxPerHostDownloads", &m_nMaxPerHostDownloads, 2);
	m_pContainer->AddProperty("MaxPerHostUploads",   &m_nMaxPerHostUploads,   2);
	m_pContainer->AddProperty("MaxPerFileUploads",   &m_nMaxPerFileUploads,   3); // to enable sharing both rare and popular content
	m_pContainer->AddProperty("MinDownloadSpeed",  &m_dMinDownSpeed,      -1); // drop download if it is slower than that
	m_pContainer->AddProperty("MinUploadSpeed",    &m_dMinUpSpeed,        -1); // same about uploads

	// Bandwidth
	m_pContainer->AddSection("Bandwidth");
	m_pContainer->AddProperty("BandwidthTotal",    &m_dBandwidthTotal,    -1); // not really functional
	m_pContainer->AddProperty("BandwidthTransfer", &m_dBandwidthTransfer, 10); // 10 K/sec
	m_pContainer->AddProperty("BandwidthConnects", &m_dBandwidthConnects, -1); // unlimited
	
	m_pContainer->SetCurrentSection(NULL);
}

MGnuPreferences::~MGnuPreferences()
{
	delete m_pContainer;
}

CString MGnuPreferences::GetDefaultDir()
{
	return "~/mutella";
}

