/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 defines.h  -  Useful and common definitions for Mutella

    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef __defines_h_included__
#define __defines_h_included__

#ifndef TRUE
#define TRUE  true
#endif
#ifndef FALSE
#define FALSE false
#endif

#define BOOL  bool
#define BYTE  u_char
#define UINT  u_int
#define WORD  u_short
#define DWORD u_long

typedef char * LPSTR;
typedef const char * LPCSTR;

#define LPTSTR LPSTR
#define LPCTSTR LPCSTR
#define USES_CONVERSION
#define T2A(_param) (_param)
#define A2T(_param) (_param)

typedef void* LPVOID;

#define HANDLE DWORD
typedef HANDLE* LPHANDLE;

#ifndef MIN
#define MIN(_a, _b) ( (_a) < (_b) ? (_a) : (_b) )
#endif

#ifndef MAX
#define MAX(_a, _b) ( (_a) > (_b) ? (_a) : (_b) )
#endif

// We occasionally make use of cout regardless.
#include <iostream>
using std::cout;
using std::cerr;
using std::flush;
using std::endl;

// debugging macros
#ifdef _DEBUG

#define ASSERT(cond) assert(cond)
#define VERIFY(cond) assert(cond)
#define TRACE1(message) cout << message << endl << flush
#define TRACE2(message1, message2) cout << message1 << message2 << endl << flush
#define TRACE3(message1, message2, message3) cout << message1 << message2 << message3 << endl << flush
#define TRACE4(message1, message2, message3, message4) cout << message1 << message2 << message3 << message4 << endl << flush
#define TRACE(message) TRACE1(message)

#else

#define ASSERT(cond)
#define VERIFY(cond) cond
#define TRACE1(message)
#define TRACE2(message1, message2)
#define TRACE3(message1, message2, message3)
#define TRACE4(message1, message2, message3, message4)
#define TRACE(message)

#endif //_DEBUG

#endif //__defines_h_included__
