/***************************************************************************
                          asyncdns.h  -  description
                             -------------------
    begin                : Mon Oct 7 2002
    copyright            : (C) 2002 by Max Zaitsev
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef ASYNCDNS_H
#define ASYNCDNS_H

#include "rcobject.h"

class MAsyncDns : public MRCObject {
	friend class MAsyncDnsThread;
	friend class MADnsDelayed;
public:
	MAsyncDns(const CString& sHost);
	//
	virtual void OnError() {};
	virtual void OnResolve() {};
	virtual void OnErrorDelayed() {};
	virtual void OnResolveDelayed() {};
	//
	bool IsFinished() { return m_bFinished; }
	bool IsSuccess() { return m_bSuccess; }
	CString GetHostName() { return m_sHostName; }
	long GetHostS_addr() { return m_nHostS_addr; }
	int GetLastError() { return m_errno; }
	//
	void Wait();
protected:
	bool    m_bFinished;
	bool    m_bSuccess;
	int     m_errno;
	CString m_sHostName;
	long    m_nHostS_addr;

	MWaitCondition m_wait;
	//	
	virtual ~MAsyncDns();
private:
	MAsyncDns();
	MAsyncDns(const MAsyncDns&);
};


class MADnsDelayed;
class MAsyncDnsThread : public MThread
{
public:
	MAsyncDnsThread();
	~MAsyncDnsThread();
	virtual void run();
	void AddRequest(MAsyncDns* pAD);
	//
	static void StopThread();
protected:
	MMutex m_mutex;
	MWaitCondition m_wait;
	//
	std::queue< TSmartPtr<MAsyncDns> > m_queue;
	MADnsDelayed* m_pDelayed;
	bool m_bContinue;
};

#endif
