#include <curses.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "error.h"

void * mymalloc(int size, char *what)
{
	void *dummy = malloc(size);
	if (!dummy)
		error_exit("failed to allocate %d bytes for %s\n", size, what);

	return dummy;
}

void * myrealloc(void *oldp, int newsize, char *what)
{
	void *dummy = realloc(oldp, newsize);
	if (!dummy)
		error_exit("failed to reallocate to %d bytes for %s\n", newsize, what);

	return dummy;
}

char * mystrdup(char *in)
{
	char *dummy = strdup(in);
	if (!dummy)
		error_exit("failed to copy string '%s': out of memory?\n", in);

	return dummy;
}

void mydelwin(WINDOW *win)
{
	if (ERR == delwin(win))
		error_exit("delwin() failed\n");
}

void mydoupdate(WINDOW *win)
{
	wnoutrefresh(win);
	doupdate();
}

WINDOW * mysubwin(WINDOW *orig, int nlines, int ncols, int begin_y, int begin_x)
{
	WINDOW *dummy = subwin(orig, nlines, ncols, begin_y, begin_x);
	if (!dummy)
		error_exit("failed to create window (subwindow) with dimensions %d-%d at offset %d,%d (terminal size: %d,%d)\n", ncols, nlines, begin_x, begin_y, COLS, LINES);

	return dummy;
}

int resize(void **pnt, int n, int *len, int size)
{
        if (n == *len)
        {
                *len = (*len) == 0 ? 2 : (*len) * 2;
                *pnt = myrealloc(*pnt, (*len) * size, "resize()");
        }
	else if (n > *len || n<0 || *len<0)
		error_exit("resize: fatal memory corruption problem: n > len || n<0 || len<0!\n");

	return 0;
}

ssize_t READ(int fd, char *whereto, size_t len)
{
	ssize_t cnt=0;

	while(len>0)
	{
		ssize_t rc;

		rc = read(fd, whereto, len);

		if (rc == -1)
		{
			if (errno != EINTR)
				error_exit("Problem reading from file\n");
		}
		else if (rc == 0)
		{
			break;
		}
		else
		{
			whereto += rc;
			len -= rc;
			cnt += rc;
		}
	}

	return cnt;
}

char * read_line_fd(int fd)
{
	char *str = mymalloc(80, "read_line_fd buffer");
	int n_in=0, size=80;

	for(;;)
	{
		char c;
		int rc;

		/* read one character */
		if ((rc = READ(fd, &c, 1)) != 1)
		{
			if (n_in == 0)
			{
				free(str);
				str = NULL;
			}
			return str;
		}

		/* resize input-buffer */
		resize((void **)&str, n_in, &size, sizeof(char));

		/* EOF or \n == end of line */
		if (c == 10 || c == EOF)
			break;

		/* ignore CR */
		if (c == 13)
			continue;

		/* add to string */
		str[n_in++] = c;
	}

	/* terminate string */
	resize((void **)&str, n_in, &size, sizeof(char));
	str[n_in] = 0x00;

	return str;
}
