#include "mt.h"
#include "version.h"

#include <errno.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <signal.h>

void error_exit(char *format, ...)
{
	va_list ap;

	(void)endwin();

	va_start(ap, format);
	(void)vfprintf(stderr, format, ap);
	va_end(ap);
	fprintf(stderr, "errno=%d (if applicable)\n", errno);

	(void)kill(0, SIGTERM); /* terminate every process in the process group of the current process */

	exit(EXIT_FAILURE);
}

