#!/usr/bin/perl

#========================================================
# CPU Usage script for mrtg
#
#    File: 	cpuinfo.pl
#    Author: 	Matthew Schumacher | schu@7x.com
#    Version:	1.0
#
#    Date:	10/15/1999
#    Purpose:   This script reports CPU usage for user
#		and system to mrtg, along with uptime 
#		and the machine's hostname.
#
#    Usage:	./cpuinfo.pl {machine} {os}
#
#		For now {os} can only be "sun" or "linux"		
#
#		If you would like to hard code defaults
#		then enter them below.
#
#    Info:	Designed on RedHat linux 6.0 with perl
#		version 5.004_04.  The script itself has
#		only been tested on Linux, however, it 
#		has been tested to connect to, and graph
#		CPU usage on sun (solaris 7) and linux.  
#			
#		This script requires both sar and rsh to 
#		be installed and working.  Because linux
#		does not come with sar (mine didn't) it
#		may be necessary to download and install
#		it.  Get it here: 
#
#		ftp://metalab.unc.edu/pub/Linux/system/status/sysstat-2.0.tar.gz 	
#
#    
#		How it works:
#		
#		The script uses rsh to run sar on the the
#		remote machine.  Sar samples the cpu time
#		for both user and system once per second
#		for 10 seconds.  It then reports an average
#		to the script, which parses out the information
#		and formats it in a way mrtg can understand.
#		The script also runs uptime to get the machine's
#		uptime and passes it to mrtg.
#		
#    [Note to User]
#		
#		If anyone has comments or suggestions, email me at
#		schu@7x.com and I'll try to get back to you :)
#
#   -------------------------------------------------------------
#
#    Sample cfg:
#
#  Target[machine]: `./cpuinfo.pl`
#  MaxBytes[machine]: 100
#  Options[machine]: gauge, nopercent
#  Unscaled[machine]: dwym
#  YLegend[machine]: % of CPU used
#  ShortLegend[machine]: %
#  LegendO[machine]: &nbsp;CPU System:
#  LegendI[machine]: &nbsp;CPU User:
#  Title[machine]: Machine name
#  PageTop[machine]: <H1>CPU usage for Machine name
#   </H1>
#   <TABLE>
#     <TR><TD>System:</TD><TD>Machine name</TD></TR>
#    </TABLE>
#
#  --------------------------------------------------------------  
#
#         Ok, we are now done with the notes :)
#	
#========================================================
# setup local vars
my($machine, $os);

#=======================================================
# == Enter your default machine name and os here ==

$machine = "machine";	# Enter machine to monitor here
$os = "sun";		# Currently there is only linux and sun

# == You shouldn't need to edit anything below this line ==
#========================================================

# This allows command args to override defaults listed above
if (scalar(@ARGV) > 2) 
   {
   print("USAGE: cpuinfo.pl {machine} {os}\n");
   exit(-1);
   }     

if ($ARGV[0] ne '' && $ARGV[0] ne '#')
   {
   $machine = $ARGV[0];
   }

if ($ARGV[1] ne '' && $ARGV[1] ne '#')
   {
   $os = $ARGV[1];
   }

# Validate the os
SWITCH: 
{
  if ($os =~ /^sun$/){last SWITCH;}
  if ($os =~ /^linux$/){last SWITCH;}

  # DEFAULT: Die if we can't figure out what the os is 
  die "Can't figure out which OS the machine is.\n";
}

# Execute the appropriate subroutine based on the os
&$os;

exit(0);

#=======================================================
# Subroutines: names of subroutines are supported OSs.
#========================================================
sub sun
  {

   # Run commands
   $getcpu = `rsh $machine "sar -u 1 10" | grep Average`;
   $getuptime = `rsh $machine "uptime"`;
   
   # Parse though getcpu and get data
   $getcpu =~ /^Average\s+(\d+)\s+(\d+)\s+/;
   $outputusr = $1;
   $outputsys = $2;

   # Print getcpu data for mrtg
   print $outputusr."\n";
   print $outputsys."\n";

   # Parse though getuptime and get data
   $getuptime =~ /^\s+(\d{1,2}:\d{2}..)\s+up\s+(\d+)\s+(......),/;

   # Print getuptime data for mrtg
   print $2." ".$3."\n"; 

   # Print machine name for mrtg
   print $machine."\n";

  }

sub linux
  {
   # Run commands
   $getcpu = `rsh $machine "/usr/local/bin/sar -u 1 10 | grep "Average:""`;
   $getuptime = `rsh $machine "/usr/bin/uptime"`;
   
   # Parse though getcpu and get data 
   $getcpu =~ /^Average:\s+(\d+).(\d+)%\s+(\d+).(\d+)%\s+(\d+).(\d+)%\s+(\d+).(\d+)%/;
   $getcpuusr = $1;
   $getcpusys = $5;

   # Print getcpu data for mrtg
   print $getcpuusr."\n";
   print $getcpusys."\n";

   # Parse though getuptime and get data
   $getuptime =~ /^\s+(\d{1,2}:\d{2}..)\s+up\s+(\d+)\s+(\w+),/;

   # Print getuptime data for mrtg
   print $2." ".$3."\n";
   
   # Print machine name for mrtg
   print $machine."\n";

  }
