/* 
 * $Id: gateway.c,v 1.8 1999/04/29 19:02:39 masaki Exp $
 */

#include <mrt.h>
#include <interface.h>


/*
 * convert gateway info into a ascii string
 * this should really use thread-specific data!! FIXME!
 */
char *gateway_toa (char *tmp, gateway_t *gateway) {

  if (gateway->AS > 0)
    sprintf (tmp, "%s AS%d", prefix_toa (gateway->prefix), gateway->AS);
  else
    sprintf (tmp, "%s", prefix_toa (gateway->prefix));

  return (tmp);
}


/* gateway_toa2
 * convert gateway info into a ascii string
 */
char *
gateway_toa2 (gateway_t *gateway) {

  char *stmp;
  THREAD_SPECIFIC_STRAGE (stmp);

  if (gateway->AS > 0)
    sprintf (stmp, "%s AS%d", prefix_toa (gateway->prefix), gateway->AS);
  else
    sprintf (stmp, "%s", prefix_toa (gateway->prefix));

  return (stmp);
}


/* 
 * find gateway or create a new one if it does not exit
 */
gateway_t *
add_gateway (prefix_t *prefix, int as, interface_t *interface)
{
    gateway_t *gateway;

    gateway = add_nexthop (prefix, interface);
    
    if (as > 0 && gateway->AS != as) {
	if (gateway->AS != 0)
            trace (TR_WARN, MRT->trace, "add_gateway: %g -> %d (as# change)\n",
	           gateway, gateway->AS, as);
	gateway->AS = as;
    }

    return (gateway);
}
