/* 
 * $Id: pthread_fake.h,v 1.8 1999/04/30 23:46:54 masaki Exp $
 */

/* This is a compatability include file for systems that DO NOT 
 * has kernel pthreads or which are NOT using MIT pthreads library
 * This file just defines pthread functions as null routines
 */

#ifndef _PTHREADS_FAKE_H
#define _PTHREADS_FAKE_H

/* these aren't used -- just define them as ints to keep compiler happy */
typedef	unsigned int	pthread_t;
typedef unsigned int	pthread_attr_t;
typedef unsigned int	pthread_mutex_t;
typedef unsigned int	pthread_cond_t;
typedef unsigned int	pthread_mutexattr_t;
typedef unsigned int	pthread_condattr_t;

#define pthread_self() get_thread_id()

/* define as null function -- just ignore */
#ifdef notdef
#define pthread_mutex_init(a, b)	0
#define pthread_mutex_trylock(a)	1
#define pthread_mutex_unlock(a)		0
#define pthread_mutex_lock(a)		0
#define pthread_mutex_destroy(a)	0
#define pthread_cond_signal(a)		(*(a) = 1 /* stop warning */)
#define pthread_cond_wait(a,b)		(pthread_mutex_lock (b))
#define pthread_cond_init(a,b)		(*(a) = (b))
#define pthread_cond_destroy(a)		(*(a) = 0 /* stop warning */)
#else
int pthread_mutex_init (pthread_mutex_t *mutex, 
			const pthread_mutexattr_t *attr);
int pthread_mutex_lock (pthread_mutex_t *mutex);
int pthread_mutex_trylock (pthread_mutex_t *mutex);
int pthread_mutex_unlock (pthread_mutex_t *mutex);
int pthread_mutex_destroy (pthread_mutex_t *mutex);
int pthread_cond_init (pthread_cond_t *cond, const pthread_condattr_t *attr);
int pthread_cond_wait (pthread_cond_t *cond, pthread_mutex_t *mutex);
int pthread_cond_signal (pthread_cond_t *cond);
int pthread_cond_destroy (pthread_cond_t *cond);
#endif
#define pthread_sigmask(a,b,c)		sigprocmask(a,b,c)
#define pthread_init()			0
#define pthread_attr_init(a)		(*(a) = 0)

#define PTHREAD_MUTEX_INITIALIZER	0

#endif /* _PTHREADS_FAKE_H */
