/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.h,v 1.26 2003/04/18 18:45:05 ostborn Exp $
*/
#ifndef _PROCESSOR_PLUGIN_CONFIG_H_
#define _PROCESSOR_PLUGIN_CONFIG_H_

#include <stdio.h>
#include <pcre.h>

#include "buffer.h"
#include "mlist.h"

#ifdef HAVE_LIBLOCALIZER
#include <localizer.h>
#endif

typedef struct {
	char *key;
	void *value;
	long long tstmp;
} m_cache_entry;

typedef struct {
	m_cache_entry **entry;
	long long last_tstmp;
} m_cache;

typedef struct {
	mlist	*page_type;

	mlist	*ignore_host;
	mlist	*ignore_url;
	mlist	*ignore_ua;
	mlist	*ignore_hostmask;
	mlist   *ignore_searchengine;

	mlist	*hide_url;
	mlist	*hide_referrer;
	mlist	*hide_host;
	mlist	*hide_brokenlinks;
	mlist	*hide_brokenlinks_ref;
	mlist	*hide_robots;
	mlist   *hide_extension;
	mlist	*hide_hostmask;

	mlist   *match_searchengine;

	mlist	*group_referrer;
	mlist	*group_os;
	mlist	*group_ua;
	mlist	*group_hosts;
	mlist	*group_brokenlinks;
	mlist	*group_url;
	mlist	*group_searchstrings;
	mlist	*group_robots;
	mlist   *group_extension;
	mlist   *group_searchengine;

	mlist	*searchengines;
	mlist	*splitby;
	mlist	*split_def;

	m_cache *host_cache;
	int     host_cache_max;
	int     max_hits_per_visit;

	int	visit_timeout;

	int	debug_searchengines;
	int	debug_visits;
	int     debug_timing;

	int	log_ungrouped_searchengines;
	char	*log_ungrouped_searchengines_file;
	FILE	*log_ungrouped_FILE;

	int     decode_searchstrings;
	
	buffer  *grouped;
	
	char *localizer_db;
#ifdef HAVE_LIBLOCALIZER
	localizer *localizer;
#endif
} config_processor;

int cleanup_visits(mconfig *ext_conf, mstate *state, time_t last_timestamp);
int mplugins_processor_web_insert_record(mconfig *ext_conf, mlist *state_list, mlogrec *record);

#endif
