/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: pic_pie.c,v 1.7 2002/10/23 15:05:37 le_zas Exp $
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "config.h"

#ifdef HAVE_LIBGD
#ifdef HAVE_GD_GD_H
#include <gd/gd.h>
#include <gd/gdfonts.h>
#else
#include <gd.h>
#include <gdfonts.h>
#endif
#endif

#include "mconfig.h"
#include "mlist.h"
#include "mdatatypes.h"
#include "mlocale.h"
#include "misc.h"

#include "pictures.h"
#include "generate.h"
/* calculating the box
**
** +------------------------------+
** |+----------------------------+|
** ||                            ||
** ||#                           ||
** ||##  #    (1)                ||
** ||## ##                       ||
** ||#####                       ||
** ||#####                       ||
** |+----------------------------+|
** +------------------------------+
**
*/


#define IM_CELLSPACING	  4
#define IM_CIRCLE_X	200
#define IM_CIRCLE_Y	130
#define IM_TEXT_LEN	 32
#define IM_CIRCLE_DROP_Y 10

/* gdSmallFont */
#define IM_FONT_HEIGHT	 13
#define IM_FONT_WIDTH	  6

#define IM_TEXT_BOX	IM_TEXT_LEN * IM_FONT_WIDTH

#define IM_BOX1_X1	IM_CELLSPACING * 2
#define IM_BOX1_Y1	IM_CELLSPACING * 2
#define IM_BOX1_X2	IM_BOX1_X1 + IM_CIRCLE_X + 2 * IM_CELLSPACING + IM_TEXT_BOX
#define IM_BOX1_Y2	IM_BOX1_Y1 + IM_CIRCLE_Y + 2 * IM_CELLSPACING + 2 * IM_CIRCLE_DROP_Y

#define IM_WIDTH	IM_BOX1_X2 + IM_CELLSPACING * 2
#define IM_HEIGHT	IM_BOX1_Y2 + IM_CELLSPACING * 2

#ifndef PI
#define PI 3.14159265358979323846
#endif

int create_pie(mconfig *ext_conf, mgraph *graph) {
#ifdef HAVE_LIBGD
	int i = 0;
	gdImage *im;
	FILE *f;
	rgb_tripple rgb;
	config_output *conf = ext_conf->plugin_conf;

	int col_border, col_backgnd, col_border_sh;
	int y1 = IM_BOX1_Y1 + IM_CIRCLE_DROP_Y, y1_tb = y1;
	int x1 = IM_BOX1_X1, x1_tb = x1 + IM_CIRCLE_X + 2 * IM_CELLSPACING + IM_CIRCLE_DROP_Y;
	int box1_ym = y1 + (IM_CIRCLE_Y / 2) + IM_CELLSPACING;
	int box1_xm = x1 + (IM_CIRCLE_X / 2) + IM_CELLSPACING;
	int oldx2, oldy2;

	int start = 0, end;
	double max_bahr;

	int *colors;

	colors = malloc((sizeof(int)) * graph->max_z);
	if (!colors) return -1;

	im = gdImageCreate( IM_WIDTH + 1,IM_HEIGHT + 1 );

	html3torgb3(conf->col_border, &rgb);
	col_border	= gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);

	html3torgb3(conf->col_shadow, &rgb);
	col_border_sh	= gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);

	html3torgb3(conf->col_backgnd, &rgb);
	col_backgnd	= gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);

	for (i = 0; i < graph->max_z; i++) {
		html3torgb3(graph->pairs[i]->color, &rgb);
		colors[i] = gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);
	}

	max_bahr = 0;
	for (i = 0; i < graph->max_z; i++)
		max_bahr += graph->pairs[i]->values[0];

/* background */
	gdImageFilledRectangle(im, 0, 0, IM_WIDTH-1, IM_HEIGHT-1, col_backgnd);
/* surrounding border */
	gdImageRectangle( im, 1, 1, IM_WIDTH-1, IM_HEIGHT-1, col_border );
	gdImageRectangle( im, 0, 0, IM_WIDTH, IM_HEIGHT, col_border_sh );

/* border for BOX1 */
	gdImageRectangle(im,
		IM_BOX1_X1 - IM_CELLSPACING,
		IM_BOX1_Y1 - IM_CELLSPACING,
		IM_BOX1_X2 + IM_CELLSPACING,
		IM_BOX1_Y2 + IM_CELLSPACING,
		col_border);
	gdImageRectangle(im,
		IM_BOX1_X1 - IM_CELLSPACING + 1,
		IM_BOX1_Y1 - IM_CELLSPACING + 1,
		IM_BOX1_X2 + IM_CELLSPACING + 1,
		IM_BOX1_Y2 + IM_CELLSPACING + 1,
		col_border_sh);

	gdImageLine(im, box1_xm + IM_CIRCLE_X / 2, box1_ym, box1_xm + IM_CIRCLE_X / 2, box1_ym + IM_CIRCLE_DROP_Y, col_border);
	gdImageLine(im, box1_xm - IM_CIRCLE_X / 2, box1_ym, box1_xm - IM_CIRCLE_X / 2, box1_ym + IM_CIRCLE_DROP_Y, col_border);

	oldx2 = box1_xm + IM_CIRCLE_X / 2;
	oldy2 = box1_ym;

	for (i = 0; i < graph->max_z; i++) {
		double percent, tmp;
		int x2, y2, x3, y3;
		char numstr[20];
		char str[IM_TEXT_LEN];

		percent = graph->pairs[i]->values[0] / max_bahr;
		if (percent < 1/100) continue;

		end = (360 * percent) + start;

		/* Calculate the new endpoints */
		x2 = cos(2 * PI * end / 360) * ((IM_CIRCLE_X - 2) / 2) + box1_xm;
		y2 = sin(2 * PI * end / 360) * ((IM_CIRCLE_Y - 2) / 2) + box1_ym;

		/* Calculate filling staring point */
		if (end - start > 180) tmp = 90;
		else tmp = ((end + start) / 2.0);

		x3 = cos(2 * PI * tmp / 360) * ((IM_CIRCLE_X - 2) / 2) * 0.95 + box1_xm;
		y3 = sin(2 * PI * tmp / 360) * ((IM_CIRCLE_Y - 2) / 2) * 0.95 + box1_ym;

		/* These lines create borders for gdImageFill() */
		gdImageLine(im, box1_xm, box1_ym, x2, y2, col_border);
		gdImageLine(im, box1_xm, box1_ym, oldx2, oldy2, col_border);

		if (start < 180) {
			if (end <= 180) {
				gdImageArc(im, box1_xm, box1_ym + IM_CIRCLE_DROP_Y, IM_CIRCLE_X, IM_CIRCLE_Y, start, end, col_border);
				gdImageLine(im, x2, y2, x2, y2 + IM_CIRCLE_DROP_Y, col_border);
			} else {
				gdImageArc(im, box1_xm, box1_ym + IM_CIRCLE_DROP_Y, IM_CIRCLE_X, IM_CIRCLE_Y, start, 180, col_border);
				gdImageArc(im, box1_xm, box1_ym, IM_CIRCLE_X, IM_CIRCLE_Y, 180, end, col_border);
			}
		} else {
			gdImageArc(im, box1_xm, box1_ym, IM_CIRCLE_X, IM_CIRCLE_Y, start, end, col_border);
		}

		gdImageFill(im, x3, y3, colors[i]);

		/* Following code is inefficient but is needed to fill all
		 * blanks points left by the previous gdImageFill() in some
		 * cases.
		 * If you have a better solution ... ;) */
		if (end - start < 30) {
			gdPoint points[3];

			points[0].x = box1_xm;
			points[0].y = box1_ym;
			points[1].x = x2;
			points[1].y = y2;
			points[2].x = oldx2;
			points[2].y = oldy2;
			gdImageFilledPolygon(im, points, 3, colors[i]);
		}

		gdImageArc(im, box1_xm, box1_ym, IM_CIRCLE_X, IM_CIRCLE_Y, start, end, col_border);

		/* We redraw lines :( */
		gdImageLine(im, box1_xm, box1_ym, x2, y2, col_border);
		gdImageLine(im, box1_xm, box1_ym, oldx2, oldy2, col_border);

		oldx2 = x2;
		oldy2 = y2;

		sprintf(numstr, "%%2d%%%% %%.%ds", IM_TEXT_LEN-5);
		sprintf(str, numstr, (int)(percent * 100), graph->pairs[i]->name);

		gdImageString(im, gdFontSmall, x1_tb+1, y1_tb+1, str, col_border_sh);
		gdImageString(im, gdFontSmall, x1_tb, y1_tb, str, colors[i]);

		y1_tb += IM_FONT_HEIGHT + 2;

		start = end;

		if (y1_tb >= IM_BOX1_Y2) break;
	}

	/* Close the ellipse */
	gdImageArc(im, box1_xm, box1_ym, IM_CIRCLE_X, IM_CIRCLE_Y, start, 360, col_border);

	if ((f = fopen (graph->filename, "wb"))) {
		gdImagePng(im, f);

		fclose(f);
	}

	gdImageDestroy(im);

	graph->width = IM_WIDTH + 1;
	graph->height = IM_HEIGHT + 1;

	free(colors);
	return 0;
#else
	return -1;
#endif
}

