/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: pic_lines.c,v 1.4 2002/10/23 15:05:37 le_zas Exp $
*/
#include <stdio.h>
#include <stdlib.h>

#include <math.h>

#include "config.h"

#ifdef HAVE_LIBGD
#ifdef HAVE_GD_GD_H
#include <gd/gd.h>
#include <gd/gdfonts.h>
#else
#include <gd.h>
#include <gdfonts.h>
#endif
#endif

#include "mconfig.h"
#include "mlist.h"
#include "mdatatypes.h"
#include "mlocale.h"
#include "misc.h"

#include "pictures.h"
#include "generate.h"
/* calculating the box
**
** +------------------------------+
** |+----------------------------+|
** ||                            ||
** ||#                           ||
** ||##  #    (1)                ||
** ||## ##                       ||
** ||#####                       ||
** ||#####                       ||
** |+----------------------------+|
** +------------------------------+
**
*/

/* #define IM_WIDTH	320 */
#define IM_HEIGHT	200
#define IM_CELLSPACING	  4

/* gdSmallFont */
#define IM_FONT_HEIGHT	 13
#define IM_FONT_WIDTH	  6

#define IM_LAB1_Y1	(IM_HEIGHT - IM_FONT_HEIGHT - IM_CELLSPACING)

#define IM_BOX1_BAR_WIDTH	  2
#define IM_BOX1_BAR_SHIFT	  2
#define IM_BOX1_BAR_SPACE	  5

#define IM_BOX1_X1	(IM_CELLSPACING * 2 + IM_FONT_HEIGHT)
#define IM_BOX1_Y1	(IM_CELLSPACING * 2 + IM_FONT_HEIGHT)
#define IM_BOX1_Y2	(IM_LAB1_Y1 - 2 * IM_CELLSPACING - 1)

int create_lines(mconfig *ext_conf, mgraph *graph) {
#ifdef HAVE_LIBGD
	int i, j;
	gdImage *im;
	FILE *f;
	rgb_tripple rgb;
	int x1, y1, y2;
	config_output *conf = ext_conf->plugin_conf;
	char int2str[32];

	double max_bahr = 0; /* :) */
	int *colors;

	int col_border, col_backgnd, col_border_sh, col_foregnd;
	int im_box1_x2, im_width;

	/* calc the max of each line */

	colors = malloc((sizeof(int)) * graph->max_z);

	for (i = 0; i < graph->max_z; i++)
		for (j = 0; j < graph->max_x; j++)
			if (graph->pairs[i]->values[j] > max_bahr)
				max_bahr = graph->pairs[i]->values[j];

	im_box1_x2 = IM_BOX1_X1 + graph->max_x * (IM_BOX1_BAR_WIDTH + IM_BOX1_BAR_SPACE);

	im_width = im_box1_x2 + ( IM_CELLSPACING * 2 + IM_FONT_HEIGHT );

	im = gdImageCreate( im_width + 1,IM_HEIGHT + 1 );


	html3torgb3(conf->col_border, &rgb);
	col_border	= gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);

	html3torgb3(conf->col_shadow, &rgb);
	col_border_sh	= gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);

	html3torgb3(conf->col_backgnd, &rgb);
	col_backgnd	= gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);

	html3torgb3(conf->col_foregnd, &rgb);
	col_foregnd	= gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);

	for (i = 0; i < graph->max_z; i++) {
		html3torgb3(graph->pairs[i]->color, &rgb);
		colors[i] = gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);
	}

/* background */
	gdImageFilledRectangle(im, 0, 0, im_width-1, IM_HEIGHT-1, col_backgnd);
/* surrounding border */
	gdImageRectangle( im, 1, 1, im_width-1, IM_HEIGHT-1, col_border );
	gdImageRectangle( im, 0, 0, im_width, IM_HEIGHT, col_border_sh );

/* upward strings - max hits */
	sprintf(int2str, "%.0f", max_bahr);
	x1 = IM_CELLSPACING;
	y1 = IM_BOX1_Y1 + strlen(int2str) * IM_FONT_WIDTH;
	gdImageStringUp(im, gdFontSmall, x1, y1, int2str, col_foregnd);

/* upward strings - 'pages/files/hits' */
	x1 = im_width - IM_CELLSPACING - IM_FONT_HEIGHT;
	y1 = IM_BOX1_Y1;

	for (i = 0; i < graph->max_z; i++) {
		if (i > 0) {
			y1 += IM_FONT_WIDTH;
			gdImageStringUp(im, gdFontSmall, x1+1, y1+1, "/", col_border_sh);
			gdImageStringUp(im, gdFontSmall, x1, y1, "/", col_foregnd);
		}

		y1 += strlen(graph->pairs[i]->name) * IM_FONT_WIDTH;
		gdImageStringUp(im, gdFontSmall, x1+1, y1+1, graph->pairs[i]->name, col_border_sh);
		gdImageStringUp(im, gdFontSmall, x1, y1, graph->pairs[i]->name, colors[i]);
	}

/* header */
	x1 = IM_BOX1_X1;
	y1 = IM_CELLSPACING;
	gdImageString(im, gdFontSmall, x1, y1, graph->name, col_foregnd);

	/* border for BOX1 */
	gdImageRectangle(im,
			 IM_BOX1_X1 - IM_CELLSPACING,
			 IM_BOX1_Y1 - IM_CELLSPACING,
			 im_box1_x2 + IM_CELLSPACING,
			 IM_BOX1_Y2 + IM_CELLSPACING,
			 col_border);
	gdImageRectangle(im,
			 IM_BOX1_X1 - IM_CELLSPACING + 1,
			 IM_BOX1_Y1 - IM_CELLSPACING + 1,
			 im_box1_x2 + IM_CELLSPACING + 1,
			 IM_BOX1_Y2 + IM_CELLSPACING + 1,
			 col_border_sh);

	/* set marks */
	if (max_bahr) {
		int high = max_bahr;
		int pot = 1;
		double scale = 0, scale_plus;

		while (high >= 10) {
			high /= 10;
			pot *= 10;
		}

		if (high <= 2) scale_plus = 0.5;
		else if (high <= 5) scale_plus = 1;
		else scale_plus = 2;

		while (scale * pot < max_bahr) {
			y1 = IM_BOX1_Y2 - ((scale * pot) / max_bahr) * (IM_BOX1_Y2 - IM_BOX1_Y1 - 1);

			gdImageLine(im,
				    IM_BOX1_X1 - IM_CELLSPACING,
				    y1,
				    im_box1_x2 + IM_CELLSPACING,
				    y1,
				    col_border
				    );
			scale += scale_plus;
		}
	}

	for ( i = 0; i < graph->max_x; i++) {
		/* Box 1 */
		if (max_bahr) {
			int y2b = IM_BOX1_Y2;
			int y1b = IM_BOX1_Y1;

			x1 = IM_BOX1_X1 + i * (IM_BOX1_BAR_SPACE + IM_BOX1_BAR_WIDTH);

			y2 = y2b;

			for ( j = 0; j < graph->max_z; j++) {
				y1 = y2 - (graph->pairs[j]->values[i] / max_bahr) * (y2b - y1b - 1);

				if (y1 != y2) {
					gdImageFilledRectangle(im, x1, y1, x1 + IM_BOX1_BAR_WIDTH, y2, colors[j]);
				}

				x1 += IM_BOX1_BAR_SHIFT;
			}

		}

		x1 = IM_BOX1_X1 + i * (IM_BOX1_BAR_SPACE + IM_BOX1_BAR_WIDTH);
		y1 = IM_BOX1_Y2 + IM_CELLSPACING;

		gdImageLine(im, x1, y1-2, x1, y1+2, col_border);

		y1 = IM_LAB1_Y1;

		gdImageString(im, gdFontSmall, x1, y1, graph->pair_names[i], col_foregnd);
	}

	if ((f = fopen (graph->filename, "wb"))) {
		gdImagePng(im, f);

		fclose(f);
	}

	gdImageDestroy(im);

	graph->width = im_width+1;
	graph->height = IM_HEIGHT+1;

	free(colors);
	return 0;
#else
	return -1;
#endif
}

