/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: pictures_vd.c,v 1.16 2003/01/06 11:14:17 ostborn Exp $
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "config.h"

#ifdef HAVE_LIBGD
#ifdef HAVE_GD_GD_H
#include <gd/gd.h>
#include <gd/gdfonts.h>
#else
#include <gd.h>
#include <gdfonts.h>
#endif
#endif

#include "mconfig.h"
#include "mlist.h"
#include "mdatatypes.h"
#include "mlocale.h"
#include "misc.h"

#include "pictures.h"
#include "generate.h"

#define IM_FILENAME "visit_duration_"
#define IM_FILEEXT  ".png"

#define GRAPH_CUTOFF 0.95
#define GRAPH_CUTOFF_TEXT "95%"

char *mplugin_modlogan_create_pic_vd(mconfig *ext_conf, mstate *state) {
#ifdef HAVE_LIBGD
	char filename[255];
	config_output *conf = ext_conf->plugin_conf;
	mstate_web *staweb = state->ext;
	mhash *h = NULL;
	mlist *l = NULL;
	int i, max, ndx, max_names;
	unsigned long visitpl_sum = 0;
	unsigned long visitpl_cur = 0;
	mdata **md;

	static char href[255] = "";

	mgraph * graph = malloc(sizeof(mgraph));
	memset(graph, 0, sizeof(mgraph));

	graph->name = malloc(strlen(_("Visit Duration for")) + 1 + 
			     strlen(get_month_string(state->month,0)) + 1 
			     + 4 + 1 + strlen(_("(bottom ")) + 
			     strlen(GRAPH_CUTOFF_TEXT) + strlen(_(", in min)")) + 1);
	
	sprintf(graph->name, "%s %s %04d %s%s%s",
		_("Visit Duration for"),
		get_month_string(state->month,0),
		state->year,
		_("(bottom "),
		GRAPH_CUTOFF_TEXT,
		_(", in min)")
		);

	h = get_visit_duration(staweb->visits);

	max = 0;

	for (i = 0; i < h->size; i++) {
		for( l = h->data[i]->list; l && l->data; l = l->next) {
			mdata *data = l->data;
			
			if (strtol(data->key, NULL, 10) > max)
				max = strtol(data->key, NULL, 10);
		}
	}

	/* minimum width */
	if (max<45) max=45;

	/* maximum width */
	if (max>90) max=90;

	graph->max_x = max + 1;
	graph->max_z = 1;
	graph->filename = NULL;
	graph->height = 0;
	graph->width  = 0;

	graph->pairs = malloc(sizeof(mgraph_array *) * graph->max_z);
	for (i = 0; i < graph->max_z; i++) {
		graph->pairs[i] = malloc(sizeof(mgraph_array));
		graph->pairs[i]->values = malloc(sizeof(double) * graph->max_x);
		memset(graph->pairs[i]->values, 0, sizeof(double) * graph->max_x);
	}

	graph->pair_names = malloc(sizeof(mgraph_array *) * graph->max_x);

	md = mhash_sorted_to_marray(h, M_SORTBY_KEY, M_SORTDIR_ASC);
	ndx = 0;
	for (i = 0; i < graph->max_x; i++) {
		mdata *data = md[ndx];
		
		if (data && strtol(data->key, NULL, 10) == i) {
			graph->pairs[0]->values[i] = mdata_get_count(data);
			visitpl_sum += graph->pairs[0]->values[i];
			ndx++;
		} else {
			graph->pairs[0]->values[i] = 0;
		}

		/* only print 10, 20, 30, ... */
		if ((i == 0) || (i % 10)) {
			graph->pair_names[i] = malloc(1);
			*(graph->pair_names[i]) = '\0';
		} else {
			graph->pair_names[i] = malloc(log10(i) + 2);
			sprintf(graph->pair_names[i], "%d", i);
		}
	}
	free(md);
	
	max_names = graph->max_x;

	/* Now honor the cutoff ratio... */
	visitpl_sum = ceil(visitpl_sum * GRAPH_CUTOFF);
	for (i = 0; i < graph->max_x-1; i++) { /* this -1 is intentional */
		visitpl_cur += graph->pairs[0]->values[i];
		if (visitpl_cur > visitpl_sum) break;
	}
	/* minimum width */
	if (i<45) i=45;

	/* maximum width */
	if (i>90) i=90;

	graph->max_x = i+1;

	mhash_free(h);

	graph->pairs[0]->name = _("Count");
	graph->pairs[0]->color = conf->col_hits;

	sprintf(filename, "%s/%s%04d%02d%s",
		conf->outputdir,
		IM_FILENAME,
		state->year, state->month,
		IM_FILEEXT);

	graph->filename = filename;

	mplugin_modlogan_create_lines(ext_conf, graph);

	sprintf(href, "<center><img src=\"%s%04i%02i%s\" alt=\"%s\" width=\"%d\" height=\"%d\"></center>\n",
		IM_FILENAME,
		state->year, state->month,
		IM_FILEEXT,
		_("Visit Duration"), graph->width, graph->height);

	for (i = 0; i < graph->max_z; i++) {
		free(graph->pairs[i]->values);
		free(graph->pairs[i]);
	}

	for (i = 0; i < max_names; i++) {
		free(graph->pair_names[i]);
	}

	free(graph->pair_names);
	free(graph->pairs);
	free(graph->name);
	free(graph);

	return href;
#else
	return NULL;
#endif
}


