/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.c,v 1.6 2003/04/18 18:40:41 ostborn Exp $
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>

#include "mlocale.h"
#include "mplugins.h"
#include "mrecord.h"
#include "mdatatypes.h"
#include "misc.h"

#include "plugin_config.h"

/* init the plugin */

int mplugins_input_postfix_dlinit(mconfig *ext_conf) {
	config_input *conf = NULL;
	const char *errptr;
	int erroffset = 0;
	int i;

/* get the neccesary space */
	conf = malloc(sizeof(config_input));
	memset(conf, 0, sizeof(config_input));

/* set some defaults */
	conf->inputfilename = NULL;

	conf->buf = buffer_init();

	conf->from_count = 0;
	for ( i = 0; i < M_FROM_ARRAY_SIZE; i++ )
	{
		conf->from_list[ i ].id       = NULL;
		conf->from_list[ i ].sender   = NULL;
		conf->from_list[ i ].bytes_in = 0;
		conf->from_list[ i ].nrcpts   = 0;
	}

/* compile the match */
	if ((conf->match_syslog_postfix = pcre_compile(
		"^([a-zA-Z]{3} [0-9 ]{2} [:0-9]{8}) .+? postfix/(.+?)\\[[0-9]+\\]:",
		0, &errptr, &erroffset, NULL)) == NULL)
	{
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	if ((conf->match_syslog_amavis = pcre_compile(
		"^([a-zA-Z]{3} [0-9 ]{2} [:0-9]{8}) .+? amavis",
		0, &errptr, &erroffset, NULL)) == NULL)
	{
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	if ((conf->match_postfix_from = pcre_compile(
		": (.+?): from=(.+?), size=([0-9]+), nrcpt=([0-9]+)",
		0, &errptr, &erroffset, NULL)) == NULL)
	{
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	if ((conf->match_postfix_to = pcre_compile(
		": (.+?): to=(.+?), relay=(.+?), delay=([0-9]+), status=(deferred|sent) (.+?)",
		0, &errptr, &erroffset, NULL)) == NULL)
	{
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	if ((conf->match_postfix_cleanup = pcre_compile(
		"postfix/cleanup\\[([0-9]+)\\]: ",
		0, &errptr, &erroffset, NULL)) == NULL)
	{
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	if ((conf->match_postfix_smtpd = pcre_compile(
		"postfix/smtpd\\[([0-9]+)\\]: ",
		0, &errptr, &erroffset, NULL)) == NULL)
	{
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	if ((conf->match_postfix_smtp = pcre_compile(
		"postfix/smtp\\[([0-9]+)\\]: ",
		0, &errptr, &erroffset, NULL)) == NULL)
	{
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	if ((conf->match_postfix_pickup = pcre_compile(
		"postfix/pickup\\[([0-9]+)\\]: ",
		0, &errptr, &erroffset, NULL)) == NULL)
	{
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	if ((conf->match_postfix_time_stamp = pcre_compile(
		"^(([a-zA-Z]{3}) ([0-9 ]{2}) ([0-9]{2}):([0-9]{2}):([0-9]{2}))",
		0, &errptr, &erroffset, NULL)) == NULL)
	{
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	if ((conf->match_postfix_pipe = pcre_compile(
		"^([a-zA-Z]{3} [0-9 ]{2} [:0-9]{8}) .+? postfix/pipe\\[[0-9]+\\]:",
		0, &errptr, &erroffset, NULL)) == NULL)
	{
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	if ((conf->match_postfix_reload = pcre_compile(
		"^([a-zA-Z]{3} [0-9 ]{2} [:0-9]{8}) .+? postfix/(.+?)\\[[0-9]+\\]: reload configuration",
		0, &errptr, &erroffset, NULL)) == NULL)
	{
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	if ((conf->match_postfix_warning = pcre_compile(
		"^([a-zA-Z]{3} [0-9 ]{2} [:0-9]{8}) .+? postfix/(.+?)\\[[0-9]+\\]: warning:",
		0, &errptr, &erroffset, NULL)) == NULL)
	{
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	if ((conf->match_postfix_daemon = pcre_compile(
		"^([a-zA-Z]{3} [0-9 ]{2} [:0-9]{8}) .+? postfix/(.+?)\\[[0-9]+\\]: daemon",
		0, &errptr, &erroffset, NULL)) == NULL)
	{
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	if ((conf->match_postfix_terminating = pcre_compile(
		"^([a-zA-Z]{3} [0-9 ]{2} [:0-9]{8}) .+? postfix/(.+?)\\[[0-9]+\\]: terminating",
		0, &errptr, &erroffset, NULL)) == NULL)
	{
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	if ((conf->match_postfix_dict_eval_action = pcre_compile(
		"^([a-zA-Z]{3} [0-9 ]{2} [:0-9]{8}) .+? postfix/(.+?)\\[[0-9]+\\]: dict_eval_action",
		0, &errptr, &erroffset, NULL)) == NULL)
	{
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	if ((conf->match_postfix_dir_forest = pcre_compile(
		"^([a-zA-Z]{3} [0-9 ]{2} [:0-9]{8}) .+? postfix/(.+?)\\[[0-9]+\\]: dir_forest",
		0, &errptr, &erroffset, NULL)) == NULL)
	{
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	if ((conf->match_postfix_queue = pcre_compile(
		"^([a-zA-Z]{3} [0-9 ]{2} [:0-9]{8}) .+? postfix/(.+?)\\[[0-9]+\\]: queue",
		0, &errptr, &erroffset, NULL)) == NULL)
	{
		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	conf->match_syslog_extra_postfix = pcre_study(conf->match_syslog_postfix, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	conf->match_syslog_extra_amavis = pcre_study(conf->match_syslog_amavis, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	conf->match_postfix_extra_from = pcre_study(conf->match_postfix_from, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	conf->match_postfix_extra_to = pcre_study(conf->match_postfix_to, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	conf->match_postfix_extra_cleanup = pcre_study(conf->match_postfix_cleanup, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	conf->match_postfix_extra_smtpd = pcre_study(conf->match_postfix_smtpd, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	conf->match_postfix_extra_smtp = pcre_study(conf->match_postfix_smtp, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	conf->match_postfix_extra_pickup = pcre_study(conf->match_postfix_pickup, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	conf->match_postfix_extra_time_stamp = pcre_study(conf->match_postfix_time_stamp, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	conf->match_postfix_extra_pipe = pcre_study(conf->match_postfix_time_stamp, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	conf->match_postfix_extra_reload = pcre_study(conf->match_postfix_time_stamp, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	conf->match_postfix_extra_warning = pcre_study(conf->match_postfix_time_stamp, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	conf->match_postfix_extra_daemon = pcre_study(conf->match_postfix_time_stamp, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	conf->match_postfix_extra_terminating = pcre_study(conf->match_postfix_time_stamp, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	conf->match_postfix_extra_dict_eval_action = pcre_study(conf->match_postfix_time_stamp, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	conf->match_postfix_extra_dir_forest = pcre_study(conf->match_postfix_time_stamp, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	conf->match_postfix_extra_queue = pcre_study(conf->match_postfix_time_stamp, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

/* connect the plugin config to the master config */
	ext_conf->plugin_conf = conf;

	return 0;
}

/* destructor */

int mplugins_input_postfix_dlclose(mconfig *ext_conf) {
	config_input *conf = ext_conf->plugin_conf;

/* clean up everything you have opened, reserved */
	mclose(&(conf->inputfile));

	buffer_free(conf->buf);

	free(ext_conf->plugin_conf);
	ext_conf->plugin_conf = NULL;

	return 0;
}

int mplugins_input_postfix_parse_config(mconfig *ext_conf, const char *filename, const char *section) {
	config_input *conf = ext_conf->plugin_conf;

/* add your config options here. the format of the struct:
 * {"<name of the option>", <type>, <how to handle the further
 * occurences of the same value>, <address of the pointer where
 * the value should go to> }
 *
 * you only have the change config_values[] the rest is done in the
 * background (-> ./src/mconfig.c)
 */
	const mconfig_values config_values[] = {
		{"inputfile",	M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->inputfilename)},

/* terminate the array of options */
		{NULL, M_CONFIG_TYPE_INT, 0, NULL}
	};

	return mconfig_parse_section(ext_conf, filename, section, config_values);
}


int mplugins_input_postfix_set_defaults(mconfig *ext_conf) {
	config_input *conf = ext_conf->plugin_conf;

	if (conf->inputfilename && strcmp(conf->inputfilename, "-") != 0) {
		if (mopen(&(conf->inputfile), conf->inputfilename)) {
			M_DEBUG2(ext_conf->debug_level, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
				 "%s: %s\n", conf->inputfilename, strerror(errno));
			return -1;
		}
		M_DEBUG1(ext_conf->debug_level, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_VERBOSE,
			 "(clf) using %s as inputfile\n", conf->inputfilename);
	} else {
		/* stdin */
		if (mopen(&(conf->inputfile), NULL)) {
			M_DEBUG2(ext_conf->debug_level, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
				 "%s: %s\n", conf->inputfilename, strerror(errno));
			return -1;
		}
		
		M_DEBUG0(ext_conf->debug_level, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_VERBOSE,
			 "(clf) using (stdin) as inputfile\n");
	}

	return 0;
}


int mplugins_init(mplugin *func) {
	func->dlinit = mplugins_input_postfix_dlinit;
	func->dlclose = mplugins_input_postfix_dlclose;
	func->parse_config = mplugins_input_postfix_parse_config;
	func->set_defaults = mplugins_input_postfix_set_defaults;
	func->get_next_record = mplugins_input_postfix_get_next_record;
	func->insert_record = NULL;
	func->gen_report = NULL;
        func->gen_history = NULL;

	return 0;
}
