/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: datatype.c,v 1.13 2003/01/06 11:11:43 ostborn Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "config.h"
#include "mdatatypes.h"
#include "datatype.h"

/* begin of Traffic */

int mdata_Traffic_to_xml(gzFile *fd, mdata *data) {
	return 0;
}

int mdata_Traffic_free(mdata *data) {
	if (!data) return -1;
	if (data->type != M_DATA_TYPE_TRAFFIC) return -1;

	if (data->data.traffic->src) free(data->data.traffic->src);
	if (data->data.traffic->dst) free(data->data.traffic->dst);
	
	free(data->data.traffic);

	return 0;
}

int mdata_Traffic_setdata(mdata *data, const char *str,
			  const char *src,
			  const char *dst,
			  unsigned long long xfer_in,
			  unsigned long long xfer_out,
			  int src_port,
			  int dst_port,
			  int src_as,
			  int dst_as,
			  int src_interface,
			  int dst_interface
			  ) {

	data->key = strdup(str);
	assert(data->key);

	data->data.traffic->src = strdup(src);
	assert(data->data.traffic->src);

	data->data.traffic->dst	= strdup(dst);
	assert(data->data.traffic->dst);

	data->data.traffic->xfer_in	= xfer_in;
	data->data.traffic->xfer_out	= xfer_out;

	/* HACK */
	data->data.traffic->src_port	= src_port;
	data->data.traffic->dst_port	= dst_port;

	data->data.traffic->src_as	= src_as;
	data->data.traffic->dst_as	= dst_as;

	data->data.traffic->src_interface= src_interface;
	data->data.traffic->dst_interface= dst_interface;
	return 0;
}
int mdata_Traffic_from_xml(mstate_stack *m, int tagtype, mdata *data, int type, const xmlChar *value, const xmlChar **attrs) {
	return 0;
}



int mdata_Traffic_append(mdata *dst, mdata *src) {
	dst->data.traffic->xfer_in += src->data.traffic->xfer_in;
	dst->data.traffic->xfer_out += src->data.traffic->xfer_out;

	return M_DATA_APPENDED;
}

mdata *mdata_Traffic_init() {
	mdata *data = mdata_init();
	assert(data);

	data->key		= NULL;
	data->type		= M_DATA_TYPE_TRAFFIC;
	
	data->data.traffic      = malloc(sizeof(data_Traffic));
	memset(data->data.traffic, 0, sizeof(data_Traffic));

#ifdef DEBUG_DATATYPES
	fprintf(stderr, "%s.%d: got %ld (%d)\n", __FILE__, __LINE__, data->id, data->type);
#endif
/* init specifics */

	data->data.traffic->src  = NULL;
	data->data.traffic->dst  = NULL;
	data->data.traffic->xfer_in = 0;
	data->data.traffic->xfer_out = 0;
	data->data.traffic->src_as  = 0;
	data->data.traffic->dst_as  = 0;
	data->data.traffic->src_port  = 0;
	data->data.traffic->dst_port  = 0;
	data->data.traffic->src_interface  = 0;
	data->data.traffic->dst_interface  = 0;

	return data;
}

mdata *mdata_Traffic_copy(mdata *src) {
	mdata *data = mdata_Traffic_init();
	assert(data);

	mdata_Traffic_setdata(data, src->key,
			      src->data.traffic->src,
			      src->data.traffic->dst,
			      src->data.traffic->xfer_in,
			      src->data.traffic->xfer_out,
			      src->data.traffic->src_port,
			      src->data.traffic->dst_port,
			      src->data.traffic->src_as,
			      src->data.traffic->dst_as,
			      src->data.traffic->src_interface,
			      src->data.traffic->dst_interface

			      );

	return data;
}

mdata  *mdata_Traffic_create(
			     const char *src,
			     const char *dst,
			     unsigned long long xfer_in,
			     unsigned long long xfer_out,
			     int src_port,
			     int dst_port,
			     int src_as,
			     int dst_as,
			     int src_interface,
			     int dst_interface
	) {

	char *s = NULL;

	mdata *data = mdata_Traffic_init();
	assert(data);

	s = malloc(strlen(src) + strlen(dst) + 2);
	sprintf(s, "%s|%s", src, dst);

	mdata_Traffic_setdata(data, s,
			      src, dst,
			      xfer_in, xfer_out,
			      src_port, dst_port,
			      src_as, dst_as,
			      src_interface, dst_interface);

	free(s);

	return data;
}

/* end of Traffic */
