/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: datatype.c,v 1.12 2003/02/24 17:18:21 ostborn Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <zlib.h>
#include <pcre.h>

#include "config.h"
#include "mdatatypes.h"
#include "datatype.h"
#include "mconfig.h"

/* begin of Match */

char *mdata_Match_to_xml(gzFile *fd, mdata *data) {
	return NULL;
}

int mdata_Match_free(mdata *data) {
	if (!data) return -1;
	if (data->type != M_DATA_TYPE_MATCH) return -1;

	if (data->data.match.match)	pcre_free(data->data.match.match);
	if (data->data.match.study)	pcre_free(data->data.match.study);

	return 0;
}

int mdata_Match_setdata(mdata *data, const char *str, const char *match) {
	const char *errstr;
	int errofs;

	data->key = strdup(str);
	assert(data->key);

	data->data.match.match	= pcre_compile(match, 0, &errstr, &errofs, NULL);
	if (data->data.match.match == NULL) {
		M_DEBUG3(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_DATATYPE, M_DEBUG_LEVEL_ERRORS,
			 "regex compilation error: %s, %d -> %s \n",
			 errstr, errofs, match);
		return -1;
	}

	data->data.match.study	= pcre_study(data->data.match.match, 0, &errstr);

	return 0;
}

int mdata_Match_from_xml(void *user_data, int tagtype, const xmlChar *value, const xmlChar **attrs) {
	return 0;
}

int mdata_Match_append(mdata *dst, mdata *src) {

	return 0;
}

mdata *mdata_Match_init() {
	mdata *data = mdata_init();
	assert(data);

	data->key		= NULL;
	data->type		= M_DATA_TYPE_MATCH;

#ifdef DEBUG_DATATYPES
	fprintf(stderr, "%s.%d: got %ld (%d)\n", __FILE__, __LINE__, data->id, data->type);
#endif
/* init specifics */
	data->data.match.match	= NULL;

	return data;
}

mdata *mdata_Match_copy(mdata *src) {
/*	mdata *data = mdata_Match_init();
	assert(data);
	mdata_Match_setdata(data, src->key, src->data.match.match);*/

	return NULL;
}

mdata *mdata_Match_create(const char *match, const char *str) {
	mdata *data = mdata_Match_init();
	assert(data);
	
	if (mdata_Match_setdata(data, str, match)) return NULL;

	return data;
}

/* end of Match */
