/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.h,v 1.22 2003/08/01 01:25:50 ostborn Exp $
*/
#ifndef _OUTPUT_PLUGIN_CONFIG_H_
#define _OUTPUT_PLUGIN_CONFIG_H_

#include <stdio.h>
#include "mlist.h"
#include "mstate.h"
#include "mtree.h"
#include "template.h"

/**
 * data container for the coloums of the tables
 *
 */
typedef struct {
	const char *name;  /*< visible name of the coloumn */
	const char *class; /*< CSS class, may be NULL */
} fields_def;

/**
 * data container for generic reports
 *
 */

typedef struct {
	const char *key; /*< type of report */
	const char *title; /*< visible title of the table */
	int options;       /*< options for show_mhash */
	int show_graph;    /*< for the graph ? (conf->show...) */
	char * (*draw_graph)(mconfig * ext_conf, mstate * state);
	                   /*< graph function (may be NULL) */
	fields_def fields[6];
	                   /*< coloumns */
} reports_def;

typedef struct {
	const char *key;
	const char *title;
	char *(*func)(mconfig *ext_conf, mstate *state, const char *current, int max);
} tmpl_reports;

#define M_TMPL_MAX_REPORTS 256

typedef struct {
	char *template_path;
	char *template_name;

	/* Colors for column headings etc. */
	char *col_pages;
	char *col_files;
	char *col_visits;
	char *col_xfer;
	char *col_hits;
	char *col_backgnd;
	char *col_shadow;
	char *col_border;
	char *col_foregnd;

	int show_reports;

	/* Create a flat menu structure. */
	int flat_menu;

	/* Provide flexible classnames */
	char *cell_class_title;
	char *cell_class_leftheader;
	char *cell_class_header;
	char *cell_class_rightheader;
	char *cell_class_leftline;
	char *cell_class_line;
	char *cell_class_rightline;
	char *cell_class_leftgline;
	char *cell_class_gline;
	char *cell_class_rightgline;
	char *cell_class_leftfooter;
	char *cell_class_footer;
	char *cell_class_rightfooter;
	char *cell_class_lefthline;
	char *cell_class_hline;
	char *cell_class_righthline;

	/* Provide flexible tagadditions */
	char *cell_tags_title;
	char *cell_tags_leftheader;
	char *cell_tags_header;
	char *cell_tags_rightheader;
	char *cell_tags_leftline;
	char *cell_tags_line;
	char *cell_tags_rightline;
	char *cell_tags_leftgline;
	char *cell_tags_gline;
	char *cell_tags_rightgline;
	char *cell_tags_leftfooter;
	char *cell_tags_footer;
	char *cell_tags_rightfooter;
	char *cell_tags_lefthline;
	char *cell_tags_hline;
	char *cell_tags_righthline;

	mlist *col_circle;
	mlist *col_vhostcircle;

	char *assumedprotocol;
	char *hostname;
	char *filename_pattern;
	char *index_filename;

	char *outputdir;

	char *tmpl_menu;
	char *tmpl_outer;
	char *tmpl_table;
	char *tmpl_index;

	mlist   *variables,
		*reports,
		*files,
		*menuentry,
		*menutitle;

	mtree   *menu;
	tmpl_reports avail_reports[M_TMPL_MAX_REPORTS];
	reports_def *web_reports;
	reports_def *mail_reports;
	
	
	buffer *tmp_buf;
	buffer *tmp_output;
	
	
	tmpl_main *tmpl_output_link;
	buffer *tmpl_output_filename;
	
	void * old_conf;
} config_output;

int mplugins_output_generate_monthly_output(mconfig *ext_conf, mstate *state, const char *subpath);
int mplugins_output_generate_history_output(mconfig *ext_conf, mlist *history, const char *subpath);

int mplugins_output_template_patch_config(mconfig *ext_conf);
int mplugins_output_template_unpatch_config(mconfig *ext_conf);

#endif
