/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.h,v 1.26 2002/10/28 17:14:21 le_zas Exp $
*/
#ifndef _OUTPUT_PLUGIN_CONFIG_H_
#define _OUTPUT_PLUGIN_CONFIG_H_

#include <stdio.h>
#include "mlist.h"
#include "mstate.h"

typedef struct {
/* colors */
	/* Colors for graphs */
	char *col_backgnd;
	char *col_foregnd;
	char *col_border;
	char *col_shadow;
	char *col_grid;

	/* Colors for column headings etc. */
	char *col_pages;
	char *col_files;
	char *col_visits;
	char *col_xfer;
	char *col_hits;

	mlist *col_circle;
	mlist *col_vhostcircle;

	char *page_style;
	char *assumedprotocol;
	char *hostname;
	char *cont_charset;
	char *cont_language;

/* filenames for the html header/footer */
	char *html_header;
	char *html_footer;
	char *cssfile;

	char *outputdir;

/* Added by Georges 'Melkor' Goncalves <melkor@lords.com>
** courtesy of Jan Kneschke
*/
/* suffix for the generated statistics page files */
	char *pages_suffix;

/* maximum values */
	int max_req_urls;
	int max_os;
	int max_hosts;
	int max_ref_urls;
	int max_entry_pages;
	int max_exit_pages;
	int max_indexed_pages;
	int max_ua;
	int max_req_prot;
	int max_req_meth;
	int max_status_codes;
	int max_robots;
	int max_bookmarks;
	int max_broken_links;
	int max_internal_errors;
	int max_search_engines;
	int max_search_strings;
	int max_countries;
	int max_extensions;
	int max_visit_paths;
	int max_visit_path_lengths;
	int max_visit_durations;
	int max_view_durations;
	int max_vhosts;
/* dkl */
	int max_graphed_months;
/* end dkl */

	int show_daily_graph;
	int show_hourly_graph;
	int show_monthly_graph;
	int show_country_graph;
	int show_validation_links;
	int show_vhost_graph;
/* Whether to show month + year at top of menu or not. --Zas */
	int show_month_in_menu;
/* Whether to show a fixed size grid in monthly graph or not. --Zas */
	int show_monthly_graph_grid;
/* Whether to show a max. values in monthly graph or not. (use tinym class) --Zas */
	int show_monthly_maxima;
	
	int dont_cut_urls;
	int dont_escape_entities;


	void *old_conf;
} config_output;

int mplugins_output_modlogan_generate_monthly_output(mconfig *ext_conf, mstate *state, const char *subpath);
int mplugins_output_modlogan_generate_history_output(mconfig *ext_conf, mlist *history, const char *subpath);

long mhash_sumup(mhash *h);

int mplugins_output_modlogan_patch_config(mconfig *ext_conf);
int mplugins_output_modlogan_unpatch_config(mconfig *ext_conf);

#endif
