/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: pictures_month.c,v 1.28 2003/08/01 21:30:01 miham Exp $
*/
#include <stdio.h>
#include <stdlib.h>

#include "config.h"

#ifdef HAVE_LIBGD
#ifdef HAVE_GD_GD_H
#include <gd/gd.h>
#include <gd/gdfonts.h>
#else
#include <gd.h>
#include <gdfonts.h>
#endif
#endif

#include "mconfig.h"
#include "mlist.h"
#include "mdatatypes.h"
#include "mlocale.h"
#include "misc.h"

#include "pictures.h"
#include "generate.h"

/* calculating the box
**
** +------------------------------+
** |+---------------++-----------+|
** ||               ||_-_    (2) ||
** ||#              ||   ~-_     ||
** ||##  #    (1)   |+-----------+|
** ||## ##          |+-----------+|
** ||#####          ||       (3) ||
** ||#####          ||           ||
** |+---------------++-----------+|
** +------------------------------+
**
*/

#define IM_FILENAME     "monthly_usage.png"

char *mplugin_modlogan_create_pic_X_month(mconfig *ext_conf, mlist *history) {
#ifdef HAVE_LIBGD
	mlist *l = history, *last;
	gdImage *im;
	FILE *f;
	char filename[255];
	static char href[255]="";
	rgb_tripple rgb;
	char int2str[20]; /* 20 is a guess only !! */
	int x1, y1, x2, y2;
	char *tmp;
	config_output *conf = ext_conf->plugin_conf;


/* this is extremely ugly. dkl */

	int i, MAX_GRAPHED_MONTHS, IM_CELLSPACING, IM_BOX1_HEIGHT,
		IM_BOX2_HEIGHT, IM_BOX3_HEIGHT, IM_FONT_HEIGHT, IM_FONT_WIDTH,
		IM_BOX1_BAR_WIDTH, IM_BOX1_BAR_SHIFT, IM_BOX1_BAR_SPACE,
		IM_BOX2_BAR_WIDTH, IM_BOX2_BAR_SPACE, IM_BOX3_BAR_WIDTH,
		IM_BOX3_BAR_SPACE, IM_BOX1_X1, IM_BOX1_Y1, IM_BOX1_X2,
		IM_BOX1_Y2, IM_BOX2_X1, IM_BOX2_Y1, IM_BOX2_X2, IM_BOX2_Y2,
		IM_BOX3_X1, IM_BOX3_Y1, IM_BOX3_X2, IM_BOX3_Y2, IM_WIDTH,
		IM_HEIGHT, IM_LAB1_Y1, col_border, col_backgnd,
		col_pages, col_files,
		col_visits, col_border_sh,
		col_hits, col_xfer, col_grid;

	double max_hits, max_files, max_pages, max_visits, max_hosts, max_xfersize;
	max_hits=max_files=max_pages=max_visits=max_hosts=max_xfersize=0;



/* the cause of the trouble */
	MAX_GRAPHED_MONTHS = conf->max_graphed_months;
	i = MAX_GRAPHED_MONTHS;

	IM_CELLSPACING=4;

	IM_BOX1_HEIGHT=200;
	IM_BOX2_HEIGHT=((IM_BOX1_HEIGHT - 3 * IM_CELLSPACING) / 2);
	IM_BOX3_HEIGHT=IM_BOX2_HEIGHT;

  /* gdSmallFont */
	IM_FONT_HEIGHT=13;
	IM_FONT_WIDTH=6;

	IM_BOX1_BAR_WIDTH=10;
	IM_BOX1_BAR_SHIFT=2;
	IM_BOX1_BAR_SPACE=10;

	IM_BOX2_BAR_WIDTH=8;
	IM_BOX2_BAR_SPACE=4;

	IM_BOX3_BAR_WIDTH=IM_BOX2_BAR_WIDTH;
	IM_BOX3_BAR_SPACE=IM_BOX2_BAR_SPACE;

	IM_BOX1_X1=IM_CELLSPACING * 2 + IM_FONT_HEIGHT;
	IM_BOX1_Y1=IM_CELLSPACING * 2 + IM_FONT_HEIGHT;
	IM_BOX1_X2=IM_BOX1_X1 + MAX_GRAPHED_MONTHS * (IM_BOX1_BAR_WIDTH + IM_BOX1_BAR_SPACE);
	IM_BOX1_Y2=IM_BOX1_Y1 + IM_BOX1_HEIGHT;

	IM_BOX2_X1=IM_BOX1_X2 + IM_CELLSPACING * 3;
	IM_BOX2_Y1=IM_BOX1_Y1;
	IM_BOX2_X2=IM_BOX2_X1 + MAX_GRAPHED_MONTHS * (IM_BOX2_BAR_WIDTH + IM_BOX2_BAR_SPACE);
	IM_BOX2_Y2=IM_BOX2_Y1 + IM_BOX2_HEIGHT;

	IM_BOX3_X1=IM_BOX2_X1;
	IM_BOX3_Y1=IM_BOX2_Y2 + 3 * IM_CELLSPACING;
	IM_BOX3_X2=IM_BOX2_X2;
	IM_BOX3_Y2=IM_BOX3_Y1 + IM_BOX3_HEIGHT;

	IM_WIDTH=IM_BOX2_X2 + IM_CELLSPACING * 2 + IM_FONT_HEIGHT;
	IM_HEIGHT= IM_BOX3_Y2 + IM_CELLSPACING * 2 + IM_FONT_HEIGHT;

	IM_LAB1_Y1=IM_HEIGHT - IM_FONT_HEIGHT - IM_CELLSPACING;

/* end dkl */



	/* go to the last element */
	while (l->next) l = l->next;

	last = l;
#define SET_MAX(x) if (data->data.hist->days_passed && \
	(data->data.hist->data.web.x / data->data.hist->days_passed) > max_##x) \
	max_##x = ((double)data->data.hist->data.web.x / data->data.hist->days_passed)

	for (;i && l; i--, l = l->prev) {
		mdata *data = l->data;

		if (data && (data->data.hist->days_passed > 0)) {
			SET_MAX(hits);
			SET_MAX(files);
			SET_MAX(pages);
			SET_MAX(visits);
			SET_MAX(hosts);
			SET_MAX(xfersize);
		}
	}
#undef SET_MAX

	l = last;

	i = MAX_GRAPHED_MONTHS - i - 1;


	im = gdImageCreate( IM_WIDTH + 1,IM_HEIGHT + 1 );

	col_border = gdImageColorAllocate(im, 0x00, 0x00, 0x00);

	html3torgb3(conf->col_shadow, &rgb);
	col_border_sh = gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);

	html3torgb3(conf->col_backgnd, &rgb);
	col_backgnd = gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);
	html3torgb3(conf->col_hits, &rgb);
	col_hits = gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);
	html3torgb3(conf->col_files, &rgb);
	col_files = gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);
	html3torgb3(conf->col_pages, &rgb);
	col_pages = gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);
	html3torgb3(conf->col_visits, &rgb);
	col_visits = gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);
	html3torgb3(conf->col_xfer, &rgb);
	col_xfer = gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);

	if (conf->col_grid) html3torgb3(conf->col_grid, &rgb);
	else html3torgb3(conf->col_border, &rgb);
	col_grid = gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);

	/* background */
	gdImageFilledRectangle(im, 0, 0, IM_WIDTH-1, IM_HEIGHT-1, col_backgnd);

	/* surrounding border */
	gdImageRectangle( im, 1, 1, IM_WIDTH-1, IM_HEIGHT-1, col_border );
	gdImageRectangle( im, 0, 0, IM_WIDTH, IM_HEIGHT, col_border_sh );

	/* left border - max hits */
	sprintf(int2str, "%.0f", max_hits);
	x1 = IM_CELLSPACING;
	y1 = IM_BOX1_Y1 + strlen(int2str) * IM_FONT_WIDTH;
	gdImageStringUp(im, gdFontSmall, x1, y1, int2str, col_border);

	/* right border - max visits */
	sprintf(int2str, "%.0f", max_visits);
	x1 = IM_WIDTH - IM_CELLSPACING - IM_FONT_HEIGHT;
	y1 = IM_BOX2_Y1 + strlen(int2str) * IM_FONT_WIDTH;
	gdImageStringUp(im, gdFontSmall, x1, y1, int2str, col_border);

	/* right border - max kbytes */
	sprintf(int2str, "%.0f", max_xfersize / 1024);
	x1 = IM_WIDTH - IM_CELLSPACING - IM_FONT_HEIGHT;
	y1 = IM_BOX3_Y1 + strlen(int2str) * IM_FONT_WIDTH;
	gdImageStringUp(im, gdFontSmall, x1, y1, int2str, col_border);

	/* right border - 'pages/files/hits' */
	x1 = IM_CELLSPACING;
	y1 = IM_BOX1_Y2;
	gdImageStringUp(im, gdFontSmall, x1+1, y1+1, _("Pages"), col_border_sh);
	gdImageStringUp(im, gdFontSmall, x1, y1, _("Pages"), col_pages);

	y1 -= strlen(_("Pages")) * IM_FONT_WIDTH;
	gdImageStringUp(im, gdFontSmall, x1+1, y1+1, "/", col_border_sh);
	gdImageStringUp(im, gdFontSmall, x1, y1, "/", col_border);

	y1 -= IM_FONT_WIDTH;
	gdImageStringUp(im, gdFontSmall, x1+1, y1+1, _("Files"), col_border_sh);
	gdImageStringUp(im, gdFontSmall, x1, y1, _("Files"), col_files);

	y1 -= strlen(_("Files")) * IM_FONT_WIDTH;
	gdImageStringUp(im, gdFontSmall, x1+1, y1+1, "/", col_border_sh);
	gdImageStringUp(im, gdFontSmall, x1, y1, "/", col_border);

	y1 -= IM_FONT_WIDTH;
	gdImageStringUp(im, gdFontSmall, x1+1, y1+1, _("Hits"), col_border_sh);
	gdImageStringUp(im, gdFontSmall, x1, y1, _("Hits"), col_hits);


  /* right border - 'visits' */
	x1 = (IM_BOX2_X2) - (IM_CELLSPACING) - strlen(_("Visits")) * IM_FONT_WIDTH;
	y1 = IM_CELLSPACING;
	gdImageString(im, gdFontSmall, x1+1, y1+1, _("Visits"), col_border_sh);
	gdImageString(im, gdFontSmall, x1, y1, _("Visits"), col_visits);
	/* right border - 'kbytes' */
	x1 = (IM_BOX3_X2) - (IM_CELLSPACING) - strlen(_("KBytes")) * IM_FONT_WIDTH;
	y1 = IM_LAB1_Y1;
	gdImageString(im, gdFontSmall, x1+1, y1+1, _("KBytes"), col_border_sh);
	gdImageString(im, gdFontSmall, x1, y1, _("KBytes"), col_xfer);


	/* header */
	x1 = IM_BOX1_X1;
	y1 = IM_CELLSPACING;
	tmp = malloc( strlen( _("Usage summary for %1$s") ) - 3 + strlen( conf->hostname ) );
	sprintf( tmp, _("Usage summary for %1$s"), conf->hostname );
	gdImageString(im, gdFontSmall, x1, y1, tmp, col_border);

	x1 += strlen(tmp) * IM_FONT_WIDTH;
	free(tmp);

	/* border for BOX1 */
	gdImageRectangle(im,
		IM_BOX1_X1 - IM_CELLSPACING,
		IM_BOX1_Y1 - IM_CELLSPACING,
		IM_BOX1_X2 + IM_CELLSPACING,
		IM_BOX1_Y2 + IM_CELLSPACING,
		col_border);

	gdImageRectangle(im,
		IM_BOX1_X1 - IM_CELLSPACING + 1,
		IM_BOX1_Y1 - IM_CELLSPACING + 1,
		IM_BOX1_X2 + IM_CELLSPACING + 1,
		IM_BOX1_Y2 + IM_CELLSPACING + 1,
		col_border_sh);

	if (conf->show_monthly_graph_grid) {
		double j;
		int styleDashed[3];

		styleDashed[0] = col_grid;
		styleDashed[1] = gdTransparent;
		styleDashed[2] = gdTransparent;

		gdImageSetStyle(im, styleDashed, 3);

		for(j = IM_BOX1_Y1;
		    j <= IM_BOX1_Y2 + (IM_BOX1_Y2-IM_BOX1_Y1)/10;
		    j += (double)(IM_BOX1_Y2-IM_BOX1_Y1)/10)
			gdImageLine(im, IM_BOX1_X1+1, j, IM_BOX1_X2+1, j, gdStyled);
	}

	/* border for BOX2 */
	gdImageRectangle(im,
			 IM_BOX2_X1 - IM_CELLSPACING,
			 IM_BOX2_Y1 - IM_CELLSPACING,
			 IM_BOX2_X2 + IM_CELLSPACING,
			 IM_BOX2_Y2 + IM_CELLSPACING,
			 col_border);
	gdImageRectangle(im,
			 IM_BOX2_X1 - IM_CELLSPACING + 1,
			 IM_BOX2_Y1 - IM_CELLSPACING + 1,
			 IM_BOX2_X2 + IM_CELLSPACING + 1,
			 IM_BOX2_Y2 + IM_CELLSPACING + 1,
			 col_border_sh);

	 if (conf->show_monthly_graph_grid) {
		double j;
		int styleDashed[3];

		styleDashed[0] = col_grid;
		styleDashed[1] = gdTransparent;
		styleDashed[2] = gdTransparent;

		gdImageSetStyle(im, styleDashed, 3);

		for(j = IM_BOX2_Y1;
		    j <= IM_BOX2_Y2 + (IM_BOX2_Y2-IM_BOX2_Y1)/10;
		    j += (double)(IM_BOX2_Y2-IM_BOX2_Y1)/10)
			gdImageLine(im, IM_BOX2_X1+1, j, IM_BOX2_X2+1, j, gdStyled);
	}

	/* border for BOX3 */
	gdImageRectangle(im,
			 IM_BOX3_X1 - IM_CELLSPACING,
			 IM_BOX3_Y1 - IM_CELLSPACING,
			 IM_BOX3_X2 + IM_CELLSPACING,
			 IM_BOX3_Y2 + IM_CELLSPACING,
			 col_border);
	gdImageRectangle(im,
			 IM_BOX3_X1 - IM_CELLSPACING + 1,
			 IM_BOX3_Y1 - IM_CELLSPACING + 1,
			 IM_BOX3_X2 + IM_CELLSPACING + 1,
			 IM_BOX3_Y2 + IM_CELLSPACING + 1,
			 col_border_sh);

	if (conf->show_monthly_graph_grid) {
		double j;
		int styleDashed[3];

		styleDashed[0] = col_grid;
		styleDashed[1] = gdTransparent;
		styleDashed[2] = gdTransparent;

		gdImageSetStyle(im, styleDashed, 3);

		for(j = IM_BOX3_Y1+1 /* +1 is needed here ;) */;
		    j < IM_BOX3_Y2+(IM_BOX3_Y2-IM_BOX3_Y1)/10;
		    j += (double)(IM_BOX3_Y2-IM_BOX3_Y1)/10)
			gdImageLine(im, IM_BOX3_X1+1, j, IM_BOX3_X2+1, j, gdStyled);
	}

	for (;i >= 0  && l; i--, l = l->prev) {
		mdata *data = l->data;

		if (data && (data->data.hist->days_passed > 0)) {
			/* Box 1 */

			if (max_hits) {
				int y2b = IM_BOX1_Y2;
				int y1b = IM_BOX1_Y1;
				x1 = IM_BOX1_X1 + i * (IM_BOX1_BAR_SPACE + IM_BOX1_BAR_WIDTH);
				x2 = x1 + IM_BOX1_BAR_WIDTH;

				y2 = y2b;
				y1 = y2 - ((double)data->data.hist->data.web.hits / max_hits / data->data.hist->days_passed) * (y2b - y1b - 1);

				if (y1 != y2) {
					gdImageFilledRectangle(im, x1, y1, x2, y2, col_hits);
					gdImageRectangle(im, x1, y1, x2, y2, col_border);
				}

				x1 += IM_BOX1_BAR_SHIFT;
				x2 += IM_BOX1_BAR_SHIFT;

				y1 = y2 - ((double)data->data.hist->data.web.files / max_hits / data->data.hist->days_passed) * (y2b - y1b - 1);

				if (y1 != y2) {
					gdImageFilledRectangle(im, x1, y1, x2, y2, col_files);
					gdImageRectangle(im, x1, y1, x2, y2, col_border);
				}

				x1 += IM_BOX1_BAR_SHIFT;
				x2 += IM_BOX1_BAR_SHIFT;

				y1 = y2 - ((double)data->data.hist->data.web.pages / max_hits / data->data.hist->days_passed) * (y2b - y1b - 1);

				if (y1 != y2) {
					gdImageFilledRectangle(im, x1, y1, x2, y2, col_pages);
					gdImageRectangle(im, x1, y1, x2, y2, col_border);
				}
			}

			/* Box 2 */

			if (max_visits) {
				int y2b = IM_BOX2_Y2;
				int y1b = IM_BOX2_Y1;

				x1 = IM_BOX2_X1 + i * (IM_BOX2_BAR_SPACE + IM_BOX2_BAR_WIDTH);
				x2 = x1 + IM_BOX2_BAR_WIDTH;

				y2 = y2b;
				y1 = y2 - ((double)data->data.hist->data.web.visits / max_visits / data->data.hist->days_passed) * (y2b - y1b - 1);

				if (y1 != y2) {
					gdImageFilledRectangle(im, x1, y1, x2, y2, col_visits);
					gdImageRectangle(im, x1, y1, x2, y2, col_border);
				}
			}

			/* Box 3 */

			if (max_xfersize) {
				double percent = (double)data->data.hist->data.web.xfersize / max_xfersize / data->data.hist->days_passed;
				int y2b = IM_BOX3_Y2;
				int y1b = IM_BOX3_Y1;

				x1 = IM_BOX3_X1 + i * (IM_BOX3_BAR_SPACE + IM_BOX3_BAR_WIDTH);
				x2 = x1 + IM_BOX3_BAR_WIDTH;

				y2 = y2b;
				y1 = y2 - (double)( percent * (y2b - y1b - 1 ));
				if (y1 != y2) {
					gdImageFilledRectangle(im, x1, y1, x2, y2, col_xfer);
					gdImageRectangle(im, x1, y1, x2, y2, col_border);
				}
			}
		}

		if (data) {
			int month_num;
			x1 = IM_BOX1_X1 + i * (IM_BOX1_BAR_SPACE + IM_BOX1_BAR_WIDTH);
			y1 = IM_LAB1_Y1;

			month_num = data->data.hist->month;
			gdImageString(im, gdFontSmall, x1, y1, get_month_string(month_num, 1), col_border);
		}
	}

	sprintf(filename, "%s/%s",
		conf->outputdir,
		IM_FILENAME);

	if ((f = fopen (filename, "wb"))) {
		gdImagePng(im, f);

		fclose(f);
	}

	gdImageDestroy(im);

	sprintf(href, "<center><img src=\"%s\" alt=\"%s\" width=\"%d\" height=\"%d\" /></center>\n",
		IM_FILENAME, _("Monthly Overview"), IM_WIDTH+1, IM_HEIGHT+1);

	return href;
#else
	return NULL;
#endif
}

