/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: mplugins.c,v 1.42 2003/01/06 10:56:46 ostborn Exp $
*/

#include <stdio.h>
#include <dlfcn.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>

#include "mconfig.h"
#include "mrecord.h"
#include "mplugins.h"

#if 0

/* looks like we don't need that function */
int mplugins_load_datatypes() {
	const char *datatypes[] = {
				    "brokenlink", 
				    "count",
				    "location",
				    "mailhist",
				    "match",
				    "netmask",
				    "query",
				    "record",
				    "split",
				    "sublist",
				    "state",
				    "traffic",
				    "visit",
				    "visited",
				    "webhist",
				    NULL
				    };
	int i;
	
	for (i = 0; datatypes[i]; i++) {
		const char *error;
		char *filename = NULL;
		void *h;
		
		filename = malloc(strlen("/libmla_mdata_") + strlen(datatypes[i]) + strlen(LIBDIR) + 1 + 3);
		assert(filename);

		sprintf(filename, "%s/libmla_mdata_%s.so", LIBDIR, datatypes[i]);
		
		if (NULL == (h = dlopen(filename, RTLD_LAZY | RTLD_GLOBAL))) {
			if ((error = dlerror()) != NULL) {
				fprintf(stderr, "%s.%d: %s -> %s\n", __FILE__, __LINE__, error, filename);
			} else {
				fprintf(stderr, "%s.%d: unknown error while loading shared lib %s(.la/.so)\n", __FILE__, __LINE__, filename);
			}
			return(-1);
		}
	}
	return 0;
}
#endif

mplugin *mplugins_create() {
	mplugin *plug = malloc(sizeof(mplugin));
	memset(plug, 0, sizeof(mplugin));

	return plug;
}

void mplugins_destroy(mplugin *plug) {
	if (plug) free(plug);
}

int mplugins_load_plugins(mconfig *conf) {
	const char *error;
	char *filename = NULL;
	mlist *l;
	mplugin *func;

	int (*initfunc)(mplugin *func);

/* reset all elements */

	if (conf->loadplugins == NULL) return -1;

	for (l = conf->loadplugins; l && l->data; l = l->next) {
		char *fn, *cfg;
		
		if ((cfg = strchr(l->data->key, ','))) {
			*cfg++ = '\0';
			while (*cfg == ' ') cfg++;
			fn = l->data->key;
		} else {
			cfg = fn = l->data->key;

		}

		filename = malloc(strlen("/libmla_") + strlen(fn) + strlen(LIBDIR) + 1 + 3);
		assert(filename);

		sprintf(filename, "%s/libmla_%s.so", LIBDIR, fn);

		func = mplugins_create();

		func->handle = dlopen(filename, RTLD_LAZY);
		if (conf->debug_level > 2)
			fprintf(stderr, "loading plugin %s (addr: %p, filename: %s)\n",
				l->data->key, func->handle,
				filename);

		if (func->handle == NULL) {
			if ((error = dlerror()) != NULL) {
				fprintf(stderr, "%s.%d: %s -> %s\n", __FILE__, __LINE__, error, filename);
			} else {
				fprintf(stderr, "%s.%d: unknown error while loading shared lib %s(.la/.so)\n", __FILE__, __LINE__, filename);
			}
			return(-1);
		}

		if ((initfunc = dlsym(func->handle, "mplugins_init")) == NULL) {
			fprintf(stderr, "%s.%d: plugin %s (%s) - no init function found\n", __FILE__, __LINE__, l->data->key, filename);
			return -1;
		}

		initfunc(func);

		if (func->dlinit)
			if (func->dlinit(conf)) {
				fprintf(stderr, "%s.%d: plugin %s (%s) - dlinit failed\n", __FILE__, __LINE__, l->data->key, filename);
				return -1;
			}

		if (func->parse_config)
			if (func->parse_config(conf, NULL, cfg)) {
				fprintf(stderr, "%s.%d: plugin %s (%s) - configfile parser failed\n", __FILE__, __LINE__, l->data->key, filename);
				return -1;
			}

		if (conf->show_options == 0 && func->set_defaults)
			if (func->set_defaults(conf)) {
				fprintf(stderr, "%s.%d: plugin %s (%s) - setting defaults failed\n", __FILE__, __LINE__, l->data->key, filename);
				return -1;
			}

		func->config = conf->plugin_conf;
		((mplugin **)(conf->plugins))[conf->plugin_count] = func;
		if (conf->debug_level > 1)
			fprintf(stderr, "plugin %s (%s) loaded\n", l->data->key, filename);
		free(filename);

		conf->plugin_count++;
	}

	if (conf->plugin_count != mlist_count(conf->loadplugins)) {
		fprintf(stderr, "%s.%d: estimated plugin count and real plugin count differ: %d != %d\n", __FILE__, __LINE__,
			conf->plugin_count, mlist_count(conf->loadplugins));

		return -1;
	}

	return 0;
}

int mplugins_setup(mconfig *conf) {
	if (mlist_count(conf->loadplugins) > 0) {
		conf->plugins = malloc(mlist_count(conf->loadplugins) * sizeof(mplugin));
	} else {
		conf->plugins = NULL;
	}
	conf->plugin_count = 0;

	return 0;
}

int mplugins_free(mconfig *conf) {
	mplugin *func;
	int i;

	for (i = 0; i < conf->plugin_count; i++) {

		func = ((mplugin **)(conf->plugins))[i];
		conf->plugin_conf = func->config;

		if (func->dlclose)
			func->dlclose(conf);
#if 0
		/* if we are compiling with -ldmalloc we shouldn't remove the
		 * shared libs. dmalloc will crash otherwise.
		 */
		dlclose(func->handle);
#endif
		mplugins_destroy(func);
	}
	free(conf->plugins);

	return 0;
}

