#ifndef _TEXFONTS
#define _TEXFONTS
/****************************************************************************
 *
 * Copyright(c) 2002-2003, John Forkosh Associates, Inc. All rights reserved.
 * --------------------------------------------------------------------------
 * This file is part of mimeTeX, which is free software. You may redistribute
 * and/or modify it under the terms of the GNU General Public License,
 * version 2 or later, as published by the Free Software Foundation.
 *      MimeTeX is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY, not even the implied warranty of MERCHANTABILITY.
 * See the GNU General Public License for specific details.
 *      By using mimeTeX, you warrant that you have read, understood and
 * agreed to these terms and conditions, and that you are at least 18 years
 * of age and possess the legal right and ability to enter into this
 * agreement and to use mimeTeX in accordance with it.
 *      Your mimeTeX distribution should contain a copy of the GNU General
 * Public License.  If not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA,
 * or point your browser to  http://www.gnu.org/licenses/gpl.html
 * --------------------------------------------------------------------------
 *
 * Purpose:	chardef structure data for mimetex
 *		generated by gfuntype
 * 
 * Source:	texfonts.h
 *
 * Notes:     o	Each big declaration of static chardef arrays
 *		is generated by a single run of my program gfuntype,
 *		as explained in the notes below, and then all those
 *		separate outputs are gathered together in this file.
 *	      o	You must first run metafont to generate a .gf file,
 *		for example...
 *		  mf '\mode=onetz; mag=magstep(.5); input cmmi10'
 *		will generate file cmmi10.131gf (which corresponds
 *		to size=3 below)
 *	      o	Given that (or any other) .gf file, next run
 *		  gftype -i cmmi10.131gf > typeout
 *		(where  typeout  can be any filename you like)
 *	      o	Then run my program against the above output,
 *		for example...
 *		  gfuntype  -n cmmi131  typeout  cmmi131.h
 *		which generates output file cmmib131.h (or any
 *		filename you supply as the last arg), containing
 *		the  static chardef cmmi131[]  array of data.
 *		(The name of that array is taken from the  -n  arg
 *		you supplied to gfuntype.)
 *	      o	Repeat the above steps for all the arrays you need,
 *		and then gather the output together in this file,
 *		texfonts.h, which will be #include'd by mimetex.h
 *	      o	Finally, manually edit the  fonttable[]  array
 *		in minetex.h, placing the names of all these chardef
 *		arrays in the appropriate fonttable[] cells.
 *	      o	Now you can recompile mimetex.c to use your new fonts.
 *
 * --------------------------------------------------------------------------
 * Revision History:
 * 10/05/02	J.Forkosh	Installation.
 * 07/10/03	J.Forkosh	Added cmmi10 fonts (in addition to cmmib10),
 *				and rsfs fonts.
 * 07/12/03	J.Forkosh	Entirely new set of fonts generated.
 * 10/21/05	J.Forkosh	Compressed fonts generated
 *
 ***************************************************************************/


/* ------------------------------------------------------------------------
font sizes 0-7 for cmr10
------------------------------------------------------------------------ */

/* --- size=0 for .83gf ---
 * mf '\mode=eighthre;  input cmr10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmr83 --- */
static	chardef  cmr83[] =
   {
      /* --- pixel bitmap for cmr83 char#0 \Gamma --- */
      {   0, 1561,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbf\x28\x0a\x82\x20\x1c" }  },
      /* --- pixel bitmap for cmr83 char#1 \Delta --- */
      {   1, 1588,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x28\x28\x6c\x44\x44\x82\xfe" }  },
      /* --- pixel bitmap for cmr83 char#2 \Theta --- */
      {   2, 1623,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x14\xb6\x61\x28\x31" }  },
      /* --- pixel bitmap for cmr83 char#3 \Lambda --- */
      {   3, 1660,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x04\x85\x42\xa1\x88\xee" }  },
      /* --- pixel bitmap for cmr83 char#4 \Xi --- */
      {   4, 1695,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\xa0\xc8\x27\x02\x04\xff" }  },
      /* --- pixel bitmap for cmr83 char#5 \Pi --- */
      {   5, 1726,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\xf5\x11\x41\x13\x23" }  },
      /* --- pixel bitmap for cmr83 char#6 \Sigma --- */
      {   6, 1763,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7f\x4a\x42\xac\xfc" }  },
      /* --- pixel bitmap for cmr83 char#7 \Upsilon --- */
      {   7, 1794,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x77\x8a\x20\x08\x82\x70" }  },
      /* --- pixel bitmap for cmr83 char#8 \Phi --- */
      {   8, 1823,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8e\xb8\x5a\x1d\x71" }  },
      /* --- pixel bitmap for cmr83 char#9 \Psi --- */
      {   9, 1854,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x92\xa6\xab\x87\x70" }  },
      /* --- pixel bitmap for cmr83 char#10 \Omega --- */
      {  10, 1889,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x91\x48\x24\xa2\x54\xef" }  },
      /* --- pixel bitmap for cmr83 char#11 \ff --- */
      {  11, 3214,                      /* character number, location */
          8,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x24\x24\x7f\x24\x24\x24\x66" }  },
      /* --- pixel bitmap for cmr83 char#12 \fi --- */
      {  12, 3249,                      /* character number, location */
          8,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x41\x7c\x1c\x45\xd9" }  },
      /* --- pixel bitmap for cmr83 char#13 \fl --- */
      {  13, 3278,                      /* character number, location */
          8,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x45\x7d\x14\x45\xd9" }  },
      /* --- pixel bitmap for cmr83 char#14 \ffi --- */
      {  14, 3313,                      /* character number, location */
          8,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x91\x40\xc2\x7f\xa4\x91\x44\x92\xdd" }  },
      /* --- pixel bitmap for cmr83 char#15 \ffl --- */
      {  15, 3356,                      /* character number, location */
          8,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x91\x44\xd2\x7f\x24\x91\x44\x92\xc9" }  },
      /* --- pixel bitmap for cmr83 char#16 \imath --- */
      {  16, 2288,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  3,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x93\x74" }  },
      /* --- pixel bitmap for cmr83 char#17 \jmath --- */
      {  17, 2305,                      /* character number, location */
          5,-1,   -2,-1,      /* topleft row,col, and botleft row,col */
          {  3,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x26\x49\x1e" }  },
      /* --- pixel bitmap for cmr83 char#18 \gravesym --- */
      {  18, 3052,                      /* character number, location */
          8, 1,    6, 1,      /* topleft row,col, and botleft row,col */
          {  2,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x09" }  },
      /* --- pixel bitmap for cmr83 char#19 \acutesym --- */
      {  19, 3063,                      /* character number, location */
          8, 2,    6, 2,      /* topleft row,col, and botleft row,col */
          {  2,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06" }  },
      /* --- pixel bitmap for cmr83 char#20 \checksym --- */
      {  20, 3074,                      /* character number, location */
          7, 1,    6, 1,      /* topleft row,col, and botleft row,col */
          {  3,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07" }  },
      /* --- pixel bitmap for cmr83 char#21 \brevesym --- */
      {  21, 3083,                      /* character number, location */
          8, 1,    6, 1,      /* topleft row,col, and botleft row,col */
          {  3,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3d" }  },
      /* --- pixel bitmap for cmr83 char#22 (noname) --- */
      {  22, 3096,                      /* character number, location */
          7, 1,    6, 1,      /* topleft row,col, and botleft row,col */
          {  3,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07" }  },
      /* --- pixel bitmap for cmr83 char#23 (noname) --- */
      {  23, 3105,                      /* character number, location */
          8, 3,    6, 3,      /* topleft row,col, and botleft row,col */
          {  2,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmr83 char#24 (noname) --- */
      {  24, 3116,                      /* character number, location */
          0, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  2,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e" }  },
      /* --- pixel bitmap for cmr83 char#25 \ss --- */
      {  25, 2326,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x44\xa9\x25\xa5\x5c" }  },
      /* --- pixel bitmap for cmr83 char#26 \ae --- */
      {  26, 2363,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x36\x7f\x22\x69\x03" }  },
      /* --- pixel bitmap for cmr83 char#27 \oe --- */
      {  27, 2390,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6e\xf1\x11\x91\x6e" }  },
      /* --- pixel bitmap for cmr83 char#28 (noname) --- */
      {  28, 2419,                      /* character number, location */
          6, 0,   -1, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xd0\xf5\x7a\x5d\x00" }  },
      /* --- pixel bitmap for cmr83 char#29 \AE --- */
      {  29, 2448,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x30\x51\xa2\xc2\x97\xaa\xc4\xf9" }  },
      /* --- pixel bitmap for cmr83 char#30 \OE --- */
      {  30, 2495,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xc9\x14\x5b\x38\xa1\xc6\x28\x23\xff" }  },
      /* --- pixel bitmap for cmr83 char#31 (noname) --- */
      {  31, 2542,                      /* character number, location */
          8, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x96\xa6\x6d\x69\x39\x02" }  },
      /* --- pixel bitmap for cmr83 char#32 (noname) --- */
      {  32, 3146,                      /* character number, location */
          4, 0,    3, 0,      /* topleft row,col, and botleft row,col */
          {  2,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x03" }  },
      /* --- pixel bitmap for cmr83 char#33 ! --- */
      {  33, 2587,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  1,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9f" }  },
      /* --- pixel bitmap for cmr83 char#34 " --- */
      {  34, 3403,                      /* character number, location */
          8, 0,    5, 0,      /* topleft row,col, and botleft row,col */
          {  3,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6d\x01" }  },
      /* --- pixel bitmap for cmr83 char#35 # --- */
      {  35, 2629,                      /* character number, location */
          8, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x28\x14\xea\x4f\xa1\x50\xfe\x0a\x05" }  },
      /* --- pixel bitmap for cmr83 char#36 $ --- */
      {  36, 2180,                      /* character number, location */
          9, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          {  3,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xd2\x3f\xff\x12" }  },
      /* --- pixel bitmap for cmr83 char#37 % --- */
      {  37, 2672,                      /* character number, location */
          9, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc2\x5e\xa9\xa2\x40\x51\xa5\xd2\x10" }  },
      /* --- pixel bitmap for cmr83 char#38 & --- */
      {  38, 2207,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x0a\x87\xed\xca\x44\xdc" }  },
      /* --- pixel bitmap for cmr83 char#39 ' --- */
      {  39, 2729,                      /* character number, location */
          8, 1,    5, 1,      /* topleft row,col, and botleft row,col */
          {  1,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07" }  },
      /* --- pixel bitmap for cmr83 char#40 ( --- */
      {  40, 2742,                      /* character number, location */
          9, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  2,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5a\x55\x95\x02" }  },
      /* --- pixel bitmap for cmr83 char#41 ) --- */
      {  41, 2775,                      /* character number, location */
          9, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          {  2,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa5\xaa\x6a\x01" }  },
      /* --- pixel bitmap for cmr83 char#42 * --- */
      {  42, 2808,                      /* character number, location */
          9, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          {  3,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x2e" }  },
      /* --- pixel bitmap for cmr83 char#43 + --- */
      {  43, 2825,                      /* character number, location */
          7, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  6,    9, 3,11, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf3\x31\x26\xf3\x31\x2f" }  },
      /* --- pixel bitmap for cmr83 char#44 (noname) --- */
      {  44, 2850,                      /* character number, location */
          1, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  1,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07" }  },
      /* --- pixel bitmap for cmr83 char#45 (noname) --- */
      {  45, 3422,                      /* character number, location */
          3, 0,    2, 0,      /* topleft row,col, and botleft row,col */
          {  3,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07" }  },
      /* --- pixel bitmap for cmr83 char#46 (noname) --- */
      {  46, 2863,                      /* character number, location */
          1, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  1,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01" }  },
      /* --- pixel bitmap for cmr83 char#47 / --- */
      {  47, 2872,                      /* character number, location */
          9, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  3,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x24\x25\x49\x4a\x02" }  },
      /* --- pixel bitmap for cmr83 char#48 0 --- */
      {  48, 1930,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\xc6\x18\xa3\x03" }  },
      /* --- pixel bitmap for cmr83 char#49 1 --- */
      {  49, 1961,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  3,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9a\x24\x1d" }  },
      /* --- pixel bitmap for cmr83 char#50 2 --- */
      {  50, 1982,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x96\x88\xa4\x0f" }  },
      /* --- pixel bitmap for cmr83 char#51 3 --- */
      {  51, 2007,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x44\x21\x06\xa3\x03" }  },
      /* --- pixel bitmap for cmr83 char#52 4 --- */
      {  52, 2032,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcc\xad\x8f\x10\x07" }  },
      /* --- pixel bitmap for cmr83 char#53 5 --- */
      {  53, 2055,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x17\x71\x98\x06" }  },
      /* --- pixel bitmap for cmr83 char#54 6 --- */
      {  54, 2078,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4c\x84\x17\xa3\x03" }  },
      /* --- pixel bitmap for cmr83 char#55 7 --- */
      {  55, 2103,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9f\x24\x22\x02" }  },
      /* --- pixel bitmap for cmr83 char#56 8 --- */
      {  56, 2126,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x44\x29\x17\xa3\x03" }  },
      /* --- pixel bitmap for cmr83 char#57 9 --- */
      {  57, 2155,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\x46\x0f\x91\x01" }  },
      /* --- pixel bitmap for cmr83 char#58 : --- */
      {  58, 2903,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  1,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x11" }  },
      /* --- pixel bitmap for cmr83 char#59 ; --- */
      {  59, 2916,                      /* character number, location */
          5, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  1,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x71" }  },
      /* --- pixel bitmap for cmr83 char#60 (noname) --- */
      {  60, 2608,                      /* character number, location */
          6, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  1,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf9" }  },
      /* --- pixel bitmap for cmr83 char#61 = --- */
      {  61, 2933,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    5, 3, 6, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\xf2\x66" }  },
      /* --- pixel bitmap for cmr83 char#62 (noname) --- */
      {  62, 2265,                      /* character number, location */
          6, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  4,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\x20\x22\x79" }  },
      /* --- pixel bitmap for cmr83 char#63 ? --- */
      {  63, 2242,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x96\x24\x02\x20" }  },
      /* --- pixel bitmap for cmr83 char#64 @ --- */
      {  64, 2946,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x37\xcf\xf3\xec\xf3" }  },
      /* --- pixel bitmap for cmr83 char#65 A --- */
      {  65,   35,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x18\x18\x3c\x24\x3c\x24\xe7" }  },
      /* --- pixel bitmap for cmr83 char#66 B --- */
      {  66,   64,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9f\x28\xfa\xb2\x28\x7e" }  },
      /* --- pixel bitmap for cmr83 char#67 C --- */
      {  67,   97,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\xc6\x10\xa2\x64" }  },
      /* --- pixel bitmap for cmr83 char#68 D --- */
      {  68,  128,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\x91\x50\x28\x14\x8a\x7e" }  },
      /* --- pixel bitmap for cmr83 char#69 E --- */
      {  69,  163,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\x91\xcc\x23\x15\x0a\xff" }  },
      /* --- pixel bitmap for cmr83 char#70 F --- */
      {  70,  198,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbf\xa8\x3a\x8a\x20\x1c" }  },
      /* --- pixel bitmap for cmr83 char#71 G --- */
      {  71,  229,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x51\x28\x10\x0f\x89\x78" }  },
      /* --- pixel bitmap for cmr83 char#72 H --- */
      {  72,  262,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe7\x42\x42\x7e\x42\x42\x42\xe7" }  },
      /* --- pixel bitmap for cmr83 char#73 I --- */
      {  73,  299,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  3,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x97\x24\xe9" }  },
      /* --- pixel bitmap for cmr83 char#74 J --- */
      {  74,  322,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4e\x44\x44\x75" }  },
      /* --- pixel bitmap for cmr83 char#75 K --- */
      {  75,  347,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf7\x32\x1a\x0e\x16\x12\x22\xe7" }  },
      /* --- pixel bitmap for cmr83 char#76 L --- */
      {  76,  384,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x87\x20\x08\xa2\x28\xfe" }  },
      /* --- pixel bitmap for cmr83 char#77 M --- */
      {  77,  413,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x87\x1b\x66\x98\x52\x4a\xc9\x24\xd3\xed" }  },
      /* --- pixel bitmap for cmr83 char#78 N --- */
      {  78,  466,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe3\x46\x4a\x4a\x52\x72\x62\x47" }  },
      /* --- pixel bitmap for cmr83 char#79 O --- */
      {  79,  511,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x14\x86\x61\x28\x31" }  },
      /* --- pixel bitmap for cmr83 char#80 P --- */
      {  80,  546,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9f\x28\x8a\x9e\x20\x1c" }  },
      /* --- pixel bitmap for cmr83 char#81 Q --- */
      {  81,  575,                      /* character number, location */
          8, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x14\x86\x61\xe8\x31\x00\x0c" }  },
      /* --- pixel bitmap for cmr83 char#82 R --- */
      {  82,  612,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f\x91\xc8\x23\x12\x89\xce" }  },
      /* --- pixel bitmap for cmr83 char#83 S --- */
      {  83,  647,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x56\x31\x8c\x79" }  },
      /* --- pixel bitmap for cmr83 char#84 T --- */
      {  84,  674,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x64\x12\x81\x40\x20\x38" }  },
      /* --- pixel bitmap for cmr83 char#85 U --- */
      {  85,  705,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe7\x42\x42\x42\x42\x42\x42\x3c" }  },
      /* --- pixel bitmap for cmr83 char#86 V --- */
      {  86,  742,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe7\x42\x24\x24\x24\x18\x18\x18" }  },
      /* --- pixel bitmap for cmr83 char#87 W --- */
      {  87,  775,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x77\x17\x11\x55\xa8\x42\x15\xaa\x20\x02\x11" }  },
      /* --- pixel bitmap for cmr83 char#88 X --- */
      {  88,  834,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x67\x24\x18\x18\x18\x34\x24\xe7" }  },
      /* --- pixel bitmap for cmr83 char#89 Y --- */
      {  89,  867,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe7\x24\x28\x38\x10\x10\x10\x38" }  },
      /* --- pixel bitmap for cmr83 char#90 Z --- */
      {  90,  896,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2f\x15\x22\x65\xfc" }  },
      /* --- pixel bitmap for cmr83 char#91 [ --- */
      {  91, 2977,                      /* character number, location */
          9, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  2,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x57\x55\xd5" }  },
      /* --- pixel bitmap for cmr83 char#92 (noname) --- */
      {  92, 3431,                      /* character number, location */
          8, 2,    5, 2,      /* topleft row,col, and botleft row,col */
          {  3,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6d\x01" }  },
      /* --- pixel bitmap for cmr83 char#93 ] --- */
      {  93, 3008,                      /* character number, location */
          9, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  2,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xab\xaa\xea" }  },
      /* --- pixel bitmap for cmr83 char#94 \^ --- */
      {  94, 3155,                      /* character number, location */
          8, 1,    6, 1,      /* topleft row,col, and botleft row,col */
          {  3,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2a" }  },
      /* --- pixel bitmap for cmr83 char#95 (noname) --- */
      {  95, 3168,                      /* character number, location */
          9, 1,    8, 1,      /* topleft row,col, and botleft row,col */
          {  1,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01" }  },
      /* --- pixel bitmap for cmr83 char#96 (noname) --- */
      {  96, 3039,                      /* character number, location */
          8, 1,    5, 1,      /* topleft row,col, and botleft row,col */
          {  1,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07" }  },
      /* --- pixel bitmap for cmr83 char#97 a --- */
      {  97,  929,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc6\xa5\xec\x01" }  },
      /* --- pixel bitmap for cmr83 char#98 b --- */
      {  98,  950,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x43\x08\x27\xa5\x74" }  },
      /* --- pixel bitmap for cmr83 char#99 c --- */
      {  99,  979,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\x91\x06" }  },
      /* --- pixel bitmap for cmr83 char#100 d --- */
      { 100,  998,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x21\x97\x52\xf2" }  },
      /* --- pixel bitmap for cmr83 char#101 e --- */
      { 101, 1027,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf6\x91\x06" }  },
      /* --- pixel bitmap for cmr83 char#102 f --- */
      { 102, 1046,                      /* character number, location */
          8,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x98\x90\x47\x08\x71" }  },
      /* --- pixel bitmap for cmr83 char#103 g --- */
      { 103, 1069,                      /* character number, location */
          5, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\xa5\xe3\x62\x74" }  },
      /* --- pixel bitmap for cmr83 char#104 h --- */
      { 104, 1100,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x43\x08\xa7\x94\xfa" }  },
      /* --- pixel bitmap for cmr83 char#105 i --- */
      { 105, 1129,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  3,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\x30\x49\x07" }  },
      /* --- pixel bitmap for cmr83 char#106 j --- */
      { 106, 1150,                      /* character number, location */
          9,-1,   -2,-1,      /* topleft row,col, and botleft row,col */
          {  3,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x60\x92\xe4\x01" }  },
      /* --- pixel bitmap for cmr83 char#107 k --- */
      { 107, 1175,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x23\xe2\x66\xb6" }  },
      /* --- pixel bitmap for cmr83 char#108 l --- */
      { 108, 1200,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  3,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x93\x24\xe9" }  },
      /* --- pixel bitmap for cmr83 char#109 m --- */
      { 109, 1223,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x24\x49\x92\x74\x1b" }  },
      /* --- pixel bitmap for cmr83 char#110 n --- */
      { 110, 1256,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4f\x29\xf5\x01" }  },
      /* --- pixel bitmap for cmr83 char#111 o --- */
      { 111, 1279,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\xc6\xe8\x00" }  },
      /* --- pixel bitmap for cmr83 char#112 p --- */
      { 112, 1302,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4f\x4a\xe9\xc4\x01" }  },
      /* --- pixel bitmap for cmr83 char#113 q --- */
      { 113, 1329,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\xa5\xe4\x10\x07" }  },
      /* --- pixel bitmap for cmr83 char#114 r --- */
      { 114, 1356,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  3,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x97\x74" }  },
      /* --- pixel bitmap for cmr83 char#115 s --- */
      { 115, 1373,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x56\x96\x07" }  },
      /* --- pixel bitmap for cmr83 char#116 t --- */
      { 116, 1394,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  3,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xd2\x64\x1b" }  },
      /* --- pixel bitmap for cmr83 char#117 u --- */
      { 117, 1415,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4f\x29\xe5\x01" }  },
      /* --- pixel bitmap for cmr83 char#118 v --- */
      { 118, 1438,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5b\x29\x42\x00" }  },
      /* --- pixel bitmap for cmr83 char#119 w --- */
      { 119, 1461,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6b\x9b\xcd\x46\x01" }  },
      /* --- pixel bitmap for cmr83 char#120 x --- */
      { 120, 1490,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xdb\x10\xb5\x01" }  },
      /* --- pixel bitmap for cmr83 char#121 y --- */
      { 121, 1513,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5b\x29\x42\xc8\x00" }  },
      /* --- pixel bitmap for cmr83 char#122 z --- */
      { 122, 1540,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5f\xaf\x0f" }  },
      /* --- pixel bitmap for cmr83 char#123 (noname) --- */
      { 123, 3450,                      /* character number, location */
          4, 0,    3, 0,      /* topleft row,col, and botleft row,col */
          {  5,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f" }  },
      /* --- pixel bitmap for cmr83 char#124 (noname) --- */
      { 124, 3459,                      /* character number, location */
          4, 0,    3, 0,      /* topleft row,col, and botleft row,col */
          { 10,    1, 3, 2, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0a" }  },
      /* --- pixel bitmap for cmr83 char#125 (noname) --- */
      { 125, 3177,                      /* character number, location */
          8, 1,    6, 1,      /* topleft row,col, and botleft row,col */
          {  3,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2d" }  },
      /* --- pixel bitmap for cmr83 char#126 \~ --- */
      { 126, 3192,                      /* character number, location */
          8, 1,    6, 1,      /* topleft row,col, and botleft row,col */
          {  3,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c" }  },
      /* --- pixel bitmap for cmr83 char#127 (noname) --- */
      { 127, 3203,                      /* character number, location */
          9, 1,    8, 1,      /* topleft row,col, and botleft row,col */
          {  3,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=1 for .100gf ---
 * mf '\mode=preview; mag=magstep(-17.87427405946994351363); input cmr10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmr100 --- */
static	chardef  cmr100[] =
   {
      /* --- pixel bitmap for cmr100 char#0 \Gamma --- */
      {   0,51662,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    9, 3,15, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\xf2\x21\x41\xf3\x21\x55\x36" }  },
      /* --- pixel bitmap for cmr100 char#1 \Delta --- */
      {   1,52527,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\xc0\x80\x04\x12\x84\x18\x26\xd0\xc0\xff\x03" }  },
      /* --- pixel bitmap for cmr100 char#2 \Theta --- */
      {   2,53612,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x8c\x0d\x0e\x98\x33\xe0\x60\x63\x7c\x00" }  },
      /* --- pixel bitmap for cmr100 char#3 \Lambda --- */
      {   3,54508,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\xc0\x00\x03\x12\x48\x20\x41\x08\x21\xcf\x03" }  },
      /* --- pixel bitmap for cmr100 char#4 \Xi --- */
      {   4,55833,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x20\x40\xe4\x13\x01\x82\x7f" }  },
      /* --- pixel bitmap for cmr100 char#5 \Pi --- */
      {   5,56950,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    9, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\xf6\x11\x41\x13\x23" }  },
      /* --- pixel bitmap for cmr100 char#6 \Sigma --- */
      {   6,58027,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\xc3\x86\x8c\x08\x8c\x84\xc2\xff" }  },
      /* --- pixel bitmap for cmr100 char#7 \Upsilon --- */
      {   7,59081,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc6\x52\x02\x80\x00\x01\x02\x04\x08\x7c\x00" }  },
      /* --- pixel bitmap for cmr100 char#8 \Phi --- */
      {   8,60071,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x10\x3c\x91\x91\x91\x3c\x10\x7c" }  },
      /* --- pixel bitmap for cmr100 char#9 \Psi --- */
      {   9,61138,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x20\x4c\x96\x24\xc9\x1a\x1f\x08\x7c\x00" }  },
      /* --- pixel bitmap for cmr100 char#10 \Omega --- */
      {  10,62247,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x42\x81\x81\x81\x42\x42\xa5\xe7" }  },
      /* --- pixel bitmap for cmr100 char#11 \ff --- */
      {  11,105922,                     /* character number, location */
         10,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          { 10,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x13\x41\x04\x11\xff\x11\x41\x04\x11\x44\x18\x03" }  },
      /* --- pixel bitmap for cmr100 char#12 \fi --- */
      {  12,107044,                     /* character number, location */
         10,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x70\x08\x08\x08\x7f\x68\x48\x48\x48\xcc" }  },
      /* --- pixel bitmap for cmr100 char#13 \fl --- */
      {  13,108160,                     /* character number, location */
         10,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x70\x48\x48\x48\x7f\x48\x48\x48\x48\xcc" }  },
      /* --- pixel bitmap for cmr100 char#14 \ffi --- */
      {  14,109727,                     /* character number, location */
         10,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          { 12,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x87\x08\x88\x80\x08\xff\x87\x68\x88\x84\x48\x88"
            "\xc4\xc8" }  },
      /* --- pixel bitmap for cmr100 char#15 \ffl --- */
      {  15,111304,                     /* character number, location */
         10,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          { 12,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x87\x48\x88\x84\x48\xff\x87\x48\x88\x84\x48\x88"
            "\xc4\xc8" }  },
      /* --- pixel bitmap for cmr100 char#16 \imath --- */
      {  16,75438,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  3,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x93\xa4\x03" }  },
      /* --- pixel bitmap for cmr100 char#17 \jmath --- */
      {  17,76102,                      /* character number, location */
          6,-1,   -3,-1,      /* topleft row,col, and botleft row,col */
          {  4,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x88\x88\x88\x07" }  },
      /* --- pixel bitmap for cmr100 char#18 \gravesym --- */
      {  18,97521,                      /* character number, location */
         10, 2,    7, 2,      /* topleft row,col, and botleft row,col */
          {  2,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x29" }  },
      /* --- pixel bitmap for cmr100 char#19 \acutesym --- */
      {  19,98064,                      /* character number, location */
         10, 3,    7, 3,      /* topleft row,col, and botleft row,col */
          {  2,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x16" }  },
      /* --- pixel bitmap for cmr100 char#20 \checksym --- */
      {  20,98663,                      /* character number, location */
          9, 2,    7, 2,      /* topleft row,col, and botleft row,col */
          {  3,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x15" }  },
      /* --- pixel bitmap for cmr100 char#21 \brevesym --- */
      {  21,99253,                      /* character number, location */
         10, 1,    7, 1,      /* topleft row,col, and botleft row,col */
          {  5,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x31\x3a" }  },
      /* --- pixel bitmap for cmr100 char#22 (noname) --- */
      {  22,99807,                      /* character number, location */
          8, 1,    7, 1,      /* topleft row,col, and botleft row,col */
          {  5,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f" }  },
      /* --- pixel bitmap for cmr100 char#23 (noname) --- */
      {  23,100558,                     /* character number, location */
         10, 3,    7, 3,      /* topleft row,col, and botleft row,col */
          {  4,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x96\x06" }  },
      /* --- pixel bitmap for cmr100 char#24 (noname) --- */
      {  24,101220,                     /* character number, location */
          0, 2,   -2, 2,      /* topleft row,col, and botleft row,col */
          {  3,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e" }  },
      /* --- pixel bitmap for cmr100 char#25 \ss --- */
      {  25,77147,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x91\x48\xb4\x11\x09\x85\xc2\x1d" }  },
      /* --- pixel bitmap for cmr100 char#26 \ae --- */
      {  26,78442,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xef\x20\xfa\x8f\x10\xd3\x1d" }  },
      /* --- pixel bitmap for cmr100 char#27 \oe --- */
      {  27,79514,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xdc\x03\x63\xf8\x43\x30\x47\xcf\x01" }  },
      /* --- pixel bitmap for cmr100 char#28 (noname) --- */
      {  28,80280,                      /* character number, location */
          7, 0,   -1, 0,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\xde\x3c\xdb\x3c\x7b\x06" }  },
      /* --- pixel bitmap for cmr100 char#29 \AE --- */
      {  29,82006,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x87\x42\x28\x86\x62\xf8\x43\xa2\x24\x4a\x42\xe7"
            "\x07" }  },
      /* --- pixel bitmap for cmr100 char#30 \OE --- */
      {  30,83642,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xcf\x08\x0d\xb1\x20\x16\x7c\x82\xe8\x10\x35\x42"
            "\xfc\x0f" }  },
      /* --- pixel bitmap for cmr100 char#31 (noname) --- */
      {  31,84560,                      /* character number, location */
         10, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          {  9,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\xf8\x08\x0b\x19\x33\x62\xc6\x84\x86\xf8\x08\x00" }  },
      /* --- pixel bitmap for cmr100 char#32 (noname) --- */
      {  32,101688,                     /* character number, location */
          5, 0,    4, 0,      /* topleft row,col, and botleft row,col */
          {  4,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmr100 char#33 ! --- */
      {  33,85153,                      /* character number, location */
         10, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  1,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\x02" }  },
      /* --- pixel bitmap for cmr100 char#34 " --- */
      {  34,112195,                     /* character number, location */
         10, 0,    6, 0,      /* topleft row,col, and botleft row,col */
          {  4,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x99\x99" }  },
      /* --- pixel bitmap for cmr100 char#35 # --- */
      {  35,86539,                      /* character number, location */
         10, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          { 10,   13, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf3\x41\x31\x1a\x31\x31\x20\xf1\x21\x31\x3a\xf3\x11"
            "\x31\x41" }  },
      /* --- pixel bitmap for cmr100 char#36 $ --- */
      {  36,71874,                      /* character number, location */
         10, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          {  5,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xae\xd6\x62\x18\xad\xd5\x11" }  },
      /* --- pixel bitmap for cmr100 char#37 % --- */
      {  37,87726,                      /* character number, location */
         10, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 10,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\xe5\x93\x48\x12\x26\x40\x06\x25\x92\x44\x12\x29"
            "\x18" }  },
      /* --- pixel bitmap for cmr100 char#38 & --- */
      {  38,73090,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x24\x48\xd0\xe0\xde\xc8\x93\x14\x31\xdd\x01" }  },
      /* --- pixel bitmap for cmr100 char#39 ' --- */
      {  39,88316,                      /* character number, location */
         10, 2,    6, 2,      /* topleft row,col, and botleft row,col */
          {  1,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmr100 char#40 ( --- */
      {  40,88860,                      /* character number, location */
         10, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  3,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x94\x92\x24\x89\x44" }  },
      /* --- pixel bitmap for cmr100 char#41 ) --- */
      {  41,89423,                      /* character number, location */
         10, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  3,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x91\x48\x92\xa4\x14" }  },
      /* --- pixel bitmap for cmr100 char#42 * --- */
      {  42,90010,                      /* character number, location */
         10, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          {  5,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa4\x3a\x57\x09" }  },
      /* --- pixel bitmap for cmr100 char#43 + --- */
      {  43,90660,                      /* character number, location */
          8, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 3,11, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf3\x41\x49\xf3\x41\x43" }  },
      /* --- pixel bitmap for cmr100 char#44 (noname) --- */
      {  44,91207,                      /* character number, location */
          1, 2,   -3, 2,      /* topleft row,col, and botleft row,col */
          {  1,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmr100 char#45 (noname) --- */
      {  45,112664,                     /* character number, location */
          4, 0,    3, 0,      /* topleft row,col, and botleft row,col */
          {  4,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmr100 char#46 (noname) --- */
      {  46,91642,                      /* character number, location */
          1, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  1,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01" }  },
      /* --- pixel bitmap for cmr100 char#47 / --- */
      {  47,92120,                      /* character number, location */
         10, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  5,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x22\x84\x08\x21\x42\x88\x10\x00" }  },
      /* --- pixel bitmap for cmr100 char#48 0 --- */
      {  48,62917,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\xc6\x18\x63\x8c\x0e" }  },
      /* --- pixel bitmap for cmr100 char#49 1 --- */
      {  49,63645,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe4\x10\x42\x08\x21\x1f" }  },
      /* --- pixel bitmap for cmr100 char#50 2 --- */
      {  50,64578,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\x46\x08\x11\x91\x1f" }  },
      /* --- pixel bitmap for cmr100 char#51 3 --- */
      {  51,65566,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\x42\xe8\x60\x8c\x0e" }  },
      /* --- pixel bitmap for cmr100 char#52 4 --- */
      {  52,66442,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x0c\x45\x32\xf9\x43\x20\x38" }  },
      /* --- pixel bitmap for cmr100 char#53 5 --- */
      {  53,67430,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\x84\x17\x61\x8c\x0e" }  },
      /* --- pixel bitmap for cmr100 char#54 6 --- */
      {  54,68274,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\x84\x17\x63\x94\x0e" }  },
      /* --- pixel bitmap for cmr100 char#55 7 --- */
      {  55,69122,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7f\x08\x21\x08\x41\x10\x04" }  },
      /* --- pixel bitmap for cmr100 char#56 8 --- */
      {  56,69996,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\x46\xe5\x62\x8c\x0e" }  },
      /* --- pixel bitmap for cmr100 char#57 9 --- */
      {  57,70846,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\xc5\x18\x3d\x44\x07" }  },
      /* --- pixel bitmap for cmr100 char#58 : --- */
      {  58,92666,                      /* character number, location */
          6, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  1,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x21" }  },
      /* --- pixel bitmap for cmr100 char#59 ; --- */
      {  59,93299,                      /* character number, location */
          6, 2,   -3, 2,      /* topleft row,col, and botleft row,col */
          {  1,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe1\x01" }  },
      /* --- pixel bitmap for cmr100 char#60 (noname) --- */
      {  60,85729,                      /* character number, location */
          7, 2,   -3, 2,      /* topleft row,col, and botleft row,col */
          {  1,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x03" }  },
      /* --- pixel bitmap for cmr100 char#61 = --- */
      {  61,93943,                      /* character number, location */
          6, 1,    1, 1,      /* topleft row,col, and botleft row,col */
          {  9,    5, 3, 6, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x09\xf2\x99" }  },
      /* --- pixel bitmap for cmr100 char#62 (noname) --- */
      {  62,74897,                      /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  5,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x00\x40\x88\x08\xd1\x01" }  },
      /* --- pixel bitmap for cmr100 char#63 ? --- */
      {  63,73999,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\x42\x44\x08\x00\x80\x00" }  },
      /* --- pixel bitmap for cmr100 char#64 @ --- */
      {  64,95087,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x8c\xe9\x2a\x5a\xb4\x68\x51\x7d\x06\xf0\x03" }  },
      /* --- pixel bitmap for cmr100 char#65 A --- */
      {  65, 1000,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\xc0\x00\x03\x12\x48\xe0\x41\x08\x21\xcf\x03" }  },
      /* --- pixel bitmap for cmr100 char#66 B --- */
      {  66, 2276,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7f\xc2\x82\xc2\x7e\x82\x82\xc2\x7f" }  },
      /* --- pixel bitmap for cmr100 char#67 C --- */
      {  67, 3151,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\xc2\x82\x01\x01\x01\x82\x82\x7c" }  },
      /* --- pixel bitmap for cmr100 char#68 D --- */
      {  68, 4209,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    9, 3,21, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x41\x51\x10\xf4\x21\x61\x21\x51\x18\x21" }  },
      /* --- pixel bitmap for cmr100 char#69 E --- */
      {  69, 5552,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7f\x42\x52\x52\x1e\x92\x92\x42\x7f" }  },
      /* --- pixel bitmap for cmr100 char#70 F --- */
      {  70, 6759,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7f\xa1\x54\xea\x91\x48\x04\x0f" }  },
      /* --- pixel bitmap for cmr100 char#71 G --- */
      {  71, 7882,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\x84\x09\x0a\x10\x3e\x90\x20\x41\xfc\x00" }  },
      /* --- pixel bitmap for cmr100 char#72 H --- */
      {  72, 8999,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe7\x42\x42\x42\x7e\x42\x42\x42\xe7" }  },
      /* --- pixel bitmap for cmr100 char#73 I --- */
      {  73, 9620,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    9, 3, 8, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\xf6\x21\x25" }  },
      /* --- pixel bitmap for cmr100 char#74 J --- */
      {  74,10380,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\x21\x84\x10\x4a\x07" }  },
      /* --- pixel bitmap for cmr100 char#75 K --- */
      {  75,11511,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xdf\x13\x43\x06\x0d\x3c\x30\x41\x04\x21\xdf\x03" }  },
      /* --- pixel bitmap for cmr100 char#76 L --- */
      {  76,12404,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f\x04\x04\x04\x04\x84\x84\xc4\xff" }  },
      /* --- pixel bitmap for cmr100 char#77 M --- */
      {  77,13636,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\x9e\xc1\x30\x18\x8a\x42\x51\x48\x09\x29\x21\x25"
            "\x5f\x1f" }  },
      /* --- pixel bitmap for cmr100 char#78 N --- */
      {  78,14698,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe3\x46\x46\x4a\x5a\x52\x62\x62\x47" }  },
      /* --- pixel bitmap for cmr100 char#79 O --- */
      {  79,15501,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x8c\x05\x0c\x18\x30\xe0\x60\x63\x7c\x00" }  },
      /* --- pixel bitmap for cmr100 char#80 P --- */
      {  80,16558,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\xa1\x50\xe8\x13\x08\x04\x07" }  },
      /* --- pixel bitmap for cmr100 char#81 Q --- */
      {  81,17531,                      /* character number, location */
          9, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  9,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x8c\x0d\x0e\x18\x30\xe0\x60\x6f\x7c\x00\x00\x01"
            "\x04" }  },
      /* --- pixel bitmap for cmr100 char#82 R --- */
      {  82,18764,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\x84\x08\x11\xe2\x43\x84\x08\x11\xe7\x01" }  },
      /* --- pixel bitmap for cmr100 char#83 S --- */
      {  83,19757,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7e\x18\x0c\x1c\x08\x86\x1f" }  },
      /* --- pixel bitmap for cmr100 char#84 T --- */
      {  84,20785,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    9, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0a\x0f\x21\x41\x31\xf3\x51\x40\x35\x21" }  },
      /* --- pixel bitmap for cmr100 char#85 U --- */
      {  85,21725,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    9, 3,15, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x03\x23\xf6\x11\x41\x10\x24\x20" }  },
      /* --- pixel bitmap for cmr100 char#86 V --- */
      {  86,22663,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcf\x13\x42\x08\x12\x48\x20\x01\x03\x0c\x30\x00" }  },
      /* --- pixel bitmap for cmr100 char#87 W --- */
      {  87,24012,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcf\x3d\x31\x42\x8c\x90\x24\x24\x09\x4a\x81\x61\x60"
            "\x18\x10\x02" }  },
      /* --- pixel bitmap for cmr100 char#88 X --- */
      {  88,25057,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcf\x31\x81\x06\x0c\x30\xc0\x80\x04\x21\xcf\x03" }  },
      /* --- pixel bitmap for cmr100 char#89 Y --- */
      {  89,26149,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcf\x13\x82\x0c\x14\x30\x80\x00\x02\x08\x70\x00" }  },
      /* --- pixel bitmap for cmr100 char#90 Z --- */
      {  90,27142,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x14\x25\x0c\x29\xca\x3f" }  },
      /* --- pixel bitmap for cmr100 char#91 [ --- */
      {  91,95760,                      /* character number, location */
         10, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  3,   13, 3, 8, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x03\x0f\xa1\x23" }  },
      /* --- pixel bitmap for cmr100 char#92 (noname) --- */
      {  92,113505,                     /* character number, location */
         10, 3,    6, 3,      /* topleft row,col, and botleft row,col */
          {  4,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x99\x99" }  },
      /* --- pixel bitmap for cmr100 char#93 ] --- */
      {  93,96408,                      /* character number, location */
         10, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  3,   13, 3, 8, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x03\xfa\x21\x03" }  },
      /* --- pixel bitmap for cmr100 char#94 \^ --- */
      {  94,102285,                     /* character number, location */
         10, 2,    8, 2,      /* topleft row,col, and botleft row,col */
          {  3,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2a" }  },
      /* --- pixel bitmap for cmr100 char#95 (noname) --- */
      {  95,102722,                     /* character number, location */
         10, 2,    9, 2,      /* topleft row,col, and botleft row,col */
          {  1,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01" }  },
      /* --- pixel bitmap for cmr100 char#96 (noname) --- */
      {  96,96976,                      /* character number, location */
         10, 2,    6, 2,      /* topleft row,col, and botleft row,col */
          {  1,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmr100 char#97 a --- */
      {  97,28238,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\xe4\x45\xb1\x0f" }  },
      /* --- pixel bitmap for cmr100 char#98 b --- */
      {  98,29194,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x83\x20\x08\x9e\x28\x8a\xa2\x07" }  },
      /* --- pixel bitmap for cmr100 char#99 c --- */
      {  99,29921,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\x84\x10\x1d" }  },
      /* --- pixel bitmap for cmr100 char#100 d --- */
      { 100,30876,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x04\x41\x5e\x14\x45\x91\x0f" }  },
      /* --- pixel bitmap for cmr100 char#101 e --- */
      { 101,31588,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\xf8\x07\x23\x07" }  },
      /* --- pixel bitmap for cmr100 char#102 f --- */
      { 102,32397,                      /* character number, location */
         10,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x41\x10\x1f\x41\x10\x84\x03" }  },
      /* --- pixel bitmap for cmr100 char#103 g --- */
      { 103,33592,                      /* character number, location */
          6, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x89\xc4\x21\xf0\x05\x83\x63\x0e" }  },
      /* --- pixel bitmap for cmr100 char#104 h --- */
      { 104,34521,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x83\x20\x08\x8e\x24\x49\xd2\x0d" }  },
      /* --- pixel bitmap for cmr100 char#105 i --- */
      { 105,35164,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  3,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\x30\x49\x3a" }  },
      /* --- pixel bitmap for cmr100 char#106 j --- */
      { 106,35922,                      /* character number, location */
         10,-1,   -3,-1,      /* topleft row,col, and botleft row,col */
          {  4,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x00\x8c\x88\x88\x88\x07" }  },
      /* --- pixel bitmap for cmr100 char#107 k --- */
      { 107,36998,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x03\x81\x40\xa0\x57\x38\x14\x92\x3b" }  },
      /* --- pixel bitmap for cmr100 char#108 l --- */
      { 108,37547,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  3,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x93\x24\x49\x3a" }  },
      /* --- pixel bitmap for cmr100 char#109 m --- */
      { 109,38846,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xdf\x11\x91\x88\x44\x24\xa2\x33\x03" }  },
      /* --- pixel bitmap for cmr100 char#110 n --- */
      { 110,39779,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8f\x24\x49\xd2\x0d" }  },
      /* --- pixel bitmap for cmr100 char#111 o --- */
      { 111,40432,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x71\x30\x38\xe6\x00" }  },
      /* --- pixel bitmap for cmr100 char#112 p --- */
      { 112,41456,                      /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9f\x28\x8a\xa2\x27\x08\x07" }  },
      /* --- pixel bitmap for cmr100 char#113 q --- */
      { 113,42438,                      /* character number, location */
          6, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x51\x28\x24\xe3\x81\x40\x70" }  },
      /* --- pixel bitmap for cmr100 char#114 r --- */
      { 114,43249,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5f\x08\x21\x0e" }  },
      /* --- pixel bitmap for cmr100 char#115 s --- */
      { 115,44144,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\x19\x1c\x1f" }  },
      /* --- pixel bitmap for cmr100 char#116 t --- */
      { 116,44927,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x22\xf2\x22\xaa\x04" }  },
      /* --- pixel bitmap for cmr100 char#117 u --- */
      { 117,45812,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9b\x24\x49\x12\x0f" }  },
      /* --- pixel bitmap for cmr100 char#118 v --- */
      { 118,46660,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x77\x11\x85\x42\x41\x00" }  },
      /* --- pixel bitmap for cmr100 char#119 w --- */
      { 119,47871,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x37\xcb\xc4\x0c\x33\xcc\x30\x03" }  },
      /* --- pixel bitmap for cmr100 char#120 x --- */
      { 120,48812,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x77\x0a\x02\x41\xb9\x03" }  },
      /* --- pixel bitmap for cmr100 char#121 y --- */
      { 121,49861,                      /* character number, location */
          6, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x77\x19\x85\xc2\x41\x20\x08\x07" }  },
      /* --- pixel bitmap for cmr100 char#122 z --- */
      { 122,50776,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x39\x2b\x3f" }  },
      /* --- pixel bitmap for cmr100 char#123 (noname) --- */
      { 123,114079,                     /* character number, location */
          4, 0,    3, 0,      /* topleft row,col, and botleft row,col */
          {  7,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7f" }  },
      /* --- pixel bitmap for cmr100 char#124 (noname) --- */
      { 124,114873,                     /* character number, location */
          4, 0,    3, 0,      /* topleft row,col, and botleft row,col */
          { 14,    1, 3, 2, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e" }  },
      /* --- pixel bitmap for cmr100 char#125 (noname) --- */
      { 125,103371,                     /* character number, location */
         10, 2,    7, 2,      /* topleft row,col, and botleft row,col */
          {  4,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5a\x05" }  },
      /* --- pixel bitmap for cmr100 char#126 \~ --- */
      { 126,104025,                     /* character number, location */
          9, 1,    7, 1,      /* topleft row,col, and botleft row,col */
          {  5,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb6\x01" }  },
      /* --- pixel bitmap for cmr100 char#127 (noname) --- */
      { 127,104678,                     /* character number, location */
         10, 2,    9, 2,      /* topleft row,col, and botleft row,col */
          {  3,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=2 for .118gf ---
 * mf '\mode=preview; mag=magstep(-16.96645799324018499600); input cmr10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmr118 --- */
static	chardef  cmr118[] =
   {
      /* --- pixel bitmap for cmr118 char#0 \Gamma --- */
      {   0,52128,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,   11, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x09\x21\x42\xf1\x21\x51\xf5\x21\x65\x41" }  },
      /* --- pixel bitmap for cmr118 char#1 \Delta --- */
      {   1,52997,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\x00\x06\x90\x00\x09\x08\x81\x10\x04\x42\x20\x02"
            "\x34\xc0\xff\x0f" }  },
      /* --- pixel bitmap for cmr118 char#2 \Theta --- */
      {   2,54090,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x20\x88\x80\x02\x98\xc8\x7c\x26\x32\x80\x02\x22"
            "\x08\x3e\x00" }  },
      /* --- pixel bitmap for cmr118 char#3 \Lambda --- */
      {   3,55002,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x00\x01\x14\xa0\x00\x05\x44\x20\x02\x11\x04\x21"
            "\xc8\xe3\x01" }  },
      /* --- pixel bitmap for cmr118 char#4 \Xi --- */
      {   4,56337,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x03\x02\x00\x20\xc8\x9f\x20\x00\x01\x03\xfe\x07" }  },
      /* --- pixel bitmap for cmr118 char#5 \Pi --- */
      {   5,57458,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   11, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\xf8\x21\x61\x25\x25" }  },
      /* --- pixel bitmap for cmr118 char#6 \Sigma --- */
      {   6,58543,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x0f\x6c\x20\x81\x08\x40\x80\x00\x83\x04\x0a\xfc"
            "\x3f" }  },
      /* --- pixel bitmap for cmr118 char#7 \Upsilon --- */
      {   7,59601,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 3,25, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x13\x33\x11\x31\x11\x31\xf1\xb0\xf5\x51\x50\x35\x31" }  },
      /* --- pixel bitmap for cmr118 char#8 \Phi --- */
      {   8,60593,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x80\x00\x02\x3f\x23\x87\x38\x32\x3f\x20\x80\x80"
            "\x0f" }  },
      /* --- pixel bitmap for cmr118 char#9 \Psi --- */
      {   9,61664,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x00\xc1\x88\x45\x24\x22\x11\x91\x04\x1f\x20\x00"
            "\x01\x3e\x00" }  },
      /* --- pixel bitmap for cmr118 char#10 \Omega --- */
      {  10,62781,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x08\x14\x60\x80\x01\x06\x28\x10\x21\x85\x2a\xe5"
            "\x1c" }  },
      /* --- pixel bitmap for cmr118 char#11 \ff --- */
      {  11,107078,                     /* character number, location */
         11,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          { 12,   11, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x57\x32\x31\x30\xf1\x31\x41\x3b\x10\xf4\x31\x41\x30"
            "\x22\x43\x11" }  },
      /* --- pixel bitmap for cmr118 char#12 \fi --- */
      {  12,108204,                     /* character number, location */
         11,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  9,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x10\x20\x40\xf0\x0f\x19\x22\x44\x88\x10\x31\x06" }  },
      /* --- pixel bitmap for cmr118 char#13 \fl --- */
      {  13,109324,                     /* character number, location */
         11,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  9,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x10\x21\x42\xf4\x0f\x11\x22\x44\x88\x10\x31\x06" }  },
      /* --- pixel bitmap for cmr118 char#14 \ffi --- */
      {  14,110895,                     /* character number, location */
         11,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          { 14,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x1f\x46\x80\x10\x20\x04\xff\x1f\x42\x86\x10\x21"
            "\x44\x08\x11\x42\xc4\x10\x03" }  },
      /* --- pixel bitmap for cmr118 char#15 \ffl --- */
      {  15,112478,                     /* character number, location */
         11,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          { 14,   11, 3,38, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x58\x42\x31\x31\x10\xf1\x31\x41\x31\x1d\x10\xf4\x31"
            "\x41\x31\x10\x23\x23\x13" }  },
      /* --- pixel bitmap for cmr118 char#16 \imath --- */
      {  16,76126,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  3,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x93\x24\x1d" }  },
      /* --- pixel bitmap for cmr118 char#17 \jmath --- */
      {  17,76792,                      /* character number, location */
          7,-1,   -3,-1,      /* topleft row,col, and botleft row,col */
          {  4,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x88\x88\x88\x78" }  },
      /* --- pixel bitmap for cmr118 char#18 \gravesym --- */
      {  18,98621,                      /* character number, location */
         11, 2,    8, 2,      /* topleft row,col, and botleft row,col */
          {  3,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x11\x01" }  },
      /* --- pixel bitmap for cmr118 char#19 \acutesym --- */
      {  19,99164,                      /* character number, location */
         11, 3,    8, 3,      /* topleft row,col, and botleft row,col */
          {  3,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x54\x00" }  },
      /* --- pixel bitmap for cmr118 char#20 \checksym --- */
      {  20,99763,                      /* character number, location */
         10, 2,    9, 2,      /* topleft row,col, and botleft row,col */
          {  4,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmr118 char#21 \brevesym --- */
      {  21,100349,                     /* character number, location */
         11, 1,    8, 1,      /* topleft row,col, and botleft row,col */
          {  6,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe1\xec\x01" }  },
      /* --- pixel bitmap for cmr118 char#22 (noname) --- */
      {  22,100903,                     /* character number, location */
          9, 1,    8, 1,      /* topleft row,col, and botleft row,col */
          {  6,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f" }  },
      /* --- pixel bitmap for cmr118 char#23 (noname) --- */
      {  23,101654,                     /* character number, location */
         11, 4,    8, 4,      /* topleft row,col, and botleft row,col */
          {  4,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x96\x06" }  },
      /* --- pixel bitmap for cmr118 char#24 (noname) --- */
      {  24,102316,                     /* character number, location */
          0, 2,   -3, 2,      /* topleft row,col, and botleft row,col */
          {  4,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\x0f" }  },
      /* --- pixel bitmap for cmr118 char#25 \ss --- */
      {  25,77839,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x91\x48\xb4\x11\x09\x85\x42\xe1\x0e" }  },
      /* --- pixel bitmap for cmr118 char#26 \ae --- */
      {  26,79138,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9f\x03\x23\xff\x45\x10\x82\x30\x7a\x0e" }  },
      /* --- pixel bitmap for cmr118 char#27 \oe --- */
      {  27,80214,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x27\xc5\xe1\x1f\x02\x21\x20\x85\x8c\x07" }  },
      /* --- pixel bitmap for cmr118 char#28 (noname) --- */
      {  28,80990,                      /* character number, location */
          9, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  6,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\xe4\x69\x69\x5b\x5a\x9e\x10\x00" }  },
      /* --- pixel bitmap for cmr118 char#29 \AE --- */
      {  29,82726,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x3f\x50\x18\x28\x08\x12\x05\x89\x80\x7f\x20\x22"
            "\x11\x91\x88\x20\x42\xd0\xf3\x0f" }  },
      /* --- pixel bitmap for cmr118 char#30 \OE --- */
      {  30,84376,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x7f\x84\x61\x82\x41\x81\x51\x01\x11\x01\x1f\x01"
            "\x91\x83\x91\x82\x41\x8c\x41\xf8\x7f" }  },
      /* --- pixel bitmap for cmr118 char#31 (noname) --- */
      {  31,85308,                      /* character number, location */
         12, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 11,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\xc2\x0f\x61\x04\x15\xc4\x20\x86\x30\x82\x11\x54"
            "\x10\x43\xf8\x21\x00" }  },
      /* --- pixel bitmap for cmr118 char#32 (noname) --- */
      {  32,102812,                     /* character number, location */
          6, 0,    5, 0,      /* topleft row,col, and botleft row,col */
          {  5,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f" }  },
      /* --- pixel bitmap for cmr118 char#33 ! --- */
      {  33,85939,                      /* character number, location */
         11, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  2,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x0f\x3c" }  },
      /* --- pixel bitmap for cmr118 char#34 " --- */
      {  34,113375,                     /* character number, location */
         11, 1,    6, 1,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7b\x4b\x99\x00" }  },
      /* --- pixel bitmap for cmr118 char#35 # --- */
      {  35,87355,                      /* character number, location */
         11, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          { 12,   14, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf3\x51\x31\x2c\xf2\x41\x31\x3c\xf1\x31\x31\x40\xf2"
            "\x21\x31\x51" }  },
      /* --- pixel bitmap for cmr118 char#36 $ --- */
      {  36,72494,                      /* character number, location */
         12, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          {  6,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x88\x97\xa6\x89\xc2\xa1\x69\x9a\x39\x08" }  },
      /* --- pixel bitmap for cmr118 char#37 % --- */
      {  37,88546,                      /* character number, location */
         12, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 12,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\xa4\x31\xf1\x12\x11\x91\xa0\x04\x4e\x07\x52\x90"
            "\x88\x88\x88\x48\x50\x02\x07" }  },
      /* --- pixel bitmap for cmr118 char#38 & --- */
      {  38,73718,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x20\x01\x09\x68\xc0\x79\x86\x38\x22\x12\x71\x18"
            "\xa3\xe7\x00" }  },
      /* --- pixel bitmap for cmr118 char#39 ' --- */
      {  39,89180,                      /* character number, location */
         11, 2,    6, 2,      /* topleft row,col, and botleft row,col */
          {  2,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xaf\x01" }  },
      /* --- pixel bitmap for cmr118 char#40 ( --- */
      {  40,89726,                      /* character number, location */
         12, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  4,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x48\x22\x11\x11\x11\x21\x42\x08" }  },
      /* --- pixel bitmap for cmr118 char#41 ) --- */
      {  41,90293,                      /* character number, location */
         12, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  4,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x21\x44\x88\x88\x88\x48\x24\x01" }  },
      /* --- pixel bitmap for cmr118 char#42 * --- */
      {  42,90884,                      /* character number, location */
         12, 1,    5, 1,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\xb2\x33\x3b\x82\x00" }  },
      /* --- pixel bitmap for cmr118 char#43 + --- */
      {  43,91532,                      /* character number, location */
         10, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 3,11, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf4\x51\x5b\xf4\x51\x52" }  },
      /* --- pixel bitmap for cmr118 char#44 (noname) --- */
      {  44,92109,                      /* character number, location */
          2, 2,   -3, 2,      /* topleft row,col, and botleft row,col */
          {  2,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xaf\x01" }  },
      /* --- pixel bitmap for cmr118 char#45 (noname) --- */
      {  45,113848,                     /* character number, location */
          4, 0,    3, 0,      /* topleft row,col, and botleft row,col */
          {  4,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmr118 char#46 (noname) --- */
      {  46,92572,                      /* character number, location */
          2, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  2,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmr118 char#47 / --- */
      {  47,93052,                      /* character number, location */
         12, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  6,   16, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x08\x41\x10\x82\x20\x04\x41\x08\x82\x10\x04" }  },
      /* --- pixel bitmap for cmr118 char#48 0 --- */
      {  48,63463,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x14\x86\x61\x18\x86\xa1\xc4\x00" }  },
      /* --- pixel bitmap for cmr118 char#49 1 --- */
      {  49,64199,                      /* character number, location */
         11, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  5,   11, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x21\x23\x20\xf7\x21\x25" }  },
      /* --- pixel bitmap for cmr118 char#50 2 --- */
      {  50,65136,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4e\x14\x86\x20\x04\x21\xa4\xf8\x03" }  },
      /* --- pixel bitmap for cmr118 char#51 3 --- */
      {  51,66132,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x18\x82\x10\x07\x81\x61\xe4\x00" }  },
      /* --- pixel bitmap for cmr118 char#52 4 --- */
      {  52,67014,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x30\x28\x24\x22\x23\xff\x20\x20\x20\xf8" }  },
      /* --- pixel bitmap for cmr118 char#53 5 --- */
      {  53,68008,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe1\x17\x04\xcd\x04\x82\x61\xe4\x00" }  },
      /* --- pixel bitmap for cmr118 char#54 6 --- */
      {  54,68860,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x28\x04\xcd\x14\x86\xa1\xc4\x00" }  },
      /* --- pixel bitmap for cmr118 char#55 7 --- */
      {  55,69718,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x81\x7f\x30\x04\x81\x20\x10\x04\x02\x81\x00" }  },
      /* --- pixel bitmap for cmr118 char#56 8 --- */
      {  56,70600,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x18\x86\x9e\x33\x85\x61\xe8\x01" }  },
      /* --- pixel bitmap for cmr118 char#57 9 --- */
      {  57,71456,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x14\x86\xa1\xcc\x82\x50\xe4\x00" }  },
      /* --- pixel bitmap for cmr118 char#58 : --- */
      {  58,93630,                      /* character number, location */
          7, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  2,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\x3c" }  },
      /* --- pixel bitmap for cmr118 char#59 ; --- */
      {  59,94293,                      /* character number, location */
          7, 2,   -3, 2,      /* topleft row,col, and botleft row,col */
          {  2,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\xbc\x06" }  },
      /* --- pixel bitmap for cmr118 char#60 (noname) --- */
      {  60,86543,                      /* character number, location */
          8, 2,   -3, 2,      /* topleft row,col, and botleft row,col */
          {  2,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\xfc\x3f" }  },
      /* --- pixel bitmap for cmr118 char#61 = --- */
      {  61,94941,                      /* character number, location */
          7, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          { 11,    5, 3, 6, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0b\xf2\xbb" }  },
      /* --- pixel bitmap for cmr118 char#62 (noname) --- */
      {  62,75531,                      /* character number, location */
          8, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  6,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x03\x00\x00\x43\x18\x41\xe8\x01" }  },
      /* --- pixel bitmap for cmr118 char#63 ? --- */
      {  63,74631,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x08\x62\x08\x03\x00\x00\xc3\x00" }  },
      /* --- pixel bitmap for cmr118 char#64 @ --- */
      {  64,96085,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x20\x88\x9c\x12\x5b\xd0\x82\x16\x34\xb1\x72\x23"
            "\x00\xfe\x01" }  },
      /* --- pixel bitmap for cmr118 char#65 A --- */
      {  65, 1000,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   11, 3,32, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf2\x52\x50\xf2\x41\x21\x40\x31\x41\x66\x61\x41\x51"
            "\x61\x25\x25" }  },
      /* --- pixel bitmap for cmr118 char#66 B --- */
      {  66, 2284,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x21\x10\x01\x09\x48\x30\xfe\x11\x98\x80\x04\x24"
            "\xd0\x7f\x00" }  },
      /* --- pixel bitmap for cmr118 char#67 C --- */
      {  67, 3167,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x12\x2c\x60\x80\x01\x04\x10\x40\x80\x02\x12\x84"
            "\x0f" }  },
      /* --- pixel bitmap for cmr118 char#68 D --- */
      {  68, 4233,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,   11, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x51\x51\x41\x61\x10\xf4\x21\x71\x21\x61\x31\x52"
            "\x18\x31" }  },
      /* --- pixel bitmap for cmr118 char#69 E --- */
      {  69, 5584,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x23\x18\x81\x88\x44\x04\x3e\x10\x91\x88\x04\x22"
            "\xd8\xff\x00" }  },
      /* --- pixel bitmap for cmr118 char#70 F --- */
      {  70, 6797,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x13\x4c\x20\xa1\x84\xf0\x43\x08\x21\x04\x10\xf0"
            "\x01" }  },
      /* --- pixel bitmap for cmr118 char#71 G --- */
      {  71, 7924,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x22\x98\x80\x02\x14\x80\x00\x04\x3e\x40\x02\x22"
            "\x10\xfe\x00" }  },
      /* --- pixel bitmap for cmr118 char#72 H --- */
      {  72, 9047,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   11, 3,26, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\x25\xf3\x21\x61\x20\x28\x20\xf3\x21\x61\x25\x25" }  },
      /* --- pixel bitmap for cmr118 char#73 I --- */
      {  73, 9702,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,   11, 3, 8, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\xf8\x21\x25" }  },
      /* --- pixel bitmap for cmr118 char#74 J --- */
      {  74,10466,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   11, 3,13, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x24\xf7\x41\x11\x31\x23\x28" }  },
      /* --- pixel bitmap for cmr118 char#75 K --- */
      {  75,11601,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9f\x4f\x10\x84\x40\x04\x24\x40\x05\x8c\x40\x08\x04"
            "\x41\x20\x1f\x0f" }  },
      /* --- pixel bitmap for cmr118 char#76 L --- */
      {  76,12506,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,   11, 3,20, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\x40\xf4\x21\x60\xf2\x21\x51\x21\x4b" }  },
      /* --- pixel bitmap for cmr118 char#77 M --- */
      {  77,13744,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\x78\x06\x0c\x05\x85\x82\x42\x41\x21\x91\x90\x48"
            "\x88\x22\x44\x11\xa2\xc8\x27\x1f" }  },
      /* --- pixel bitmap for cmr118 char#78 N --- */
      {  78,14826,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x87\xcf\x20\x14\x42\x21\x24\x42\x26\x44\x42\x28\x84"
            "\x42\x30\x1f\x02" }  },
      /* --- pixel bitmap for cmr118 char#79 O --- */
      {  79,15645,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 3,27, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x35\x51\x51\x31\x71\x1f\x41\x91\x11\x71\x31\x51\x55"
            "\x31" }  },
      /* --- pixel bitmap for cmr118 char#80 P --- */
      {  80,16710,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x10\x44\x20\x81\x04\xf1\x43\x00\x01\x04\x10\xf0"
            "\x01" }  },
      /* --- pixel bitmap for cmr118 char#81 Q --- */
      {  81,17689,                      /* character number, location */
         11, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          { 11,   14, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x35\x51\x51\x31\x71\x1f\x41\x91\x11\x23\x21\x31\x11"
            "\x31\x55\xa1\xd1\x82\x11" }  },
      /* --- pixel bitmap for cmr118 char#82 R --- */
      {  82,18934,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x40\x10\x04\x42\x20\x04\xc1\x0f\x84\x41\x10\x04"
            "\x41\x10\x1f\x0e" }  },
      /* --- pixel bitmap for cmr118 char#83 S --- */
      {  83,19935,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x60\x30\x60\xe0\x81\x81\xc1\xd0\x07" }  },
      /* --- pixel bitmap for cmr118 char#84 T --- */
      {  84,20971,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   11, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0a\x0f\x21\x41\x31\xf5\x51\x40\x35\x22" }  },
      /* --- pixel bitmap for cmr118 char#85 U --- */
      {  85,21915,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   11, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\x25\xf7\x21\x61\x20\x31\x41\x74\x42" }  },
      /* --- pixel bitmap for cmr118 char#86 V --- */
      {  86,22861,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\x4f\x20\x04\x82\x10\x08\x01\x09\x90\x00\x09\x60"
            "\x00\x06\x60\x00" }  },
      /* --- pixel bitmap for cmr118 char#87 W --- */
      {  87,24218,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 17,   11, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x34\x24\xf2\x21\x41\x11\x41\x20\xf2\x31\x21\x31"
            "\x21\x30\xf3\x42\x52\x43" }  },
      /* --- pixel bitmap for cmr118 char#88 X --- */
      {  88,25279,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9f\x87\x10\x98\x00\x0d\x60\x00\x06\x70\x00\x09\x08"
            "\xc1\x10\x0f\x0f" }  },
      /* --- pixel bitmap for cmr118 char#89 Y --- */
      {  89,26379,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\xcf\x20\x08\x01\x11\xa0\x00\x0e\x40\x00\x04\x40"
            "\x00\x04\xf0\x01" }  },
      /* --- pixel bitmap for cmr118 char#90 Z --- */
      {  90,27378,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x43\x61\x21\x10\x18\x88\x84\x86\xc2\xff" }  },
      /* --- pixel bitmap for cmr118 char#91 [ --- */
      {  91,96794,                      /* character number, location */
         12, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  4,   16, 3, 8, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x0f\xd1\x34" }  },
      /* --- pixel bitmap for cmr118 char#92 (noname) --- */
      {  92,114689,                     /* character number, location */
         11, 2,    6, 2,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x32\xa5\xbd\x01" }  },
      /* --- pixel bitmap for cmr118 char#93 ] --- */
      {  93,97474,                      /* character number, location */
         12, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          {  4,   16, 3, 8, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\xfd\x31\x04" }  },
      /* --- pixel bitmap for cmr118 char#94 \^ --- */
      {  94,103409,                     /* character number, location */
         11, 2,    9, 2,      /* topleft row,col, and botleft row,col */
          {  4,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x96" }  },
      /* --- pixel bitmap for cmr118 char#95 (noname) --- */
      {  95,103872,                     /* character number, location */
         12, 2,   10, 2,      /* topleft row,col, and botleft row,col */
          {  1,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x03" }  },
      /* --- pixel bitmap for cmr118 char#96 (noname) --- */
      {  96,98074,                      /* character number, location */
         11, 2,    6, 2,      /* topleft row,col, and botleft row,col */
          {  2,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xd6\x03" }  },
      /* --- pixel bitmap for cmr118 char#97 a --- */
      {  97,28480,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\x08\x47\x12\x89\xfa\x00" }  },
      /* --- pixel bitmap for cmr118 char#98 b --- */
      {  98,29442,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x03\x81\x40\xe0\x11\x09\x85\x42\x93\x07" }  },
      /* --- pixel bitmap for cmr118 char#99 c --- */
      {  99,30173,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x10\x04\x81\xc8\x01" }  },
      /* --- pixel bitmap for cmr118 char#100 d --- */
      { 100,31130,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x10\x08\xc4\x13\x85\x42\x21\x19\x1b" }  },
      /* --- pixel bitmap for cmr118 char#101 e --- */
      { 101,31848,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\xfe\x10\xa4\x03" }  },
      /* --- pixel bitmap for cmr118 char#102 f --- */
      { 102,32659,                      /* character number, location */
         11,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  7,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x70\x04\x02\xf1\x43\x20\x10\x08\x04\x0f" }  },
      /* --- pixel bitmap for cmr118 char#103 g --- */
      { 103,33856,                      /* character number, location */
          7, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          {  8,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x22\x22\x22\x1e\x02\x7e\x81\x81\xc3\x3c" }  },
      /* --- pixel bitmap for cmr118 char#104 h --- */
      { 104,34789,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x03\x81\x40\xe0\x11\x89\x44\x22\xd1\x19" }  },
      /* --- pixel bitmap for cmr118 char#105 i --- */
      { 105,35488,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  3,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1b\x80\x49\x92\x0e" }  },
      /* --- pixel bitmap for cmr118 char#106 j --- */
      { 106,36250,                      /* character number, location */
         12,-1,   -3,-1,      /* topleft row,col, and botleft row,col */
          {  4,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcc\x00\xc0\x88\x88\x88\x88\x07" }  },
      /* --- pixel bitmap for cmr118 char#107 k --- */
      { 107,37330,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x03\x02\x02\x02\xf2\x12\x0a\x1e\x12\x22\xe7" }  },
      /* --- pixel bitmap for cmr118 char#108 l --- */
      { 108,37935,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  3,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x93\x24\x49\xd2\x01" }  },
      /* --- pixel bitmap for cmr118 char#109 m --- */
      { 109,39236,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3b\xc7\x18\x09\x21\x21\x24\x84\x84\xd0\x39\x07" }  },
      /* --- pixel bitmap for cmr118 char#110 n --- */
      { 110,40177,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f\x91\x48\x24\x12\x9d\x01" }  },
      /* --- pixel bitmap for cmr118 char#111 o --- */
      { 111,40834,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9e\x14\x86\xa1\xe4\x01" }  },
      /* --- pixel bitmap for cmr118 char#112 p --- */
      { 112,41862,                      /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f\x91\x50\x28\x34\x79\x04\x82\x03" }  },
      /* --- pixel bitmap for cmr118 char#113 q --- */
      { 113,42848,                      /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x51\x28\x14\x92\xb1\x40\x20\x38" }  },
      /* --- pixel bitmap for cmr118 char#114 r --- */
      { 114,43665,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5f\x08\x21\xc4\x01" }  },
      /* --- pixel bitmap for cmr118 char#115 s --- */
      { 115,44562,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9e\x61\x99\x07" }  },
      /* --- pixel bitmap for cmr118 char#116 t --- */
      { 116,45349,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x84\x98\x4f\x08\xa1\x14\x01" }  },
      /* --- pixel bitmap for cmr118 char#117 u --- */
      { 117,46236,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x33\x91\x48\x24\x12\xf1\x01" }  },
      /* --- pixel bitmap for cmr118 char#118 v --- */
      { 118,47088,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xef\x89\x10\x41\x81\x02\x05\x04" }  },
      /* --- pixel bitmap for cmr118 char#119 w --- */
      { 119,48303,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe7\x4e\x26\x94\x42\x29\x94\x82\x19\x08\x01" }  },
      /* --- pixel bitmap for cmr118 char#120 x --- */
      { 120,49260,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe7\xc9\xa0\x80\x80\x82\xc8\x71" }  },
      /* --- pixel bitmap for cmr118 char#121 y --- */
      { 121,50315,                      /* character number, location */
          7, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xef\x89\x10\x41\x81\x02\x05\x04\x08\x08\x0e\x00" }  },
      /* --- pixel bitmap for cmr118 char#122 z --- */
      { 122,51236,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbe\xa4\xb0\xa4\xf8\x03" }  },
      /* --- pixel bitmap for cmr118 char#123 (noname) --- */
      { 123,115267,                     /* character number, location */
          5, 0,    4, 0,      /* topleft row,col, and botleft row,col */
          {  8,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff" }  },
      /* --- pixel bitmap for cmr118 char#124 (noname) --- */
      { 124,116061,                     /* character number, location */
          5, 0,    4, 0,      /* topleft row,col, and botleft row,col */
          { 16,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\xff" }  },
      /* --- pixel bitmap for cmr118 char#125 (noname) --- */
      { 125,104523,                     /* character number, location */
         11, 2,    8, 2,      /* topleft row,col, and botleft row,col */
          {  5,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x32\x25" }  },
      /* --- pixel bitmap for cmr118 char#126 \~ --- */
      { 126,105177,                     /* character number, location */
         11, 1,    9, 1,      /* topleft row,col, and botleft row,col */
          {  6,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x66\x06" }  },
      /* --- pixel bitmap for cmr118 char#127 (noname) --- */
      { 127,105830,                     /* character number, location */
         12, 1,   10, 1,      /* topleft row,col, and botleft row,col */
          {  5,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x52\x02" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=3 for .131gf ---
 * mf '\mode=preview; mag=magstep(-16.39322518098640003469); input cmr10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmr131 --- */
static	chardef  cmr131[] =
   {
      /* --- pixel bitmap for cmr131 char#0 \Gamma --- */
      {   0,53384,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,   12, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0a\x22\x42\xf2\x22\x51\xf5\x22\x66\x41" }  },
      /* --- pixel bitmap for cmr131 char#1 \Delta --- */
      {   1,54283,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x00\x1c\x80\x03\xc8\x00\x19\x10\x06\xc2\x20\x30"
            "\x04\x46\x80\xf9\xbf\xff\x0f" }  },
      /* --- pixel bitmap for cmr131 char#2 \Theta --- */
      {   2,55402,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\xc0\x30\x06\x26\x40\x93\x3c\xcf\xf3\x3c\xc9\x02"
            "\x64\x60\x0c\x03\x0f" }  },
      /* --- pixel bitmap for cmr131 char#3 \Lambda --- */
      {   3,56346,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x80\x03\x1c\xe0\x80\x0f\x64\x20\x83\x39\x84\x21"
            "\x8c\xe1\x9e\x0f" }  },
      /* --- pixel bitmap for cmr131 char#4 \Xi --- */
      {   4,57705,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\xff\x1f\x60\x80\x84\xf0\xc3\x0f\x21\x01\x06\xf8"
            "\xff\xff" }  },
      /* --- pixel bitmap for cmr131 char#5 \Pi --- */
      {   5,58858,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   12, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\xf9\x22\x62\x26\x26" }  },
      /* --- pixel bitmap for cmr131 char#6 \Sigma --- */
      {   6,59973,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x3f\xb0\x03\x39\x88\x41\x18\xc0\x00\x82\x08\x64"
            "\xa0\x81\xff\x0f" }  },
      /* --- pixel bitmap for cmr131 char#7 \Upsilon --- */
      {   7,61063,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   12, 3,25, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x13\x43\x12\x12\x22\x12\x44\x40\xf7\x52\x50\x36\x31" }  },
      /* --- pixel bitmap for cmr131 char#8 \Phi --- */
      {   8,62085,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x01\x03\x18\xf8\x63\xb6\x31\x8f\xd9\x6c\xfc\x01"
            "\x03\x18\xf0\x03" }  },
      /* --- pixel bitmap for cmr131 char#9 \Psi --- */
      {   9,63188,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x01\x06\x67\x6e\x66\x66\x66\x66\x66\xc6\x36\xf8"
            "\x01\x06\x60\x80\x1f" }  },
      /* --- pixel bitmap for cmr131 char#10 \Omega --- */
      {  10,64337,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x30\xd8\x80\x07\x3c\xe0\x01\x0b\xc8\x60\x05\x6d"
            "\xac\xe3\x1c\x07" }  },
      /* --- pixel bitmap for cmr131 char#11 \ff --- */
      {  11,109874,                     /* character number, location */
         13, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   13, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x48\x31\x31\x40\xf2\x21\x41\x4b\x10\xf5\x21\x41\x40"
            "\x12\x43\x21" }  },
      /* --- pixel bitmap for cmr131 char#12 \fi --- */
      {  12,111034,                     /* character number, location */
         13, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x10\x11\x20\x40\xe0\x1f\x31\x42\x84\x08\x11\x22"
            "\x64\x18" }  },
      /* --- pixel bitmap for cmr131 char#13 \fl --- */
      {  13,112188,                     /* character number, location */
         13, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x10\x11\x22\x44\xe8\x1f\x21\x42\x84\x08\x11\x22"
            "\xe4\x1c" }  },
      /* --- pixel bitmap for cmr131 char#14 \ffi --- */
      {  14,113793,                     /* character number, location */
         13, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   13, 3,44, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x44\x14\x41\x32\x31\x10\xf2\x21\x41\x6d\x31\x41\x32"
            "\x10\xf4\x21\x41\x41\x10\x12\x41\x42" }  },
      /* --- pixel bitmap for cmr131 char#15 \ffl --- */
      {  15,115416,                     /* character number, location */
         13, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   13, 3,40, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x44\x14\x41\x41\x31\x10\xf2\x21\x41\x41\x1d\x10\xf5"
            "\x21\x41\x41\x10\x13\x23\x23" }  },
      /* --- pixel bitmap for cmr131 char#16 \imath --- */
      {  16,78056,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  3,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x93\x24\xe9" }  },
      /* --- pixel bitmap for cmr131 char#17 \jmath --- */
      {  17,78724,                      /* character number, location */
          8,-1,   -4,-1,      /* topleft row,col, and botleft row,col */
          {  5,   12, 3, 9, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x23\xf9\x41\x03\x23" }  },
      /* --- pixel bitmap for cmr131 char#18 \gravesym --- */
      {  18,101143,                     /* character number, location */
         13, 2,   10, 2,      /* topleft row,col, and botleft row,col */
          {  3,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x11\x01" }  },
      /* --- pixel bitmap for cmr131 char#19 \acutesym --- */
      {  19,101712,                     /* character number, location */
         13, 3,   10, 3,      /* topleft row,col, and botleft row,col */
          {  4,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x48\x02" }  },
      /* --- pixel bitmap for cmr131 char#20 \checksym --- */
      {  20,102337,                     /* character number, location */
         11, 2,    9, 2,      /* topleft row,col, and botleft row,col */
          {  5,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9b\x00" }  },
      /* --- pixel bitmap for cmr131 char#21 \brevesym --- */
      {  21,102953,                     /* character number, location */
         13, 2,    9, 2,      /* topleft row,col, and botleft row,col */
          {  5,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x31\x6e\x07" }  },
      /* --- pixel bitmap for cmr131 char#22 (noname) --- */
      {  22,103537,                     /* character number, location */
         10, 1,    9, 1,      /* topleft row,col, and botleft row,col */
          {  7,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7f" }  },
      /* --- pixel bitmap for cmr131 char#23 (noname) --- */
      {  23,104314,                     /* character number, location */
         13, 5,   10, 5,      /* topleft row,col, and botleft row,col */
          {  4,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x96\x06" }  },
      /* --- pixel bitmap for cmr131 char#24 (noname) --- */
      {  24,105002,                     /* character number, location */
          0, 3,   -3, 3,      /* topleft row,col, and botleft row,col */
          {  3,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe6\x01" }  },
      /* --- pixel bitmap for cmr131 char#25 \ss --- */
      {  25,79801,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x42\x42\x42\x22\x1b\x62\x42\x82\x82\x82\x92\x63" }  },
      /* --- pixel bitmap for cmr131 char#26 \ae --- */
      {  26,81136,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9e\x07\x46\x20\xc8\xff\x22\x10\x02\x61\xe8\x79" }  },
      /* --- pixel bitmap for cmr131 char#27 \oe --- */
      {  27,82242,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x4f\x14\x05\xc1\xe0\x1f\x04\x82\x80\x28\xe4\x78" }  },
      /* --- pixel bitmap for cmr131 char#28 (noname) --- */
      {  28,83050,                      /* character number, location */
         10, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x10\x4f\x16\x4d\x26\x8b\x26\x8f\x20\x00" }  },
      /* --- pixel bitmap for cmr131 char#29 \AE --- */
      {  29,84818,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x3f\x68\x18\x34\x08\x1b\x84\x8c\x42\x46\xe0\x3f"
            "\x88\x91\xc4\x48\x62\x90\x30\xec\xfc\x07" }  },
      /* --- pixel bitmap for cmr131 char#30 \OE --- */
      {  30,86500,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\xff\x18\x86\x19\x0c\x12\x18\x35\x30\x6a\xe0\xc7"
            "\xc0\x88\x81\x91\x06\x03\x0d\x06\x31\x0c\x83\xff\x07" }  },
      /* --- pixel bitmap for cmr131 char#31 (noname) --- */
      {  31,87464,                      /* character number, location */
         13, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 12,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x02\x2f\x0c\x63\x78\x82\x34\xc4\x43\x3c\xc2\x23"
            "\x2c\x41\x1e\xc6\x30\xf4\x40\x00" }  },
      /* --- pixel bitmap for cmr131 char#32 (noname) --- */
      {  32,105498,                     /* character number, location */
          7, 0,    5, 0,      /* topleft row,col, and botleft row,col */
          {  5,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\x00" }  },
      /* --- pixel bitmap for cmr131 char#33 ! --- */
      {  33,88101,                      /* character number, location */
         13, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  2,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\xff\xc0\x03" }  },
      /* --- pixel bitmap for cmr131 char#34 " --- */
      {  34,116353,                     /* character number, location */
         13, 1,    7, 1,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf3\x2c\x8a\x62\x04" }  },
      /* --- pixel bitmap for cmr131 char#35 # --- */
      {  35,89551,                      /* character number, location */
         13, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 13,   17, 3,39, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf2\x61\x31\x20\xf2\x51\x31\x3d\xf2\x41\x31\x4d\xf2"
            "\x31\x31\x50\xf2\x21\x31\x61" }  },
      /* --- pixel bitmap for cmr131 char#36 $ --- */
      {  36,74366,                      /* character number, location */
         14, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          {  7,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x8e\x2a\x99\x5c\x38\x78\x78\x64\x32\xa9\xe2\x20"
            "\x00" }  },
      /* --- pixel bitmap for cmr131 char#37 % --- */
      {  37,90780,                      /* character number, location */
         14, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 13,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x48\x83\xc4\x9f\x08\x11\x11\x22\x82\x22\x70\x72"
            "\x40\x0a\x24\x82\x44\x88\x88\x10\x11\x14\x81\x03" }  },
      /* --- pixel bitmap for cmr131 char#38 & --- */
      {  38,75624,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x40\x04\x44\x40\x04\x24\x40\xf1\x08\xc2\x10\x12"
            "\x11\x0a\x61\x30\x8e\x1e\x07" }  },
      /* --- pixel bitmap for cmr131 char#39 ' --- */
      {  39,91424,                      /* character number, location */
         13, 2,    7, 2,      /* topleft row,col, and botleft row,col */
          {  2,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xaf\x06" }  },
      /* --- pixel bitmap for cmr131 char#40 ( --- */
      {  40,91998,                      /* character number, location */
         14, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          {  5,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x11\x21\x44\x08\x21\x84\x10\x84\x10\x04\x41" }  },
      /* --- pixel bitmap for cmr131 char#41 ) --- */
      {  41,92599,                      /* character number, location */
         14, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          {  5,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x41\x10\x84\x10\x84\x10\x42\x08\x11\x42\x44\x04" }  },
      /* --- pixel bitmap for cmr131 char#42 * --- */
      {  42,93224,                      /* character number, location */
         14, 1,    6, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\xc4\x9a\xc3\x59\x23\x10" }  },
      /* --- pixel bitmap for cmr131 char#43 + --- */
      {  43,93904,                      /* character number, location */
         11, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          { 12,   13, 3,11, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf5\x61\x5c\xf5\x61\x51" }  },
      /* --- pixel bitmap for cmr131 char#44 (noname) --- */
      {  44,94485,                      /* character number, location */
          2, 2,   -4, 2,      /* topleft row,col, and botleft row,col */
          {  2,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xaf\x06" }  },
      /* --- pixel bitmap for cmr131 char#45 (noname) --- */
      {  45,116856,                     /* character number, location */
          5, 0,    4, 0,      /* topleft row,col, and botleft row,col */
          {  5,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f" }  },
      /* --- pixel bitmap for cmr131 char#46 (noname) --- */
      {  46,94950,                      /* character number, location */
          2, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  2,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmr131 char#47 / --- */
      {  47,95456,                      /* character number, location */
         14, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          {  7,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x20\x08\x04\x82\x40\x20\x08\x04\x82\x40\x20\x08"
            "\x04\x82\x40\x00" }  },
      /* --- pixel bitmap for cmr131 char#48 0 --- */
      {  48,65049,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x23\x31\x31\x1f\x71\x51\x11\x31\x33\x22" }  },
      /* --- pixel bitmap for cmr131 char#49 1 --- */
      {  49,65815,                      /* character number, location */
         12, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  5,   12, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x21\x23\x20\xf8\x21\x25" }  },
      /* --- pixel bitmap for cmr131 char#50 2 --- */
      {  50,66780,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\xd1\x78\x08\x06\x83\x20\x08\xa2\xf0\x0f" }  },
#if 0
      /* --- *unmodified* pixel bitmap for cmr131 char#51 3 --- */
      {  51,67804,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9e\x70\x18\x0c\xe2\xc0\xc0\xe0\x71\xcc\x03" }  },
#else
      /* --- *modified* pixel bitmap for cmr131 char#51 3 --- */
      {  51,67804,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbe\x70\x18\x0c\xe2\xc0\xc0\xe0\x71\xcc\x03" }  },
#endif
      /* --- pixel bitmap for cmr131 char#52 4 --- */
      {  52,68714,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x30\x28\x2c\x24\x22\x23\xff\x20\x20\x20\xf8" }  },
      /* --- pixel bitmap for cmr131 char#53 5 --- */
      {  53,69738,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x22\x8f\x43\x20\xf0\x88\xc0\xe0\x70\xcc\x03" }  },
      /* --- pixel bitmap for cmr131 char#54 6 --- */
      {  54,70616,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\xa2\x20\xd0\x19\x05\x83\x41\xa1\x88\x03" }  },
      /* --- pixel bitmap for cmr131 char#55 7 --- */
      {  55,71504,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\xfe\x82\x41\x20\x10\x10\x10\x08\x08\x08\x08\x08" }  },
#if 0
      /* --- *unmodified* pixel bitmap for cmr131 char#56 8 --- */
      {  56,72414,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x70\x70\xe8\xe2\xe8\xc2\xc1\xa0\x88\x03" }  },
      /* --- *unmodified* pixel bitmap for cmr131 char#57 9 --- */
      {  57,73300,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x51\x28\x18\x14\x73\x81\x40\x50\xc4\x01" }  },
#else
      /* --- *modified* pixel bitmap for cmr131 char#56 8 --- */
      {  56,72414,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x71\x70\xe8\xe2\xe8\xc2\xc1\xa0\x88\x03" }  },
      /* --- *modified* pixel bitmap for cmr131 char#57 9 --- */
      {  57,73300,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x51\x30\x18\x14\x73\x81\x40\x50\xc4\x01" }  },
#endif
      /* --- pixel bitmap for cmr131 char#58 : --- */
      {  58,96040,                      /* character number, location */
          8, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  2,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\xf0" }  },
      /* --- pixel bitmap for cmr131 char#59 ; --- */
      {  59,96703,                      /* character number, location */
          8, 2,   -4, 2,      /* topleft row,col, and botleft row,col */
          {  2,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\xf0\x6a" }  },
      /* --- pixel bitmap for cmr131 char#60 (noname) --- */
      {  60,88709,                      /* character number, location */
          9, 2,   -4, 2,      /* topleft row,col, and botleft row,col */
          {  2,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\xfc\xff\x03" }  },
      /* --- pixel bitmap for cmr131 char#61 = --- */
      {  61,97379,                      /* character number, location */
          7, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          { 12,    5, 3, 6, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\xf2\xcc" }  },
      /* --- pixel bitmap for cmr131 char#62 (noname) --- */
      {  62,77455,                      /* character number, location */
          9, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  7,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x06\x00\x00\x60\x10\x08\x04\x41\x30\xe8\x03" }  },
      /* --- pixel bitmap for cmr131 char#63 ? --- */
      {  63,76549,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbe\x60\x10\x04\x41\x20\x18\x00\x00\x80\xc1\x00" }  },
      /* --- pixel bitmap for cmr131 char#64 @ --- */
      {  64,98549,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\xc0\x30\xf2\xa4\x50\x05\x5a\xa0\x05\x5a\xa0\x05"
            "\xaa\xb0\xf2\xc6\xc0\xf0\x03" }  },
      /* --- pixel bitmap for cmr131 char#65 A --- */
      {  65, 1026,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\x00\x06\x60\x00\x0d\xd0\x80\x1d\x88\x81\x18\xfc"
            "\x43\x30\x04\xf3\xf8" }  },
      /* --- pixel bitmap for cmr131 char#66 B --- */
      {  66, 2314,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\xc1\x30\x0c\xc6\x60\x0c\xc6\x3f\x0c\xc6\xc0\x0c"
            "\xcc\xc0\x0c\xf6\x3f" }  },
      /* --- pixel bitmap for cmr131 char#67 C --- */
      {  67, 3227,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x65\xb0\x01\x05\x38\x80\x01\x0c\x60\x00\x02\x34"
            "\x20\x83\xe0\x03" }  },
      /* --- pixel bitmap for cmr131 char#68 D --- */
      {  68, 4295,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   12, 3,33, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0a\x52\x52\x42\x62\x32\x71\x10\xf4\x22\x72\x22\x62"
            "\x32\x52\x2a\x31" }  },
      /* --- pixel bitmap for cmr131 char#69 E --- */
      {  69, 5676,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\xc7\x60\x0c\xc4\x48\x8c\xc4\x0f\x8c\xc0\x88\x0c"
            "\xc8\x40\x0c\xf6\x7f" }  },
      /* --- pixel bitmap for cmr131 char#70 F --- */
      {  70, 6893,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x63\x18\x83\x18\xc9\x48\x7e\x30\x82\x11\x0c\x60"
            "\x00\x03\x7e\x00" }  },
      /* --- pixel bitmap for cmr131 char#71 G --- */
      {  71, 8050,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\xc5\x60\x06\x24\x40\x03\x30\x00\x83\x3f\x60\x02"
            "\x66\x60\x0c\x06\x5f" }  },
      /* --- pixel bitmap for cmr131 char#72 H --- */
      {  72, 9205,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   12, 3,26, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x26\xf3\x22\x62\x20\x2a\x20\xf4\x22\x62\x26\x26" }  },
      /* --- pixel bitmap for cmr131 char#73 I --- */
      {  73, 9864,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   12, 3, 8, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\xf9\x22\x26" }  },
      /* --- pixel bitmap for cmr131 char#74 J --- */
      {  74,10656,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 3,17, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x25\xf7\x42\x1f\x12\x22\x10\x14\x24" }  },
      /* --- pixel bitmap for cmr131 char#75 K --- */
      {  75,11795,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\x9f\x41\x30\x04\x46\xc0\x04\xd8\x01\x37\x60\x0c"
            "\x8c\x83\x61\x30\x98\x9f\x0f" }  },
      /* --- pixel bitmap for cmr131 char#76 L --- */
      {  76,12728,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,   12, 3,20, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x40\xf5\x22\x60\xf2\x22\x51\x22\x4c" }  },
      /* --- pixel bitmap for cmr131 char#77 M --- */
      {  77,13994,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 17,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f\xf0\x39\xe0\xd0\xa0\xa1\x41\x43\x83\x86\x8c\x0c"
            "\x19\x19\x62\x31\xc4\x62\x88\xc5\x10\x86\xf9\xcc\x0f" }  },
      /* --- pixel bitmap for cmr131 char#78 N --- */
      {  78,15108,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f\x3e\x07\x42\x83\x90\x21\xe4\x08\x31\x42\x98\x10"
            "\x2c\x04\x0f\x81\x43\xc0\x7c\x20" }  },
      /* --- pixel bitmap for cmr131 char#79 O --- */
      {  79,15955,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\xc0\x30\x06\x26\x40\x03\x3c\xc0\x03\x3c\xc0\x02"
            "\x64\x60\x0c\x03\x0f" }  },
      /* --- pixel bitmap for cmr131 char#80 P --- */
      {  80,17050,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,   12, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x09\x42\x42\x10\xf2\x22\x52\x22\x42\x37\x20\xf3\x22"
            "\x76\x52" }  },
      /* --- pixel bitmap for cmr131 char#81 Q --- */
      {  81,18059,                      /* character number, location */
         12, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 12,   16, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\xc0\x30\x06\x26\x40\x03\x3c\xc0\x03\x3c\xc0\x02"
            "\x64\x67\x9c\x03\x0f\x00\x00\x90\x00\x0f\x60" }  },
      /* --- pixel bitmap for cmr131 char#82 R --- */
      {  82,19336,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x81\x61\x30\x18\x06\xc3\x30\xf8\x03\x63\x60\x18"
            "\x0c\x83\x61\x30\xcc\x1f\x0f" }  },
      /* --- pixel bitmap for cmr131 char#83 S --- */
      {  83,20369,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\xc2\x83\x03\x07\x3e\x78\xc0\xc0\xc1\x41\x3f" }  },
      /* --- pixel bitmap for cmr131 char#84 T --- */
      {  84,21435,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   12, 3,23, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0d\x32\x22\x0f\x21\x42\x31\xf5\x52\x40\x28\x11" }  },
      /* --- pixel bitmap for cmr131 char#85 U --- */
      {  85,22411,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   12, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x35\xf8\x22\x71\x20\x32\x51\x85\x40" }  },
      /* --- pixel bitmap for cmr131 char#86 V --- */
      {  86,23387,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\x3e\x03\x82\x41\x60\x10\x30\x02\x8c\x00\x23\x80"
            "\x05\x60\x01\x78\x00\x0c\x00\x03" }  },
      /* --- pixel bitmap for cmr131 char#87 W --- */
      {  87,24789,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 19,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbf\xcf\x67\x30\x08\x87\x61\x30\x1e\x81\xd1\x08\x9c"
            "\x66\xc0\x76\x01\x16\x0b\xf0\x78\x00\xc7\x01\x18\x0c"
            "\xc0\x60\x00" }  },
      /* --- pixel bitmap for cmr131 char#88 X --- */
      {  88,25878,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\x1f\x86\x00\x33\xc0\x05\xe0\x00\x30\x00\x1c\x80"
            "\x06\x30\x03\xc4\x81\x60\x7c\xfc" }  },
      /* --- pixel bitmap for cmr131 char#89 Y --- */
      {  89,27008,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   12, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x35\x23\x52\x52\x51\x72\x31\x83\x12\x92\x11\x50"
            "\xf4\x62\x60\x46\x41" }  },
      /* --- pixel bitmap for cmr131 char#90 Z --- */
      {  90,28037,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x87\x05\x0b\x13\x07\x06\x06\x8e\x0c\x0d\x1a\xfe"
            "\x0f" }  },
      /* --- pixel bitmap for cmr131 char#91 [ --- */
      {  91,99276,                      /* character number, location */
         14, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          {  4,   19, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x0f\xe1\x3f\x11\x34" }  },
      /* --- pixel bitmap for cmr131 char#92 (noname) --- */
      {  92,117723,                     /* character number, location */
         13, 2,    7, 2,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x62\x14\x45\xf3\x0c" }  },
      /* --- pixel bitmap for cmr131 char#93 ] --- */
      {  93,99962,                      /* character number, location */
         14, 0,   -5, 0,      /* topleft row,col, and botleft row,col */
          {  4,   19, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\xfe\x31\xf1\x31\x04" }  },
      /* --- pixel bitmap for cmr131 char#94 \^ --- */
      {  94,106123,                     /* character number, location */
         13, 2,   10, 2,      /* topleft row,col, and botleft row,col */
          {  5,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x44\x45" }  },
      /* --- pixel bitmap for cmr131 char#95 (noname) --- */
      {  95,106590,                     /* character number, location */
         13, 2,   11, 2,      /* topleft row,col, and botleft row,col */
          {  1,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x03" }  },
      /* --- pixel bitmap for cmr131 char#96 (noname) --- */
      {  96,100568,                     /* character number, location */
         13, 2,    7, 2,      /* topleft row,col, and botleft row,col */
          {  2,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x56\x0f" }  },
      /* --- pixel bitmap for cmr131 char#97 a --- */
      {  97,29169,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\x20\x20\x3e\x21\xa1\xa1\x7e" }  },
      /* --- pixel bitmap for cmr131 char#98 b --- */
      {  98,30161,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x03\x02\x02\x02\x02\x3a\x46\x82\x82\x82\x82\x46\x3a" }  },
      /* --- pixel bitmap for cmr131 char#99 c --- */
      {  99,30928,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x41\x20\x10\x08\x08\x79" }  },
      /* --- pixel bitmap for cmr131 char#100 d --- */
      { 100,31913,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\x40\x40\x40\x40\x5c\x62\x41\x41\x41\x41\x62\xdc" }  },
      /* --- pixel bitmap for cmr131 char#101 e --- */
      { 101,32665,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x18\xfe\x41\x20\x72" }  },
      /* --- pixel bitmap for cmr131 char#102 f --- */
      { 102,33480,                      /* character number, location */
         13, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,   13, 3,17, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x34\xf3\x21\x46\x10\xf5\x21\x45\x21" }  },
      /* --- pixel bitmap for cmr131 char#103 g --- */
      { 103,34707,                      /* character number, location */
          8, 0,   -5, 0,      /* topleft row,col, and botleft row,col */
          {  9,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xcd\x08\x11\x42\x42\x83\x00\x3f\x81\x02\x06\x14"
            "\xc4\x07" }  },
      /* --- pixel bitmap for cmr131 char#104 h --- */
      { 104,35676,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x03\x02\x02\x02\x02\x3a\x46\x42\x42\x42\x42\x42\xe7" }  },
      /* --- pixel bitmap for cmr131 char#105 i --- */
      { 105,36383,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  3,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1b\x80\x49\x92\x74" }  },
      /* --- pixel bitmap for cmr131 char#106 j --- */
      { 106,37147,                      /* character number, location */
         13,-1,   -4,-1,      /* topleft row,col, and botleft row,col */
          {  5,   17, 3,17, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x32\xf2\x50\x23\xf9\x41\x03\x23" }  },
      /* --- pixel bitmap for cmr131 char#107 k --- */
      { 107,38231,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x03\x04\x08\x10\x20\x40\x9e\x0c\x0d\x1e\x2c\x88\x10"
            "\x72\x1e" }  },
      /* --- pixel bitmap for cmr131 char#108 l --- */
      { 108,38842,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  3,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x93\x24\x49\x92\x74" }  },
      /* --- pixel bitmap for cmr131 char#109 m --- */
      { 109,40147,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3b\xc7\x18\x09\x21\x21\x24\x84\x84\x90\x10\x3a\xe7" }  },
      /* --- pixel bitmap for cmr131 char#110 n --- */
      { 110,41120,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3b\x46\x42\x42\x42\x42\x42\xe7" }  },
      /* --- pixel bitmap for cmr131 char#111 o --- */
      { 111,41809,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x51\x30\x18\x0c\x8a\x38" }  },
      /* --- pixel bitmap for cmr131 char#112 p --- */
      { 112,42867,                      /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  8,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3b\x46\x82\x82\x82\x82\x46\x3a\x02\x02\x02\x07" }  },
      /* --- pixel bitmap for cmr131 char#113 q --- */
      { 113,43863,                      /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 10,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\x08\x13\x48\x20\x81\x04\x22\x0c\x2f\x80\x00\x02"
            "\x08\xf8" }  },
      /* --- pixel bitmap for cmr131 char#114 r --- */
      { 114,44714,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9b\x2d\x08\x82\x20\x3c" }  },
      /* --- pixel bitmap for cmr131 char#115 s --- */
      { 115,45643,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\x46\x83\x63\x7c" }  },
      /* --- pixel bitmap for cmr131 char#116 t --- */
      { 116,46460,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x61\xfc\x04\x41\x10\x24\x89\x01" }  },
      /* --- pixel bitmap for cmr131 char#117 u --- */
      { 117,47375,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x63\x42\x42\x42\x42\x42\x62\xdc" }  },
      /* --- pixel bitmap for cmr131 char#118 v --- */
      { 118,48233,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcf\x13\x42\x08\x12\x48\xc0\x00\x03\x0c" }  },
      /* --- pixel bitmap for cmr131 char#119 w --- */
      { 119,49489,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe7\x9e\x88\x90\x12\x52\x82\x2a\x50\x05\xc6\x80\x08" }  },
      /* --- pixel bitmap for cmr131 char#120 x --- */
      { 120,50454,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcf\x13\x81\x04\x0c\x30\x20\x41\xc8\xf3" }  },
      /* --- pixel bitmap for cmr131 char#121 y --- */
      { 121,51511,                      /* character number, location */
          8, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          { 10,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcf\x13\x42\x08\x12\x48\xe0\x01\x03\x0c\x10\x40\x90"
            "\xc0\x03" }  },
      /* --- pixel bitmap for cmr131 char#122 z --- */
      { 122,52462,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7f\x94\x25\xa4\x29\xfe" }  },
      /* --- pixel bitmap for cmr131 char#123 (noname) --- */
      { 123,118331,                     /* character number, location */
          5, 0,    4, 0,      /* topleft row,col, and botleft row,col */
          {  9,    1, 3, 2, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x09" }  },
      /* --- pixel bitmap for cmr131 char#124 (noname) --- */
      { 124,119151,                     /* character number, location */
          5, 0,    4, 0,      /* topleft row,col, and botleft row,col */
          { 18,    1, 3, 4, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x04" }  },
      /* --- pixel bitmap for cmr131 char#125 (noname) --- */
      { 125,107267,                     /* character number, location */
         13, 2,   10, 2,      /* topleft row,col, and botleft row,col */
          {  6,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa4\xb4\x01" }  },
      /* --- pixel bitmap for cmr131 char#126 \~ --- */
      { 126,107947,                     /* character number, location */
         12, 2,   10, 2,      /* topleft row,col, and botleft row,col */
          {  5,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb6\x01" }  },
      /* --- pixel bitmap for cmr131 char#127 (noname) --- */
      { 127,108626,                     /* character number, location */
         13, 2,   11, 2,      /* topleft row,col, and botleft row,col */
          {  5,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7b\x03" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=4 for .160gf ---
 * mf '\mode=preview; mag=magstep(-15.29639112828755784636); input cmr10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmr160 --- */
static	chardef  cmr160[] =
   {
      /* --- pixel bitmap for cmr160 char#0 \Gamma --- */
      {   0,53842,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   15, 3,25, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0b\x32\x52\x32\x61\x10\xf1\x22\x71\xf8\x22\x87\x51" }  },
      /* --- pixel bitmap for cmr160 char#1 \Delta --- */
      {   1,54747,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   15, 3,56, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x72\x70\xf1\x61\x12\x60\xf1\x51\x32\x50\xf1\x41"
            "\x52\x40\xf1\x31\x72\x30\xf1\x21\x92\x20\x11\xb2\x2e"
            "\x1e\x02" }  },
      /* --- pixel bitmap for cmr160 char#2 \Theta --- */
      {   2,55880,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x03\x0c\x06\x03\xc6\x00\x66\x00\x9b\x20\xcf\x9f"
            "\xe7\xcf\x13\xe4\x01\xb0\x01\xcc\x00\xc6\x80\xc1\x60"
            "\x80\x0f\x00" }  },
      /* --- pixel bitmap for cmr160 char#3 \Lambda --- */
      {   3,56836,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   15, 3,38, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x61\x60\xf2\x53\x50\xf2\x41\x22\x40\xf2\x31\x42"
            "\x30\xf2\x21\x62\x25\x26" }  },
      /* --- pixel bitmap for cmr160 char#4 \Xi --- */
      {   4,58207,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   15, 3,42, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x0d\x0f\x11\xb1\xe0\x11\x71\x20\xf1\x29\x20\x21"
            "\x71\x20\xf1\xdf\x11\xb1\x0f\x1d" }  },
      /* --- pixel bitmap for cmr160 char#5 \Pi --- */
      {   5,59364,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,14, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x01\xfc\x22\x72\x26\x36" }  },
      /* --- pixel bitmap for cmr160 char#6 \Sigma --- */
      {   6,60491,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   15, 3,51, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0d\x13\x82\x23\x81\x32\x91\x32\x81\x33\xc3\x70\xf1"
            "\x52\x70\x51\xc1\x81\x31\x91\x21\x91\x22\x82\x1d\x10" }  },
      /* --- pixel bitmap for cmr160 char#7 \Upsilon --- */
      {   7,61587,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,27, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x14\x54\x16\x37\x51\x21\x41\x63\x60\xf9\x72\x60\x48"
            "\x32" }  },
      /* --- pixel bitmap for cmr160 char#8 \Phi --- */
      {   8,62617,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x07\x30\x00\x0c\xc0\x0f\xcc\x8c\x31\x36\x0c\x0f"
            "\xc3\xc3\xb0\x31\xc6\xcc\xc0\x0f\xc0\x00\x30\x80\x7f"
            "\x00" }  },
      /* --- pixel bitmap for cmr160 char#9 \Psi --- */
      {   9,63738,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,55, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x48\x30\xf1\x72\x63\x42\x33\x13\x32\x23\x10\xf3\x22"
            "\x32\x22\x20\x32\x22\x12\x72\x15\x85\x50\xf1\x72\x60"
            "\x48\x38" }  },
      /* --- pixel bitmap for cmr160 char#10 \Omega --- */
      {  10,64899,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x03\x03\x63\x80\x0d\xc0\x03\xf0\x00\x3c\x00\x0b"
            "\x40\x06\x18\x01\xc2\xc0\x24\x90\x19\xa6\x87\xe7\xe1"
            "\x01" }  },
      /* --- pixel bitmap for cmr160 char#11 \ff --- */
      {  11,110754,                     /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\x14\x42\x33\x22\xf2\x22\x42\x5d\x20\xf7\x22\x42"
            "\x54\x44\x31" }  },
      /* --- pixel bitmap for cmr160 char#12 \fi --- */
      {  12,111926,                     /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   15, 3,34, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\x62\x41\x42\x51\x20\xf1\x22\x8a\x42\x24\x20\xf6"
            "\x22\x42\x24\x44" }  },
      /* --- pixel bitmap for cmr160 char#13 \fl --- */
      {  13,113090,                     /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   15, 3,28, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x46\x52\x32\x20\xf2\x22\x42\x2a\x20\xf7\x22\x42\x25"
            "\x25" }  },
      /* --- pixel bitmap for cmr160 char#14 \ffi --- */
      {  14,114703,                     /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 18,   15, 3,50, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\x15\x62\x42\x41\x42\x42\x51\x20\xf1\x22\x42\x8e"
            "\x02\x42\x42\x24\x20\xf6\x22\x42\x42\x24\x42\x44" }  },
      /* --- pixel bitmap for cmr160 char#15 \ffl --- */
      {  15,116340,                     /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 18,   15, 3,38, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4c\x52\x33\x32\x20\xf2\x22\x42\x42\x2e\x02\x20\xf7"
            "\x22\x42\x42\x25\x24\x25" }  },
      /* --- pixel bitmap for cmr160 char#16 \imath --- */
      {  16,78730,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,   10, 3,10, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x20\xf7\x22\x26" }  },
      /* --- pixel bitmap for cmr160 char#17 \jmath --- */
      {  17,79402,                      /* character number, location */
         10,-2,   -4,-2,      /* topleft row,col, and botleft row,col */
          {  7,   14, 3,11, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x34\xfa\x52\x02\x28\x22" }  },
      /* --- pixel bitmap for cmr160 char#18 \gravesym --- */
      {  18,102013,                     /* character number, location */
         15, 2,   12, 2,      /* topleft row,col, and botleft row,col */
          {  4,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x73\x0c" }  },
      /* --- pixel bitmap for cmr160 char#19 \acutesym --- */
      {  19,102582,                     /* character number, location */
         15, 4,   12, 4,      /* topleft row,col, and botleft row,col */
          {  5,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x98\x1b" }  },
      /* --- pixel bitmap for cmr160 char#20 \checksym --- */
      {  20,103207,                     /* character number, location */
         14, 3,   12, 3,      /* topleft row,col, and botleft row,col */
          {  5,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xdb\x01" }  },
      /* --- pixel bitmap for cmr160 char#21 \brevesym --- */
      {  21,103823,                     /* character number, location */
         15, 2,   11, 2,      /* topleft row,col, and botleft row,col */
          {  7,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc1\xa0\x88\x03" }  },
      /* --- pixel bitmap for cmr160 char#22 (noname) --- */
      {  22,104407,                     /* character number, location */
         13, 2,   12, 2,      /* topleft row,col, and botleft row,col */
          {  7,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7f" }  },
      /* --- pixel bitmap for cmr160 char#23 (noname) --- */
      {  23,105184,                     /* character number, location */
         15, 6,   12, 6,      /* topleft row,col, and botleft row,col */
          {  5,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\x3a" }  },
      /* --- pixel bitmap for cmr160 char#24 (noname) --- */
      {  24,105872,                     /* character number, location */
          0, 3,   -4, 3,      /* topleft row,col, and botleft row,col */
          {  5,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\xe3\x0f" }  },
      /* --- pixel bitmap for cmr160 char#25 \ss --- */
      {  25,80485,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x20\xc4\x30\xc3\x8c\xbd\xc3\x08\x63\x0c\x33\xcc"
            "\x30\xc3\x4c\x33\xf7\x0c" }  },
      /* --- pixel bitmap for cmr160 char#26 \ae --- */
      {  26,81828,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x8f\x79\x06\x0c\x03\xc3\xf8\xbf\x31\x30\x0c\x0c"
            "\x03\xc3\x21\x8f\x07" }  },
      /* --- pixel bitmap for cmr160 char#27 \oe --- */
      {  27,82944,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x1e\xe3\x99\x60\x78\x30\x3c\xf8\x1f\x0c\x0c\x06"
            "\x04\x03\xc6\x43\x1c\x1e" }  },
      /* --- pixel bitmap for cmr160 char#28 (noname) --- */
      {  28,83758,                      /* character number, location */
         12, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x00\xe1\x31\x26\x6a\xf4\xe4\xc9\x8b\x15\x19\xe3"
            "\x21\x40\x00" }  },
      /* --- pixel bitmap for cmr160 char#29 \AE --- */
      {  29,85538,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\xff\x01\x0d\x06\x32\x10\xc8\x80\x20\x43\xc2\x0c"
            "\x01\x31\x06\xfc\x1f\x10\x63\x20\x0c\x89\x30\x24\xc2"
            "\xc0\x04\x03\x11\x0c\xf6\xfd\x1f" }  },
      /* --- pixel bitmap for cmr160 char#30 \OE --- */
      {  30,87238,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 20,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\xff\x87\xe1\x60\x0c\x0c\x64\xc0\x80\x06\x0c\x39"
            "\xc0\x10\x03\x8c\x31\xc0\x1f\x03\x8c\x31\xc0\x90\x06"
            "\x0c\x69\xc0\xc0\x0c\x0c\x84\xe1\x60\xe0\xff\x07" }  },
      /* --- pixel bitmap for cmr160 char#31 (noname) --- */
      {  31,88220,                      /* character number, location */
         16, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 15,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x10\xf0\x0d\x06\x83\x81\x63\x60\x13\x10\x0d\x84"
            "\x07\xc2\x83\xe0\x21\xf0\x10\x58\x04\x64\x03\xe3\xc0"
            "\x60\x30\xd8\x07\x04\x00" }  },
      /* --- pixel bitmap for cmr160 char#32 (noname) --- */
      {  32,106370,                     /* character number, location */
          9, 0,    6, 0,      /* topleft row,col, and botleft row,col */
          {  6,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb0\x13\x00" }  },
      /* --- pixel bitmap for cmr160 char#33 ! --- */
      {  33,88875,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  2,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\xff\x03\x3c" }  },
      /* --- pixel bitmap for cmr160 char#34 " --- */
      {  34,117287,                     /* character number, location */
         15, 1,    9, 1,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf3\x2c\x8a\x51\x04" }  },
      /* --- pixel bitmap for cmr160 char#35 # --- */
      {  35,90329,                      /* character number, location */
         15, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 16,   19, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf2\x71\x41\x30\xf2\x61\x41\x4e\x02\xf4\x51\x41\x5e"
            "\x02\xf2\x41\x41\x60\xf2\x31\x41\x72" }  },
      /* --- pixel bitmap for cmr160 char#36 $ --- */
      {  36,75008,                      /* character number, location */
         17, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          {  9,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x20\xf0\x91\x14\x31\x72\xe4\x09\x3e\xf8\x40\x83"
            "\x3c\x71\x62\x44\x49\x3c\x20\x00" }  },
      /* --- pixel bitmap for cmr160 char#37 % --- */
      {  37,91566,                      /* character number, location */
         17, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 16,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x20\x16\x10\x63\x1c\xa3\x0b\x23\x04\x23\x04\x23"
            "\x02\x23\x01\x16\x01\x8c\x30\x80\x48\x40\x8c\x20\x8c"
            "\x20\x8c\x10\x8c\x08\x8c\x08\x48\x04\x30" }  },
      /* --- pixel bitmap for cmr160 char#38 & --- */
      {  38,76282,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x70\x00\x44\x00\x23\x80\x11\xc0\x04\x60\xe3\xf3\x60"
            "\x30\x10\x3c\x04\x1b\xc2\x98\x60\x5c\x30\x1c\x34\x1e"
            "\xf3\xf8\x00" }  },
      /* --- pixel bitmap for cmr160 char#39 ' --- */
      {  39,92232,                      /* character number, location */
         15, 2,    9, 2,      /* topleft row,col, and botleft row,col */
          {  2,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xaf\x05" }  },
      /* --- pixel bitmap for cmr160 char#40 ( --- */
      {  40,92806,                      /* character number, location */
         17, 2,   -6, 2,      /* topleft row,col, and botleft row,col */
          {  6,   23, 3,34, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x51\x41\x41\x42\x41\x42\x41\x4f\x82\x40\x11\x52\x51"
            "\x52\x51\x61\x61" }  },
      /* --- pixel bitmap for cmr160 char#41 ) --- */
      {  41,93415,                      /* character number, location */
         17, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          {  6,   23, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x81\x40\x30\x08\x06\xc1\x30\x0c\xc3\x30\x0c\xc3\x10"
            "\x86\x30\x84\x10\x00" }  },
      /* --- pixel bitmap for cmr160 char#42 * --- */
      {  42,94048,                      /* character number, location */
         17, 1,    7, 1,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x20\x48\xba\xce\x87\xcf\x75\x49\x10\x20\x00" }  },
      /* --- pixel bitmap for cmr160 char#43 + --- */
      {  43,94740,                      /* character number, location */
         13, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,13, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf6\x71\x7e\x01\xf6\x71\x73" }  },
      /* --- pixel bitmap for cmr160 char#44 (noname) --- */
      {  44,95325,                      /* character number, location */
          2, 2,   -4, 2,      /* topleft row,col, and botleft row,col */
          {  2,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xaf\x05" }  },
      /* --- pixel bitmap for cmr160 char#45 (noname) --- */
      {  45,117790,                     /* character number, location */
          6, 0,    4, 0,      /* topleft row,col, and botleft row,col */
          {  6,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x0f" }  },
      /* --- pixel bitmap for cmr160 char#46 (noname) --- */
      {  46,95790,                      /* character number, location */
          2, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  2,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmr160 char#47 / --- */
      {  47,96296,                      /* character number, location */
         17, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          {  9,   23, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x81\xf2\x71\x10\xf1\x61\x20\xf2\x51\x30\xf2\x41"
            "\x40\xf2\x31\x50\xf1\x21\x60\xf2\x11\x7f\x11\x81" }  },
      /* --- pixel bitmap for cmr160 char#48 0 --- */
      {  48,65623,                      /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 3,27, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x33\x42\x32\x21\x51\x1f\x72\x52\x11\x51\x22\x32\x35"
            "\x21" }  },
      /* --- pixel bitmap for cmr160 char#49 1 --- */
      {  49,66397,                      /* character number, location */
         14, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  7,   14, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x41\x25\x20\xfa\x32\x27" }  },
      /* --- pixel bitmap for cmr160 char#50 2 --- */
      {  50,67366,                      /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x84\x05\x1e\x0c\x18\x30\x30\x20\x20\x20\x20\x24"
            "\xe8\xef\x1f" }  },
      /* --- pixel bitmap for cmr160 char#51 3 --- */
      {  51,68394,                      /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x84\x18\x03\x06\x0c\x0c\x1e\x60\x80\x01\x0f\x1e"
            "\x2c\x8c\x0f" }  },
      /* --- pixel bitmap for cmr160 char#52 4 --- */
      {  52,69310,                      /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\xc0\xc0\x41\x83\x86\x8c\x98\x31\xff\xc1\x80\x01"
            "\x03\x06\x3f" }  },
      /* --- pixel bitmap for cmr160 char#53 5 --- */
      {  53,70338,                      /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x82\xfc\xe8\x10\x20\x40\x8f\x31\xc1\x80\x01\x0f\x1e"
            "\x24\x8c\x07" }  },
      /* --- pixel bitmap for cmr160 char#54 6 --- */
      {  54,71228,                      /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x18\x1b\x36\x30\x60\xcf\xb1\xc1\x83\x07\x0f\x16"
            "\x44\x0c\x07" }  },
      /* --- pixel bitmap for cmr160 char#55 7 --- */
      {  55,72124,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\xf8\xef\x7f\x40\x81\x00\x01\x02\x08\x30\x40\x00"
            "\x01\x06\x18\x60\x80\x01" }  },
      /* --- pixel bitmap for cmr160 char#56 8 --- */
      {  56,73038,                      /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x88\x18\x33\x66\x8c\x0f\x0e\x7a\xc2\x07\x0f\x1e"
            "\x6c\x8c\x0f" }  },
      /* --- pixel bitmap for cmr160 char#57 9 --- */
      {  57,73932,                      /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x8c\x08\x1a\x3c\x78\xf0\x60\xe3\xbc\x01\x03\x1a"
            "\x36\xc6\x03" }  },
      /* --- pixel bitmap for cmr160 char#58 : --- */
      {  58,96888,                      /* character number, location */
         10, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  2,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\x00\x0f" }  },
      /* --- pixel bitmap for cmr160 char#59 ; --- */
      {  59,97551,                      /* character number, location */
         10, 2,   -4, 2,      /* topleft row,col, and botleft row,col */
          {  2,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\x00\xaf\x05" }  },
      /* --- pixel bitmap for cmr160 char#60 (noname) --- */
      {  60,89485,                      /* character number, location */
         11, 2,   -4, 2,      /* topleft row,col, and botleft row,col */
          {  2,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\xf0\xff\x3f" }  },
      /* --- pixel bitmap for cmr160 char#61 = --- */
      {  61,98227,                      /* character number, location */
          9, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          { 15,    7, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x01\xf4\xe0\x1e\x01" }  },
      /* --- pixel bitmap for cmr160 char#62 (noname) --- */
      {  62,78127,                      /* character number, location */
         11, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  8,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x18\x00\x00\x00\x00\x18\x08\x08\x0c\x06\x03\xc3"
            "\xc3\x3c" }  },
      /* --- pixel bitmap for cmr160 char#63 ? --- */
      {  63,77219,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\xc3\xc3\xc0\x60\x30\x10\x10\x18\x00\x00\x00\x00"
            "\x18\x18" }  },
      /* --- pixel bitmap for cmr160 char#64 @ --- */
      {  64,99397,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x03\x0c\x06\x01\x44\x38\x24\x23\x8a\x60\x66\x30"
            "\x33\x98\x19\xcc\x08\xa6\x8c\x4b\x38\x47\x00\xc0\x80"
            "\x83\x3f\x00" }  },
      /* --- pixel bitmap for cmr160 char#65 A --- */
      {  65, 1026,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,50, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x71\x70\xf2\x63\x60\xf2\x51\x22\x50\xf1\x41\x42\x40"
            "\x47\x40\xf1\x31\x62\x30\x22\x63\x41\x82\x25\x46" }  },
      /* --- pixel bitmap for cmr160 char#66 B --- */
      {  66, 2324,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   15, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0a\x62\x62\x20\xf2\x22\x72\x10\x22\x63\x32\x53\x4a"
            "\x42\x72\x10\xf2\x22\x82\x22\x73\x22\x63\x1b\x36" }  },
      /* --- pixel bitmap for cmr160 char#67 C --- */
      {  67, 3249,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   15, 3,41, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x56\x21\x32\x63\x22\x82\xf1\x12\xa1\x0f\x42\xc0\xf1"
            "\x12\xa1\x22\x81\x42\x61\x76\x33" }  },
      /* --- pixel bitmap for cmr160 char#68 D --- */
      {  68, 4327,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,45, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0a\x72\x62\x52\x72\x42\x82\x32\x91\x10\xf4\x22\x92"
            "\x22\x91\x32\x82\x32\x72\x42\x62\x3a\x53" }  },
      /* --- pixel bitmap for cmr160 char#69 E --- */
      {  69, 5720,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x8f\x81\x31\x20\x06\xc8\x10\x19\x02\x63\xe0\x0f"
            "\x8c\x81\x21\x32\x44\x06\xcc\x80\x18\xd8\xff\x03" }  },
      /* --- pixel bitmap for cmr160 char#70 F --- */
      {  70, 6949,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\xc7\x60\x0c\xc4\x80\x0c\xc9\x10\x8c\xc1\x1f\x8c"
            "\xc1\x10\x0c\xc1\x00\x0c\xc0\x00\x7f\x00" }  },
      /* --- pixel bitmap for cmr160 char#71 G --- */
      {  71, 8116,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   15, 3,53, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x56\x21\x52\x63\x42\x82\x20\xf1\x12\xa1\x2f\x22\xe2"
            "\x79\xa2\x20\xf1\x12\x92\x20\x22\x82\x52\x63\x76\x21"
            "\x22" }  },
      /* --- pixel bitmap for cmr160 char#72 H --- */
      {  72, 9281,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,26, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x36\xf5\x22\x72\x20\x2b\x20\xf5\x22\x72\x26\x36" }  },
      /* --- pixel bitmap for cmr160 char#73 I --- */
      {  73, 9952,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,   15, 3, 8, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\xfc\x32\x38" }  },
      /* --- pixel bitmap for cmr160 char#74 J --- */
      {  74,10750,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   15, 3,17, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x37\xfa\x62\x22\x42\x22\x32\x45\x45" }  },
      /* --- pixel bitmap for cmr160 char#75 K --- */
      {  75,11895,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\x3e\x06\x06\x83\x81\x61\xc0\x18\x60\x04\x30\x03"
            "\x58\x03\x1c\x03\x86\x01\x83\x81\x81\xc1\xc0\x60\xc0"
            "\xfc\xf8\x01" }  },
      /* --- pixel bitmap for cmr160 char#76 L --- */
      {  76,12842,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   15, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07\x50\xf7\x22\x80\xf1\x22\x71\x22\x62\x22\x61\x32"
            "\x52\x1b\x11" }  },
      /* --- pixel bitmap for cmr160 char#77 M --- */
      {  77,14116,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   15, 3,62, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\x85\xf1\x23\x83\x20\xf1\x21\x12\x61\x12\x20\xf2"
            "\x21\x22\x41\x22\x20\xf2\x21\x32\x21\x32\x20\xf2\x21"
            "\x43\x42\x25\x31\x36" }  },
      /* --- pixel bitmap for cmr160 char#78 N --- */
      {  78,15246,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f\x7c\x0e\x08\x0d\x84\x0e\x42\x06\x21\x86\x10\x47"
            "\x08\x23\x04\x13\x82\x0b\x81\x85\x80\x43\xc0\x21\xc0"
            "\x7c\x40\x00" }  },
      /* --- pixel bitmap for cmr160 char#79 O --- */
      {  79,16111,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x55\x82\x52\x52\x72\x32\x92\x21\xb1\x1f\x42\xb2\xf1"
            "\x12\x92\x10\x22\x72\x52\x52\x85\x51" }  },
      /* --- pixel bitmap for cmr160 char#80 P --- */
      {  80,17218,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   15, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0a\x52\x62\x10\xf3\x22\x72\x22\x62\x38\x30\xf5\x22"
            "\x96\x72" }  },
      /* --- pixel bitmap for cmr160 char#81 Q --- */
      {  81,18235,                      /* character number, location */
         15, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 15,   19, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x55\x82\x52\x52\x72\x20\xf1\x12\x92\x1f\x42\xb2\xf1"
            "\x12\x92\x10\x22\x23\x22\x53\x33\x85\xe0\x11\xe1\x31"
            "\xb4\xb3\x11" }  },
      /* --- pixel bitmap for cmr160 char#82 R --- */
      {  82,19524,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,45, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x09\x82\x52\x40\xf3\x22\x62\x30\x22\x52\x67\x82\x42"
            "\x50\xf3\x22\x52\x40\x22\x52\x37\x44\x10" }  },
      /* --- pixel bitmap for cmr160 char#83 S --- */
      {  83,20569,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x19\x36\xd0\x40\x03\x1c\xe0\x07\x3f\xc0\x01\x0c"
            "\x70\xc0\x01\x0f\xd6\x0f" }  },
      /* --- pixel bitmap for cmr160 char#84 T --- */
      {  84,21647,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   15, 3,25, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x02\x42\x42\x0f\x21\x52\x51\xf8\x62\x60\x38\x30" }  },
      /* --- pixel bitmap for cmr160 char#85 U --- */
      {  85,22629,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,23, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x45\xfa\x22\x81\x20\x32\x61\x72\x41\x95\x58" }  },
      /* --- pixel bitmap for cmr160 char#86 V --- */
      {  86,23617,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 17,   15, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07\x46\xf1\x32\x81\x30\x33\x62\x30\xf1\x42\x61\x40"
            "\xf1\x52\x41\x50\x53\x22\x50\xf1\x62\x21\x60\xf2\x73"
            "\x70\x81\x81" }  },
      /* --- pixel bitmap for cmr160 char#87 W --- */
      {  87,25014,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 23,   15, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x36\x26\x22\x72\x62\x20\xf2\x32\x51\x12\x51\x30"
            "\xf2\x42\x31\x32\x31\x40\xf3\x52\x11\x52\x11\x50\xf2"
            "\x62\x72\x61" }  },
      /* --- pixel bitmap for cmr160 char#88 X --- */
      {  88,26135,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 17,   15, 3,58, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x16\x36\x43\x52\x82\x51\xa2\x31\xc2\x12\xc2\x11\xe2"
            "\x80\xf1\x73\x70\x61\x22\xb2\x32\xa1\x42\x91\x62\x72"
            "\x72\x36\x47" }  },
      /* --- pixel bitmap for cmr160 char#89 Y --- */
      {  89,27277,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 17,   15, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07\x46\x32\x81\x72\x62\x73\x51\x92\x42\xa2\x31\xb3"
            "\x11\xd2\x11\x60\xf5\x82\x70\x66\x51" }  },
      /* --- pixel bitmap for cmr160 char#90 Z --- */
      {  90,28316,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\xef\x60\x06\x27\x30\x82\x01\x1c\xc0\x00\x06\x30"
            "\x80\x83\x18\xc8\x80\x0e\x6c\xe0\xff\x0f" }  },
      /* --- pixel bitmap for cmr160 char#91 [ --- */
      {  91,100130,                     /* character number, location */
         17, 2,   -6, 2,      /* topleft row,col, and botleft row,col */
          {  4,   23, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x0f\xe1\x3f\x51\x34" }  },
      /* --- pixel bitmap for cmr160 char#92 (noname) --- */
      {  92,118659,                     /* character number, location */
         15, 4,    9, 4,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa2\x18\x45\xf3\x0c" }  },
      /* --- pixel bitmap for cmr160 char#93 ] --- */
      {  93,100824,                     /* character number, location */
         17, 0,   -6, 0,      /* topleft row,col, and botleft row,col */
          {  5,   23, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\xfe\x41\xf5\x41\x05" }  },
      /* --- pixel bitmap for cmr160 char#94 \^ --- */
      {  94,106997,                     /* character number, location */
         15, 3,   12, 3,      /* topleft row,col, and botleft row,col */
          {  5,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x44\x45" }  },
      /* --- pixel bitmap for cmr160 char#95 (noname) --- */
      {  95,107464,                     /* character number, location */
         16, 2,   14, 2,      /* topleft row,col, and botleft row,col */
          {  2,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmr160 char#96 (noname) --- */
      {  96,101438,                     /* character number, location */
         15, 2,    9, 2,      /* topleft row,col, and botleft row,col */
          {  2,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5a\x0f" }  },
      /* --- pixel bitmap for cmr160 char#97 a --- */
      {  97,29456,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x98\x01\x0c\x30\xfc\x18\x33\xcc\xb0\xe3\x72\x07" }  },
      /* --- pixel bitmap for cmr160 char#98 b --- */
      {  98,30458,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\x60\x00\x03\x18\xc0\x00\x76\x70\x8c\x41\x0c\x66"
            "\x30\x83\x19\xcc\x20\x8e\x90\x03" }  },
      /* --- pixel bitmap for cmr160 char#99 c --- */
      {  99,31233,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\xc4\x02\x03\x03\x03\x03\x02\x84\x78" }  },
      /* --- pixel bitmap for cmr160 char#100 d --- */
      { 100,32224,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x01\x0c\x60\x00\x03\x18\xdc\x10\x47\x30\x83\x19"
            "\xcc\x60\x06\x23\x18\xe3\xe0\x1e" }  },
      /* --- pixel bitmap for cmr160 char#101 e --- */
      { 101,32984,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x66\xc2\xc3\xff\x03\x03\x02\x86\x78" }  },
      /* --- pixel bitmap for cmr160 char#102 f --- */
      { 102,33805,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,   15, 3,21, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x44\x42\x22\xf2\x22\x57\x20\xf7\x22\x56\x32" }  },
      /* --- pixel bitmap for cmr160 char#103 g --- */
      { 103,35038,                      /* character number, location */
         10, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          { 10,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\x9b\x39\xcc\x30\xc3\x98\xe1\xc3\x00\x7e\xf8\x33"
            "\xd8\x60\x83\x19\xc3\x07" }  },
      /* --- pixel bitmap for cmr160 char#104 h --- */
      { 104,36015,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   15, 3,30, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x80\xf3\x22\x80\x22\x14\x53\x32\x20\xf6\x22\x42"
            "\x26\x15" }  },
      /* --- pixel bitmap for cmr160 char#105 i --- */
      { 105,36730,                      /* character number, location */
         16, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,   16, 3,18, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x22\x20\xf3\x64\x20\xf7\x22\x26" }  },
      /* --- pixel bitmap for cmr160 char#106 j --- */
      { 106,37498,                      /* character number, location */
         16,-2,   -4,-2,      /* topleft row,col, and botleft row,col */
          {  7,   20, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x52\xf3\x70\x34\xfa\x52\x02\x28\x20" }  },
      /* --- pixel bitmap for cmr160 char#107 k --- */
      { 107,38588,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\xc0\x00\x0c\xc0\x00\x0c\xc0\x7c\x8c\xc1\x04\x6c"
            "\xc0\x07\xcc\xc0\x1c\x8c\xc1\x30\x9f\x0f" }  },
      /* --- pixel bitmap for cmr160 char#108 l --- */
      { 108,39207,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,   15, 3,10, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x20\xfc\x22\x26" }  },
      /* --- pixel bitmap for cmr160 char#109 m --- */
      { 109,40516,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 18,   10, 3,28, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x14\x24\x53\x33\x32\x20\xf6\x22\x42\x42\x26\x15"
            "\x15" }  },
      /* --- pixel bitmap for cmr160 char#110 n --- */
      { 110,41501,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   10, 3,20, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x14\x53\x32\x20\xf6\x22\x42\x26\x15" }  },
      /* --- pixel bitmap for cmr160 char#111 o --- */
      { 111,42198,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x8c\x09\x1a\x3c\x78\xf0\x60\x41\xc6\x70\x00" }  },
      /* --- pixel bitmap for cmr160 char#112 p --- */
      { 112,43264,                      /* character number, location */
         10, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          { 11,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xef\xe0\x18\x83\x18\xcc\x60\x06\x33\x98\x61\x1c\x61"
            "\x07\x03\x18\xc0\x80\x1f\x00" }  },
      /* --- pixel bitmap for cmr160 char#113 q --- */
      { 113,44268,                      /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 12,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x42\x38\x06\x33\x30\x03\x33\x30\x03\x63\x30\x84"
            "\x83\x37\x00\x03\x30\x00\x03\xfc" }  },
      /* --- pixel bitmap for cmr160 char#114 r --- */
      { 114,45127,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,   10, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x13\x33\x22\x23\x40\xf5\x22\x56\x30" }  },
      /* --- pixel bitmap for cmr160 char#115 s --- */
      { 115,46060,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\xe1\xf0\xe0\xe3\x87\xc3\xa3\x0e" }  },
      /* --- pixel bitmap for cmr160 char#116 t --- */
      { 116,46885,                      /* character number, location */
         14, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x08\x0c\x0c\x7f\x0c\x0c\x0c\x0c\x0c\x8c\x8c\x8c"
            "\x78" }  },
      /* --- pixel bitmap for cmr160 char#117 u --- */
      { 117,47808,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   10, 3,22, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x24\x20\xf6\x22\x42\x20\x22\x33\x54\x14" }  },
      /* --- pixel bitmap for cmr160 char#118 v --- */
      { 118,48674,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f\xcf\x20\x18\x81\x11\x18\x01\x0b\xb0\x00\x06\x60"
            "\x00\x06" }  },
      /* --- pixel bitmap for cmr160 char#119 w --- */
      { 119,49923,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 16,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9f\xf3\x8c\x23\x8c\x23\xd8\x13\x58\x16\x58\x16\x78"
            "\x1e\x30\x0c\x30\x0c\x30\x0c" }  },
      /* --- pixel bitmap for cmr160 char#120 x --- */
      { 120,50892,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9f\x8f\x11\x98\x00\x0f\x60\x00\x06\xd0\x80\x19\x88"
            "\xf3\xf9" }  },
      /* --- pixel bitmap for cmr160 char#121 y --- */
      { 121,51955,                      /* character number, location */
         10, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          { 12,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f\xcf\x20\x18\x81\x11\x18\x01\x0b\xb0\x00\x06\x60"
            "\x00\x06\x20\x00\x02\x13\xe0\x00" }  },
      /* --- pixel bitmap for cmr160 char#122 z --- */
      { 122,52914,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x63\x61\x31\x18\x98\x8c\x86\xc6\xff" }  },
      /* --- pixel bitmap for cmr160 char#123 (noname) --- */
      { 123,119267,                     /* character number, location */
          7, 0,    6, 0,      /* topleft row,col, and botleft row,col */
          { 11,    1, 3, 2, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0b" }  },
      /* --- pixel bitmap for cmr160 char#124 (noname) --- */
      { 124,120087,                     /* character number, location */
          7, 0,    6, 0,      /* topleft row,col, and botleft row,col */
          { 22,    1, 3, 4, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x08" }  },
      /* --- pixel bitmap for cmr160 char#125 (noname) --- */
      { 125,108141,                     /* character number, location */
         15, 3,   11, 3,      /* topleft row,col, and botleft row,col */
          {  6,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf3\x1c\x45" }  },
      /* --- pixel bitmap for cmr160 char#126 \~ --- */
      { 126,108825,                     /* character number, location */
         15, 2,   12, 2,      /* topleft row,col, and botleft row,col */
          {  7,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x44\x5f\x04" }  },
      /* --- pixel bitmap for cmr160 char#127 (noname) --- */
      { 127,109506,                     /* character number, location */
         16, 2,   14, 2,      /* topleft row,col, and botleft row,col */
          {  7,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe3\x31" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=5 for .180gf ---
 * mf '\mode=preview; mag=magstep(-14.65037297372839890542); input cmr10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmr180 --- */
static	chardef  cmr180[] =
   {
      /* --- pixel bitmap for cmr180 char#0 \Gamma --- */
      {   0,54233,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   17, 3,27, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x42\x72\x42\x81\x42\x82\xf1\x32\x91\xf9\x32\xa8"
            "\x71" }  },
      /* --- pixel bitmap for cmr180 char#1 \Delta --- */
      {   1,55144,                      /* character number, location */
         18, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   18, 3,70, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x91\x90\xf1\x83\x80\xf1\x71\x22\x70\xf1\x61\x42\x60"
            "\xf1\x51\x62\x50\xf1\x41\x82\x40\xf1\x31\xa2\x30\x21"
            "\xb3\x41\xc2\x31\xd3\x2e\x03\x1e\x05" }  },
      /* --- pixel bitmap for cmr180 char#2 \Theta --- */
      {   2,56287,                      /* character number, location */
         18, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 17,   19, 3,77, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x65\xa2\x52\x72\x72\x52\x92\x20\xf1\x12\xb2\x12\xd4"
            "\x21\x71\x22\x0f\x12\x29\x22\x02\x21\x71\x22\x0f\x12"
            "\xd2\xf1\x12\xb2\x10\x22\x92\x52\x72\x72\x52\xa5\x60" }  },
      /* --- pixel bitmap for cmr180 char#3 \Lambda --- */
      {   3,57259,                      /* character number, location */
         18, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   18, 3,54, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x71\x70\xf2\x63\x60\xf2\x51\x22\x50\x41\x33\x40"
            "\xf2\x41\x42\x40\xf2\x31\x62\x30\x21\x82\x42\x72\x25"
            "\x46" }  },
      /* --- pixel bitmap for cmr180 char#4 \Xi --- */
      {   4,58642,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   17, 3,52, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x0e\x01\x0f\x11\xd1\xf1\xe0\x10\x31\x71\x30\xf1"
            "\x39\x30\x31\x71\x30\xf2\xe0\x1f\x11\xd1\x0f\x1e\x01" }  },
      /* --- pixel bitmap for cmr180 char#5 \Pi --- */
      {   5,59799,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 19,   17, 3,14, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x05\xfe\x32\x92\x38\x38" }  },
      /* --- pixel bitmap for cmr180 char#6 \Sigma --- */
      {   6,60934,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   17, 3,63, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x01\x22\x93\x23\xa1\x32\xa2\x32\xa1\x33\x91\x42"
            "\xe0\x12\xe0\x12\xe1\xe1\xe1\xa1\x31\xb1\x31\xa2\x21"
            "\xb1\x21\xa3\x1e\x01\x12" }  },
      /* --- pixel bitmap for cmr180 char#7 \Upsilon --- */
      {   7,62038,                      /* character number, location */
         18, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   18, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x24\x54\x36\x36\x12\x42\x21\x43\x61\x12\x52\x63\x61"
            "\xfb\x82\x70\x58\x41" }  },
      /* --- pixel bitmap for cmr180 char#8 \Phi --- */
      {   8,63084,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   17, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x48\x40\xf2\x72\x70\x48\x62\x32\x32\x32\x42\x42\x1f"
            "\x22\x52\x52\x12\x42\x42\x32\x32\x32\x68\x40\xf2\x72"
            "\x70\x48\x43" }  },
      /* --- pixel bitmap for cmr180 char#9 \Psi --- */
      {   9,64209,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   17, 3,55, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x58\x40\xf1\x82\x73\x52\x43\xf4\x22\x42\x32\x20\x31"
            "\x42\x32\x52\x32\x22\x72\x22\x12\xa6\x50\xf2\x82\x70"
            "\x58\x48" }  },
      /* --- pixel bitmap for cmr180 char#10 \Omega --- */
      {  10,65380,                      /* character number, location */
         18, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   18, 3,61, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x56\x82\x62\x52\x82\x32\xa2\x1f\x42\xc2\xf1\x12\xa2"
            "\x10\x22\x82\x51\x81\x71\x61\x41\x31\x61\x32\x41\x41"
            "\x41\xf1\x15\x45\x11" }  },
      /* --- pixel bitmap for cmr180 char#11 \ff --- */
      {  11,111599,                     /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 16,   17, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x65\x13\x52\x43\x12\xf3\x32\x52\x4e\x01\x10\xf8\x32"
            "\x52\x40\x15\x35\x21" }  },
      /* --- pixel bitmap for cmr180 char#12 \fi --- */
      {  12,112779,                     /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   17, 3,32, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x55\x72\x32\x52\x42\x20\xf2\x32\x8b\x20\xf8\x32\x42"
            "\x20\x15\x25" }  },
      /* --- pixel bitmap for cmr180 char#13 \fl --- */
      {  13,113949,                     /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   17, 3,30, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x56\x62\x32\x20\xf3\x32\x42\x2b\x20\xf8\x32\x42\x20"
            "\x15\x25" }  },
      /* --- pixel bitmap for cmr180 char#14 \ffi --- */
      {  14,115570,                     /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 20,   17, 3,46, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x65\x15\x72\x43\x32\x52\x52\x42\x20\xf2\x32\x52\x8e"
            "\x04\x20\xf8\x32\x52\x42\x20\x15\x34\x25" }  },
      /* --- pixel bitmap for cmr180 char#15 \ffl --- */
      {  15,117217,                     /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 20,   17, 3,40, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x65\x16\x62\x43\x32\x20\xf3\x32\x52\x42\x2e\x04\x20"
            "\xf8\x32\x52\x42\x20\x16\x1c" }  },
      /* --- pixel bitmap for cmr180 char#16 \imath --- */
      {  16,79369,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,   11, 3,10, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x20\xf8\x22\x26" }  },
      /* --- pixel bitmap for cmr180 char#17 \jmath --- */
      {  17,80043,                      /* character number, location */
         11,-1,   -5,-1,      /* topleft row,col, and botleft row,col */
          {  6,   16, 3,13, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x24\xfc\x42\x02\x21\x23\x23" }  },
      /* --- pixel bitmap for cmr180 char#18 \gravesym --- */
      {  18,102844,                     /* character number, location */
         17, 3,   13, 3,      /* topleft row,col, and botleft row,col */
          {  4,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x73\xc6" }  },
      /* --- pixel bitmap for cmr180 char#19 \acutesym --- */
      {  19,103415,                     /* character number, location */
         17, 5,   13, 5,      /* topleft row,col, and botleft row,col */
          {  4,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xec\x36" }  },
      /* --- pixel bitmap for cmr180 char#20 \checksym --- */
      {  20,104042,                     /* character number, location */
         16, 3,   14, 3,      /* topleft row,col, and botleft row,col */
          {  6,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb3\x07" }  },
      /* --- pixel bitmap for cmr180 char#21 \brevesym --- */
      {  21,104658,                     /* character number, location */
         17, 2,   14, 2,      /* topleft row,col, and botleft row,col */
          {  8,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x81\xc3\x3c" }  },
      /* --- pixel bitmap for cmr180 char#22 (noname) --- */
      {  22,105238,                     /* character number, location */
         15, 2,   14, 2,      /* topleft row,col, and botleft row,col */
          {  8,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff" }  },
      /* --- pixel bitmap for cmr180 char#23 (noname) --- */
      {  23,106015,                     /* character number, location */
         18, 7,   14, 7,      /* topleft row,col, and botleft row,col */
          {  5,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\x46\x07" }  },
      /* --- pixel bitmap for cmr180 char#24 (noname) --- */
      {  24,106707,                     /* character number, location */
         -1, 3,   -6, 3,      /* topleft row,col, and botleft row,col */
          {  6,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x0c\xfb\x01" }  },
      /* --- pixel bitmap for cmr180 char#25 \ss --- */
      {  25,81130,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\xc1\x18\x83\x19\xcc\x60\x86\xbd\x83\x31\x0c\x63"
            "\x18\x83\x19\xcc\x60\x06\x33\x99\x79\x8f\x01" }  },
      /* --- pixel bitmap for cmr180 char#26 \ae --- */
      {  26,82481,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x3c\xc6\x62\x80\xc3\x80\xc1\xf0\xff\x8c\x01\x82"
            "\x01\x83\x01\x83\x83\xc6\x46\x7c\x3c" }  },
      /* --- pixel bitmap for cmr180 char#27 \oe --- */
      {  27,83607,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x78\x08\x89\x19\x1e\x1e\x18\x3c\xf0\x7f\x60\xc0"
            "\xc0\x80\x81\x01\x86\x07\x09\x19\xe1\xe1\x01" }  },
      /* --- pixel bitmap for cmr180 char#28 (noname) --- */
      {  28,84431,                      /* character number, location */
         13, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          { 10,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x01\x84\x0f\x21\x42\x8d\x3d\xf2\xcc\x13\x2f\xac"
            "\x10\x21\x7c\x08\x20\x00" }  },
      /* --- pixel bitmap for cmr180 char#29 \AE --- */
      {  29,86217,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 20,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\xff\x07\x68\x60\x80\x06\x04\x64\xc0\x40\x06\x08"
            "\x64\x88\x20\x86\x00\x62\x0c\xe0\xff\x00\x61\x0c\x10"
            "\x86\x08\x61\x88\x08\x06\x88\x60\x40\x08\x06\xc4\x60"
            "\x60\x9f\xff\x07" }  },
      /* --- pixel bitmap for cmr180 char#30 \OE --- */
      {  30,87929,                      /* character number, location */
         18, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 23,   19, 3,103, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x65\xe0\x22\x5b\x42\x63\x62\x32\x73\x71\x22\x83\x72"
            "\x12\x83\x83\x93\x51\x23\xa2\x51\x32\xa2\x42\x32\xa8"
            "\x32\xa2\x42\x32\xa2\x51\x23\x93\x51\x21\x12\x83\x81"
            "\x12\x83\x71\x32\x73\x71\x42\x63\x62\x53\x4b\x75\xc1" }  },
      /* --- pixel bitmap for cmr180 char#31 (noname) --- */
      {  31,88931,                      /* character number, location */
         18, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 17,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x47\x60\xf0\x20\x80\x60\x80\x63\x80\xcd\x00\xd9"
            "\x00\xe1\x01\xc1\x03\x82\x07\x02\x0f\x02\x1e\x04\x3c"
            "\x04\xd8\x04\x98\x0d\x30\x0e\x30\x08\x20\x78\x30\x10"
            "\x1f\x00" }  },
      /* --- pixel bitmap for cmr180 char#32 (noname) --- */
      {  32,107207,                     /* character number, location */
         10, 0,    7, 0,      /* topleft row,col, and botleft row,col */
          {  6,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x27\x00" }  },
      /* --- pixel bitmap for cmr180 char#33 ! --- */
      {  33,89602,                      /* character number, location */
         18, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  3,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfa\xff\x5b\x92\x04\x40\x17" }  },
      /* --- pixel bitmap for cmr180 char#34 " --- */
      {  34,118176,                     /* character number, location */
         17, 1,    9, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x42\xe7\xc6\x84\x84\x84\x42\x21" }  },
      /* --- pixel bitmap for cmr180 char#35 # --- */
      {  35,91072,                      /* character number, location */
         17, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          { 19,   22, 3,59, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf3\x91\x51\x30\xf2\x81\x51\x4e\x05\xf1\x71\x51\x50"
            "\xf2\x61\x51\x6e\x05\xf1\x51\x51\x70\xf3\x41\x51\x80"
            "\xf1\x31\x51\x91" }  },
      /* --- pixel bitmap for cmr180 char#36 $ --- */
      {  36,75631,                      /* character number, location */
         19, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 10,   20, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x80\x80\x87\x69\x20\x86\x18\x72\x08\x26\xf8\x80"
            "\x0f\x78\x20\x83\x38\x62\x88\x22\x99\x82\x07\x08" }  },
      /* --- pixel bitmap for cmr180 char#37 % --- */
      {  37,92321,                      /* character number, location */
         19, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 19,   20, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x80\x30\x01\x82\x38\x18\x86\x7e\x30\x04\x81\x21"
            "\x08\x0c\x21\x60\x08\x01\x22\x04\x30\x11\x00\x87\x70"
            "\x00\xc2\x04\x08\x42\x40\x18\x02\xc1\x10\x08\x86\x20"
            "\x30\x84\x00\x21\x04\x98\x10\x80\x03" }  },
      /* --- pixel bitmap for cmr180 char#38 & --- */
      {  38,76909,                      /* character number, location */
         18, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 17,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x00\x20\x02\x60\x04\xc0\x08\x80\x11\x00\x13\x00"
            "\x26\x00\x2c\xfc\x30\x60\x60\x40\xe0\x41\x20\x83\x20"
            "\x8e\x60\x18\xc1\x60\x81\x81\x81\x03\x07\x0d\x19\xf1"
            "\xe1\x01" }  },
      /* --- pixel bitmap for cmr180 char#39 ' --- */
      {  39,92997,                      /* character number, location */
         17, 2,    9, 2,      /* topleft row,col, and botleft row,col */
          {  3,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x49\x29" }  },
      /* --- pixel bitmap for cmr180 char#40 ( --- */
      {  40,93575,                      /* character number, location */
         19, 3,   -6, 3,      /* topleft row,col, and botleft row,col */
          {  6,   25, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x84\x30\x84\x61\x08\xc3\x30\x0c\xc3\x30\x0c\x83"
            "\x60\x18\x04\x83\x40\x20" }  },
      /* --- pixel bitmap for cmr180 char#41 ) --- */
      {  41,94188,                      /* character number, location */
         19, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          {  6,   25, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x81\x40\x30\x08\x86\x41\x30\x0c\xc3\x30\x0c\xc3\x30"
            "\x84\x61\x08\x43\x08\x01" }  },
      /* --- pixel bitmap for cmr180 char#42 * --- */
      {  42,94825,                      /* character number, location */
         19, 1,    8, 1,      /* topleft row,col, and botleft row,col */
          {  9,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x60\xc8\xb4\xcd\x0f\x06\x3f\xdb\x32\x61\xc0\x00" }  },
      /* --- pixel bitmap for cmr180 char#43 + --- */
      {  43,95519,                      /* character number, location */
         15, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          { 17,   17, 3,13, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf7\x81\x8e\x03\xf7\x81\x82" }  },
      /* --- pixel bitmap for cmr180 char#44 (noname) --- */
      {  44,96108,                      /* character number, location */
          3, 2,   -5, 2,      /* topleft row,col, and botleft row,col */
          {  3,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x49\x29" }  },
      /* --- pixel bitmap for cmr180 char#45 (noname) --- */
      {  45,118687,                     /* character number, location */
          6, 0,    4, 0,      /* topleft row,col, and botleft row,col */
          {  7,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x3f" }  },
      /* --- pixel bitmap for cmr180 char#46 (noname) --- */
      {  46,96577,                      /* character number, location */
          3, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  3,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x00" }  },
      /* --- pixel bitmap for cmr180 char#47 / --- */
      {  47,97085,                      /* character number, location */
         19, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 10,   25, 3,55, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x91\xf2\x81\x10\xf1\x71\x20\xf2\x61\x30\xf1\x51"
            "\x40\xf2\x41\x50\xf2\x31\x60\xf1\x21\x70\xf2\x11\x8f"
            "\x11\x91" }  },
      /* --- pixel bitmap for cmr180 char#48 0 --- */
      {  48,66116,                      /* character number, location */
         17, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 10,   18, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x34\x52\x22\x32\x42\x21\x61\x1f\x92\x62\x11\x61\x22"
            "\x42\x32\x22\x54\x31" }  },
      /* --- pixel bitmap for cmr180 char#49 1 --- */
      {  49,66906,                      /* character number, location */
         17, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  8,   17, 3,16, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x32\x44\x31\x22\x30\xfc\x32\x38" }  },
      /* --- pixel bitmap for cmr180 char#50 2 --- */
      {  50,67883,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x10\x22\x58\xc0\x01\x0f\x0c\x30\xc0\x80\x01\x02"
            "\x04\x08\x10\x20\x48\xa0\x7f\xff\x01" }  },
      /* --- pixel bitmap for cmr180 char#51 3 --- */
      {  51,68921,                      /* character number, location */
         17, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 10,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x10\x23\x98\x61\x86\x01\x06\x08\x10\x78\x00\x02"
            "\x18\xc0\x03\x0f\x1c\xb0\x60\x84\xe0\x01" }  },
      /* --- pixel bitmap for cmr180 char#52 4 --- */
      {  52,69853,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x00\x03\x0e\x38\xd0\x60\x83\x0c\x31\xc4\x08\x13"
            "\xcc\xff\xc0\x00\x03\x0c\x30\xf0\x03" }  },
      /* --- pixel bitmap for cmr180 char#53 5 --- */
      {  53,70891,                      /* character number, location */
         17, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 10,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\xf9\xa3\x83\x00\x02\x08\x20\x87\x22\x86\x09\x0c"
            "\x30\xc0\x00\x0f\x1c\x90\x60\xc6\xe0\x01" }  },
      /* --- pixel bitmap for cmr180 char#54 6 --- */
      {  54,71795,                      /* character number, location */
         17, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 10,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x60\xc4\x98\x61\x06\x08\xb0\xc7\x21\x87\x0d\x3c"
            "\xf0\xc0\x03\x0f\x2c\xb0\x61\x8c\xe0\x01" }  },
      /* --- pixel bitmap for cmr180 char#55 7 --- */
      {  55,72707,                      /* character number, location */
         17, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 11,   18, 3,45, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x11\xaa\x19\x11\x81\x11\x71\x20\xf1\x71\x30\x61\x92"
            "\x91\x50\xf1\x42\x50\x41\x60\xf4\x32\x62" }  },
      /* --- pixel bitmap for cmr180 char#56 8 --- */
      {  56,73627,                      /* character number, location */
         17, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 10,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x30\x63\x98\x61\x86\x19\xc6\x0c\x17\x70\xb0\x63"
            "\xd8\xe0\x03\x0f\x3c\xb0\x41\x84\xe0\x01" }  },
      /* --- pixel bitmap for cmr180 char#57 9 --- */
      {  57,74539,                      /* character number, location */
         17, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 10,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x10\x62\xd8\x40\x03\x0f\x3c\xf0\xc0\x03\x1b\x4e"
            "\x38\xde\x00\x03\x66\x98\x21\x42\xf0\x00" }  },
      /* --- pixel bitmap for cmr180 char#58 : --- */
      {  58,97681,                      /* character number, location */
         11, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  3,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x00\x00\xba\x00" }  },
      /* --- pixel bitmap for cmr180 char#59 ; --- */
      {  59,98348,                      /* character number, location */
         11, 2,   -5, 2,      /* topleft row,col, and botleft row,col */
          {  3,   16, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x00\x00\xba\x49\x29" }  },
      /* --- pixel bitmap for cmr180 char#60 (noname) --- */
      {  60,90220,                      /* character number, location */
         12, 2,   -6, 2,      /* topleft row,col, and botleft row,col */
          {  3,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x00\x48\x92\xfc\xff\x17" }  },
      /* --- pixel bitmap for cmr180 char#61 = --- */
      {  61,99030,                      /* character number, location */
         10, 1,    3, 1,      /* topleft row,col, and botleft row,col */
          { 17,    7, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x03\xf4\xe0\x3e\x03" }  },
      /* --- pixel bitmap for cmr180 char#62 (noname) --- */
      {  62,78784,                      /* character number, location */
         12, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          { 10,   17, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x41\x83\x81\x50\xf2\xa0\xf3\x41\x50\x31\x81\x81\x8f"
            "\x12\x62\x11\x61\x36\x21" }  },
      /* --- pixel bitmap for cmr180 char#63 ? --- */
      {  63,77868,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   17, 3,39, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x26\x31\x52\x1f\x12\x62\x72\x72\x71\x82\x40\xf2\x41"
            "\x50\xf2\xa0\x41\x83\x81\x54" }  },
      /* --- pixel bitmap for cmr180 char#64 @ --- */
      {  64,100200,                     /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x07\x60\x30\x20\x80\x20\x1c\x22\x44\x48\x0c\x53"
            "\x0c\xc6\x18\x8c\x31\x18\x63\x30\xc6\x60\x14\xc3\x28"
            "\xc4\x89\x70\x0e\x02\x00\x18\xe0\xc0\x3f\x00" }  },
      /* --- pixel bitmap for cmr180 char#65 A --- */
      {  65, 1026,                      /* character number, location */
         18, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   18, 3,60, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x81\x80\xf2\x73\x70\x62\x12\x60\xf1\x61\x22\x60\xf2"
            "\x51\x42\x50\x41\x62\x89\x81\x62\x40\xf2\x31\x82\x30"
            "\x22\x83\x26\x47" }  },
      /* --- pixel bitmap for cmr180 char#66 B --- */
      {  66, 2336,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 17,   17, 3,55, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0d\x72\x73\x52\x82\x20\xf2\x32\x92\x10\x32\x82\x52"
            "\x63\x6b\x62\x83\x42\x93\xf2\x32\xa2\x32\x92\x42\x82"
            "\x2e\x33" }  },
      /* --- pixel bitmap for cmr180 char#67 C --- */
      {  67, 3269,                      /* character number, location */
         18, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 16,   19, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x65\x41\x42\x52\x12\x32\x83\x22\xa2\x12\xb2\x12\xc3"
            "\xd1\x0f\x42\xe2\xd1\xf1\x12\xc1\x22\xa1\x42\x81\x62"
            "\x61\x96\x46" }  },
      /* --- pixel bitmap for cmr180 char#68 D --- */
      {  68, 4365,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 18,   17, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0d\x82\x72\x72\x92\x52\xa1\x52\xa2\x42\xb1\x10\xf5"
            "\x32\xb2\x32\xa2\x42\xa1\x52\x92\x52\x73\x3d\x51" }  },
      /* --- pixel bitmap for cmr180 char#69 E --- */
      {  69, 5766,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 16,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x7f\x18\x60\x18\x40\x18\xc0\x18\x80\x18\x84\x18"
            "\x04\x18\x06\xf8\x07\x18\x06\x18\x84\x18\x84\x18\x80"
            "\x18\x40\x18\x40\x18\x70\xff\x7f" }  },
      /* --- pixel bitmap for cmr180 char#70 F --- */
      {  70, 7003,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   17, 3,55, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x42\x72\x42\x81\x42\x82\x32\x91\x32\x51\x31\x32"
            "\x51\x72\x42\x78\x72\x42\x40\xf1\x32\x51\x40\xf3\x32"
            "\xa8\x71" }  },
      /* --- pixel bitmap for cmr180 char#71 G --- */
      {  71, 8176,                      /* character number, location */
         18, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 18,   19, 3,73, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x65\x41\x62\x52\x12\x52\x83\x42\xa2\x32\xb2\x32\xc1"
            "\x22\xd1\x2f\x22\xe0\x22\x97\x0f\x12\xc2\x20\xf1\x12"
            "\xb2\x20\x22\xa2\x52\x92\x62\x62\x11\x86\x60" }  },
      /* --- pixel bitmap for cmr180 char#72 H --- */
      {  72, 9359,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 19,   17, 3,26, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x38\xf6\x32\x92\x30\x3d\x30\xf6\x32\x92\x38\x38" }  },
      /* --- pixel bitmap for cmr180 char#73 I --- */
      {  73,10038,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   17, 3, 8, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\xfe\x32\x38" }  },
      /* --- pixel bitmap for cmr180 char#74 J --- */
      {  74,10840,                      /* character number, location */
         17, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 10,   18, 3,23, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x37\xfb\x62\x2f\x12\x42\x21\x51\x41\x32\x54\x48" }  },
      /* --- pixel bitmap for cmr180 char#75 K --- */
      {  75,11995,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 18,   17, 3,72, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x46\x32\x82\x62\x81\x72\x71\x82\x61\x92\x51\xa2"
            "\x41\xb2\x32\xb2\x12\x11\xb3\x32\xa2\x52\x60\xf1\x32"
            "\x62\x50\x32\x72\x40\xf1\x32\x82\x38\x37" }  },
      /* --- pixel bitmap for cmr180 char#76 L --- */
      {  76,12950,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   17, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x70\xf8\x32\xa0\xf2\x32\x91\x32\x82\x32\x81\x42"
            "\x63\x1e\x12" }  },
      /* --- pixel bitmap for cmr180 char#77 M --- */
      {  77,14230,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 23,   17, 3,82, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\xb6\x33\xb3\x30\xf2\x31\x12\x91\x12\x30\xf1\x31"
            "\x22\x71\x22\x30\xf2\x31\x32\x51\x32\x30\xf1\x31\x42"
            "\x31\x42\x30\xf2\x31\x52\x11\x52\x30\x23\x52\x62\x37"
            "\x32\x38" }  },
      /* --- pixel bitmap for cmr180 char#78 N --- */
      {  78,15384,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 19,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f\xf0\xc7\x01\x0e\x0e\x20\xd0\x00\x81\x0c\x08\xc4"
            "\x40\x20\x06\x02\x61\x10\x08\x86\x40\x60\x04\x02\x23"
            "\x10\x30\x81\x00\x0b\x04\x70\x20\x80\x83\x03\x18\x7f"
            "\x80\x00" }  },
      /* --- pixel bitmap for cmr180 char#79 O --- */
      {  79,16259,                      /* character number, location */
         18, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 17,   19, 3,51, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x65\xa2\x52\x72\x72\x52\x92\x20\xf1\x12\xb2\x1f\x62"
            "\xd2\xf1\x12\xb2\x10\x22\x92\x52\x72\x72\x52\xa5\x61" }  },
      /* --- pixel bitmap for cmr180 char#80 P --- */
      {  80,17382,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 16,   17, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0d\x62\x72\x52\x82\x10\xf2\x32\x92\x32\x82\x42\x72"
            "\x5a\x30\xf6\x32\xb8\x82" }  },
      /* --- pixel bitmap for cmr180 char#81 Q --- */
      {  81,18405,                      /* character number, location */
         18, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          { 17,   23, 3,77, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x65\xa2\x52\x72\x72\x52\x92\x20\xf1\x12\xb2\x1f\x62"
            "\xd2\x12\xb2\x22\x43\x42\x32\x21\x31\x22\x52\x11\x31"
            "\x12\x73\x42\x31\x66\x41\xb1\x41\xb2\x22\xb5\xd3\x21" }  },
      /* --- pixel bitmap for cmr180 char#82 R --- */
      {  82,19724,                      /* character number, location */
         17, 0,   -1, 0,      /* topleft row,col, and botleft row,col */
          { 18,   18, 3,61, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0b\xa2\x62\x82\x72\x40\xf2\x32\x82\x30\x32\x72\x72"
            "\x62\x88\xa2\x62\x50\xf3\x32\x72\x40\xf1\x32\x72\x31"
            "\x08\x51\x31\xe3\x16" }  },
      /* --- pixel bitmap for cmr180 char#83 S --- */
      {  83,20783,                      /* character number, location */
         18, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 12,   19, 3,55, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x35\x21\x31\x51\x11\x21\x72\x1f\x22\x81\x13\xa3\xa6"
            "\x77\x94\xa2\xb2\x0f\x21\x92\x02\x72\x11\x12\x42\x21"
            "\x35\x31" }  },
      /* --- pixel bitmap for cmr180 char#84 T --- */
      {  84,21881,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   17, 3,25, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x04\x52\x52\x0f\x31\x62\x61\xf9\x72\x70\x3a\x36" }  },
      /* --- pixel bitmap for cmr180 char#85 U --- */
      {  85,22871,                      /* character number, location */
         17, 0,   -1, 0,      /* topleft row,col, and botleft row,col */
          { 19,   18, 3,33, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x47\x32\x93\x20\xfb\x32\xa1\x30\x42\x81\x91\x71"
            "\xb2\x42\xc5\x72" }  },
      /* --- pixel bitmap for cmr180 char#86 V --- */
      {  86,23871,                      /* character number, location */
         17, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 17,   18, 3,61, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x65\x22\x92\x42\xa1\x20\xf2\x32\x81\x30\xf1\x42"
            "\x61\x40\x43\x42\x40\xf1\x52\x41\x50\xf2\x62\x21\x60"
            "\xf2\x73\x70\x81\x86" }  },
      /* --- pixel bitmap for cmr180 char#87 W --- */
      {  87,25295,                      /* character number, location */
         17, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 24,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\xfe\xf8\x0c\x18\x70\x0c\x38\x20\x0c\x38\x20\x18"
            "\x38\x10\x18\x38\x10\x18\x64\x10\x30\x64\x08\x30\x64"
            "\x08\x30\xc2\x08\x30\xc2\x08\x60\xc2\x04\x60\x81\x05"
            "\x60\x81\x05\xc0\x81\x03\xc0\x81\x03\xc0\x00\x03\x80"
            "\x00\x01" }  },
      /* --- pixel bitmap for cmr180 char#88 X --- */
      {  88,26428,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   17, 3,66, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07\x36\x42\x63\x63\x52\x82\x51\xa2\x31\xc2\x12\xc2"
            "\x11\xe2\x80\xf1\x73\x70\x61\x22\xb2\x32\xa1\x43\x81"
            "\x62\x72\x72\x53\x73\x26\x47" }  },
      /* --- pixel bitmap for cmr180 char#89 Y --- */
      {  89,27578,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   17, 3,47, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x66\x23\x82\x62\x81\x73\x71\x82\x61\xa2\x42\xa3"
            "\x31\xc3\x12\xd2\x11\x70\xf6\x82\x80\x58\x51" }  },
      /* --- pixel bitmap for cmr180 char#90 Z --- */
      {  90,28623,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\xdf\x81\x19\x30\x01\x23\x30\x04\x06\x60\x00\x06"
            "\xe0\x00\x0c\xc0\x40\x0c\x88\x01\x19\xa0\x01\x36\xe0"
            "\xff\x1f" }  },
      /* --- pixel bitmap for cmr180 char#91 [ --- */
      {  91,100949,                     /* character number, location */
         19, 2,   -6, 2,      /* topleft row,col, and botleft row,col */
          {  5,   25, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\x0f\xe1\x4f\x71\x45" }  },
      /* --- pixel bitmap for cmr180 char#92 (noname) --- */
      {  92,119556,                     /* character number, location */
         17, 3,    9, 3,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x84\x42\x21\x21\x21\x63\xe7\x42" }  },
      /* --- pixel bitmap for cmr180 char#93 ] --- */
      {  93,101647,                     /* character number, location */
         19, 0,   -6, 0,      /* topleft row,col, and botleft row,col */
          {  5,   25, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\xfe\x41\xf7\x41\x05" }  },
      /* --- pixel bitmap for cmr180 char#94 \^ --- */
      {  94,107834,                     /* character number, location */
         17, 3,   13, 3,      /* topleft row,col, and botleft row,col */
          {  6,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x37\x87" }  },
      /* --- pixel bitmap for cmr180 char#95 (noname) --- */
      {  95,108303,                     /* character number, location */
         18, 2,   15, 2,      /* topleft row,col, and botleft row,col */
          {  3,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x00" }  },
      /* --- pixel bitmap for cmr180 char#96 (noname) --- */
      {  96,102265,                     /* character number, location */
         17, 2,    9, 2,      /* topleft row,col, and botleft row,col */
          {  3,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x94\x92\x5d" }  },
      /* --- pixel bitmap for cmr180 char#97 a --- */
      {  97,29771,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x30\x06\x60\x00\x03\x1f\xc6\x08\x66\xb0\x83\x35"
            "\x2e\xcf\x00" }  },
      /* --- pixel bitmap for cmr180 char#98 b --- */
      {  98,30779,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   17, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x80\xf4\x22\x80\x22\x14\x53\x32\x42\x52\x10\xf4"
            "\x22\x62\x22\x52\x33\x32\x41\x24\x32" }  },
      /* --- pixel bitmap for cmr180 char#99 c --- */
      {  99,31560,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x18\x1b\x18\x30\x60\xc0\x80\x01\x06\x19\xe1\x01" }  },
      /* --- pixel bitmap for cmr180 char#100 d --- */
      { 100,32555,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   17, 3,42, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x64\x20\xf4\x82\x20\x34\x12\x42\x33\x32\x52\x2f\x42"
            "\x62\x20\x12\x52\x42\x33\x54\x14" }  },
      /* --- pixel bitmap for cmr180 char#101 e --- */
      { 101,33321,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x08\x19\x1e\xfc\x7f\xc0\x80\x01\x06\x09\xe1\x01" }  },
      /* --- pixel bitmap for cmr180 char#102 f --- */
      { 102,34146,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,   17, 3,23, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x53\x52\x12\xf3\x32\x48\x10\xf8\x32\x40\x17\x11" }  },
      /* --- pixel bitmap for cmr180 char#103 g --- */
      { 103,35383,                      /* character number, location */
         12, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 11,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\xe3\xa5\x19\x87\x31\x8c\x61\x98\xc1\x07\x01\x18"
            "\xc0\x3f\xfc\x23\xb8\x81\x0d\x6c\x60\x86\xc1\x03" }  },
      /* --- pixel bitmap for cmr180 char#104 h --- */
      { 104,36370,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   17, 3,30, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x80\xf4\x22\x80\x22\x14\x53\x32\x20\xf7\x22\x42"
            "\x26\x24" }  },
      /* --- pixel bitmap for cmr180 char#105 i --- */
      { 105,37065,                      /* character number, location */
         18, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,   18, 3,20, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x21\x43\x41\x30\xf3\x64\x20\xf8\x22\x26" }  },
      /* --- pixel bitmap for cmr180 char#106 j --- */
      { 106,37837,                      /* character number, location */
         18,-1,   -5,-1,      /* topleft row,col, and botleft row,col */
          {  6,   23, 3,25, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x41\x43\x41\x10\xf3\x60\x24\xfc\x42\x02\x21\x23\x22" }  },
      /* --- pixel bitmap for cmr180 char#107 k --- */
      { 107,38933,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\xc0\x00\x0c\xc0\x00\x0c\xc0\x00\x8c\xcf\x30\x0c"
            "\xc1\x0c\x6c\xc0\x0f\xcc\xc0\x18\x8c\xc3\x30\xbf\x0f" }  },
      /* --- pixel bitmap for cmr180 char#108 l --- */
      { 108,39532,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,   17, 3,10, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x20\xfe\x22\x26" }  },
      /* --- pixel bitmap for cmr180 char#109 m --- */
      { 109,40845,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 20,   11, 3,28, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x24\x34\x54\x34\x32\x20\xf7\x22\x52\x52\x26\x25"
            "\x25" }  },
      /* --- pixel bitmap for cmr180 char#110 n --- */
      { 110,41836,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   11, 3,20, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x14\x53\x32\x20\xf7\x22\x42\x26\x24" }  },
      /* --- pixel bitmap for cmr180 char#111 o --- */
      { 111,42537,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x10\x22\xd0\xc0\x03\x0f\x3c\xf0\xc0\x02\x11\x82"
            "\x07" }  },
      /* --- pixel bitmap for cmr180 char#112 p --- */
      { 112,43607,                      /* character number, location */
         11, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          { 12,   16, 3,41, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x14\x53\x32\x42\x52\x10\xf4\x22\x62\x22\x52\x33"
            "\x32\x42\x14\x30\xf3\x22\x86\x62" }  },
      /* --- pixel bitmap for cmr180 char#113 q --- */
      { 113,44617,                      /* character number, location */
         11, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          { 12,   16, 3,42, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x34\x21\x42\x33\x32\x52\x2f\x42\x62\x20\x12\x52\x42"
            "\x33\x54\x12\x20\xf3\x82\x20\x66" }  },
      /* --- pixel bitmap for cmr180 char#114 r --- */
      { 114,45482,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   11, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x13\x33\x22\x23\x40\xf6\x22\x56\x30" }  },
      /* --- pixel bitmap for cmr180 char#115 s --- */
      { 115,46417,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x82\x83\x03\x3e\x7c\xe0\xc1\xc1\x43\x3d" }  },
      /* --- pixel bitmap for cmr180 char#116 t --- */
      { 116,47244,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,   15, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x41\x40\x32\x63\x48\x10\xf4\x32\x40\xf3\x32\x31"
            "\x44\x14" }  },
      /* --- pixel bitmap for cmr180 char#117 u --- */
      { 117,48171,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   11, 3,22, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x24\x20\xf7\x22\x42\x20\x22\x33\x54\x14" }  },
      /* --- pixel bitmap for cmr180 char#118 v --- */
      { 118,49041,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9f\x77\x18\x43\x18\xc2\x19\x4c\x60\x02\x0e\x70\x80"
            "\x03\x08\x00" }  },
      /* --- pixel bitmap for cmr180 char#119 w --- */
      { 119,50292,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xdf\xf7\x86\x63\x8e\x63\x8c\x23\x4c\x22\x4c\x36\x58"
            "\x16\x38\x14\x38\x1c\x30\x0c\x10\x08" }  },
      /* --- pixel bitmap for cmr180 char#120 x --- */
      { 120,51271,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbe\x0f\x63\x60\x04\x58\x00\x0e\x80\x01\x38\x80\x0c"
            "\x18\x83\x61\x7c\x7e" }  },
      /* --- pixel bitmap for cmr180 char#121 y --- */
      { 121,52338,                      /* character number, location */
         11, 0,   -5, 0,      /* topleft row,col, and botleft row,col */
          { 12,   16, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\xcf\x61\x18\x82\x21\x38\x03\x13\x30\x01\x0e\xe0"
            "\x00\x0e\x40\x00\x04\x20\x30\x02\x13\xe0\x00" }  },
      /* --- pixel bitmap for cmr180 char#122 z --- */
      { 122,53303,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x87\x05\x0b\x03\x03\x07\x46\x86\x06\x0d\xff\x07" }  },
      /* --- pixel bitmap for cmr180 char#123 (noname) --- */
      { 123,120172,                     /* character number, location */
          7, 0,    6, 0,      /* topleft row,col, and botleft row,col */
          { 12,    1, 3, 2, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c" }  },
      /* --- pixel bitmap for cmr180 char#124 (noname) --- */
      { 124,120992,                     /* character number, location */
          7, 0,    6, 0,      /* topleft row,col, and botleft row,col */
          { 25,    1, 3, 4, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x0b" }  },
      /* --- pixel bitmap for cmr180 char#125 (noname) --- */
      { 125,108982,                     /* character number, location */
         17, 3,   13, 3,      /* topleft row,col, and botleft row,col */
          {  7,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x66\xf3\x2c\x02" }  },
      /* --- pixel bitmap for cmr180 char#126 \~ --- */
      { 126,109666,                     /* character number, location */
         17, 2,   14, 2,      /* topleft row,col, and botleft row,col */
          {  8,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x7e\x31" }  },
      /* --- pixel bitmap for cmr180 char#127 (noname) --- */
      { 127,110347,                     /* character number, location */
         18, 2,   15, 2,      /* topleft row,col, and botleft row,col */
          {  8,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x66\xe7\x66" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=6 for .210gf ---
 * mf '\mode=preview; mag=magstep(-13.80488502080647873125); input cmr10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmr210 --- */
static	chardef  cmr210[] =
   {
      /* --- pixel bitmap for cmr210 char#0 \Gamma --- */
      {   0,54819,                      /* character number, location */
         20, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 17,   20, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x02\x43\x73\x10\xf1\x33\x91\x10\xf2\x33\xa1\xfb"
            "\x33\xba\x71" }  },
      /* --- pixel bitmap for cmr210 char#1 \Delta --- */
      {   1,55738,                      /* character number, location */
         21, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 22,   21, 3,84, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\xa2\xa0\xf1\x94\x90\x81\x14\xe0\x21\x23\xe0\x11"
            "\x34\xe1\x43\xd1\x54\xc1\x63\xb1\x74\xa1\x83\x91\x94"
            "\x81\xa3\x71\xb4\x61\xc3\x52\xc4\x41\xe3\x20\xf1\x1e"
            "\x06\x1e\x08" }  },
      /* --- pixel bitmap for cmr210 char#2 \Theta --- */
      {   2,56889,                      /* character number, location */
         21, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 19,   22, 3,89, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x75\xc2\x52\x83\x73\x62\x92\x52\xb2\x20\xf1\x13\xb3"
            "\x10\x12\xd2\x13\x31\x51\x33\x0f\x23\x37\x33\x03\x31"
            "\x51\x33\x0f\x13\xd3\xf1\x13\xb3\x10\x22\xb2\x52\x92"
            "\x63\x73\x82\x52\xc5\x73" }  },
      /* --- pixel bitmap for cmr210 char#3 \Lambda --- */
      {   3,57875,                      /* character number, location */
         21, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   21, 3,62, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf2\x82\x80\xf2\x74\x70\x66\x60\xf2\x61\x23\x60\xf2"
            "\x51\x43\x50\xf2\x41\x63\x40\x31\x74\x30\xf1\x31\x83"
            "\x30\x22\x84\x26\x48" }  },
      /* --- pixel bitmap for cmr210 char#4 \Xi --- */
      {   4,59266,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   20, 3,56, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x0e\x03\x0f\x21\xe0\x11\xf2\xe0\x30\x31\x91\x30"
            "\xf1\x3b\x30\x31\x91\x30\xf2\xe0\x3f\x21\xe0\x11\x0f"
            "\x1e\x03" }  },
      /* --- pixel bitmap for cmr210 char#5 \Pi --- */
      {   5,60431,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 20,   20, 3,22, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x06\xfe\x33\x83\x30\xf2\x33\x83\x39\x29" }  },
      /* --- pixel bitmap for cmr210 char#6 \Sigma --- */
      {   6,61578,                      /* character number, location */
         20, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 17,   20, 3,75, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x02\x23\x93\x24\x92\x33\xa1\x43\xa1\x34\x91\x44"
            "\x81\x53\xe4\xe4\xe2\xe0\x11\xe0\x21\x81\x61\x91\x51"
            "\xa1\x41\xa2\x31\xb1\x31\xa3\x2e\x01\x1e\x02\x12" }  },
      /* --- pixel bitmap for cmr210 char#7 \Upsilon --- */
      {   7,62692,                      /* character number, location */
         21, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 19,   21, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x24\x74\x36\x56\x13\x23\x33\x24\x52\x32\x52\x62\x12"
            "\x61\x72\x12\xe0\x11\x11\x80\xfc\x83\x80\x4b\x41" }  },
      /* --- pixel bitmap for cmr210 char#8 \Phi --- */
      {   8,63750,                      /* character number, location */
         20, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 17,   20, 3,69, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3b\x30\xf2\x73\x70\x57\x83\x13\x13\x52\x33\x32\x32"
            "\x43\x42\x1f\x33\x43\x43\x12\x43\x42\x32\x33\x32\x53"
            "\x13\x13\x87\x50\xf2\x73\x70\x3b\x31" }  },
      /* --- pixel bitmap for cmr210 char#9 \Psi --- */
      {   9,64893,                      /* character number, location */
         20, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 19,   20, 3,61, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4b\x40\xf2\x83\x83\x53\x53\xf5\x13\x43\x43\x10\x22"
            "\x43\x42\x43\x33\x33\x53\x23\x23\x73\x13\x13\xa7\x60"
            "\xf2\x83\x80\x4b\x42" }  },
      /* --- pixel bitmap for cmr210 char#10 \Omega --- */
      {  10,66078,                      /* character number, location */
         21, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   21, 3,77, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x75\xc2\x52\x83\x73\x30\xf1\x23\x93\x20\xf4\x13\xb3"
            "\x10\x22\xb2\x43\x93\x20\xf1\x32\x92\x30\x42\x72\x41"
            "\x32\x72\x32\x41\x71\x43\x32\x52\x32\xf2\x16\x56\x12" }  },
      /* --- pixel bitmap for cmr210 char#11 \ff --- */
      {  11,112755,                     /* character number, location */
         20, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 19,   20, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x65\x34\x62\x43\x23\x41\x53\x33\x32\x62\x41\x10\xf2"
            "\x32\x62\x6e\x02\x30\xfa\x32\x62\x60\x16\x27\x32" }  },
      /* --- pixel bitmap for cmr210 char#12 \fi --- */
      {  12,113951,                     /* character number, location */
         20, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   20, 3,36, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x65\x92\x41\x71\x53\x52\x53\x20\xf2\x32\xad\x20\xfa"
            "\x32\x62\x20\x16\x26" }  },
      /* --- pixel bitmap for cmr210 char#13 \fl --- */
      {  13,115133,                     /* character number, location */
         20, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   20, 3,34, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x67\x63\x33\x61\x53\x20\xf3\x32\x62\x2d\x20\xfa\x32"
            "\x62\x20\x16\x26" }  },
      /* --- pixel bitmap for cmr210 char#14 \ffi --- */
      {  14,116766,                     /* character number, location */
         20, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 23,   20, 3,54, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x65\x35\x83\x41\x12\x41\x71\x53\x53\x52\x53\x53\x20"
            "\xf2\x32\x62\xae\x07\x20\xfa\x32\x62\x62\x20\x16\x26"
            "\x26" }  },
      /* --- pixel bitmap for cmr210 char#15 \ffl --- */
      {  15,118433,                     /* character number, location */
         20, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 23,   20, 3,54, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x65\x37\x63\x44\x33\x61\x53\x53\x52\x53\x62\x20\xf2"
            "\x32\x62\x62\x2e\x07\x20\xfa\x32\x62\x62\x20\x16\x26"
            "\x26" }  },
      /* --- pixel bitmap for cmr210 char#16 \imath --- */
      {  16,80265,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   13, 3,10, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x20\xfa\x22\x26" }  },
      /* --- pixel bitmap for cmr210 char#17 \jmath --- */
      {  17,80943,                      /* character number, location */
         13,-2,   -6,-2,      /* topleft row,col, and botleft row,col */
          {  8,   19, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x35\xfd\x62\x11\x45\x31\x13\x22\x25\x22" }  },
      /* --- pixel bitmap for cmr210 char#18 \gravesym --- */
      {  18,103978,                     /* character number, location */
         20, 3,   15, 3,      /* topleft row,col, and botleft row,col */
          {  6,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc3\xe1\x60\x20" }  },
      /* --- pixel bitmap for cmr210 char#19 \acutesym --- */
      {  19,104551,                     /* character number, location */
         20, 6,   15, 6,      /* topleft row,col, and botleft row,col */
          {  6,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\xce\x19\x01" }  },
      /* --- pixel bitmap for cmr210 char#20 \checksym --- */
      {  20,105180,                     /* character number, location */
         18, 4,   15, 4,      /* topleft row,col, and botleft row,col */
          {  7,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x63\x1f\x02" }  },
      /* --- pixel bitmap for cmr210 char#21 \brevesym --- */
      {  21,105798,                     /* character number, location */
         20, 3,   16, 3,      /* topleft row,col, and botleft row,col */
          {  9,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\x03\x1a\xe3\x03" }  },
      /* --- pixel bitmap for cmr210 char#22 (noname) --- */
      {  22,106382,                     /* character number, location */
         17, 2,   16, 2,      /* topleft row,col, and botleft row,col */
          { 11,    1, 3, 2, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0b" }  },
      /* --- pixel bitmap for cmr210 char#23 (noname) --- */
      {  23,107159,                     /* character number, location */
         21, 8,   16, 8,      /* topleft row,col, and botleft row,col */
          {  6,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x18\x86\x1e" }  },
      /* --- pixel bitmap for cmr210 char#24 (noname) --- */
      {  24,107855,                     /* character number, location */
         -1, 4,   -6, 4,      /* topleft row,col, and botleft row,col */
          {  7,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x18\x18\xfc\x03" }  },
      /* --- pixel bitmap for cmr210 char#25 \ss --- */
      {  25,82040,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   20, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x01\xc3\x30\x30\x06\xc6\xc0\x18\x08\x83\x78\x0e"
            "\x0c\x83\xc1\x30\x30\x06\xc4\x80\x19\x30\x03\x66\xc0"
            "\x0c\x98\x99\x31\x93\xc7\x01" }  },
      /* --- pixel bitmap for cmr210 char#26 \ae --- */
      {  26,83405,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xf0\x70\xd8\x98\x83\x83\x08\x0c\x0c\x60\x60\xf0"
            "\xff\x73\x18\xc0\xc0\x00\x03\x06\x18\x70\xc0\x80\x03"
            "\x0d\x36\xc4\x0f\x1e" }  },
      /* --- pixel bitmap for cmr210 char#27 \oe --- */
      {  27,84543,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 21,   13, 3,61, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x44\x64\x52\x42\x22\x42\x22\x64\x52\x21\x83\x64\x82"
            "\x74\x8b\x0f\x22\x82\x90\x12\x64\x92\x64\x71\x22\x42"
            "\x22\x51\x54\x65\x26" }  },
      /* --- pixel bitmap for cmr210 char#28 (noname) --- */
      {  28,85377,                      /* character number, location */
         15, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          { 13,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x08\x80\xc1\x17\x06\x63\xe0\x04\xd2\x60\x1e\xc4"
            "\x43\x78\x08\x8f\x60\x19\x64\xc1\x18\x0c\x7e\x20\x00"
            "\x06\x40\x00\x00" }  },
      /* --- pixel bitmap for cmr210 char#29 \AE --- */
      {  29,87177,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 24,   20, 3,113, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x6e\x02\xb1\x13\x62\xa2\x13\x71\xa1\x23\x71\xa1\x23"
            "\x81\x10\xf1\x71\x33\x81\x10\x71\x33\x51\xa1\x43\x51"
            "\xa1\x43\x42\xae\x91\x53\x42\x40\xf1\x51\x53\x51\x31"
            "\x41\x63\x91\x41\x63\x82\x32\x63\x81\x41\x73\x81\x33"
            "\x63\x63\x16\x3e\x15" }  },
      /* --- pixel bitmap for cmr210 char#30 \OE --- */
      {  30,88905,                      /* character number, location */
         21, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 26,   22, 3,119, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x75\xe0\x52\x4d\x53\x64\x62\x52\x74\x71\x42\x84\x71"
            "\x20\xf1\x13\x84\x81\x13\x94\x51\x21\x13\xa3\x51\x43"
            "\xa3\x42\x43\xa9\x43\xa3\x42\x43\xa3\x51\x43\xa3\x51"
            "\x34\x94\x91\x13\x84\x91\x13\x84\x82\xf1\x23\x74\x81"
            "\x10\x33\x64\x63\x62\x4e\x85\xe0" }  },
      /* --- pixel bitmap for cmr210 char#31 (noname) --- */
      {  31,89923,                      /* character number, location */
         21, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 19,   22, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x0f\x01\x83\x05\x0e\x38\x30\x80\xc1\x00\x1a\x07"
            "\xd8\x19\x40\xcc\x00\x61\x07\x0c\x3f\x20\xf8\x81\xc0"
            "\x0f\x04\x7e\x10\xf0\xc3\x80\x1f\x02\xdc\x08\x60\x6e"
            "\x80\x63\x01\x0c\x06\x30\x70\xc0\x81\x06\x03\xc2\x07"
            "\x00" }  },
      /* --- pixel bitmap for cmr210 char#32 (noname) --- */
      {  32,108355,                     /* character number, location */
         12, 1,    8, 1,      /* topleft row,col, and botleft row,col */
          {  6,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x7e\x04" }  },
      /* --- pixel bitmap for cmr210 char#33 ! --- */
      {  33,90616,                      /* character number, location */
         21, 3,    0, 3,      /* topleft row,col, and botleft row,col */
          {  3,   21, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfa\xff\xff\x92\x24\x01\x80\x2e" }  },
      /* --- pixel bitmap for cmr210 char#34 " --- */
      {  34,119412,                     /* character number, location */
         20, 1,   11, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x82\x8e\x1b\x26\x48\x90\xa0\x20\x41\x41\x00" }  },
      /* --- pixel bitmap for cmr210 char#35 # --- */
      {  35,92096,                      /* character number, location */
         20, 2,   -6, 2,      /* topleft row,col, and botleft row,col */
          { 20,   26, 3,79, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf2\x92\x42\x30\x83\x33\x30\xf2\x82\x42\x40\x73\x33"
            "\xb2\x42\x5f\x1e\x06\xf3\x62\x42\x6f\x1e\x06\x52\x42"
            "\xb3\x33\x70\xf2\x42\x42\x80\x33\x33\x80\xf2\x32\x42"
            "\x92" }  },
      /* --- pixel bitmap for cmr210 char#36 $ --- */
      {  36,76445,                      /* character number, location */
         22, 2,   -2, 2,      /* topleft row,col, and botleft row,col */
          { 11,   24, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x00\x01\x3e\x58\x62\xa2\x11\x8e\x7c\xe4\x27\x7a"
            "\x81\x1f\xf8\x83\x3f\xd0\x81\x5c\xc4\x27\x1e\x71\x88"
            "\x44\x46\x1a\x7c\x80\x00\x04" }  },
      /* --- pixel bitmap for cmr210 char#37 % --- */
      {  37,93357,                      /* character number, location */
         22, 2,   -2, 2,      /* topleft row,col, and botleft row,col */
          { 20,   24, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x00\x43\x04\x38\xc6\xc0\x31\xf8\x1f\x83\xe0\x30"
            "\x08\x06\x83\x70\x30\x08\x03\x83\x38\x60\xc4\x01\x44"
            "\x0c\x80\xe3\x00\x00\x87\x03\x30\x44\x80\x63\x04\x1c"
            "\x83\xc0\x30\x08\x0e\x83\x60\x30\x08\x07\x83\x38\x30"
            "\x88\x01\x46\x1c\x40\xc4\x00\x38" }  },
      /* --- pixel bitmap for cmr210 char#38 & --- */
      {  38,77747,                      /* character number, location */
         21, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 21,   22, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x01\x00\x4c\x00\x80\x10\x00\x18\x02\x00\x43\x00"
            "\x60\x08\x00\x8c\x00\x80\x09\x00\xb0\xc0\x1f\x1c\xe0"
            "\x80\x01\x0c\x78\x80\x80\x0c\x08\x88\x03\x81\x61\x10"
            "\x10\x18\x01\x03\x27\x60\xc0\x02\x0d\x30\x20\x03\x0e"
            "\xc4\x30\x43\xf0\x81\x07" }  },
      /* --- pixel bitmap for cmr210 char#39 ' --- */
      {  39,94051,                      /* character number, location */
         20, 3,   11, 3,      /* topleft row,col, and botleft row,col */
          {  3,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x49\x4a\x01" }  },
      /* --- pixel bitmap for cmr210 char#40 ( --- */
      {  40,94631,                      /* character number, location */
         22, 2,   -8, 2,      /* topleft row,col, and botleft row,col */
          {  7,   30, 3,50, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x61\x51\x51\x52\x51\x52\x51\x52\x40\xf1\x11\x5f\x92"
            "\x50\xf1\x11\x50\x12\x61\x62\x61\x62\x61\x71\x71" }  },
      /* --- pixel bitmap for cmr210 char#41 ) --- */
      {  41,95254,                      /* character number, location */
         22, 2,   -8, 2,      /* topleft row,col, and botleft row,col */
          {  7,   30, 3,51, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\x71\x71\x62\x61\x62\x61\x62\x10\xf1\x51\x10\xf9"
            "\x52\xf1\x51\x10\x42\x51\x52\x51\x52\x51\x51\x51\x62" }  },
      /* --- pixel bitmap for cmr210 char#42 * --- */
      {  42,95901,                      /* character number, location */
         22, 2,    9, 2,      /* topleft row,col, and botleft row,col */
          { 11,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x00\x01\x08\x46\xfc\x7a\xfe\xc0\x81\x3f\xaf\x1f"
            "\x31\x08\x40\x00\x02" }  },
      /* --- pixel bitmap for cmr210 char#43 + --- */
      {  43,96599,                      /* character number, location */
         17, 2,   -3, 2,      /* topleft row,col, and botleft row,col */
          { 19,   20, 3,15, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x92\x8f\x1e\x05\xf8\x92\x87" }  },
      /* --- pixel bitmap for cmr210 char#44 (noname) --- */
      {  44,97194,                      /* character number, location */
          3, 3,   -6, 3,      /* topleft row,col, and botleft row,col */
          {  3,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x49\x4a\x01" }  },
      /* --- pixel bitmap for cmr210 char#45 (noname) --- */
      {  45,119927,                     /* character number, location */
          7, 0,    5, 0,      /* topleft row,col, and botleft row,col */
          {  8,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\xff" }  },
      /* --- pixel bitmap for cmr210 char#46 (noname) --- */
      {  46,97665,                      /* character number, location */
          3, 3,    0, 3,      /* topleft row,col, and botleft row,col */
          {  3,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x00" }  },
      /* --- pixel bitmap for cmr210 char#47 / --- */
      {  47,98173,                      /* character number, location */
         22, 2,   -7, 2,      /* topleft row,col, and botleft row,col */
          { 11,   29, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x06\x30\xc0\x01\x06\x30\xc0\x01\x06\x30\xc0\x01"
            "\x06\x30\xc0\x01\x06\x30\xc0\x01\x06\x30\xc0\x01\x06"
            "\x30\xc0\x01\x06\x30\xc0\x01\x06\x30\xc0\x01\x06\x30"
            "\x00" }  },
      /* --- pixel bitmap for cmr210 char#48 0 --- */
      {  48,66830,                      /* character number, location */
         20, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 13,   21, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\x72\x32\x51\x71\x32\x72\x21\x91\x1f\xa2\x92\x11"
            "\x91\x22\x72\x31\x71\x52\x32\x75\x42" }  },
      /* --- pixel bitmap for cmr210 char#49 1 --- */
      {  49,67632,                      /* character number, location */
         20, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 10,   20, 3,20, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x42\x73\x43\x12\x40\xfe\x42\x40\x42\x4a" }  },
      /* --- pixel bitmap for cmr210 char#50 2 --- */
      {  50,68615,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   20, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\x62\x43\x31\x82\x13\x72\x14\x67\x72\x12\x82\xf1"
            "\xa3\xa2\xa2\xa2\xa2\xa2\xa2\xa2\x61\x31\x81\x21\x81"
            "\x2b\x1c\x12" }  },
      /* --- pixel bitmap for cmr210 char#51 3 --- */
      {  51,69663,                      /* character number, location */
         20, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 13,   21, 3,63, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\x71\x43\x41\x62\x20\xf2\x13\x53\x10\xf1\x92\x20"
            "\x82\x75\xc3\xb3\xb2\xb3\x12\x73\x0f\x14\x63\x03\x72"
            "\x21\x73\x32\x43\x65\x43" }  },
      /* --- pixel bitmap for cmr210 char#52 4 --- */
      {  52,70605,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   20, 3,56, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x82\x30\x73\x94\x91\x12\x81\x22\x72\x22\x71\x32"
            "\x61\x42\x52\x42\x51\x52\x41\x62\x32\x62\x3d\xf4\x82"
            "\x30\x58" }  },
      /* --- pixel bitmap for cmr210 char#53 5 --- */
      {  53,71653,                      /* character number, location */
         20, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 13,   21, 3,65, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x22\x52\x48\x57\x61\x21\x70\xf2\x21\xa0\x21\x24\x61"
            "\x11\x42\x42\x52\x41\x72\x10\xf2\xa3\x0f\x23\x73\x11"
            "\x82\x21\x72\x42\x42\x75\x42" }  },
      /* --- pixel bitmap for cmr210 char#54 6 --- */
      {  54,72567,                      /* character number, location */
         20, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 13,   21, 3,67, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x64\x72\x41\x52\x43\x32\x53\x31\xb2\xb1\xb2\x34\x42"
            "\x12\x41\x33\x71\x23\x72\x1f\x32\x92\x11\x92\x12\x82"
            "\x12\x72\x31\x71\x52\x41\x75\x42" }  },
      /* --- pixel bitmap for cmr210 char#55 7 --- */
      {  55,73491,                      /* character number, location */
         20, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 13,   21, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x11\xcc\x1b\x21\x91\x11\x91\x21\x81\x30\xf1\x81\x40"
            "\x71\x50\xf1\x61\x60\xf1\x52\x60\xf2\x42\x70\xf3\x33"
            "\x70\x41\x81" }  },
      /* --- pixel bitmap for cmr210 char#56 8 --- */
      {  56,74419,                      /* character number, location */
         20, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 13,   21, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x01\x61\x10\x18\x03\x66\xc0\x0c\x98\x03\xe3\x31"
            "\x7c\x03\x3f\xc0\x0f\xc6\x63\xf0\x04\xf8\x00\x1e\xc0"
            "\x03\x78\x00\x19\x30\x06\x03\x1f\x00" }  },
      /* --- pixel bitmap for cmr210 char#57 9 --- */
      {  57,75341,                      /* character number, location */
         20, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 13,   21, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x01\x41\x10\x10\x03\x36\xc0\x06\xd0\x00\x1e\xc0"
            "\x03\x78\x00\x1b\x70\x02\x8e\xb0\xe1\x31\x00\x02\x60"
            "\x00\xcc\xc1\x38\x08\xc2\x80\x0f\x00" }  },
      /* --- pixel bitmap for cmr210 char#58 : --- */
      {  58,98777,                      /* character number, location */
         13, 3,    0, 3,      /* topleft row,col, and botleft row,col */
          {  3,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x00\x00\x80\x2e" }  },
      /* --- pixel bitmap for cmr210 char#59 ; --- */
      {  59,99444,                      /* character number, location */
         13, 3,   -6, 3,      /* topleft row,col, and botleft row,col */
          {  3,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x00\x00\x80\x6e\x92\x52\x00" }  },
      /* --- pixel bitmap for cmr210 char#60 (noname) --- */
      {  60,91238,                      /* character number, location */
         15, 3,   -7, 3,      /* topleft row,col, and botleft row,col */
          {  3,   22, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x00\x40\x92\x24\xfd\xff\x7f\x01" }  },
      /* --- pixel bitmap for cmr210 char#61 = --- */
      {  61,100128,                     /* character number, location */
         11, 2,    3, 2,      /* topleft row,col, and botleft row,col */
          { 19,    8, 3,16, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x0e\x05\xf3\xe0\x5f\x1e\x05" }  },
      /* --- pixel bitmap for cmr210 char#62 (noname) --- */
      {  62,79646,                      /* character number, location */
         15, 2,   -6, 2,      /* topleft row,col, and botleft row,col */
          { 10,   21, 3,45, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x41\x83\x81\x50\xf3\xa0\xf3\x41\x50\x32\x81\x82\x72"
            "\x72\x8f\x12\x53\x02\x62\x12\x42\x35\x33" }  },
      /* --- pixel bitmap for cmr210 char#63 ? --- */
      {  63,78724,                      /* character number, location */
         20, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 10,   20, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x26\x31\x52\x12\x62\x0f\x13\x52\x72\x72\x72\x81\x40"
            "\xf3\x41\x50\xf3\xa0\x41\x83\x81\x53" }  },
      /* --- pixel bitmap for cmr210 char#64 @ --- */
      {  64,101302,                     /* character number, location */
         20, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 19,   20, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x0f\x00\x83\x01\x06\x30\x08\x00\x42\x78\x10\x61"
            "\x0c\x89\xc1\x29\x04\x8c\x31\x60\x8c\x01\x63\x0c\x18"
            "\x63\xc0\x18\x02\x46\x31\x38\x0a\xe3\x89\xf0\x38\x04"
            "\x00\xc0\x00\x00\x18\xe0\x01\xff\x01" }  },
      /* --- pixel bitmap for cmr210 char#65 A --- */
      {  65, 1026,                      /* character number, location */
         21, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 20,   21, 3,60, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf2\x92\x90\xf2\x84\x80\xf2\x71\x23\x70\xf2\x61\x43"
            "\x60\xf1\x51\x63\x50\x5a\x50\xf2\x41\x83\x40\x31\xa3"
            "\x53\x93\x37\x49" }  },
      /* --- pixel bitmap for cmr210 char#66 B --- */
      {  66, 2344,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   20, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x73\x72\x63\x73\x20\xf3\x33\x83\x10\x33\x73\x53"
            "\x63\x6b\x73\x73\x53\x83\x10\xf4\x33\x93\x33\x83\x43"
            "\x73\x2e\x47" }  },
      /* --- pixel bitmap for cmr210 char#67 C --- */
      {  67, 3289,                      /* character number, location */
         21, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 17,   22, 3,67, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x75\x41\x52\x52\x12\x42\x83\x32\xa2\x22\xb2\xf1\x13"
            "\xc1\x12\xd1\x0f\x53\xe0\x12\xd1\xf1\x13\xc1\x22\xb1"
            "\x42\xa1\x52\x81\x72\x52\xa5\x50" }  },
      /* --- pixel bitmap for cmr210 char#68 D --- */
      {  68, 4395,                      /* character number, location */
         20, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 20,   20, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x93\x73\x73\x92\x63\xa2\x53\xa3\x10\xf1\x33\xb2"
            "\x10\xf6\x33\xb3\x33\xb2\x43\xa3\x43\xa2\x53\x92\x63"
            "\x73\x4e\x62" }  },
      /* --- pixel bitmap for cmr210 char#69 E --- */
      {  69, 5808,                      /* character number, location */
         20, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 19,   20, 3,83, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x03\x53\x83\x20\xf1\x33\xa1\x20\xf1\x33\xb1\x10"
            "\x33\x61\x41\x43\x61\x93\x52\x9a\x93\x52\x93\x61\x93"
            "\x61\x51\xf1\x33\xc1\x33\xb2\x33\xb1\x43\xa2\x43\x93"
            "\x1e\x04\x10" }  },
      /* --- pixel bitmap for cmr210 char#70 F --- */
      {  70, 7055,                      /* character number, location */
         20, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 18,   20, 3,61, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x03\x43\x83\x10\xf1\x33\xa1\x10\xf1\x33\xb1\x33"
            "\x61\x41\x33\x61\x83\x52\x8a\x83\x52\x50\xf1\x33\x61"
            "\x50\xf5\x33\xca\x81" }  },
      /* --- pixel bitmap for cmr210 char#71 G --- */
      {  71, 8236,                      /* character number, location */
         21, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 20,   22, 3,85, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x76\x41\x73\x52\x12\x62\x93\x52\xa3\x42\xc2\x20\xf1"
            "\x13\xd1\x20\x12\xe1\x2f\x33\xe0\x33\x8c\xc3\x32\xc3"
            "\x20\xf1\x13\xb3\x20\x22\xb3\x52\xa3\x62\x81\x12\x73"
            "\x51\x31\x96\x70" }  },
      /* --- pixel bitmap for cmr210 char#72 H --- */
      {  72, 9431,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 20,   20, 3,26, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x09\x29\xf7\x33\x83\x30\x3e\x30\xf8\x33\x83\x39\x29" }  },
      /* --- pixel bitmap for cmr210 char#73 I --- */
      {  73,10122,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   20, 3,14, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x09\xfe\x33\x30\xf2\x33\x39" }  },
      /* --- pixel bitmap for cmr210 char#74 J --- */
      {  74,10930,                      /* character number, location */
         20, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 13,   21, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x49\xfd\x83\x20\x12\x53\x2f\x14\x43\x20\x12\x43\x42"
            "\x42\x74\x60" }  },
      /* --- pixel bitmap for cmr210 char#75 K --- */
      {  75,12093,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 21,   20, 3,82, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x09\x47\x43\x93\x63\x91\x83\x81\x93\x71\xa3\x61\xb3"
            "\x51\xc3\x41\xd3\x33\xc3\x24\xc3\x11\x23\xb4\x34\xa3"
            "\x53\xa3\x63\x93\x64\x83\x73\x83\x83\x73\x84\x63\x94"
            "\x29\x48" }  },
      /* --- pixel bitmap for cmr210 char#76 L --- */
      {  76,13060,                      /* character number, location */
         20, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 17,   20, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0a\x70\xfa\x33\xb0\xf2\x33\xa1\x33\x92\x33\x91\x43"
            "\x82\x43\x73\x1e\x02\x13" }  },
      /* --- pixel bitmap for cmr210 char#77 M --- */
      {  77,14348,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 25,   20, 3,94, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07\xb7\xf1\x34\xb4\x30\xf1\x31\x13\x91\x13\x30\xf2"
            "\x31\x23\x71\x23\x30\xf2\x31\x33\x51\x33\x30\xf1\x31"
            "\x43\x31\x43\x30\xf2\x31\x53\x11\x53\x30\xf1\x31\x63"
            "\x63\x30\x23\x53\x63\x37\x41\x49" }  },
      /* --- pixel bitmap for cmr210 char#78 N --- */
      {  78,15518,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 20,   20, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\xe0\x8f\x07\x38\x78\x00\x81\x0e\x10\xc8\x01\x81"
            "\x3c\x10\x88\x03\x81\x70\x10\x08\x0f\x81\xe0\x10\x08"
            "\x1c\x81\x80\x13\x08\x38\x81\x00\x17\x08\xe0\x81\x00"
            "\x1e\x08\xc0\x81\x00\x18\x1c\x80\xf1\x07\x10" }  },
      /* --- pixel bitmap for cmr210 char#79 O --- */
      {  79,16407,                      /* character number, location */
         21, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 19,   22, 3,63, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x75\xc2\x52\x83\x73\x62\x92\x52\xb2\x33\xb3\x10\xf1"
            "\x12\xd2\x1f\x63\xd3\xf1\x13\xb3\x10\x22\xb2\x52\x92"
            "\x63\x73\x82\x52\xc5\x71" }  },
      /* --- pixel bitmap for cmr210 char#80 P --- */
      {  80,17542,                      /* character number, location */
         20, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 18,   20, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x73\x73\x53\x83\x10\xf4\x33\x93\x33\x83\x43\x73"
            "\x5b\x40\xf7\x33\xc9\x91" }  },
      /* --- pixel bitmap for cmr210 char#81 Q --- */
      {  81,18575,                      /* character number, location */
         21, 2,   -6, 2,      /* topleft row,col, and botleft row,col */
          { 19,   27, 3,93, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x75\xc2\x52\x83\x73\x62\x92\x52\xb2\x20\xf1\x13\xb3"
            "\x10\x12\xd2\x1f\x63\xd3\xf1\x13\xb3\x10\x22\x43\x42"
            "\x52\x21\x31\x22\x63\x11\x35\x83\x42\x41\x76\x51\xc2"
            "\x41\xc2\x32\xf1\xd5\x10\xe3\x21" }  },
      /* --- pixel bitmap for cmr210 char#82 R --- */
      {  82,19906,                      /* character number, location */
         20, 0,   -1, 0,      /* topleft row,col, and botleft row,col */
          { 21,   21, 3,71, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0d\xb3\x63\x93\x73\x50\xf3\x33\x83\x40\x33\x73\x83"
            "\x63\x9a\xb3\x62\xa3\x63\x60\xf3\x33\x73\x50\xf1\x33"
            "\x73\x41\x33\x82\x4a\x53\x21\xe0\x33\x21" }  },
      /* --- pixel bitmap for cmr210 char#83 S --- */
      {  83,20979,                      /* character number, location */
         21, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 12,   22, 3,63, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x35\x31\x21\x51\x12\x12\x63\x11\x82\x0f\x22\x91\x03"
            "\xa3\x97\x68\x58\x84\xa3\xa2\x0f\x21\x92\x02\x81\x12"
            "\x72\x14\x42\x21\x35\x33" }  },
      /* --- pixel bitmap for cmr210 char#84 T --- */
      {  84,22085,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   20, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\x03\x22\x53\x52\x10\xf1\x11\x63\x61\x1f\x21\x73"
            "\x71\xfb\x83\x80\x4b\x43" }  },
      /* --- pixel bitmap for cmr210 char#85 U --- */
      {  85,23085,                      /* character number, location */
         20, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 20,   21, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x09\x47\x33\x93\x20\xfd\x33\xa1\x30\x42\x91\x83\x81"
            "\x92\x71\xb3\x41\xe5\x73" }  },
      /* --- pixel bitmap for cmr210 char#86 V --- */
      {  86,24097,                      /* character number, location */
         20, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 20,   21, 3,71, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x66\x24\xa2\x20\xf1\x33\xa1\x30\x34\x91\x30\xf1"
            "\x43\x81\x40\xf2\x53\x61\x50\xf2\x63\x41\x60\xf1\x73"
            "\x21\x70\x76\x70\xf1\x84\x80\xf2\x92\x91" }  },
      /* --- pixel bitmap for cmr210 char#87 W --- */
      {  87,25529,                      /* character number, location */
         20, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 28,   21, 3,119, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x08\x29\x36\x23\x83\x82\x43\x83\x91\x20\xf2\x33\x74"
            "\x71\x30\x43\x64\x61\x40\xf1\x43\x51\x23\x51\x40\x53"
            "\x41\x23\x41\x50\xf1\x53\x31\x43\x31\x50\x54\x21\x43"
            "\x31\x50\xf2\x63\x11\x63\x11\x60\x74\x64\x70\xf1\x73"
            "\x83\x70\x82\x82\xe0\x21\xa1\x80" }  },
      /* --- pixel bitmap for cmr210 char#88 X --- */
      {  88,26680,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 20,   20, 3,78, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x09\x28\x44\x63\x83\x71\x94\x51\xb3\x42\xc3\x31\xd4"
            "\x11\xe0\x15\xe0\x23\x90\xf1\x84\x80\x85\xe1\x23\xd2"
            "\x33\xc1\x44\xa1\x63\xa1\x73\x81\x84\x63\x74\x37\x58" }  },
      /* --- pixel bitmap for cmr210 char#89 Y --- */
      {  89,27838,                      /* character number, location */
         20, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 22,   20, 3,59, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x09\x67\x34\xa2\x73\xa1\x93\x82\x94\x71\xb3\x62\xc3"
            "\x51\xd4\x31\xe0\x13\x31\xe0\x14\x11\xe0\x35\x80\xf7"
            "\xa3\x90\x79\x61" }  },
      /* --- pixel bitmap for cmr210 char#90 Z --- */
      {  90,28891,                      /* character number, location */
         20, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 15,   20, 3,68, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x14\x64\x12\x83\x22\x73\x31\x83\x3f\x11\x73\x40"
            "\x73\x50\xf1\x63\x60\xf1\x53\x70\x43\x71\xf1\x33\x81"
            "\x23\x91\x23\x82\x13\x96\x7e\x05" }  },
      /* --- pixel bitmap for cmr210 char#91 [ --- */
      {  91,102065,                     /* character number, location */
         22, 2,   -7, 2,      /* topleft row,col, and botleft row,col */
          {  6,   29, 3,16, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x06\x0f\xe2\x4f\x92\x4f\x16" }  },
      /* --- pixel bitmap for cmr210 char#92 (noname) --- */
      {  92,120796,                     /* character number, location */
         20, 5,   11, 5,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x05\x09\x0a\x12\x24\xc8\xb0\xe3\x82\x00" }  },
      /* --- pixel bitmap for cmr210 char#93 ] --- */
      {  93,102771,                     /* character number, location */
         22, 0,   -7, 0,      /* topleft row,col, and botleft row,col */
          {  6,   29, 3,16, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x06\xfe\x42\xf9\x42\x0f\x16" }  },
      /* --- pixel bitmap for cmr210 char#94 \^ --- */
      {  94,108984,                     /* character number, location */
         20, 4,   16, 4,      /* topleft row,col, and botleft row,col */
          {  7,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x8a\x28\x08" }  },
      /* --- pixel bitmap for cmr210 char#95 (noname) --- */
      {  95,109455,                     /* character number, location */
         20, 2,   17, 2,      /* topleft row,col, and botleft row,col */
          {  4,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf6\x06" }  },
      /* --- pixel bitmap for cmr210 char#96 (noname) --- */
      {  96,103397,                     /* character number, location */
         20, 3,   11, 3,      /* topleft row,col, and botleft row,col */
          {  3,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x94\x92\xec\x02" }  },
      /* --- pixel bitmap for cmr210 char#97 a --- */
      {  97,30049,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x80\xc3\xe0\x60\x10\x18\x00\x06\xf8\xc1\x61\x18"
            "\x18\x03\xc6\x80\x39\x60\x1a\x9c\xfc\x1c" }  },
      /* --- pixel bitmap for cmr210 char#98 b --- */
      {  98,31067,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   20, 3,51, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\xa0\xf5\x22\xa0\x22\x24\x64\x42\x43\x62\x32\x72"
            "\x10\xf4\x22\x82\x22\x72\x33\x61\x44\x41\x51\x34\x41" }  },
      /* --- pixel bitmap for cmr210 char#99 c --- */
      {  99,31858,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   13, 3,33, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x46\x32\x43\x12\x53\x12\x61\x1f\x42\x90\x12\x92\x71"
            "\x22\x51\x55\x22" }  },
      /* --- pixel bitmap for cmr210 char#100 d --- */
      { 100,32861,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   20, 3,52, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x84\x20\xf5\xa2\x20\x44\x22\x51\x44\x41\x72\x32\x72"
            "\x2f\x42\x82\x20\x12\x72\x32\x63\x42\x41\x12\x64\x24" }  },
      /* --- pixel bitmap for cmr210 char#101 e --- */
      { 101,33639,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x60\x88\x81\x04\x3c\xe0\xff\x0f\x60\x00\x03\x30"
            "\x80\x01\x19\x04\x1f" }  },
      /* --- pixel bitmap for cmr210 char#102 f --- */
      { 102,34470,                      /* character number, location */
         20, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,   20, 3,33, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x64\x52\x23\x32\x33\x32\x41\x10\xf2\x32\x68\x30\xfa"
            "\x32\x60\x17\x35" }  },
      /* --- pixel bitmap for cmr210 char#103 g --- */
      { 103,35717,                      /* character number, location */
         14, 1,   -7, 1,      /* topleft row,col, and botleft row,col */
          { 14,   21, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x1c\x9c\xc8\x18\x13\x04\x06\x83\xc1\x60\x30\x10"
            "\x04\x8c\x01\x1d\x60\x00\x18\x00\xfc\x03\xff\x63\xc0"
            "\x0c\x60\x03\xd8\x00\x66\xc0\x30\x18\xf8\x03" }  },
      /* --- pixel bitmap for cmr210 char#104 h --- */
      { 104,36718,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   20, 3,36, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\xa0\xf5\x22\xa0\x22\x24\x62\x11\x32\x53\x52\x20"
            "\xf8\x22\x62\x26\x26" }  },
      /* --- pixel bitmap for cmr210 char#105 i --- */
      { 105,37451,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   20, 3,20, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x21\x43\x41\x30\xf3\x64\x20\xfa\x22\x26" }  },
      /* --- pixel bitmap for cmr210 char#106 j --- */
      { 106,38227,                      /* character number, location */
         20,-2,   -6,-2,      /* topleft row,col, and botleft row,col */
          {  8,   26, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x61\x63\x61\x10\xf3\x80\x35\xfd\x62\x11\x45\x31\x13"
            "\x22\x25\x22" }  },
      /* --- pixel bitmap for cmr210 char#107 k --- */
      { 107,39333,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   20, 3,64, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x90\xf5\x22\x90\x22\x45\x22\x52\x42\x51\x52\x41"
            "\x62\x22\x72\x12\x83\x12\x50\xf1\x22\x32\x40\x22\x42"
            "\x52\x43\x42\x53\x16\x25" }  },
      /* --- pixel bitmap for cmr210 char#108 l --- */
      { 108,39970,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   20, 3,16, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x20\xfe\x22\x20\xf2\x22\x26" }  },
      /* --- pixel bitmap for cmr210 char#109 m --- */
      { 109,41289,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 22,   13, 3,38, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x24\x44\x62\x11\x32\x21\x32\x53\x53\x52\x20\xf8"
            "\x22\x62\x62\x26\x26\x26" }  },
      /* --- pixel bitmap for cmr210 char#110 n --- */
      { 110,42296,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   13, 3,26, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x24\x62\x11\x32\x53\x52\x20\xf8\x22\x62\x26\x26" }  },
      /* --- pixel bitmap for cmr210 char#111 o --- */
      { 111,43007,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   13, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\x62\x52\x32\x72\x21\x91\x1f\x42\x92\xf1\x12\x72"
            "\x10\x22\x52\x65\x46" }  },
      /* --- pixel bitmap for cmr210 char#112 p --- */
      { 112,44085,                      /* character number, location */
         13, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 14,   19, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x24\x64\x42\x43\x62\x32\x72\x10\xf4\x22\x82\x22"
            "\x72\x33\x61\x44\x32\x52\x24\x40\xf4\x22\xa6\x82" }  },
      /* --- pixel bitmap for cmr210 char#113 q --- */
      { 113,45105,                      /* character number, location */
         13, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 14,   19, 3,54, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x44\x31\x52\x31\x12\x41\x63\x32\x72\x2f\x42\x82\x20"
            "\x12\x72\x32\x63\x42\x41\x12\x64\x22\x20\xf4\xa2\x20"
            "\x86" }  },
      /* --- pixel bitmap for cmr210 char#114 r --- */
      { 114,45984,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   13, 3,25, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x14\x10\xf1\x23\x23\x22\x41\x10\xf7\x22\x67\x30" }  },
      /* --- pixel bitmap for cmr210 char#115 s --- */
      { 115,46927,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\x84\x0d\x1a\x74\xc0\x07\x3f\xe0\x81\x03\x0f\x3e"
            "\x96\x07" }  },
      /* --- pixel bitmap for cmr210 char#116 t --- */
      { 116,47764,                      /* character number, location */
         18, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   18, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf2\x31\x40\x22\x53\x48\xf6\x22\x40\xf2\x22\x31\x31"
            "\x31\x43\x15" }  },
      /* --- pixel bitmap for cmr210 char#117 u --- */
      { 117,48697,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   13, 3,26, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x44\x20\xf8\x22\x62\x20\x22\x53\x51\x44\x64\x24" }  },
      /* --- pixel bitmap for cmr210 char#118 v --- */
      { 118,49575,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f\x9e\x81\x31\x10\x06\x82\x21\x30\x04\x4c\x80\x09"
            "\x30\x01\x1c\x80\x03\x70\x00\x04\x00" }  },
      /* --- pixel bitmap for cmr210 char#119 w --- */
      { 119,50834,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f\x9f\x77\x30\x18\x43\x41\x18\x1a\xc2\xd0\x10\x4c"
            "\x44\x60\x62\x02\x13\x13\x70\x50\x80\x83\x03\x1c\x1c"
            "\xc0\x60\x00\x02\x02" }  },
      /* --- pixel bitmap for cmr210 char#120 x --- */
      { 120,51829,                      /* character number, location */
         13, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   13, 3,46, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x15\x35\x42\x52\x72\x41\x82\x31\xa2\x11\xc3\xd2\xc3"
            "\xb1\x22\x92\x32\x81\x43\x62\x52\x36\x36" }  },
      /* --- pixel bitmap for cmr210 char#121 y --- */
      { 121,52904,                      /* character number, location */
         13, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 13,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f\x9e\x81\x31\x10\x06\x82\x21\x30\x04\x4c\x80\x09"
            "\x30\x01\x1c\x80\x03\x70\x00\x04\x80\x00\x08\x38\x01"
            "\x27\xe0\x02\x38\x00" }  },
      /* --- pixel bitmap for cmr210 char#122 z --- */
      { 122,53881,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x1f\x58\xe0\x02\x13\x0c\x30\xc0\x01\x86\x18\x64"
            "\xa0\x03\x0d\xfc\x7f" }  },
      /* --- pixel bitmap for cmr210 char#123 (noname) --- */
      { 123,121416,                     /* character number, location */
          9, 0,    8, 0,      /* topleft row,col, and botleft row,col */
          { 15,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x7f" }  },
      /* --- pixel bitmap for cmr210 char#124 (noname) --- */
      { 124,122236,                     /* character number, location */
          9, 0,    8, 0,      /* topleft row,col, and botleft row,col */
          { 29,    1, 2, 2, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x1d" }  },
      /* --- pixel bitmap for cmr210 char#125 (noname) --- */
      { 125,110134,                     /* character number, location */
         20, 4,   15, 4,      /* topleft row,col, and botleft row,col */
          {  9,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x19\x1b\x1b\x13\x02" }  },
      /* --- pixel bitmap for cmr210 char#126 \~ --- */
      { 126,110822,                     /* character number, location */
         19, 2,   16, 2,      /* topleft row,col, and botleft row,col */
          { 11,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\xf4\x5f\x70\x00" }  },
      /* --- pixel bitmap for cmr210 char#127 (noname) --- */
      { 127,111503,                     /* character number, location */
         20, 3,   17, 3,      /* topleft row,col, and botleft row,col */
          {  9,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x82\x8e\x0b\x02" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=7 for .250gf ---
 * mf '\mode=preview; mag=magstep(-12.84858895680446863032); input cmr10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmr250 --- */
static	chardef  cmr250[] =
   {
      /* --- pixel bitmap for cmr250 char#0 \Gamma --- */
      {   0,55643,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 21,   24, 3,33, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x06\x53\xa3\x53\xb2\x53\xc1\x53\xc2\xf2\x43\xd1"
            "\xfe\x43\xec\x91" }  },
      /* --- pixel bitmap for cmr250 char#1 \Delta --- */
      {   1,56572,                      /* character number, location */
         25, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 25,   25, 3,114, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\xc1\xc0\xf1\xb3\xb0\xa5\xe0\x61\x13\xe0\x51\x24\xe0"
            "\x41\x33\xe0\x31\x44\xe0\x21\x53\xe0\x11\x64\xe1\x73"
            "\xd1\x84\xc1\x93\xb1\xa4\xa1\xb3\x91\xc4\x81\xd3\x71"
            "\xe4\x61\xe0\x13\x51\xe0\x24\x41\xe0\x33\x31\xe0\x44"
            "\x2e\x09\x1f\x1e\x0b" }  },
      /* --- pixel bitmap for cmr250 char#2 \Theta --- */
      {   2,57739,                      /* character number, location */
         25, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 23,   26, 3,113, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x87\xe3\x53\xb3\x73\x93\x93\x73\xb3\x30\xf1\x23\xd3"
            "\x20\x14\xd4\x23\xe0\x13\x14\xe0\x18\x31\x71\x34\x0f"
            "\x24\x39\x34\x04\x31\x71\x34\x0f\x14\xe0\x14\x13\xe0"
            "\x13\x24\xd4\x10\xf1\x23\xd3\x20\x33\xb3\x73\x93\x93"
            "\x73\xb3\x53\xe7\x8b" }  },
      /* --- pixel bitmap for cmr250 char#3 \Lambda --- */
      {   3,58741,                      /* character number, location */
         25, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 22,   25, 3,76, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf2\xa2\xa0\xf2\x94\x90\x81\x14\x80\xf1\x81\x23\x80"
            "\x72\x24\x70\xf2\x71\x43\x70\xf2\x61\x63\x60\xf2\x51"
            "\x83\x50\xf2\x41\xa3\x40\x32\xa4\x54\x94\x37\x5a" }  },
      /* --- pixel bitmap for cmr250 char#4 \Xi --- */
      {   4,60150,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 21,   24, 3,64, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x1e\x05\x10\xf2\x11\xe0\x31\x10\xf3\xe0\x70\xf1"
            "\x41\xb1\x40\xf1\x4d\x40\xf1\x41\xb1\x40\xf3\xe0\x7f"
            "\x21\xe0\x51\x0f\x1e\x07" }  },
      /* --- pixel bitmap for cmr250 char#5 \Pi --- */
      {   5,61323,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 26,   24, 3,22, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x0c\xfe\x43\xc3\x40\xf6\x43\xc3\x4b\x4b" }  },
      /* --- pixel bitmap for cmr250 char#6 \Sigma --- */
      {   6,62486,                      /* character number, location */
         24, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 21,   24, 3,97, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x06\x23\xc4\x24\xd2\x33\xe1\x43\xd2\x34\xd1\x43"
            "\xd1\x53\xc1\x54\xe0\x43\xe0\x53\xe0\x44\xe0\x43\xe0"
            "\x51\xe0\x51\xe0\x51\xc1\x61\xd1\x51\xe1\x41\xe2\x41"
            "\xe1\x41\xe2\x31\xd4\x2e\x05\x1e\x06\x13" }  },
      /* --- pixel bitmap for cmr250 char#7 \Upsilon --- */
      {   7,63612,                      /* character number, location */
         25, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 23,   25, 3,55, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x34\x94\x47\x77\x28\x58\x12\x53\x33\x53\x72\x32\x72"
            "\x73\x13\x71\xf1\x92\x12\x90\xa1\x11\xa0\xfe\xa3\xa0"
            "\x6b\x60" }  },
      /* --- pixel bitmap for cmr250 char#8 \Phi --- */
      {   8,64682,                      /* character number, location */
         24, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 21,   24, 3,81, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5b\x50\xf3\x93\x90\x77\xb3\x23\x23\x64\x33\x34\x34"
            "\x43\x44\x23\x53\x53\x1f\x34\x53\x54\x13\x53\x53\x24"
            "\x43\x44\x34\x33\x34\x63\x23\x23\xb7\x70\xf3\x93\x90"
            "\x5b\x51" }  },
      /* --- pixel bitmap for cmr250 char#9 \Psi --- */
      {   9,65841,                      /* character number, location */
         24, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 23,   24, 3,67, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6b\x60\xf2\xa3\xa4\x63\x64\xf7\x23\x53\x53\x20\x32"
            "\x53\x52\x63\x43\x43\x72\x43\x42\x92\x33\x32\xb3\x13"
            "\x13\xe7\x80\xf3\xa3\xa0\x6b\x63" }  },
      /* --- pixel bitmap for cmr250 char#10 \Omega --- */
      {  10,67046,                      /* character number, location */
         25, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 21,   25, 3,87, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x77\xc3\x53\x83\x93\x30\xf1\x23\xb3\x20\x14\xb4\x1f"
            "\x54\xd4\x13\xd3\x24\xb4\x10\xf1\x23\xb3\x20\x32\xb2"
            "\x63\x93\x72\x92\x41\x41\x91\x42\x42\x72\x43\x32\x72"
            "\x32\xf2\x16\x76\x14" }  },
      /* --- pixel bitmap for cmr250 char#11 \ff --- */
      {  11,114273,                     /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 22,   24, 3,51, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x85\x35\x72\x51\x12\x23\x52\x54\x33\x42\x63\x51\x10"
            "\xf4\x42\x72\x7e\x05\x30\xfc\x42\x72\x70\x17\x37\x4f" }  },
      /* --- pixel bitmap for cmr250 char#12 \fi --- */
      {  12,115487,                     /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 18,   24, 3,42, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x85\xb2\x51\x92\x53\x72\x63\x72\x71\x40\xf3\x42\xce"
            "\x01\x30\xfc\x42\x72\x30\x17\x37" }  },
      /* --- pixel bitmap for cmr250 char#13 \fl --- */
      {  13,116683,                     /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 18,   24, 3,36, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x87\x92\x43\x82\x53\x30\xf5\x42\x72\x3e\x01\x30\xfc"
            "\x42\x72\x30\x18\x18" }  },
      /* --- pixel bitmap for cmr250 char#14 \ffi --- */
      {  14,118332,                     /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 28,   24, 3,60, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\x45\xb3\x51\x12\x51\x92\x64\x53\x72\x73\x63\x72"
            "\x82\x71\x40\xf3\x42\x82\xce\x0b\x30\xfc\x42\x82\x72"
            "\x30\x18\x28\x18" }  },
      /* --- pixel bitmap for cmr250 char#15 \ffl --- */
      {  15,120021,                     /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 28,   24, 3,56, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\x47\x93\x51\x12\x43\x82\x64\x53\x72\x73\x72\x30"
            "\xf4\x42\x82\x72\x3e\x0b\x30\xfc\x42\x82\x72\x30\x18"
            "\x28\x18" }  },
      /* --- pixel bitmap for cmr250 char#16 \imath --- */
      {  16,81399,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   15, 3,10, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\x30\xfc\x32\x38" }  },
      /* --- pixel bitmap for cmr250 char#17 \jmath --- */
      {  17,82107,                      /* character number, location */
         15,-2,   -7,-2,      /* topleft row,col, and botleft row,col */
          {  9,   22, 3,23, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\xfe\x72\xf1\x72\x11\x55\x32\x13\x31\x35\x30" }  },
      /* --- pixel bitmap for cmr250 char#18 \gravesym --- */
      {  18,105464,                     /* character number, location */
         24, 4,   18, 4,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc3\x61\x30\x18\x0c" }  },
      /* --- pixel bitmap for cmr250 char#19 \acutesym --- */
      {  19,106039,                     /* character number, location */
         24, 7,   18, 7,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x8e\x31\xc6\x00" }  },
      /* --- pixel bitmap for cmr250 char#20 \checksym --- */
      {  20,106670,                     /* character number, location */
         22, 4,   18, 4,      /* topleft row,col, and botleft row,col */
          {  9,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x83\x8d\xe1\x80\x00" }  },
      /* --- pixel bitmap for cmr250 char#21 \brevesym --- */
      {  21,107292,                     /* character number, location */
         24, 3,   19, 3,      /* topleft row,col, and botleft row,col */
          { 11,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\x0c\xa0\x80\x08\x82\x0f" }  },
      /* --- pixel bitmap for cmr250 char#22 (noname) --- */
      {  22,107880,                     /* character number, location */
         21, 2,   20, 2,      /* topleft row,col, and botleft row,col */
          { 13,    1, 3, 2, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0d" }  },
      /* --- pixel bitmap for cmr250 char#23 (noname) --- */
      {  23,108657,                     /* character number, location */
         25,10,   19,10,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x18\x86\xa1\x07" }  },
      /* --- pixel bitmap for cmr250 char#24 (noname) --- */
      {  24,109357,                     /* character number, location */
         -1, 5,   -7, 5,      /* topleft row,col, and botleft row,col */
          {  7,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x0e\x18\x0c\xfe\x01" }  },
      /* --- pixel bitmap for cmr250 char#25 \ss --- */
      {  25,83210,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   24, 3,81, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x65\x92\x32\x72\x52\x20\xf3\x32\x72\x10\x32\x62\x52"
            "\x52\x35\x23\x82\x51\x72\x62\x52\x71\x52\x72\x42\x81"
            "\x10\xf4\x32\x82\x32\x81\x42\x22\x32\x42\x22\x22\x25"
            "\x34\x32" }  },
      /* --- pixel bitmap for cmr250 char#26 \ae --- */
      {  26,84591,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 22,   15, 3,77, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x27\x55\x43\x42\x32\x41\x33\x52\x11\x71\x31\x73\x81"
            "\xf1\xa2\x91\x6e\x02\x33\x42\xb3\x62\xb2\x72\xa2\x82"
            "\xa2\x83\x83\x81\x12\x71\x12\x52\x32\x42\x45\x74\x35" }  },
      /* --- pixel bitmap for cmr250 char#27 \oe --- */
      {  27,85743,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 25,   15, 3,77, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x54\x85\x62\x42\x42\x51\x41\x81\x22\x71\x22\x84\x81"
            "\x21\xa2\xa3\xa2\xa3\xad\x0f\x22\xa2\xb0\x12\x84\xb2"
            "\x84\x91\x22\x62\x22\x81\x32\x42\x42\x52\x64\x85\x35" }  },
      /* --- pixel bitmap for cmr250 char#28 (noname) --- */
      {  28,86593,                      /* character number, location */
         18, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          { 15,   21, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x20\x00\x18\x00\x04\x7c\x81\xc1\x60\xe0\x18\xd8"
            "\x04\x44\x03\xe1\x81\xf0\x20\x78\x08\x3c\x04\x16\x01"
            "\xd9\xc0\x38\x30\x18\x0c\xf4\x01\x01\xc0\x00\x20\x00"
            "\x00" }  },
      /* --- pixel bitmap for cmr250 char#29 \AE --- */
      {  29,88407,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 29,   24, 3,143, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x7e\x06\xd1\x13\x83\xc1\x23\x92\xc1\x23\xa1\xb2\x23"
            "\xa2\x10\xf1\x91\x33\xb1\x10\x82\x33\xb1\x10\xf1\x81"
            "\x43\x61\x60\x72\x43\x61\xd1\x53\x52\xde\x02\xc1\x63"
            "\x52\xc1\x63\x61\xc1\x63\x61\x51\x51\x73\x61\x51\x51"
            "\x73\xc1\x51\x73\xb2\xf1\x41\x83\xb1\x10\x41\x83\xa2"
            "\x34\x73\x93\x18\x2e\x04\x10" }  },
      /* --- pixel bitmap for cmr250 char#30 \OE --- */
      {  30,90159,                      /* character number, location */
         25, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 32,   26, 3,143, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x87\xe0\x93\x5e\x02\x73\x74\x83\x63\x84\x92\x53\x94"
            "\xa1\x44\x94\xa2\x33\xa4\xb1\x24\xa4\xb1\x23\xb4\x71"
            "\x31\x1f\x14\xc3\x71\x54\xc3\x62\x54\xcb\x54\xc3\x62"
            "\x5f\x14\xc3\x71\x54\xc3\x71\x41\xf1\x14\xa4\xc1\x23"
            "\xa4\xb2\x24\x94\xb1\x43\x94\xb1\x53\x84\xa2\x63\x74"
            "\x93\x73\x5e\x03\x97\xe0\x30" }  },
      /* --- pixel bitmap for cmr250 char#31 (noname) --- */
      {  31,91201,                      /* character number, location */
         25, 2,   -2, 2,      /* topleft row,col, and botleft row,col */
          { 23,   27, 3,137, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x87\x51\x83\x53\x21\x82\x93\x82\xb2\x72\xc3\x30\xf1"
            "\x22\xc1\x22\x20\x13\xb1\x33\x22\xb1\x52\x13\xb1\x56"
            "\xa1\x63\x0f\x13\x91\x73\x03\x81\x83\x0f\x13\x71\x93"
            "\x03\x61\xa3\x12\x51\xb2\x23\x41\xa3\x32\x31\xb2\x42"
            "\x21\xc2\x52\x11\xb2\x72\xb2\x83\x92\x91\x13\x53\x91"
            "\x47\xa1\xe0\x63" }  },
      /* --- pixel bitmap for cmr250 char#32 (noname) --- */
      {  32,109859,                     /* character number, location */
         14, 1,   10, 1,      /* topleft row,col, and botleft row,col */
          {  8,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\xe0\x1c\x03" }  },
      /* --- pixel bitmap for cmr250 char#33 ! --- */
      {  33,91918,                      /* character number, location */
         25, 3,    0, 3,      /* topleft row,col, and botleft row,col */
          {  4,   25, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf6\xff\xff\x6f\x66\x66\x66\x66\x06\x00\x60\xff\x06" }  },
      /* --- pixel bitmap for cmr250 char#34 " --- */
      {  34,121026,                     /* character number, location */
         24, 1,   13, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x7b\xfc\xe3\x1d\x8e\x40\x04\x22\x90\x40\x04\x12"
            "\x88\x40\x00" }  },
      /* --- pixel bitmap for cmr250 char#35 # --- */
      {  35,93412,                      /* character number, location */
         24, 2,   -7, 2,      /* topleft row,col, and botleft row,col */
          { 25,   31, 3,93, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf2\xb2\x62\x40\xa3\x53\x40\xf3\xa2\x62\x50\x93\x53"
            "\xe2\x62\x6f\x1e\x0b\xf1\x82\x62\x70\x73\x53\x70\xf2"
            "\x72\x62\x8f\x1e\x0b\x62\x62\xe3\x53\x90\xf4\x52\x62"
            "\xa0\x43\x53\xa0\xf2\x42\x62\xb1" }  },
      /* --- pixel bitmap for cmr250 char#36 $ --- */
      {  36,77523,                      /* character number, location */
         26, 2,   -2, 2,      /* topleft row,col, and botleft row,col */
          { 13,   28, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x00\x08\xc0\x07\x24\x43\x84\x84\xd0\x10\x1c\xe2"
            "\x43\x7c\x08\x1d\x01\x2f\xc0\x0f\xf0\x07\xfc\x01\x7a"
            "\x40\x0c\x88\x0b\xe1\x23\x3c\x84\x83\xb0\x10\x13\x22"
            "\x4c\x02\x3e\x00\x01\x20\x00" }  },
      /* --- pixel bitmap for cmr250 char#37 % --- */
      {  37,94693,                      /* character number, location */
         26, 2,   -2, 2,      /* topleft row,col, and botleft row,col */
          { 25,   28, 3,167, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x34\xd2\x52\x31\xb3\x42\x52\x83\x51\x61\x13\x26\x42"
            "\x71\x32\x23\x52\x71\x72\x62\x71\x63\x62\x71\x53\x72"
            "\x71\x52\x82\x71\x43\x91\x61\x43\xa2\x51\x42\xc2\x31"
            "\x43\xd4\x43\xe0\x82\x54\xd3\x42\x31\xc2\x42\x51\xa3"
            "\x41\x61\x93\x42\x71\x82\x52\x71\x73\x52\x71\x63\x62"
            "\x71\x62\x72\x71\x53\x72\x71\x43\x91\x61\x52\xa2\x51"
            "\x43\xb2\x31\x52\xd4\x30" }  },
      /* --- pixel bitmap for cmr250 char#38 & --- */
      {  38,78845,                      /* character number, location */
         25, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 24,   26, 3,133, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x83\xe0\x61\x31\xe0\x41\x51\xb0\xf2\x52\x51\xb0\xf1"
            "\x52\x41\xc0\x52\x31\xe0\x42\x21\xe0\x63\x78\x62\xa4"
            "\x82\xb1\xa3\xa1\x91\x12\x91\x91\x32\x71\x91\x43\x61"
            "\x81\x62\x51\x81\x82\x41\x72\x82\x31\x82\x92\x11\x92"
            "\xa2\x93\xa3\x81\x12\x81\x22\x61\x32\x52\x42\x42\x55"
            "\x84\x30" }  },
      /* --- pixel bitmap for cmr250 char#39 ' --- */
      {  39,95417,                      /* character number, location */
         24, 3,   13, 3,      /* topleft row,col, and botleft row,col */
          {  5,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe6\x7d\x0b\x21\x44\x88\x08" }  },
      /* --- pixel bitmap for cmr250 char#40 ( --- */
      {  40,96003,                      /* character number, location */
         26, 3,   -8, 3,      /* topleft row,col, and botleft row,col */
          {  8,   34, 3,62, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x71\x61\x61\x61\x62\x61\x62\x61\x50\xf1\x12\x50\xf1"
            "\x11\x6f\x92\x60\xf1\x11\x60\xf1\x12\x50\x21\x72\x71"
            "\x72\x71\x81\x81\x81" }  },
      /* --- pixel bitmap for cmr250 char#41 ) --- */
      {  41,96634,                      /* character number, location */
         26, 2,   -8, 2,      /* topleft row,col, and botleft row,col */
          {  8,   34, 3,63, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\x81\x81\x81\x72\x71\x72\x71\x20\xf1\x52\x10\xf1"
            "\x61\x10\xf9\x62\xf1\x61\x10\xf1\x52\x10\x51\x62\x61"
            "\x62\x61\x61\x61\x61\x71" }  },
      /* --- pixel bitmap for cmr250 char#42 * --- */
      {  42,97289,                      /* character number, location */
         26, 2,   11, 2,      /* topleft row,col, and botleft row,col */
          { 13,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x00\x08\x00\x01\x21\x74\xc4\xbd\x1e\xfe\x00\x07"
            "\xf8\xc3\xeb\x1d\x71\x21\x04\x04\x80\x00\x10\x00" }  },
      /* --- pixel bitmap for cmr250 char#43 + --- */
      {  43,97999,                      /* character number, location */
         20, 2,   -2, 2,      /* topleft row,col, and botleft row,col */
          { 23,   22, 3,15, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf9\xb2\xaf\x1e\x09\xf9\xb2\xa1" }  },
      /* --- pixel bitmap for cmr250 char#44 (noname) --- */
      {  44,98598,                      /* character number, location */
          4, 3,   -7, 3,      /* topleft row,col, and botleft row,col */
          {  4,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf6\xef\x88\x48\x24\x02" }  },
      /* --- pixel bitmap for cmr250 char#45 (noname) --- */
      {  45,121549,                     /* character number, location */
          8, 0,    6, 0,      /* topleft row,col, and botleft row,col */
          { 10,    2, 3, 4, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x0a" }  },
      /* --- pixel bitmap for cmr250 char#46 (noname) --- */
      {  46,99073,                      /* character number, location */
          4, 3,    0, 3,      /* topleft row,col, and botleft row,col */
          {  4,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf6\x6f" }  },
      /* --- pixel bitmap for cmr250 char#47 / --- */
      {  47,99583,                      /* character number, location */
         26, 2,   -9, 2,      /* topleft row,col, and botleft row,col */
          { 13,   35, 3,107, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\xf1\xb2\xa3\xf1\xa2\x10\x93\x10\xf1\x92\x20\x83\x20"
            "\xf1\x82\x30\x73\x30\xf1\x72\x40\x63\x40\xf1\x62\x50"
            "\x53\x50\xf1\x52\x60\x43\x60\xf1\x42\x70\x33\x70\xf1"
            "\x32\x80\x23\x80\xf1\x22\x90\x13\x90\xf1\x12\xa3\xaf"
            "\x12\xb1" }  },
      /* --- pixel bitmap for cmr250 char#48 0 --- */
      {  48,67814,                      /* character number, location */
         23, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 13,   24, 3,55, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\x72\x32\x52\x52\x20\xf1\x12\x72\x10\x11\x91\x1f"
            "\xb2\x92\x11\x91\x10\xf1\x12\x72\x10\x22\x52\x52\x32"
            "\x75\x43" }  },
      /* --- pixel bitmap for cmr250 char#49 1 --- */
      {  49,68628,                      /* character number, location */
         23, 3,    0, 3,      /* topleft row,col, and botleft row,col */
          { 10,   23, 3,22, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x51\x73\x43\x12\x40\xfe\x42\x40\xf3\x42\x4a" }  },
      /* --- pixel bitmap for cmr250 char#50 2 --- */
      {  50,69617,                      /* character number, location */
         23, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 13,   23, 3,65, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\x62\x42\x41\x72\x31\x82\x13\x73\x0f\x14\x63\x12"
            "\x73\xf1\xa3\x93\xa2\xa3\xa2\xa2\xa2\xa2\xa2\xa2\x71"
            "\x31\x81\x21\x81\x2b\x1c\x11" }  },
      /* --- pixel bitmap for cmr250 char#51 3 --- */
      {  51,70673,                      /* character number, location */
         23, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 15,   24, 3,67, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x55\x82\x43\x51\x73\x20\xf2\x13\x73\x10\x21\x83\xc2"
            "\xc3\xc2\xc2\x95\xe3\xd3\xd3\xc4\x12\x84\x0f\x24\x74"
            "\x11\x93\x21\x83\x42\x53\x76\x52" }  },
      /* --- pixel bitmap for cmr250 char#52 4 --- */
      {  52,71625,                      /* character number, location */
         23, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   23, 3,75, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x92\x40\xf1\x83\x40\x71\x12\x40\xf1\x61\x22\x40"
            "\x51\x32\x40\xf1\x41\x42\x40\x31\x52\x40\xf1\x21\x62"
            "\x40\x11\x72\x42\x72\x4e\x01\xf5\x92\x40\x68\x12" }  },
      /* --- pixel bitmap for cmr250 char#53 5 --- */
      {  53,72683,                      /* character number, location */
         23, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 13,   24, 3,69, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x12\x72\x2a\x39\x48\x40\xf3\x11\xb0\x11\x25\x51\x11"
            "\x42\x42\x62\x31\x73\xb2\x10\xf2\xa3\x0f\x23\x73\x01"
            "\x92\x21\x73\x21\x72\x42\x42\x74\x52" }  },
      /* --- pixel bitmap for cmr250 char#54 6 --- */
      {  54,73603,                      /* character number, location */
         23, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 15,   24, 3,77, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x75\x82\x51\x62\x62\x42\x63\x32\x73\x32\xc3\xc2\xc3"
            "\x34\x53\x12\x42\x34\x72\x24\x73\x14\x82\x1f\x33\x93"
            "\xf1\x12\x93\x13\x82\x32\x73\x42\x62\x62\x42\x85\x52" }  },
      /* --- pixel bitmap for cmr250 char#55 7 --- */
      {  55,74539,                      /* character number, location */
         23, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 15,   24, 3,63, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x11\xee\x1d\x21\xb1\x11\xb1\x21\xa1\x30\xf1\xa1\x40"
            "\x91\x50\xf1\x81\x60\xf1\x71\x70\xf1\x62\x70\xf2\x52"
            "\x80\xf4\x43\x80\x51\x92" }  },
      /* --- pixel bitmap for cmr250 char#56 8 --- */
      {  56,75473,                      /* character number, location */
         23, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 15,   24, 3,83, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x55\x82\x52\x52\x72\x41\x92\x10\xf1\x12\x92\x10\x13"
            "\x82\x24\x62\x44\x52\x55\x21\x86\xa6\x81\x25\x52\x54"
            "\x32\x74\x22\x95\xa3\x0f\x22\xb2\x12\xa1\x31\x91\x52"
            "\x52\x85\x56" }  },
      /* --- pixel bitmap for cmr250 char#57 9 --- */
      {  57,76407,                      /* character number, location */
         23, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 15,   24, 3,81, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x55\x82\x51\x62\x71\x43\x72\x32\x83\x1f\x13\x92\x1f"
            "\x33\x93\x12\x84\x13\x74\x22\x74\x32\x42\x13\x54\x33"
            "\xc2\x10\xf1\xb3\x10\x13\x72\x33\x62\x42\x71\x61\x52"
            "\x86\x65" }  },
      /* --- pixel bitmap for cmr250 char#58 : --- */
      {  58,100199,                     /* character number, location */
         15, 3,    0, 3,      /* topleft row,col, and botleft row,col */
          {  4,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf6\x6f\x00\x00\x00\x60\xff\x06" }  },
      /* --- pixel bitmap for cmr250 char#59 ; --- */
      {  59,100870,                     /* character number, location */
         15, 3,   -7, 3,      /* topleft row,col, and botleft row,col */
          {  4,   22, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf6\x6f\x00\x00\x00\x60\xff\x8e\x88\x44\x22" }  },
      /* --- pixel bitmap for cmr250 char#60 (noname) --- */
      {  60,92548,                      /* character number, location */
         17, 3,   -8, 3,      /* topleft row,col, and botleft row,col */
          {  4,   25, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf6\x6f\x00\x00\x66\x66\x66\x66\x66\xff\xff\xff\x06" }  },
      /* --- pixel bitmap for cmr250 char#61 = --- */
      {  61,101560,                     /* character number, location */
         14, 2,    4, 2,      /* topleft row,col, and botleft row,col */
          { 23,   10, 3,16, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x0e\x09\xf5\xe0\x9f\x1e\x09" }  },
      /* --- pixel bitmap for cmr250 char#62 (noname) --- */
      {  62,80772,                      /* character number, location */
         17, 2,   -7, 2,      /* topleft row,col, and botleft row,col */
          { 12,   24, 3,59, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x52\x50\xf1\x44\x40\x52\x50\xf3\xc0\xf1\x61\x50\xf3"
            "\x51\x60\x41\xa2\x92\x92\x92\x81\x1f\x12\x73\x11\x81"
            "\x22\x61\x56\x31" }  },
      /* --- pixel bitmap for cmr250 char#63 ? --- */
      {  63,79840,                      /* character number, location */
         24, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 12,   24, 3,53, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x36\x51\x62\x21\x81\x1f\x13\x72\x11\x82\x92\x92\x92"
            "\xa1\x40\xf5\x61\x50\xf3\xc0\x52\x50\xf1\x44\x40\x52"
            "\x52" }  },
      /* --- pixel bitmap for cmr250 char#64 @ --- */
      {  64,102734,                     /* character number, location */
         24, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 23,   24, 3,111, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x87\xe2\x72\xb1\xb1\x91\xd1\x71\xe0\x11\x51\x65\x61"
            "\x31\x62\x41\x61\x21\x51\x71\x51\x21\x42\x82\x31\x1f"
            "\x51\x42\x92\x41\x11\x42\x82\x41\x11\x51\x73\x31\x21"
            "\x62\x41\x12\x31\x31\x65\x34\x51\xe0\x91\xe0\x91\xe3"
            "\x62\x94\xa9\x62" }  },
      /* --- pixel bitmap for cmr250 char#65 A --- */
      {  65, 1026,                      /* character number, location */
         25, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 24,   25, 3,78, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf2\xb2\xb0\xf2\xa4\xa0\xf2\x91\x23\x90\xf2\x81\x43"
            "\x80\xf2\x71\x63\x70\x61\x83\xcc\xc1\x83\x60\xf1\x51"
            "\xa3\x50\x42\xa4\x40\xf1\x41\xc3\x40\x33\xb4\x38\x6a" }  },
      /* --- pixel bitmap for cmr250 char#66 B --- */
      {  66, 2360,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 22,   24, 3,77, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x02\xa3\x83\x83\x94\x63\xa3\x20\xf3\x43\xa4\x10"
            "\x43\xa3\x63\x94\x63\x84\x7d\x93\x93\x73\xa3\x63\xa4"
            "\x10\xf4\x43\xb4\x43\xa4\x53\xa3\x63\x84\x3e\x03\x5a" }  },
      /* --- pixel bitmap for cmr250 char#67 C --- */
      {  67, 3321,                      /* character number, location */
         25, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 21,   26, 3,97, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x96\x51\x73\x52\x22\x53\x94\x43\xb3\x33\xc3\xf1\x23"
            "\xe2\x14\xe0\x11\x13\xe0\x25\xe0\x21\x0f\x54\xe0\x34"
            "\xe0\x21\x13\xe0\x21\x14\xe0\x11\x23\xe0\x11\x23\xe1"
            "\x43\xd1\x53\xb1\x73\x91\xa3\x52\xd6\x60" }  },
      /* --- pixel bitmap for cmr250 char#68 D --- */
      {  68, 4443,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 24,   24, 3,75, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x02\xc3\x84\x93\xa3\x83\xb3\x30\xf1\x43\xc3\x20"
            "\x43\xc4\x53\xd3\x10\xf7\x43\xd4\xf1\x43\xd3\x10\xf1"
            "\x43\xc3\x20\x43\xb3\x73\xa3\x83\x84\x5e\x03\x73" }  },
      /* --- pixel bitmap for cmr250 char#69 E --- */
      {  69, 5872,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 23,   24, 3,105, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x0e\x07\x63\xb3\x63\xc2\x63\xd1\x63\xd2\x10\xf1\x43"
            "\xe1\x10\x43\x81\x51\x10\xf1\x43\x81\x70\x43\x72\xbc"
            "\xb3\x72\x70\xf1\x43\x81\x70\x43\x81\x61\xf1\x43\xe0"
            "\x11\x43\xe2\xf1\x43\xe1\x10\x43\xd2\x53\xb4\x1e\x08"
            "\x10" }  },
      /* --- pixel bitmap for cmr250 char#70 F --- */
      {  70, 7161,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 22,   24, 3,69, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x07\x53\xb3\x53\xc2\x53\xd1\x53\xd2\xf1\x43\xe1"
            "\x43\x81\x51\xf1\x43\x81\x60\x43\x72\xac\xa3\x72\x60"
            "\xf2\x43\x81\x60\xf6\x43\xe0\x1c\xa1" }  },
      /* --- pixel bitmap for cmr250 char#71 G --- */
      {  71, 8356,                      /* character number, location */
         25, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 23,   26, 3,109, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x96\x51\x93\x52\x22\x73\x94\x63\xb3\x53\xc3\x20\xf1"
            "\x23\xe2\x20\x14\xe0\x11\x33\xe0\x21\x24\xe0\x21\x2f"
            "\x34\xe0\x54\xa9\x0f\x14\xe3\x20\x13\xe3\x34\xd3\x20"
            "\xf1\x23\xd3\x20\x33\xc3\x63\xb3\x73\x91\x12\x93\x52"
            "\x31\xb6\x80" }  },
      /* --- pixel bitmap for cmr250 char#72 H --- */
      {  72, 9567,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 26,   24, 3,28, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0b\x4b\xf9\x43\xc3\x40\x4e\x04\x40\xfa\x43\xc3\x4b"
            "\x4b" }  },
      /* --- pixel bitmap for cmr250 char#73 I --- */
      {  73,10274,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   24, 3,14, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0b\xfe\x43\x40\xf6\x43\x4b" }  },
      /* --- pixel bitmap for cmr250 char#74 J --- */
      {  74,11090,                      /* character number, location */
         24, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 16,   25, 3,39, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5b\xfe\xa3\x30\xf1\xa3\x30\x12\x73\x3f\x14\x63\x33"
            "\x72\x51\x72\x71\x52\x96\x73" }  },
      /* --- pixel bitmap for cmr250 char#75 K --- */
      {  75,12289,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 25,   24, 3,108, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x0b\x77\x43\xc4\x63\xc2\x83\xc1\x93\xb1\xa3\x92\xb3"
            "\x81\xd3\x71\xe3\x61\xe0\x13\x51\xe0\x23\x43\xe0\x13"
            "\x31\x13\xe3\x21\x23\xe3\x11\x43\xd4\x63\xc3\x73\xc3"
            "\x83\xb3\x93\xa3\x94\x93\xa3\x93\xb3\x83\xb4\x73\xb5"
            "\x2b\x59" }  },
      /* --- pixel bitmap for cmr250 char#76 L --- */
      {  76,13276,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 21,   24, 3,39, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x90\xfd\x43\xe0\xf2\x43\xd1\xf1\x43\xc2\xf1\x43"
            "\xb2\x10\x43\x94\x1e\x06\x13" }  },
      /* --- pixel bitmap for cmr250 char#77 M --- */
      {  77,14574,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 32,   24, 3,120, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x08\xe0\x28\x44\xe0\x24\x40\xf2\x41\x13\xe1\x13\x40"
            "\xf1\x41\x23\xc1\x23\x40\xf2\x41\x33\xa1\x33\x40\xf1"
            "\x41\x43\x81\x43\x40\xf1\x41\x53\x61\x53\x40\xf2\x41"
            "\x63\x41\x63\x40\xf1\x41\x73\x21\x73\x40\xf2\x41\x84"
            "\x83\x40\x33\x82\x93\x49\x52\x5b" }  },
      /* --- pixel bitmap for cmr250 char#78 N --- */
      {  78,15778,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 26,   24, 3,131, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x07\xa9\x44\xc3\x75\xc1\x81\x13\xc1\x81\x23\xb1\x81"
            "\x33\xa1\x81\x34\x91\x81\x43\x91\x81\x53\x81\x81\x63"
            "\x71\x81\x64\x61\x81\x73\x61\x81\x83\x51\x40\xf1\x41"
            "\x93\x41\x40\x41\xa3\x31\x81\xb3\x21\x40\xf1\x41\xc3"
            "\x11\x40\x41\xd4\x81\xe3\x81\xe0\x12\x73\xe2\x49\xc1"
            "\x40" }  },
      /* --- pixel bitmap for cmr250 char#79 O --- */
      {  79,16693,                      /* character number, location */
         25, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 23,   26, 3,85, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x87\xe3\x53\xb3\x73\x93\x93\x73\xb3\x30\xf1\x23\xd3"
            "\x20\x14\xd4\x23\xe0\x13\x1f\x74\xe0\x14\x13\xe0\x13"
            "\x24\xd4\x10\xf1\x23\xd3\x20\x33\xb3\x73\x93\x93\x73"
            "\xb3\x53\xe7\x81" }  },
      /* --- pixel bitmap for cmr250 char#80 P --- */
      {  80,17844,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 22,   24, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x03\x93\x84\x73\xa3\x63\xb3\x10\xf4\x43\xb4\x43"
            "\xb3\x53\xa3\x63\x84\x7d\x50\xf9\x43\xe0\x1b\xb0" }  },
      /* --- pixel bitmap for cmr250 char#81 Q --- */
      {  81,18889,                      /* character number, location */
         25, 2,   -7, 2,      /* topleft row,col, and botleft row,col */
          { 23,   32, 3,127, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x87\xe3\x53\xb3\x73\x93\x93\x73\xb3\x30\xf1\x23\xd3"
            "\x20\x14\xd4\x23\xe0\x13\x1f\x74\xe0\x14\x13\xe0\x13"
            "\x24\xd4\x33\xd3\x43\x53\x53\x53\x31\x31\x33\x73\x21"
            "\x41\x13\x93\x11\x44\xb4\x43\x51\x88\x61\xe0\x12\x51"
            "\xe0\x12\x42\xe0\x18\xe0\x17\xe0\x36\xe0\x43\x39" }  },
      /* --- pixel bitmap for cmr250 char#82 R --- */
      {  82,20242,                      /* character number, location */
         24, 0,   -1, 0,      /* topleft row,col, and botleft row,col */
          { 25,   25, 3,97, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x01\xe3\x74\xb3\x93\xa3\xa3\x50\xf3\x43\xa4\x40"
            "\x43\xa3\x93\x93\xa3\x74\xbb\xe3\x72\xd3\x82\xc3\x92"
            "\x70\xf2\x43\x93\x60\xf1\x43\x94\x50\x43\x94\x41\x43"
            "\x95\x31\x43\xa4\x3c\x73\x21\xe0\x64\x21" }  },
      /* --- pixel bitmap for cmr250 char#83 S --- */
      {  83,21331,                      /* character number, location */
         25, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 15,   26, 3,77, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\x41\x41\x52\x12\x31\x83\x21\xa2\x12\xa2\x1f\x22"
            "\xb1\x13\xd3\xc5\xb8\x89\x88\xb5\xc3\xd3\xd2\x0f\x21"
            "\xc2\x02\xb1\x12\xa2\x13\x91\x22\x12\x61\x31\x46\x43" }  },
      /* --- pixel bitmap for cmr250 char#84 T --- */
      {  84,22451,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 23,   24, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\x07\x23\x63\x63\x10\xf1\x11\x83\x81\x12\x83\x82"
            "\x0f\x21\x93\x91\xfe\xa3\xa0\x5d\x53" }  },
      /* --- pixel bitmap for cmr250 char#85 U --- */
      {  85,23463,                      /* character number, location */
         24, 0,   -1, 0,      /* topleft row,col, and botleft row,col */
          { 26,   25, 3,53, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0b\x69\x43\xd3\x30\xfe\x43\xe1\x40\xf1\x43\xe1\x40"
            "\x52\xd1\xa3\xc1\xb2\xb1\xd2\x91\xe0\x13\x52\xe0\x46"
            "\xa2" }  },
      /* --- pixel bitmap for cmr250 char#86 V --- */
      {  86,24491,                      /* character number, location */
         24, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 24,   25, 3,77, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x09\x87\x33\xd3\x53\xd2\x30\xf2\x43\xc1\x40\xf2\x53"
            "\xa1\x50\xf1\x63\x81\x60\xf2\x73\x61\x70\xf2\x83\x41"
            "\x80\xf1\x93\x21\x90\x96\x90\xf1\xa4\xa0\xf2\xb2\xb3" }  },
      /* --- pixel bitmap for cmr250 char#87 W --- */
      {  87,25924,                      /* character number, location */
         24, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 34,   25, 3,123, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x09\x4a\x47\x24\xa4\x93\x20\xf2\x33\xa4\xa1\x30\xf2"
            "\x43\x81\x23\x81\x40\x53\x71\x23\x71\x50\xf1\x53\x61"
            "\x43\x61\x50\x63\x51\x43\x51\x60\xf2\x63\x41\x63\x41"
            "\x60\xf2\x73\x21\x83\x21\x70\x83\x11\x83\x11\x80\xf1"
            "\x84\xa4\x80\x93\xa3\x90\xf2\x92\xc2\x90" }  },
      /* --- pixel bitmap for cmr250 char#88 X --- */
      {  88,27107,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 24,   24, 3,108, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x0a\x49\x54\x84\x84\x91\xb3\x81\xd3\x71\xd4\x51\xe0"
            "\x13\x41\xe0\x33\x31\xe0\x34\x11\xe0\x54\xe0\x73\xb0"
            "\xf1\xa4\xa0\xa1\x13\xe0\x41\x24\xe0\x22\x33\xe0\x21"
            "\x53\xe1\x63\xd2\x73\xc1\x84\xa1\xa3\x92\xb3\x74\x95"
            "\x38\x6a" }  },
      /* --- pixel bitmap for cmr250 char#89 Y --- */
      {  89,28283,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 25,   24, 3,75, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x09\x88\x34\xc3\x64\xc2\x84\xb1\xa3\xa2\xa4\x91\xc3"
            "\x81\xe3\x71\xe4\x51\xe0\x23\x51\xe0\x33\x31\xe0\x44"
            "\x12\xe0\x53\x11\xe0\x64\xb0\xf8\xb3\xb0\x7b\x70" }  },
      /* --- pixel bitmap for cmr250 char#90 Z --- */
      {  90,29350,                      /* character number, location */
         24, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 17,   24, 3,83, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x07\x93\x13\xa3\x12\xa3\x21\xb3\x21\xa3\x3f\x11"
            "\x93\x40\x93\xd4\xd3\x60\xf1\x73\x70\x63\xd4\xd3\x81"
            "\xf1\x43\x91\x33\x92\xf1\x23\xa1\x10\x13\xa2\x23\x84"
            "\x1e\x02\x13" }  },
      /* --- pixel bitmap for cmr250 char#91 [ --- */
      {  91,103523,                     /* character number, location */
         26, 3,   -9, 3,      /* topleft row,col, and botleft row,col */
          {  7,   35, 3,18, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x07\x0f\xe2\x5f\xe2\x52\x5f\x17" }  },
      /* --- pixel bitmap for cmr250 char#92 (noname) --- */
      {  92,122418,                     /* character number, location */
         24, 5,   13, 5,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x22\x90\x40\x04\x12\x88\x40\x04\xe2\x70\x8f\x7f"
            "\xbc\xc1\x00" }  },
      /* --- pixel bitmap for cmr250 char#93 ] --- */
      {  93,104241,                     /* character number, location */
         26, 0,   -9, 0,      /* topleft row,col, and botleft row,col */
          {  7,   35, 3,18, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x07\xfe\x52\xfe\x52\x52\x0f\x17" }  },
      /* --- pixel bitmap for cmr250 char#94 \^ --- */
      {  94,110488,                     /* character number, location */
         24, 4,   19, 4,      /* topleft row,col, and botleft row,col */
          {  9,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x50\x10\x11\x14\x10" }  },
      /* --- pixel bitmap for cmr250 char#95 (noname) --- */
      {  95,110963,                     /* character number, location */
         24, 3,   20, 3,      /* topleft row,col, and botleft row,col */
          {  4,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf6\x6f" }  },
      /* --- pixel bitmap for cmr250 char#96 (noname) --- */
      {  96,104879,                     /* character number, location */
         24, 3,   13, 3,      /* topleft row,col, and botleft row,col */
          {  4,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x44\x22\x11\x71\xff\x06" }  },
      /* --- pixel bitmap for cmr250 char#97 a --- */
      {  97,30520,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 15,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x80\xc3\xc0\xc1\x40\xc0\x00\x60\x00\x30\xc0\x1f"
            "\x38\x0c\x06\x86\x01\xc3\x80\x71\xc0\x38\x70\x34\x7c"
            "\xe3\x71\x00" }  },
      /* --- pixel bitmap for cmr250 char#98 b --- */
      {  98,31546,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   24, 3,63, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\xb0\xf7\x32\xb0\x32\x25\x72\x11\x42\x63\x71\x52"
            "\x82\x42\x91\x10\xf4\x32\x92\x32\x91\x42\x82\x43\x62"
            "\x51\x21\x42\x61\x34\x51" }  },
      /* --- pixel bitmap for cmr250 char#99 c --- */
      {  99,32353,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 12,   15, 3,39, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x47\x42\x43\x21\x63\x12\x71\x21\xaf\x42\xa0\x11\xb2"
            "\x81\x21\x81\x32\x42\x55\x32" }  },
      /* --- pixel bitmap for cmr250 char#100 d --- */
      { 100,33362,                      /* character number, location */
         24, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 16,   24, 3,62, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x85\x30\xf7\xb2\x30\x54\x22\x62\x41\x12\x52\x63\x42"
            "\x82\x41\x92\x3f\x42\x92\x30\x11\x92\x42\x82\x51\x73"
            "\x62\x41\x12\x75\x25" }  },
      /* --- pixel bitmap for cmr250 char#101 e --- */
      { 101,34154,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   15, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x55\x62\x42\x42\x71\x22\x81\x21\x94\xae\x0f\x22\xb0"
            "\x11\xc2\x91\x22\x71\x42\x52\x65\x32" }  },
      /* --- pixel bitmap for cmr250 char#102 f --- */
      { 102,35019,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   24, 3,33, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x75\x72\x23\x52\x33\x42\x51\x10\xf4\x42\x7a\x30\xfc"
            "\x42\x70\x19\x32" }  },
      /* --- pixel bitmap for cmr250 char#103 g --- */
      { 103,36274,                      /* character number, location */
         16, 1,   -8, 1,      /* topleft row,col, and botleft row,col */
          { 16,   24, 3,75, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc3\x55\x21\x31\x32\x33\x32\x22\x52\x50\xf3\x12\x72"
            "\x40\x22\x52\x73\x32\x81\x15\x70\xf2\x12\xd0\x2a\x7a"
            "\x42\x83\x2f\x32\xb2\x10\x12\x92\x43\x53\x77\x53" }  },
      /* --- pixel bitmap for cmr250 char#104 h --- */
      { 104,37285,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   24, 3,36, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\xc0\xf7\x32\xc0\x32\x25\x82\x11\x42\x73\x62\x30"
            "\xfa\x32\x72\x38\x27" }  },
      /* --- pixel bitmap for cmr250 char#105 i --- */
      { 105,38030,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   24, 3,26, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x22\x40\xf1\x14\x30\x22\x40\xf4\x85\x30\xfc\x32\x38" }  },
      /* --- pixel bitmap for cmr250 char#106 j --- */
      { 106,38838,                      /* character number, location */
         24,-2,   -7,-2,      /* topleft row,col, and botleft row,col */
          {  9,   31, 3,39, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x62\x10\xf1\x54\x62\x10\xf4\x90\x45\xfe\x72\xf1\x72"
            "\x11\x55\x32\x13\x31\x35\x35" }  },
      /* --- pixel bitmap for cmr250 char#107 k --- */
      { 107,39952,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   24, 3,72, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\xc0\xf7\x32\xc0\x32\x47\x42\x54\x62\x52\x82\x51"
            "\x92\x41\xa2\x22\xb2\x13\xb3\x22\x70\xf1\x32\x42\x60"
            "\x32\x52\x82\x62\x72\x63\x62\x64\x28\x27" }  },
      /* --- pixel bitmap for cmr250 char#108 l --- */
      { 108,40601,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   24, 3,16, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\x30\xfe\x32\x30\xf6\x32\x38" }  },
      /* --- pixel bitmap for cmr250 char#109 m --- */
      { 109,41954,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 28,   15, 3,42, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\x35\x55\x82\x12\x42\x22\x42\x40\xf1\x33\x73\x72"
            "\x30\xf9\x32\x82\x82\x38\x28\x28" }  },
      /* --- pixel bitmap for cmr250 char#110 n --- */
      { 110,42973,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   15, 3,26, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\x25\x82\x11\x42\x73\x62\x30\xfa\x32\x72\x38\x27" }  },
      /* --- pixel bitmap for cmr250 char#111 o --- */
      { 111,43692,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x55\x82\x52\x52\x72\x32\x92\x21\xb1\x1f\x42\xb2\x11"
            "\xb1\x22\x92\x32\x72\x52\x52\x85\x50" }  },
      /* --- pixel bitmap for cmr250 char#112 p --- */
      { 112,44778,                      /* character number, location */
         15, 1,   -7, 1,      /* topleft row,col, and botleft row,col */
          { 16,   22, 3,61, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\x25\x72\x11\x42\x63\x62\x52\x82\x42\x91\x10\xf4"
            "\x32\x92\xf1\x32\x82\x10\x33\x62\x52\x11\x42\x62\x24"
            "\x50\xf5\x32\xb8\x82" }  },
      /* --- pixel bitmap for cmr250 char#113 q --- */
      { 113,45812,                      /* character number, location */
         15, 2,   -7, 2,      /* topleft row,col, and botleft row,col */
          { 16,   22, 3,62, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x54\x31\x62\x41\x21\x52\x63\x30\xf1\x12\x82\x3f\x42"
            "\x92\x30\x11\x92\x42\x73\x52\x63\x62\x41\x12\x75\x22"
            "\x30\xf5\xb2\x30\x88" }  },
      /* --- pixel bitmap for cmr250 char#114 r --- */
      { 114,46701,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   15, 3,27, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\x34\x42\x12\x23\x33\x43\x33\x51\x10\xf9\x32\x88"
            "\x52" }  },
      /* --- pixel bitmap for cmr250 char#115 s --- */
      { 115,47650,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   15, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x35\x21\x22\x53\x1f\x22\x81\x10\x13\x97\x77\xa3\x11"
            "\x84\x94\x84\x81\x14\x52\x11\x35\x32" }  },
      /* --- pixel bitmap for cmr250 char#116 t --- */
      { 116,48495,                      /* character number, location */
         21, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   21, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf2\x41\x50\xf1\x32\x50\x23\x5a\xf7\x32\x50\xf3\x32"
            "\x41\x42\x21\x63\x24" }  },
      /* --- pixel bitmap for cmr250 char#117 u --- */
      { 117,49436,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   15, 3,28, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\x45\x30\xfa\x32\x72\x30\x32\x63\x72\x41\x12\x85"
            "\x25" }  },
      /* --- pixel bitmap for cmr250 char#118 v --- */
      { 118,50324,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\xf8\x0c\x70\x1c\x30\x18\x10\x18\x10\x30\x08\x30"
            "\x08\x70\x0c\x60\x04\x60\x04\xc0\x02\xc0\x02\xc0\x03"
            "\x80\x01\x80\x01" }  },
      /* --- pixel bitmap for cmr250 char#119 w --- */
      { 119,51608,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 23,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\x7e\x7e\x06\x0c\x1c\x03\x06\x04\x83\x02\x81\x41"
            "\x83\xc0\xa0\x41\xc0\x88\x10\x60\xc4\x08\x30\x62\x04"
            "\xb0\x20\x01\x58\xb0\x00\x2c\x58\x00\x0c\x18\x00\x06"
            "\x0c\x00\x03\x06\x00" }  },
      /* --- pixel bitmap for cmr250 char#120 x --- */
      { 120,52623,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   15, 3,54, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x46\x23\x63\x52\x61\x82\x42\x92\x22\xa3\x11\xc3"
            "\xe2\xd4\xb2\x22\xa1\x32\x91\x52\x72\x62\x53\x63\x25"
            "\x56" }  },
      /* --- pixel bitmap for cmr250 char#121 y --- */
      { 121,53706,                      /* character number, location */
         15, 1,   -7, 1,      /* topleft row,col, and botleft row,col */
          { 16,   22, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\xf8\x0c\x70\x1c\x30\x18\x10\x18\x10\x30\x08\x30"
            "\x08\x70\x0c\x60\x04\x60\x04\xc0\x02\xc0\x02\xc0\x03"
            "\x80\x01\x80\x01\x80\x00\x80\x00\xc0\x00\x47\x00\x67"
            "\x00\x35\x00\x1e\x00" }  },
      /* --- pixel bitmap for cmr250 char#122 z --- */
      { 122,54697,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\xff\x80\x0d\xb8\x00\x13\x30\x02\x03\x30\x00\x07"
            "\x60\x10\x06\x62\x40\x06\xe4\x80\x0c\xdc\xff\x03" }  },
      /* --- pixel bitmap for cmr250 char#123 (noname) --- */
      { 123,123046,                     /* character number, location */
         10, 0,    9, 0,      /* topleft row,col, and botleft row,col */
          { 17,    1, 3, 4, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x03" }  },
      /* --- pixel bitmap for cmr250 char#124 (noname) --- */
      { 124,123866,                     /* character number, location */
         10, 0,    9, 0,      /* topleft row,col, and botleft row,col */
          { 35,    1, 2, 2, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x23" }  },
      /* --- pixel bitmap for cmr250 char#125 (noname) --- */
      { 125,111644,                     /* character number, location */
         24, 4,   18, 4,      /* topleft row,col, and botleft row,col */
          { 10,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x33\x6c\x98\x61\x82\x0c\x03" }  },
      /* --- pixel bitmap for cmr250 char#126 \~ --- */
      { 126,112336,                     /* character number, location */
         23, 3,   20, 3,      /* topleft row,col, and botleft row,col */
          { 11,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\xf4\x5f\x70\x00" }  },
      /* --- pixel bitmap for cmr250 char#127 (noname) --- */
      { 127,113017,                     /* character number, location */
         24, 3,   20, 3,      /* topleft row,col, and botleft row,col */
          { 11,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x7b\xfc\xe3\x0d\x06" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* ------------------------------------------------------------------------
font sizes 0-7 for cmmi10
------------------------------------------------------------------------ */

/* --- size=0 for .83gf ---
 * mf '\mode=eighthre;  input cmmi10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmmi83 --- */
static	chardef  cmmi83[] =
   {
      /* --- pixel bitmap for cmmi83 char#0 \Gamma --- */
      {   0, 1597,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xc8\x44\x04\x04\x04\x02\x07" }  },
      /* --- pixel bitmap for cmmi83 char#1 \Delta --- */
      {   1, 1624,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x60\xd0\x90\x88\x84\x86\xfe" }  },
      /* --- pixel bitmap for cmmi83 char#2 \Theta --- */
      {   2, 1657,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x28\xb6\x61\x14\x39" }  },
      /* --- pixel bitmap for cmmi83 char#3 \Lambda --- */
      {   3, 1694,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x18\x0c\x85\x22\x91\xee" }  },
      /* --- pixel bitmap for cmmi83 char#4 \Xi --- */
      {   4, 1727,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x09\x12\xe1\x43\x04\x40\x90\x3f" }  },
      /* --- pixel bitmap for cmmi83 char#5 \Pi --- */
      {   5, 1758,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x23\x44\x08\x21\x84\x10\x22\xc4\x39" }  },
      /* --- pixel bitmap for cmmi83 char#6 \Sigma --- */
      {   6, 1795,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x32\x0b\x81\x20\x49\x3e" }  },
      /* --- pixel bitmap for cmmi83 char#7 \Upsilon --- */
      {   7, 1826,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x57\x4b\x10\x04\x21\x1c" }  },
      /* --- pixel bitmap for cmmi83 char#8 \Phi --- */
      {   8, 1855,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\xf9\x5a\x9f\x38" }  },
      /* --- pixel bitmap for cmmi83 char#9 \Psi --- */
      {   9, 1886,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x94\xa6\xa9\x47\x38" }  },
      /* --- pixel bitmap for cmmi83 char#10 \Omega --- */
      {  10, 1921,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x70\x24\x91\x48\x24\x95\xef" }  },
      /* --- pixel bitmap for cmmi83 char#11 \alpha --- */
      {  11, 1960,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\xa7\x7c\x01" }  },
      /* --- pixel bitmap for cmmi83 char#12 \beta --- */
      {  12, 1985,                      /* character number, location */
          8, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x29\x39\x92\xb4\x1c\x41\x00" }  },
      /* --- pixel bitmap for cmmi83 char#13 \gamma --- */
      {  13, 2022,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb2\x32\x46\x08\x01" }  },
      /* --- pixel bitmap for cmmi83 char#14 \delta --- */
      {  14, 2049,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa4\x42\x56\x59\x03" }  },
      /* --- pixel bitmap for cmmi83 char#15 \epsilon --- */
      {  15, 2082,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  3,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xce\x73" }  },
      /* --- pixel bitmap for cmmi83 char#16 \zeta --- */
      {  16, 2099,                      /* character number, location */
          8, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  5,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x13\x21\x44\x10\xc4\x00" }  },
      /* --- pixel bitmap for cmmi83 char#17 \eta --- */
      {  17, 2126,                      /* character number, location */
          5, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6f\xca\x94\x10\x02" }  },
      /* --- pixel bitmap for cmmi83 char#18 \theta --- */
      {  18, 2155,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xac\xfa\x5f\x35" }  },
      /* --- pixel bitmap for cmmi83 char#19 \iota --- */
      {  19, 2186,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  2,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xea\x03" }  },
      /* --- pixel bitmap for cmmi83 char#20 \kappa --- */
      {  20, 2203,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xda\xb8\x1c\x01" }  },
      /* --- pixel bitmap for cmmi83 char#21 \lambda --- */
      {  21, 2226,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x82\x40\x18\x25\x85" }  },
      /* --- pixel bitmap for cmmi83 char#22 \mu --- */
      {  22, 2255,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x52\xca\x7c\x43\x00" }  },
      /* --- pixel bitmap for cmmi83 char#23 \nu --- */
      {  23, 2286,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x53\xaa\x32\x00" }  },
      /* --- pixel bitmap for cmmi83 char#24 \xi --- */
      {  24, 2311,                      /* character number, location */
          8, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  5,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x88\x0b\xc1\x44\x08\xc6\x00" }  },
      /* --- pixel bitmap for cmmi83 char#25 \pi --- */
      {  25, 2338,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x18\x53\x00" }  },
      /* --- pixel bitmap for cmmi83 char#26 \rho --- */
      {  26, 2357,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4c\xca\x75\x42\x00" }  },
      /* --- pixel bitmap for cmmi83 char#27 \sigma --- */
      {  27, 2384,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7e\x14\x25\x07" }  },
      /* --- pixel bitmap for cmmi83 char#28 \tau --- */
      {  28, 2407,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbe\x10\x21\x00" }  },
      /* --- pixel bitmap for cmmi83 char#29 \upsilon --- */
      {  29, 2426,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x73\xca\x64\x00" }  },
      /* --- pixel bitmap for cmmi83 char#30 \phi --- */
      {  30, 2451,                      /* character number, location */
          8, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x82\x78\x65\x59\x39\x82\x00" }  },
      /* --- pixel bitmap for cmmi83 char#31 \chi --- */
      {  31, 2490,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  7,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x42\x13\x05\xc1\x90\xc4\x00" }  },
      /* --- pixel bitmap for cmmi83 char#32 \psi --- */
      {  32, 2521,                      /* character number, location */
          8, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x82\xac\xab\x59\x39\x84\x00" }  },
      /* --- pixel bitmap for cmmi83 char#33 \omega --- */
      {  33, 2562,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x63\x9a\x76\x1b" }  },
      /* --- pixel bitmap for cmmi83 char#34 \varepsilon --- */
      {  34, 2593,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2c\x12\x06" }  },
      /* --- pixel bitmap for cmmi83 char#35 \vartheta --- */
      {  35, 2610,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\xd2\x3f\x55\x32" }  },
      /* --- pixel bitmap for cmmi83 char#36 \varpi --- */
      {  36, 2643,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x53\x52\x29\x36" }  },
      /* --- pixel bitmap for cmmi83 char#37 \varrho --- */
      {  37, 2674,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4c\xca\x75\xc2\x03" }  },
      /* --- pixel bitmap for cmmi83 char#38 \varsigma --- */
      {  38, 2701,                      /* character number, location */
          5, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          {  3,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4e\xa2\x01" }  },
      /* --- pixel bitmap for cmmi83 char#39 \varphi --- */
      {  39, 2720,                      /* character number, location */
          5, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5a\x59\x4e\x8e\x20\x00" }  },
      /* --- pixel bitmap for cmmi83 char#40 \leftharpoonup --- */
      {  40, 3136,                      /* character number, location */
          5, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          {  8,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x02\xff" }  },
      /* --- pixel bitmap for cmmi83 char#41 \leftharpoondown --- */
      {  41, 3149,                      /* character number, location */
          3, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x02\x04" }  },
      /* --- pixel bitmap for cmmi83 char#42 \rightharpoonup --- */
      {  42, 3162,                      /* character number, location */
          5, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          {  8,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x40\xff" }  },
      /* --- pixel bitmap for cmmi83 char#43 \rightharpoondown --- */
      {  43, 3175,                      /* character number, location */
          3, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x40\x20" }  },
      /* --- pixel bitmap for cmmi83 char#44 ` --- */
      {  44, 3188,                      /* character number, location */
          7, 0,    2, 0,      /* topleft row,col, and botleft row,col */
          {  2,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x56\x02" }  },
      /* --- pixel bitmap for cmmi83 char#45 ' --- */
      {  45, 3205,                      /* character number, location */
          7, 0,    2, 0,      /* topleft row,col, and botleft row,col */
          {  2,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa9\x01" }  },
      /* --- pixel bitmap for cmmi83 char#46 \triangleright --- */
      {  46, 3222,                      /* character number, location */
          4, 1,    1, 1,      /* topleft row,col, and botleft row,col */
          {  3,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf9\x00" }  },
      /* --- pixel bitmap for cmmi83 char#47 \triangleleft --- */
      {  47, 3235,                      /* character number, location */
          4, 1,    1, 1,      /* topleft row,col, and botleft row,col */
          {  3,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\x01" }  },
      /* --- pixel bitmap for cmmi83 char#48 \0 --- */
      {  48, 2902,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\xc6\xe8\x00" }  },
      /* --- pixel bitmap for cmmi83 char#49 \1 --- */
      {  49, 2925,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  3,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x93\x74" }  },
      /* --- pixel bitmap for cmmi83 char#50 \2 --- */
      {  50, 2942,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4e\x42\xfe\x01" }  },
      /* --- pixel bitmap for cmmi83 char#51 \3 --- */
      {  51, 2961,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x44\x21\x06\xa3\x03" }  },
      /* --- pixel bitmap for cmmi83 char#52 \4 --- */
      {  52, 2986,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\xa9\xf5\x11\x07" }  },
      /* --- pixel bitmap for cmmi83 char#53 \5 --- */
      {  53, 3011,                      /* character number, location */
          5, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x17\x71\x98\x06" }  },
      /* --- pixel bitmap for cmmi83 char#54 \6 --- */
      {  54, 3034,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4c\x84\x17\xa3\x03" }  },
      /* --- pixel bitmap for cmmi83 char#55 \7 --- */
      {  55, 3059,                      /* character number, location */
          5, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9f\x24\x22\x02" }  },
      /* --- pixel bitmap for cmmi83 char#56 \8 --- */
      {  56, 3082,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x44\x29\x17\xa3\x03" }  },
      /* --- pixel bitmap for cmmi83 char#57 \9 --- */
      {  57, 3111,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\x46\x0f\x91\x01" }  },
      /* --- pixel bitmap for cmmi83 char#58 . --- */
      {  58, 3248,                      /* character number, location */
          1, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  1,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01" }  },
      /* --- pixel bitmap for cmmi83 char#59 , --- */
      {  59, 3257,                      /* character number, location */
          1, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  1,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07" }  },
      /* --- pixel bitmap for cmmi83 char#60 < --- */
      {  60, 3270,                      /* character number, location */
          7, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\xc4\x08\x81\xc0\x40\x20" }  },
      /* --- pixel bitmap for cmmi83 char#61 / --- */
      {  61, 3295,                      /* character number, location */
          9, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  3,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x24\x25\x49\x4a\x02" }  },
      /* --- pixel bitmap for cmmi83 char#62 > --- */
      {  62, 3326,                      /* character number, location */
          7, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x81\xc0\x40\x20\xc4\x08\x01" }  },
      /* --- pixel bitmap for cmmi83 char#63 \star --- */
      {  63, 3351,                      /* character number, location */
          3,-1,    1,-1,      /* topleft row,col, and botleft row,col */
          {  6,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x06" }  },
      /* --- pixel bitmap for cmmi83 char#64 \partial --- */
      {  64, 2753,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x42\x1f\x53\x3a" }  },
      /* --- pixel bitmap for cmmi83 char#65 A --- */
      {  65,   35,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\x60\x50\x50\x48\x78\x44\xe7" }  },
      /* --- pixel bitmap for cmmi83 char#66 B --- */
      {  66,   68,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\xc8\x44\x7c\x64\x44\x22\x1f" }  },
      /* --- pixel bitmap for cmmi83 char#67 C --- */
      {  67,  101,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\x2c\x05\x41\x94\x18" }  },
      /* --- pixel bitmap for cmmi83 char#68 D --- */
      {  68,  132,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x88\x84\x84\x84\x04\x42\x3f" }  },
      /* --- pixel bitmap for cmmi83 char#69 E --- */
      {  69,  165,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xc8\x64\x3c\xa4\x84\x42\x7f" }  },
      /* --- pixel bitmap for cmmi83 char#70 F --- */
      {  70,  200,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xc8\x54\x1c\x14\x04\x02\x07" }  },
      /* --- pixel bitmap for cmmi83 char#71 G --- */
      {  71,  231,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x58\xb3\x28\x10\x0f\x45\x3c" }  },
      /* --- pixel bitmap for cmmi83 char#72 H --- */
      {  72,  266,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x23\x44\x08\x3f\x84\x10\x22\xc4\x39" }  },
      /* --- pixel bitmap for cmmi83 char#73 I --- */
      {  73,  303,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x11\x42\x88\x38" }  },
      /* --- pixel bitmap for cmmi83 char#74 J --- */
      {  74,  326,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x84\x20\x08\x52\x1c" }  },
      /* --- pixel bitmap for cmmi83 char#75 K --- */
      {  75,  351,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xdc\x23\x41\x02\x05\x2c\x90\x20\xc2\x39" }  },
      /* --- pixel bitmap for cmmi83 char#76 L --- */
      {  76,  390,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x04\x81\x40\x24\x8a\x7e" }  },
      /* --- pixel bitmap for cmmi83 char#77 M --- */
      {  77,  419,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x8e\x61\x14\x43\x29\x94\x42\x25\x32\x71\x3b" }  },
      /* --- pixel bitmap for cmmi83 char#78 N --- */
      {  78,  476,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x63\x44\x09\x25\xa4\x90\x22\xc6\x11" }  },
      /* --- pixel bitmap for cmmi83 char#79 O --- */
      {  79,  523,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x28\x86\x61\x14\x39" }  },
      /* --- pixel bitmap for cmmi83 char#80 P --- */
      {  80,  558,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x24\x91\xc8\x23\x08\x0e" }  },
      /* --- pixel bitmap for cmmi83 char#81 Q --- */
      {  81,  587,                      /* character number, location */
          8, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x28\x86\x61\x54\x39\x00\x02" }  },
      /* --- pixel bitmap for cmmi83 char#82 R --- */
      {  82,  628,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x88\x44\x3c\x44\x44\x22\x67" }  },
      /* --- pixel bitmap for cmmi83 char#83 S --- */
      {  83,  663,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x0a\x83\x60\x3a" }  },
      /* --- pixel bitmap for cmmi83 char#84 T --- */
      {  84,  690,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\xd2\x49\x08\x08\x08\x04\x1e" }  },
      /* --- pixel bitmap for cmmi83 char#85 U --- */
      {  85,  721,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe7\x42\x21\x21\x21\x21\x11\x0f" }  },
      /* --- pixel bitmap for cmmi83 char#86 V --- */
      {  86,  758,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe7\x22\x22\x12\x0a\x0a\x06\x06" }  },
      /* --- pixel bitmap for cmmi83 char#87 W --- */
      {  87,  793,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x77\x97\x89\x4c\x54\xa1\x0a\x33\x98\x41\x04" }  },
      /* --- pixel bitmap for cmmi83 char#88 X --- */
      {  88,  846,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xdc\xa1\xc0\x81\x01\x03\x05\x89\x73" }  },
      /* --- pixel bitmap for cmmi83 char#89 Y --- */
      {  89,  879,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe7\x26\x14\x14\x08\x08\x04\x0e" }  },
      /* --- pixel bitmap for cmmi83 char#90 Z --- */
      {  90,  910,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\xa5\x21\xa4\x29\x7d" }  },
      /* --- pixel bitmap for cmmi83 char#91 \flat --- */
      {  91, 3362,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  3,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x49\xd2\x76\x03" }  },
      /* --- pixel bitmap for cmmi83 char#92 \natural --- */
      {  92, 3393,                      /* character number, location */
          8, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  3,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x49\xdf\xb6\x27" }  },
      /* --- pixel bitmap for cmmi83 char#93 \sharp --- */
      {  93, 3430,                      /* character number, location */
          8, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  3,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6d\xdf\xb6\x2f" }  },
      /* --- pixel bitmap for cmmi83 char#94 \smile --- */
      {  94, 3473,                      /* character number, location */
          5, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          {  8,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x81\x42\x3c" }  },
      /* --- pixel bitmap for cmmi83 char#95 \frown --- */
      {  95, 3490,                      /* character number, location */
          5, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          {  8,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x42\x81" }  },
      /* --- pixel bitmap for cmmi83 char#96 \ell --- */
      {  96, 2784,                      /* character number, location */
          8,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x33\x46\x8c\xe1" }  },
      /* --- pixel bitmap for cmmi83 char#97 a --- */
      {  97,  943,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9e\xd9\x0b" }  },
      /* --- pixel bitmap for cmmi83 char#98 b --- */
      {  98,  968,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x23\x71\x99\x35" }  },
      /* --- pixel bitmap for cmmi83 char#99 c --- */
      {  99,  997,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9e\x11\x07" }  },
      /* --- pixel bitmap for cmmi83 char#100 d --- */
      { 100, 1016,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x22\x97\x52\x5b" }  },
      /* --- pixel bitmap for cmmi83 char#101 e --- */
      { 101, 1047,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x96\x17\x07" }  },
      /* --- pixel bitmap for cmmi83 char#102 f --- */
      { 102, 1066,                      /* character number, location */
          8, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  4,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4c\x64\x22\x22\x11" }  },
      /* --- pixel bitmap for cmmi83 char#103 g --- */
      { 103, 1093,                      /* character number, location */
          5, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9e\x59\x47\x03" }  },
      /* --- pixel bitmap for cmmi83 char#104 h --- */
      { 104, 1120,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\x08\x27\x65\xce" }  },
      /* --- pixel bitmap for cmmi83 char#105 i --- */
      { 105, 1151,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  2,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\x55\x01" }  },
      /* --- pixel bitmap for cmmi83 char#106 j --- */
      { 106, 1172,                      /* character number, location */
          9, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  4,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x00\x66\x24\x22\x01" }  },
      /* --- pixel bitmap for cmmi83 char#107 k --- */
      { 107, 1197,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\x08\x6d\x4d\x4b" }  },
      /* --- pixel bitmap for cmmi83 char#108 l --- */
      { 108, 1228,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  3,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa6\x24\x4d" }  },
      /* --- pixel bitmap for cmmi83 char#109 m --- */
      { 109, 1251,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6f\x93\x92\xc9\xc9" }  },
      /* --- pixel bitmap for cmmi83 char#110 n --- */
      { 110, 1286,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbf\xda\x0d" }  },
      /* --- pixel bitmap for cmmi83 char#111 o --- */
      { 111, 1311,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\xc6\x74\x00" }  },
      /* --- pixel bitmap for cmmi83 char#112 p --- */
      { 112, 1334,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9e\x49\x5a\x8e\x30\x00" }  },
      /* --- pixel bitmap for cmmi83 char#113 q --- */
      { 113, 1361,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9e\x59\x47\x06" }  },
      /* --- pixel bitmap for cmmi83 char#114 r --- */
      { 114, 1388,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbf\x12\x01" }  },
      /* --- pixel bitmap for cmmi83 char#115 s --- */
      { 115, 1407,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xac\x46\x06" }  },
      /* --- pixel bitmap for cmmi83 char#116 t --- */
      { 116, 1426,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  3,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xd4\xa5\x09" }  },
      /* --- pixel bitmap for cmmi83 char#117 u --- */
      { 117, 1447,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbb\xda\x0e" }  },
      /* --- pixel bitmap for cmmi83 char#118 v --- */
      { 118, 1472,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbb\x5a\x06" }  },
      /* --- pixel bitmap for cmmi83 char#119 w --- */
      { 119, 1497,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcb\xa5\xb2\xe4\x01" }  },
      /* --- pixel bitmap for cmmi83 char#120 x --- */
      { 120, 1530,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xce\x92\xf5\x00" }  },
      /* --- pixel bitmap for cmmi83 char#121 y --- */
      { 121, 1551,                      /* character number, location */
          5, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbb\x5a\x46\x03" }  },
      /* --- pixel bitmap for cmmi83 char#122 z --- */
      { 122, 1580,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6e\x64\x07" }  },
      /* --- pixel bitmap for cmmi83 char#123 \imath --- */
      { 123, 2807,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  1,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f" }  },
      /* --- pixel bitmap for cmmi83 char#124 \jmath --- */
      { 124, 2824,                      /* character number, location */
          5, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  3,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x36\x25\x05" }  },
      /* --- pixel bitmap for cmmi83 char#125 \wp --- */
      { 125, 2845,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  7,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\xa3\x50\xd4\x29\x08\x00" }  },
      /* --- pixel bitmap for cmmi83 char#126 \vec --- */
      { 126, 2876,                      /* character number, location */
          9, 2,    6, 2,      /* topleft row,col, and botleft row,col */
          {  5,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe8\x23" }  },
      /* --- pixel bitmap for cmmi83 char#127 (noname) --- */
      { 127, 2889,                      /* character number, location */
          8, 3,    6, 3,      /* topleft row,col, and botleft row,col */
          {  3,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2b" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=1 for .100gf ---
 * mf '\mode=preview; mag=magstep(-17.87427405946994351363); input cmmi10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmmi100 --- */
static	chardef  cmmi100[] =
   {
      /* --- pixel bitmap for cmmi100 char#0 \Gamma --- */
      {   0,52525,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x11\x23\x24\x44\x80\x00\x01\x01\x0f\x00" }  },
      /* --- pixel bitmap for cmmi100 char#1 \Delta --- */
      {   1,53390,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x00\x03\x1a\x44\x08\x11\x44\xa0\x80\xff\x03" }  },
      /* --- pixel bitmap for cmmi100 char#2 \Theta --- */
      {   2,54515,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x08\x0b\x1c\x98\x33\x60\x20\x21\x3c\x00" }  },
      /* --- pixel bitmap for cmmi100 char#3 \Lambda --- */
      {   3,55411,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\xc0\x40\x81\x82\x04\x09\x11\x21\xe7\x01" }  },
      /* --- pixel bitmap for cmmi100 char#4 \Xi --- */
      {   4,56816,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x09\x02\x20\xc2\x87\x08\x80\x20\x7f\x00" }  },
      /* --- pixel bitmap for cmmi100 char#5 \Pi --- */
      {   5,58037,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x47\x08\x42\x08\x41\x08\x42\x10\x42\x08\xe7\x01" }  },
      /* --- pixel bitmap for cmmi100 char#6 \Sigma --- */
      {   6,59192,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x33\x8c\x20\x44\x30\x60\xc4\x90\x21\xff\x00" }  },
      /* --- pixel bitmap for cmmi100 char#7 \Upsilon --- */
      {   7,60208,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xce\x12\x62\x40\x80\x00\x01\x02\x02\x1f\x00" }  },
      /* --- pixel bitmap for cmmi100 char#8 \Phi --- */
      {   8,61210,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x20\x7c\x92\x91\xd1\x3e\x08\x3e" }  },
      /* --- pixel bitmap for cmmi100 char#9 \Psi --- */
      {   9,62239,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x20\x44\x4e\x92\x64\x85\x07\x02\x1f\x00" }  },
      /* --- pixel bitmap for cmmi100 char#10 \Omega --- */
      {  10,63426,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x30\x44\xa0\x40\x02\x11\x42\x44\x31\xe7\x00" }  },
      /* --- pixel bitmap for cmmi100 char#11 \alpha --- */
      {  11,64434,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4e\x1c\x47\xd9\x09" }  },
      /* --- pixel bitmap for cmmi100 char#12 \beta --- */
      {  12,65455,                      /* character number, location */
         10, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  8,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x70\x90\x88\x48\x3c\x44\x44\x44\x26\x1e\x02\x02\x01" }  },
      /* --- pixel bitmap for cmmi100 char#13 \gamma --- */
      {  13,66316,                      /* character number, location */
          6, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xce\x68\x0c\x06\x83\x40\x20\x08" }  },
      /* --- pixel bitmap for cmmi100 char#14 \delta --- */
      {  14,67225,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x08\x42\x56\x4a\x65\x00" }  },
      /* --- pixel bitmap for cmmi100 char#15 \epsilon --- */
      {  15,68065,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\x17\x69" }  },
      /* --- pixel bitmap for cmmi100 char#16 \zeta --- */
      {  16,68937,                      /* character number, location */
         10, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  5,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x13\x21\x42\x08\x61\x30\xe4\x00" }  },
      /* --- pixel bitmap for cmmi100 char#17 \eta --- */
      {  17,69770,                      /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xdb\x29\x8a\x51\x04\x41\x08" }  },
      /* --- pixel bitmap for cmmi100 char#18 \theta --- */
      {  18,70480,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x88\x4a\xf9\x5e\x2a\x65\x00" }  },
      /* --- pixel bitmap for cmmi100 char#19 \iota --- */
      {  19,71073,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  3,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x92\x54\x01" }  },
      /* --- pixel bitmap for cmmi100 char#20 \kappa --- */
      {  20,71967,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb2\x62\x28\x69\x0c" }  },
      /* --- pixel bitmap for cmmi100 char#21 \lambda --- */
      {  21,72778,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x82\x20\x10\x84\x91\x62\x08" }  },
      /* --- pixel bitmap for cmmi100 char#22 \mu --- */
      {  22,73728,                      /* character number, location */
          6, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x44\x22\x91\x68\xf6\x0a\x04\x01" }  },
      /* --- pixel bitmap for cmmi100 char#23 \nu --- */
      {  23,74469,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa3\x28\x49\xcd\x00" }  },
      /* --- pixel bitmap for cmmi100 char#24 \xi --- */
      {  24,75547,                      /* character number, location */
         10, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  6,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x4e\x10\x04\x27\x08\x81\xc0\x40\x1c" }  },
      /* --- pixel bitmap for cmmi100 char#25 \pi --- */
      {  25,76403,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x15\x14\x14\x12\x22" }  },
      /* --- pixel bitmap for cmmi100 char#26 \rho --- */
      {  26,77185,                      /* character number, location */
          6, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x49\x92\x96\x23\x08\x01" }  },
      /* --- pixel bitmap for cmmi100 char#27 \sigma --- */
      {  27,78037,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x49\x24\x92\x30\x00" }  },
      /* --- pixel bitmap for cmmi100 char#28 \tau --- */
      {  28,78742,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x04\x02\x41\x20\x00" }  },
      /* --- pixel bitmap for cmmi100 char#29 \upsilon --- */
      {  29,79565,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc2\xa1\x50\x28\xe2\x00" }  },
      /* --- pixel bitmap for cmmi100 char#30 \phi --- */
      {  30,80385,                      /* character number, location */
         10, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  6,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x84\x20\x9c\x5a\x96\x95\x23\x08\x02" }  },
      /* --- pixel bitmap for cmmi100 char#31 \chi --- */
      {  31,81378,                      /* character number, location */
          6, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x84\x86\x48\x28\x10\x18\x24\x22\x41" }  },
      /* --- pixel bitmap for cmmi100 char#32 \psi --- */
      {  32,82387,                      /* character number, location */
         10, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  8,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x20\x20\x10\x92\x93\x92\x4a\x6a\x1c\x08\x04\x04" }  },
      /* --- pixel bitmap for cmmi100 char#33 \omega --- */
      {  33,83452,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x82\x81\x91\x91\x59\x36" }  },
      /* --- pixel bitmap for cmmi100 char#34 \varepsilon --- */
      {  34,84381,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\x30\x11\x1d" }  },
      /* --- pixel bitmap for cmmi100 char#35 \vartheta --- */
      {  35,85330,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x14\x12\x39\x1b\x8b\x24\x12\x07" }  },
      /* --- pixel bitmap for cmmi100 char#36 \varpi --- */
      {  36,86475,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x4f\x10\x89\x48\x44\x13\x66\x00" }  },
      /* --- pixel bitmap for cmmi100 char#37 \varrho --- */
      {  37,87318,                      /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  5,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4c\x4a\xb9\x4e\x08\x07" }  },
      /* --- pixel bitmap for cmmi100 char#38 \varsigma --- */
      {  38,88091,                      /* character number, location */
          6, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\x11\x86\x06" }  },
      /* --- pixel bitmap for cmmi100 char#39 \varphi --- */
      {  39,88970,                      /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x62\x91\x89\x49\x65\x1e\x04\x04\x02" }  },
      /* --- pixel bitmap for cmmi100 char#40 \leftharpoonup --- */
      {  40,103866,                     /* character number, location */
          7, 1,    3, 1,      /* topleft row,col, and botleft row,col */
          { 12,    4, 3,10, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x21\x90\x12\x9c" }  },
      /* --- pixel bitmap for cmmi100 char#41 \leftharpoondown --- */
      {  41,104862,                     /* character number, location */
          4, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x6f\x00\x04\x40\x00" }  },
      /* --- pixel bitmap for cmmi100 char#42 \rightharpoonup --- */
      {  42,105856,                     /* character number, location */
          7, 1,    3, 1,      /* topleft row,col, and botleft row,col */
          { 12,    4, 3,10, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x91\x20\x92\x1c" }  },
      /* --- pixel bitmap for cmmi100 char#43 \rightharpoondown --- */
      {  43,106853,                     /* character number, location */
          4, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x0f\x60\x00\x02\x20" }  },
      /* --- pixel bitmap for cmmi100 char#44 ` --- */
      {  44,107242,                     /* character number, location */
          8, 1,    3, 1,      /* topleft row,col, and botleft row,col */
          {  2,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x56\x02" }  },
      /* --- pixel bitmap for cmmi100 char#45 ' --- */
      {  45,107634,                     /* character number, location */
          8, 1,    3, 1,      /* topleft row,col, and botleft row,col */
          {  2,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa9\x01" }  },
      /* --- pixel bitmap for cmmi100 char#46 \triangleright --- */
      {  46,108143,                     /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x61\xb4\xd8\x46\x00" }  },
      /* --- pixel bitmap for cmmi100 char#47 \triangleleft --- */
      {  47,108661,                     /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x90\xcb\x28\x39\x04" }  },
      /* --- pixel bitmap for cmmi100 char#48 \0 --- */
      {  48,94905,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\xc6\x18\x1d" }  },
      /* --- pixel bitmap for cmmi100 char#49 \1 --- */
      {  49,95626,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa6\x10\x42\x3e" }  },
      /* --- pixel bitmap for cmmi100 char#50 \2 --- */
      {  50,96560,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\x42\x64\x3f" }  },
      /* --- pixel bitmap for cmmi100 char#51 \3 --- */
      {  51,97545,                      /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  5,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\x42\xe8\x60\x8c\x0e" }  },
      /* --- pixel bitmap for cmmi100 char#52 \4 --- */
      {  52,98426,                      /* character number, location */
          6, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x0c\x45\x32\xf9\x43\x20\x38" }  },
      /* --- pixel bitmap for cmmi100 char#53 \5 --- */
      {  53,99419,                      /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  5,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\x84\x17\x61\x8c\x0e" }  },
      /* --- pixel bitmap for cmmi100 char#54 \6 --- */
      {  54,100268,                     /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\x84\x17\x63\x94\x0e" }  },
      /* --- pixel bitmap for cmmi100 char#55 \7 --- */
      {  55,101121,                     /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7f\x08\x21\x08\x41\x10\x04" }  },
      /* --- pixel bitmap for cmmi100 char#56 \8 --- */
      {  56,102000,                     /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\x46\xe5\x62\x8c\x0e" }  },
      /* --- pixel bitmap for cmmi100 char#57 \9 --- */
      {  57,102855,                     /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  5,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\xc5\x18\x3d\x44\x07" }  },
      /* --- pixel bitmap for cmmi100 char#58 . --- */
      {  58,109108,                     /* character number, location */
          1, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  1,    1, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01" }  },
      /* --- pixel bitmap for cmmi100 char#59 , --- */
      {  59,109639,                     /* character number, location */
          1, 2,   -3, 2,      /* topleft row,col, and botleft row,col */
          {  1,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmmi100 char#60 < --- */
      {  60,110267,                     /* character number, location */
          8, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 3,18, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x72\x52\x52\x52\x61\x92\x92\x92\x92" }  },
      /* --- pixel bitmap for cmmi100 char#61 / --- */
      {  61,110761,                     /* character number, location */
         10, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  5,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x22\x84\x08\x21\x42\x88\x10\x00" }  },
      /* --- pixel bitmap for cmmi100 char#62 > --- */
      {  62,111410,                     /* character number, location */
          8, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\x92\x92\x92\x91\x62\x52\x52\x52\x71" }  },
      /* --- pixel bitmap for cmmi100 char#63 \star --- */
      {  63,112079,                     /* character number, location */
          4, 0,    2, 0,      /* topleft row,col, and botleft row,col */
          {  6,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x06" }  },
      /* --- pixel bitmap for cmmi100 char#64 \partial --- */
      {  64,89878,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x08\x82\xbc\x18\x46\x91\x03" }  },
      /* --- pixel bitmap for cmmi100 char#65 A --- */
      {  65, 1000,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\xc0\x40\x81\x82\x04\x0f\x11\x21\xe7\x01" }  },
      /* --- pixel bitmap for cmmi100 char#66 B --- */
      {  66, 2304,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x21\x8c\x20\x61\xfc\x10\x44\x90\x20\x7f\x00" }  },
      /* --- pixel bitmap for cmmi100 char#67 C --- */
      {  67, 3245,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x09\x0b\x0c\x10\x20\x40\x20\x21\x3c\x00" }  },
      /* --- pixel bitmap for cmmi100 char#68 D --- */
      {  68, 4329,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x83\x30\x04\x11\x88\x40\x04\x22\x88\x20\xfe\x00" }  },
      /* --- pixel bitmap for cmmi100 char#69 E --- */
      {  69, 5750,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x11\x23\x25\xc5\x83\x24\x29\x61\x7f\x00" }  },
      /* --- pixel bitmap for cmmi100 char#70 F --- */
      {  70, 6983,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x11\x23\x25\xc5\x83\x04\x09\x01\x0f\x00" }  },
      /* --- pixel bitmap for cmmi100 char#71 G --- */
      {  71, 8120,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x09\x0b\x0c\x10\x3e\x50\x20\x21\x7c\x00" }  },
      /* --- pixel bitmap for cmmi100 char#72 H --- */
      {  72, 9341,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x47\x08\x42\x08\xc1\x0f\x42\x10\x42\x08\xe7\x01" }  },
      /* --- pixel bitmap for cmmi100 char#73 I --- */
      {  73,10040,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x82\x10\x04\x41\x08\x0f" }  },
      /* --- pixel bitmap for cmmi100 char#74 J --- */
      {  74,10878,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x10\x08\x02\x81\x40\x12\x06" }  },
      /* --- pixel bitmap for cmmi100 char#75 K --- */
      {  75,12061,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\x47\x04\x12\x48\xc0\x03\x36\x10\x41\x08\xcf\x01" }  },
      /* --- pixel bitmap for cmmi100 char#76 L --- */
      {  76,12954,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x20\x40\x40\x80\x00\x21\x42\x42\xfe\x00" }  },
      /* --- pixel bitmap for cmmi100 char#77 M --- */
      {  77,14212,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x3c\x06\x83\xa1\x50\x18\x14\x05\x29\x41\x4a\x88"
            "\x09\x2f\x0f" }  },
      /* --- pixel bitmap for cmmi100 char#78 N --- */
      {  78,15350,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\xc7\x08\x46\x28\x41\x0a\x52\x90\x42\x08\x4f\x00" }  },
      /* --- pixel bitmap for cmmi100 char#79 O --- */
      {  79,16195,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x08\x0b\x0c\x18\x30\x60\x20\x21\x3c\x00" }  },
      /* --- pixel bitmap for cmmi100 char#80 P --- */
      {  80,17278,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x10\x22\x24\xc4\x87\x00\x01\x01\x0f\x00" }  },
      /* --- pixel bitmap for cmmi100 char#81 Q --- */
      {  81,18265,                      /* character number, location */
          9, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  9,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x08\x0b\x1c\x18\x30\x60\x20\x2d\x3c\x00\x00\x00"
            "\x03" }  },
      /* --- pixel bitmap for cmmi100 char#82 R --- */
      {  82,19576,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x10\x23\x24\xc4\x87\x08\x11\x11\xcf\x01" }  },
      /* --- pixel bitmap for cmmi100 char#83 S --- */
      {  83,20595,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x84\x04\x04\x38\x40\x40\x21\x1f" }  },
      /* --- pixel bitmap for cmmi100 char#84 T --- */
      {  84,21611,                      /* character number, location */
          9,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          { 11,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x17\xa2\x10\x43\x04\x02\x10\x80\x00\x02\x7c\x00" }  },
      /* --- pixel bitmap for cmmi100 char#85 U --- */
      {  85,22591,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xef\x85\x08\x09\x11\x22\x44\x88\x08\x0f\x00" }  },
      /* --- pixel bitmap for cmmi100 char#86 V --- */
      {  86,23491,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcf\x13\x42\x04\x11\x24\x90\x40\x01\x03\x0c\x00" }  },
      /* --- pixel bitmap for cmmi100 char#87 W --- */
      {  87,24856,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcf\xb9\x30\x42\x8a\x90\x12\x94\x04\xa5\xc0\x28\x10"
            "\x06\x84\x01" }  },
      /* --- pixel bitmap for cmmi100 char#88 X --- */
      {  88,25983,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x87\x08\x28\xc0\x00\x06\x28\x60\x02\x11\xcf\x03" }  },
      /* --- pixel bitmap for cmmi100 char#89 Y --- */
      {  89,27039,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcf\x13\x82\x04\x0a\x38\x40\x00\x01\x02\x3c\x00" }  },
      /* --- pixel bitmap for cmmi100 char#90 Z --- */
      {  90,28084,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x4c\x24\x32\x10\x48\x44\x22\x3f" }  },
      /* --- pixel bitmap for cmmi100 char#91 \flat --- */
      {  91,112714,                     /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  3,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x49\xd2\xf6\x0b" }  },
      /* --- pixel bitmap for cmmi100 char#92 \natural --- */
      {  92,113421,                     /* character number, location */
         10, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  5,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x21\x84\x7c\x63\x8c\x31\x5f\x08\x01" }  },
      /* --- pixel bitmap for cmmi100 char#93 \sharp --- */
      {  93,114236,                     /* character number, location */
         10, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  3,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6d\xfb\xb6\xed\x5b" }  },
      /* --- pixel bitmap for cmmi100 char#94 \smile --- */
      {  94,115108,                     /* character number, location */
          6, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          { 12,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\x28\x40\x04\x82\x1f" }  },
      /* --- pixel bitmap for cmmi100 char#95 \frown --- */
      {  95,115946,                     /* character number, location */
          6, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          { 12,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x41\x20\x02\x14\x80" }  },
      /* --- pixel bitmap for cmmi100 char#96 \ell --- */
      {  96,90620,                      /* character number, location */
         10,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\x28\x12\x45\xa2\x30\x08\x46\x1c" }  },
      /* --- pixel bitmap for cmmi100 char#97 a --- */
      {  97,28976,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\xc6\x98\x2d" }  },
      /* --- pixel bitmap for cmmi100 char#98 b --- */
      {  98,29788,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x23\x22\x97\x99\x35" }  },
      /* --- pixel bitmap for cmmi100 char#99 c --- */
      {  99,30573,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\x11\x79" }  },
      /* --- pixel bitmap for cmmi100 char#100 d --- */
      { 100,31499,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x08\x82\x9c\x14\x45\x99\x05" }  },
      /* --- pixel bitmap for cmmi100 char#101 e --- */
      { 101,32286,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9e\x17\x69" }  },
      /* --- pixel bitmap for cmmi100 char#102 f --- */
      { 102,33416,                      /* character number, location */
         10, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  7,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\x08\x04\x82\x83\x20\x10\x08\x04\x82\x70\x00" }  },
      /* --- pixel bitmap for cmmi100 char#103 g --- */
      { 103,34363,                      /* character number, location */
          6, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x49\x92\x14\x07\x41\x0f" }  },
      /* --- pixel bitmap for cmmi100 char#104 h --- */
      { 104,35264,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x41\x10\x9a\x29\x8a\x71\x08" }  },
      /* --- pixel bitmap for cmmi100 char#105 i --- */
      { 105,36040,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x00\x52\x22\x66" }  },
      /* --- pixel bitmap for cmmi100 char#106 j --- */
      { 106,36941,                      /* character number, location */
         10, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  6,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x00\x00\x18\x05\x41\x08\x82\x10\x07" }  },
      /* --- pixel bitmap for cmmi100 char#107 k --- */
      { 107,37934,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x41\x10\xb2\x6a\x18\x55\x06" }  },
      /* --- pixel bitmap for cmmi100 char#108 l --- */
      { 108,38596,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  3,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x26\x29\x49\x13" }  },
      /* --- pixel bitmap for cmmi100 char#109 m --- */
      { 109,39737,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb6\x6b\x16\x91\x88\x24\x52\x11\x01" }  },
      /* --- pixel bitmap for cmmi100 char#110 n --- */
      { 110,40674,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbe\x16\x89\x24\x15\x01" }  },
      /* --- pixel bitmap for cmmi100 char#111 o --- */
      { 111,41374,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4c\xc6\x98\x0c" }  },
      /* --- pixel bitmap for cmmi100 char#112 p --- */
      { 112,42280,                      /* character number, location */
          6, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x36\x27\x91\x68\xd2\x08\x04\x07" }  },
      /* --- pixel bitmap for cmmi100 char#113 q --- */
      { 113,43157,                      /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  4,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x96\x99\x75\x44\x0f" }  },
      /* --- pixel bitmap for cmmi100 char#114 r --- */
      { 114,43958,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7e\x4b\x10\x82\x00" }  },
      /* --- pixel bitmap for cmmi100 char#115 s --- */
      { 115,44854,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x98\x32\x18\x1d" }  },
      /* --- pixel bitmap for cmmi100 char#116 t --- */
      { 116,45560,                      /* character number, location */
          9,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  4,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x88\xf8\x44\xa4\x0c" }  },
      /* --- pixel bitmap for cmmi100 char#117 u --- */
      { 117,46548,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe2\x28\x8a\xb2\x0b" }  },
      /* --- pixel bitmap for cmmi100 char#118 v --- */
      { 118,47399,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe2\x28\x8a\x92\x03" }  },
      /* --- pixel bitmap for cmmi100 char#119 w --- */
      { 119,48543,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x22\x47\x8a\x14\x29\xcb\x0d" }  },
      /* --- pixel bitmap for cmmi100 char#120 x --- */
      { 120,49745,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x25\x02\x51\xf2\x00" }  },
      /* --- pixel bitmap for cmmi100 char#121 y --- */
      { 121,50757,                      /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x66\x49\x92\x14\x07\x29\x06" }  },
      /* --- pixel bitmap for cmmi100 char#122 z --- */
      { 122,51611,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xac\x8c\x11\x52\x07" }  },
      /* --- pixel bitmap for cmmi100 char#123 \imath --- */
      { 123,91284,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  3,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xaa\x64\x03" }  },
      /* --- pixel bitmap for cmmi100 char#124 \jmath --- */
      { 124,92069,                      /* character number, location */
          6, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  5,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x98\x42\x88\x10\x22\x07" }  },
      /* --- pixel bitmap for cmmi100 char#125 \wp --- */
      { 125,93174,                      /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\x5c\x71\xb8\x9a\x14\x0a\x03" }  },
      /* --- pixel bitmap for cmmi100 char#126 \vec --- */
      { 126,93748,                      /* character number, location */
         10, 2,    7, 2,      /* topleft row,col, and botleft row,col */
          {  7,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa0\x3f\x08" }  },
      /* --- pixel bitmap for cmmi100 char#127 (noname) --- */
      { 127,94258,                      /* character number, location */
         10, 4,    7, 4,      /* topleft row,col, and botleft row,col */
          {  6,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x18\x02" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=2 for .118gf ---
 * mf '\mode=preview; mag=magstep(-16.96645799324018499600); input cmmi10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmmi118 --- */
static	chardef  cmmi118[] =
   {
      /* --- pixel bitmap for cmmi118 char#0 \Gamma --- */
      {   0,53147,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   11, 3,25, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x39\xf2\x41\x51\x10\x41\x70\xf3\x31\x80\x21\x95\x71" }  },
      /* --- pixel bitmap for cmmi118 char#1 \Delta --- */
      {   1,54016,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x01\x28\x40\x02\x26\x20\x06\x41\x08\xc4\x40\x04"
            "\x2c\x80\xff\x0f" }  },
      /* --- pixel bitmap for cmmi118 char#2 \Theta --- */
      {   2,55125,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x81\x61\x04\x24\x40\x12\x99\x4f\x89\x14\x60\x02"
            "\x62\x18\x7c\x00" }  },
      /* --- pixel bitmap for cmmi118 char#3 \Lambda --- */
      {   3,56037,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x00\x03\x0a\x28\x90\x40\x82\x08\x22\x84\x18\xf2"
            "\x3c" }  },
      /* --- pixel bitmap for cmmi118 char#4 \Xi --- */
      {   4,57424,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x4f\x40\x00\x00\x00\x08\xc2\x1f\x04\x01\x00\x02"
            "\x12\x10\xff\x01" }  },
      /* --- pixel bitmap for cmmi118 char#5 \Pi --- */
      {   5,58649,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   11, 3,27, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3b\xf3\x41\x61\x20\xf3\x31\x61\x30\x21\x61\x45\x25"
            "\x21" }  },
      /* --- pixel bitmap for cmmi118 char#6 \Sigma --- */
      {   6,59786,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x1f\x01\x61\x20\x08\x04\x03\x40\x00\x04\x40\x20"
            "\x0c\xc6\x40\xfc\x0f" }  },
      /* --- pixel bitmap for cmmi118 char#7 \Upsilon --- */
      {   7,60806,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8e\x27\x08\x02\x04\x10\x20\x80\x00\x02\x08\x10\xf0"
            "\x01" }  },
      /* --- pixel bitmap for cmmi118 char#8 \Phi --- */
      {   8,61786,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x03\x01\x04\x7e\x42\x86\x28\x32\x3f\x20\x40\xc0"
            "\x07" }  },
      /* --- pixel bitmap for cmmi118 char#9 \Psi --- */
      {   9,62819,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x01\xc1\x88\x45\x24\x22\x89\x48\x82\x0f\x10\x40"
            "\x80\x0f\x00" }  },
      /* --- pixel bitmap for cmmi118 char#10 \Omega --- */
      {  10,63988,                      /* character number, location */
         11, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x61\x90\x00\x05\x28\x40\x01\x09\x44\x10\x45\x29"
            "\xca\x39\x00" }  },
      /* --- pixel bitmap for cmmi118 char#11 \alpha --- */
      {  11,64984,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\xa2\xa1\xc1\x41\x71\xce" }  },
      /* --- pixel bitmap for cmmi118 char#12 \beta --- */
      {  12,65987,                      /* character number, location */
         11, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x20\x22\x44\x8c\x87\x10\x41\x82\x04\x8d\xe9\x10"
            "\x20\x20\x00" }  },
      /* --- pixel bitmap for cmmi118 char#13 \gamma --- */
      {  13,66854,                      /* character number, location */
          7, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x25\x85\x02\x03\x06\x0c\x08\x10\x20\x20\x00" }  },
      /* --- pixel bitmap for cmmi118 char#14 \delta --- */
      {  14,67767,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x41\x10\x8c\x14\x45\x51\x62\x00" }  },
      /* --- pixel bitmap for cmmi118 char#15 \epsilon --- */
      {  15,68611,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\x84\x17\xa2\x03" }  },
      /* --- pixel bitmap for cmmi118 char#16 \zeta --- */
      {  16,69485,                      /* character number, location */
         11, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  6,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x8c\x10\x42\x10\x04\x41\x60\x60\x10\x03" }  },
      /* --- pixel bitmap for cmmi118 char#17 \eta --- */
      {  17,70360,                      /* character number, location */
          7, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf6\x66\x91\x48\x14\x89\x40\x20\x08" }  },
      /* --- pixel bitmap for cmmi118 char#18 \theta --- */
      {  18,71104,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x49\x8a\xe2\x17\x45\x49\x62\x00" }  },
      /* --- pixel bitmap for cmmi118 char#19 \iota --- */
      {  19,71729,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x24\x22\x91\x06" }  },
      /* --- pixel bitmap for cmmi118 char#20 \kappa --- */
      {  20,72625,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe4\x12\x0e\x1e\x22\x51\x61" }  },
      /* --- pixel bitmap for cmmi118 char#21 \lambda --- */
      {  21,73438,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x08\x10\x10\x20\x20\x30\x48\x44\x82\x81" }  },
      /* --- pixel bitmap for cmmi118 char#22 \mu --- */
      {  22,74418,                      /* character number, location */
          7, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x88\x44\x44\x44\x64\xa6\xde\x02\x02\x01" }  },
      /* --- pixel bitmap for cmmi118 char#23 \nu --- */
      {  23,75165,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x87\x42\x42\x22\x12\x0d\x03" }  },
      /* --- pixel bitmap for cmmi118 char#24 \xi --- */
      {  24,76247,                      /* character number, location */
         11, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  6,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x6e\x08\x02\x27\x04\x41\x30\x30\x10\x03" }  },
      /* --- pixel bitmap for cmmi118 char#25 \pi --- */
      {  25,77145,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x55\xa4\x20\x41\x82\x84\x08" }  },
      /* --- pixel bitmap for cmmi118 char#26 \rho --- */
      {  26,77933,                      /* character number, location */
          7, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x24\x91\x48\x34\x69\x04\x82\x00" }  },
      /* --- pixel bitmap for cmmi118 char#27 \sigma --- */
      {  27,78791,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x22\x21\x21\x11\x11\x0e" }  },
      /* --- pixel bitmap for cmmi118 char#28 \tau --- */
      {  28,79514,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x0a\x09\x08\x08\x04\x04" }  },
      /* --- pixel bitmap for cmmi118 char#29 \upsilon --- */
      {  29,80407,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\x89\x85\x84\x44\x64\x18" }  },
      /* --- pixel bitmap for cmmi118 char#30 \phi --- */
      {  30,81261,                      /* character number, location */
         11, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  8,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x20\x20\x10\x38\x56\x91\x89\x49\x69\x1e\x04\x04"
            "\x04" }  },
      /* --- pixel bitmap for cmmi118 char#31 \chi --- */
      {  31,82234,                      /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\x09\x21\x41\x01\x01\x02\x0a\x12\x42\x02\x01" }  },
      /* --- pixel bitmap for cmmi118 char#32 \psi --- */
      {  32,83287,                      /* character number, location */
         11, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          { 10,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x00\x01\x04\x10\x46\xa6\x58\x22\x89\x24\x51\x82"
            "\x07\x04\x10\x20\x00" }  },
      /* --- pixel bitmap for cmmi118 char#33 \omega --- */
      {  33,84336,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\x0a\x18\x62\x88\x31\xe7\xe4\x0c" }  },
      /* --- pixel bitmap for cmmi118 char#34 \varepsilon --- */
      {  34,85297,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x8c\x17\xe2\x03" }  },
      /* --- pixel bitmap for cmmi118 char#35 \vartheta --- */
      {  35,86288,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x70\x88\x88\x88\xb6\xc5\x45\x44\x24\x24\x1c" }  },
      /* --- pixel bitmap for cmmi118 char#36 \varpi --- */
      {  36,87483,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x5f\x01\x15\x21\x22\x44\x46\xc8\x08\xe7\x00" }  },
      /* --- pixel bitmap for cmmi118 char#37 \varrho --- */
      {  37,88334,                      /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x29\x8a\xe2\xd4\x04\x81\x03" }  },
      /* --- pixel bitmap for cmmi118 char#38 \varsigma --- */
      {  38,89113,                      /* character number, location */
          7, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  5,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\x84\x10\x0c\x42\x0c" }  },
      /* --- pixel bitmap for cmmi118 char#39 \varphi --- */
      {  39,90036,                      /* character number, location */
          7, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          { 10,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc2\x89\x18\x61\x84\x11\x29\xc2\x07\x02\x08\x10\x00" }  },
      /* --- pixel bitmap for cmmi118 char#40 \leftharpoonup --- */
      {  40,105132,                     /* character number, location */
          8, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          { 14,    4, 3, 8, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x31\xc1\xc2\xbe" }  },
      /* --- pixel bitmap for cmmi118 char#41 \leftharpoondown --- */
      {  41,106128,                     /* character number, location */
          5, 1,    1, 1,      /* topleft row,col, and botleft row,col */
          { 14,    4, 3, 9, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x12\xd1\xe1\xa1" }  },
      /* --- pixel bitmap for cmmi118 char#42 \rightharpoonup --- */
      {  42,107122,                     /* character number, location */
          8, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          { 14,    4, 3, 8, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa1\xe1\xd2\x1e" }  },
      /* --- pixel bitmap for cmmi118 char#43 \rightharpoondown --- */
      {  43,108119,                     /* character number, location */
          5, 1,    1, 1,      /* topleft row,col, and botleft row,col */
          { 14,    4, 3, 9, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\xb2\xc1\xc1\x31" }  },
      /* --- pixel bitmap for cmmi118 char#44 ` --- */
      {  44,108534,                     /* character number, location */
          9, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          {  3,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4e\x62" }  },
      /* --- pixel bitmap for cmmi118 char#45 ' --- */
      {  45,108952,                     /* character number, location */
          9, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          {  3,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x23\x39" }  },
      /* --- pixel bitmap for cmmi118 char#46 \triangleright --- */
      {  46,109461,                     /* character number, location */
          8, 1,    1, 1,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc1\x91\x85\xd9\x11\x00" }  },
      /* --- pixel bitmap for cmmi118 char#47 \triangleleft --- */
      {  47,109979,                     /* character number, location */
          8, 1,    1, 1,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x6e\x86\x26\x0e\x02" }  },
      /* --- pixel bitmap for cmmi118 char#48 \0 --- */
      {  48,96123,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x18\x86\x61\xe8\x01" }  },
      /* --- pixel bitmap for cmmi118 char#49 \1 --- */
      {  49,96848,                      /* character number, location */
          7, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe4\x10\x42\xc8\x07" }  },
      /* --- pixel bitmap for cmmi118 char#50 \2 --- */
      {  50,97782,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x08\xc2\x88\xf9\x03" }  },
      /* --- pixel bitmap for cmmi118 char#51 \3 --- */
      {  51,98769,                      /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x18\x82\x1c\x04\x86\x91\x03" }  },
      /* --- pixel bitmap for cmmi118 char#52 \4 --- */
      {  52,99654,                      /* character number, location */
          7, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x30\x28\x24\x22\x23\xff\x20\x20\xf8" }  },
      /* --- pixel bitmap for cmmi118 char#53 \5 --- */
      {  53,100651,                     /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe1\x17\x04\xdd\x08\x86\x91\x03" }  },
      /* --- pixel bitmap for cmmi118 char#54 \6 --- */
      {  54,101506,                     /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x28\x04\xcd\x14\x86\xa1\xc4\x00" }  },
      /* --- pixel bitmap for cmmi118 char#55 \7 --- */
      {  55,102369,                     /* character number, location */
          8, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  7,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x81\x7f\x30\x04\x41\x20\x08\x04\x02\x01" }  },
      /* --- pixel bitmap for cmmi118 char#56 \8 --- */
      {  56,103254,                     /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x18\x86\x9e\x33\x85\x61\xe8\x01" }  },
      /* --- pixel bitmap for cmmi118 char#57 \9 --- */
      {  57,104115,                     /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x14\x86\xb1\x0b\x42\x91\x03" }  },
      /* --- pixel bitmap for cmmi118 char#58 . --- */
      {  58,110452,                     /* character number, location */
          2, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  2,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmmi118 char#59 , --- */
      {  59,111011,                     /* character number, location */
          2, 2,   -3, 2,      /* topleft row,col, and botleft row,col */
          {  2,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xaf\x01" }  },
      /* --- pixel bitmap for cmmi118 char#60 < --- */
      {  60,111641,                     /* character number, location */
         10, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 3,22, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x92\x72\x72\x72\x72\x81\xb2\xb2\xb2\xb2\xb2" }  },
      /* --- pixel bitmap for cmmi118 char#61 / --- */
      {  61,112139,                     /* character number, location */
         12, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  6,   16, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x08\x41\x10\x82\x20\x04\x41\x08\x82\x10\x04" }  },
      /* --- pixel bitmap for cmmi118 char#62 > --- */
      {  62,112794,                     /* character number, location */
         10, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 3,23, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\xb2\xb2\xb2\xb2\xb1\x82\x72\x72\x72\x72\x92" }  },
      /* --- pixel bitmap for cmmi118 char#63 \star --- */
      {  63,113467,                     /* character number, location */
          5,-1,    3,-1,      /* topleft row,col, and botleft row,col */
          {  7,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x18" }  },
      /* --- pixel bitmap for cmmi118 char#64 \partial --- */
      {  64,91002,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x42\x40\x80\xbc\x42\x41\x41\x21\x11\x0e" }  },
      /* --- pixel bitmap for cmmi118 char#65 A --- */
      {  65, 1000,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x00\x06\x30\x40\x02\x12\x88\x20\x04\x3f\x04\x21"
            "\xc8\xe3\x01" }  },
      /* --- pixel bitmap for cmmi118 char#66 B --- */
      {  66, 2310,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x0f\x02\x43\x40\x08\x08\xc1\xf0\x0f\x02\x43\x40"
            "\x08\x88\xc0\xfc\x07" }  },
      /* --- pixel bitmap for cmmi118 char#67 C --- */
      {  67, 3233,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x89\x61\x04\x24\x40\x02\x10\x00\x01\x10\x20\x02"
            "\x61\x18\x78\x00" }  },
      /* --- pixel bitmap for cmmi118 char#68 D --- */
      {  68, 4377,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x07\x82\x41\x20\x08\x08\x01\x11\x10\x02\x42\x40"
            "\x08\x84\x60\xfc\x03" }  },
      /* --- pixel bitmap for cmmi118 char#69 E --- */
      {  69, 5780,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x1f\x02\x41\x20\x88\x04\x19\xf0\x01\x22\x42\x44"
            "\x08\x84\xc0\xfc\x0f" }  },
      /* --- pixel bitmap for cmmi118 char#70 F --- */
      {  70, 6993,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x1f\x02\x41\x20\x08\x05\x31\xf0\x03\x42\x40\x08"
            "\x08\x80\x00\x7c\x00" }  },
      /* --- pixel bitmap for cmmi118 char#71 G --- */
      {  71, 8134,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x89\x61\x04\x24\x40\x02\x10\x00\x81\x17\x20\x02"
            "\x62\x10\xf8\x01" }  },
      /* --- pixel bitmap for cmmi118 char#72 H --- */
      {  72, 9361,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   11, 3,33, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x34\x34\xf3\x41\x61\x20\x38\x30\xf2\x31\x61\x30\x21"
            "\x61\x45\x25\x22" }  },
      /* --- pixel bitmap for cmmi118 char#73 I --- */
      {  73,10068,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   11, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x35\xf3\x41\x30\xf3\x31\x40\x21\x55\x31" }  },
      /* --- pixel bitmap for cmmi118 char#74 J --- */
      {  74,10910,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   11, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\xf3\x61\x20\xf3\x51\x31\x31\x53\x51" }  },
      /* --- pixel bitmap for cmmi118 char#75 K --- */
      {  75,12097,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x7c\x08\x06\x84\x00\x22\x00\x0d\x40\x07\x60\x04"
            "\x10\x02\x08\x02\x02\xc1\xc7\x03" }  },
      /* --- pixel bitmap for cmmi118 char#76 L --- */
      {  76,13052,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x40\x00\x01\x04\x10\x20\x80\x20\x82\x08\x13\xf6"
            "\x1f" }  },
      /* --- pixel bitmap for cmmi118 char#77 M --- */
      {  77,14368,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 17,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\xc0\x61\xc0\x40\x81\x81\x82\x02\x85\x04\x09\x05"
            "\x12\x09\x24\x11\x88\x22\x08\x23\x7c\xf2\x01" }  },
      /* --- pixel bitmap for cmmi118 char#78 N --- */
      {  78,15498,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x3c\x0c\x02\x85\x40\x21\xd0\x08\x22\x81\x48\x20"
            "\x14\x08\x05\xc1\xf0\x21\x00" }  },
      /* --- pixel bitmap for cmmi118 char#79 O --- */
      {  79,16331,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x81\x61\x04\x24\x00\x02\x18\x40\x01\x14\x60\x02"
            "\x62\x18\x7c\x00" }  },
      /* --- pixel bitmap for cmmi118 char#80 P --- */
      {  80,17394,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   11, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x10\xf2\x41\x61\x41\x51\x47\x20\xf2\x31\x80\x21"
            "\x95\x71" }  },
      /* --- pixel bitmap for cmmi118 char#81 Q --- */
      {  81,18387,                      /* character number, location */
         11, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          { 12,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x81\x61\x04\x24\x40\x02\x18\x40\x01\x14\x60\x32"
            "\xe2\x18\x7c\x00\x04\x40\x00\x1c" }  },
      /* --- pixel bitmap for cmmi118 char#82 R --- */
      {  82,19656,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x07\x81\x10\x08\x81\x10\x84\x1f\x08\x83\x20\x08"
            "\x42\x10\x1f\x0e" }  },
      /* --- pixel bitmap for cmmi118 char#83 S --- */
      {  83,20735,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x22\x44\x10\x01\x0c\xc0\x01\x08\x20\x82\x0c\xd1"
            "\x03" }  },
      /* --- pixel bitmap for cmmi118 char#84 T --- */
      {  84,21763,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x1f\x51\x88\x42\x04\x02\x08\x40\x00\x02\x10\x40"
            "\x80\x1f\x00" }  },
      /* --- pixel bitmap for cmmi118 char#85 U --- */
      {  85,22721,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 3,27, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x34\xf3\x11\x61\x2f\x21\x61\x31\x51\x41\x42\x54"
            "\x61" }  },
      /* --- pixel bitmap for cmmi118 char#86 V --- */
      {  86,23629,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8f\x17\x08\x41\x08\x41\x04\x22\x90\x80\x04\x14\x60"
            "\x00\x03\x00" }  },
      /* --- pixel bitmap for cmmi118 char#87 W --- */
      {  87,24950,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8f\xf7\x42\x41\x42\x21\x22\x11\x22\x11\x12\x09\x12"
            "\x09\x0a\x05\x0a\x05\x06\x02\x06\x02" }  },
      /* --- pixel bitmap for cmmi118 char#88 X --- */
      {  88,26123,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x3c\x08\x01\x24\x00\x05\xc0\x00\x30\x00\x0c\x80"
            "\x04\x10\x01\x82\xf0\xf0\x00" }  },
      /* --- pixel bitmap for cmmi118 char#89 Y --- */
      {  89,27159,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8f\x4f\x10\x84\x80\x0c\x48\x00\x03\x10\x00\x01\x10"
            "\x80\x00\x3e\x00" }  },
      /* --- pixel bitmap for cmmi118 char#90 Z --- */
      {  90,28236,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x67\x10\x41\x08\x01\x04\x10\x40\x04\x21\x84\x11"
            "\xc6\x3f\x00" }  },
      /* --- pixel bitmap for cmmi118 char#91 \flat --- */
      {  91,114102,                     /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x11\x11\xd1\x99\x59\x37" }  },
      /* --- pixel bitmap for cmmi118 char#92 \natural --- */
      {  92,114817,                     /* character number, location */
         11, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  4,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x11\xd1\x9b\x99\x99\xbd\x88" }  },
      /* --- pixel bitmap for cmmi118 char#93 \sharp --- */
      {  93,115636,                     /* character number, location */
         11, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  4,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x98\xd9\x9b\x99\x99\xbd\x19" }  },
      /* --- pixel bitmap for cmmi118 char#94 \smile --- */
      {  94,116512,                     /* character number, location */
          7, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          { 14,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\xa0\x00\x44\x80\x20\x10\xf0\x03" }  },
      /* --- pixel bitmap for cmmi118 char#95 \frown --- */
      {  95,117354,                     /* character number, location */
          7, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          { 14,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x03\x02\x41\x80\x08\x40\x01\x20" }  },
      /* --- pixel bitmap for cmmi118 char#96 \ell --- */
      {  96,91776,                      /* character number, location */
         11,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  7,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\x28\x14\x89\xa2\x30\x08\x86\x22\x0e" }  },
      /* --- pixel bitmap for cmmi118 char#97 a --- */
      {  97,29160,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xac\x14\x45\x51\x6a\x03" }  },
      /* --- pixel bitmap for cmmi118 char#98 b --- */
      {  98,29980,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x47\x08\xe1\x66\x8c\x31\x19" }  },
      /* --- pixel bitmap for cmmi118 char#99 c --- */
      {  99,30769,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\x86\x10\xa2\x03" }  },
      /* --- pixel bitmap for cmmi118 char#100 d --- */
      { 100,31697,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x70\x10\x08\xc4\x92\x44\x22\x91\x94\x0d" }  },
      /* --- pixel bitmap for cmmi118 char#101 e --- */
      { 101,32518,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\xe6\x13\xa2\x03" }  },
      /* --- pixel bitmap for cmmi118 char#102 f --- */
      { 102,33652,                      /* character number, location */
         11, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 3,25, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x63\xf2\x51\x30\x34\x20\xf4\x41\x40\xf2\x31\x53\x61" }  },
      /* --- pixel bitmap for cmmi118 char#103 g --- */
      { 103,34601,                      /* character number, location */
          7, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb0\x48\x44\x44\x44\x24\x38\x20\x20\x1f" }  },
      /* --- pixel bitmap for cmmi118 char#104 h --- */
      { 104,35508,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x02\x81\xc0\x33\x89\x44\x92\x68\x08" }  },
      /* --- pixel bitmap for cmmi118 char#105 i --- */
      { 105,36328,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x00\x60\x59\x24\xca" }  },
      /* --- pixel bitmap for cmmi118 char#106 j --- */
      { 106,37235,                      /* character number, location */
         12, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  7,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x00\x00\x00\xc0\xa1\x48\x20\x10\x04\x02\x41\x1c"
            "\x00" }  },
      /* --- pixel bitmap for cmmi118 char#107 k --- */
      { 107,38232,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x02\x81\x40\xd6\x1a\x1c\x92\x54\x0c" }  },
      /* --- pixel bitmap for cmmi118 char#108 l --- */
      { 108,38898,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4e\x44\x24\x22\x52\x06" }  },
      /* --- pixel bitmap for cmmi118 char#109 m --- */
      { 109,40057,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x66\xae\x33\x35\x22\x42\x44\x48\x84\xa8\x10\x02" }  },
      /* --- pixel bitmap for cmmi118 char#110 n --- */
      { 110,41068,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x76\x4d\x45\x44\x24\xa2\x42" }  },
      /* --- pixel bitmap for cmmi118 char#111 o --- */
      { 111,41776,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x18\x86\x51\xe4\x00" }  },
      /* --- pixel bitmap for cmmi118 char#112 p --- */
      { 112,42686,                      /* character number, location */
          7, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6c\x9a\x8a\x88\x88\x4c\x34\x04\x04\x0f" }  },
      /* --- pixel bitmap for cmmi118 char#113 q --- */
      { 113,43571,                      /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xac\x14\x45\x51\xe2\x20\x88\x07" }  },
      /* --- pixel bitmap for cmmi118 char#114 r --- */
      { 114,44392,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf6\x66\x81\x40\x10\x08\x00" }  },
      /* --- pixel bitmap for cmmi118 char#115 s --- */
      { 115,45346,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x12\x01\x07\x0c\x79\x00" }  },
      /* --- pixel bitmap for cmmi118 char#116 t --- */
      { 116,46054,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x84\x90\x2f\x84\x10\xc9\x00" }  },
      /* --- pixel bitmap for cmmi118 char#117 u --- */
      { 117,47032,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\x49\x45\x44\x64\xa4\xdc" }  },
      /* --- pixel bitmap for cmmi118 char#118 v --- */
      { 118,47907,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc6\x64\x91\x48\x22\x71\x00" }  },
      /* --- pixel bitmap for cmmi118 char#119 w --- */
      { 119,49073,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\x4c\x62\x11\x89\x48\x24\x32\x61\x07" }  },
      /* --- pixel bitmap for cmmi118 char#120 x --- */
      { 120,50285,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x94\x12\x10\x10\x59\x36" }  },
      /* --- pixel bitmap for cmmi118 char#121 y --- */
      { 121,51317,                      /* character number, location */
          7, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\x49\x45\x44\x64\x24\x3c\x20\x12\x0e" }  },
      /* --- pixel bitmap for cmmi118 char#122 z --- */
      { 122,52229,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x62\x20\x18\x44\x26\x19" }  },
      /* --- pixel bitmap for cmmi118 char#123 \imath --- */
      { 123,92484,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x96\x45\xa2\x0c" }  },
      /* --- pixel bitmap for cmmi118 char#124 \jmath --- */
      { 124,93275,                      /* character number, location */
          7, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x4a\x82\x20\x04\x41\xc8\x01" }  },
      /* --- pixel bitmap for cmmi118 char#125 \wp --- */
      { 125,94358,                      /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\xc4\x65\x2c\x38\x50\x52\x99\x04\x09\x0c\x00" }  },
      /* --- pixel bitmap for cmmi118 char#126 \vec --- */
      { 126,94940,                      /* character number, location */
         11, 2,    8, 2,      /* topleft row,col, and botleft row,col */
          {  8,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\xff\x40" }  },
      /* --- pixel bitmap for cmmi118 char#127 (noname) --- */
      { 127,95476,                      /* character number, location */
         11, 4,    8, 4,      /* topleft row,col, and botleft row,col */
          {  8,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x82\x81" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=3 for .131gf ---
 * mf '\mode=preview; mag=magstep(-16.39322518098640003469); input cmmi10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmmi131 --- */
static	chardef  cmmi131[] =
   {
      /* --- pixel bitmap for cmmi131 char#0 \Gamma --- */
      {   0,53970,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   12, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3a\x52\x42\xf2\x42\x51\x10\x42\x70\xf3\x32\x80\x22"
            "\x96\x71" }  },
      /* --- pixel bitmap for cmmi131 char#1 \Delta --- */
      {   1,54869,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   12, 3,38, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x91\xb2\xa4\x81\x22\x72\x22\x71\x33\x51\x52\x41\x62"
            "\x32\x62\x31\x73\x1e\x0b" }  },
      /* --- pixel bitmap for cmmi131 char#2 \Theta --- */
      {   2,56028,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x03\x86\x21\x30\x06\x6c\x92\xcd\xf3\x3c\x9b\x64"
            "\x03\xc6\xc0\x18\x06\x7c\x00" }  },
      /* --- pixel bitmap for cmmi131 char#3 \Lambda --- */
      {   3,56972,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x01\x18\x80\x01\x1c\xa0\x01\x1a\x90\x03\x31\x08"
            "\x43\x30\x04\xf3\xfc" }  },
      /* --- pixel bitmap for cmmi131 char#4 \Xi --- */
      {   4,58385,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   12, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x3a\xf1\x21\x81\x10\x41\x41\x76\x66\x71\x41\x40"
            "\xf1\x11\x81\x2f\x1a\x31" }  },
      /* --- pixel bitmap for cmmi131 char#5 \Pi --- */
      {   5,59564,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 17,   12, 3,33, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\x52\x62\x20\xf3\x42\x62\x30\xf3\x32\x62\x40\x22"
            "\x62\x56\x26\x3f" }  },
      /* --- pixel bitmap for cmmi131 char#6 \Sigma --- */
      {   6,60731,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x3f\x0e\x0c\x03\xc1\x41\x60\x10\x38\x00\x0c\x80"
            "\x20\x10\x08\x02\x43\x60\xf8\x1f" }  },
      /* --- pixel bitmap for cmmi131 char#7 \Upsilon --- */
      {   7,61783,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   12, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x13\x48\x24\x41\x11\x40\xf2\x42\x50\xf3\x32\x60\x22"
            "\x76\x51" }  },
      /* --- pixel bitmap for cmmi131 char#8 \Phi --- */
      {   8,62791,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x07\x18\xc0\x00\x3f\xcc\x66\xcc\x63\x66\x36\xfc"
            "\x00\x06\x30\xc0\x0f" }  },
      /* --- pixel bitmap for cmmi131 char#9 \Psi --- */
      {   9,63856,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x03\x0c\x67\x6c\x66\x66\x66\x66\x36\x63\x1b\xfc"
            "\x00\x03\x18\xe0\x07" }  },
      /* --- pixel bitmap for cmmi131 char#10 \Omega --- */
      {  10,65057,                      /* character number, location */
         12, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 12,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x83\x61\x0c\x6c\xc0\x06\x6c\x60\x06\x66\x30\x05"
            "\x55\x28\x87\x73\x1c" }  },
      /* --- pixel bitmap for cmmi131 char#11 \alpha --- */
      {  11,66083,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x10\x29\x54\x50\xc1\x04\x11\x8a\x67" }  },
      /* --- pixel bitmap for cmmi131 char#12 \beta --- */
      {  12,67094,                      /* character number, location */
         13, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          { 11,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x01\x11\x04\x21\x84\x30\x74\x20\x84\x40\x04\x22"
            "\x10\x41\x0c\xa1\x07\x01\x08\x20\x00\x01\x00" }  },
      /* --- pixel bitmap for cmmi131 char#13 \gamma --- */
      {  13,67999,                      /* character number, location */
          8, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          { 10,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x9a\x14\x14\x50\xc0\x00\x03\x0c\x10\x40\x00\x01"
            "\x02\x08" }  },
      /* --- pixel bitmap for cmmi131 char#14 \delta --- */
      {  14,68918,                      /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x34\x81\x80\x40\x60\x28\xa2\x50\x28\x14\x71\x00" }  },
      /* --- pixel bitmap for cmmi131 char#15 \epsilon --- */
      {  15,69746,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb8\x21\x7c\x41\x20\x72" }  },
      /* --- pixel bitmap for cmmi131 char#16 \zeta --- */
      {  16,70648,                      /* character number, location */
         13, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  8,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x20\xe0\x18\x04\x04\x02\x01\x01\x01\x01\x01\x06"
            "\x18\x20\x20\x1c" }  },
      /* --- pixel bitmap for cmmi131 char#17 \eta --- */
      {  17,71529,                      /* character number, location */
          8, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          {  8,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe6\x9a\x8d\x84\x84\x84\x42\x42\x40\x40\x20\x20" }  },
      /* --- pixel bitmap for cmmi131 char#18 \theta --- */
      {  18,72279,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x24\x91\x28\x14\xfa\x43\xa1\x50\x24\x61\x00" }  },
      /* --- pixel bitmap for cmmi131 char#19 \iota --- */
      {  19,72912,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x84\x08\x21\x62\x32" }  },
      /* --- pixel bitmap for cmmi131 char#20 \kappa --- */
      {  20,73812,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x84\xc9\x48\xf0\x20\x42\x68\xa8\x60" }  },
      /* --- pixel bitmap for cmmi131 char#21 \lambda --- */
      {  21,74633,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x20\x40\x00\x01\x02\x04\x10\x30\x50\x10\x11\x12"
            "\x14\x10" }  },
      /* --- pixel bitmap for cmmi131 char#22 \mu --- */
      {  22,75619,                      /* character number, location */
          8, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          { 10,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x21\x44\x08\x21\x84\x10\x6b\x94\x6e\x02\x08\x10"
            "\x40\x00" }  },
      /* --- pixel bitmap for cmmi131 char#23 \nu --- */
      {  23,76376,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07\x09\x0a\x12\x22\x44\x46\x83\x01" }  },
      /* --- pixel bitmap for cmmi131 char#24 \xi --- */
      {  24,77488,                      /* character number, location */
         13, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  8,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x10\xf8\x04\x02\x02\x7c\x06\x02\x01\x01\x01\x03"
            "\x0c\x30\x20\x1c" }  },
      /* --- pixel bitmap for cmmi131 char#25 \pi --- */
      {  25,78392,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x4b\x91\x04\x12\x48\x10\x41\x04\x11" }  },
      /* --- pixel bitmap for cmmi131 char#26 \rho --- */
      {  26,79184,                      /* character number, location */
          8, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          {  8,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x70\x88\x88\x84\x84\x44\x46\x3a\x02\x02\x01\x01" }  },
      /* --- pixel bitmap for cmmi131 char#27 \sigma --- */
      {  27,80048,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x89\x08\x09\x12\x24\x44\x04\x07" }  },
      /* --- pixel bitmap for cmmi131 char#28 \tau --- */
      {  28,80801,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x45\x44\x80\x00\x01\x02\x02\x04" }  },
      /* --- pixel bitmap for cmmi131 char#29 \upsilon --- */
      {  29,81696,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x15\x26\x24\x48\x90\x10\x11\x1c" }  },
      /* --- pixel bitmap for cmmi131 char#30 \phi --- */
      {  30,82554,                      /* character number, location */
         13, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  9,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x80\x00\x01\x01\x02\x0f\x29\x89\x11\x23\x46\x52"
            "\xc2\x03\x01\x02\x02\x04\x00" }  },
      /* --- pixel bitmap for cmmi131 char#31 \chi --- */
      {  31,83563,                      /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 10,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x1a\x84\x10\x22\x50\xc0\x00\x03\x0a\x44\x08\x21"
            "\x58\x60" }  },
      /* --- pixel bitmap for cmmi131 char#32 \psi --- */
      {  32,84624,                      /* character number, location */
         13, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          { 11,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x01\x04\x20\x00\x01\x08\x23\x2a\x31\x89\x44\x24"
            "\x21\x89\x48\x82\x0f\x08\x40\x00\x02\x10\x00" }  },
      /* --- pixel bitmap for cmmi131 char#33 \omega --- */
      {  33,85683,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x0a\x38\x61\x84\x11\x66\x94\x99\x39" }  },
      /* --- pixel bitmap for cmmi131 char#34 \varepsilon --- */
      {  34,86624,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\x10\x78\x43\x10\x7a" }  },
      /* --- pixel bitmap for cmmi131 char#35 \vartheta --- */
      {  35,87617,                      /* character number, location */
         13, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x40\x82\x04\x09\xd2\xa8\xe2\x42\x84\x08\x11\x21"
            "\x81\x01" }  },
      /* --- pixel bitmap for cmmi131 char#36 \varpi --- */
      {  36,88820,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x7f\x05\x48\x02\x84\x10\x42\x08\x21\x46\x90\x22"
            "\x30\x0e" }  },
      /* --- pixel bitmap for cmmi131 char#37 \varrho --- */
      {  37,89677,                      /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x22\x51\x28\x14\x8d\x3a\x81\x40\xc0\x03" }  },
      /* --- pixel bitmap for cmmi131 char#38 \varsigma --- */
      {  38,90488,                      /* character number, location */
          8, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb8\x21\x04\x81\xc0\x40\x10\x07" }  },
      /* --- pixel bitmap for cmmi131 char#39 \varphi --- */
      {  39,91413,                      /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 10,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x84\x89\x19\x62\x84\x11\x46\xa4\x0c\x0f\x08\x20\x40"
            "\x00\x01" }  },
      /* --- pixel bitmap for cmmi131 char#40 \leftharpoonup --- */
      {  40,106945,                     /* character number, location */
          9, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          { 16,    5, 3,14, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x31\xc0\x21\xe2\xde\x02" }  },
      /* --- pixel bitmap for cmmi131 char#41 \leftharpoondown --- */
      {  41,107969,                     /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,    5, 3,17, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x02\x12\xe0\x11\xd0\xf1\x31\xc1" }  },
      /* --- pixel bitmap for cmmi131 char#42 \rightharpoonup --- */
      {  42,108991,                     /* character number, location */
          9, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          { 16,    5, 3,16, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\xc1\x30\xd1\xe0\x12\x1e\x02" }  },
      /* --- pixel bitmap for cmmi131 char#43 \rightharpoondown --- */
      {  43,110016,                     /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,    5, 3,15, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x02\xd2\xe1\x20\xf1\xc1\x32" }  },
      /* --- pixel bitmap for cmmi131 char#44 ` --- */
      {  44,110433,                     /* character number, location */
          9, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          {  3,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4e\x62" }  },
      /* --- pixel bitmap for cmmi131 char#45 ' --- */
      {  45,110851,                     /* character number, location */
          9, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          {  3,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x23\x39" }  },
      /* --- pixel bitmap for cmmi131 char#46 \triangleright --- */
      {  46,111386,                     /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x81\x43\x22\x16\x8c\x25\x0e\x01" }  },
      /* --- pixel bitmap for cmmi131 char#47 \triangleleft --- */
      {  47,111938,                     /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x38\xd2\x18\x34\x22\xe1\x40" }  },
      /* --- pixel bitmap for cmmi131 char#48 \0 --- */
      {  48,97636,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x51\x30\x18\x0c\x8a\x7c" }  },
      /* --- pixel bitmap for cmmi131 char#49 \1 --- */
      {  49,98391,                      /* character number, location */
          8, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe4\x10\x42\x08\xf9" }  },
      /* --- pixel bitmap for cmmi131 char#50 \2 --- */
      {  50,99353,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbe\x70\x10\x0c\xc3\xfa\xff" }  },
#if 0
      /* --- *unmodified* pixel bitmap for cmmi131 char#51 \3 --- */
      {  51,100370,                     /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9e\x70\x18\x0c\xe2\xc0\xc0\xe0\x71\xcc\x03" }  },
#else
      /* --- *modified* pixel bitmap for cmmi131 char#51 \3 --- */
      {  51,100370,                     /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbe\x70\x18\x0c\xe2\xc0\xc0\xe0\x71\xcc\x03" }  },
#endif
      /* --- pixel bitmap for cmmi131 char#52 \4 --- */
      {  52,101285,                     /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  8,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x30\x28\x2c\x24\x22\x23\xff\x20\x20\x20\xf8" }  },
      /* --- pixel bitmap for cmmi131 char#53 \5 --- */
      {  53,102314,                     /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x22\x8f\x43\x20\xf0\x88\xc0\xe0\x70\xcc\x03" }  },
      /* --- pixel bitmap for cmmi131 char#54 \6 --- */
      {  54,103197,                     /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\xa2\x20\xd0\x19\x05\x83\x41\xa1\x88\x03" }  },
      /* --- pixel bitmap for cmmi131 char#55 \7 --- */
      {  55,104090,                     /* character number, location */
          9, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  8,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\xfe\x82\x41\x20\x10\x10\x10\x08\x08\x08\x08\x08" }  },
#if 0
      /* --- *unmodified* pixel bitmap for cmmi131 char#56 \8 --- */
      {  56,105005,                     /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x70\x70\xe8\xe2\xe8\xc2\xc1\xa0\x88\x03" }  },
      /* --- *unmodified* pixel bitmap for cmmi131 char#57 \9 --- */
      {  57,105896,                     /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x51\x28\x18\x14\x73\x81\x40\x50\xc4\x01" }  },
#else
      /* --- pixel bitmap for cmmi131 char#56 \8 --- */
      {  56,105005,                     /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x71\x70\xe8\xe2\xe8\xc2\xc1\xa0\x88\x03" }  },
      /* --- pixel bitmap for cmmi131 char#57 \9 --- */
      {  57,105896,                     /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x51\x30\x18\x14\x73\x81\x40\x50\xc4\x01" }  },
#endif
      /* --- pixel bitmap for cmmi131 char#58 . --- */
      {  58,112419,                     /* character number, location */
          2, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  2,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmmi131 char#59 , --- */
      {  59,112978,                     /* character number, location */
          2, 2,   -4, 2,      /* topleft row,col, and botleft row,col */
          {  2,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xaf\x06" }  },
      /* --- pixel bitmap for cmmi131 char#60 < --- */
      {  60,113636,                     /* character number, location */
         10, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 10,   11, 3,22, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x91\x72\x62\x62\x62\x71\xa2\xa2\xa2\xa2\xa1" }  },
      /* --- pixel bitmap for cmmi131 char#61 / --- */
      {  61,114160,                     /* character number, location */
         14, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          {  7,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x20\x08\x04\x82\x40\x20\x08\x04\x82\x40\x20\x08"
            "\x04\x82\x40\x00" }  },
      /* --- pixel bitmap for cmmi131 char#62 > --- */
      {  62,114847,                     /* character number, location */
         10, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 12,   11, 3,23, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\xc2\xc2\xc2\xc2\xc2\x82\x82\x82\x82\x82\xa2" }  },
      /* --- pixel bitmap for cmmi131 char#63 \star --- */
      {  63,115546,                     /* character number, location */
          5, 0,    3, 0,      /* topleft row,col, and botleft row,col */
          {  7,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x18" }  },
      /* --- pixel bitmap for cmmi131 char#64 \partial --- */
      {  64,92387,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x08\x01\x02\x08\x10\x2f\x61\x41\x81\x02\x05\x09"
            "\xe1\x01" }  },
      /* --- pixel bitmap for cmmi131 char#65 A --- */
      {  65, 1026,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x03\x60\x00\x0e\xa0\x01\x34\x40\x06\xcc\x80\x18"
            "\xf8\x03\xc1\x10\x98\xc7\x0f" }  },
      /* --- pixel bitmap for cmmi131 char#66 B --- */
      {  66, 2366,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x0f\x0c\xc3\x60\x18\x0c\xc3\xe1\x0f\x06\xc3\xc0"
            "\x18\x18\x83\x31\xb8\xff\x01" }  },
      /* --- pixel bitmap for cmmi131 char#67 C --- */
      {  67, 3319,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x13\x86\x23\x20\x06\x64\x00\x0c\xc0\x00\x18\x00"
            "\x02\xc4\x40\x10\x04\x7c\x00" }  },
      /* --- pixel bitmap for cmmi131 char#68 D --- */
      {  68, 4439,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   12, 3,41, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x39\x82\x52\x52\x71\x10\xf2\x42\x72\xf1\x32\x72\x10"
            "\x32\x71\x52\x62\x42\x52\x4a\x55" }  },
      /* --- pixel bitmap for cmmi131 char#69 E --- */
      {  69, 5872,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x3f\x18\x0c\x03\xc1\x48\x30\x12\xfc\x80\x11\x60"
            "\x44\x18\x10\x06\xc2\xc0\xfc\x1f" }  },
      /* --- pixel bitmap for cmmi131 char#70 F --- */
      {  70, 7115,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x1f\x0c\xc3\x40\x18\x09\x23\xe1\x07\x46\xc0\x08"
            "\x18\x00\x03\x30\x80\x3f\x00" }  },
      /* --- pixel bitmap for cmmi131 char#71 G --- */
      {  71, 8286,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x13\x86\x23\x20\x06\x64\x00\x0c\xc0\xe0\x1f\x30"
            "\x02\xc6\xc0\x10\x0c\x7c\x01" }  },
      /* --- pixel bitmap for cmmi131 char#72 H --- */
      {  72, 9467,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 17,   12, 3,39, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x36\x26\x52\x62\x20\xf2\x42\x62\x30\x4a\x30\xf3\x32"
            "\x62\x40\x22\x62\x56\x26\x32" }  },
      /* --- pixel bitmap for cmmi131 char#73 I --- */
      {  73,10178,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   12, 3,23, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x36\x52\x20\xf3\x42\x30\xf3\x32\x40\x22\x56\x33" }  },
      /* --- pixel bitmap for cmmi131 char#74 J --- */
      {  74,11022,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x03\x06\x0c\x30\xc0\x00\x03\x06\x18\x60\x98\x31"
            "\x83\x07" }  },
      /* --- pixel bitmap for cmmi131 char#75 K --- */
      {  75,12213,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 16,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\xf9\x60\x10\x30\x0c\x30\x06\x30\x01\xf0\x01\x78"
            "\x03\x18\x03\x18\x07\x18\x06\x0c\x06\x3f\x1f" }  },
      /* --- pixel bitmap for cmmi131 char#76 L --- */
      {  76,13170,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x01\x03\x0c\x60\x00\x03\x18\x60\x00\x83\x18\xc4"
            "\x30\xc3\xfe\x07" }  },
#if 0
      /* --- *unmodified* pixel bitmap for cmmi131 char#77 M --- */
      {  77,14488,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 20,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x80\x0f\x0e\x30\xd0\xc0\x01\x0d\x1a\xd0\x80\x01"
            "\x0d\x19\x88\xc9\x80\x18\x0c\x88\xc5\x80\x38\x0c\x84"
            "\x61\xf0\x99\x1f" }  },
#else
      /* --- *modified* pixel bitmap for cmmi131 char#77 M --- */
      {  77,14488,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 20,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x80\x0f\x0e\x34\xd0\xa0\x01\x0d\x1a\xd0\x90\x01"
            "\x0d\x19\x88\xc9\x80\x98\x0c\x88\xc5\x80\x38\x0c\x84"
            "\x61\xf0\x99\x1f" }  },
#endif
      /* --- pixel bitmap for cmmi131 char#78 N --- */
      {  78,15620,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 17,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\xf0\xc1\x81\x40\x87\x80\x0c\x01\x39\x02\x62\x04"
            "\xc2\x05\x04\x0b\x08\x1e\x10\x38\x10\x30\xf8\x40\x00" }  },
      /* --- pixel bitmap for cmmi131 char#79 O --- */
      {  79,16507,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x03\x86\x21\x30\x06\x6c\x80\x0d\xf0\x00\x1b\x60"
            "\x03\xc6\xc0\x38\x06\x7c\x00" }  },
      /* --- pixel bitmap for cmmi131 char#80 P --- */
      {  80,17628,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   12, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x39\x62\x42\xf2\x42\x52\x42\x42\x47\x30\xf2\x32\x80"
            "\x22\x96\x72" }  },
      /* --- pixel bitmap for cmmi131 char#81 Q --- */
      {  81,18651,                      /* character number, location */
         12, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 13,   16, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x03\x86\x21\x30\x06\x6c\x80\x0d\xf0\x00\x1b\x60"
            "\x03\xc6\xce\x38\x06\x7c\x00\x00\x00\x09\xe0\x00\x0c" }  },
      /* --- pixel bitmap for cmmi131 char#82 R --- */
      {  82,19980,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   12, 3,36, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x39\x62\x42\xf1\x42\x52\x42\x42\x56\x30\xf3\x32\x42"
            "\x20\x22\x43\x17\x34" }  },
      /* --- pixel bitmap for cmmi131 char#83 S --- */
      {  83,21065,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\xc5\x30\x82\x18\xc0\x01\x7c\xc0\x07\x30\x80\x11"
            "\xc4\x30\x7a\x00" }  },
      /* --- pixel bitmap for cmmi131 char#84 T --- */
      {  84,22121,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x2f\xcc\x63\x14\x46\x61\x04\x06\x30\x00\x03\x30"
            "\x00\x03\x18\xe0\x0f" }  },
      /* --- pixel bitmap for cmmi131 char#85 U --- */
      {  85,23111,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   12, 3,33, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x35\x22\x71\x20\xf3\x12\x71\x3f\x22\x71\x42\x61"
            "\x61\x51\x85\x72" }  },
      /* --- pixel bitmap for cmmi131 char#86 V --- */
      {  86,24049,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\x3e\x03\xc1\x40\x30\x08\x0c\x01\x46\x80\x09\x60"
            "\x01\x58\x00\x0e\x80\x01\x60\x00" }  },
      /* --- pixel bitmap for cmmi131 char#87 W --- */
      {  87,25439,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9f\xcf\x67\x18\x04\xc3\x21\x18\x8e\xc0\x68\x04\x26"
            "\x13\x30\x99\x80\xc5\x02\x2c\x0e\xe0\x70\x00\x86\x01"
            "\x10\x0c\x00" }  },
      /* --- pixel bitmap for cmmi131 char#88 X --- */
      {  88,26556,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 16,   12, 3,45, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x36\x25\x62\x41\x92\x31\xa3\x11\x50\xf2\x73\x60\x61"
            "\x12\xb1\x32\x91\x42\x82\x43\x46\x26\x20" }  },
      /* --- pixel bitmap for cmmi131 char#89 Y --- */
      {  89,27648,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   12, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x35\x22\x61\x53\x41\x72\x31\x82\x22\x94\xa3\x70"
            "\xf2\x42\x80\x32\xa6\x72" }  },
      /* --- pixel bitmap for cmmi131 char#90 Z --- */
      {  90,28727,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x8f\x61\x0c\x43\x18\xc4\x00\x0e\x70\x00\x23\x18"
            "\xc2\x30\x86\xf1\x1f" }  },
      /* --- pixel bitmap for cmmi131 char#91 \flat --- */
      {  91,116207,                     /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x21\x84\x10\xc2\x8e\x31\xa6\x54\x06" }  },
      /* --- pixel bitmap for cmmi131 char#92 \natural --- */
      {  92,116956,                     /* character number, location */
         13, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  5,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x21\x84\x90\x6f\x8c\x31\xc6\x98\x2f\x84\x10" }  },
      /* --- pixel bitmap for cmmi131 char#93 \sharp --- */
      {  93,117809,                     /* character number, location */
         13, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  5,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4a\x29\xa5\x9f\x52\x4a\x29\xa5\x9f\x52\x0a" }  },
      /* --- pixel bitmap for cmmi131 char#94 \smile --- */
      {  94,118723,                     /* character number, location */
          7, 1,    3, 1,      /* topleft row,col, and botleft row,col */
          { 16,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\x80\x02\x40\x0c\x30\xf0\x0f" }  },
      /* --- pixel bitmap for cmmi131 char#95 \frown --- */
      {  95,119587,                     /* character number, location */
          7, 1,    3, 1,      /* topleft row,col, and botleft row,col */
          { 16,    4, 3,14, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x48\x62\x82\x31\xc1\x11\xe1" }  },
      /* --- pixel bitmap for cmmi131 char#96 \ell --- */
      {  96,93167,                      /* character number, location */
         13,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  9,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x40\x42\x84\x84\x08\x09\x0a\x0a\x0c\x08\x18\x40"
            "\x04\x07" }  },
      /* --- pixel bitmap for cmmi131 char#97 a --- */
      {  97,29655,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\x62\x22\x21\x21\xb1\x51\x6e" }  },
      /* --- pixel bitmap for cmmi131 char#98 b --- */
      {  98,30481,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x41\x08\x82\x27\x8e\x61\x18\x45\x0e" }  },
      /* --- pixel bitmap for cmmi131 char#99 c --- */
      {  99,31276,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\xa2\x20\x10\x08\x84\x3c" }  },
      /* --- pixel bitmap for cmmi131 char#100 d --- */
      { 100,32206,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x80\x80\x40\x40\x5c\x62\x22\x21\x21\xb1\x51\x6e" }  },
      /* --- pixel bitmap for cmmi131 char#101 e --- */
      { 101,33009,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\xa3\xe8\x13\x08\x84\x3c" }  },
#if 0
      /* --- *unmodified* pixel bitmap for cmmi131 char#102 f --- */
      { 102,34171,                      /* character number, location */
         13, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  9,   17, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x62\x71\x11\xf2\x51\x30\x43\x71\x30\xf4\x41\x40\xf2"
            "\x31\x51\x21\x62\x62" }  },
#else
      /* --- *modified* pixel bitmap for cmmi131 char#102 f --- */
      { 102,34171,                      /* character number, location */
         13, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 10,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x01\x09\x04\x08\x20\xe0\x03\x02\x08\x10\x40\x00"
            "\x01\x04\x08\x20\x80\x40\x02\x06\x00" }  },
#endif
      /* --- pixel bitmap for cmmi131 char#103 g --- */
      { 103,35130,                      /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  8,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb8\xc4\x44\x42\x42\x62\x22\x3c\x20\x20\x10\x0f" }  },
      /* --- pixel bitmap for cmmi131 char#104 h --- */
      { 104,36043,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x10\x20\x20\x40\x80\x0e\x13\x23\x42\x84\x88\x0c"
            "\x15\x0c" }  },
      /* --- pixel bitmap for cmmi131 char#105 i --- */
      { 105,36873,                      /* character number, location */
         13, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x00\x00\x8c\x4a\x84\x48\xc5\x00" }  },
      /* --- pixel bitmap for cmmi131 char#106 j --- */
      { 106,37784,                      /* character number, location */
         13, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          {  8,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x00\x00\x00\x00\x30\x48\x24\x20\x20\x20\x10\x10"
            "\x10\x10\x08\x07" }  },
      /* --- pixel bitmap for cmmi131 char#107 k --- */
      { 107,38785,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x10\x20\x20\x40\x80\x1c\x45\x05\x0e\x24\x88\x8a"
            "\x12\x06" }  },
      /* --- pixel bitmap for cmmi131 char#108 l --- */
      { 108,39475,                      /* character number, location */
         13, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x48\x44\x24\x22\x5a\x06" }  },
      /* --- pixel bitmap for cmmi131 char#109 m --- */
      { 109,40692,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe6\x1c\x4d\x49\x63\x84\x10\x42\x08\x21\x44\x0a\xa1"
            "\x84\x60" }  },
      /* --- pixel bitmap for cmmi131 char#110 n --- */
      { 110,41713,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe6\x68\xd2\x08\x21\x84\x10\x29\x94\x60" }  },
      /* --- pixel bitmap for cmmi131 char#111 o --- */
      { 111,42427,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\xa2\x30\x18\x0c\x45\x1c" }  },
      /* --- pixel bitmap for cmmi131 char#112 p --- */
      { 112,43381,                      /* character number, location */
          8,-1,   -4,-1,      /* topleft row,col, and botleft row,col */
          {  9,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xec\x28\x6a\x44\x88\x10\x11\x23\x3a\x04\x08\x08\x78"
            "\x00" }  },
      /* --- pixel bitmap for cmmi131 char#113 q --- */
      { 113,44272,                      /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\xb1\x28\x14\x8a\x45\x3c\x10\x08\x82\x07" }  },
      /* --- pixel bitmap for cmmi131 char#114 r --- */
      { 114,45125,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x76\x8a\x0d\x04\x04\x04\x02\x02" }  },
      /* --- pixel bitmap for cmmi131 char#115 s --- */
      { 115,46055,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\xa2\x80\x03\x02\x86\x3c" }  },
      /* --- pixel bitmap for cmmi131 char#116 t --- */
      { 116,46791,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x82\xfc\x08\x41\x10\xa4\xc4\x00" }  },
      /* --- pixel bitmap for cmmi131 char#117 u --- */
      { 117,47799,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x29\x94\x08\x21\x84\x10\x4b\x14\x6e" }  },
      /* --- pixel bitmap for cmmi131 char#118 v --- */
      { 118,48680,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\x8a\x89\x84\x84\x44\x44\x38" }  },
      /* --- pixel bitmap for cmmi131 char#119 w --- */
      { 119,49850,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\xa8\x88\x49\x48\x84\x44\x48\x44\x64\x84\x39" }  },
      /* --- pixel bitmap for cmmi131 char#120 x --- */
      { 120,51068,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xd8\xd1\x28\x01\x04\x10\x40\x94\x89\x1d" }  },
      /* --- pixel bitmap for cmmi131 char#121 y --- */
      { 121,52132,                      /* character number, location */
          8, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          {  9,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x15\x26\x22\x44\x88\x18\x11\x3c\x40\x40\x44\x70"
            "\x00" }  },
      /* --- pixel bitmap for cmmi131 char#122 z --- */
      { 122,53024,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x64\x20\x10\x08\x44\x26\x19" }  },
      /* --- pixel bitmap for cmmi131 char#123 \imath --- */
      { 123,93907,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x46\x25\x42\xa4\x62" }  },
      /* --- pixel bitmap for cmmi131 char#124 \jmath --- */
      { 124,94676,                      /* character number, location */
          8,-1,   -4,-1,      /* topleft row,col, and botleft row,col */
          {  8,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\x90\x48\x40\x40\x40\x20\x20\x20\x20\x10\x0f" }  },
      /* --- pixel bitmap for cmmi131 char#125 \wp --- */
      { 125,95815,                      /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 10,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x90\x27\xa1\x82\x06\x0a\x24\x51\x39\x09\x24\x50"
            "\x80\x00" }  },
      /* --- pixel bitmap for cmmi131 char#126 \vec --- */
      { 126,96431,                      /* character number, location */
         13, 4,   10, 4,      /* topleft row,col, and botleft row,col */
          {  7,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa0\x3f\x08" }  },
      /* --- pixel bitmap for cmmi131 char#127 (noname) --- */
      { 127,96967,                      /* character number, location */
         12, 5,   10, 5,      /* topleft row,col, and botleft row,col */
          {  8,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7e\x81" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=4 for .160gf ---
 * mf '\mode=preview; mag=magstep(-15.29639112828755784636); input cmmi10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmmi160 --- */
static	chardef  cmmi160[] =
   {
      /* --- pixel bitmap for cmmi160 char#0 \Gamma --- */
      {   0,54633,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\xf1\x52\x62\xf1\x52\x71\xf3\x42\x90\xf3\x32\xa0"
            "\x22\xb7\x81" }  },
      /* --- pixel bitmap for cmmi160 char#1 \Delta --- */
      {   1,55538,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x08\x00\x1c\x00\x1a\x00\x1a\x00\x19\x80\x38\x40"
            "\x30\x40\x30\x20\x30\x10\x70\x08\x60\x08\x60\x04\x60"
            "\xfe\xff\xff\xff" }  },
      /* --- pixel bitmap for cmmi160 char#2 \Theta --- */
      {   2,56711,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x0f\x38\x0c\x06\x8c\x01\x6c\x00\xb6\x20\xcf\x9f"
            "\xe7\xcf\x13\xe4\x01\xd8\x00\x6c\x00\x23\xc0\x70\x18"
            "\xe0\x03\x00" }  },
      /* --- pixel bitmap for cmmi160 char#3 \Lambda --- */
      {   3,57667,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x06\x80\x01\x70\x00\x1c\x80\x06\xa0\x01\x64\x80"
            "\x19\x20\x06\x84\x01\x61\x20\x38\x08\x0e\x01\xf3\xf9"
            "\x03" }  },
      /* --- pixel bitmap for cmmi160 char#4 \Xi --- */
      {   4,59092,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   15, 3,51, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4d\x3d\x10\xf1\x31\xb1\x10\xe0\x71\x71\x40\xf1\x49"
            "\x40\x41\x71\x40\xf1\xe0\x30\xf1\x11\xb1\x3f\x1d\x41" }  },
      /* --- pixel bitmap for cmmi160 char#5 \Pi --- */
      {   5,60275,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   15, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\x02\xf3\x52\x72\x30\xf3\x42\x72\x40\xf3\x32\x72"
            "\x50\x22\x72\x67\x27\x30" }  },
      /* --- pixel bitmap for cmmi160 char#6 \Sigma --- */
      {   6,61428,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   15, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4d\x42\x83\x43\x82\x52\x82\x53\x81\x62\xe0\x13\xe0"
            "\x12\xe0\x11\xe0\x11\xe0\x11\x81\x61\x82\x51\x91\x51"
            "\x83\x4c\x47" }  },
      /* --- pixel bitmap for cmmi160 char#7 \Upsilon --- */
      {   7,62486,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,39, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x24\x53\x26\x27\x51\x21\x41\xf1\x61\x11\x60\xf3\x62"
            "\x70\xf3\x52\x80\x42\xa8\x61" }  },
      /* --- pixel bitmap for cmmi160 char#8 \Phi --- */
      {   8,63508,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x0f\x60\x00\x18\x80\x1f\x9c\x99\x31\x3c\x0c\x0f"
            "\xc3\xc3\xd8\x18\x66\x66\xe0\x07\x60\x00\x0c\xe0\x1f"
            "\x00" }  },
      /* --- pixel bitmap for cmmi160 char#9 \Psi --- */
      {   9,64591,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x0f\xc0\x00\x60\xe0\x30\x6e\x98\x31\x66\x18\x33"
            "\x8c\x19\xc6\x06\x33\x03\xdb\x00\x1f\x00\x06\x80\x01"
            "\xf8\x07\x00" }  },
      /* --- pixel bitmap for cmmi160 char#10 \Omega --- */
      {  10,65780,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 16,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x1f\x70\x30\x18\x60\x0c\xc0\x0c\xc0\x06\x60\x06"
            "\x60\x06\x30\x04\x30\x0c\x18\x0c\x0c\x09\x24\x09\x12"
            "\x0f\x1e\x0f\x0f" }  },
      /* --- pixel bitmap for cmmi160 char#11 \alpha --- */
      {  11,66818,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x00\x21\x12\x44\x01\x15\xa0\x02\x4c\x80\x08\x18"
            "\xc2\x8a\x87\x01" }  },
      /* --- pixel bitmap for cmmi160 char#12 \beta --- */
      {  12,67867,                      /* character number, location */
         15, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          { 13,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x07\x08\x83\x40\x08\x08\xc1\xd0\x07\x02\x41\x40"
            "\x08\x88\x00\x11\x20\x02\x44\x40\x14\x86\x3c\x10\x00"
            "\x02\x20\x00\x04\x00" }  },
      /* --- pixel bitmap for cmmi160 char#13 \gamma --- */
      {  13,68808,                      /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 11,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x34\x63\x10\x03\x05\x28\xc0\x00\x06\x30\x80\x00"
            "\x04\x20\x00\x01\x04\x20\x00" }  },
      /* --- pixel bitmap for cmmi160 char#14 \delta --- */
      {  14,69761,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x11\x40\x80\x00\x02\x0e\x12\x42\x82\x02\x05\x0a"
            "\x14\x44\x0c\x07" }  },
      /* --- pixel bitmap for cmmi160 char#15 \epsilon --- */
      {  15,70619,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x0c\x02\x02\x7f\x01\x01\x02\x42\x3c" }  },
      /* --- pixel bitmap for cmmi160 char#16 \zeta --- */
      {  16,71551,                      /* character number, location */
         15, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 10,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x00\x01\x3c\x0c\x08\x10\x40\x80\x00\x02\x04\x10"
            "\x40\x00\x01\x08\xc0\x01\x18\x40\x00\x01\x07" }  },
      /* --- pixel bitmap for cmmi160 char#17 \eta --- */
      {  17,72436,                      /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 10,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc6\xe5\x98\x61\x82\x0c\x11\x44\x10\x41\x82\x08\x02"
            "\x08\x20\x40\x00\x01" }  },
      /* --- pixel bitmap for cmmi160 char#18 \theta --- */
      {  18,73196,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x20\x22\x24\x48\x90\xa0\x40\xff\x02\x05\x05\x0a"
            "\x22\x44\x04\x07" }  },
      /* --- pixel bitmap for cmmi160 char#19 \iota --- */
      {  19,73837,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x41\x10\x82\x20\x86\x91\x03" }  },
      /* --- pixel bitmap for cmmi160 char#20 \kappa --- */
      {  20,74743,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x23\x04\x19\x28\xe0\x03\x21\x08\x52\x90\x81\x0a"
            "\x1c" }  },
      /* --- pixel bitmap for cmmi160 char#21 \lambda --- */
      {  21,75574,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x00\x01\x08\x80\x00\x04\x20\x00\x02\x10\xc0\x00"
            "\x09\x44\x10\x42\x20\x01\x05\x10" }  },
      /* --- pixel bitmap for cmmi160 char#22 \mu --- */
      {  22,76554,                      /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 12,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x82\x20\x08\x82\x20\x04\x41\x10\x04\x49\x98\x46"
            "\xa5\x33\x02\x20\x00\x01\x10\x00" }  },
      /* --- pixel bitmap for cmmi160 char#23 \nu --- */
      {  23,77349,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x12\x48\x20\x41\x82\x08\x22\x84\x0c\x0d\x0c\x00" }  },
      /* --- pixel bitmap for cmmi160 char#24 \xi --- */
      {  24,78495,                      /* character number, location */
         15, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  9,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x80\xc0\x47\x40\x40\x00\x01\x7c\x0c\x04\x04\x08"
            "\x10\x20\x80\x01\x1c\x40\x80\xe0\x01" }  },
      /* --- pixel bitmap for cmmi160 char#25 \pi --- */
      {  25,79429,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x97\x44\x24\x90\x80\x04\x24\x10\x81\x08\x44\x10"
            "\x04" }  },
      /* --- pixel bitmap for cmmi160 char#26 \rho --- */
      {  26,80243,                      /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 10,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\xc1\x88\x20\x82\x04\x12\x48\x20\x41\x8a\xc8\x21"
            "\x80\x00\x01\x04\x00" }  },
      /* --- pixel bitmap for cmmi160 char#27 \sigma --- */
      {  27,81143,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x8f\x10\x04\x21\x10\x01\x11\x10\x01\x11\x08\x42"
            "\xc0\x03" }  },
      /* --- pixel bitmap for cmmi160 char#28 \tau --- */
      {  28,81930,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x4b\x10\x01\x04\x08\x20\x80\x00\x02\x04\x10\x00" }  },
      /* --- pixel bitmap for cmmi160 char#29 \upsilon --- */
      {  29,82829,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x26\x98\x60\x82\x04\x11\x44\x10\x21\x44\xe0\x00" }  },
      /* --- pixel bitmap for cmmi160 char#30 \phi --- */
      {  30,83697,                      /* character number, location */
         15, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 12,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x01\x10\x00\x01\x08\x80\x00\x3e\x98\x44\x84\x42"
            "\x18\x84\x41\x18\x82\x22\x64\x32\xf8\x00\x01\x10\x00"
            "\x01\x10\x00" }  },
      /* --- pixel bitmap for cmmi160 char#31 \chi --- */
      {  31,84718,                      /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 13,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x50\x01\x41\x10\x08\x02\x22\x40\x02\x30\x00\x06"
            "\xa0\x00\x22\x20\x04\x02\x21\xa0\x02\x18" }  },
      /* --- pixel bitmap for cmmi160 char#32 \psi --- */
      {  32,85791,                      /* character number, location */
         15, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 13,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x02\x40\x00\x04\x80\x00\x10\x1c\x62\x22\x4c\x84"
            "\x89\x90\x10\x11\x21\x22\x42\x44\x90\x06\x3c\x00\x01"
            "\x20\x00\x04\x40\x00" }  },
      /* --- pixel bitmap for cmmi160 char#33 \omega --- */
      {  33,86890,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x90\x00\x0a\x40\x41\x18\x84\x82\x50\x10\x0a\x23"
            "\xd3\xc6\x71\x00" }  },
      /* --- pixel bitmap for cmmi160 char#34 \varepsilon --- */
      {  34,87869,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x08\x0a\x10\xc0\x43\x40\x80\x00\x41\x7c\x00" }  },
      /* --- pixel bitmap for cmmi160 char#35 \vartheta --- */
      {  35,88868,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x01\x11\x84\x20\x04\x21\x13\x25\x2f\xc1\x09\x22"
            "\x08\x41\x08\x41\x08\x22\xe0\x00" }  },
      /* --- pixel bitmap for cmmi160 char#36 \varpi --- */
      {  36,90081,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xff\x15\x80\x24\x00\x21\x00\x24\x10\x44\x20\x88"
            "\x60\x10\xc1\x10\x62\x11\x38\x1c\x00" }  },
      /* --- pixel bitmap for cmmi160 char#37 \varrho --- */
      {  37,90962,                      /* character number, location */
         10, 2,   -4, 2,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x30\x12\x24\x28\x50\xa0\x40\x41\x45\x72\x04\x08"
            "\x10\xc0\x0f" }  },
      /* --- pixel bitmap for cmmi160 char#38 \varsigma --- */
      {  38,91783,                      /* character number, location */
         10, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  9,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x19\x08\x10\x10\x40\x00\x01\x0c\x20\x80\x00\x81"
            "\x01" }  },
      /* --- pixel bitmap for cmmi160 char#39 \varphi --- */
      {  39,92712,                      /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 13,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x87\x10\x09\x21\x21\x18\x82\x42\x50\x08\x12\x21"
            "\x14\x03\x1f\x40\x00\x08\x80\x00\x10\x00" }  },
      /* --- pixel bitmap for cmmi160 char#40 \leftharpoonup --- */
      {  40,108370,                     /* character number, location */
         11, 1,    5, 1,      /* topleft row,col, and botleft row,col */
          { 20,    6, 3,24, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x41\xe0\x10\x31\xe0\x42\xe0\x32\xe0\x3e\x06" }  },
      /* --- pixel bitmap for cmmi160 char#41 \leftharpoondown --- */
      {  41,109396,                     /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 20,    6, 3,25, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x06\x12\xe0\x52\xe0\x51\xe0\x20\xf1\x41\xe0\x14" }  },
      /* --- pixel bitmap for cmmi160 char#42 \rightharpoonup --- */
      {  42,110420,                     /* character number, location */
         11, 1,    5, 1,      /* topleft row,col, and botleft row,col */
          { 20,    6, 3,24, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\xe0\x11\x40\xe0\x21\xe0\x52\xe0\x52\x1e\x06" }  },
      /* --- pixel bitmap for cmmi160 char#43 \rightharpoondown --- */
      {  43,111447,                     /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 20,    6, 3,25, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x06\xe0\x32\xe0\x32\xe0\x41\x30\xf1\xe0\x11\x44" }  },
      /* --- pixel bitmap for cmmi160 char#44 ` --- */
      {  44,111866,                     /* character number, location */
         12, 1,    5, 1,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2c\x11\x21\x0c" }  },
      /* --- pixel bitmap for cmmi160 char#45 ' --- */
      {  45,112288,                     /* character number, location */
         12, 1,    5, 1,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x43\x88\x48\x03" }  },
      /* --- pixel bitmap for cmmi160 char#46 \triangleright --- */
      {  46,112827,                     /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\x38\x40\x06\xc2\x10\x98\x00\x07\x2c\x18\x31\x28"
            "\x40\x00\x00" }  },
      /* --- pixel bitmap for cmmi160 char#47 \triangleleft --- */
      {  47,113389,                     /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x04\x38\x30\x61\x48\xc0\x00\x1a\x10\x83\x60\x04"
            "\x2c\x80\x01" }  },
      /* --- pixel bitmap for cmmi160 char#48 \0 --- */
      {  48,98993,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   10, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x25\x31\x51\x1f\x51\x71\x11\x51\x35\x21" }  },
      /* --- pixel bitmap for cmmi160 char#49 \1 --- */
      {  49,99756,                      /* character number, location */
         10, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  7,   10, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x31\x34\x30\xf6\x31\x37" }  },
      /* --- pixel bitmap for cmmi160 char#50 \2 --- */
      {  50,100722,                     /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x04\x05\x04\x08\x18\x18\x0c\x8c\xfe\xfe\x01" }  },
      /* --- pixel bitmap for cmmi160 char#51 \3 --- */
      {  51,101743,                     /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x8c\x08\x03\x06\x0c\x08\x1e\x60\x80\x01\x0f\x1e"
            "\x2c\x8c\x0f" }  },
      /* --- pixel bitmap for cmmi160 char#52 \4 --- */
      {  52,102664,                     /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\xc0\x40\x81\x82\x84\x08\x11\x21\x43\xfe\x03\x01"
            "\x02\x04\x3e" }  },
      /* --- pixel bitmap for cmmi160 char#53 \5 --- */
      {  53,103701,                     /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x82\xfc\xe8\x10\x20\x40\x8f\x31\xc1\x80\x01\x07\x0e"
            "\x24\x8c\x07" }  },
      /* --- pixel bitmap for cmmi160 char#54 \6 --- */
      {  54,104596,                     /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x18\x0a\x10\x10\x20\xcf\xa1\x81\x01\x03\x06\x14"
            "\x44\x0c\x07" }  },
      /* --- pixel bitmap for cmmi160 char#55 \7 --- */
      {  55,105495,                     /* character number, location */
         11, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 10,   15, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x11\x99\x11\x72\x71\x81\x20\xf1\x61\x30\x51\x40\xf2"
            "\x41\x50\xf3\x31\x61" }  },
      /* --- pixel bitmap for cmmi160 char#56 \8 --- */
      {  56,106414,                     /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x88\x08\x12\x64\x88\x0f\x0e\x7a\xc2\x03\x06\x0c"
            "\x28\x88\x0f" }  },
      /* --- pixel bitmap for cmmi160 char#57 \9 --- */
      {  57,107313,                     /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x8c\x08\x0a\x18\x30\x60\x60\xe1\x3c\x01\x02\x02"
            "\x14\xc6\x03" }  },
      /* --- pixel bitmap for cmmi160 char#58 . --- */
      {  58,113880,                     /* character number, location */
          2, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  2,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmmi160 char#59 , --- */
      {  59,114439,                     /* character number, location */
          2, 2,   -4, 2,      /* topleft row,col, and botleft row,col */
          {  2,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xaf\x05" }  },
      /* --- pixel bitmap for cmmi160 char#60 < --- */
      {  60,115097,                     /* character number, location */
         12, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 13,   13, 3,26, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb2\x92\x92\x92\x92\x92\xa1\xd2\xd2\xd2\xd2\xd2\xd2" }  },
      /* --- pixel bitmap for cmmi160 char#61 / --- */
      {  61,115625,                     /* character number, location */
         17, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          {  9,   23, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x81\xf2\x71\x10\xf1\x61\x20\xf2\x51\x30\xf2\x41"
            "\x40\xf2\x31\x50\xf1\x21\x60\xf2\x11\x7f\x11\x81" }  },
      /* --- pixel bitmap for cmmi160 char#62 > --- */
      {  62,116320,                     /* character number, location */
         12, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 13,   13, 3,27, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\xd2\xd2\xd2\xd2\xd2\xd1\xa2\x92\x92\x92\x92\x92"
            "\xb0" }  },
      /* --- pixel bitmap for cmmi160 char#63 \star --- */
      {  63,117023,                     /* character number, location */
          7, 0,    1, 0,      /* topleft row,col, and botleft row,col */
          { 11,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\xc4\x0f\x18\x00\x00\x09\x84\x00" }  },
      /* --- pixel bitmap for cmmi160 char#64 \partial --- */
      {  64,93724,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x40\x18\x81\x00\x08\x40\x00\xc2\x93\xa1\x02\x0e"
            "\x50\x80\x02\x12\x10\x61\xf0\x00" }  },
      /* --- pixel bitmap for cmmi160 char#65 A --- */
      {  65, 1026,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x0c\x00\x06\x80\x03\xc0\x01\xd0\x00\x64\x00\x32"
            "\x80\x30\x40\x18\xf0\x0f\x04\x06\x02\x83\x80\x61\xc0"
            "\x7c\xf8\x01" }  },
      /* --- pixel bitmap for cmmi160 char#66 B --- */
      {  66, 2376,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   15, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3b\x72\x62\x10\xf2\x52\x72\x42\x72\x52\x53\x6a\x62"
            "\x63\x10\xf2\x32\x82\x10\x32\x72\x42\x72\x3b\x52" }  },
      /* --- pixel bitmap for cmmi160 char#67 C --- */
      {  67, 3341,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   15, 3,47, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x75\x31\x52\x51\x11\x42\x82\x32\xa1\x22\xb1\x22\xdf"
            "\x32\xef\x12\xa1\x30\x11\x91\x62\x52\x86\x7b" }  },
      /* --- pixel bitmap for cmmi160 char#68 D --- */
      {  68, 4473,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   15, 3,47, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3b\x82\x62\x72\x72\x10\xf1\x52\x82\xf3\x42\x92\xf1"
            "\x32\x92\x10\x32\x82\x52\x72\x52\x63\x4b\x6b" }  },
      /* --- pixel bitmap for cmmi160 char#69 E --- */
      {  69, 5918,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\xff\x60\xc0\x60\xc0\x60\x80\x60\x88\x30\x04\x30"
            "\x04\xf0\x07\x30\x06\x18\x22\x18\x22\x18\x10\x18\x10"
            "\x0c\x1c\xff\x0f" }  },
      /* --- pixel bitmap for cmmi160 char#70 F --- */
      {  70, 7173,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,53, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\xf1\x52\x62\x52\x71\x52\x41\x21\xf1\x42\x41\x40"
            "\x47\x82\x32\x40\xf1\x32\x41\x50\xf1\x32\xa0\x22\xb7"
            "\x82" }  },
      /* --- pixel bitmap for cmmi160 char#71 G --- */
      {  71, 8354,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   15, 3,53, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x75\x31\x52\x51\x11\x42\x82\x32\xa1\x22\xb1\x22\xdf"
            "\x12\xe2\x76\x1f\x22\x92\x30\x11\x92\x52\x62\x77\x11"
            "\x42" }  },
      /* --- pixel bitmap for cmmi160 char#72 H --- */
      {  72, 9547,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   15, 3,45, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x37\x27\xf3\x52\x72\x30\xf1\x42\x72\x40\x4b\x82\x72"
            "\x40\xf3\x32\x72\x50\x22\x72\x67\x27\x32" }  },
      /* --- pixel bitmap for cmmi160 char#73 I --- */
      {  73,10270,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   15, 3,25, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x37\xf3\x52\x30\xf3\x42\x40\xf3\x32\x50\x22\x67\x32" }  },
      /* --- pixel bitmap for cmmi160 char#74 J --- */
      {  74,11094,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 12,   15, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x66\xf3\x82\x20\xf3\x72\x30\xf2\x62\x42\x42\x41\x42"
            "\x64\x73" }  },
      /* --- pixel bitmap for cmmi160 char#75 K --- */
      {  75,12317,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   15, 3,63, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x37\x26\x52\x62\x82\x52\x92\x42\xa2\x31\xb2\x31\xc2"
            "\x23\xb2\x11\x12\xb3\x22\xa3\x42\x92\x52\x92\x53\x82"
            "\x62\x72\x72\x56\x46\x20" }  },
      /* --- pixel bitmap for cmmi160 char#76 L --- */
      {  76,13290,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   15, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x20\xf3\x52\x60\xf3\x42\x70\xf1\x32\x71\xf1\x32"
            "\x61\x10\x22\x53\x1b\x22" }  },
      /* --- pixel bitmap for cmmi160 char#77 M --- */
      {  77,14616,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 22,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x00\x3e\x38\xc0\x01\x1a\x70\x80\x06\x1a\xa0\x41"
            "\x06\x64\xd0\x00\x19\x32\x40\x86\x0c\x90\x11\x03\x62"
            "\x62\x80\x98\x18\x20\x1c\x06\x08\x87\x01\xc3\x30\xf0"
            "\x11\x3f\x00" }  },
      /* --- pixel bitmap for cmmi160 char#78 N --- */
      {  78,15774,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\xe0\x07\x0f\x0c\x68\x20\x40\x03\x01\x32\x08\x88"
            "\x21\x40\x1c\x01\xc2\x08\x10\x46\x40\x60\x01\x02\x0b"
            "\x10\x70\x80\x80\x03\x06\x0c\xfc\x40\x00" }  },
      /* --- pixel bitmap for cmmi160 char#79 O --- */
      {  79,16679,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,47, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x66\x73\x42\x52\x72\x32\x92\xf1\x12\xa2\x0f\x22\xb2"
            "\x0f\x12\xa2\x12\x92\x32\x72\x43\x42\x85\x71" }  },
      /* --- pixel bitmap for cmmi160 char#80 P --- */
      {  80,17786,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   15, 3,39, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3b\x72\x62\x10\xf2\x52\x72\x42\x72\x52\x62\x68\x82"
            "\xa0\xf3\x32\xb0\x22\xc6\xa2" }  },
      /* --- pixel bitmap for cmmi160 char#81 Q --- */
      {  81,18843,                      /* character number, location */
         15, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 15,   19, 3,59, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x66\x73\x42\x52\x72\x32\x92\xf1\x12\xa2\x0f\x22\xb2"
            "\x0f\x12\xa2\x12\x92\x31\x23\x32\x43\x33\x85\xe0\xe0"
            "\x21\xe4\xb3\x40" }  },
      /* --- pixel bitmap for cmmi160 char#82 R --- */
      {  82,20156,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,47, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3a\x72\x52\x10\xf2\x52\x62\x42\x62\x52\x52\x67\x82"
            "\x42\x30\xf3\x32\x52\x30\x22\x62\x27\x44\x15" }  },
      /* --- pixel bitmap for cmmi160 char#83 S --- */
      {  83,21253,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x13\x86\x41\x20\x0c\x84\x01\x30\x00\x7e\x80\x1f"
            "\x80\x07\xc0\x00\x18\x01\x23\x30\x06\x43\x3f\x00" }  },
      /* --- pixel bitmap for cmmi160 char#84 T --- */
      {  84,22319,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\x02\x42\x51\x1f\x21\x52\x51\x10\xf3\x52\x80\xf3"
            "\x42\x90\x32\xa8\x72" }  },
      /* --- pixel bitmap for cmmi160 char#85 U --- */
      {  85,23289,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   15, 3,41, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07\x36\x22\x82\x20\xf2\x22\x81\x30\xf3\x12\x81\x4f"
            "\x22\x81\x52\x71\x72\x42\x95\x92" }  },
      /* --- pixel bitmap for cmmi160 char#86 V --- */
      {  86,24213,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   15, 3,55, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x55\x22\x82\x42\x81\x52\x71\x72\x61\x72\x51\x50"
            "\xf1\x32\x41\x60\x32\x31\xa2\x22\xa2\x21\xb4\xd3\xd2"
            "\xe1\xb4" }  },
      /* --- pixel bitmap for cmmi160 char#87 W --- */
      {  87,25598,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 22,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\x7e\x3e\x03\x07\xc2\xa0\x41\x30\x68\x10\x0c\x19"
            "\x02\x43\x86\xc0\x88\x11\x30\x62\x04\x4c\x98\x00\x1b"
            "\x36\xc0\x82\x05\x70\xe0\x00\x1c\x38\x00\x03\x06\xc0"
            "\x80\x01\x00" }  },
      /* --- pixel bitmap for cmmi160 char#88 X --- */
      {  88,26741,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 19,   15, 3,61, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x47\x26\x72\x61\xa3\x41\xc2\x31\xd2\x21\xe0\x13\xe0"
            "\x22\xe0\x33\xe0\x14\xe2\x13\xd1\x32\xc1\x42\xb1\x62"
            "\x91\x72\x56\x47\x22" }  },
      /* --- pixel bitmap for cmmi160 char#89 Y --- */
      {  89,27817,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   15, 3,45, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x56\x23\x72\x62\x71\x72\x61\x92\x41\xa2\x31\xb3"
            "\x12\xc4\xd3\x90\xf3\x52\xa0\x42\xd6\x91" }  },
      /* --- pixel bitmap for cmmi160 char#90 Z --- */
      {  90,28906,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   15, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5b\x43\x53\x52\x53\x61\x62\x71\x52\xd2\xd2\xd2\xd2"
            "\xd2\x51\x72\x61\x62\x71\x52\x72\x42\x72\x4c\x41" }  },
      /* --- pixel bitmap for cmmi160 char#91 \flat --- */
      {  91,117698,                     /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x81\x40\x20\x10\x08\x04\x6e\xc1\x60\x30\x18\x8a\x64"
            "\x0a\x03" }  },
      /* --- pixel bitmap for cmmi160 char#92 \natural --- */
      {  92,118457,                     /* character number, location */
         15, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  7,   19, 3,26, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf3\x01\x61\x37\x21\x0f\x71\x51\x01\x37\x21\xf2\x61" }  },
      /* --- pixel bitmap for cmmi160 char#93 \sharp --- */
      {  93,119318,                     /* character number, location */
         15, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  7,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x22\x91\x48\x24\x7f\x89\x44\x22\x91\x48\x24\x12\xc9"
            "\x5f\x22\x91\x08" }  },
      /* --- pixel bitmap for cmmi160 char#94 \smile --- */
      {  94,120244,                     /* character number, location */
          9, 1,    3, 1,      /* topleft row,col, and botleft row,col */
          { 20,    6, 3,27, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\xe0\x41\x11\xe0\x21\x31\xe1\x51\xc1\x73\x63\xb6"
            "\x77" }  },
      /* --- pixel bitmap for cmmi160 char#95 \frown --- */
      {  95,121116,                     /* character number, location */
          9, 1,    3, 1,      /* topleft row,col, and botleft row,col */
          { 20,    6, 3,26, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x76\xb3\x63\x71\xc1\x51\xe1\x31\xe0\x21\x11\xe0\x41" }  },
      /* --- pixel bitmap for cmmi160 char#96 \ell --- */
      {  96,94488,                      /* character number, location */
         15,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  9,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x81\x02\x05\x09\x0a\x12\x14\x28\x30\x30\x20\x60"
            "\xa0\x00\x22\x3c" }  },
      /* --- pixel bitmap for cmmi160 char#97 a --- */
      {  97,29842,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb8\x10\x23\x8c\x30\x41\x04\x11\x64\x98\x51\x39\x03" }  },
      /* --- pixel bitmap for cmmi160 char#98 b --- */
      {  98,30706,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x04\x04\x04\x04\x72\x8e\x82\x82\x81\x81\x81\x41"
            "\x22\x1c" }  },
      /* --- pixel bitmap for cmmi160 char#99 c --- */
      {  99,31537,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x10\x12\x14\x10\x20\x40\x80\x80\xc2\x78\x00" }  },
      /* --- pixel bitmap for cmmi160 char#100 d --- */
      { 100,32501,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x03\x04\x10\x40\x00\xe1\x42\x8c\x30\xc2\x04\x11"
            "\x44\x90\x61\x46\xe5\x0c" }  },
      /* --- pixel bitmap for cmmi160 char#101 e --- */
      { 101,33342,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x18\x0a\x14\xf4\x27\x40\x80\x80\xc2\x78\x00" }  },
      /* --- pixel bitmap for cmmi160 char#102 f --- */
      { 102,34486,                      /* character number, location */
         15, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 10,   19, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x73\x61\x21\xf2\x61\x30\x44\x20\xf5\x51\x40\xf3\x41"
            "\x50\x31\x61\x21\x72\x72" }  },
      /* --- pixel bitmap for cmmi160 char#103 g --- */
      { 103,35449,                      /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 10,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x62\x4c\x30\xc1\x02\x09\x24\x90\x60\xc4\xe0\x02"
            "\x08\x20\x40\xfc\x00" }  },
      /* --- pixel bitmap for cmmi160 char#104 h --- */
      { 104,36372,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x40\x00\x02\x10\x80\x00\x72\x70\x84\x21\x04\x31"
            "\x84\x20\x04\x29\xc4\x20\x05\x06" }  },
      /* --- pixel bitmap for cmmi160 char#105 i --- */
      { 105,37238,                      /* character number, location */
         16, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,   16, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x00\x00\x80\x49\xa9\x10\x22\xa5\x32" }  },
      /* --- pixel bitmap for cmmi160 char#106 j --- */
      { 106,38157,                      /* character number, location */
         16,-1,   -4,-1,      /* topleft row,col, and botleft row,col */
          { 10,   20, 3,39, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x91\xf4\xa0\x62\x71\x21\x10\xf1\x41\x31\x10\xf3\x71"
            "\x20\xf3\x61\x30\x51\x45\x51" }  },
      /* --- pixel bitmap for cmmi160 char#107 k --- */
      { 107,39164,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x20\x80\x00\x02\x08\x10\x4e\x24\x09\x14\x78\x20"
            "\x82\x90\x42\x06\x15\x1c" }  },
      /* --- pixel bitmap for cmmi160 char#108 l --- */
      { 108,39890,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4e\x44\x24\x22\x12\x91\x59\x03" }  },
      /* --- pixel bitmap for cmmi160 char#109 m --- */
      { 109,41113,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc6\x71\x72\x1c\x65\x18\x4a\x10\xc4\x30\x84\x20\x08"
            "\x41\x50\x82\x90\x82\xa0\x04\x81\x01" }  },
      /* --- pixel bitmap for cmmi160 char#110 n --- */
      { 110,42148,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc6\xc9\x51\x86\x12\xc4\x10\x82\x10\x94\x90\x82\x12"
            "\x18" }  },
      /* --- pixel bitmap for cmmi160 char#111 o --- */
      { 111,42874,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x10\x12\x14\x18\x30\x60\xc0\x40\x42\x78\x00" }  },
      /* --- pixel bitmap for cmmi160 char#112 p --- */
      { 112,43836,                      /* character number, location */
         10, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          { 10,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcc\xc9\x28\xa1\x84\x08\x22\x88\x20\x42\x8c\xd0\x41"
            "\x00\x01\x02\x3c\x00" }  },
      /* --- pixel bitmap for cmmi160 char#113 q --- */
      { 113,44763,                      /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x70\x18\x0b\x16\x1c\x28\x50\xa0\x60\x62\xb8\x00\x01"
            "\x02\x02\x1f" }  },
      /* --- pixel bitmap for cmmi160 char#114 r --- */
      { 114,45650,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe6\x99\x09\x09\x0c\x04\x04\x04\x02\x02" }  },
      /* --- pixel bitmap for cmmi160 char#115 s --- */
      { 115,46586,                      /* character number, location */
         10, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x86\x82\x02\x1c\x20\x40\x41\x21\x1e" }  },
      /* --- pixel bitmap for cmmi160 char#116 t --- */
      { 116,47330,                      /* character number, location */
         14, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x08\x04\xf2\x47\x20\x10\x04\x02\x91\x44\xe2\x00" }  },
      /* --- pixel bitmap for cmmi160 char#117 u --- */
      { 117,48372,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x49\x48\x42\x12\x42\x08\x42\x10\x92\x98\xc4\xc2"
            "\x0d" }  },
      /* --- pixel bitmap for cmmi160 char#118 v --- */
      { 118,49265,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x13\x26\x4c\x48\x88\x10\x21\x22\x44\x70\x00" }  },
      /* --- pixel bitmap for cmmi160 char#119 w --- */
      { 119,50445,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x61\x42\x98\x10\x26\x84\x84\x10\x21\x44\x08\x11"
            "\x23\xc4\x08\xce\x01" }  },
      /* --- pixel bitmap for cmmi160 char#120 x --- */
      { 120,51677,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x8f\x8c\x44\x40\x04\x20\x00\x02\x20\x04\x42\x31"
            "\xe2\x1c" }  },
      /* --- pixel bitmap for cmmi160 char#121 y --- */
      { 121,52775,                      /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x0b\x16\x2c\x28\x48\x90\x20\x61\x62\xb8\x00\x01"
            "\x11\xc1\x01" }  },
      /* --- pixel bitmap for cmmi160 char#122 z --- */
      { 122,53679,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x89\x13\x02\x02\x02\x02\x42\x82\x8e\xe2\x00" }  },
      /* --- pixel bitmap for cmmi160 char#123 \imath --- */
      { 123,95234,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x26\xa5\x42\x88\x94\xca\x00" }  },
      /* --- pixel bitmap for cmmi160 char#124 \jmath --- */
      { 124,96037,                      /* character number, location */
         10,-1,   -4,-1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x62\x61\x21\xf1\x41\x31\xf3\x71\x10\xf3\x61\x20\x51"
            "\x35\x41" }  },
      /* --- pixel bitmap for cmmi160 char#125 \wp --- */
      { 125,97156,                      /* character number, location */
         10, 2,   -4, 2,      /* topleft row,col, and botleft row,col */
          { 12,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x40\x78\x62\x28\x81\x09\x58\x80\x03\x28\x40\x15"
            "\x92\x1e\x09\x10\x01\x09\x60\x00" }  },
      /* --- pixel bitmap for cmmi160 char#126 \vec --- */
      { 126,97786,                      /* character number, location */
         15, 4,   11, 4,      /* topleft row,col, and botleft row,col */
          {  9,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\xfe\x03\x03\x02" }  },
      /* --- pixel bitmap for cmmi160 char#127 (noname) --- */
      { 127,98324,                      /* character number, location */
         14, 6,   12, 6,      /* topleft row,col, and botleft row,col */
          {  8,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7e\x81" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=5 for .180gf ---
 * mf '\mode=preview; mag=magstep(-14.65037297372839890542); input cmmi10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmmi180 --- */
static	chardef  cmmi180[] =
   {
      /* --- pixel bitmap for cmmi180 char#0 \Gamma --- */
      {   0,55074,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 18,   17, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4e\x72\x72\x72\x81\xf2\x62\x91\x62\xa0\xf3\x52\xb0"
            "\xf3\x42\xc0\x32\xd8\xa2" }  },
      /* --- pixel bitmap for cmmi180 char#1 \Delta --- */
      {   1,55985,                      /* character number, location */
         18, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   18, 3,72, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xd2\x40\xf1\xc3\x40\xb1\x12\xe1\x23\x30\xf1\x91\x42"
            "\x30\x81\x52\xa1\x63\x20\xf1\x61\x82\x20\x51\x92\x61"
            "\xa3\x42\xb2\x41\xc2\x31\xd2\x2e\x0e\x09" }  },
      /* --- pixel bitmap for cmmi180 char#2 \Theta --- */
      {   2,57168,                      /* character number, location */
         18, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 17,   19, 3,67, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\x92\x52\x72\x72\x51\xa2\x31\xb2\x22\xb2\x12\xd1"
            "\x12\xc2\x0f\x22\x29\x22\x0f\x12\xc2\x1f\x12\xb2\x20"
            "\x11\xa2\x42\x82\x62\x52\xa5\x8e" }  },
      /* --- pixel bitmap for cmmi180 char#3 \Lambda --- */
      {   3,58134,                      /* character number, location */
         18, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x18\x00\x0c\x00\x07\x80\x03\xa0\x01\xc8\x00\x64"
            "\x00\x31\x80\x18\x20\x0c\x10\x06\x04\x03\x82\x81\xc0"
            "\x60\x60\x10\x30\x0c\x98\x0f\x3f" }  },
      /* --- pixel bitmap for cmmi180 char#4 \Xi --- */
      {   4,59545,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   17, 3,59, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x4e\x01\x41\xd1\x31\xd1\x10\xf1\xe0\x50\x61\x71"
            "\x40\xf1\x59\x50\x51\x71\x50\xf2\xe0\x50\xf1\x11\xd1"
            "\x3f\x1e\x01\x41" }  },
      /* --- pixel bitmap for cmmi180 char#5 \Pi --- */
      {   5,60754,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 23,   17, 3,45, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4e\x05\xf1\x72\x92\x30\xf3\x62\x92\x40\xf3\x52\x92"
            "\x50\xf3\x42\x92\x60\x32\x92\x78\x38\x40" }  },
      /* --- pixel bitmap for cmmi180 char#6 \Sigma --- */
      {   6,61941,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   17, 3,67, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4e\x01\x52\xa2\x52\xb1\x53\xa1\x62\xa1\x63\x91\xf1"
            "\x72\xa0\x82\xe0\x31\xe0\x31\xe0\x31\x91\x62\xa1\x51"
            "\xb1\x51\xc1\x41\xb3\x3e\x01\x45" }  },
      /* --- pixel bitmap for cmmi180 char#7 \Upsilon --- */
      {   7,63033,                      /* character number, location */
         18, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 18,   18, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x34\x63\x46\x42\x12\x22\x42\x21\x42\x11\x52\x11\x53"
            "\x71\x11\x51\x10\xf2\x82\x80\xf3\x72\x90\xf3\x62\xa0"
            "\x52\xd8\x81" }  },
      /* --- pixel bitmap for cmmi180 char#8 \Phi --- */
      {   8,64071,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 16,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x3f\x00\x06\x00\x06\x00\x03\xe0\x1f\x18\x73\x06"
            "\xc3\x86\xc1\x83\xc1\x83\xc1\x83\x61\xce\x18\xf8\x07"
            "\xc0\x00\xc0\x00\x60\x00\xfc\x03" }  },
      /* --- pixel bitmap for cmmi180 char#9 \Psi --- */
      {   9,65184,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 17,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x3f\x00\x0c\x00\x18\x38\x18\xcc\x30\x8c\x61\x0c"
            "\xc3\x18\xc3\x18\x86\x31\x0c\x33\x30\x66\xc0\x76\x00"
            "\x3f\x00\x18\x00\x30\x00\x30\x00\xfc\x03\x00" }  },
      /* --- pixel bitmap for cmmi180 char#10 \Omega --- */
      {  10,66407,                      /* character number, location */
         18, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 18,   18, 3,75, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\xa3\x52\x72\x82\x52\xa2\x32\xb2\xf2\x22\xc2\x22"
            "\xb2\x10\xf1\x22\xa2\x20\x31\x92\x62\x72\x81\x62\x51"
            "\x31\x61\x31\x21\x31\x51\x31\x35\x46\x35\x45\x42" }  },
      /* --- pixel bitmap for cmmi180 char#11 \alpha --- */
      {  11,67457,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x01\xc6\xc8\x60\x1a\x98\x06\xd6\x80\x35\xe0\x0c"
            "\x18\x02\x86\x61\xc5\xc7\x01" }  },
      /* --- pixel bitmap for cmmi180 char#12 \beta --- */
      {  12,68512,                      /* character number, location */
         17, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          { 13,   22, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x07\x18\x83\x40\x10\x08\x81\x21\x10\xf4\x41\x3e"
            "\x08\x0c\x81\x21\x30\x02\x46\xc0\x08\x18\x81\x51\x1c"
            "\xf2\x40\x00\x08\x80\x00\x10\x00\x02\x00" }  },
      /* --- pixel bitmap for cmmi180 char#13 \gamma --- */
      {  13,69437,                      /* character number, location */
         11, 0,   -6, 0,      /* topleft row,col, and botleft row,col */
          { 14,   17, 3,51, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x33\x71\x16\x51\x22\x32\x41\x11\x61\x31\xa1\x21\x20"
            "\xf1\x81\x11\x30\xf2\x82\x40\xf2\x81\x50\xf3\x71\x61" }  },
      /* --- pixel bitmap for cmmi180 char#14 \delta --- */
      {  14,70398,                      /* character number, location */
         18, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x80\x0f\x21\x04\x30\x80\x01\x06\x38\xd8\x31\x66"
            "\x98\x61\x83\x0d\x36\x98\x20\x46\xf0\x00" }  },
      /* --- pixel bitmap for cmmi180 char#15 \epsilon --- */
      {  15,71266,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x31\x30\x30\xe0\x67\xc0\x80\x01\x06\x08\xe1\x01" }  },
      /* --- pixel bitmap for cmmi180 char#16 \zeta --- */
      {  16,72200,                      /* character number, location */
         17, 0,   -5, 0,      /* topleft row,col, and botleft row,col */
          { 10,   22, 3,47, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x71\x20\x73\x55\x42\x72\x81\x82\x60\xf2\x12\x7f"
            "\x22\x80\x12\x83\x85\x74\x83\x82\x81\x63\x31" }  },
      /* --- pixel bitmap for cmmi180 char#17 \eta --- */
      {  17,73117,                      /* character number, location */
         11, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 11,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc6\x6b\x71\x87\x1b\xcc\x60\x83\x19\xcc\x60\x06\x1b"
            "\xcc\x60\x00\x03\x18\x60\x00\x03\x18\x40\x00" }  },
      /* --- pixel bitmap for cmmi180 char#18 \theta --- */
      {  18,73887,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x40\x86\x11\xc3\x04\x1b\x6c\xf0\x60\xff\x0d\x36"
            "\xd8\x30\xc1\x84\x31\xc2\x04\x0e\x00" }  },
      /* --- pixel bitmap for cmmi180 char#19 \iota --- */
      {  19,74536,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x06\x83\xc1\x30\x18\x8c\xa3\x99\x03" }  },
      /* --- pixel bitmap for cmmi180 char#20 \kappa --- */
      {  20,75444,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\xc6\x58\x4c\xc0\x02\x1c\xe0\x0f\x86\x61\x98\x86"
            "\x39\x58\x03\x03" }  },
      /* --- pixel bitmap for cmmi180 char#21 \lambda --- */
      {  21,76279,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x00\x0c\x80\x03\x60\x00\x0c\x80\x03\x60\x00\x0c"
            "\x00\x03\x70\x00\x1d\x10\x03\x63\x30\x1c\x03\x33\x60"
            "\x02\x18" }  },
      /* --- pixel bitmap for cmmi180 char#22 \mu --- */
      {  22,77291,                      /* character number, location */
         11, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 13,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x08\x83\x61\x30\x0c\x86\xc1\x18\x0c\x83\x61\xb0"
            "\x0c\xd7\xf1\xd9\x31\x03\x60\x00\x06\xc0\x00\x18\x00"
            "\x01\x00" }  },
      /* --- pixel bitmap for cmmi180 char#23 \nu --- */
      {  23,78064,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\xc8\xc0\x0c\xcc\xc0\x0c\x66\x30\x86\x61\x0c\x66"
            "\xb0\x01\x07\x00" }  },
      /* --- pixel bitmap for cmmi180 char#24 \xi --- */
      {  24,79214,                      /* character number, location */
         17, 0,   -5, 0,      /* topleft row,col, and botleft row,col */
          { 10,   22, 3,53, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x61\x30\x55\x42\x13\x32\x50\xf2\x22\x60\xf1\x36"
            "\x10\x21\x82\x7f\x22\x83\x84\x75\x74\x92\x41\x31\x63"
            "\x32" }  },
      /* --- pixel bitmap for cmmi180 char#25 \pi --- */
      {  25,80132,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xdf\xff\xcf\x84\x88\x00\x11\x30\x03\x62\x40\x0c"
            "\x8c\x81\x71\x10\x04" }  },
      /* --- pixel bitmap for cmmi180 char#26 \rho --- */
      {  26,80974,                      /* character number, location */
         11, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 12,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x03\x66\x30\x84\xc1\x18\xcc\x60\x0c\xc6\x60\x0c"
            "\xe3\x18\x76\x60\x00\x06\x30\x00\x03\x30\x00\x01\x00" }  },
      /* --- pixel bitmap for cmmi180 char#27 \sigma --- */
      {  27,81880,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   11, 3,33, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x58\x3a\x22\x42\x42\x52\x42\x61\x3f\x22\x62\x32\x52"
            "\x52\x32\x74\x72" }  },
      /* --- pixel bitmap for cmmi180 char#28 \tau --- */
      {  28,82669,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x29\x1c\x31\x51\x32\x50\xf1\x41\x60\xf2\x32\x60\xf1"
            "\x22\x72" }  },
      /* --- pixel bitmap for cmmi180 char#29 \upsilon --- */
      {  29,83570,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x54\x70\x03\x1b\xc8\x40\x03\x19\xc8\x40\x06\x21"
            "\x04\x1e\x00" }  },
      /* --- pixel bitmap for cmmi180 char#30 \phi --- */
      {  30,84442,                      /* character number, location */
         17, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          { 14,   22, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x02\x80\x00\x20\x00\x04\x00\x01\x40\x00\x7e\xe0"
            "\x32\x8c\x98\x21\x64\x08\x0f\x61\x43\xd8\x10\x62\x44"
            "\x90\x0c\xf8\x00\x08\x00\x02\x40\x00\x10\x00\x04\x00" }  },
      /* --- pixel bitmap for cmmi180 char#31 \chi --- */
      {  31,85513,                      /* character number, location */
         11, 0,   -5, 0,      /* topleft row,col, and botleft row,col */
          { 14,   16, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\xa0\x0c\x08\x03\x81\x21\x60\x04\xb8\x00\x1c\x00"
            "\x03\xc0\x00\x68\x00\x1a\x40\x0e\x08\x03\xc1\x20\x60"
            "\x05\x30" }  },
      /* --- pixel bitmap for cmmi180 char#32 \psi --- */
      {  32,86592,                      /* character number, location */
         17, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          { 14,   22, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x04\x00\x01\x20\x00\x08\x00\x02\x80\xe0\x10\x2a"
            "\xc4\x0d\x61\x43\xc8\x08\x1a\x42\x86\x90\x21\x62\x44"
            "\x30\x09\xf0\x01\x10\x00\x02\x80\x00\x20\x00\x08\x00" }  },
      /* --- pixel bitmap for cmmi180 char#33 \omega --- */
      {  33,87675,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x20\x01\x6c\x00\x0a\x86\x82\x61\x30\x14\x0c\x0d"
            "\x63\xf7\x8c\xef\xc3\x31\x00" }  },
      /* --- pixel bitmap for cmmi180 char#34 \varepsilon --- */
      {  34,88656,                      /* character number, location */
         12, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 10,   13, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\x47\x22\x51\xf1\x11\x80\x25\x46\x3f\x21\x91\x61"
            "\x36\x54\x42" }  },
      /* --- pixel bitmap for cmmi180 char#35 \vartheta --- */
      {  35,89687,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x03\x64\x40\x04\xc2\x20\x0c\xc4\x86\xdc\x70\x0d"
            "\xde\x60\x0c\x66\x30\x06\x63\x18\x86\x60\x04\x3c\x00" }  },
      /* --- pixel bitmap for cmmi180 char#36 \varpi --- */
      {  36,90934,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xff\xf7\xff\xff\x04\x80\x12\x00\x84\x40\x20\x02"
            "\x81\x10\x08\x84\xe0\x30\x84\xc7\xe0\xe7\x03\x0e\x0f"
            "\x00" }  },
      /* --- pixel bitmap for cmmi180 char#37 \varrho --- */
      {  37,91841,                      /* character number, location */
         11, 2,   -5, 2,      /* topleft row,col, and botleft row,col */
          { 11,   16, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x81\x19\x86\x18\xcc\x60\x83\x19\xcc\x60\x86\x29"
            "\x46\x0e\x02\x10\x80\x3f\xf8\x03\x10" }  },
      /* --- pixel bitmap for cmmi180 char#38 \varsigma --- */
      {  38,92668,                      /* character number, location */
         11, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  9,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x19\x18\x18\x30\x60\xc0\x01\x07\x3c\xe0\x00\x01"
            "\x82\x03" }  },
      /* --- pixel bitmap for cmmi180 char#39 \varphi --- */
      {  39,93599,                      /* character number, location */
         11, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 14,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x0e\xc1\x27\x18\x0b\x82\x42\x60\x10\x14\x04\x89"
            "\x20\x26\x06\xff\x00\x1f\xc0\x00\x10\x00\x04\x80\x01"
            "\x60\x00\x08\x00" }  },
      /* --- pixel bitmap for cmmi180 char#40 \leftharpoonup --- */
      {  40,109405,                     /* character number, location */
         13, 1,    6, 1,      /* topleft row,col, and botleft row,col */
          { 23,    7, 3,30, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x61\xe0\x71\xe0\x30\xf1\x41\xe0\x40\x31\xe0\x62\xe0"
            "\x6e\x09" }  },
      /* --- pixel bitmap for cmmi180 char#41 \leftharpoondown --- */
      {  41,110433,                     /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 23,    7, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x09\x12\xe0\x91\xe0\x50\xf1\x41\xe0\x40\x51\xe0"
            "\x91\xe0\x22" }  },
      /* --- pixel bitmap for cmmi180 char#42 \rightharpoonup --- */
      {  42,111459,                     /* character number, location */
         13, 1,    6, 1,      /* topleft row,col, and botleft row,col */
          { 23,    7, 3,30, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x21\xe0\x91\x50\xf1\xe0\x41\x40\xe0\x51\xe0\x92"
            "\x1e\x09" }  },
      /* --- pixel bitmap for cmmi180 char#43 \rightharpoondown --- */
      {  43,112488,                     /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 23,    7, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x09\xe0\x62\xe0\x61\x30\xf1\xe0\x41\x40\xe0\x31"
            "\xe0\x71\x62" }  },
      /* --- pixel bitmap for cmmi180 char#44 ` --- */
      {  44,112909,                     /* character number, location */
         13, 1,    6, 1,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\x84\x10\x04\x07" }  },
      /* --- pixel bitmap for cmmi180 char#45 ' --- */
      {  45,113331,                     /* character number, location */
         13, 1,    6, 1,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07\x41\x08\xd1\x01" }  },
      /* --- pixel bitmap for cmmi180 char#46 \triangleright --- */
      {  46,113870,                     /* character number, location */
         13, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\x70\x00\x19\x10\x06\x81\x11\x60\x01\x18\x60\x81"
            "\x11\x06\x19\x70\x00\x01\x00" }  },
      /* --- pixel bitmap for cmmi180 char#47 \triangleleft --- */
      {  47,114438,                     /* character number, location */
         13, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x08\xe0\x80\x09\x86\x18\x68\x80\x01\x68\x80\x18"
            "\x08\x86\x80\x09\xe0\x00\x08" }  },
      /* --- pixel bitmap for cmmi180 char#48 \0 --- */
      {  48,99908,                      /* character number, location */
         12, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 10,   13, 3,27, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x34\x42\x42\x21\x61\x1f\x62\x62\x11\x61\x22\x42\x44"
            "\x32" }  },
      /* --- pixel bitmap for cmmi180 char#49 \1 --- */
      {  49,100683,                     /* character number, location */
         12, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  8,   12, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x41\x35\x30\xf8\x32\x38" }  },
      /* --- pixel bitmap for cmmi180 char#50 \2 --- */
      {  50,101653,                     /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x08\x16\xf0\xc0\x00\x03\x0c\x18\x30\x30\x22\xe8"
            "\xdf\x7f" }  },
      /* --- pixel bitmap for cmmi180 char#51 \3 --- */
      {  51,102682,                     /* character number, location */
         12, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 10,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x10\x23\x98\x61\x86\x01\x06\x08\x10\x78\x00\x02"
            "\x18\xc0\x03\x0f\x1c\xb0\x60\x84\xe0\x01" }  },
      /* --- pixel bitmap for cmmi180 char#52 \4 --- */
      {  52,103619,                     /* character number, location */
         12, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          { 10,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x00\x03\x0e\x38\xd0\x60\x83\x0c\x31\xc4\x08\x13"
            "\xcc\xff\xc0\x00\x03\x0c\x30\xf0\x03" }  },
      /* --- pixel bitmap for cmmi180 char#53 \5 --- */
      {  53,104662,                     /* character number, location */
         12, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 10,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\xf9\xa3\x83\x00\x02\x08\x20\x87\x22\x86\x09\x0c"
            "\x30\xc0\x00\x0f\x1c\x90\x60\xc6\xe0\x01" }  },
      /* --- pixel bitmap for cmmi180 char#54 \6 --- */
      {  54,105571,                     /* character number, location */
         17, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 10,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x60\xc4\x98\x61\x06\x08\xb0\xc7\x21\x87\x0d\x3c"
            "\xf0\xc0\x03\x0f\x2c\xb0\x61\x8c\xe0\x01" }  },
      /* --- pixel bitmap for cmmi180 char#55 \7 --- */
      {  55,106488,                     /* character number, location */
         12, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 11,   18, 3,45, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x11\xaa\x19\x11\x81\x11\x71\x20\xf1\x71\x30\x61\x92"
            "\x91\x50\xf1\x42\x50\x41\x60\xf4\x32\x62" }  },
      /* --- pixel bitmap for cmmi180 char#56 \8 --- */
      {  56,107413,                     /* character number, location */
         17, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 10,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x30\x63\x98\x61\x86\x19\xc6\x0c\x17\x70\xb0\x63"
            "\xd8\xe0\x03\x0f\x3c\xb0\x41\x84\xe0\x01" }  },
      /* --- pixel bitmap for cmmi180 char#57 \9 --- */
      {  57,108330,                     /* character number, location */
         12, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 10,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x10\x62\xd8\x40\x03\x0f\x3c\xf0\xc0\x03\x1b\x4e"
            "\x38\xde\x00\x03\x66\x98\x21\x42\xf0\x00" }  },
      /* --- pixel bitmap for cmmi180 char#58 . --- */
      {  58,114935,                     /* character number, location */
          3, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  3,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x00" }  },
      /* --- pixel bitmap for cmmi180 char#59 , --- */
      {  59,115496,                     /* character number, location */
          3, 2,   -5, 2,      /* topleft row,col, and botleft row,col */
          {  3,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x49\x29" }  },
      /* --- pixel bitmap for cmmi180 char#60 < --- */
      {  60,116158,                     /* character number, location */
         14, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,44, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xd2\xb2\xb2\xb2\xb2\xb2\xb2\xc1\xe0\x12\xe0\x12\xe0"
            "\x12\xe0\x12\xe0\x12\xe0\x12\xe0\x12" }  },
      /* --- pixel bitmap for cmmi180 char#61 / --- */
      {  61,116690,                     /* character number, location */
         19, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 10,   25, 3,55, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x91\xf2\x81\x10\xf1\x71\x20\xf2\x61\x30\xf1\x51"
            "\x40\xf2\x41\x50\xf2\x31\x60\xf1\x21\x70\xf2\x11\x8f"
            "\x11\x94" }  },
      /* --- pixel bitmap for cmmi180 char#62 > --- */
      {  62,117389,                     /* character number, location */
         14, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,45, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\xe0\x22\xe0\x12\xe0\x12\xe0\x12\xe0\x12\xe0\x12"
            "\xe0\x11\xc2\xb2\xb2\xb2\xb2\xb2\xb2\xd0" }  },
      /* --- pixel bitmap for cmmi180 char#63 \star --- */
      {  63,118096,                     /* character number, location */
         13, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   13, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf4\x61\x64\x21\x24\x29\x73\xa1\x11\x92\x12\x72\x32"
            "\x61\x51\x51\x71\x22" }  },
      /* --- pixel bitmap for cmmi180 char#64 \partial --- */
      {  64,94589,                      /* character number, location */
         18, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 13,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x03\x84\x40\x20\x08\x0c\x01\x01\x20\xf8\x84\xa1"
            "\x08\x9c\x01\x1b\x60\x03\x3c\xc0\x06\xd8\x80\x19\x30"
            "\x02\x83\x30\xe0\x01" }  },
      /* --- pixel bitmap for cmmi180 char#65 A --- */
      {  65, 1026,                      /* character number, location */
         18, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   18, 3,70, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\xc2\x30\xb3\x30\xf1\xa1\x12\x30\xf1\x91\x22\x30"
            "\x81\x32\xa2\x32\xa1\x42\x91\x52\x99\x20\xf1\x51\x72"
            "\x20\x41\x82\x51\x92\x42\x92\x26\x47" }  },
      /* --- pixel bitmap for cmmi180 char#66 B --- */
      {  66, 2390,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 19,   17, 3,55, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4d\x92\x72\x82\x82\xf2\x62\x92\x62\x82\x62\x64\x7c"
            "\x72\x83\x62\x92\x10\xf2\x42\xa2\x10\x42\x92\x52\x83"
            "\x3e\x51" }  },
      /* --- pixel bitmap for cmmi180 char#67 C --- */
      {  67, 3363,                      /* character number, location */
         18, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 18,   19, 3,63, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\x31\x63\x51\x21\x52\x83\x41\xb2\x32\xb1\x32\xc1"
            "\x22\xd1\x22\xe0\x1f\x32\xe0\x2f\x22\xc1\x30\x11\xb1"
            "\x61\x91\x81\x62\xa6\x82" }  },
      /* --- pixel bitmap for cmmi180 char#68 D --- */
      {  68, 4537,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   17, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4c\x92\x72\x82\x82\x10\xf1\x52\xa2\xf1\x52\xb1\xf2"
            "\x42\xb2\x42\xb1\x42\xb2\x42\xa2\x52\xa1\x62\x82\x62"
            "\x73\x5c\x71" }  },
      /* --- pixel bitmap for cmmi180 char#69 E --- */
      {  69, 5964,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   17, 3,69, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4e\x62\x82\x62\x91\xf1\x52\xa1\x52\x51\x41\x52\x51"
            "\x92\x51\xa8\xa2\x51\xa2\x51\x41\x42\x51\x41\x52\xa1"
            "\x20\xf1\x32\x91\x30\x22\x83\x3e\x47" }  },
      /* --- pixel bitmap for cmmi180 char#70 F --- */
      {  70, 7227,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   17, 3,59, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4d\x62\x72\x62\x81\xf1\x52\x91\x52\x51\x31\x52\x51"
            "\x82\x51\x98\x50\xf1\x42\x51\x50\x32\x51\x60\xf2\x32"
            "\xc0\x22\xd7\xa1" }  },
      /* --- pixel bitmap for cmmi180 char#71 G --- */
      {  71, 8414,                      /* character number, location */
         18, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 18,   19, 3,71, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\x31\x63\x51\x21\x52\x83\x41\xb2\x32\xb1\x32\xc1"
            "\x22\xd1\x22\xe0\x1f\x12\xe0\x22\x99\xc2\x2f\x22\xb2"
            "\x30\x11\xb2\x51\x92\x71\x62\x11\x86\x80" }  },
      /* --- pixel bitmap for cmmi180 char#72 H --- */
      {  72, 9649,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 23,   17, 3,53, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x48\x38\xf1\x72\x92\x30\xf3\x62\x92\x40\x52\x92\xad"
            "\x50\xf1\x52\x92\x50\xf3\x42\x92\x60\x32\x92\x78\x38"
            "\x40" }  },
      /* --- pixel bitmap for cmmi180 char#73 I --- */
      {  73,10380,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   17, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x48\xf1\x72\x30\xf3\x62\x40\xf3\x52\x50\xf3\x42\x60"
            "\x32\x78\x42" }  },
      /* --- pixel bitmap for cmmi180 char#74 J --- */
      {  74,11208,                      /* character number, location */
         17, 3,   -1, 3,      /* topleft row,col, and botleft row,col */
          { 13,   18, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x67\xf1\x92\x20\xf3\x82\x30\xf3\x72\x40\xf1\x62\x51"
            "\x52\x52\x41\x61\x42\x61\x32\x84\x80" }  },
      /* --- pixel bitmap for cmmi180 char#75 K --- */
      {  75,12441,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 21,   17, 3,73, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x47\x46\x62\x82\x92\x72\x92\x71\xb2\x61\xc2\x51\xd2"
            "\x31\xe2\x32\xe2\x21\x12\xd3\x32\xd2\x51\x90\xf1\x32"
            "\x62\x80\xf1\x32\x72\x70\x22\x92\x67\x46\x40" }  },
      /* --- pixel bitmap for cmmi180 char#76 L --- */
      {  76,13422,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 16,   17, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x48\x40\xf1\x72\x70\xf3\x62\x80\xf3\x52\x90\xf1\x42"
            "\x91\x42\x81\x52\x72\x42\x73\x1e\x22" }  },
      /* --- pixel bitmap for cmmi180 char#77 M --- */
      {  77,14726,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 27,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x03\xe0\x07\x1c\x00\x07\xe0\x00\x34\x80\x06\xd0"
            "\x00\x34\x80\x06\x20\x03\x32\x00\x19\x88\x01\xc4\x40"
            "\x06\x20\x06\x31\x00\x31\x84\x01\x88\x21\x0c\x20\x98"
            "\x30\x00\xc1\x82\x01\x08\x16\x0c\x40\x70\x60\x00\x83"
            "\x81\x01\x7f\x8c\x7f\x00" }  },
      /* --- pixel bitmap for cmmi180 char#78 N --- */
      {  78,15928,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 23,   17, 3,79, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\x77\xf1\x73\x91\x30\xf1\x61\x22\x71\x40\xf1\x61"
            "\x32\x61\x40\xf1\x51\x52\x41\x50\xf1\x51\x62\x31\x50"
            "\xf1\x41\x82\x11\x60\xf1\x41\x93\x60\x32\xa1\x77\x81"
            "\x71" }  },
      /* --- pixel bitmap for cmmi180 char#79 O --- */
      {  79,16843,                      /* character number, location */
         18, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 17,   19, 3,63, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\x92\x52\x71\x82\x51\xa2\x31\xb2\x22\xc1\xf1\x12"
            "\xd1\x0f\x22\xd2\x0f\x12\xc2\x1f\x12\xb2\x20\x11\xa2"
            "\x42\x82\x62\x52\xa5\x81" }  },
      /* --- pixel bitmap for cmmi180 char#80 P --- */
      {  80,17966,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   17, 3,45, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4c\x82\x72\x72\x82\xf2\x52\x92\x52\x82\x52\x73\x6a"
            "\x40\xf1\x42\xc0\xf3\x32\xd0\x22\xe7\xb2" }  },
      /* --- pixel bitmap for cmmi180 char#81 Q --- */
      {  81,19029,                      /* character number, location */
         18, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          { 17,   23, 3,91, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\x92\x52\x72\x72\x51\xa2\x31\xb2\x22\xb2\x12\xd1"
            "\x12\xc2\x0f\x22\xd2\x0f\x12\xc2\x12\xb2\x22\x43\x42"
            "\x31\x31\x21\x32\x42\x11\x41\x12\x63\x42\x31\x66\x41"
            "\xa2\x32\xa2\x31\xc4\xd3\x51" }  },
      /* --- pixel bitmap for cmmi180 char#82 R --- */
      {  82,20400,                      /* character number, location */
         17, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 18,   18, 3,69, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4b\x92\x62\x82\x72\x10\xf2\x52\x82\x10\x52\x72\x62"
            "\x63\x79\x50\xf1\x42\x62\x40\xf2\x32\x72\x40\x32\x72"
            "\x31\x22\x81\x31\x17\x52\x21\xe3\x23" }  },
      /* --- pixel bitmap for cmmi180 char#83 S --- */
      {  83,21485,                      /* character number, location */
         18, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 15,   19, 3,69, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x75\x21\x62\x41\x11\x51\x72\x42\x72\xf1\x32\x81\x10"
            "\x32\xd3\xd6\xa7\xc4\x20\xf1\xb2\x20\xf1\x11\x92\x20"
            "\x11\x82\x32\x81\x44\x42\x51\x35\x63" }  },
      /* --- pixel bitmap for cmmi180 char#84 T --- */
      {  84,22569,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   17, 3,47, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\x02\x12\x52\x52\x11\x62\x52\x0f\x21\x62\x61\x10"
            "\x72\x80\xf3\x62\x90\xf3\x52\xa0\x42\xc9\x71" }  },
      /* --- pixel bitmap for cmmi180 char#85 U --- */
      {  85,23573,                      /* character number, location */
         17, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 19,   18, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x47\xf1\x32\xa1\x30\xf3\x22\xa1\x40\xf3\x12\xa1"
            "\x5f\x22\xa1\x60\x11\x91\x82\x71\xa2\x42\xc5\xb2" }  },
      /* --- pixel bitmap for cmmi180 char#86 V --- */
      {  86,24509,                      /* character number, location */
         17, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 18,   18, 3,77, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x66\x22\x92\x30\xf1\x22\x91\x40\x22\x81\x50\xf1"
            "\x22\x71\x60\xf1\x32\x51\x70\x32\x41\x80\xf1\x32\x31"
            "\x90\x32\x21\xd2\x12\xd2\x11\xe3\xe0\x22\xe0\x21\xd1" }  },
      /* --- pixel bitmap for cmmi180 char#87 W --- */
      {  87,25897,                      /* character number, location */
         17, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 25,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\xfe\xf8\x19\x30\x40\x30\x60\x80\x60\xc0\x80\xc0"
            "\xc0\x81\x81\x41\x03\x01\x83\x06\x01\x86\x0c\x02\x0c"
            "\x19\x02\x18\x71\x04\x30\xc2\x04\x60\x82\x09\xc0\x04"
            "\x0b\x80\x05\x1e\x00\x07\x1c\x00\x0e\x18\x00\x0c\x30"
            "\x00\x18\x20\x00\x00" }  },
      /* --- pixel bitmap for cmmi180 char#88 X --- */
      {  88,27082,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 20,   17, 3,65, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x47\x36\x72\x63\x92\x61\xc2\x41\xd2\x31\xe3\x11\xe0"
            "\x24\x70\xf2\x93\x80\x81\x22\xe1\x32\xd1\x43\xb1\x62"
            "\xa1\x73\x82\x82\x56\x56\x33" }  },
      /* --- pixel bitmap for cmmi180 char#89 Y --- */
      {  89,28166,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   17, 3,55, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x66\x22\x92\x53\x81\x72\x71\x83\x51\xa2\x42\xa2"
            "\x41\xc2\x21\xd2\x11\xe3\xe0\x22\xa0\xf3\x52\xb0\x42"
            "\xd8\x93" }  },
      /* --- pixel bitmap for cmmi180 char#90 Z --- */
      {  90,29263,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   17, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\x53\x62\x61\x72\x62\x62\x71\x62\x81\x53\xd3\xe2"
            "\xe2\xe2\xe2\x61\x72\x61\x72\x71\x62\x81\x52\x82\x42"
            "\x82\x4d\x42" }  },
      /* --- pixel bitmap for cmmi180 char#91 \flat --- */
      {  91,118793,                     /* character number, location */
         19, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          {  8,   20, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\x01\x01\x01\x01\x01\x01\x3d\x63\xc1\xc1\xc1\xc1"
            "\x61\x61\x31\x19\x0d\x07\x01" }  },
      /* --- pixel bitmap for cmmi180 char#92 \natural --- */
      {  92,119562,                     /* character number, location */
         19, 2,   -6, 2,      /* topleft row,col, and botleft row,col */
          {  6,   25, 3,34, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf5\x01\x51\x33\x18\x13\x31\x0f\x61\x41\x01\x33\x18"
            "\x13\x31\xf3\x51" }  },
      /* --- pixel bitmap for cmmi180 char#93 \sharp --- */
      {  93,120441,                     /* character number, location */
         18, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          {  8,   24, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x42\x42\x42\x42\xc2\xfe\x7f\x43\x42\x42\x42\x42"
            "\x42\x42\x42\xc2\xfe\x7f\x43\x42\x42\x42\x02" }  },
      /* --- pixel bitmap for cmmi180 char#94 \smile --- */
      {  94,121375,                     /* character number, location */
         10, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          { 23,    6, 3,27, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\xe0\x71\x11\xe0\x51\x32\xe0\x12\x54\x94\x8d\xd7"
            "\x81" }  },
      /* --- pixel bitmap for cmmi180 char#95 \frown --- */
      {  95,122245,                     /* character number, location */
         11, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          { 23,    7, 3,32, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb1\xe0\x3b\xae\x01\x72\xd2\x51\xe0\x31\x31\xe0\x51"
            "\x11\xe0\x71" }  },
      /* --- pixel bitmap for cmmi180 char#96 \ell --- */
      {  96,95373,                      /* character number, location */
         17, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x01\x0b\x26\x58\x30\xc1\x04\x0b\x16\x58\xe0\x80"
            "\x01\x02\x0c\x28\x90\x00\x66\x70\x00" }  },
      /* --- pixel bitmap for cmmi180 char#97 a --- */
      {  97,30207,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\xc2\x1c\xc3\x0c\x66\xb0\xc1\x0c\x66\xb0\xc3\x15"
            "\x1f\xc7\x00" }  },
      /* --- pixel bitmap for cmmi180 char#98 b --- */
      {  98,31071,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\x60\x80\x01\x03\x0c\x30\xc0\x8f\x63\x06\x19\x6c"
            "\xf0\x60\x83\x0d\x36\x8c\x18\x1c\x00" }  },
      /* --- pixel bitmap for cmmi180 char#99 c --- */
      {  99,31906,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x61\xc8\xb0\x01\x06\x0c\x30\xc0\x00\x02\x1a\xc6"
            "\x07" }  },
      /* --- pixel bitmap for cmmi180 char#100 d --- */
      { 100,32872,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x0f\xc0\x00\x0c\x60\x00\x06\x60\xf0\x86\x39\x0c"
            "\x63\x30\x06\x33\x18\x83\x31\x58\xc3\x25\x3e\x1c\x03" }  },
      /* --- pixel bitmap for cmmi180 char#101 e --- */
      { 101,33715,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x60\xc4\x90\x41\xfe\x0c\x30\xc0\x00\x02\x1a\xc6"
            "\x07" }  },
      /* --- pixel bitmap for cmmi180 char#102 f --- */
      { 102,34861,                      /* character number, location */
         17, 2,   -5, 2,      /* topleft row,col, and botleft row,col */
          { 12,   22, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x83\x82\x12\x72\x11\x10\xf2\x62\x40\x38\x72\x40\xf5"
            "\x52\x50\xf3\x42\x60\x41\x81\x12\x72\x11\x92\x91" }  },
      /* --- pixel bitmap for cmmi180 char#103 g --- */
      { 103,35834,                      /* character number, location */
         11, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          { 11,   16, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x85\x39\x86\x19\xcc\x60\x83\x19\xcc\x60\x86\x23"
            "\x0e\x6e\x00\x03\x18\x61\x8c\xc1\x07" }  },
      /* --- pixel bitmap for cmmi180 char#104 h --- */
      { 104,36767,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x00\x03\x30\x80\x01\x18\x80\x01\xd8\xc3\x62\x1c"
            "\xc6\x60\x0c\x66\x30\x06\x63\xb0\x86\x39\x58\x03\x03" }  },
      /* --- pixel bitmap for cmmi180 char#105 i --- */
      { 105,37641,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x0c\x00\x00\xc0\x68\x59\xc6\x30\x86\x69\x5a\x0c" }  },
      /* --- pixel bitmap for cmmi180 char#106 j --- */
      { 106,38564,                      /* character number, location */
         17,-1,   -5,-1,      /* topleft row,col, and botleft row,col */
          { 11,   22, 3,51, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa1\x92\xf3\xb0\x63\x71\x22\x10\xf1\x41\x32\x10\x82"
            "\x10\xf3\x72\x20\xf3\x62\x30\x11\x32\x42\x22\x64\x62" }  },
      /* --- pixel bitmap for cmmi180 char#107 k --- */
      { 107,39581,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x80\x01\x0c\x30\x80\x01\x0c\x60\x9c\x91\x4c\x66"
            "\x01\x07\xfc\x60\x0c\x63\x1a\x73\x58\x83\x01" }  },
      /* --- pixel bitmap for cmmi180 char#108 l --- */
      { 108,40287,                      /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\x63\xc6\x18\x33\xc6\x98\x31\xe6\x5c\x06" }  },
      /* --- pixel bitmap for cmmi180 char#109 m --- */
      { 109,41514,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 20,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8e\xe7\xa1\xc5\x31\x39\x0c\x93\xc1\x30\x18\x0c\xc3"
            "\x60\x18\x0c\x86\xc1\x60\x98\x0c\xc6\x64\x30\x4c\x06"
            "\x83\x03" }  },
      /* --- pixel bitmap for cmmi180 char#110 n --- */
      { 110,42557,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xce\x43\xc7\x64\x98\x0c\x83\x61\x18\x06\xc3\x60\x98"
            "\x8c\xc9\x30\x19\x1c" }  },
      /* --- pixel bitmap for cmmi180 char#111 o --- */
      { 111,43313,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\xc0\x18\x83\x0c\x6c\xe0\x81\x0d\x6c\x60\x82\x31"
            "\x06\x0f\x00" }  },
      /* --- pixel bitmap for cmmi180 char#112 p --- */
      { 112,44305,                      /* character number, location */
         11,-2,   -5,-2,      /* topleft row,col, and botleft row,col */
          { 14,   16, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x0f\x3a\x86\x06\xa1\xc1\x60\x30\x0c\x06\x83\xc1"
            "\x60\x30\x0c\x8e\x81\x1d\x60\x00\x18\x00\x03\xc0\x00"
            "\xfc\x00" }  },
      /* --- pixel bitmap for cmmi180 char#113 q --- */
      { 113,45238,                      /* character number, location */
         11, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          { 11,   16, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\xc4\x14\xc3\x0c\x66\xb0\xc1\x0c\x66\x30\xc3\x11"
            "\x07\x37\x80\x01\x0c\x30\x80\x01\x3f" }  },
      /* --- pixel bitmap for cmmi180 char#114 r --- */
      { 114,46109,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc6\x7b\x76\x6e\xc0\xc0\x80\x01\x03\x06\x06\x0c\x00" }  },
      /* --- pixel bitmap for cmmi180 char#115 s --- */
      { 115,47049,                      /* character number, location */
         11, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  9,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x18\x1a\x36\xe0\x83\x0f\xb8\x60\x43\xc2\x78\x00" }  },
      /* --- pixel bitmap for cmmi180 char#116 t --- */
      { 116,47797,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x18\x18\x18\xff\x0c\x0c\x0c\x0c\x06\x06\x46\x26"
            "\x26\x1c" }  },
      /* --- pixel bitmap for cmmi180 char#117 u --- */
      { 117,48841,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\xa4\x60\x0d\xd6\x60\x0c\x66\x30\x06\x63\xb0\x86"
            "\x6b\x7c\x38\x06" }  },
      /* --- pixel bitmap for cmmi180 char#118 v --- */
      { 118,49736,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x2b\xdc\x60\x83\x0c\x1a\x64\x90\x41\x86\x10\x81"
            "\x03" }  },
      /* --- pixel bitmap for cmmi180 char#119 w --- */
      { 119,50920,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\xc4\x12\xc6\x11\x86\x19\x86\x18\x86\x0c\x43\x0c"
            "\x43\x0c\x43\x0c\x23\x88\x23\x70\x1e" }  },
      /* --- pixel bitmap for cmmi180 char#120 x --- */
      { 120,52158,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x70\x0e\x39\x12\x63\x62\x00\x0c\xc0\x00\x18\x00\x43"
            "\x62\x64\xce\x38\x07" }  },
      /* --- pixel bitmap for cmmi180 char#121 y --- */
      { 121,53236,                      /* character number, location */
         11, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          { 11,   16, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x94\x70\x84\x33\x8c\x61\x86\x31\x8c\x61\x0c\x63"
            "\x0c\x7e\x00\x23\x8c\x61\x84\xc1\x03" }  },
      /* --- pixel bitmap for cmmi180 char#122 z --- */
      { 122,54148,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x70\xc4\x1f\x41\x00\x01\x04\x10\x40\x00\x41\x04\xf1"
            "\x4f\x38\x00" }  },
      /* --- pixel bitmap for cmmi180 char#123 \imath --- */
      { 123,96127,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x96\x65\x0c\x63\x98\xa6\xc5\x00" }  },
      /* --- pixel bitmap for cmmi180 char#124 \jmath --- */
      { 124,96932,                      /* character number, location */
         11,-1,   -5,-1,      /* topleft row,col, and botleft row,col */
          { 10,   16, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x63\x61\x22\xf1\x41\x32\x82\xf3\x72\x10\xf3\x62\x20"
            "\x11\x32\x32\x22\x54\x50" }  },
      /* --- pixel bitmap for cmmi180 char#125 \wp --- */
      { 125,98059,                      /* character number, location */
         12, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 15,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x00\x0c\x0f\x66\x8c\x09\xc4\x02\xe6\x00\x3b\xc0"
            "\x1c\x60\x06\x30\x47\x8c\x27\x43\xf3\x20\x03\x90\x01"
            "\x64\x00\x32\x00\x09\x00\x03\x00" }  },
      /* --- pixel bitmap for cmmi180 char#126 \vec --- */
      { 126,98703,                      /* character number, location */
         17, 5,   14, 5,      /* topleft row,col, and botleft row,col */
          { 10,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\xfd\x0f\x08" }  },
      /* --- pixel bitmap for cmmi180 char#127 (noname) --- */
      { 127,99239,                      /* character number, location */
         16, 6,   14, 6,      /* topleft row,col, and botleft row,col */
          { 10,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x19\x08" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=6 for .210gf ---
 * mf '\mode=preview; mag=magstep(-13.80488502080647873125); input cmmi10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmmi210 --- */
static	chardef  cmmi210[] =
   {
      /* --- pixel bitmap for cmmi210 char#0 \Gamma --- */
      {   0,55957,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 20,   20, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x01\x82\x82\xf2\x72\x92\x72\x91\x72\xa1\x10\xf2"
            "\x62\xc0\xf3\x52\xd0\xf3\x42\xe0\x32\xe0\x19\xb3" }  },
      /* --- pixel bitmap for cmmi210 char#1 \Delta --- */
      {   1,56876,                      /* character number, location */
         21, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 22,   21, 3,90, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\xe0\x12\x50\xe3\xe0\x41\x13\x40\xf1\xc1\x32\x40"
            "\xb1\x42\xe1\x53\xc2\x62\xc1\x72\xb1\x82\xa1\x93\x82"
            "\xa2\x81\xb2\x71\xc2\x61\xd2\x61\xe2\x41\xe0\x12\x31"
            "\xe0\x22\x2e\x06\x2e\x07" }  },
      /* --- pixel bitmap for cmmi210 char#2 \Theta --- */
      {   2,58071,                      /* character number, location */
         21, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 20,   22, 3,95, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa5\xd2\x52\x92\x82\x72\xa2\x52\xb2\x42\xd2\xf1\x22"
            "\xe2\x12\xe0\x12\x12\x31\x71\x32\x12\x39\x34\x39\x32"
            "\x12\x31\x71\x32\x12\xe0\x12\x1f\x12\xe2\x22\xd2\x42"
            "\xb2\x52\xa2\x72\x82\x92\x52\xd5\xa0" }  },
      /* --- pixel bitmap for cmmi210 char#3 \Lambda --- */
      {   3,59055,                      /* character number, location */
         21, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   21, 3,84, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\xd2\x30\xf1\xc3\x30\xf1\xb1\x12\x30\xf1\xa1\x22"
            "\x30\x91\x32\x30\xf1\x81\x42\x30\x71\x52\xa1\x53\x81"
            "\x63\x81\x72\x20\xf1\x51\x82\x20\x41\x92\x51\xa2\x42"
            "\xa2\x26\x57" }  },
      /* --- pixel bitmap for cmmi210 char#4 \Xi --- */
      {   4,60530,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 22,   20, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x5e\x03\xf2\x41\xe0\x11\x10\xf2\xe0\x80\x61\x91"
            "\xbb\xab\xb1\x91\x60\xf2\xe0\x80\xf2\x11\xe0\x11\x4f"
            "\x1e\x03\x52" }  },
      /* --- pixel bitmap for cmmi210 char#5 \Pi --- */
      {   5,61747,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 25,   20, 3,51, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x06\x82\xa2\x30\xf3\x72\xa2\x40\xf3\x62\xa2\x50"
            "\xf3\x52\xa2\x60\xf3\x42\xa2\x70\x32\xa2\x88\x48\x5f" }  },
      /* --- pixel bitmap for cmmi210 char#6 \Sigma --- */
      {   6,62946,                      /* character number, location */
         20, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 21,   20, 3,77, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x02\x53\xa3\xf1\x62\xb2\x72\xa2\x72\xa1\x83\x91"
            "\x92\xe0\x53\xa0\xf1\x92\xa0\x91\xe0\x42\xe0\x41\xb1"
            "\x71\xb1\x71\xc1\x61\xc1\x61\xc2\x51\xb4\x4e\x02\x52" }  },
      /* --- pixel bitmap for cmmi210 char#7 \Upsilon --- */
      {   7,63996,                      /* character number, location */
         21, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   21, 3,61, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x34\x74\x36\x56\x12\x42\x31\x51\x11\x61\x21\x62\x71"
            "\x21\x61\xf1\x81\x11\x80\xf3\x82\x90\xf3\x72\xa0\xf3"
            "\x62\xb0\x52\xda\x81" }  },
      /* --- pixel bitmap for cmmi210 char#8 \Phi --- */
      {   8,65068,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   20, 3,85, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7a\xc2\x50\xf1\xa2\x60\x77\x92\x32\x13\x52\x42\x42"
            "\x32\x52\x42\x10\xf1\x12\x62\x52\x0f\x12\x62\x52\x10"
            "\x12\x52\x42\x32\x52\x32\x53\x22\x22\x97\x70\xf1\x72"
            "\x90\x62\xca\x62" }  },
      /* --- pixel bitmap for cmmi210 char#9 \Psi --- */
      {   9,66173,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   20, 3,83, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6a\xd2\x70\xf1\x92\x82\x72\x53\x12\x62\x42\x32\x52"
            "\x52\x20\xf2\x12\x52\x42\x30\xf1\x12\x42\x42\x40\x12"
            "\x42\x32\x71\x42\x22\x83\x12\x22\xb6\x90\xf1\x62\xb0"
            "\x52\xda\x8a" }  },
      /* --- pixel bitmap for cmmi210 char#10 \Omega --- */
      {  10,67410,                      /* character number, location */
         21, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 21,   21, 3,91, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb5\xd3\x52\xa2\x91\x82\xa2\x62\xb2\x52\xd1\x52\xd2"
            "\xf2\x32\xd2\x10\x32\xc2\x52\xc1\x71\xb2\x72\x92\x82"
            "\x82\xa1\x81\x61\x41\x71\x41\x21\x41\x62\x41\x21\x41"
            "\x61\x41\x36\x57\x36\x56\x42" }  },
      /* --- pixel bitmap for cmmi210 char#11 \alpha --- */
      {  11,68476,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x07\x60\x18\x62\x60\x64\xc0\x64\x80\xc9\x00\x8f"
            "\x01\x9c\x01\x18\x03\x30\x04\x70\x18\xd0\x60\x98\x85"
            "\x0f\x0e" }  },
      /* --- pixel bitmap for cmmi210 char#12 \beta --- */
      {  12,69539,                      /* character number, location */
         20, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 15,   26, 3,85, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x94\xa1\x41\x81\x52\x61\x62\x51\x72\x51\x71\x51\x72"
            "\x51\x26\x61\x25\x71\x62\x20\xf3\x31\x82\x10\xf1\x21"
            "\x82\x20\x21\x72\x52\x61\x51\x11\x42\x61\x25\x60\xf1"
            "\x11\xdf\x31\xe7" }  },
      /* --- pixel bitmap for cmmi210 char#13 \gamma --- */
      {  13,70504,                      /* character number, location */
         13, 0,   -7, 0,      /* topleft row,col, and botleft row,col */
          { 15,   20, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x44\x61\x27\x51\x13\x33\x31\x21\x71\x31\x11\x81\x31"
            "\x10\xf2\xa1\x11\x20\xf2\xa2\x30\xf3\xa1\x40\xf3\x91"
            "\x50\x81\x61" }  },
      /* --- pixel bitmap for cmmi210 char#14 \delta --- */
      {  14,71475,                      /* character number, location */
         21, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   21, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x01\xfc\x20\x0c\x02\x60\x00\x04\xc0\x00\x18\xc0"
            "\x03\x33\x18\xc7\x60\x06\x66\x60\x06\x36\x30\x03\x23"
            "\x30\x86\xc1\x08\x78\x00" }  },
      /* --- pixel bitmap for cmmi210 char#15 \epsilon --- */
      {  15,72353,                      /* character number, location */
         13, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 10,   13, 3,25, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x55\x32\x72\x72\x72\x88\x2f\x42\x80\x12\x51\x45\x22" }  },
      /* --- pixel bitmap for cmmi210 char#16 \zeta --- */
      {  16,73265,                      /* character number, location */
         20, 2,   -6, 2,      /* topleft row,col, and botleft row,col */
          { 12,   26, 3,53, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x71\x40\x75\x66\x51\xa1\xa2\x92\xa1\xa2\xa1\xaf"
            "\x62\xa0\x13\xa5\x85\xa3\x30\xf1\x81\x30\x31\x32\x74"
            "\x42" }  },
      /* --- pixel bitmap for cmmi210 char#17 \eta --- */
      {  17,74166,                      /* character number, location */
         13, 1,   -7, 1,      /* topleft row,col, and botleft row,col */
          { 14,   20, 3,63, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x22\x45\x21\x12\x21\x42\x11\x23\x53\x23\x63\x22\x72"
            "\xf1\x32\x72\xf3\x22\x72\x10\xf1\x12\x72\x20\xf1\xa2"
            "\x20\xf3\x92\x30\x91\x41" }  },
      /* --- pixel bitmap for cmmi210 char#18 \theta --- */
      {  18,74948,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   20, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x03\x46\x30\x84\xc1\x08\xcc\xc0\x0c\x6c\xc0\x06"
            "\xec\xff\xff\x37\x60\x03\x36\x30\x03\x33\x10\x83\x21"
            "\x0c\x62\xc0\x01" }  },
      /* --- pixel bitmap for cmmi210 char#19 \iota --- */
      {  19,75607,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x18\x18\x0c\x0c\x0c\x0c\x06\x86\x86\x43\x23\x1e" }  },
      /* --- pixel bitmap for cmmi210 char#20 \kappa --- */
      {  20,76521,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x70\x0c\x3e\xc6\x8c\x11\xc0\x04\xe0\x01\xf0\x0f"
            "\x0c\x0c\x06\x46\x03\xa3\x81\x71\xc0\x34\xc0\x01" }  },
      /* --- pixel bitmap for cmmi210 char#21 \lambda --- */
      {  21,77366,                      /* character number, location */
         20, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 14,   20, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x00\x18\x00\x06\x00\x03\xc0\x00\x70\x00\x18\x00"
            "\x06\x80\x03\xc0\x00\x30\x00\x1e\x40\x06\x98\x01\xc3"
            "\x60\x30\x0c\x8c\x01\x36\x80\x05\xc0" }  },
      /* --- pixel bitmap for cmmi210 char#22 \mu --- */
      {  22,78386,                      /* character number, location */
         13, 0,   -7, 0,      /* topleft row,col, and botleft row,col */
          { 17,   20, 3,69, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf2\x52\x72\x10\xf3\x42\x72\x20\x32\x72\x30\xf1\x32"
            "\x72\x21\x32\x63\x21\x24\x41\x12\x11\x32\x15\x33\x10"
            "\xf1\x22\xd0\xf3\x12\xe0\x11\xe0\x12" }  },
      /* --- pixel bitmap for cmmi210 char#23 \nu --- */
      {  23,79175,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\x60\x0c\x30\x06\x98\x01\xc6\x00\x63\xc0\x30\x30"
            "\x0c\x0c\x06\x03\xc3\x80\x19\x60\x07\x70\x00\x00" }  },
      /* --- pixel bitmap for cmmi210 char#24 \xi --- */
      {  24,80307,                      /* character number, location */
         20, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 12,   26, 3,65, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x71\x40\x75\x52\x14\x42\x92\x70\xf2\x22\x80\x31"
            "\x80\xf1\x37\x20\x22\x80\xf1\x12\x9f\x22\xa3\xa4\x96"
            "\x94\xa3\xa2\x61\x32\x74\x31" }  },
      /* --- pixel bitmap for cmmi210 char#25 \pi --- */
      {  25,81259,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x7f\xfe\xbf\x11\x41\xc4\x00\x22\x00\x11\xc0\x08"
            "\x20\x04\x10\x02\x0c\x03\x86\x81\xc1\xc0\x60\x00" }  },
      /* --- pixel bitmap for cmmi210 char#26 \rho --- */
      {  26,82109,                      /* character number, location */
         13, 0,   -7, 0,      /* topleft row,col, and botleft row,col */
          { 15,   20, 3,63, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x93\xa2\x32\x72\x51\x62\x62\xf2\x42\x72\xf1\x32\x72"
            "\x10\x32\x62\x52\x61\x52\x11\x32\x62\x24\x50\xf1\x22"
            "\xb0\xf3\x12\xc0\x11\xd4" }  },
      /* --- pixel bitmap for cmmi210 char#27 \sigma --- */
      {  27,83027,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   13, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6a\x4c\x33\x42\x62\x72\x30\xf2\x12\x82\x3f\x12\x82"
            "\x40\x11\x72\x62\x61\x81\x42\xa4\x92" }  },
      /* --- pixel bitmap for cmmi210 char#28 \tau --- */
      {  28,83798,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   13, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3b\x2c\x12\x41\x71\x51\x60\xf1\x62\x60\xf1\x61\x70"
            "\xf2\x52\x70\xf1\x42\x81" }  },
      /* --- pixel bitmap for cmmi210 char#29 \upsilon --- */
      {  29,84703,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x20\x19\xb8\x0c\x28\x06\x94\x01\xc2\x00\x61\x80"
            "\x18\x20\x0c\x10\x06\x04\x03\x01\x43\x00\x1e\x00" }  },
      /* --- pixel bitmap for cmmi210 char#30 \phi --- */
      {  30,85585,                      /* character number, location */
         20, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 17,   26, 3,91, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf3\xb1\x50\xf2\xa1\x60\x76\x92\x21\x32\x52\x41\x42"
            "\x32\x51\x51\x31\x61\x52\xf1\x12\x51\x62\x02\x61\x52"
            "\x21\x61\x52\x22\x41\x52\x41\x41\x42\x62\x21\x22\x96"
            "\x70\xf3\x61\xa0\xf1\x51\xb2" }  },
      /* --- pixel bitmap for cmmi210 char#31 \chi --- */
      {  31,86646,                      /* character number, location */
         13, 0,   -6, 0,      /* topleft row,col, and botleft row,col */
          { 17,   19, 3,77, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x33\xa1\x21\x22\x81\x62\x81\x63\x61\x82\x51\x93\x31"
            "\xb2\x21\xc2\x11\xd3\xe0\x12\xe3\xe4\xc1\x22\xb1\x32"
            "\xa1\x52\x81\x62\x71\x73\x21\x21\x92\x21\x11\xb3\x26" }  },
      /* --- pixel bitmap for cmmi210 char#32 \psi --- */
      {  32,87737,                      /* character number, location */
         20, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 18,   26, 3,107, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\xf2\xc1\x50\xf3\xb1\x60\x23\x51\x51\x21\x22\x41\x52"
            "\x11\x22\x41\x51\x11\x32\x41\x51\x11\x22\x41\x61\x10"
            "\xf1\x32\x41\x61\x10\x22\x51\x51\x42\x41\x61\x42\x41"
            "\x51\x62\x31\x41\x82\x21\x22\xa6\x70\xf2\x71\xa0\xf2"
            "\x61\xb0" }  },
      /* --- pixel bitmap for cmmi210 char#33 \omega --- */
      {  33,88838,                      /* character number, location */
         13, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 18,   13, 3,53, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x32\xb1\x41\xc2\xf1\x21\xd1\x10\xf2\x11\x62\x61\x1f"
            "\x12\x52\x61\x22\x52\x51\x42\x26\x13\x46\x16\x63\x44"
            "\x51" }  },
      /* --- pixel bitmap for cmmi210 char#34 \varepsilon --- */
      {  34,89829,                      /* character number, location */
         14, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 11,   15, 3,39, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x54\x58\x22\x52\x21\x80\xf1\x11\x90\xf1\x25\x40\x11"
            "\x9f\x21\xa2\x61\x37\x55\x42" }  },
      /* --- pixel bitmap for cmmi210 char#35 \vartheta --- */
      {  35,90838,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   20, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x1c\x80\x11\x40\x08\x10\x0c\x08\x06\x04\x03\x82"
            "\x19\xc2\x1a\x66\x19\x7c\x06\x2c\x03\x86\x01\xc3\xc0"
            "\x30\x60\x18\x10\x0c\x0c\x06\x03\xc6\x00\x1e\x00" }  },
      /* --- pixel bitmap for cmmi210 char#36 \varpi --- */
      {  36,92101,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 22,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\xff\x3f\xff\xff\x6f\x02\x00\x49\x00\x40\x10\x08"
            "\x10\x02\x02\x84\xc0\x00\x11\x30\x20\x04\x0e\x08\x81"
            "\x02\xc1\x98\x31\xe0\xe3\x07\x78\xf0\x00" }  },
      /* --- pixel bitmap for cmmi210 char#37 \varrho --- */
      {  37,93024,                      /* character number, location */
         13, 2,   -6, 2,      /* topleft row,col, and botleft row,col */
          { 13,   19, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x73\x82\x32\x52\x51\x42\x62\xf2\x22\x72\xf1\x12\x72"
            "\x10\x12\x62\x33\x51\x31\x21\x32\x41\x34\x5f\x21\xc8"
            "\x77\xc1\x41" }  },
      /* --- pixel bitmap for cmmi210 char#38 \varsigma --- */
      {  38,93861,                      /* character number, location */
         13, 2,   -3, 2,      /* topleft row,col, and botleft row,col */
          { 10,   16, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x55\x32\x41\x21\x82\x7f\x32\x83\x84\x74\x84\x20\xf1"
            "\x62\x20\x61\x63\x41" }  },
      /* --- pixel bitmap for cmmi210 char#39 \varphi --- */
      {  39,94800,                      /* character number, location */
         13, 2,   -7, 2,      /* topleft row,col, and botleft row,col */
          { 16,   20, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x38\x04\x7e\x02\xc3\x02\x81\x81\x80\x81\x80\x41"
            "\x80\x41\x40\x41\x60\x23\x30\x2e\x1c\xfc\x0f\xf0\x03"
            "\x30\x00\x10\x00\x10\x00\x18\x00\x18\x00\x18\x00\x08"
            "\x00" }  },
      /* --- pixel bitmap for cmmi210 char#40 \leftharpoonup --- */
      {  40,110784,                     /* character number, location */
         15, 2,    6, 2,      /* topleft row,col, and botleft row,col */
          { 25,    9, 3,36, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x62\xe0\x30\xf1\x52\xe0\x40\x42\xe0\x83\xe0\x73"
            "\xe0\x7e\x0e\x0e\x07" }  },
      /* --- pixel bitmap for cmmi210 char#41 \leftharpoondown --- */
      {  41,111816,                     /* character number, location */
          8, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 25,    9, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x0b\x1e\x0a\x23\xe0\x93\xe0\x92\xe0\x50\xf1\x52"
            "\xe0\x40\xf1\x62\xe0\x31" }  },
      /* --- pixel bitmap for cmmi210 char#42 \rightharpoonup --- */
      {  42,112846,                     /* character number, location */
         15, 2,    6, 2,      /* topleft row,col, and botleft row,col */
          { 25,    9, 3,34, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\xe0\x32\x60\xf1\xe0\x42\x50\xe0\x52\xe0\x93\xe0"
            "\x93\x2f\x1e\x0b" }  },
      /* --- pixel bitmap for cmmi210 char#43 \rightharpoondown --- */
      {  43,113879,                     /* character number, location */
          8, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 25,    9, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x0e\x0b\xe0\x63\xe0\x73\xe0\x82\x40\xf1\xe0\x42"
            "\x50\xf1\xe0\x32\x60" }  },
      /* --- pixel bitmap for cmmi210 char#44 ` --- */
      {  44,114304,                     /* character number, location */
         14, 2,    6, 2,      /* topleft row,col, and botleft row,col */
          {  4,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x33\x33\xef" }  },
      /* --- pixel bitmap for cmmi210 char#45 ' --- */
      {  45,114728,                     /* character number, location */
         14, 2,    6, 2,      /* topleft row,col, and botleft row,col */
          {  4,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf7\xcc\xcc\x7f" }  },
      /* --- pixel bitmap for cmmi210 char#46 \triangleright --- */
      {  46,115269,                     /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   14, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\xb4\x96\x72\x23\x62\x34\x42\x54\x2f\x12\x74\x02"
            "\x54\x22\x34\x42\x23\x66\x74\x92\xb4" }  },
      /* --- pixel bitmap for cmmi210 char#47 \triangleleft --- */
      {  47,115837,                     /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   14, 3,42, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb2\x94\x76\x54\x22\x43\x42\x24\x52\x0f\x14\x72\x24"
            "\x52\x43\x42\x54\x22\x76\x94\xb2" }  },
      /* --- pixel bitmap for cmmi210 char#48 \0 --- */
      {  48,101197,                     /* character number, location */
         14, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 13,   15, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\x62\x52\x32\x72\x21\x91\x1f\x62\x92\x11\x91\x22"
            "\x72\x32\x52\x65\x41" }  },
      /* --- pixel bitmap for cmmi210 char#49 \1 --- */
      {  49,101980,                     /* character number, location */
         14, 3,    0, 3,      /* topleft row,col, and botleft row,col */
          { 10,   14, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x51\x46\x40\xfa\x42\x4a" }  },
      /* --- pixel bitmap for cmmi210 char#50 \2 --- */
      {  50,102954,                     /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   14, 3,41, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\x62\x52\x32\x72\x10\xf1\x13\x72\xb2\xb1\xb2\x92"
            "\x93\x92\x51\x32\x71\x1b\x1c\x13" }  },
      /* --- pixel bitmap for cmmi210 char#51 \3 --- */
      {  51,103989,                     /* character number, location */
         14, 1,   -7, 1,      /* topleft row,col, and botleft row,col */
          { 13,   21, 3,65, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\x71\x52\x41\x71\x20\xf1\x13\x62\x10\x21\x72\xb1"
            "\xb2\xa2\x75\xd2\xc2\xc1\xc2\x11\x92\x0f\x13\x82\x01"
            "\xa1\x21\x82\x32\x52\x65\x41" }  },
      /* --- pixel bitmap for cmmi210 char#52 \4 --- */
      {  52,104936,                     /* character number, location */
         14, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 13,   20, 3,56, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x82\x30\x73\x94\x91\x12\x81\x22\x72\x22\x71\x32"
            "\x61\x42\x52\x42\x51\x52\x41\x62\x32\x62\x3d\xf4\x82"
            "\x30\x58" }  },
      /* --- pixel bitmap for cmmi210 char#53 \5 --- */
      {  53,105989,                     /* character number, location */
         14, 1,   -7, 1,      /* topleft row,col, and botleft row,col */
          { 13,   21, 3,67, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x22\x52\x48\x51\x14\x50\xf3\x21\xa0\x21\x24\x61\x11"
            "\x42\x42\x62\x31\x72\x10\xf2\xb2\x0f\x13\x82\x02\x92"
            "\x11\x82\x21\x81\x42\x42\x75\x42" }  },
      /* --- pixel bitmap for cmmi210 char#54 \6 --- */
      {  54,106908,                     /* character number, location */
         20, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 13,   21, 3,67, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x64\x72\x41\x52\x43\x32\x53\x31\xb2\xb1\xb2\x34\x42"
            "\x12\x41\x33\x71\x23\x72\x1f\x32\x92\x11\x92\x12\x82"
            "\x12\x72\x31\x71\x52\x41\x75\x42" }  },
      /* --- pixel bitmap for cmmi210 char#55 \7 --- */
      {  55,107837,                     /* character number, location */
         14, 2,   -7, 2,      /* topleft row,col, and botleft row,col */
          { 13,   21, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x11\xcc\x1b\x21\x91\x11\x91\x21\x81\x30\xf1\x81\x40"
            "\x71\x50\xf1\x61\x60\xf1\x52\x60\xf2\x42\x70\xf3\x33"
            "\x70\x41\x81" }  },
      /* --- pixel bitmap for cmmi210 char#56 \8 --- */
      {  56,108770,                     /* character number, location */
         20, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 13,   21, 3,65, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\x72\x32\x52\x52\x20\xf2\x12\x72\x10\x13\x62\x33"
            "\x42\x53\x22\x74\x95\x62\x43\x32\x63\x21\x83\x0f\x32"
            "\x92\x12\x72\x32\x52\x65\x45" }  },
      /* --- pixel bitmap for cmmi210 char#57 \9 --- */
      {  57,109697,                     /* character number, location */
         14, 1,   -7, 1,      /* topleft row,col, and botleft row,col */
          { 13,   21, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x01\x41\x10\x10\x03\x36\xc0\x06\xd0\x00\x1e\xc0"
            "\x03\x78\x00\x1b\x70\x02\x8e\xb0\xe1\x31\x00\x02\x60"
            "\x00\xcc\xc1\x38\x08\xc2\x80\x0f\x00" }  },
      /* --- pixel bitmap for cmmi210 char#58 . --- */
      {  58,116334,                     /* character number, location */
          3, 3,    0, 3,      /* topleft row,col, and botleft row,col */
          {  3,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x00" }  },
      /* --- pixel bitmap for cmmi210 char#59 , --- */
      {  59,116895,                     /* character number, location */
          3, 3,   -6, 3,      /* topleft row,col, and botleft row,col */
          {  3,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x49\x4a\x01" }  },
      /* --- pixel bitmap for cmmi210 char#60 < --- */
      {  60,117559,                     /* character number, location */
         16, 2,   -2, 2,      /* topleft row,col, and botleft row,col */
          { 19,   18, 3,58, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x32\xe0\x14\xd4\xd4\xc5\xc5\xc4\xd4\xdf\x14\xe0"
            "\x10\x24\xe0\x34\xe0\x35\xe0\x25\xe0\x34\xe0\x34\xe0"
            "\x34\xe0\x32" }  },
      /* --- pixel bitmap for cmmi210 char#61 / --- */
      {  61,118097,                     /* character number, location */
         22, 2,   -7, 2,      /* topleft row,col, and botleft row,col */
          { 11,   29, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x06\x30\xc0\x01\x06\x30\xc0\x01\x06\x30\xc0\x01"
            "\x06\x30\xc0\x01\x06\x30\xc0\x01\x06\x30\xc0\x01\x06"
            "\x30\xc0\x01\x06\x30\xc0\x01\x06\x30\xc0\x01\x06\x30"
            "\x00" }  },
      /* --- pixel bitmap for cmmi210 char#62 > --- */
      {  62,118804,                     /* character number, location */
         16, 2,   -2, 2,      /* topleft row,col, and botleft row,col */
          { 19,   18, 3,59, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\xe0\x34\xe0\x34\xe0\x34\xe0\x35\xe0\x25\xe0\x34"
            "\xe0\x34\x20\xf1\xe0\x14\xd4\xd4\xc5\xc5\xc4\xd4\xd4"
            "\xe0\x12\xe0\x32" }  },
      /* --- pixel bitmap for cmmi210 char#63 \star --- */
      {  63,119517,                     /* character number, location */
         15,-1,   -1,-1,      /* topleft row,col, and botleft row,col */
          { 17,   16, 3,41, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf5\x81\x84\x41\x44\x3b\x87\xc3\xd2\x12\xc1\x31\xb2"
            "\x32\x92\x52\x81\x71\x71\x91\x34" }  },
      /* --- pixel bitmap for cmmi210 char#64 \partial --- */
      {  64,95804,                      /* character number, location */
         21, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 16,   22, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x0f\x40\x10\x20\x20\x70\x60\x70\x40\x00\xc0\x00"
            "\xc0\x80\xc7\x60\xd8\x10\xd0\x08\xe0\x0c\x60\x06\x60"
            "\x06\x60\x06\x20\x03\x30\x03\x10\x03\x18\x02\x0c\x06"
            "\x04\x0c\x03\xf8\x00" }  },
      /* --- pixel bitmap for cmmi210 char#65 A --- */
      {  65, 1026,                      /* character number, location */
         21, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 20,   21, 3,88, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\xe2\x40\xf1\xd3\x40\xc1\x12\xe0\x12\x12\xe0\x11"
            "\x22\xe1\x32\xe1\x42\x30\xf1\x91\x52\x30\x81\x62\xa1"
            "\x72\xaa\x30\xf1\x61\x82\x30\x51\x92\x30\xf1\x41\xa2"
            "\x30\x32\xa3\x27\x58" }  },
      /* --- pixel bitmap for cmmi210 char#66 B --- */
      {  66, 2400,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 21,   20, 3,71, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5d\xb2\x73\x10\xf3\x72\xa2\x62\xa2\x72\x92\x82\x82"
            "\x9b\x92\x92\x30\xf1\x52\xa2\x20\x52\xb2\x10\xf1\x42"
            "\xb2\x20\x42\xa2\x72\x93\x62\x92\x5e\x70" }  },
      /* --- pixel bitmap for cmmi210 char#67 C --- */
      {  67, 3385,                      /* character number, location */
         21, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 20,   22, 3,81, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa5\x41\x82\x51\x22\x62\x81\x12\x52\xa2\x52\xb2\x42"
            "\xc2\x32\xd2\x32\xd1\x20\xf2\x12\xe0\x3f\x22\xe0\x42"
            "\xe1\x3f\x12\xd1\x40\x11\xc1\x62\xa1\x82\x81\xa2\x52"
            "\xd5\xa2" }  },
      /* --- pixel bitmap for cmmi210 char#68 D --- */
      {  68, 4571,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 22,   20, 3,63, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5d\xc2\x73\x92\xa1\x92\xa2\x82\xb1\x82\xb2\xf3\x62"
            "\xc2\xf2\x52\xc2\x10\x52\xb2\x62\xc2\x62\xb2\x72\xa2"
            "\x82\x92\x82\x82\x7d\x91" }  },
      /* --- pixel bitmap for cmmi210 char#69 E --- */
      {  69, 6036,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 21,   20, 3,83, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x02\x82\x83\xf2\x72\xa2\x72\xa1\x72\x61\x41\x10"
            "\xf1\x62\x61\x60\x69\x60\xf1\x52\x61\x70\x52\x61\x51"
            "\x62\xb1\x20\xf1\x42\xc1\x20\x42\xb1\x72\xa2\x62\xa3"
            "\x3e\x03\x43" }  },
      /* --- pixel bitmap for cmmi210 char#70 F --- */
      {  70, 7309,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 21,   20, 3,65, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x02\x82\x83\xf2\x72\xa2\x72\xa1\x72\x61\x41\x10"
            "\xf1\x62\x61\x60\x69\x60\xf2\x52\x61\x70\x52\xe0\xf3"
            "\x42\xe0\x10\x32\xe0\x29\xc0" }  },
      /* --- pixel bitmap for cmmi210 char#71 G --- */
      {  71, 8504,                      /* character number, location */
         21, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 21,   22, 3,87, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa6\x41\x82\x61\x22\x62\x91\x12\x52\xb2\x52\xc2\x42"
            "\xd2\x41\xe2\x32\xe1\x20\xf2\x12\xe0\x42\xe0\x52\xa8"
            "\x1f\x12\xe2\x32\xd2\x51\xd2\x52\xc2\x52\xb3\x62\xa2"
            "\x82\x63\x11\xa6\xa8" }  },
      /* --- pixel bitmap for cmmi210 char#72 H --- */
      {  72, 9751,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 25,   20, 3,55, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x58\x48\x82\xa2\x30\xf3\x72\xa2\x40\xf2\x62\xa2\x50"
            "\x6e\x50\xf3\x52\xa2\x60\xf3\x42\xa2\x70\x32\xa2\x88"
            "\x48\x52" }  },
      /* --- pixel bitmap for cmmi210 char#73 I --- */
      {  73,10520,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   20, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x58\x82\x30\xf3\x72\x40\xf3\x62\x50\xf3\x52\x60\xf3"
            "\x42\x70\x32\x88\x52" }  },
      /* --- pixel bitmap for cmmi210 char#74 J --- */
      {  74,11380,                      /* character number, location */
         20, 3,   -1, 3,      /* topleft row,col, and botleft row,col */
          { 16,   21, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x88\xc2\x20\xf3\xb2\x30\xf3\xa2\x40\xf3\x92\x50\x82"
            "\x71\x62\x63\x52\x62\x52\x71\x62\x81\x32\xb4\xa2" }  },
      /* --- pixel bitmap for cmmi210 char#75 K --- */
      {  75,12621,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 25,   20, 3,101, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x58\x57\x82\xa2\xa2\xa2\xb2\x91\xd2\x81\xe2\x61\xe0"
            "\x12\x61\xe0\x22\x51\xe0\x32\x33\xe0\x32\x21\x12\xe0"
            "\x22\x21\x32\xe0\x12\x11\x42\xa0\xf1\x52\x72\x90\xf1"
            "\x42\x92\x80\xf1\x42\xa2\x70\x32\xb3\x68\x67\x40" }  },
      /* --- pixel bitmap for cmmi210 char#76 L --- */
      {  76,13618,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   20, 3,53, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x59\xc2\x80\xf3\x72\x90\xf3\x62\xa0\xf2\x52\xb0\x52"
            "\xa1\xf1\x42\xa1\x10\x42\x91\x62\x82\x52\x74\x2e\x01"
            "\x32" }  },
      /* --- pixel bitmap for cmmi210 char#77 M --- */
      {  77,14956,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 30,   20, 3,141, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x56\xd6\x83\xd3\xa1\x12\xc3\x40\xf1\x71\x12\xb1\x12"
            "\x40\x71\x12\xa1\x22\xa1\x22\x91\x22\xb1\x32\x81\x22"
            "\xb1\x32\x71\x32\xb1\x32\x61\x42\xa1\x42\x61\x32\xb1"
            "\x42\x51\x42\xb1\x42\x41\x52\xb1\x52\x31\x52\xa1\x62"
            "\x21\x52\x70\xf1\x41\x62\x11\x62\x70\x41\x63\x72\xa2"
            "\x62\x72\x87\x42\x48\x50" }  },
      /* --- pixel bitmap for cmmi210 char#78 N --- */
      {  78,16182,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 25,   20, 3,107, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x55\x87\x82\xa2\x30\xf1\x71\x12\x91\x40\xf1\x71\x22"
            "\x81\x40\x61\x32\x71\x50\xf1\x61\x42\x61\x50\x61\x52"
            "\x51\xa1\x62\x41\x60\xf1\x51\x72\x31\x60\x51\x81\x31"
            "\x60\xf1\x41\x92\x11\x70\xf1\x41\xa3\x70\x32\xb1\x87"
            "\x91\x82" }  },
      /* --- pixel bitmap for cmmi210 char#79 O --- */
      {  79,17117,                      /* character number, location */
         21, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 20,   22, 3,73, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa5\xd2\x52\x92\x82\x72\xa2\x52\xc1\x42\xd2\xf1\x22"
            "\xe2\xf2\x12\xe0\x12\x0f\x22\xe0\x12\x1f\x12\xe2\x22"
            "\xd2\x42\xb2\x52\xa2\x72\x82\x92\x52\xd5\xa1" }  },
      /* --- pixel bitmap for cmmi210 char#80 P --- */
      {  80,18252,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 21,   20, 3,59, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5d\xb2\x73\x82\x92\x10\xf2\x72\xa2\xf1\x62\xa2\x10"
            "\x62\x92\x82\x73\x8a\x60\xf2\x52\xe0\xf3\x42\xe0\x10"
            "\x32\xe0\x28\xd2" }  },
      /* --- pixel bitmap for cmmi210 char#81 Q --- */
      {  81,19299,                      /* character number, location */
         21, 2,   -6, 2,      /* topleft row,col, and botleft row,col */
          { 20,   27, 3,105, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\xa5\xd2\x52\x92\x82\x72\xa2\x52\xb2\x42\xd2\xf1\x22"
            "\xe2\xf2\x12\xe0\x12\x0f\x22\xe0\x12\x1f\x12\xe2\x22"
            "\xd2\x42\x43\x42\x52\x31\x31\x22\x72\x11\x41\x12\x93"
            "\x42\x41\x86\x51\xd1\x42\xd1\x41\xe1\x32\xe5\xe0\x23"
            "\x61" }  },
      /* --- pixel bitmap for cmmi210 char#82 R --- */
      {  82,20686,                      /* character number, location */
         20, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 21,   21, 3,83, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\xc2\x63\x92\x82\x20\xf2\x72\x92\x10\x62\x92\x82"
            "\x82\x92\x63\xa9\xb2\x72\xa2\x81\x50\xf1\x52\x82\x40"
            "\xf2\x42\x82\x50\x42\x82\x41\x32\x92\x31\x18\x62\x21"
            "\xe0\x33\x36" }  },
      /* --- pixel bitmap for cmmi210 char#83 S --- */
      {  83,21809,                      /* character number, location */
         21, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 17,   22, 3,75, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x85\x31\x72\x41\x21\x61\x73\x52\x72\x10\xf2\x42\x91"
            "\x10\xf1\x42\xb0\x45\xd7\xd5\x40\xf2\xb2\x40\xf2\x11"
            "\x92\x40\x11\x82\x53\x71\x61\x21\x42\x71\x35\x82" }  },
      /* --- pixel bitmap for cmmi210 char#84 T --- */
      {  84,22905,                      /* character number, location */
         20, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 20,   20, 3,65, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\x03\x23\x62\x52\x21\x72\x62\x21\x72\x71\x11\x82"
            "\x71\x11\x82\x61\x11\x82\x71\x10\xf2\x92\x90\xf3\x82"
            "\xa0\xf3\x72\xb0\x62\xea\x81" }  },
      /* --- pixel bitmap for cmmi210 char#85 U --- */
      {  85,23919,                      /* character number, location */
         20, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 21,   21, 3,61, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x57\x42\xa2\x30\xf3\x32\xb1\x40\xf3\x22\xb1\x50"
            "\xf3\x12\xb1\x6f\x12\xb1\x70\x11\xa1\x92\x81\xa2\x71"
            "\xc2\x51\xe0\x15\xc2" }  },
      /* --- pixel bitmap for cmmi210 char#86 V --- */
      {  86,24867,                      /* character number, location */
         20, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 20,   21, 3,89, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07\x76\x22\xc2\x42\xc1\x52\xb1\x40\xf1\x22\xa1\x50"
            "\xf1\x32\x81\x60\x32\x71\x70\xf1\x32\x61\x80\x32\x51"
            "\xc2\x42\xc2\x41\xd3\x21\xe0\x12\x21\xe0\x12\x11\xc0"
            "\xf1\x43\xd0\xf1\x42\xe2" }  },
      /* --- pixel bitmap for cmmi210 char#87 W --- */
      {  87,26276,                      /* character number, location */
         20, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 29,   21, 3,139, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x08\x47\x46\x32\x93\x82\x52\x83\x91\x62\x81\x12\x81"
            "\x62\x71\x22\x71\x72\x71\x22\x61\x82\x61\x32\x61\x82"
            "\x61\x32\x51\x92\x51\x42\x51\x92\x42\x42\x41\xa2\x41"
            "\x52\x41\x70\xf1\x32\x31\x62\x31\x80\xf1\x32\x21\x72"
            "\x21\x90\xf1\x32\x11\x82\x11\xa0\xf1\x33\x93\xb0\x32"
            "\xa2\xe0\x12\xa1\xd8" }  },
      /* --- pixel bitmap for cmmi210 char#88 X --- */
      {  88,27491,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 24,   20, 3,89, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x58\x47\x82\x83\xb3\x71\xe2\x62\xe2\x52\xe0\x22\x32"
            "\xe0\x32\x31\xe0\x43\x11\x90\xf2\xb3\xa0\xa1\x12\xe0"
            "\x51\x32\xe0\x31\x42\xe0\x21\x62\xe1\x72\xd1\x83\xb2"
            "\x92\xa2\xa3\x67\x67\x41" }  },
      /* --- pixel bitmap for cmmi210 char#89 Y --- */
      {  89,28589,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 21,   20, 3,67, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x76\x32\xc2\x53\xa1\x82\x91\x92\x82\xa2\x71\xb2"
            "\x61\xc3\x41\xe2\x31\xe0\x12\x21\xe0\x24\xb0\xf2\x72"
            "\xc0\xf3\x62\xd0\x52\xe0\x28\xb2" }  },
      /* --- pixel bitmap for cmmi210 char#90 Z --- */
      {  90,29694,                      /* character number, location */
         20, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 19,   20, 3,81, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x53\x82\x52\x92\x62\x82\x71\x82\x81\x73\x71\x82"
            "\xe0\x22\xe0\x22\xe0\x22\xe0\x22\xe0\x22\xe0\x22\x81"
            "\x72\x91\x63\x81\x72\x91\x62\x92\x52\xa2\x42\x93\x4e"
            "\x01\x42" }  },
      /* --- pixel bitmap for cmmi210 char#91 \flat --- */
      {  91,120222,                     /* character number, location */
         22, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          {  7,   23, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x81\x40\x20\x10\x08\x04\x02\x9d\x59\x38\x1c\x0e\x87"
            "\x63\xb1\x48\xa6\x51\x18\x04\x00" }  },
      /* --- pixel bitmap for cmmi210 char#92 \natural --- */
      {  92,121001,                     /* character number, location */
         22, 2,   -7, 2,      /* topleft row,col, and botleft row,col */
          {  7,   29, 3,34, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf6\x01\x61\x43\x1a\x13\x41\x0f\x81\x51\x01\x43\x1a"
            "\x13\x41\xf4\x61" }  },
      /* --- pixel bitmap for cmmi210 char#93 \sharp --- */
      {  93,121892,                     /* character number, location */
         21, 2,   -7, 2,      /* topleft row,col, and botleft row,col */
          {  7,   28, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x91\x48\x24\x12\x89\xfd\xbf\x91\x48\x24\x12\x89"
            "\x44\x22\x91\x48\xec\xff\x8d\x44\x22\x91\x48\x00" }  },
      /* --- pixel bitmap for cmmi210 char#94 \smile --- */
      {  94,122842,                     /* character number, location */
         11, 2,    4, 2,      /* topleft row,col, and botleft row,col */
          { 25,    7, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\xe0\x91\x11\xe0\x71\x31\xe0\x51\x52\xe0\x12\x74"
            "\x94\xad\xe0\x17\x92" }  },
      /* --- pixel bitmap for cmmi210 char#95 \frown --- */
      {  95,123716,                     /* character number, location */
         12, 2,    4, 2,      /* topleft row,col, and botleft row,col */
          { 25,    8, 3,38, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc1\xe0\x5b\xce\x01\x92\xd2\x71\xe0\x31\x51\xe0\x51"
            "\x31\xe0\x71\x11\xe0\x91" }  },
      /* --- pixel bitmap for cmmi210 char#96 \ell --- */
      {  96,96600,                      /* character number, location */
         20, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   20, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x06\x98\x80\x08\x8c\x40\x08\x46\x20\x04\x23\x30"
            "\x01\x13\x98\x80\x05\x38\x80\x01\x18\xc0\x01\x1a\x90"
            "\x81\x10\x06\x1e" }  },
      /* --- pixel bitmap for cmmi210 char#97 a --- */
      {  97,30648,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x19\x8c\x86\xc1\x31\x30\x06\x8c\x01\x63\xc0\x0c"
            "\x18\x03\xa6\x80\x69\x70\x12\x5a\x78\x1c" }  },
      /* --- pixel bitmap for cmmi210 char#98 b --- */
      {  98,31502,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   20, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x15\xa2\x60\xf3\x32\x70\x22\xa2\x23\x54\x32\x32\x61"
            "\x10\xf3\x12\x72\x0f\x12\x72\x10\x11\x62\x32\x51\x51"
            "\x32\x74\x54" }  },
      /* --- pixel bitmap for cmmi210 char#99 c --- */
      {  99,32349,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x03\x43\x18\xce\x70\x06\x60\x00\x06\x30\x00\x03"
            "\x20\x80\x06\xc4\x30\xf8\x00" }  },
      /* --- pixel bitmap for cmmi210 char#100 d --- */
      { 100,33323,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   20, 3,73, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa5\xd2\xf3\xc2\x10\xb2\x83\x22\x62\x31\x12\x52\x53"
            "\x42\x62\x30\xf2\x12\x72\x32\x72\x42\x72\x21\x21\x72"
            "\x21\x22\x53\x21\x31\x41\x12\x11\x54\x33\x22" }  },
      /* --- pixel bitmap for cmmi210 char#101 e --- */
      { 101,34184,                      /* character number, location */
         13, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 11,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\xc1\x10\x03\x0d\x34\xa0\xff\x0c\x20\x00\x01\x18"
            "\xe0\x80\x0c\xc3\x07" }  },
      /* --- pixel bitmap for cmmi210 char#102 f --- */
      { 102,35338,                      /* character number, location */
         20, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 14,   26, 3,61, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb2\xa2\x12\x95\x92\x12\xf2\x82\x40\x58\x92\x40\xf4"
            "\x72\x50\xf4\x62\x60\x61\x70\xf1\x52\x70\x12\x22\x73"
            "\x21\x82\x21\xa3\xa1" }  },
      /* --- pixel bitmap for cmmi210 char#103 g --- */
      { 103,36321,                      /* character number, location */
         13, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 14,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x33\x18\x0d\x83\x63\x60\x0c\x18\x03\xc6\x80\x19"
            "\x30\x06\x0c\x01\xc3\xe0\x20\x1c\xf0\x06\x80\x01\x60"
            "\x18\x0c\x07\xc3\x70\xe0\x07\x00" }  },
      /* --- pixel bitmap for cmmi210 char#104 h --- */
      { 104,37268,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   20, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x00\x30\x00\x0c\x00\x06\x00\x03\x80\x01\x60\x00"
            "\x30\x1f\x58\x18\x1c\x0c\x07\x86\x01\xc3\x80\x61\xc0"
            "\x18\x30\x0c\x98\x06\x46\x03\xd3\x80\x69\x80\x03" }  },
      /* --- pixel bitmap for cmmi210 char#105 i --- */
      { 105,38154,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   20, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\xe0\x60\x00\x00\x00\x00\x1c\x32\x32\x31\x19\x18"
            "\x18\x0c\x4c\x4c\x26\x26\x1c" }  },
      /* --- pixel bitmap for cmmi210 char#106 j --- */
      { 106,39113,                      /* character number, location */
         20,-1,   -6,-1,      /* topleft row,col, and botleft row,col */
          { 13,   26, 3,65, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa2\xb3\xa2\x10\xf3\xd0\x73\x91\x22\x71\x42\x61\x32"
            "\x61\x42\x20\xf1\x92\x20\xf3\x82\x30\xf3\x72\x40\x12"
            "\x32\x53\x32\x52\x32\x74\x82" }  },
      /* --- pixel bitmap for cmmi210 char#107 k --- */
      { 107,40142,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   20, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x00\x18\x00\x03\xc0\x00\x30\x00\x0c\x80\x01\x60"
            "\x70\x18\x3a\x46\xce\x88\xb1\x01\x1c\x00\x7f\x60\x38"
            "\x18\x4c\x06\x93\xc1\x34\xb0\x0c\x18" }  },
      /* --- pixel bitmap for cmmi210 char#108 l --- */
      { 108,40888,                      /* character number, location */
         20, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   20, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x8c\x61\x18\xc6\x30\x0c\x63\x18\x86\x31\x4c\xd3"
            "\xb4\x18" }  },
      /* --- pixel bitmap for cmmi210 char#109 m --- */
      { 109,42149,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 23,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x0f\x0f\x6d\x6c\x8c\x0c\x0e\x26\x07\x07\x93\x81"
            "\x81\xc1\xc0\xc0\x60\x60\x60\x18\x18\x18\x0c\x0c\x4c"
            "\x06\x06\x26\x03\x83\xc9\xc0\xc0\x64\x60\xc0\x01" }  },
      /* --- pixel bitmap for cmmi210 char#110 n --- */
      { 110,43210,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x0f\x6d\x8c\x0c\x26\x07\x93\x81\xc1\xc0\x60\x60"
            "\x18\x18\x0c\x4c\x06\x26\x83\xc9\xc0\x64\xc0\x01" }  },
      /* --- pixel bitmap for cmmi210 char#111 o --- */
      { 111,43954,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   13, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x65\x72\x51\x52\x62\x32\x82\xf2\x12\x92\x0f\x12\x92"
            "\x10\x11\x82\x32\x62\x52\x42\x75\x62" }  },
      /* --- pixel bitmap for cmmi210 char#112 p --- */
      { 112,44954,                      /* character number, location */
         13,-1,   -6,-1,      /* topleft row,col, and botleft row,col */
          { 16,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x1c\x68\x63\xc8\x40\x64\xc0\x64\xc0\x60\xc0\x60"
            "\xc0\x30\x60\x30\x60\x30\x30\x30\x10\x58\x0c\x98\x07"
            "\x18\x00\x18\x00\x0c\x00\x0c\x00\x0c\x00\x3f\x00" }  },
      /* --- pixel bitmap for cmmi210 char#113 q --- */
      { 113,45903,                      /* character number, location */
         13, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 13,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x11\x46\x63\x70\x06\x66\xc0\x0c\x98\x01\x1b\x30"
            "\x03\x46\xc0\x18\x1c\xc2\x81\x37\x00\x06\xc0\x00\x0c"
            "\x80\x01\x30\xc0\x1f" }  },
      /* --- pixel bitmap for cmmi210 char#114 r --- */
      { 114,46784,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\xa7\xe5\x32\x9e\x63\x19\x80\x01\x18\xc0\x00\x0c"
            "\xc0\x00\x0c\x60\x00\x06\x00" }  },
      /* --- pixel bitmap for cmmi210 char#115 s --- */
      { 115,47760,                      /* character number, location */
         13, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 10,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x60\x84\x39\x63\x1c\xe0\x81\x0f\x70\x82\x1d\x36"
            "\x48\x10\x3e\x00" }  },
      /* --- pixel bitmap for cmmi210 char#116 t --- */
      { 116,48516,                      /* character number, location */
         18, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x60\xc0\x80\x81\xe1\x3f\x06\x0c\x0c\x18\x30\x60"
            "\x60\xc0\x90\x21\x23\x26\x38\x00" }  },
      /* --- pixel bitmap for cmmi210 char#117 u --- */
      { 117,49568,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x98\x0c\x26\x83\xc5\x30\x19\x0c\x06\x83\xc1\x30"
            "\x18\x0c\x26\x83\xc9\x70\x22\x5e\x70\x0c" }  },
      /* --- pixel bitmap for cmmi210 char#118 v --- */
      { 118,50477,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x48\x06\xcb\xa0\x18\x94\x81\x30\x10\x06\x62\x20"
            "\x0c\x84\x41\x30\x08\x8c\x00\x0f\x00" }  },
      /* --- pixel bitmap for cmmi210 char#119 w --- */
      { 119,51697,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x18\x92\xc1\xb0\x0c\x86\x63\x18\x94\xc1\x20\x0c"
            "\x06\x61\x30\x88\xc1\x20\x0c\x06\x61\x30\x08\x83\x21"
            "\x30\x8a\x00\x8f\x03" }  },
      /* --- pixel bitmap for cmmi210 char#120 x --- */
      { 120,52951,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x70\x3c\xe4\x39\x71\x5c\x18\x26\x0c\x00\x06\x00\x03"
            "\xc0\x00\x60\x90\x31\xc8\x19\x62\x8a\xe0\x38\x00" }  },
      /* --- pixel bitmap for cmmi210 char#121 y --- */
      { 121,54043,                      /* character number, location */
         13, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 14,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\xb0\x0c\x2c\x03\xc7\x60\x19\x18\x06\x86\x81\x31"
            "\x30\x0c\x0c\x03\xc3\xe0\x60\x1c\xf0\x06\x80\x01\x30"
            "\x1c\x0c\x87\x81\x30\xc0\x03\x00" }  },
      /* --- pixel bitmap for cmmi210 char#122 z --- */
      { 122,54995,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\x88\x5f\x08\x07\x20\x00\x01\x08\x40\x00\x03\x08"
            "\x44\x40\x1c\x22\x3f\xc1\x00" }  },
      /* --- pixel bitmap for cmmi210 char#123 \imath --- */
      { 123,97368,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x99\x2c\x96\xc1\x60\x18\x4c\xa6\xc9\xc4\x01" }  },
      /* --- pixel bitmap for cmmi210 char#124 \jmath --- */
      { 124,98181,                      /* character number, location */
         13,-1,   -6,-1,      /* topleft row,col, and botleft row,col */
          { 12,   19, 3,53, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x73\x81\x22\x61\x42\x51\x32\x51\x42\x10\xf1\x92\x10"
            "\xf3\x82\x20\xf3\x72\x30\x12\x32\x43\x32\x42\x32\x64"
            "\x71" }  },
      /* --- pixel bitmap for cmmi210 char#125 \wp --- */
      { 125,99318,                      /* character number, location */
         14, 2,   -7, 2,      /* topleft row,col, and botleft row,col */
          { 17,   21, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x00\x30\x78\x30\x0c\x63\x04\x64\x04\xd8\x04\xb0"
            "\x05\x60\x0b\xc0\x0e\xc0\x1c\x80\x19\x82\x71\x04\xe1"
            "\x89\x41\xe3\x81\x0c\x00\x19\x00\x31\x00\x62\x00\xc4"
            "\x00\xc8\x00\xe0\x00\x00" }  },
      /* --- pixel bitmap for cmmi210 char#126 \vec --- */
      { 126,99982,                      /* character number, location */
         21, 6,   15, 6,      /* topleft row,col, and botleft row,col */
          { 13,    6, 3,13, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x82\xb3\x2f\x1d\x73\xa2\x42" }  },
      /* --- pixel bitmap for cmmi210 char#127 (noname) --- */
      { 127,100524,                     /* character number, location */
         19, 8,   16, 8,      /* topleft row,col, and botleft row,col */
          { 11,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x31\x50\x00\x01" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=7 for .250gf ---
 * mf '\mode=preview; mag=magstep(-12.84858895680446863032); input cmmi10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmmi250 --- */
static	chardef  cmmi250[] =
   {
      /* --- pixel bitmap for cmmi250 char#0 \Gamma --- */
      {   0,56859,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 26,   24, 3,69, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6e\x06\xa3\xa3\xf1\x93\xc2\xf1\x93\xc1\x10\xf1\x83"
            "\xd1\x10\xf1\x83\xe0\x10\xf3\x73\xe0\x20\xf3\x63\xe0"
            "\x30\xf3\x53\xe0\x40\x44\xe0\x4c\xe2" }  },
      /* --- pixel bitmap for cmmi250 char#1 \Delta --- */
      {   1,57788,                      /* character number, location */
         25, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 25,   25, 3,120, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\xe0\x41\xe0\x93\x50\xf1\xe0\x24\x50\xe0\x11\x13\xe0"
            "\x51\x24\x40\xf1\xd1\x43\x40\xc1\x53\xe0\x11\x64\x30"
            "\xf1\xa1\x83\x30\x91\x93\xb1\xa4\x20\xf1\x71\xc3\x20"
            "\x61\xd3\x71\xe4\x10\xf1\x41\xe0\x23\x10\x31\xe0\x33"
            "\x31\xe0\x44\xf1\x1e\x0a\x0e\x0b" }  },
      /* --- pixel bitmap for cmmi250 char#2 \Theta --- */
      {   2,58995,                      /* character number, location */
         25, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 23,   26, 3,101, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\xb7\xe3\x53\xa3\x83\x82\xb3\x62\xd2\x53\xd3\x33\xe3"
            "\xf1\x23\xe0\x22\x13\xe0\x32\x13\xe0\x23\x0f\x33\x3b"
            "\x33\x03\xe0\x23\x12\xe0\x33\x1f\x12\xe0\x23\x23\xe3"
            "\x33\xd3\x52\xd2\x63\xb2\x83\x83\xa3\x53\xe7\xb0" }  },
      /* --- pixel bitmap for cmmi250 char#3 \Lambda --- */
      {   3,59991,                      /* character number, location */
         25, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 22,   25, 3,106, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\xf1\xe0\x22\x40\xf1\xe0\x13\x40\xf1\xe4\x40\xd1\x13"
            "\xe0\x22\x13\xe0\x21\x23\x40\xf1\xb1\x33\x40\xf1\xa1"
            "\x44\x30\xf1\x91\x63\x30\x81\x73\x30\xf1\x71\x83\x30"
            "\xf1\x61\x93\x30\xf1\x51\xa3\x30\x41\xb3\x62\xb3\x38"
            "\x59" }  },
      /* --- pixel bitmap for cmmi250 char#4 \Xi --- */
      {   4,61478,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 26,   24, 3,61, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x7e\x05\xf2\x61\xe0\x31\x10\xf4\xe0\xc0\x71\xb1"
            "\x60\xf1\x7d\x60\x71\xb1\x60\xf4\xe0\xc0\xf2\x11\xe0"
            "\x51\x4f\x1e\x07\x53" }  },
      /* --- pixel bitmap for cmmi250 char#5 \Pi --- */
      {   5,62721,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 32,   24, 3,59, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6e\x0c\xa3\xc3\x40\xf3\x93\xc3\x50\xf3\x83\xc3\x60"
            "\xf3\x73\xc3\x70\xf3\x63\xc3\x80\xf3\x53\xc3\x90\x43"
            "\xc3\xab\x4b\x67" }  },
      /* --- pixel bitmap for cmmi250 char#6 \Sigma --- */
      {   6,63936,                      /* character number, location */
         24, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 26,   24, 3,95, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6e\x06\x64\xc4\x73\xe2\x74\xd2\xf1\x83\xd1\x10\x84"
            "\xc1\xa3\xc1\xa4\xd0\xf1\xa3\xd0\xa4\xe0\x93\xe0\x91"
            "\xe0\xa1\xe0\xa1\xc1\xb1\xd1\xa1\xd1\xa1\xe1\x91\xe2"
            "\x72\xe2\x71\xe4\x6e\x05\x6e\x06\x61" }  },
      /* --- pixel bitmap for cmmi250 char#7 \Upsilon --- */
      {   7,64998,                      /* character number, location */
         25, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 23,   25, 3,77, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x44\x95\x37\x76\x23\x33\x44\x23\x11\x62\x42\x62\x72"
            "\x32\x72\x82\x12\x81\x92\x11\xe0\x54\xa0\xf2\x93\xb0"
            "\xf3\x83\xc0\xf3\x73\xd0\xf3\x63\xe0\x54\xe0\x1c\xa2" }  },
      /* --- pixel bitmap for cmmi250 char#8 \Phi --- */
      {   8,66056,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 21,   24, 3,97, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\xd4\x60\xf2\xb3\x70\x88\xa3\x23\x23\x72\x43\x43"
            "\x33\x53\x52\x23\x63\x53\x13\x53\x63\x0f\x13\x63\x63"
            "\x03\x63\x53\x13\x53\x63\x22\x53\x53\x33\x43\x42\x73"
            "\x23\x23\xa8\x80\xf2\x73\xb0\x64\xdc\x73" }  },
      /* --- pixel bitmap for cmmi250 char#9 \Psi --- */
      {   9,67177,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 23,   24, 3,95, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6c\xe0\x14\x90\xf1\xa3\xa3\x73\x64\x13\x63\x53\x33"
            "\x53\x63\x20\xf2\x13\x53\x53\x3f\x23\x53\x53\x43\x53"
            "\x43\x53\x43\x52\x72\x43\x42\x92\x33\x32\xb2\x23\x13"
            "\xd8\xb0\xf2\x63\xe0\x54\xe0\x1c\xac" }  },
      /* --- pixel bitmap for cmmi250 char#10 \Omega --- */
      {  10,68434,                      /* character number, location */
         25, 3,    0, 3,      /* topleft row,col, and botleft row,col */
          { 24,   25, 3,117, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\xc7\xe0\x13\x53\xb3\x92\x92\xc2\x72\xd3\x53\xd3\x43"
            "\xe3\x42\xe0\x13\xf1\x33\xe0\x13\x33\xe0\x12\x43\xe3"
            "\x43\xe2\x53\xd3\x53\xc3\x72\xc2\x82\xb2\x92\xb1\xb1"
            "\xa2\x61\x41\x92\x31\x31\x41\x91\x41\x31\x42\x71\x41"
            "\x46\x86\x46\x77\x46\x76\x5e" }  },
      /* --- pixel bitmap for cmmi250 char#11 \alpha --- */
      {  11,69516,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 18,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x03\xc0\x30\x88\x81\x21\x03\x86\x06\x30\x19\xc0"
            "\x34\x00\xcb\x00\x2c\x03\x70\x0c\xc0\x30\x00\xc3\x00"
            "\x0e\x03\x34\x18\x8c\x84\x0f\x0c" }  },
      /* --- pixel bitmap for cmmi250 char#12 \beta --- */
      {  12,70619,                      /* character number, location */
         24, 0,   -7, 0,      /* topleft row,col, and botleft row,col */
          { 20,   31, 3,111, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\xc5\xd2\x51\xb1\x81\x10\xf1\x81\x92\x71\xa2\x71\x92"
            "\x71\xa2\x71\x92\x81\x37\x81\x46\x91\x92\x81\xa1\x81"
            "\xa2\x20\xf3\x41\xb2\x20\xf1\x32\xa2\x30\x32\x92\x72"
            "\x82\x71\x21\x53\x81\x36\x80\xf1\x21\xe0\x30\xf3\x11"
            "\xe0\x41\xe0\x57" }  },
      /* --- pixel bitmap for cmmi250 char#13 \gamma --- */
      {  13,71602,                      /* character number, location */
         15, 0,   -8, 0,      /* topleft row,col, and botleft row,col */
          { 19,   23, 3,73, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x54\x91\x37\x71\x34\x14\x61\x22\x72\x41\x31\x91\x41"
            "\x21\xa1\x31\x30\xf1\xc1\x21\x30\xf2\xc1\x11\x40\xf2"
            "\xc2\x50\xf2\xc1\x60\xf3\xb1\x70\xf1\xa1\x82" }  },
      /* --- pixel bitmap for cmmi250 char#14 \delta --- */
      {  14,72561,                      /* character number, location */
         25, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 13,   25, 3,79, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x73\x97\x51\x43\xf2\x51\x70\xf1\x52\x60\x62\x50\xf1"
            "\x63\x40\x42\x13\x62\x32\x52\x43\x20\xf1\x12\x62\x2f"
            "\x22\x72\x22\x71\x32\x62\x32\x61\x42\x52\x52\x32\x74"
            "\x72" }  },
      /* --- pixel bitmap for cmmi250 char#15 \epsilon --- */
      {  15,73451,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 10,   15, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x64\x42\x71\x81\x82\x72\x89\x1f\x42\x80\x11\xa1\x52"
            "\x35\x20" }  },
      /* --- pixel bitmap for cmmi250 char#16 \zeta --- */
      {  16,74367,                      /* character number, location */
         24, 2,   -7, 2,      /* topleft row,col, and botleft row,col */
          { 14,   31, 3,63, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf2\x91\x40\x95\x81\x14\x62\xb2\xb2\xc1\xc2\xb2\xc1"
            "\xb0\xf1\x12\xbf\x62\xc0\x12\xc4\xb6\xa6\xb4\x30\xf2"
            "\x92\x30\x42\x31\xa3\x52" }  },
      /* --- pixel bitmap for cmmi250 char#17 \eta --- */
      {  17,75306,                      /* character number, location */
         15, 1,   -8, 1,      /* topleft row,col, and botleft row,col */
          { 16,   23, 3,69, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x32\x54\x41\x21\x22\x32\x10\xf1\x11\x33\x62\x11\x32"
            "\x72\xf3\x42\x72\x10\xf3\x32\x72\x20\xf1\x22\x72\x30"
            "\xf1\xb2\x30\xf3\xa2\x40\xf1\x92\x52" }  },
      /* --- pixel bitmap for cmmi250 char#18 \theta --- */
      {  18,76072,                      /* character number, location */
         24, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 14,   24, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x07\x20\x02\x04\x81\x40\x30\x30\x04\x8c\x01\x23"
            "\xc0\x0c\x30\x03\x6c\x80\xf9\x7f\xfe\x9f\x01\x36\xc0"
            "\x0c\x30\x03\xc4\x80\x31\x20\x0c\x0c\x02\x81\x20\x40"
            "\x04\xe0\x00" }  },
      /* --- pixel bitmap for cmmi250 char#19 \iota --- */
      {  19,76747,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  9,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x30\x60\xc0\x80\x81\x01\x03\x06\x06\x0c\x18\x1c"
            "\x38\x48\x0c\x07" }  },
      /* --- pixel bitmap for cmmi250 char#20 \kappa --- */
      {  20,77691,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 16,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x70\x18\x7c\x18\x62\x18\x01\x98\x00\x6c\x00\xfc"
            "\x00\x8c\x07\x0c\x0c\x06\x0c\x06\x8c\x06\x8c\x06\x8c"
            "\x03\x4c\x03\x38" }  },
      /* --- pixel bitmap for cmmi250 char#21 \lambda --- */
      {  21,78546,                      /* character number, location */
         24, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 17,   24, 3,78, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x43\xe0\x22\xe0\x13\x80\xf1\x72\x80\xf2\x82\x70\xf2"
            "\x92\x60\xf1\xa2\x50\x94\xc2\x12\xb2\x22\xa2\x33\x82"
            "\x52\x72\x62\x62\x82\x42\x92\x33\x92\x23\xb2\x12\xc3" }  },
      /* --- pixel bitmap for cmmi250 char#22 \mu --- */
      {  22,79604,                      /* character number, location */
         15, 1,   -8, 1,      /* topleft row,col, and botleft row,col */
          { 18,   23, 3,77, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x61\x81\x20\xf3\x52\x72\x20\xf3\x42\x72\x30\x32\x72"
            "\x40\xf1\x32\x72\x31\x32\x63\x31\x24\x41\x12\x21\x32"
            "\x15\x33\x20\xf1\x22\xe0\xf3\x12\xe0\x1f\x12\xe0\x23" }  },
      /* --- pixel bitmap for cmmi250 char#23 \nu --- */
      {  23,80429,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,53, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x15\x81\xf2\x32\x82\x32\x72\x32\x82\x32\x72\x42\x71"
            "\x52\x62\x42\x62\x52\x52\x62\x41\x82\x22\x82\x12\xa3"
            "\xc5" }  },
      /* --- pixel bitmap for cmmi250 char#24 \xi --- */
      {  24,81569,                      /* character number, location */
         24, 1,   -7, 1,      /* topleft row,col, and botleft row,col */
          { 14,   31, 3,71, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf2\x91\x40\x86\x63\x14\x52\xb2\x80\xf4\x32\x90\xf1"
            "\x47\x30\x32\xb2\xa0\xf1\x12\xbf\x22\xc3\xc3\xc4\xb5"
            "\xb6\xb4\x20\xf1\xa2\x20\x51\x41\x94\x4f" }  },
      /* --- pixel bitmap for cmmi250 char#25 \pi --- */
      {  25,82531,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 17,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\xff\xf9\xff\x1b\x21\x08\x42\x10\x84\x00\x8c\x01"
            "\x08\x01\x10\x02\x30\x04\x20\x08\x40\x30\xc0\x60\x80"
            "\xc1\x80\x81\x01\x03\x02" }  },
      /* --- pixel bitmap for cmmi250 char#26 \rho --- */
      {  26,83391,                      /* character number, location */
         15, 1,   -8, 1,      /* topleft row,col, and botleft row,col */
          { 16,   23, 3,69, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x95\xa2\x32\x81\x61\x72\x62\xf1\x52\x72\xf2\x42\x82"
            "\xf1\x32\x82\x10\x32\x72\x53\x52\x52\x11\x42\x62\x24"
            "\x60\xf1\x22\xc0\xf3\x12\xdf\x12\xe4" }  },
      /* --- pixel bitmap for cmmi250 char#27 \sigma --- */
      {  27,84293,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 17,   15, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6b\x4d\x33\x42\x72\x72\x40\xf1\x12\x82\x4f\x22\x92"
            "\x42\x82\x51\x92\x52\x72\x62\x62\x82\x42\xa5\xa2" }  },
      /* --- pixel bitmap for cmmi250 char#28 \tau --- */
      {  28,85072,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x2d\x11\x61\x6f\x11\x61\x70\x71\x70\xf1\x62\x70"
            "\xf1\x61\x80\xf2\x52\x80\xf1\x42\x92" }  },
      /* --- pixel bitmap for cmmi250 char#29 \upsilon --- */
      {  29,86009,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x80\x88\x00\x0b\x01\x16\x03\x2c\x06\x18\x0c\x10"
            "\x0c\x20\x18\x40\x30\x40\x30\x80\x60\x80\xc0\x00\x01"
            "\x03\x01\x06\x01\xf0\x01" }  },
      /* --- pixel bitmap for cmmi250 char#30 \phi --- */
      {  30,86899,                      /* character number, location */
         24, 2,   -7, 2,      /* topleft row,col, and botleft row,col */
          { 17,   31, 3,107, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\xf1\xc1\x40\xf3\xb1\x50\xf2\xa1\x60\x76\x92\x21\x32"
            "\x52\x41\x42\x32\x51\x51\x22\x61\x52\x12\x51\x62\x0f"
            "\x22\x61\x62\x02\x51\x62\x12\x51\x61\x22\x51\x51\x42"
            "\x41\x32\x62\x21\x23\x96\x70\xf1\x61\xa0\xf3\x51\xb0"
            "\x41\xc1" }  },
      /* --- pixel bitmap for cmmi250 char#31 \chi --- */
      {  31,88004,                      /* character number, location */
         15, 1,   -7, 1,      /* topleft row,col, and botleft row,col */
          { 19,   22, 3,99, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x23\xd1\x21\x13\xa1\x21\x32\xa1\x63\x81\x82\x71\x92"
            "\x61\xb2\x41\xc2\x31\xd3\x11\xe0\x13\xe0\x22\xe0\x42"
            "\xe0\x23\xe0\x11\x13\xd1\x32\xc1\x42\xb1\x62\x91\x72"
            "\x81\x83\x61\xa2\x31\x21\xa3\x11\x21\xd3\x23" }  },
      /* --- pixel bitmap for cmmi250 char#32 \psi --- */
      {  32,89135,                      /* character number, location */
         24, 1,   -7, 1,      /* topleft row,col, and botleft row,col */
          { 21,   31, 3,125, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\xf1\xe0\x11\x50\xf3\xe1\x60\xf2\xd1\x70\x33\x71\x51"
            "\x31\x31\x51\x62\x11\x41\x51\x62\xf1\x11\x32\x51\x62"
            "\x52\x41\x71\x10\xf1\x42\x51\x71\x10\x42\x51\x61\x52"
            "\x51\x71\x52\x51\x61\x71\x51\x51\x82\x41\x41\xa2\x21"
            "\x32\xd6\x80\xf1\x91\xb0\xf3\x81\xc0\x71\xd3" }  },
      /* --- pixel bitmap for cmmi250 char#33 \omega --- */
      {  33,90280,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 20,   15, 3,73, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x31\xe1\x32\xe2\x21\xe0\x12\xf1\x11\xe0\x22\x01\x91"
            "\x71\x1f\x11\x82\x71\x11\x82\x62\x11\x81\x71\x21\x72"
            "\x62\x22\x54\x51\x38\x18\x46\x36\x64\x53\x61" }  },
      /* --- pixel bitmap for cmmi250 char#34 \varepsilon --- */
      {  34,91279,                      /* character number, location */
         16, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 13,   17, 3,47, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x65\x69\x33\x52\x22\x90\xf2\x21\xa0\x36\x62\x13\x50"
            "\xf1\x11\xbf\x11\xc1\xa1\x22\x62\x39\x65\x51" }  },
      /* --- pixel bitmap for cmmi250 char#35 \vartheta --- */
      {  35,92296,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   24, 3,97, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc3\xe1\x22\xc1\x41\xb1\x51\x20\xf4\x91\x52\x10\x32"
            "\x51\x42\x31\x21\x52\x12\x31\x32\x63\x31\x32\x74\x11"
            "\x32\x72\x20\xf1\x42\x72\x30\x42\x71\x82\x62\x72\x72"
            "\x72\x62\x82\x61\x92\x51\xb2\x32\xc4\x91" }  },
      /* --- pixel bitmap for cmmi250 char#36 \varpi --- */
      {  36,93575,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 26,   15, 3,95, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\x09\x2e\x0a\x12\x31\xe0\x21\x21\x41\xe0\x31\x21"
            "\x31\xe0\x41\x61\x81\x91\x20\xf1\x31\x91\x91\x20\x31"
            "\x82\x81\x51\x92\x81\x51\x81\x11\x72\x52\x61\x21\x62"
            "\x71\x42\x32\x42\x86\x56\xa4\x74\x74" }  },
      /* --- pixel bitmap for cmmi250 char#37 \varrho --- */
      {  37,94512,                      /* character number, location */
         15, 3,   -7, 3,      /* topleft row,col, and botleft row,col */
          { 14,   22, 3,65, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x75\x82\x32\x61\x61\x52\x62\xf1\x32\x72\xf2\x22\x82"
            "\x13\x72\x22\x82\x23\x62\x33\x52\x32\x12\x32\x41\x34"
            "\x6f\x21\xd2\xd9\x68\xd1\x41" }  },
      /* --- pixel bitmap for cmmi250 char#38 \varsigma --- */
      {  38,95385,                      /* character number, location */
         15, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          { 12,   18, 3,41, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x66\x42\x51\x31\xa1\xa2\x9f\x22\xa3\xa3\xa3\xa4\xa4"
            "\xa3\x20\xf1\x82\x20\x81\x83\x42" }  },
      /* --- pixel bitmap for cmmi250 char#39 \varphi --- */
      {  39,96354,                      /* character number, location */
         15, 2,   -8, 2,      /* topleft row,col, and botleft row,col */
          { 19,   23, 3,91, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x31\xa3\x41\x96\x31\x82\x42\x11\x82\x61\x11\x81\x71"
            "\x0f\x11\x81\x81\x01\xe0\x31\x0f\x11\x71\x81\x12\x61"
            "\x71\x32\x41\x62\x53\x21\x43\x7b\xa7\xd2\xb0\xf1\x61"
            "\xc0\xf2\x52\xc0\xf1\x42\xd4" }  },
      /* --- pixel bitmap for cmmi250 char#40 \leftharpoonup --- */
      {  40,112528,                     /* character number, location */
         18, 2,    8, 2,      /* topleft row,col, and botleft row,col */
          { 31,   10, 3,42, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x72\xe0\x80\xf1\x62\xe0\x90\x52\xe0\xe3\xe0\xd3"
            "\xe0\xd3\xe0\xde\x0e\x0e\x0e\x05" }  },
      /* --- pixel bitmap for cmmi250 char#41 \leftharpoondown --- */
      {  41,113562,                     /* character number, location */
         10, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 31,   10, 2,25, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x1f\x01\x1e\x02\x03\x1d\x03\x1d\x03\x1d\x02\x18"
            "\x00\xff\x01\x06\x02\x17\x00\xff\x01\x07\x02\x16" }  },
      /* --- pixel bitmap for cmmi250 char#42 \rightharpoonup --- */
      {  42,114594,                     /* character number, location */
         18, 2,    8, 2,      /* topleft row,col, and botleft row,col */
          { 31,   10, 3,46, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\xe0\x82\x70\xf1\xe0\x92\x60\xe0\xa2\xe0\xe0\x13"
            "\xe0\xe0\x13\xe0\xe0\x13\x2f\x1e\x0e\x03" }  },
      /* --- pixel bitmap for cmmi250 char#43 \rightharpoondown --- */
      {  43,115629,                     /* character number, location */
         10, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 31,   10, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x0e\x0e\x0e\x05\xe0\xd3\xe0\xd3\xe0\xd3\xe0\xe2"
            "\x50\xf1\xe0\x92\x60\xf1\xe0\x82\x7e" }  },
      /* --- pixel bitmap for cmmi250 char#44 ` --- */
      {  44,116056,                     /* character number, location */
         18, 2,    8, 2,      /* topleft row,col, and botleft row,col */
          {  6,   10, 3,14, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x33\x18\x3f\x32\x43\x45\x33" }  },
      /* --- pixel bitmap for cmmi250 char#45 ' --- */
      {  45,116484,                     /* character number, location */
         18, 2,    8, 2,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc7\x87\xc3\x30\x0c\xe3\xdf\x01" }  },
      /* --- pixel bitmap for cmmi250 char#46 \triangleright --- */
      {  46,117029,                     /* character number, location */
         17, 1,    1, 1,      /* topleft row,col, and botleft row,col */
          { 15,   16, 3,51, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\xd4\xb6\x92\x24\x72\x43\x62\x54\x42\x74\x2f\x12"
            "\x94\x02\x74\x22\x54\x42\x43\x62\x24\x76\x94\xb2\xd1" }  },
      /* --- pixel bitmap for cmmi250 char#47 \triangleleft --- */
      {  47,117605,                     /* character number, location */
         17, 1,    1, 1,      /* topleft row,col, and botleft row,col */
          { 15,   16, 3,50, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xd2\xb4\x96\x74\x22\x63\x42\x44\x52\x24\x72\x0f\x14"
            "\x92\x24\x72\x44\x52\x63\x42\x74\x22\x96\xb4\xd2" }  },
      /* --- pixel bitmap for cmmi250 char#48 \0 --- */
      {  48,102853,                     /* character number, location */
         16, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 13,   17, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\x62\x52\x20\xf1\x12\x72\x1f\x82\x92\xf1\x12\x72"
            "\x10\x22\x52\x65\x41" }  },
      /* --- pixel bitmap for cmmi250 char#49 \1 --- */
      {  49,103644,                     /* character number, location */
         16, 3,    0, 3,      /* topleft row,col, and botleft row,col */
          { 10,   16, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x51\x46\x40\xfc\x42\x4a" }  },
      /* --- pixel bitmap for cmmi250 char#50 \2 --- */
      {  50,104622,                     /* character number, location */
         16, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 13,   16, 3,45, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x36\x61\x53\x31\x82\x12\x86\x82\x11\x92\xa3\xa2\xa2"
            "\xa2\xa2\x92\x51\x42\x61\x39\x2b\x1c\x11" }  },
      /* --- pixel bitmap for cmmi250 char#51 \3 --- */
      {  51,105663,                     /* character number, location */
         16, 1,   -8, 1,      /* topleft row,col, and botleft row,col */
          { 15,   24, 3,73, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x55\x82\x52\x51\x82\x20\xf2\x13\x73\x10\x21\x83\x10"
            "\xf1\xb2\x20\xa2\xc2\x95\xe0\x12\xe2\xd3\xd3\x12\x93"
            "\x0f\x24\x83\x11\x93\x21\x92\x42\x62\x76\x51" }  },
      /* --- pixel bitmap for cmmi250 char#52 \4 --- */
      {  52,106620,                     /* character number, location */
         16, 1,   -7, 1,      /* topleft row,col, and botleft row,col */
          { 15,   23, 3,75, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x92\x40\xf1\x83\x40\x71\x12\x40\xf1\x61\x22\x40"
            "\x51\x32\x40\xf1\x41\x42\x40\x31\x52\x40\xf1\x21\x62"
            "\x40\x11\x72\x42\x72\x4e\x01\xf5\x92\x40\x68\x13" }  },
      /* --- pixel bitmap for cmmi250 char#53 \5 --- */
      {  53,107683,                     /* character number, location */
         16, 2,   -8, 2,      /* topleft row,col, and botleft row,col */
          { 13,   24, 3,71, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x12\x72\x2a\x39\x41\x31\x70\xf3\x11\xb0\x11\x25\x51"
            "\x11\x42\x42\x62\x31\x73\xb2\x10\xf2\xa3\x0f\x23\x73"
            "\x01\x92\x21\x73\x21\x72\x42\x42\x74\x50" }  },
      /* --- pixel bitmap for cmmi250 char#54 \6 --- */
      {  54,108610,                     /* character number, location */
         23, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 13,   24, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x07\x04\x61\x60\x04\x4e\xc0\x0d\x80\x01\x10\x00"
            "\xe3\x61\x43\x1c\x90\x03\x36\x80\x06\xf0\x00\x1e\xc0"
            "\x03\x78\x00\x0b\x60\x03\x44\xc0\x18\x08\x86\x80\x0f" }  },
      /* --- pixel bitmap for cmmi250 char#55 \7 --- */
      {  55,109551,                     /* character number, location */
         16, 2,   -8, 2,      /* topleft row,col, and botleft row,col */
          { 15,   24, 3,63, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x11\xee\x1d\x21\xb1\x11\xb1\x21\xa1\x30\xf1\xa1\x40"
            "\x91\x50\xf1\x81\x60\xf1\x71\x70\xf1\x62\x70\xf2\x52"
            "\x80\xf4\x43\x80\x51\x91" }  },
      /* --- pixel bitmap for cmmi250 char#56 \8 --- */
      {  56,110490,                     /* character number, location */
         23, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 15,   24, 3,83, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x55\x82\x52\x52\x72\x41\x92\x10\xf1\x12\x92\x10\x13"
            "\x82\x24\x62\x44\x52\x55\x21\x86\xa6\x81\x25\x52\x54"
            "\x32\x74\x22\x95\xa3\x0f\x22\xb2\x12\xa1\x31\x91\x52"
            "\x52\x85\x52" }  },
      /* --- pixel bitmap for cmmi250 char#57 \9 --- */
      {  57,111429,                     /* character number, location */
         16, 2,   -8, 2,      /* topleft row,col, and botleft row,col */
          { 13,   24, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x01\x63\x10\x18\x03\x22\xc0\x06\xd0\x00\x1e\xc0"
            "\x03\x78\x00\x0f\x60\x01\x6c\xc0\x09\x38\xc2\x86\xc7"
            "\x00\x08\x80\x01\xb0\x03\x72\x60\x06\x86\x60\xe0\x03" }  },
      /* --- pixel bitmap for cmmi250 char#58 . --- */
      {  58,118110,                     /* character number, location */
          4, 3,    0, 3,      /* topleft row,col, and botleft row,col */
          {  4,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf6\x6f" }  },
      /* --- pixel bitmap for cmmi250 char#59 , --- */
      {  59,118673,                     /* character number, location */
          4, 3,   -7, 3,      /* topleft row,col, and botleft row,col */
          {  4,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf6\xef\x88\x48\x24\x02" }  },
      /* --- pixel bitmap for cmmi250 char#60 < --- */
      {  60,119341,                     /* character number, location */
         20, 3,   -2, 3,      /* topleft row,col, and botleft row,col */
          { 21,   22, 3,88, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x52\xe0\x34\xe0\x14\xe0\x14\xe0\x14\xe0\x14\xe0"
            "\x23\xe0\x24\xe0\x14\xe0\x14\xe0\x1f\x14\xe0\x30\x24"
            "\xe0\x54\xe0\x54\xe0\x53\xe0\x54\xe0\x54\xe0\x54\xe0"
            "\x54\xe0\x54\xe0\x52" }  },
      /* --- pixel bitmap for cmmi250 char#61 / --- */
      {  61,119887,                     /* character number, location */
         26, 2,   -9, 2,      /* topleft row,col, and botleft row,col */
          { 13,   35, 3,107, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\xf1\xb2\xa3\xf1\xa2\x10\x93\x10\xf1\x92\x20\x83\x20"
            "\xf1\x82\x30\x73\x30\xf1\x72\x40\x63\x40\xf1\x62\x50"
            "\x53\x50\xf1\x52\x60\x43\x60\xf1\x42\x70\x33\x70\xf1"
            "\x32\x80\x23\x80\xf1\x22\x90\x13\x90\xf1\x12\xa3\xaf"
            "\x12\xb1" }  },
      /* --- pixel bitmap for cmmi250 char#62 > --- */
      {  62,120606,                     /* character number, location */
         20, 3,   -2, 3,      /* topleft row,col, and botleft row,col */
          { 21,   22, 3,89, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\xe0\x54\xe0\x54\xe0\x54\xe0\x54\xe0\x54\xe0\x53"
            "\xe0\x54\xe0\x54\xe0\x54\x20\xf1\xe0\x34\xe0\x14\xe0"
            "\x14\xe0\x14\xe0\x23\xe0\x24\xe0\x14\xe0\x14\xe0\x14"
            "\xe0\x14\xe0\x32\xe0\x52" }  },
      /* --- pixel bitmap for cmmi250 char#63 \star --- */
      {  63,121327,                     /* character number, location */
         18,-1,    1,-1,      /* topleft row,col, and botleft row,col */
          { 18,   17, 3,47, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf6\x91\x80\x14\x41\x44\x35\x11\x15\x87\xd3\xe2\x12"
            "\xd1\x31\xc2\x32\xa2\x52\x91\x71\x81\x91\x30" }  },
      /* --- pixel bitmap for cmmi250 char#64 \partial --- */
      {  64,97370,                      /* character number, location */
         25, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 17,   26, 3,105, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x75\xa2\x52\x71\x82\x61\x91\x20\xf1\x33\x82\x10\xf1"
            "\xe0\x11\x10\xe0\x12\x74\x42\x52\x42\x21\x51\x71\x12"
            "\x41\x93\x31\xa3\x22\xa3\x21\xb2\x2f\x12\xb2\x22\xa2"
            "\x31\xb2\x31\xa2\x41\xa1\x52\x82\x61\x72\x81\x52\xa5"
            "\x92" }  },
      /* --- pixel bitmap for cmmi250 char#65 A --- */
      {  65, 1026,                      /* character number, location */
         25, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 24,   25, 3,110, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\xf1\xe0\x32\x50\xf1\xe0\x23\x50\xe0\x14\xe0\x55\xe0"
            "\x51\x13\xe0\x41\x23\xe0\x41\x24\x40\xf1\xc1\x43\x40"
            "\xb1\x53\x40\xf1\xa1\x63\x40\xf1\x91\x73\x40\x8c\x40"
            "\xf1\x71\x93\x40\x61\xa4\x91\xb3\x81\xc3\x72\xc3\x63"
            "\xc3\x38\x6a" }  },
      /* --- pixel bitmap for cmmi250 char#66 B --- */
      {  66, 2438,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 25,   24, 3,89, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x02\xd3\x83\xa3\xa3\x93\xb2\x10\xf1\x83\xb3\x73"
            "\xc2\x83\xb3\x83\xa3\x93\x93\x93\x84\xae\xb3\x93\xa3"
            "\xa3\x30\xf3\x53\xc3\x20\xf1\x43\xc3\x30\x43\xb3\x83"
            "\xa3\x83\x94\x6e\x02\x94" }  },
      /* --- pixel bitmap for cmmi250 char#67 C --- */
      {  67, 3465,                      /* character number, location */
         25, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 24,   26, 3,107, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\xc6\x51\x93\x61\x32\x82\x91\x22\x63\xb3\x62\xd3\x53"
            "\xe2\x43\xe0\x12\x42\xe0\x21\x43\xe0\x21\x33\xe0\x31"
            "\x33\xe0\x6f\x43\xe0\x7f\x12\xe0\x31\x42\xe0\x21\x53"
            "\xe0\x11\x53\xe1\x72\xd1\x92\xb1\xb2\x91\xd2\x62\xe0"
            "\x26\xc8" }  },
      /* --- pixel bitmap for cmmi250 char#68 D --- */
      {  68, 4667,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 26,   24, 3,77, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x02\xe3\x83\xb3\xb2\xa3\xc2\x10\xf1\x83\xc3\xf3"
            "\x73\xe2\xf3\x63\xe3\xf1\x53\xe3\x10\x53\xe2\x73\xd3"
            "\x63\xd3\x73\xc3\x83\xb3\x93\xa3\x93\x93\x8e\x02\xa3" }  },
      /* --- pixel bitmap for cmmi250 char#69 E --- */
      {  69, 6148,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 27,   24, 3,109, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x6e\x07\xa3\xb3\xf1\x93\xd2\xf1\x93\xd1\x10\x83\xe1"
            "\x93\x81\x51\x93\x81\xe0\x13\x72\xe3\x81\xe0\x1c\x80"
            "\xf1\x73\x72\x80\x63\x81\xe0\x13\x81\x61\x83\xe0\x11"
            "\x83\xe1\x83\xe0\x11\x83\xe2\x83\xe1\x93\xd2\x83\xc3"
            "\x5e\x08\x5a" }  },
      /* --- pixel bitmap for cmmi250 char#70 F --- */
      {  70, 7437,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 27,   24, 3,93, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6e\x07\xa3\xb3\xf1\x93\xd2\xf1\x93\xd1\x10\x83\xe1"
            "\x93\x81\x51\x93\x81\xe0\x13\x72\xe3\x81\xe0\x1c\x80"
            "\xf1\x73\x72\x80\xf1\x63\x81\x90\xf1\x63\xe0\x40\xf3"
            "\x53\xe0\x50\x44\xe0\x5c\xe0\x13" }  },
      /* --- pixel bitmap for cmmi250 char#71 G --- */
      {  71, 8672,                      /* character number, location */
         25, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 24,   26, 3,109, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\xc6\x51\x93\x61\x32\x82\x91\x22\x63\xb3\x62\xd3\x53"
            "\xe2\x43\xe0\x12\x42\xe0\x21\x43\xe0\x21\x33\xe0\x31"
            "\x33\xe0\x6f\x23\xe0\x73\xaa\x13\xe3\x4f\x22\xe0\x13"
            "\x4f\x13\xd3\x50\x12\xd3\x72\xb4\x82\x91\x12\xa2\x62"
            "\x31\xc6\xca" }  },
      /* --- pixel bitmap for cmmi250 char#72 H --- */
      {  72, 9963,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 32,   24, 3,69, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6b\x4b\xa3\xc3\x40\xf3\x93\xc3\x50\xf3\x83\xc3\x60"
            "\x73\xc3\xee\x04\x70\xf1\x73\xc3\x70\xf3\x63\xc3\x80"
            "\xf3\x53\xc3\x90\x43\xc3\xab\x4b\x63" }  },
      /* --- pixel bitmap for cmmi250 char#73 I --- */
      {  73,10748,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   24, 3,41, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6b\xa3\x40\xf3\x93\x50\xf3\x83\x60\xf3\x73\x70\xf3"
            "\x63\x80\xf3\x53\x90\x43\xab\x63" }  },
      /* --- pixel bitmap for cmmi250 char#74 J --- */
      {  74,11616,                      /* character number, location */
         24, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 21,   25, 3,55, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xab\xe4\x30\xf3\xe3\x40\xf3\xd3\x50\xf3\xc3\x60\xf3"
            "\xb3\x70\x12\x73\x8f\x14\x63\x83\x63\x91\x73\xb1\x53"
            "\xd6\xd3" }  },
      /* --- pixel bitmap for cmmi250 char#75 K --- */
      {  75,12867,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 31,   24, 3,127, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x6b\x68\xa3\xc3\xc3\xd2\xd3\xc1\xe0\x13\xa2\xe0\x23"
            "\x91\xe0\x33\x91\xe0\x43\x71\xe0\x63\x61\xe0\x73\x51"
            "\xe0\x73\x43\xe0\x73\x31\x13\xe0\x63\x21\x23\xe0\x64"
            "\x53\xe0\x44\x63\xe0\x43\x74\xb0\xf1\x63\x83\xb0\xf1"
            "\x53\xa3\xa0\xf1\x53\xb3\x90\x43\xc4\x8b\x59\x60" }  },
      /* --- pixel bitmap for cmmi250 char#76 L --- */
      {  76,13878,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 23,   24, 3,65, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6c\xe0\x13\xa0\xf3\x93\xb0\xf3\x83\xc0\xf3\x73\xd0"
            "\x63\xe0\xf1\x63\xd1\x63\xc1\x63\xd1\x63\xc2\x63\xc1"
            "\x73\xa3\x63\x95\x2e\x06\x33" }  },
      /* --- pixel bitmap for cmmi250 char#77 M --- */
      {  77,15228,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 38,   24, 3,173, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x68\xe0\x28\xa4\xe0\x11\x13\xd1\x13\xe0\x14\xe1\x13"
            "\xe1\x13\x50\xf1\x91\x13\xd1\x23\x50\x81\x33\xb1\x23"
            "\x60\xf1\x81\x33\xa1\x33\x60\x81\x33\x91\x43\x60\xf1"
            "\x71\x43\x81\x43\x70\x71\x53\x61\x53\xe1\x53\x51\x63"
            "\xd1\x63\x51\x53\xe1\x63\x41\x63\x80\xf1\x61\x63\x31"
            "\x73\x80\x51\x83\x11\x73\x90\xf1\x51\x84\x83\x90\x51"
            "\x83\x93\xc3\x82\x93\xa9\x52\x5b\x60" }  },
      /* --- pixel bitmap for cmmi250 char#78 N --- */
      {  78,16484,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 32,   24, 3,117, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x67\xa9\xa3\xd3\x30\xf1\x91\x13\xc1\x50\xf1\x91\x23"
            "\xb1\x50\xf1\x81\x43\x91\x60\xf1\x81\x53\x81\x60\xf1"
            "\x71\x73\x61\x70\xf1\x71\x83\x51\x70\xf1\x61\xa3\x31"
            "\x80\xf1\x61\xb3\x21\x80\xf1\x51\xd4\x90\xf1\x51\xe3"
            "\x90\x33\xe0\x11\xa9\xc1\xa1" }  },
      /* --- pixel bitmap for cmmi250 char#79 O --- */
      {  79,17439,                      /* character number, location */
         25, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 23,   26, 3,99, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb7\xe3\x53\xa3\x83\x82\xb3\x62\xd2\x52\xe3\x33\xe0"
            "\x12\xf1\x23\xe0\x22\xf1\x13\xe0\x32\x0f\x33\xe0\x33"
            "\x03\xe0\x23\x12\xe0\x33\x1f\x12\xe0\x23\x23\xe3\x33"
            "\xd3\x52\xd2\x63\xa3\x83\x83\xa3\x53\xe7\xb1" }  },
      /* --- pixel bitmap for cmmi250 char#80 P --- */
      {  80,18590,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 27,   24, 3,83, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6e\x03\xe3\x93\x20\xf1\x93\xb3\x10\x93\xc2\xa3\xc3"
            "\xf1\x83\xc3\x10\x83\xc2\xa3\xb3\x93\xb3\xa3\x93\xcd"
            "\xe3\xe0\x30\xf3\x63\xe0\x40\xf3\x53\xe0\x50\x43\xe0"
            "\x6b\xe0\x22" }  },
      /* --- pixel bitmap for cmmi250 char#81 Q --- */
      {  81,19675,                      /* character number, location */
         25, 2,   -7, 2,      /* topleft row,col, and botleft row,col */
          { 23,   32, 3,145, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\xb7\xe3\x53\xa3\x83\x82\xb3\x62\xd2\x53\xd3\x33\xe3"
            "\xf1\x23\xe0\x22\x13\xe0\x32\x13\xe0\x23\x0f\x33\xe0"
            "\x33\x03\xe0\x23\x12\xe0\x33\x1f\x12\xe0\x23\x23\xe3"
            "\x33\x53\x53\x52\x41\x31\x42\x63\x31\x31\x32\x83\x11"
            "\x54\xa3\x11\x33\x51\x88\x61\xe2\x52\xe2\x51\xe0\x12"
            "\x42\xe0\x17\xe0\x35\xe0\x53\x71" }  },
      /* --- pixel bitmap for cmmi250 char#82 R --- */
      {  82,21058,                      /* character number, location */
         24, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          { 25,   25, 3,97, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x01\xe3\x73\xb3\xa3\x93\xb2\x10\xf1\x83\xb3\xf1"
            "\x73\xb3\x10\x73\xa3\x93\x93\x93\x83\xbb\xe3\x73\xc3"
            "\x92\x50\xf3\x53\xa3\x40\xf1\x43\xa3\x50\xf1\x43\xa3"
            "\x41\x33\xb3\x31\x1a\x82\x21\xe0\x73\x31" }  },
      /* --- pixel bitmap for cmmi250 char#83 S --- */
      {  83,22199,                      /* character number, location */
         25, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 20,   26, 3,103, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\xa5\x41\x82\x52\x12\x72\x83\x62\x92\x71\xa2\x10\xf1"
            "\x52\xa2\x10\x43\xa1\x20\xf1\x43\xd0\x55\xe0\x18\xd9"
            "\xd8\xe0\x15\x40\xf2\xe3\x30\x21\xb3\x30\xf1\x11\xc2"
            "\x40\x11\xc1\x62\xa2\x53\x92\x62\x12\x61\x81\x46\x91" }  },
      /* --- pixel bitmap for cmmi250 char#84 T --- */
      {  84,23281,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 24,   24, 3,77, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\x07\x23\x73\x63\x22\x73\x82\x21\x83\x82\xf1\x11"
            "\x93\x81\x10\x11\x83\x91\x11\x93\x91\x10\xf1\xa3\xb0"
            "\xf3\x93\xc0\xf3\x83\xd0\xf3\x73\xe0\x64\xe0\x1d\xa2" }  },
      /* --- pixel bitmap for cmmi250 char#85 U --- */
      {  85,24307,                      /* character number, location */
         24, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 26,   25, 3,75, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0b\x69\x43\xd3\x30\xf3\x33\xe1\x50\xf3\x23\xe1\x60"
            "\xf3\x13\xe1\x7f\x23\xe1\x83\xd2\x83\xd1\x9f\x13\xc1"
            "\xa0\x12\xb1\xd2\x82\xe0\x12\x52\xe0\x46\xe0\x2d" }  },
      /* --- pixel bitmap for cmmi250 char#86 V --- */
      {  86,25271,                      /* character number, location */
         24, 3,   -1, 3,      /* topleft row,col, and botleft row,col */
          { 24,   25, 3,117, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x09\x87\x24\xd3\x53\xd1\x73\xc2\x73\xc1\x50\xf1\x33"
            "\xb1\x60\x33\xa1\x70\xf1\x33\x91\x80\xf1\x43\x71\x90"
            "\x43\x61\xa0\xf1\x43\x51\xb0\x43\x41\xe0\x23\x32\xe0"
            "\x23\x31\xe0\x34\x11\xe0\x53\x11\xe0\x54\xe0\x10\xf1"
            "\x53\xe0\x20\xf1\x52\xe0\x31" }  },
      /* --- pixel bitmap for cmmi250 char#87 W --- */
      {  87,26694,                      /* character number, location */
         24, 3,   -1, 3,      /* topleft row,col, and botleft row,col */
          { 34,   25, 3,169, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x09\x4a\x47\x24\xa3\xa3\x43\xb3\xa2\x53\xa4\xa1\x63"
            "\xa4\x91\x73\x91\x13\x91\x73\x91\x13\x81\x84\x71\x23"
            "\x81\x60\xf1\x33\x61\x33\x71\x70\xf1\x33\x51\x43\x61"
            "\x80\x33\x41\x54\x41\xc3\x41\x63\x31\xd3\x31\x73\x31"
            "\xd3\x31\x73\x21\xe3\x21\x83\x21\xe3\x12\x83\x11\xe0"
            "\x13\x11\x93\x11\xc0\xf1\x34\xa4\xd0\xf1\x33\xb3\xe0"
            "\x32\xc2\xe0\x42\xc1\xe0\x22" }  },
      /* --- pixel bitmap for cmmi250 char#88 X --- */
      {  88,27955,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 28,   24, 3,119, (pixbyte *)/* width,ht, fmt,pixsz,map... */
            "\x6a\x48\x94\x93\xd3\x92\xe4\x72\xe0\x23\x62\xe0\x33"
            "\x61\xe0\x44\x41\xe0\x63\x31\xe0\x74\x11\xe0\x94\xe0"
            "\xa3\xc0\xf1\xd4\xb0\xc1\x14\xe0\x72\x23\xe0\x62\x33"
            "\xe0\x61\x44\xe0\x41\x63\xe0\x31\x74\xe0\x11\x93\xe1"
            "\xa3\xd1\xb4\xa4\xa4\x78\x79\x41" }  },
      /* --- pixel bitmap for cmmi250 char#89 Y --- */
      {  89,29093,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 25,   24, 3,87, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0a\x87\x34\xd3\x63\xd1\x84\xb1\xa3\xa1\xb3\x92\xb4"
            "\x81\xd3\x71\xe4\x51\xe0\x23\x41\xe0\x33\x32\xe0\x34"
            "\x21\xe0\x53\x11\xe0\x64\xd0\xf3\x83\xe0\xf3\x73\xe0"
            "\x10\x63\xe0\x4b\xc1" }  },
      /* --- pixel bitmap for cmmi250 char#90 Z --- */
      {  90,30238,                      /* character number, location */
         24, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 23,   24, 3,97, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6e\x03\x64\x93\x63\xa3\x72\xa3\x81\xa4\x81\xa3\x81"
            "\xa3\x91\x93\xe0\x53\xe0\x53\xe0\x53\x90\xf1\xa3\xa0"
            "\x93\xe0\x53\xe0\x53\x81\xa3\x91\x93\x91\x93\xa1\x84"
            "\x92\x83\xa1\x83\xa2\x73\x93\x7e\x02\x70" }  },
      /* --- pixel bitmap for cmmi250 char#91 \flat --- */
      {  91,122038,                     /* character number, location */
         26, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          {  9,   27, 3,53, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf9\x01\x81\x15\x22\x42\x11\x61\x1f\x41\x62\x0f\x11"
            "\x52\x11\x42\x21\x41\x31\x32\x31\x22\x41\x12\x52\x71"
            "\x84" }  },
      /* --- pixel bitmap for cmmi250 char#92 \natural --- */
      {  92,122829,                     /* character number, location */
         26, 2,   -8, 2,      /* topleft row,col, and botleft row,col */
          {  9,   34, 3,34, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x01\x81\x54\x1e\x14\x51\x0f\xa1\x71\x01\x54\x1e"
            "\x14\x51\xf5\x81" }  },
      /* --- pixel bitmap for cmmi250 char#93 \sharp --- */
      {  93,123734,                     /* character number, location */
         25, 2,   -8, 2,      /* topleft row,col, and botleft row,col */
          {  9,   33, 3,59, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x71\x10\xf6\x11\x51\x10\x11\x43\x1e\x02\x13\x41\x10"
            "\xfa\x11\x51\x10\x11\x43\x1e\x02\x13\x41\x10\xf4\x11"
            "\x51\x10\x11\x70" }  },
      /* --- pixel bitmap for cmmi250 char#94 \smile --- */
      {  94,124704,                     /* character number, location */
         13, 2,    5, 2,      /* topleft row,col, and botleft row,col */
          { 31,    8, 3,45, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\xe0\xe0\x11\x11\xe0\xd1\x31\xe0\xb1\x52\xe0\x72"
            "\x73\xe0\x33\xa4\xb4\xee\x01\xe0\x59\xb1" }  },
      /* --- pixel bitmap for cmmi250 char#95 \frown --- */
      {  95,125582,                     /* character number, location */
         14, 2,    5, 2,      /* topleft row,col, and botleft row,col */
          { 31,    9, 3,52, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x11\xe0\xad\xe0\x2e\x03\xc3\xe0\x13\x92\xe0\x52"
            "\x71\xe0\x91\x51\xe0\xb1\x31\xe0\xd1\x11\xe0\xe0\x11" }  },
      /* --- pixel bitmap for cmmi250 char#96 \ell --- */
      {  96,98180,                      /* character number, location */
         24, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   24, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x1c\x80\x09\x30\x02\x84\x80\x21\x30\x08\x0c\x81"
            "\x41\x60\x08\x18\x02\x43\xc0\x08\x30\x01\x2c\x00\x05"
            "\x60\x01\x38\x00\x06\xc0\x01\x48\x00\x11\x00\x0c\x04"
            "\xc2\x00\x0f" }  },
      /* --- pixel bitmap for cmmi250 char#97 a --- */
      {  97,31204,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 14,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x09\x84\x83\xe0\x10\x30\x06\x8c\x80\x31\x60\x0c"
            "\x18\x03\x46\xc0\x10\x30\x06\x8c\x83\xa3\xd8\xc4\xe1"
            "\x00" }  },
      /* --- pixel bitmap for cmmi250 char#98 b --- */
      {  98,32064,                      /* character number, location */
         24, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 11,   24, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\x80\x01\x06\x30\x80\x01\x0c\x30\x80\x01\x0c\x60"
            "\x8f\x85\x1c\x6c\x60\x03\x0f\x78\xc0\x03\x1e\x70\xc0"
            "\x02\x16\x98\x41\x88\x81\x07" }  },
      /* --- pixel bitmap for cmmi250 char#99 c --- */
      {  99,32899,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 12,   15, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x64\x62\x41\x42\x43\x22\x53\x12\x62\x22\x9f\x42\xa2"
            "\x93\x81\x22\x52\x46\x42" }  },
      /* --- pixel bitmap for cmmi250 char#100 d --- */
      { 100,33879,                      /* character number, location */
         24, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 15,   24, 3,77, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa5\xd2\xf3\xc2\x10\xf2\xb2\x20\x54\x22\x61\x43\x61"
            "\x53\x51\x72\x42\x72\x41\x72\x4f\x22\x72\x41\x72\x5f"
            "\x11\x72\x31\x12\x53\x31\x21\x32\x12\x21\x43\x43\x34" }  },
      /* --- pixel bitmap for cmmi250 char#101 e --- */
      { 101,34750,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 12,   15, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x64\x62\x41\x41\x71\x21\x81\x12\x71\x12\x72\x19\x3f"
            "\x32\xa2\x91\x11\x81\x22\x52\x55\x42" }  },
      /* --- pixel bitmap for cmmi250 char#102 f --- */
      { 102,35936,                      /* character number, location */
         24, 2,   -7, 2,      /* topleft row,col, and botleft row,col */
          { 18,   31, 3,65, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xd4\xd1\x32\xb2\x23\xb1\x42\xf3\xa2\x60\x92\xd9\x30"
            "\xf2\x92\x70\xf5\x82\x80\xf4\x72\x90\xf2\x62\xa0\x12"
            "\x31\xb3\x22\xb2\x31\xd4\xd1" }  },
      /* --- pixel bitmap for cmmi250 char#103 g --- */
      { 103,36945,                      /* character number, location */
         15, 0,   -7, 0,      /* topleft row,col, and botleft row,col */
          { 15,   22, 3,79, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x84\x21\x71\x43\x61\x53\x51\x72\x42\x72\x41\x72\x10"
            "\xf2\x32\x72\x10\xf2\x31\x72\x20\x32\x53\x61\x34\x83"
            "\x22\x30\xf1\xa2\x30\x92\x52\x62\x43\x52\x52\x52\x76"
            "\x82" }  },
      /* --- pixel bitmap for cmmi250 char#104 h --- */
      { 104,37926,                      /* character number, location */
         24, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 16,   24, 3,89, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x35\xe2\x80\xf3\x52\x90\xf2\x42\xa0\x42\x24\x72\x12"
            "\x32\x30\xf1\x33\x62\x20\x32\x72\x20\xf2\x22\x72\x30"
            "\x22\x62\x52\x72\x52\x72\x31\x12\x62\x41\x12\x62\x31"
            "\x12\x81\x22\x12\x92\x33" }  },
      /* --- pixel bitmap for cmmi250 char#105 i --- */
      { 105,38824,                      /* character number, location */
         24, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   24, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x81\x03\x06\x00\x00\x00\x00\x00\x00\x70\x90\x11"
            "\x26\x46\x0c\x18\x18\x30\x30\x60\xc0\xc8\x90\x11\x22"
            "\x38" }  },
      /* --- pixel bitmap for cmmi250 char#106 j --- */
      { 106,39787,                      /* character number, location */
         24, 0,   -7, 0,      /* topleft row,col, and botleft row,col */
          { 14,   31, 3,65, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc2\xb3\xc2\xf5\xe0\x83\xa1\x31\x81\x42\x10\xf1\x51"
            "\x52\x10\xf3\xa2\x20\xf3\x92\x30\xf3\x82\x40\x72\x62"
            "\x42\x53\x32\x62\x32\x84\x91" }  },
      /* --- pixel bitmap for cmmi250 char#107 k --- */
      { 107,40848,                      /* character number, location */
         24, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 15,   24, 3,83, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x35\xd2\x70\xf3\x52\x80\xf2\x42\x90\x42\x53\x42\x51"
            "\x22\x32\x41\x23\x32\x31\x32\x42\x21\x92\x12\xa4\xb2"
            "\x23\x82\x42\x62\x52\x50\xf2\x12\x52\x31\x12\x62\x21"
            "\x22\x73\x32" }  },
      /* --- pixel bitmap for cmmi250 char#108 l --- */
      { 108,41608,                      /* character number, location */
         24, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  7,   24, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x30\x0c\x06\x83\x61\x30\x18\x0c\x83\xc1\x60\x18"
            "\x0c\x06\xc3\x60\x34\x1a\x4d\x1c" }  },
      /* --- pixel bitmap for cmmi250 char#109 m --- */
      { 109,42851,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 28,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x7c\xf0\x40\x22\xcc\x18\x62\x81\x02\x23\x0e\x38"
            "\x30\x62\x80\x01\x03\x07\x0c\x18\x30\xc0\x80\x01\x03"
            "\x0c\x18\x30\xc0\xc0\x80\x01\x06\x0c\x18\x60\xc0\x88"
            "\x01\x06\x86\x18\x60\x60\xc4\x00\x03\x44\x0c\x30\x80"
            "\x03" }  },
      /* --- pixel bitmap for cmmi250 char#110 n --- */
      { 110,43954,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x3c\x90\x8c\x21\x0e\x8c\x38\x30\x62\xc0\xc0\x80"
            "\x01\x03\x06\x0c\x18\x30\x30\x60\xc0\x80\x01\x23\x06"
            "\x86\x18\x18\x31\x40\xc6\x00\x06" }  },
      /* --- pixel bitmap for cmmi250 char#111 o --- */
      { 111,44706,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 13,   15, 3,47, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x64\x72\x41\x52\x61\x32\x72\xf1\x12\x82\x0f\x22\x92"
            "\x0f\x12\x82\x12\x72\x22\x62\x42\x42\x74\x62" }  },
      /* --- pixel bitmap for cmmi250 char#112 p --- */
      { 112,45714,                      /* character number, location */
         15,-1,   -7,-1,      /* topleft row,col, and botleft row,col */
          { 17,   22, 3,73, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x52\x44\x61\x21\x21\x41\x41\x33\x52\xf1\x31\x32\x62"
            "\xf3\x62\x72\xf1\x52\x72\x10\x52\x62\x72\x61\x72\x11"
            "\x32\x82\x24\x50\xf1\x42\xb0\xf3\x32\xc7\xa2" }  },
      /* --- pixel bitmap for cmmi250 char#113 q --- */
      { 113,46647,                      /* character number, location */
         15, 2,   -7, 2,      /* topleft row,col, and botleft row,col */
          { 13,   22, 3,67, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x54\x31\x41\x41\x11\x41\x53\x31\x72\x22\x72\x21\x72"
            "\x2f\x22\x72\x2f\x21\x72\x32\x53\x41\x34\x63\x22\x40"
            "\xf1\x72\x40\xf3\x62\x50\x37\x33" }  },
      /* --- pixel bitmap for cmmi250 char#114 r --- */
      { 114,47564,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   15, 3,47, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x32\x44\x31\x21\x21\x32\x11\x33\x33\x11\x32\x42\x21"
            "\x32\x70\xf3\x42\x80\xf3\x32\x90\xf1\x22\xa3" }  },
      /* --- pixel bitmap for cmmi250 char#115 s --- */
      { 115,48544,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 12,   15, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x64\x62\x42\xf1\x32\x43\x32\x42\x43\x96\x85\xa3\xa2"
            "\x1f\x13\x62\x12\x62\x31\x52\x56\x41" }  },
      /* --- pixel bitmap for cmmi250 char#116 t --- */
      { 116,49306,                      /* character number, location */
         21, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 11,   21, 3,47, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf2\x52\x40\xf2\x42\x5b\xf3\x32\x60\xf3\x22\x70\x12"
            "\x80\xf1\x12\x51\x20\x12\x41\x42\x31\x64\x53" }  },
      /* --- pixel bitmap for cmmi250 char#117 u --- */
      { 117,50364,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x40\x88\xc0\x08\x81\x11\x03\x23\x06\x06\x0c\x06"
            "\x0c\x0c\x18\x18\x30\x30\x30\x30\x60\x60\xc4\xc0\x88"
            "\xc1\x11\x46\x13\x78\x1c" }  },
      /* --- pixel bitmap for cmmi250 char#118 v --- */
      { 118,51309,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x20\x22\xb0\x10\x58\x0c\x2c\x06\x06\x03\xc1\x80"
            "\x60\x40\x30\x20\x0c\x08\x06\x04\x03\x01\x41\x80\x31"
            "\x80\x07\x00" }  },
      /* --- pixel bitmap for cmmi250 char#119 w --- */
      { 119,52537,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 23,   15, 3,85, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x33\x81\x61\x31\x31\x62\x62\x11\x41\x62\x62\xf1\x11"
            "\x32\x62\x62\x52\x52\x71\x10\xf2\x42\x62\x71\x10\xf1"
            "\x32\x62\x71\x20\x32\x62\x61\x71\x62\x61\x72\x41\x12"
            "\x41\xa4\x35\x52" }  },
      /* --- pixel bitmap for cmmi250 char#120 x --- */
      { 120,53803,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\xe1\x41\x6c\x8c\x60\x38\x81\x61\x04\x06\x00\x0c"
            "\x00\x30\x00\xc0\x00\x00\x03\x00\x06\x00\x18\xc8\x60"
            "\x20\xc7\x41\x8c\x85\xe0\xe1\x01" }  },
      /* --- pixel bitmap for cmmi250 char#121 y --- */
      { 121,54927,                      /* character number, location */
         15, 1,   -7, 1,      /* topleft row,col, and botleft row,col */
          { 15,   22, 3,81, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x33\x81\x21\x31\x62\x11\x41\x62\xf1\x11\x32\x62\x52"
            "\x52\x10\xf2\x42\x62\x10\xf2\x32\x62\x20\x32\x53\x62"
            "\x33\x84\x12\xd2\xd1\x62\x52\x53\x42\x62\x51\x81\x32"
            "\xa4\x84" }  },
      /* --- pixel bitmap for cmmi250 char#122 z --- */
      { 122,55891,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x54\x51\x46\x31\x42\x44\x51\x71\xd1\xd1\xd1\xd1\xd1"
            "\xc2\xc1\x81\x41\x91\x45\x32\x41\x45\x41\x63\x53" }  },
      /* --- pixel bitmap for cmmi250 char#123 \imath --- */
      { 123,98964,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\xc8\x08\x13\x23\x06\x0c\x0c\x18\x18\x30\x60\x64"
            "\xc8\x08\x11\x1c" }  },
      /* --- pixel bitmap for cmmi250 char#124 \jmath --- */
      { 124,99807,                      /* character number, location */
         15, 0,   -7, 0,      /* topleft row,col, and botleft row,col */
          { 13,   22, 3,51, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x83\x91\x31\x71\x42\xf1\x51\x52\xf3\xa2\x10\xf3\x92"
            "\x20\xf3\x82\x30\x72\x52\x42\x43\x32\x52\x32\x75\x71" }  },
      /* --- pixel bitmap for cmmi250 char#125 \wp --- */
      { 125,100950,                     /* character number, location */
         16, 2,   -8, 2,      /* topleft row,col, and botleft row,col */
          { 19,   24, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\x00\x80\x81\x0f\x06\xc3\x10\x04\xcc\x18\x60\x26"
            "\x00\x1b\x01\xd8\x04\xc0\x16\x00\xb6\x00\xb0\x03\xc0"
            "\x1c\x00\xc6\x20\x18\x0e\x41\xe8\x88\x41\x86\x07\x62"
            "\x00\x10\x03\x40\x18\x00\xc2\x00\x10\x06\x80\x18\x00"
            "\x4c\x00\xc0\x01\x00" }  },
      /* --- pixel bitmap for cmmi250 char#126 \vec --- */
      { 126,101632,                     /* character number, location */
         24, 6,   17, 6,      /* topleft row,col, and botleft row,col */
          { 15,    7, 3,17, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb2\xd3\x1f\x1e\x01\xa3\xc2\xd1\x41" }  },
      /* --- pixel bitmap for cmmi250 char#127 (noname) --- */
      { 127,102176,                     /* character number, location */
         23,10,   19,10,      /* topleft row,col, and botleft row,col */
          { 13,    4, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x46\x52\x62\x21\xa2\xb1" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* ------------------------------------------------------------------------
font sizes 0-7 for cmmib10
------------------------------------------------------------------------ */

/* --- size=0 for .83gf ---
 * mf '\mode=eighthre;  input cmmib10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmmib83 --- */
static	chardef  cmmib83[] =
   {
      /* --- pixel bitmap for cmmib83 char#0 \Gamma --- */
      {   0, 1593,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x31\x33\x62\xc0\x80\x81\x81\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#1 \Delta --- */
      {   1, 1620,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\xc0\x81\x83\x86\x9c\x30\x7f\xff" }  },
      /* --- pixel bitmap for cmmib83 char#2 \Theta --- */
      {   2, 1649,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\xb3\xf8\xff\x1f\xcd\x1c" }  },
      /* --- pixel bitmap for cmmib83 char#3 \Lambda --- */
      {   3, 1680,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\x60\x70\x70\x68\x6c\x64\xf7" }  },
      /* --- pixel bitmap for cmmib83 char#4 \Xi --- */
      {   4, 1711,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\xf1\x13\xc2\x83\x47\xe0\xbf\x7f" }  },
      /* --- pixel bitmap for cmmib83 char#5 \Pi --- */
      {   5, 1738,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xc7\x18\x63\x18\xc3\x18\xc6\x18\xe3\x3d" }  },
      /* --- pixel bitmap for cmmib83 char#6 \Sigma --- */
      {   6, 1775,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x39\x63\xc2\x01\x03\x13\x11\x3f" }  },
      /* --- pixel bitmap for cmmib83 char#7 \Upsilon --- */
      {   7, 1806,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb7\x3b\x83\xc1\x60\x18\x1e" }  },
      /* --- pixel bitmap for cmmib83 char#8 \Phi --- */
      {   8, 1833,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x98\x6f\xbf\xf7\x31\x7c" }  },
      /* --- pixel bitmap for cmmib83 char#9 \Psi --- */
      {   9, 1860,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\xd8\x7e\xbf\xf7\x31\x3c" }  },
      /* --- pixel bitmap for cmmib83 char#10 \Omega --- */
      {  10, 1889,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\xcc\xc6\xc6\x46\xe6\x67\x77" }  },
      /* --- pixel bitmap for cmmib83 char#11 \alpha --- */
      {  11, 1926,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6e\x1c\x65\x27" }  },
      /* --- pixel bitmap for cmmib83 char#12 \beta --- */
      {  12, 1953,                      /* character number, location */
          8, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\xa2\xc8\x23\x12\x4d\x1e\x81\x00" }  },
      /* --- pixel bitmap for cmmib83 char#13 \gamma --- */
      {  13, 1990,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x36\x63\x84\x10\x02" }  },
      /* --- pixel bitmap for cmmib83 char#14 \delta --- */
      {  14, 2015,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x10\x93\x52\x39" }  },
      /* --- pixel bitmap for cmmib83 char#15 \epsilon --- */
      {  15, 2044,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\x17\x0e" }  },
      /* --- pixel bitmap for cmmib83 char#16 \zeta --- */
      {  16, 2061,                      /* character number, location */
          8, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  5,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x84\x8b\x10\x42\x18\xc4\x00" }  },
      /* --- pixel bitmap for cmmib83 char#17 \eta --- */
      {  17, 2088,                      /* character number, location */
          5, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xdb\x29\x46\x11\x04\x01" }  },
      /* --- pixel bitmap for cmmib83 char#18 \theta --- */
      {  18, 2119,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4c\xca\xff\x53\x32" }  },
      /* --- pixel bitmap for cmmib83 char#19 \iota --- */
      {  19, 2150,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  3,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x92\x7a" }  },
      /* --- pixel bitmap for cmmib83 char#20 \kappa --- */
      {  20, 2169,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb2\xe3\xc5\x21" }  },
      /* --- pixel bitmap for cmmib83 char#21 \lambda --- */
      {  21, 2192,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\x20\x84\xa8\x8c" }  },
      /* --- pixel bitmap for cmmib83 char#22 \mu --- */
      {  22, 2221,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa2\x28\xc6\x6f\x10\x00" }  },
      /* --- pixel bitmap for cmmib83 char#23 \nu --- */
      {  23, 2252,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa3\x28\x35\x03" }  },
      /* --- pixel bitmap for cmmib83 char#24 \xi --- */
      {  24, 2277,                      /* character number, location */
          8, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  5,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x88\x0b\xc1\x44\x10\xcc\x01" }  },
      /* --- pixel bitmap for cmmib83 char#25 \pi --- */
      {  25, 2304,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\xa2\x28\x09" }  },
      /* --- pixel bitmap for cmmib83 char#26 \rho --- */
      {  26, 2329,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x28\x4e\x4f\x10\x00" }  },
      /* --- pixel bitmap for cmmib83 char#27 \sigma --- */
      {  27, 2356,                      /* character number, location */
          5, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  6,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7e\x92\x14\x03" }  },
      /* --- pixel bitmap for cmmib83 char#28 \tau --- */
      {  28, 2379,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7e\x41\x08\x02" }  },
      /* --- pixel bitmap for cmmib83 char#29 \upsilon --- */
      {  29, 2398,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xd3\x28\x46\x0e" }  },
      /* --- pixel bitmap for cmmib83 char#30 \phi --- */
      {  30, 2423,                      /* character number, location */
          8, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x08\xc2\x97\x4c\x96\x3c\x04\x02" }  },
      /* --- pixel bitmap for cmmib83 char#31 \chi --- */
      {  31, 2462,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  7,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x42\x13\x06\x41\x11\x85\x01" }  },
      /* --- pixel bitmap for cmmib83 char#32 \psi --- */
      {  32, 2493,                      /* character number, location */
          8, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x08\x64\xb5\x54\xaa\x3c\x04\x02" }  },
      /* --- pixel bitmap for cmmib83 char#33 \omega --- */
      {  33, 2536,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa2\x64\xb2\xb5\x01" }  },
      /* --- pixel bitmap for cmmib83 char#34 \varepsilon --- */
      {  34, 2569,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2c\x12\x0e" }  },
      /* --- pixel bitmap for cmmib83 char#35 \vartheta --- */
      {  35, 2586,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x8a\xee\xa3\x14\x39" }  },
      /* --- pixel bitmap for cmmib83 char#36 \varpi --- */
      {  36, 2621,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x8f\x24\x52\x2c\x6e\x00" }  },
      /* --- pixel bitmap for cmmib83 char#37 \varrho --- */
      {  37, 2652,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x28\x4e\x4f\xe0\x00" }  },
      /* --- pixel bitmap for cmmib83 char#38 \varsigma --- */
      {  38, 2679,                      /* character number, location */
          5, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          {  3,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4e\x46\x01" }  },
      /* --- pixel bitmap for cmmib83 char#39 \varphi --- */
      {  39, 2698,                      /* character number, location */
          5, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  7,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb2\x64\xb2\xe4\x21\x10\x00" }  },
      /* --- pixel bitmap for cmmib83 char#40 \bfleftharpoonup --- */
      {  40, 3124,                      /* character number, location */
          5, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          { 10,    3, 3, 6, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x21\x82\x7a" }  },
      /* --- pixel bitmap for cmmib83 char#41 \bfleftharpoondown --- */
      {  41, 3137,                      /* character number, location */
          3, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x1b\x40\x00" }  },
      /* --- pixel bitmap for cmmib83 char#42 \bfrightharpoonup --- */
      {  42, 3150,                      /* character number, location */
          5, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          { 10,    3, 3, 6, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x71\x92\x1a" }  },
      /* --- pixel bitmap for cmmib83 char#43 \bfrightharpoondown --- */
      {  43, 3163,                      /* character number, location */
          3, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x03\x06\x08" }  },
      /* --- pixel bitmap for cmmib83 char#44 ` --- */
      {  44, 3176,                      /* character number, location */
          7, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          {  1,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f" }  },
      /* --- pixel bitmap for cmmib83 char#45 ' --- */
      {  45, 3193,                      /* character number, location */
          7, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          {  1,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f" }  },
      /* --- pixel bitmap for cmmib83 char#46 \triangleright --- */
      {  46, 3210,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x71\x79\x01" }  },
      /* --- pixel bitmap for cmmib83 char#47 \triangleleft --- */
      {  47, 3229,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe8\xe9\x08" }  },
      /* --- pixel bitmap for cmmib83 char#48 \0 --- */
      {  48, 2892,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x18\x86\x1e" }  },
      /* --- pixel bitmap for cmmib83 char#49 \1 --- */
      {  49, 2915,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  3,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x93\x74" }  },
      /* --- pixel bitmap for cmmib83 char#50 \2 --- */
      {  50, 2932,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x97\xe8\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#51 \3 --- */
      {  51, 2951,                      /* character number, location */
          5, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa6\x31\x87\xb7\x03" }  },
      /* --- pixel bitmap for cmmib83 char#52 \4 --- */
      {  52, 2976,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x67\x4d\x3f\x84\x03" }  },
      /* --- pixel bitmap for cmmib83 char#53 \5 --- */
      {  53, 3001,                      /* character number, location */
          5, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7f\x71\xdc\x06" }  },
      /* --- pixel bitmap for cmmib83 char#54 \6 --- */
      {  54, 3024,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\x71\x99\x06" }  },
      /* --- pixel bitmap for cmmib83 char#55 \7 --- */
      {  55, 3049,                      /* character number, location */
          5, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3f\x22\x22\x84\x00" }  },
      /* --- pixel bitmap for cmmib83 char#56 \8 --- */
      {  56, 3072,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x96\xef\x9d\x06" }  },
      /* --- pixel bitmap for cmmib83 char#57 \9 --- */
      {  57, 3099,                      /* character number, location */
          5, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x96\xe9\x88\x07" }  },
      /* --- pixel bitmap for cmmib83 char#58 . --- */
      {  58, 3248,                      /* character number, location */
          2, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  2,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#59 , --- */
      {  59, 3259,                      /* character number, location */
          2, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  2,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6f" }  },
      /* --- pixel bitmap for cmmib83 char#60 < --- */
      {  60, 3274,                      /* character number, location */
          7, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x18\xc2\x10\x30\x20\x60\x40" }  },
      /* --- pixel bitmap for cmmib83 char#61 / --- */
      {  61, 3299,                      /* character number, location */
          9, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  4,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x88\x44\x44\x22\x22\x11" }  },
      /* --- pixel bitmap for cmmib83 char#62 > --- */
      {  62, 3330,                      /* character number, location */
          7, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\x03\x02\x06\x84\x21\x0c\x01" }  },
      /* --- pixel bitmap for cmmib83 char#63 \star --- */
      {  63, 3355,                      /* character number, location */
          3,-1,    1,-1,      /* topleft row,col, and botleft row,col */
          {  6,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x06" }  },
      /* --- pixel bitmap for cmmib83 char#64 \partial --- */
      {  64, 2733,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x09\xfa\x61\x14\x3d" }  },
      /* --- pixel bitmap for cmmib83 char#65 A --- */
      {  65,   35,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\xc0\x80\x81\x83\x06\x1f\xb1\xf3" }  },
      /* --- pixel bitmap for cmmib83 char#66 B --- */
      {  66,   64,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x30\x33\xe3\xc7\x8c\x99\x99\x1f" }  },
      /* --- pixel bitmap for cmmib83 char#67 C --- */
      {  67,   97,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\xc4\x46\x03\x03\x43\x23\x1e" }  },
      /* --- pixel bitmap for cmmib83 char#68 D --- */
      {  68,  128,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x30\x33\x66\xcc\x98\x91\xb1\x3f" }  },
      /* --- pixel bitmap for cmmib83 char#69 E --- */
      {  69,  163,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x31\xb3\xe2\xc1\x92\xa1\xa1\x7f" }  },
      /* --- pixel bitmap for cmmib83 char#70 F --- */
      {  70,  200,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x31\xb3\xe2\xc1\x82\x81\x81\x07" }  },
      /* --- pixel bitmap for cmmib83 char#71 G --- */
      {  71,  231,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\xc4\x46\x03\xfb\x63\x33\x3e" }  },
      /* --- pixel bitmap for cmmib83 char#72 H --- */
      {  72,  264,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\xc7\x18\x63\xf8\xc3\x18\xc6\x18\xe3\x3d" }  },
      /* --- pixel bitmap for cmmib83 char#73 I --- */
      {  73,  301,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\xc6\x30\x0c\x63\x3c" }  },
      /* --- pixel bitmap for cmmib83 char#74 J --- */
      {  74,  324,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x60\x30\x30\x30\x30\x1b\x0e" }  },
      /* --- pixel bitmap for cmmib83 char#75 K --- */
      {  75,  349,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\xc7\x04\x1b\x78\xc0\x06\x36\x98\xe1\x39" }  },
      /* --- pixel bitmap for cmmib83 char#76 L --- */
      {  76,  386,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x18\x0c\x0c\x8c\x8c\x46\x7f" }  },
      /* --- pixel bitmap for cmmib83 char#77 M --- */
      {  77,  415,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x3c\x8e\x46\xe3\xd0\x34\xb4\x0c\x39\x23\x66\x9c"
            "\x3c" }  },
      /* --- pixel bitmap for cmmib83 char#78 N --- */
      {  78,  472,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\xc7\x11\x5d\xc8\x42\x1e\xe2\x08\xe3\x10" }  },
      /* --- pixel bitmap for cmmib83 char#79 O --- */
      {  79,  515,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\xb3\x78\x3c\x1e\xcd\x1c" }  },
      /* --- pixel bitmap for cmmib83 char#80 P --- */
      {  80,  550,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x98\xcc\xcc\x7c\x0c\x06\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#81 Q --- */
      {  81,  579,                      /* character number, location */
          8, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\xb3\x78\x3c\x1e\xfd\x1c\x30\x08" }  },
      /* --- pixel bitmap for cmmib83 char#82 R --- */
      {  82,  616,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x30\x33\xe3\xc3\x8c\x99\x99\xe7" }  },
      /* --- pixel bitmap for cmmib83 char#83 S --- */
      {  83,  651,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x6b\x38\x1c\xd6\x1c" }  },
      /* --- pixel bitmap for cmmib83 char#84 T --- */
      {  84,  678,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x65\x67\xc2\x80\x01\x03\x03\x1f" }  },
      /* --- pixel bitmap for cmmib83 char#85 U --- */
      {  85,  709,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcf\x0d\x0d\x19\x32\x64\xc8\x08\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#86 V --- */
      {  86,  746,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcf\x8d\x98\x70\xc1\x81\x03\x03\x02" }  },
      /* --- pixel bitmap for cmmib83 char#87 W --- */
      {  87,  777,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xef\xdd\x9c\x98\x1b\x6b\x61\x1d\x9c\x83\x31\x20\x06" }  },
      /* --- pixel bitmap for cmmib83 char#88 X --- */
      {  88,  828,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\xc3\x02\x07\x1c\x70\xe0\x81\xc6\x7b" }  },
      /* --- pixel bitmap for cmmib83 char#89 Y --- */
      {  89,  859,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcf\x99\xb0\xe0\x81\x01\x03\x03\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#90 Z --- */
      {  90,  888,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x9a\x0e\xc3\x72\x59\x3e" }  },
      /* --- pixel bitmap for cmmib83 char#91 \flat --- */
      {  91, 3366,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  2,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x55\xff\x01" }  },
      /* --- pixel bitmap for cmmib83 char#92 \natural --- */
      {  92, 3391,                      /* character number, location */
          8, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  4,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x11\xbd\x99\xd9\x8b" }  },
      /* --- pixel bitmap for cmmib83 char#93 \sharp --- */
      {  93, 3432,                      /* character number, location */
          8, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  2,   10, 3, 4, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf9\x02" }  },
      /* --- pixel bitmap for cmmib83 char#94 \smile --- */
      {  94, 3459,                      /* character number, location */
          5, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          { 10,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\x0a\xc4\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#95 \frown --- */
      {  95, 3476,                      /* character number, location */
          5, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          { 10,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x08\x14\x20" }  },
      /* --- pixel bitmap for cmmib83 char#96 \ell --- */
      {  96, 2764,                      /* character number, location */
          8,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x4a\x51\x0c\x61\xe0" }  },
      /* --- pixel bitmap for cmmib83 char#97 a --- */
      {  97,  921,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\xc6\x7c\x01" }  },
      /* --- pixel bitmap for cmmib83 char#98 b --- */
      {  98,  946,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x43\x84\x17\x63\x3a" }  },
      /* --- pixel bitmap for cmmib83 char#99 c --- */
      {  99,  975,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9e\x11\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#100 d --- */
      { 100,  994,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x08\x79\x51\x94\x5d" }  },
      /* --- pixel bitmap for cmmib83 char#101 e --- */
      { 101, 1025,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\xbe\xf0\x00" }  },
      /* --- pixel bitmap for cmmib83 char#102 f --- */
      { 102, 1044,                      /* character number, location */
          8, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  5,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x98\x10\x47\x88\x10\x22\x00" }  },
      /* --- pixel bitmap for cmmib83 char#103 g --- */
      { 103, 1071,                      /* character number, location */
          5, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\xc6\xf4\xd0\x01" }  },
      /* --- pixel bitmap for cmmib83 char#104 h --- */
      { 104, 1098,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x21\x68\xa6\x18\xc7" }  },
      /* --- pixel bitmap for cmmib83 char#105 i --- */
      { 105, 1131,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  3,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\xb0\x69\x03" }  },
      /* --- pixel bitmap for cmmib83 char#106 j --- */
      { 106, 1152,                      /* character number, location */
          9, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  5,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x00\xc0\x14\x22\x84\x0c" }  },
      /* --- pixel bitmap for cmmib83 char#107 k --- */
      { 107, 1179,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x21\xc8\xae\x93\x45" }  },
      /* --- pixel bitmap for cmmib83 char#108 l --- */
      { 108, 1210,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  3,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa6\x24\x4d" }  },
      /* --- pixel bitmap for cmmib83 char#109 m --- */
      { 109, 1233,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xdb\x4e\x8a\x8c\x1c\x19" }  },
      /* --- pixel bitmap for cmmib83 char#110 n --- */
      { 110, 1270,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6f\xca\x9c\x01" }  },
      /* --- pixel bitmap for cmmib83 char#111 o --- */
      { 111, 1295,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x18\x46\x0f" }  },
      /* --- pixel bitmap for cmmib83 char#112 p --- */
      { 112, 1318,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  7,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\x23\xd1\xe4\x11\x0c\x00" }  },
      /* --- pixel bitmap for cmmib83 char#113 q --- */
      { 113, 1345,                      /* character number, location */
          5, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\xc6\xf4\x10\x03" }  },
      /* --- pixel bitmap for cmmib83 char#114 r --- */
      { 114, 1372,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbf\x12\x01" }  },
      /* --- pixel bitmap for cmmib83 char#115 s --- */
      { 115, 1391,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcc\x8c\x0e" }  },
      /* --- pixel bitmap for cmmib83 char#116 t --- */
      { 116, 1408,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  3,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xd4\xa5\x09" }  },
      /* --- pixel bitmap for cmmib83 char#117 u --- */
      { 117, 1429,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x73\xca\x6c\x01" }  },
      /* --- pixel bitmap for cmmib83 char#118 v --- */
      { 118, 1456,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x73\xca\x64\x00" }  },
      /* --- pixel bitmap for cmmib83 char#119 w --- */
      { 119, 1481,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x53\x93\x92\x49\x36" }  },
      /* --- pixel bitmap for cmmib83 char#120 x --- */
      { 120, 1516,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x94\x8a\x54\x1e" }  },
      /* --- pixel bitmap for cmmib83 char#121 y --- */
      { 121, 1543,                      /* character number, location */
          5, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x73\xca\xe4\xd0\x01" }  },
      /* --- pixel bitmap for cmmib83 char#122 z --- */
      { 122, 1572,                      /* character number, location */
          5, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\x11\xf5\x00" }  },
      /* --- pixel bitmap for cmmib83 char#123 \imath --- */
      { 123, 2793,                      /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  2,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xef\x03" }  },
      /* --- pixel bitmap for cmmib83 char#124 \jmath --- */
      { 124, 2810,                      /* character number, location */
          5, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  3,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x36\x25\x05" }  },
      /* --- pixel bitmap for cmmib83 char#125 \wp --- */
      { 125, 2831,                      /* character number, location */
          5, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  8,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x74\x8e\x82\x42\x35\x05\x02" }  },
      /* --- pixel bitmap for cmmib83 char#126 \bfvec --- */
      { 126, 2866,                      /* character number, location */
          9, 2,    6, 2,      /* topleft row,col, and botleft row,col */
          {  6,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xd0\x0f\x01" }  },
      /* --- pixel bitmap for cmmib83 char#127 (noname) --- */
      { 127, 2879,                      /* character number, location */
          8, 3,    6, 3,      /* topleft row,col, and botleft row,col */
          {  5,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2e\x02" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=1 for .100gf ---
 * mf '\mode=preview; mag=magstep(-17.87427405946994351363); input cmmib10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmmib100 --- */
static	chardef  cmmib100[] =
   {
      /* --- pixel bitmap for cmmib100 char#0 \Gamma --- */
      {   0,52539,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x63\x8c\x21\x43\x0c\x30\xc0\x80\x01\x1f\x00" }  },
      /* --- pixel bitmap for cmmib100 char#1 \Delta --- */
      {   1,53404,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x00\x0e\x68\x20\x87\x31\x84\x11\xdc\xff\xff\x07" }  },
      /* --- pixel bitmap for cmmib100 char#2 \Theta --- */
      {   2,54527,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x31\x6c\xf0\xcc\x33\x0f\x3c\xd8\x31\x7c\x00" }  },
      /* --- pixel bitmap for cmmib100 char#3 \Lambda --- */
      {   3,55425,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x80\x01\x0e\x34\xc8\x20\x43\x8c\x31\xe7\x03" }  },
      /* --- pixel bitmap for cmmib100 char#4 \Xi --- */
      {   4,56802,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    9, 3,23, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x29\x21\x71\xf1\x27\x20\xc1\x71\x1f\x19\x22" }  },
      /* --- pixel bitmap for cmmib100 char#5 \Pi --- */
      {   5,58019,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,    9, 3,27, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2b\xf1\x32\x42\x20\xf3\x22\x42\x30\x12\x42\x44\x25"
            "\x22" }  },
      /* --- pixel bitmap for cmmib100 char#6 \Sigma --- */
      {   6,59174,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xe7\x30\x8e\xe1\x04\x06\x10\x61\x8c\x20\xfe\x01" }  },
      /* --- pixel bitmap for cmmib100 char#7 \Upsilon --- */
      {   7,60190,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xce\xbd\x8f\x03\x06\x18\x60\x80\x01\x03\x3f\x00" }  },
      /* --- pixel bitmap for cmmib100 char#8 \Phi --- */
      {   8,61216,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\xc1\xf0\xb3\x3d\x7b\xb6\x1f\x0c\x7e\x00" }  },
      /* --- pixel bitmap for cmmib100 char#9 \Psi --- */
      {   9,62271,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xc0\x30\xfb\x36\xdb\xec\xe1\x03\x03\x3f\x00" }  },
      /* --- pixel bitmap for cmmib100 char#10 \Omega --- */
      {  10,63456,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x61\x18\x83\x0d\x66\x30\x82\x18\xea\x30\xc7\x01" }  },
      /* --- pixel bitmap for cmmib100 char#11 \alpha --- */
      {  11,64424,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\xcc\x0f\x1f\x36\xce\x33" }  },
      /* --- pixel bitmap for cmmib100 char#12 \beta --- */
      {  12,65445,                      /* character number, location */
         10, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  9,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x20\x23\x46\x4c\x8f\x1e\x31\x62\x66\x74\x08\x10"
            "\x10\x00" }  },
      /* --- pixel bitmap for cmmib100 char#13 \gamma --- */
      {  13,66310,                      /* character number, location */
          6, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8e\x9f\x71\x60\x60\x20\x20\x20\x10" }  },
      /* --- pixel bitmap for cmmib100 char#14 \delta --- */
      {  14,67177,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x4e\x32\x18\x67\xcf\xf3\xe6\x00" }  },
      /* --- pixel bitmap for cmmib100 char#15 \epsilon --- */
      {  15,67981,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\xf0\x0d\xa3\x07" }  },
      /* --- pixel bitmap for cmmib100 char#16 \zeta --- */
      {  16,68853,                      /* character number, location */
         10, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  6,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\xce\x1b\xc2\x30\x0c\xc3\xe3\x41\x1c" }  },
      /* --- pixel bitmap for cmmib100 char#17 \eta --- */
      {  17,69686,                      /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x77\xcf\xc6\xc6\x63\x63\x60\x60\x20" }  },
      /* --- pixel bitmap for cmmib100 char#18 \theta --- */
      {  18,70422,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\xa6\xd1\xf8\xff\x8f\x67\x13\x07" }  },
      /* --- pixel bitmap for cmmib100 char#19 \iota --- */
      {  19,71067,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  4,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x64\x66\x6b" }  },
      /* --- pixel bitmap for cmmib100 char#20 \kappa --- */
      {  20,71961,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc4\xf6\x3e\x66\xe3\xc3" }  },
      /* --- pixel bitmap for cmmib100 char#21 \lambda --- */
      {  21,72770,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x70\xc0\x80\x01\x06\x0c\x1c\x66\xc6\x84\x03" }  },
      /* --- pixel bitmap for cmmib100 char#22 \mu --- */
      {  22,73786,                      /* character number, location */
          6, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x19\x33\x66\xec\xdc\xb7\x01\x03\x02\x00" }  },
      /* --- pixel bitmap for cmmib100 char#23 \nu --- */
      {  23,74527,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07\x0d\x1b\x36\xb7\xe3\x00" }  },
      /* --- pixel bitmap for cmmib100 char#24 \xi --- */
      {  24,75605,                      /* character number, location */
         10, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  7,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x38\x9b\x61\xe0\xf1\x0c\x83\x87\x0f\x86\x03" }  },
      /* --- pixel bitmap for cmmib100 char#25 \pi --- */
      {  25,76463,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\xff\xb3\x20\x61\xc6\x0c" }  },
      /* --- pixel bitmap for cmmib100 char#26 \rho --- */
      {  26,77281,                      /* character number, location */
          6, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x10\x33\x66\x6c\xcc\x8f\x01\x03\x02\x00" }  },
      /* --- pixel bitmap for cmmib100 char#27 \sigma --- */
      {  27,78119,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xfd\x8f\x19\x33\xc3\x03" }  },
      /* --- pixel bitmap for cmmib100 char#28 \tau --- */
      {  28,78822,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\xff\x18\x08\x0c\x0c" }  },
      /* --- pixel bitmap for cmmib100 char#29 \upsilon --- */
      {  29,79695,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x46\xc7\x86\x46\x46\x3c" }  },
      /* --- pixel bitmap for cmmib100 char#30 \phi --- */
      {  30,80501,                      /* character number, location */
         10, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          { 10,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x00\x01\x02\x08\xfc\x98\x34\xf1\xc4\x93\xf9\x81"
            "\x00\x02\x08\x00" }  },
      /* --- pixel bitmap for cmmib100 char#31 \chi --- */
      {  31,81468,                      /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\x1b\x61\xc1\x81\x01\x07\x0d\x31\xe1\x00" }  },
      /* --- pixel bitmap for cmmib100 char#32 \psi --- */
      {  32,82451,                      /* character number, location */
         10, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          { 10,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x00\x01\x04\x10\x26\x9d\x6c\xa2\x49\x96\xf1\x01"
            "\x01\x04\x08\x00" }  },
      /* --- pixel bitmap for cmmib100 char#33 \omega --- */
      {  33,83490,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\x05\x1c\x63\xcc\xff\xb9\x03" }  },
      /* --- pixel bitmap for cmmib100 char#34 \varepsilon --- */
      {  34,84415,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\xbf\xf3\x1f" }  },
      /* --- pixel bitmap for cmmib100 char#35 \vartheta --- */
      {  35,85388,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x70\x88\x88\x88\xf7\xc7\xc6\x66\x22\x1e" }  },
      /* --- pixel bitmap for cmmib100 char#36 \varpi --- */
      {  36,86533,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\xff\xff\x13\x21\x32\xc6\x7f\x38\x07" }  },
      /* --- pixel bitmap for cmmib100 char#37 \varrho --- */
      {  37,87408,                      /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\xc4\xc6\xc6\x67\x3d\x01\x1f\x1e" }  },
      /* --- pixel bitmap for cmmib100 char#38 \varsigma --- */
      {  38,88183,                      /* character number, location */
          6, 1,   -1, 1,      /* topleft row,col, and botleft row,col */
          {  5,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\x8c\xe3\x38\x03" }  },
      /* --- pixel bitmap for cmmib100 char#39 \varphi --- */
      {  39,89036,                      /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc2\x85\x1f\x62\x44\xff\xf1\x81\x01\x06\x08\x00" }  },
      /* --- pixel bitmap for cmmib100 char#40 \bfleftharpoonup --- */
      {  40,103938,                     /* character number, location */
          7, 1,    3, 1,      /* topleft row,col, and botleft row,col */
          { 14,    4, 3, 8, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x31\xc1\xc2\xbe" }  },
      /* --- pixel bitmap for cmmib100 char#41 \bfleftharpoondown --- */
      {  41,104934,                     /* character number, location */
          4, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,    4, 3, 9, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x12\xd1\xe1\xa2" }  },
      /* --- pixel bitmap for cmmib100 char#42 \bfrightharpoonup --- */
      {  42,105928,                     /* character number, location */
          7, 1,    3, 1,      /* topleft row,col, and botleft row,col */
          { 14,    4, 3, 8, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa1\xe1\xd2\x1e" }  },
      /* --- pixel bitmap for cmmib100 char#43 \bfrightharpoondown --- */
      {  43,106925,                     /* character number, location */
          4, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,    4, 3, 9, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\xb2\xc1\xc1\x32" }  },
      /* --- pixel bitmap for cmmib100 char#44 ` --- */
      {  44,107314,                     /* character number, location */
          8, 1,    3, 1,      /* topleft row,col, and botleft row,col */
          {  2,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x56\x02" }  },
      /* --- pixel bitmap for cmmib100 char#45 ' --- */
      {  45,107706,                     /* character number, location */
          8, 1,    3, 1,      /* topleft row,col, and botleft row,col */
          {  2,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa9\x01" }  },
      /* --- pixel bitmap for cmmib100 char#46 \triangleright --- */
      {  46,108215,                     /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc1\x91\x85\xd9\x11\x00" }  },
      /* --- pixel bitmap for cmmib100 char#47 \triangleleft --- */
      {  47,108733,                     /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x6e\x86\x26\x0e\x02" }  },
      /* --- pixel bitmap for cmmib100 char#48 \0 --- */
      {  48,94975,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xde\x3c\xcf\xb3\x07" }  },
      /* --- pixel bitmap for cmmib100 char#49 \1 --- */
      {  49,95696,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcc\xc3\x30\xcc\x0f" }  },
      /* --- pixel bitmap for cmmib100 char#50 \2 --- */
      {  50,96628,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xdf\x0c\xe3\xfe\x0f" }  },
      /* --- pixel bitmap for cmmib100 char#51 \3 --- */
      {  51,97611,                      /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xde\x3c\xc3\x1c\x3c\xcf\x1e" }  },
      /* --- pixel bitmap for cmmib100 char#52 \4 --- */
      {  52,98494,                      /* character number, location */
          6, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x38\x3c\x36\x33\xff\x30\x30\xfc" }  },
      /* --- pixel bitmap for cmmib100 char#53 \5 --- */
      {  53,99485,                      /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x13\x7c\x33\x3c\x4f\x0e" }  },
      /* --- pixel bitmap for cmmib100 char#54 \6 --- */
      {  54,100334,                     /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x3d\x7f\xf3\x3c\xcb\x1c" }  },
      /* --- pixel bitmap for cmmib100 char#55 \7 --- */
      {  55,101191,                     /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xff\x7f\x08\x82\x60\x30\x18\x0c" }  },
      /* --- pixel bitmap for cmmib100 char#56 \8 --- */
      {  56,102070,                     /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xde\x3c\x7b\xde\x3c\xcf\x1e" }  },
      /* --- pixel bitmap for cmmib100 char#57 \9 --- */
      {  57,102923,                     /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xce\x34\xcf\xb3\x3f\x6f\x0e" }  },
      /* --- pixel bitmap for cmmib100 char#58 . --- */
      {  58,109180,                     /* character number, location */
          2, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  2,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f" }  },
      /* --- pixel bitmap for cmmib100 char#59 , --- */
      {  59,109713,                     /* character number, location */
          2, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  2,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xaf\x01" }  },
      /* --- pixel bitmap for cmmib100 char#60 < --- */
      {  60,110343,                     /* character number, location */
          9, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          { 10,   11, 3,22, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x91\x72\x62\x62\x62\x71\xa2\xa2\xa2\xa2\xa1" }  },
      /* --- pixel bitmap for cmmib100 char#61 / --- */
      {  61,110841,                     /* character number, location */
         10, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  6,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x08\x41\x08\x42\x10\x84\x20\x04\x01" }  },
      /* --- pixel bitmap for cmmib100 char#62 > --- */
      {  62,111490,                     /* character number, location */
          9, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          { 10,   11, 3,23, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\xa2\xa2\xa2\xa2\xa1\x72\x62\x62\x62\x71\x91" }  },
      /* --- pixel bitmap for cmmib100 char#63 \star --- */
      {  63,112163,                     /* character number, location */
          5, 0,    1, 0,      /* topleft row,col, and botleft row,col */
          {  6,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x8f\x91" }  },
      /* --- pixel bitmap for cmmib100 char#64 \partial --- */
      {  64,89950,                      /* character number, location */
         10, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\xb3\x11\xc8\x17\x8f\x67\x33\x07" }  },
      /* --- pixel bitmap for cmmib100 char#65 A --- */
      {  65, 1000,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x00\x06\x38\xa0\x01\x1d\xc4\xf0\x87\x30\xc7\x07" }  },
      /* --- pixel bitmap for cmmib100 char#66 B --- */
      {  66, 2328,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xc3\x30\x86\x19\xc6\x1f\x86\x31\xcc\x30\xff\x00" }  },
      /* --- pixel bitmap for cmmib100 char#67 C --- */
      {  67, 3269,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x32\x6c\xe0\x00\x03\x0c\x30\x90\x20\x7c\x00" }  },
      /* --- pixel bitmap for cmmib100 char#68 D --- */
      {  68, 4379,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x07\xc3\x30\x8c\xc1\x18\x8c\xc1\x18\xc6\x30\xfe"
            "\x01" }  },
      /* --- pixel bitmap for cmmib100 char#69 E --- */
      {  69, 5774,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x63\x8c\x29\x53\x7c\x30\xc9\x94\x61\xff\x00" }  },
      /* --- pixel bitmap for cmmib100 char#70 F --- */
      {  70, 6981,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x63\x8c\x29\x53\x7c\x30\xc1\x84\x01\x1f\x00" }  },
      /* --- pixel bitmap for cmmib100 char#71 G --- */
      {  71, 8092,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x65\xb0\x01\x05\x30\xfc\x81\x0d\xcc\x30\xfc\x01" }  },
      /* --- pixel bitmap for cmmib100 char#72 H --- */
      {  72, 9313,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x1f\xc3\x60\x18\x86\xc1\x3f\x18\x06\xc3\x30\x0c"
            "\xcf\x07" }  },
      /* --- pixel bitmap for cmmib100 char#73 I --- */
      {  73,10012,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x30\x30\x18\x18\x18\x18\x0c\x3f" }  },
      /* --- pixel bitmap for cmmib100 char#74 J --- */
      {  74,10850,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    9, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x45\xf1\x62\x10\xf3\x52\x22\x22\x44\x40" }  },
      /* --- pixel bitmap for cmmib100 char#75 K --- */
      {  75,12033,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x8f\x11\x98\xc0\x06\x7c\xc0\x0e\xcc\x60\x0c\xdf"
            "\x03" }  },
      /* --- pixel bitmap for cmmib100 char#76 L --- */
      {  76,12926,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\xc0\x00\x03\x06\x18\x60\x88\x31\x43\xfe\x01" }  },
      /* --- pixel bitmap for cmmib100 char#77 M --- */
      {  77,14236,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\xf8\x38\x38\x38\x34\x34\x1a\x64\x1a\x64\x19\xe4"
            "\x18\xe2\x0c\x6f\x3e" }  },
      /* --- pixel bitmap for cmmib100 char#78 N --- */
      {  78,15374,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x1e\x87\xa0\x11\x32\x41\x2c\x88\x05\xe1\x10\x0c"
            "\x0f\x01" }  },
      /* --- pixel bitmap for cmmib100 char#79 O --- */
      {  79,16219,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x31\x6c\xf0\xc0\x03\x0f\x3c\xd8\x31\x7c\x00" }  },
      /* --- pixel bitmap for cmmib100 char#80 P --- */
      {  80,17276,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xc3\x30\x86\x19\xc6\x1f\x06\x30\xc0\x00\x1f\x00" }  },
      /* --- pixel bitmap for cmmib100 char#81 Q --- */
      {  81,18263,                      /* character number, location */
          9, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          { 10,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x31\x6c\xf0\xc0\x03\x0f\x3c\xd8\x37\x7c\x80\x00"
            "\x0e\x30" }  },
      /* --- pixel bitmap for cmmib100 char#82 R --- */
      {  82,19548,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xc3\x30\x86\x19\xc6\x1f\xc6\x30\xc6\x18\x9f\x07" }  },
      /* --- pixel bitmap for cmmib100 char#83 S --- */
      {  83,20593,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x19\x32\xe0\xc1\x07\x1c\xb0\x30\x3f\x00" }  },
      /* --- pixel bitmap for cmmib100 char#84 T --- */
      {  84,21609,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x8b\x2d\x66\x4c\x30\xc0\x00\x03\x06\x7e\x00" }  },
      /* --- pixel bitmap for cmmib100 char#85 U --- */
      {  85,22589,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    9, 3,23, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\x24\xf1\x12\x51\x2f\x32\x51\x32\x41\x55\x52" }  },
      /* --- pixel bitmap for cmmib100 char#86 V --- */
      {  86,23463,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f\xcf\x20\x0c\xc1\x08\x98\x80\x05\x38\x80\x03\x18"
            "\x00" }  },
      /* --- pixel bitmap for cmmib100 char#87 W --- */
      {  87,24826,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 16,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9f\xf7\x8c\x23\x4c\x33\x6c\x13\x2c\x0b\x1c\x0b\x1c"
            "\x07\x0c\x06\x0c\x02" }  },
      /* --- pixel bitmap for cmmib100 char#88 X --- */
      {  88,25923,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x1e\x4c\x80\x05\x60\x00\x0c\x40\x03\x64\x40\x18"
            "\x9f\x0f" }  },
      /* --- pixel bitmap for cmmib100 char#89 Y --- */
      {  89,26953,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f\xcf\x30\x98\x81\x0d\x78\x00\x03\x30\x80\x01\x7c"
            "\x00" }  },
      /* --- pixel bitmap for cmmib100 char#90 Z --- */
      {  90,28024,                      /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x33\x46\x8c\x18\x30\x60\xc4\x98\x21\xff\x00" }  },
      /* --- pixel bitmap for cmmib100 char#91 \flat --- */
      {  91,112804,                     /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x11\x51\xdf\x7d\x37" }  },
      /* --- pixel bitmap for cmmib100 char#92 \natural --- */
      {  92,113511,                     /* character number, location */
         10, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  4,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x11\xf9\x9f\x99\xf9\x9f\x08" }  },
      /* --- pixel bitmap for cmmib100 char#93 \sharp --- */
      {  93,114322,                     /* character number, location */
         10, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  4,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x98\xf9\x9f\x99\xf9\x9f\x01" }  },
      /* --- pixel bitmap for cmmib100 char#94 \smile --- */
      {  94,115186,                     /* character number, location */
          6, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          { 14,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\xa0\x01\xc6\xff\xc0\x0f" }  },
      /* --- pixel bitmap for cmmib100 char#95 \frown --- */
      {  95,116022,                     /* character number, location */
          6, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          { 14,    4, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x5a\x31\xa1\x11\xc1" }  },
      /* --- pixel bitmap for cmmib100 char#96 \ell --- */
      {  96,90694,                      /* character number, location */
         10,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\xb0\x98\x58\x2c\x1c\x0c\x0c\x8e\x78" }  },
      /* --- pixel bitmap for cmmib100 char#97 a --- */
      {  97,28928,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\xf1\x78\x3c\x77\x03" }  },
      /* --- pixel bitmap for cmmib100 char#98 b --- */
      {  98,29702,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07\x83\xc1\xf0\x1b\x8f\xc7\x33\x0f" }  },
      /* --- pixel bitmap for cmmib100 char#99 c --- */
      {  99,30447,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\x3d\x0c\xa3\x07" }  },
      /* --- pixel bitmap for cmmib100 char#100 d --- */
      { 100,31333,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\xc0\xc0\xc0\x7c\x62\x63\x63\x73\x6e" }  },
      /* --- pixel bitmap for cmmib100 char#101 e --- */
      { 101,32132,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\xf8\x0d\xa3\x07" }  },
      /* --- pixel bitmap for cmmib100 char#102 f --- */
      { 102,33262,                      /* character number, location */
         10, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  8,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\xf0\x30\x30\xfc\x30\x18\x18\x18\x18\x18\x0a\x06" }  },
      /* --- pixel bitmap for cmmib100 char#103 g --- */
      { 103,34211,                      /* character number, location */
          6, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb8\xc4\xc6\xc6\x66\x7c\x60\x62\x1e" }  },
      /* --- pixel bitmap for cmmib100 char#104 h --- */
      { 104,35116,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x0c\x0c\x0c\x76\xce\xc6\xc6\xe3\xc3" }  },
      /* --- pixel bitmap for cmmib100 char#105 i --- */
      { 105,35944,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcc\x00\x60\x67\x76\x06" }  },
      /* --- pixel bitmap for cmmib100 char#106 j --- */
      { 106,36897,                      /* character number, location */
         11, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  7,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\x30\x00\x00\xc0\xd1\x60\x30\x0c\x06\xe3\x30\x00" }  },
      /* --- pixel bitmap for cmmib100 char#107 k --- */
      { 107,37892,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x0c\x0c\x0c\xe6\xd6\xde\x36\x73\x63" }  },
      /* --- pixel bitmap for cmmib100 char#108 l --- */
      { 108,38556,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xce\xcc\x66\x66\x67" }  },
      /* --- pixel bitmap for cmmib100 char#109 m --- */
      { 109,39723,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x77\xf7\xcc\xc6\x6c\xcc\x63\x3e\xc6" }  },
      /* --- pixel bitmap for cmmib100 char#110 n --- */
      { 110,40682,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x77\xcf\xc6\xc6\xe3\xc3" }  },
      /* --- pixel bitmap for cmmib100 char#111 o --- */
      { 111,41340,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\xc6\xc3\xc3\x63\x3e" }  },
      /* --- pixel bitmap for cmmib100 char#112 p --- */
      { 112,42246,                      /* character number, location */
          6, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x1c\x33\x66\x6c\xcc\x8f\x01\x03\x07\x00" }  },
      /* --- pixel bitmap for cmmib100 char#113 q --- */
      { 113,43131,                      /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\xf1\x78\x3c\xf3\xc1\x60\x3c" }  },
      /* --- pixel bitmap for cmmib100 char#114 r --- */
      { 114,43960,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xde\x6d\x1b\xc3\x00" }  },
      /* --- pixel bitmap for cmmib100 char#115 s --- */
      { 115,44882,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x1a\x4f\x3f\xf2\x00" }  },
      /* --- pixel bitmap for cmmib100 char#116 t --- */
      { 116,45576,                      /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\xe3\xcf\x18\xb3\x0c" }  },
      /* --- pixel bitmap for cmmib100 char#117 u --- */
      { 117,46564,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc6\xb3\xd9\x6c\x77\x03" }  },
      /* --- pixel bitmap for cmmib100 char#118 v --- */
      { 118,47415,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa6\xb3\xd1\x68\xf2\x00" }  },
      /* --- pixel bitmap for cmmib100 char#119 w --- */
      { 119,48533,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x46\x3a\xb3\x19\xcd\x68\x26\xee\x00" }  },
      /* --- pixel bitmap for cmmib100 char#120 x --- */
      { 120,49735,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6c\xda\xd8\x1a\x4f\x3e" }  },
      /* --- pixel bitmap for cmmib100 char#121 y --- */
      { 121,50751,                      /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  8,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x86\xc7\xc6\xc6\x66\x7c\x60\x36\x1e" }  },
      /* --- pixel bitmap for cmmib100 char#122 z --- */
      { 122,51655,                      /* character number, location */
          6, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\x1f\x84\xe1\xdb\x00" }  },
      /* --- pixel bitmap for cmmib100 char#123 \imath --- */
      { 123,91382,                      /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  3,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbe\x7d\x03" }  },
      /* --- pixel bitmap for cmmib100 char#124 \jmath --- */
      { 124,92165,                      /* character number, location */
          6, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x0d\xc3\x18\x86\x29\x06" }  },
      /* --- pixel bitmap for cmmib100 char#125 \wp --- */
      { 125,93246,                      /* character number, location */
          6, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          { 10,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x06\xcc\xf7\xf0\xc0\xb3\x9d\xd3\x40\x03\x06\x00" }  },
      /* --- pixel bitmap for cmmib100 char#126 \bfvec --- */
      { 126,93818,                      /* character number, location */
         10, 2,    7, 2,      /* topleft row,col, and botleft row,col */
          {  8,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\xff\x40" }  },
      /* --- pixel bitmap for cmmib100 char#127 (noname) --- */
      { 127,94328,                      /* character number, location */
         10, 4,    7, 4,      /* topleft row,col, and botleft row,col */
          {  6,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5e\x18\x02" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=2 for .118gf ---
 * mf '\mode=preview; mag=magstep(-16.96645799324018499600); input cmmib10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmmib118 --- */
static	chardef  cmmib118[] =
   {
      /* --- pixel bitmap for cmmib118 char#0 \Gamma --- */
      {   0,53816,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   11, 3,27, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x39\x42\x42\xf1\x42\x51\x42\x60\xf3\x32\x70\x22\x86"
            "\x62" }  },
      /* --- pixel bitmap for cmmib118 char#1 \Delta --- */
      {   1,54711,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   11, 3,36, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x92\xb3\xa1\x12\x91\x23\x72\x32\x62\x42\x61\x53\x41"
            "\x72\x31\x82\x2e\x0d" }  },
      /* --- pixel bitmap for cmmib118 char#2 \Theta --- */
      {   2,55868,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x07\x06\xc7\x80\x19\x40\xe6\xf3\x7c\x36\x9f\x4d"
            "\x64\x03\x8c\xc1\x81\x1f\x00" }  },
      /* --- pixel bitmap for cmmib118 char#3 \Lambda --- */
      {   3,56806,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x01\x0c\x70\x80\x03\x1a\xc8\x40\x0e\x61\x04\x23"
            "\xd8\xf3\x01" }  },
      /* --- pixel bitmap for cmmib118 char#4 \Xi --- */
      {   4,58215,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   11, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3b\x2b\x31\x91\xe0\x57\x67\xe0\x40\xf1\x11\x91\x2f"
            "\x1b\x30" }  },
      /* --- pixel bitmap for cmmib118 char#5 \Pi --- */
      {   5,59412,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 18,   11, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\x01\xf3\x42\x72\x30\xf3\x32\x72\x40\x22\x72\x56"
            "\x36\x30" }  },
      /* --- pixel bitmap for cmmib118 char#6 \Sigma --- */
      {   6,60549,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   11, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3b\x33\x62\x42\x71\x43\x61\x52\xd2\xb2\xb1\x71\x41"
            "\x71\x32\x72\x2b\x32" }  },
      /* --- pixel bitmap for cmmib118 char#7 \Upsilon --- */
      {   7,61595,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   11, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x23\x44\x15\x22\x13\x44\x31\x53\xb2\x50\xf3\x52\x60"
            "\x42\x96\x52" }  },
      /* --- pixel bitmap for cmmib118 char#8 \Phi --- */
      {   8,62605,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x07\x0c\xc0\x80\x7f\xc6\x3c\xc6\x66\xcc\x3f\x60"
            "\x00\x03\xfc\x00" }  },
      /* --- pixel bitmap for cmmib118 char#9 \Psi --- */
      {   9,63690,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x07\x18\x0c\x63\x63\x66\xcc\xcc\x8c\xd9\xe0\x0f"
            "\x60\x00\x06\xf0\x03" }  },
      /* --- pixel bitmap for cmmib118 char#10 \Omega --- */
      {  10,64859,                      /* character number, location */
         11, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 13,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x87\x83\x19\x60\x03\x6c\x80\x0d\x98\x81\x29\x50"
            "\x05\xe5\xf0\x1c\x0e" }  },
      /* --- pixel bitmap for cmmib118 char#11 \alpha --- */
      {  11,65855,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\xcc\x0e\x1f\x36\x6c\x9c\x67" }  },
      /* --- pixel bitmap for cmmib118 char#12 \beta --- */
      {  12,66882,                      /* character number, location */
         11, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          { 10,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\xc1\x8c\x30\xc2\xe8\x91\x47\x30\xc1\x04\x1b\xa6"
            "\x87\x00\x02\x04\x00" }  },
      /* --- pixel bitmap for cmmib118 char#13 \gamma --- */
      {  13,67803,                      /* character number, location */
          7, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          { 10,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\xfa\x14\x12\x30\xc0\x00\x03\x04\x10\x40\x80\x00" }  },
      /* --- pixel bitmap for cmmib118 char#14 \delta --- */
      {  14,68740,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  7,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x3c\x12\x83\xc1\x99\xc7\xe3\xf1\xcc\x03" }  },
      /* --- pixel bitmap for cmmib118 char#15 \epsilon --- */
      {  15,69588,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\x31\x7c\xc3\xe8\x01" }  },
      /* --- pixel bitmap for cmmib118 char#16 \zeta --- */
      {  16,70488,                      /* character number, location */
         11, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  7,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x38\x9e\x61\x10\x0c\x06\x83\x81\x87\x07\xe3\x00" }  },
      /* --- pixel bitmap for cmmib118 char#17 \eta --- */
      {  17,71375,                      /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xee\x3a\x37\x66\xcc\xd8\x98\x31\x60\xc0\x80\x00" }  },
      /* --- pixel bitmap for cmmib118 char#18 \theta --- */
      {  18,72119,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x4c\xc4\xc6\xc6\x7f\x63\x63\x33\x13\x0e" }  },
      /* --- pixel bitmap for cmmib118 char#19 \iota --- */
      {  19,72770,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x64\x66\xb3\x06" }  },
      /* --- pixel bitmap for cmmib118 char#20 \kappa --- */
      {  20,73692,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc4\xa6\x1e\x3e\x66\xb3\xe3" }  },
      /* --- pixel bitmap for cmmib118 char#21 \lambda --- */
      {  21,74507,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x30\xc0\x80\x01\x07\x0c\x3c\x6c\xce\x06\x07\x06" }  },
      /* --- pixel bitmap for cmmib118 char#22 \mu --- */
      {  22,75527,                      /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x19\x33\x66\xcc\xd8\xb9\x6f\x03\x06\x04\x00" }  },
      /* --- pixel bitmap for cmmib118 char#23 \nu --- */
      {  23,76272,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8f\xc6\xc6\x66\x36\x1b\x07" }  },
      /* --- pixel bitmap for cmmib118 char#24 \xi --- */
      {  24,77380,                      /* character number, location */
         11, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  8,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\xf0\xf8\x0c\x0c\x7c\x7c\x06\x06\x07\x1e\x7c\x70"
            "\x38" }  },
      /* --- pixel bitmap for cmmib118 char#25 \pi --- */
      {  25,78290,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xfb\x9f\x04\x1a\x6c\x90\x63\x04" }  },
      /* --- pixel bitmap for cmmib118 char#26 \rho --- */
      {  26,79088,                      /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x30\x33\x66\xcc\xc8\x98\x1f\x03\x06\x04\x00" }  },
      /* --- pixel bitmap for cmmib118 char#27 \sigma --- */
      {  27,79970,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xfb\x3f\xc6\x18\x63\xcc\xe0\x01" }  },
      /* --- pixel bitmap for cmmib118 char#28 \tau --- */
      {  28,80729,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xfd\x67\xc0\x80\x80\x01\x03" }  },
      /* --- pixel bitmap for cmmib118 char#29 \upsilon --- */
      {  29,81606,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8e\x34\x37\x64\xc8\x88\x09\x0e" }  },
      /* --- pixel bitmap for cmmib118 char#30 \phi --- */
      {  30,82486,                      /* character number, location */
         11, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x40\x80\x00\x81\xc7\xf2\xe4\xc9\x93\x96\xf9\x40"
            "\x80\x80\x00" }  },
      /* --- pixel bitmap for cmmib118 char#31 \chi --- */
      {  31,83511,                      /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          { 10,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x72\x84\x09\x1e\x30\xc0\x80\x07\x19\xe2\x04\x07" }  },
      /* --- pixel bitmap for cmmib118 char#32 \psi --- */
      {  32,84546,                      /* character number, location */
         11, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          { 11,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x00\x04\x20\x80\xe0\x24\x2d\x37\x91\x85\x2c\x62"
            "\x09\x3e\x20\x00\x01\x08\x00" }  },
      /* --- pixel bitmap for cmmib118 char#33 \omega --- */
      {  33,85621,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\x09\x1c\x63\x8c\x11\xfd\xe7\x0e" }  },
      /* --- pixel bitmap for cmmib118 char#34 \varepsilon --- */
      {  34,86578,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\xff\x7d\xc1\xef\x01" }  },
      /* --- pixel bitmap for cmmib118 char#35 \vartheta --- */
      {  35,87553,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x40\x04\x31\xc4\x6e\x37\xd6\x18\x63\xcc\x30\xc1"
            "\x03" }  },
      /* --- pixel bitmap for cmmib118 char#36 \varpi --- */
      {  36,88734,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\x7f\xff\x7f\x21\x84\x10\x42\x8c\xe0\x7d\x60\x1c"
            "\x00" }  },
      /* --- pixel bitmap for cmmib118 char#37 \varrho --- */
      {  37,89593,                      /* character number, location */
          7, 2,   -3, 2,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\xcc\xc6\xc6\x46\x67\x3d\x01\x3f\x3e" }  },
      /* --- pixel bitmap for cmmib118 char#38 \varsigma --- */
      {  38,90398,                      /* character number, location */
          7, 1,   -2, 1,      /* topleft row,col, and botleft row,col */
          {  6,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\x31\x0c\x87\xc7\xc3\x1c" }  },
      /* --- pixel bitmap for cmmib118 char#39 \varphi --- */
      {  39,91321,                      /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          { 10,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc2\x89\x1f\x61\x80\x09\xf9\xc3\x07\x03\x0c\x10\x00" }  },
      /* --- pixel bitmap for cmmib118 char#40 \bfleftharpoonup --- */
      {  40,106721,                     /* character number, location */
          9, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          { 17,    5, 3,14, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x41\xc0\x31\xe2\xee\x03" }  },
      /* --- pixel bitmap for cmmib118 char#41 \bfleftharpoondown --- */
      {  41,107745,                     /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,    5, 3,17, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x03\x12\xe0\x31\xd0\xf1\x41\xc1" }  },
      /* --- pixel bitmap for cmmib118 char#42 \bfrightharpoonup --- */
      {  42,108767,                     /* character number, location */
          9, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          { 17,    5, 3,16, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\xc1\x40\xd1\xe0\x32\x1e\x03" }  },
      /* --- pixel bitmap for cmmib118 char#43 \bfrightharpoondown --- */
      {  43,109792,                     /* character number, location */
          5, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,    5, 3,15, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x03\xe2\xe1\x30\xf1\xc1\x43" }  },
      /* --- pixel bitmap for cmmib118 char#44 ` --- */
      {  44,110209,                     /* character number, location */
          9, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          {  3,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4e\x62" }  },
      /* --- pixel bitmap for cmmib118 char#45 ' --- */
      {  45,110627,                     /* character number, location */
          9, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          {  3,    5, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x23\x39" }  },
      /* --- pixel bitmap for cmmib118 char#46 \triangleright --- */
      {  46,111162,                     /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x81\x43\x22\x16\x8c\x25\x0e\x01" }  },
      /* --- pixel bitmap for cmmib118 char#47 \triangleleft --- */
      {  47,111714,                     /* character number, location */
          9, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x38\xd2\x18\x34\x22\xe1\x40" }  },
      /* --- pixel bitmap for cmmib118 char#48 \0 --- */
      {  48,97456,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    7, 3,11, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x15\x1f\x42\x32\x15\x12" }  },
      /* --- pixel bitmap for cmmib118 char#49 \1 --- */
      {  49,98207,                      /* character number, location */
          7, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcc\xc3\x30\x0c\xf3\x03" }  },
      /* --- pixel bitmap for cmmib118 char#50 \2 --- */
      {  50,99167,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbe\x31\x18\x84\xf5\xff\x01" }  },
      /* --- pixel bitmap for cmmib118 char#51 \3 --- */
      {  51,100180,                     /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbe\xf1\x18\xc4\x01\x81\xc7\x23\x0f" }  },
      /* --- pixel bitmap for cmmib118 char#52 \4 --- */
      {  52,101091,                     /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x30\x38\x34\x32\x33\xff\x30\x30\xfc" }  },
      /* --- pixel bitmap for cmmib118 char#53 \5 --- */
      {  53,102112,                     /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x22\x8f\x43\xe0\x11\x83\xc7\x21\x0f" }  },
      /* --- pixel bitmap for cmmib118 char#54 \6 --- */
      {  54,102991,                     /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\xb3\x78\xf0\x19\x8d\xc7\x63\x11\x07" }  },
      /* --- pixel bitmap for cmmib118 char#55 \7 --- */
      {  55,103880,                     /* character number, location */
          8, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  8,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\xff\x7f\x21\x11\x18\x08\x0c\x0c\x0c\x0c" }  },
      /* --- pixel bitmap for cmmib118 char#56 \8 --- */
      {  56,104791,                     /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbe\xf1\xf8\xec\xe3\xc9\xc7\xe3\x11\x07" }  },
      /* --- pixel bitmap for cmmib118 char#57 \9 --- */
      {  57,105678,                     /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\xd1\x78\x3c\xe6\x83\x47\x33\x0f" }  },
      /* --- pixel bitmap for cmmib118 char#58 . --- */
      {  58,112195,                     /* character number, location */
          3, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  3,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x00" }  },
      /* --- pixel bitmap for cmmib118 char#59 , --- */
      {  59,112756,                     /* character number, location */
          3, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  3,    6, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x29\x01" }  },
      /* --- pixel bitmap for cmmib118 char#60 < --- */
      {  60,113414,                     /* character number, location */
         10, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 11,   11, 3,22, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x92\x72\x72\x72\x72\x81\xb2\xb2\xb2\xb2\xb2" }  },
      /* --- pixel bitmap for cmmib118 char#61 / --- */
      {  61,113938,                     /* character number, location */
         12, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  7,   16, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x20\x08\x04\x81\x40\x10\x08\x02\x81\x20\x10\x04"
            "\x02" }  },
      /* --- pixel bitmap for cmmib118 char#62 > --- */
      {  62,114619,                     /* character number, location */
         10, 2,   -1, 2,      /* topleft row,col, and botleft row,col */
          { 11,   11, 3,23, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\xb2\xb2\xb2\xb2\xb1\x82\x72\x72\x72\x72\x92" }  },
      /* --- pixel bitmap for cmmib118 char#63 \star --- */
      {  63,115318,                     /* character number, location */
          9, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  9,    9, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x20\x40\x98\xec\x0f\x07\x0a\x22\x82\x00" }  },
      /* --- pixel bitmap for cmmib118 char#64 \partial --- */
      {  64,92279,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x88\x19\x32\xcc\xdb\xd8\xb0\x61\x63\x46\x78\x00" }  },
      /* --- pixel bitmap for cmmib118 char#65 A --- */
      {  65, 1026,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x01\x38\x80\x03\x34\x20\x03\x32\x10\x83\x3f\x08"
            "\x46\x60\x8f\x0f" }  },
      /* --- pixel bitmap for cmmib118 char#66 B --- */
      {  66, 2362,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   11, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x39\x10\xf2\x42\x52\x42\x42\x49\x10\xf2\x32\x62\x22"
            "\x62\x1a\x31" }  },
      /* --- pixel bitmap for cmmib118 char#67 C --- */
      {  67, 3311,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   11, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x56\x12\x33\x52\x32\x81\x22\x91\x22\xbf\x12\xc2\x91"
            "\x31\x81\x51\x61\x76\x52" }  },
      /* --- pixel bitmap for cmmib118 char#68 D --- */
      {  68, 4429,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   11, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x39\x30\xf1\x42\x62\x10\xf1\x42\x72\xf2\x32\x72\x10"
            "\x32\x62\x42\x62\x3a\x52" }  },
      /* --- pixel bitmap for cmmib118 char#69 E --- */
      {  69, 5832,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x3f\x0c\x04\x03\xc1\x48\x30\x02\x7e\x80\x91\x60"
            "\x24\x18\x04\x83\xf1\x3f\x00" }  },
      /* --- pixel bitmap for cmmib118 char#70 F --- */
      {  70, 7045,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x1f\x06\xc3\x40\x18\x09\x23\xf0\x03\x46\xc0\x08"
            "\x18\x80\x01\xfc\x00" }  },
      /* --- pixel bitmap for cmmib118 char#71 G --- */
      {  71, 8212,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x37\x0e\xc6\x00\x19\x40\x06\xc0\xc0\x3f\xc0\x0c"
            "\x30\x02\x0c\x81\x81\x5f\x00" }  },
      /* --- pixel bitmap for cmmib118 char#72 H --- */
      {  72, 9417,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 18,   11, 3,33, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x36\x36\xf3\x42\x72\x30\x3b\x40\xf2\x32\x72\x40\x22"
            "\x72\x56\x36\x32" }  },
      /* --- pixel bitmap for cmmib118 char#73 I --- */
      {  73,10124,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   11, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x36\xf3\x42\x30\xf3\x32\x40\x22\x56\x32" }  },
      /* --- pixel bitmap for cmmib118 char#74 J --- */
      {  74,10940,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 3,25, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x56\xf3\x72\x20\xf2\x62\x30\x11\x42\x32\x32\x55\x52" }  },
      /* --- pixel bitmap for cmmib118 char#75 K --- */
      {  75,12129,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 17,   11, 3,45, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x36\x35\x42\x71\x72\x52\x82\x41\xa2\x21\xb2\x14\xa3"
            "\x32\x92\x42\x92\x52\x72\x62\x56\x35\x30" }  },
      /* --- pixel bitmap for cmmib118 char#76 L --- */
      {  76,13058,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x81\x01\x0c\x60\x00\x03\x0c\x60\x10\x83\x18\x62"
            "\xd8\x7f\x00" }  },
      /* --- pixel bitmap for cmmib118 char#77 M --- */
      {  77,14374,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 20,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x00\x0f\x0d\x38\xd0\x40\x03\x0d\x34\xd0\x20\x83"
            "\x18\x19\x88\x89\x81\x98\x18\x88\x85\x41\x30\x0c\x1f"
            "\xf1\x03" }  },
      /* --- pixel bitmap for cmmib118 char#78 N --- */
      {  78,15534,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 18,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\xe0\xc3\x01\x01\x0d\x04\x64\x10\x10\x43\x20\x8c"
            "\x80\x60\x02\x02\x0b\x08\x38\x10\x60\xf0\x01\x01" }  },
      /* --- pixel bitmap for cmmib118 char#79 O --- */
      {  79,16417,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x03\x83\x31\x30\x03\x6c\x80\x07\xd8\x00\x1b\x60"
            "\x03\xc6\x70\xf0\x03" }  },
      /* --- pixel bitmap for cmmib118 char#80 P --- */
      {  80,17508,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   11, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3a\x10\xf2\x42\x62\x42\x52\x49\x20\xf2\x32\x90\x22"
            "\xa6\x82" }  },
      /* --- pixel bitmap for cmmib118 char#81 Q --- */
      {  81,18527,                      /* character number, location */
         11, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          { 13,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x03\xc3\x31\x30\x03\x6c\x80\x07\xd8\x00\x1b\x60"
            "\x73\xc6\x69\xf0\x13\x60\x02\x3c\x00\x03" }  },
      /* --- pixel bitmap for cmmib118 char#82 R --- */
      {  82,19828,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   11, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x39\x20\xf2\x42\x62\x42\x52\x48\x30\xf2\x32\x52\x20"
            "\x22\x61\x27\x43\x12" }  },
      /* --- pixel bitmap for cmmib118 char#83 S --- */
      {  83,20909,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\xc7\x10\x83\x18\xc0\x07\x7c\x00\x07\x30\x82\x19"
            "\x46\x1f\x00" }  },
      /* --- pixel bitmap for cmmib118 char#84 T --- */
      {  84,21935,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   11, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1d\x32\x31\x1f\x11\x42\x31\x10\x52\x50\xf3\x42\x60"
            "\x32\x87\x45" }  },
      /* --- pixel bitmap for cmmib118 char#85 U --- */
      {  85,22945,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   11, 3,27, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x05\x44\xf3\x12\x71\x2f\x22\x71\x32\x61\x42\x51\x75"
            "\x62" }  },
      /* --- pixel bitmap for cmmib118 char#86 V --- */
      {  86,23879,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f\x9e\x81\x30\x08\x06\xc1\x10\x38\x01\x26\xc0\x02"
            "\x38\x00\x07\x60\x00" }  },
      /* --- pixel bitmap for cmmib118 char#87 W --- */
      {  87,25265,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9f\xcf\x1b\x0c\xc2\x30\x08\xa3\x11\x8c\x26\x30\x99"
            "\xc0\x62\x01\x8b\x05\x1c\x0e\x70\x18\xc0\x60\x00" }  },
      /* --- pixel bitmap for cmmib118 char#88 X --- */
      {  88,26378,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x3e\x1c\x03\x66\x80\x0f\xc0\x01\x70\x00\x1e\xc0"
            "\x0e\x18\x03\xc3\xf1\xf8\x00" }  },
      /* --- pixel bitmap for cmmib118 char#89 Y --- */
      {  89,27464,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1f\x9e\x81\x70\x08\x8c\x80\x09\xe0\x00\x0c\x80\x01"
            "\x30\x00\x03\xf8\x01" }  },
      /* --- pixel bitmap for cmmib118 char#90 Z --- */
      {  90,28567,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\xcf\x60\x04\x43\x18\xc0\x00\x06\x30\x82\x21\x0c"
            "\x63\x18\xff\x01" }  },
      /* --- pixel bitmap for cmmib118 char#91 \flat --- */
      {  91,116003,                     /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x21\x84\x10\x5e\xce\xb9\x9d\x00" }  },
      /* --- pixel bitmap for cmmib118 char#92 \natural --- */
      {  92,116742,                     /* character number, location */
         12, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  5,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x21\x84\xfc\xff\x8c\x31\xe6\xff\x27\x04" }  },
      /* --- pixel bitmap for cmmib118 char#93 \sharp --- */
      {  93,117585,                     /* character number, location */
         11, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  5,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x48\x69\xff\x96\x52\x4a\xfb\xb7\x04" }  },
      /* --- pixel bitmap for cmmib118 char#94 \smile --- */
      {  94,118479,                     /* character number, location */
          7, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          { 17,    5, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\xe0\x11\x11\xd1\x32\x92\x5b\x87\x52" }  },
      /* --- pixel bitmap for cmmib118 char#95 \frown --- */
      {  95,119345,                     /* character number, location */
          8, 1,    2, 1,      /* topleft row,col, and botleft row,col */
          { 17,    6, 3,20, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x81\xc9\x7b\x51\xb1\x31\xd1\x11\xe0\x11" }  },
      /* --- pixel bitmap for cmmib118 char#96 \ell --- */
      {  96,93031,                      /* character number, location */
         11,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  9,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\xc0\xc1\x82\x05\x07\x07\x06\x0c\x1c\x36\xc2\x03" }  },
      /* --- pixel bitmap for cmmib118 char#97 a --- */
      {  97,29491,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5c\xf3\x78\x3c\x9e\xbb\x01" }  },
      /* --- pixel bitmap for cmmib118 char#98 b --- */
      {  98,30335,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\x83\xc1\xe0\x3b\x8f\xc7\xa3\x99\x07" }  },
      /* --- pixel bitmap for cmmib118 char#99 c --- */
      {  99,31124,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\x3d\x0e\xc3\xe8\x01" }  },
      /* --- pixel bitmap for cmmib118 char#100 d --- */
      { 100,32080,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x81\x01\x03\xc6\xcd\xcc\x98\x31\x63\xe6\xb8\x01" }  },
      /* --- pixel bitmap for cmmib118 char#101 e --- */
      { 101,32899,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xbc\x39\x3f\xc3\xe8\x01" }  },
      /* --- pixel bitmap for cmmib118 char#102 f --- */
      { 102,34007,                      /* character number, location */
         11, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  9,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\xc1\x82\x01\xc3\x1f\x06\x0c\x18\x30\x60\x60\xc0"
            "\xa0\xc1\x01" }  },
      /* --- pixel bitmap for cmmib118 char#103 g --- */
      { 103,34974,                      /* character number, location */
          7,-1,   -3,-1,      /* topleft row,col, and botleft row,col */
          {  9,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x70\x31\x33\x66\xcc\x98\x19\x3e\x60\xc2\x7c\x00" }  },
      /* --- pixel bitmap for cmmib118 char#104 h --- */
      { 104,35909,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\x0c\x0c\x0c\x7c\xce\xc6\xc6\x66\xe3\xc3" }  },
      /* --- pixel bitmap for cmmib118 char#105 i --- */
      { 105,36739,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\x01\x00\x5c\x6b\xc6\x38\x07" }  },
      /* --- pixel bitmap for cmmib118 char#106 j --- */
      { 106,37672,                      /* character number, location */
         12, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          {  8,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\xc0\x00\x00\x00\x70\x68\x64\x60\x60\x30\x30\x30"
            "\x1a\x0e" }  },
      /* --- pixel bitmap for cmmib118 char#107 k --- */
      { 107,38699,                      /* character number, location */
         11, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\x0c\x0c\x0c\xec\x96\xce\x1e\x36\x5b\x73" }  },
      /* --- pixel bitmap for cmmib118 char#108 l --- */
      { 108,39407,                      /* character number, location */
         11, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,   11, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9e\x31\xc6\x8c\x31\xe6\x18" }  },
      /* --- pixel bitmap for cmmib118 char#109 m --- */
      { 109,40602,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xee\x9c\xce\x59\x63\x8c\x31\xc6\x98\x31\xc6\x1a\xc3"
            "\x00" }  },
      /* --- pixel bitmap for cmmib118 char#110 n --- */
      { 110,41625,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xee\x3a\x37\x66\xcc\xcc\xb8\x61" }  },
      /* --- pixel bitmap for cmmib118 char#111 o --- */
      { 111,42357,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\xf3\x78\x3c\x9a\x79\x00" }  },
      /* --- pixel bitmap for cmmib118 char#112 p --- */
      { 112,43319,                      /* character number, location */
          7, 0,   -3, 0,      /* topleft row,col, and botleft row,col */
          { 10,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xdc\xe9\xac\x31\xc6\x18\x31\xc6\x0f\x03\x0c\x7c\x00" }  },
      /* --- pixel bitmap for cmmib118 char#113 q --- */
      { 113,44228,                      /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xdc\x66\x63\x63\x63\x33\x3e\x30\x30\x7c" }  },
      /* --- pixel bitmap for cmmib118 char#114 r --- */
      { 114,45061,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xee\x6e\x9b\xc1\x30\x18\x00" }  },
      /* --- pixel bitmap for cmmib118 char#115 s --- */
      { 115,46017,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  8,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x64\x1c\x78\xc2\x43\x3e" }  },
      /* --- pixel bitmap for cmmib118 char#116 t --- */
      { 116,46753,                      /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\xc3\xfc\x86\x61\x18\x93\x03" }  },
      /* --- pixel bitmap for cmmib118 char#117 u --- */
      { 117,47743,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8e\xb4\x35\x63\xc6\x8c\x2d\x76" }  },
      /* --- pixel bitmap for cmmib118 char#118 v --- */
      { 118,48604,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4e\xda\x8d\x8c\x4c\x4c\x38" }  },
      /* --- pixel bitmap for cmmib118 char#119 w --- */
      { 119,49756,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8e\xa8\x8d\xcd\xc8\x8c\xcc\xc8\x4c\xb8\x03" }  },
      /* --- pixel bitmap for cmmib118 char#120 x --- */
      { 120,50968,                      /* character number, location */
          7, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xd8\xd1\x28\x33\x0c\x32\x6c\xe4\x0f" }  },
      /* --- pixel bitmap for cmmib118 char#121 y --- */
      { 121,52016,                      /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8e\xda\xcd\xcc\xcc\x6c\x78\x60\x36\x1e" }  },
      /* --- pixel bitmap for cmmib118 char#122 z --- */
      { 122,52902,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9c\x7e\x20\x18\x84\x7e\x39" }  },
      /* --- pixel bitmap for cmmib118 char#123 \imath --- */
      { 123,93745,                      /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  4,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xde\x6d\xe6\x0e" }  },
      /* --- pixel bitmap for cmmib118 char#124 \jmath --- */
      { 124,94508,                      /* character number, location */
          7,-1,   -3,-1,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\xd0\xc8\xc0\xc0\x60\x60\x60\x32\x1e" }  },
      /* --- pixel bitmap for cmmib118 char#125 \wp --- */
      { 125,95645,                      /* character number, location */
          7, 1,   -3, 1,      /* topleft row,col, and botleft row,col */
          { 11,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x20\x9f\x87\x0d\x2c\x60\x8b\xbd\xa7\x01\x0d\x30"
            "\x00" }  },
      /* --- pixel bitmap for cmmib118 char#126 \bfvec --- */
      { 126,96247,                      /* character number, location */
         11, 3,    8, 3,      /* topleft row,col, and botleft row,col */
          {  7,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x3f\x08" }  },
      /* --- pixel bitmap for cmmib118 char#127 (noname) --- */
      { 127,96783,                      /* character number, location */
         11, 4,    8, 4,      /* topleft row,col, and botleft row,col */
          {  8,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\x82\x81" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=3 for .131gf ---
 * mf '\mode=preview; mag=magstep(-16.39322518098640003469); input cmmib10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmmib131 --- */
static	chardef  cmmib131[] =
   {
      /* --- pixel bitmap for cmmib131 char#0 \Gamma --- */
      {   0,53849,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   12, 3,27, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3b\x53\x42\xf2\x43\x61\x43\x70\xf3\x33\x80\x23\x98"
            "\x62" }  },
      /* --- pixel bitmap for cmmib131 char#1 \Delta --- */
      {   1,54748,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   12, 3,38, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x92\xd3\xb4\xa1\x13\x91\x24\x71\x34\x62\x43\x61\x54"
            "\x41\x64\x3c\x2e\x0e\x01" }  },
      /* --- pixel bitmap for cmmib131 char#2 \Theta --- */
      {   2,55905,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x0f\x38\x1c\x06\x8c\x49\xee\x3c\x77\x9e\x9f\xe7"
            "\xce\x73\x27\x19\x03\x8e\xc3\x01\x3f\x00" }  },
      /* --- pixel bitmap for cmmib131 char#3 \Lambda --- */
      {   3,56853,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x02\x60\x00\x0e\xc0\x03\x7c\x40\x0e\xc8\x81\x38"
            "\x08\x07\xe1\x11\xbc\xef\x0f" }  },
      /* --- pixel bitmap for cmmib131 char#4 \Xi --- */
      {   4,58264,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   12, 3,33, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x3c\xf1\x21\xa1\x10\xe0\x58\x68\xe0\x50\xf1\x11"
            "\xa1\x2f\x1c\x31" }  },
      /* --- pixel bitmap for cmmib131 char#5 \Pi --- */
      {   5,59491,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 19,   12, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\x02\x53\x63\x20\xf3\x43\x63\x30\xf3\x33\x63\x40"
            "\x23\x63\x57\x27\x34" }  },
      /* --- pixel bitmap for cmmib131 char#6 \Sigma --- */
      {   6,60632,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   12, 3,41, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x34\x62\x44\x61\x53\x61\x54\x51\x63\xc3\x41\x72"
            "\x51\x61\x61\x52\x62\x3c\x2c\x32" }  },
      /* --- pixel bitmap for cmmib131 char#7 \Upsilon --- */
      {   7,61684,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   12, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x24\x44\x16\x26\x33\x13\x21\x52\x12\x40\xf1\x63\x50"
            "\xf3\x53\x60\x43\x98\x4c" }  },
      /* --- pixel bitmap for cmmib131 char#8 \Phi --- */
      {   8,62698,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   12, 3,39, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x48\x93\xa3\x98\x42\x23\x13\x23\x23\x26\x23\x23\x23"
            "\x13\x22\x48\x93\xa3\x98\x4c" }  },
      /* --- pixel bitmap for cmmib131 char#9 \Psi --- */
      {   9,63789,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   12, 3,39, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x48\x93\x44\x23\x23\xf2\x13\x23\x13\x10\x13\x13\x13"
            "\x42\x16\x67\x93\xa3\x98\x4c" }  },
      /* --- pixel bitmap for cmmib131 char#10 \Omega --- */
      {  10,64962,                      /* character number, location */
         12, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 14,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x0f\x0e\xc6\x81\x3b\xe0\x0e\xb8\x03\xe7\xc0\x34"
            "\x58\x09\xd2\xc3\xf3\xf8\x3c\x1e" }  },
      /* --- pixel bitmap for cmmib131 char#11 \alpha --- */
      {  11,65962,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x40\x88\x86\x35\x58\x83\x33\x18\xc3\xe3\x63" }  },
      /* --- pixel bitmap for cmmib131 char#12 \beta --- */
      {  12,66997,                      /* character number, location */
         13, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          { 11,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x03\x21\x04\x21\x88\x60\xf4\xa1\x8f\xc0\x04\x26"
            "\x30\xc1\x0c\xa3\x0f\x01\x08\x20\x00\x01\x00" }  },
      /* --- pixel bitmap for cmmib131 char#13 \gamma --- */
      {  13,67928,                      /* character number, location */
          8, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          { 12,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\xe8\x47\xc3\x04\x48\x00\x03\x30\x00\x03\x10\x00"
            "\x01\x10\x80\x00\x08" }  },
      /* --- pixel bitmap for cmmib131 char#14 \delta --- */
      {  14,68871,                      /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\xf8\x48\x08\x18\x18\x38\x74\x66\x63\x63\x23\x33"
            "\x1e" }  },
      /* --- pixel bitmap for cmmib131 char#15 \epsilon --- */
      {  15,69751,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\x83\xe0\x37\x18\x08\x78" }  },
      /* --- pixel bitmap for cmmib131 char#16 \zeta --- */
      {  16,70677,                      /* character number, location */
         13, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  8,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x20\xe0\xf0\x08\x04\x06\x03\x03\x03\x03\x07\x3e"
            "\x7c\x60\x60\x38" }  },
      /* --- pixel bitmap for cmmib131 char#17 \eta --- */
      {  17,71544,                      /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  9,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xee\x35\x37\x66\xcc\x98\xb1\x31\x63\xc0\x80\x81\x01"
            "\x03" }  },
      /* --- pixel bitmap for cmmib131 char#18 \theta --- */
      {  18,72294,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x30\x31\x66\x6c\xd8\xb0\xff\x61\xc3\x86\x8d\x91"
            "\xc1\x01" }  },
      /* --- pixel bitmap for cmmib131 char#19 \iota --- */
      {  19,72901,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x63\x18\xc6\x38\x39" }  },
      /* --- pixel bitmap for cmmib131 char#20 \kappa --- */
      {  20,73801,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xcc\xb1\x62\x81\x0f\x66\x18\x3b\xd4\x70" }  },
      /* --- pixel bitmap for cmmib131 char#21 \lambda --- */
      {  21,74624,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\xc0\x00\x03\x1c\x60\x80\x01\x0c\x38\xf0\x61\xc6"
            "\xd8\xc1\x03\x03" }  },
      /* --- pixel bitmap for cmmib131 char#22 \mu --- */
      {  22,75622,                      /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 11,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\xc3\x18\x63\x18\xc3\x18\xc6\x3a\xcb\x77\x06\x30"
            "\xc0\x00\x06\x00" }  },
      /* --- pixel bitmap for cmmib131 char#23 \nu --- */
      {  23,76377,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0f\x33\x6c\x98\x61\xc6\x98\xb1\xc1\x01" }  },
      /* --- pixel bitmap for cmmib131 char#24 \xi --- */
      {  24,77515,                      /* character number, location */
         13, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  7,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x08\x9e\x6f\x30\xf8\x78\x82\xc1\x60\xf0\xf0\xe1"
            "\xc1\x38" }  },
      /* --- pixel bitmap for cmmib131 char#25 \pi --- */
      {  25,78405,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xef\xff\x91\x00\x09\x98\x80\x18\x8c\x41\x18" }  },
      /* --- pixel bitmap for cmmib131 char#26 \rho --- */
      {  26,79207,                      /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 10,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x41\x8c\x31\xc3\x0c\x33\xe6\x88\x1d\x06\x18\x30"
            "\xc0\x00" }  },
      /* --- pixel bitmap for cmmib131 char#27 \sigma --- */
      {  27,80097,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\xe7\xbf\x31\x86\x31\x8c\x21\x8c\xc1\x03" }  },
      /* --- pixel bitmap for cmmib131 char#28 \tau --- */
      {  28,80834,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xfb\x1f\x01\x06\x18\x60\xc0\x00\x03" }  },
      /* --- pixel bitmap for cmmib131 char#29 \upsilon --- */
      {  29,81687,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x69\x9c\x11\x43\x0c\x31\xc2\x08\x1e" }  },
      /* --- pixel bitmap for cmmib131 char#30 \phi --- */
      {  30,82571,                      /* character number, location */
         13, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 11,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x00\x04\x20\x80\x00\x04\xfc\x30\xc9\xc4\x23\x1e"
            "\xf1\xc8\x24\xc3\x0f\x08\x40\x00\x01\x08\x00" }  },
      /* --- pixel bitmap for cmmib131 char#31 \chi --- */
      {  31,83580,                      /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 12,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\xa8\x41\x38\x02\x13\xf0\x00\x06\x60\x00\x0f\xc8"
            "\x40\x1c\x82\x15\x70" }  },
      /* --- pixel bitmap for cmmib131 char#32 \psi --- */
      {  32,84627,                      /* character number, location */
         13, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 13,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x02\x20\x00\x04\x80\x00\x10\x18\x91\x26\xce\x44"
            "\x8c\x88\x09\x31\x11\x26\x01\x1f\x40\x00\x08\x00\x01"
            "\x20\x00" }  },
      /* --- pixel bitmap for cmmib131 char#33 \omega --- */
      {  33,85712,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x24\xc0\x43\x14\x46\x61\x34\x27\xff\xe3\x1c" }  },
      /* --- pixel bitmap for cmmib131 char#34 \varepsilon --- */
      {  34,86675,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\xfe\x41\x1e\x0d\x01\x3f\x1e" }  },
      /* --- pixel bitmap for cmmib131 char#35 \vartheta --- */
      {  35,87656,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x81\x0c\x32\xc8\x20\x3b\xad\x79\x63\x8c\x31\xc6"
            "\x0c\x13\x38\x00" }  },
      /* --- pixel bitmap for cmmib131 char#36 \varpi --- */
      {  36,88845,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xff\xfd\xff\x27\x00\x21\x08\x42\x10\x84\x78\x04"
            "\x9f\x0f\x1c\x07" }  },
      /* --- pixel bitmap for cmmib131 char#37 \varrho --- */
      {  37,89708,                      /* character number, location */
          8, 2,   -4, 2,      /* topleft row,col, and botleft row,col */
          {  9,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x10\x33\x36\x6c\xd8\xd8\x91\x1e\x01\x02\xfc\xf1"
            "\x03" }  },
      /* --- pixel bitmap for cmmib131 char#38 \varsigma --- */
      {  38,90545,                      /* character number, location */
          8, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x0c\x02\x03\x03\x0e\x3c\x70\x20\x18" }  },
      /* --- pixel bitmap for cmmib131 char#39 \varphi --- */
      {  39,91470,                      /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 11,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x84\x13\x7e\x18\x43\x18\xc1\x89\xf9\x87\x1f\x18\x40"
            "\x00\x03\x18\x00" }  },
      /* --- pixel bitmap for cmmib131 char#40 \bfleftharpoonup --- */
      {  40,106960,                     /* character number, location */
         10, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          { 19,    6, 3,20, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x42\xd0\x32\xe0\x22\xe0\x2e\x0e\x09" }  },
      /* --- pixel bitmap for cmmib131 char#41 \bfleftharpoondown --- */
      {  41,107986,                     /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,    6, 3,21, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x05\x1e\x04\x22\xe0\x42\xe0\xf1\x42\xd3" }  },
      /* --- pixel bitmap for cmmib131 char#42 \bfrightharpoonup --- */
      {  42,109010,                     /* character number, location */
         10, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          { 19,    6, 3,18, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\xd2\x40\xe2\xe0\x42\x2f\x1e\x05" }  },
      /* --- pixel bitmap for cmmib131 char#43 \bfrightharpoondown --- */
      {  43,110037,                     /* character number, location */
          6, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,    6, 3,21, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x0e\x05\xe0\x12\xe0\x22\x30\xf1\xd2\x43" }  },
      /* --- pixel bitmap for cmmib131 char#44 ` --- */
      {  44,110456,                     /* character number, location */
         12, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          {  4,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x33\x33\xef" }  },
      /* --- pixel bitmap for cmmib131 char#45 ' --- */
      {  45,110880,                     /* character number, location */
         12, 1,    4, 1,      /* topleft row,col, and botleft row,col */
          {  4,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf7\xcc\xcc\x7f" }  },
      /* --- pixel bitmap for cmmib131 char#46 \triangleright --- */
      {  46,111421,                     /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x03\x07\x1f\x3b\xf3\xf3\x3b\x1f\x07\x03" }  },
      /* --- pixel bitmap for cmmib131 char#47 \triangleleft --- */
      {  47,111973,                     /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\xf0\xf8\xde\xc7\xc7\xde\xf8\xf0\xc0" }  },
      /* --- pixel bitmap for cmmib131 char#48 \0 --- */
      {  48,97647,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x42\xc3\xc3\xc3\xc3\x42\x3c" }  },
      /* --- pixel bitmap for cmmib131 char#49 \1 --- */
      {  49,98402,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 3,14, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x32\x44\x30\xf4\x32\x30\x17" }  },
      /* --- pixel bitmap for cmmib131 char#50 \2 --- */
      {  50,99364,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7e\xe3\xc0\xc0\xb0\xf8\x7e\x7f" }  },
      /* --- pixel bitmap for cmmib131 char#51 \3 --- */
      {  51,100379,                     /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  8,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\xe3\xe3\xe2\x60\x3c\x60\xe0\xe7\xe7\x63\x3c" }  },
      /* --- pixel bitmap for cmmib131 char#52 \4 --- */
      {  52,101298,                     /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  8,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\x70\x70\x68\x64\x66\x63\xff\x60\x60\x60\xf8" }  },
      /* --- pixel bitmap for cmmib131 char#53 \5 --- */
      {  53,102325,                     /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  8,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x42\x3e\x3e\x02\x02\x3e\x62\xe0\xe3\xe3\x63\x3c" }  },
      /* --- pixel bitmap for cmmib131 char#54 \6 --- */
      {  54,103210,                     /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\xc4\xc6\x03\x3b\x47\xc3\xc3\xc3\xc2\x66\x3c" }  },
      /* --- pixel bitmap for cmmib131 char#55 \7 --- */
      {  55,104105,                     /* character number, location */
          9, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  9,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\xfc\xfb\x0b\x12\x04\x04\x04\x0c\x08\x18\x30\x60"
            "\xc0\x00" }  },
      /* --- pixel bitmap for cmmib131 char#56 \8 --- */
      {  56,105020,                     /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7c\xc2\xc3\xc7\x7f\x7e\x7e\xe3\xc3\xc3\x42\x3c" }  },
      /* --- pixel bitmap for cmmib131 char#57 \9 --- */
      {  57,105909,                     /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  8,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x62\x43\xc3\xc3\xe2\xdc\xc0\xc0\x63\x23\x1e" }  },
      /* --- pixel bitmap for cmmib131 char#58 . --- */
      {  58,112454,                     /* character number, location */
          3, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  3,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x00" }  },
      /* --- pixel bitmap for cmmib131 char#59 , --- */
      {  59,113015,                     /* character number, location */
          3, 2,   -4, 2,      /* topleft row,col, and botleft row,col */
          {  3,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x49\x05" }  },
      /* --- pixel bitmap for cmmib131 char#60 < --- */
      {  60,113675,                     /* character number, location */
         12, 2,   -2, 2,      /* topleft row,col, and botleft row,col */
          { 12,   14, 3,30, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xa2\x84\x73\x74\x64\x73\x7f\x14\x80\x23\xa4\xa4\xa3"
            "\xa4\xa2" }  },
      /* --- pixel bitmap for cmmib131 char#61 / --- */
      {  61,114205,                     /* character number, location */
         14, 1,   -5, 1,      /* topleft row,col, and botleft row,col */
          {  8,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\xc0\xe0\x60\x60\x70\x30\x30\x38\x18\x1c\x0c\x0c"
            "\x0e\x06\x06\x07\x03\x03" }  },
      /* --- pixel bitmap for cmmib131 char#62 > --- */
      {  62,114892,                     /* character number, location */
         12, 2,   -2, 2,      /* topleft row,col, and botleft row,col */
          { 12,   14, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\xa4\xa3\xa4\xa4\xa3\x20\xf1\x84\x73\x74\x64\x73"
            "\x74\x82\xa1" }  },
      /* --- pixel bitmap for cmmib131 char#63 \star --- */
      {  63,115597,                     /* character number, location */
         10, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 10,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x20\x80\x00\x02\x08\xfe\xe3\x03\x07\x36\x88\x10\x04" }  },
      /* --- pixel bitmap for cmmib131 char#64 \partial --- */
      {  64,92438,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x60\x18\x81\x08\x0c\x60\x7c\x33\xdc\x60\x03\x1b"
            "\xc8\x60\x84\xc1\x03" }  },
      /* --- pixel bitmap for cmmib131 char#65 A --- */
      {  65, 1026,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x06\xc0\x01\x70\x00\x1e\x40\x07\xd0\x03\xe2\x40"
            "\x38\xf0\x0f\x82\x43\xe0\x7c\xfe" }  },
      /* --- pixel bitmap for cmmib131 char#66 B --- */
      {  66, 2364,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   12, 3,41, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3b\x63\x43\x43\x62\xf1\x43\x53\x49\x53\x53\x10\xf1"
            "\x33\x63\x33\x62\x33\x63\x1c\x37" }  },
      /* --- pixel bitmap for cmmib131 char#67 C --- */
      {  67, 3317,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   12, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x66\x12\x43\x53\x32\x81\x32\x91\x10\xf1\x13\xbf\x13"
            "\xc0\x12\x91\x32\x81\x52\x61\x86\x50" }  },
      /* --- pixel bitmap for cmmib131 char#68 D --- */
      {  68, 4437,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 17,   12, 3,41, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3b\x83\x53\x53\x72\x10\xf2\x43\x73\xf1\x33\x73\x10"
            "\x33\x72\x53\x63\x43\x62\x4b\x66" }  },
      /* --- pixel bitmap for cmmib131 char#69 E --- */
      {  69, 5844,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x7f\x70\x30\x1c\x10\x8e\x08\x47\x84\x3f\xe0\x08"
            "\x70\x44\x38\x20\x1c\x08\x07\xe6\xff\x01" }  },
      /* --- pixel bitmap for cmmib131 char#70 F --- */
      {  70, 7061,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 14,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x3f\x38\x0c\x07\xc2\x91\x70\x24\xfc\x81\x23\xe0"
            "\x08\x38\x00\x0e\xc0\x01\xfc\x03" }  },
      /* --- pixel bitmap for cmmib131 char#71 G --- */
      {  71, 8232,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x6f\x38\x38\x06\x88\x01\xe4\x00\x70\x00\x1c\xfc"
            "\x0f\x38\x06\x1c\x03\x0e\x83\x03\x3e\x01" }  },
      /* --- pixel bitmap for cmmib131 char#72 H --- */
      {  72, 9465,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 19,   12, 3,39, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x37\x27\x53\x63\x20\xf2\x43\x63\x30\x4c\x30\xf3\x33"
            "\x63\x40\x23\x63\x57\x27\x32" }  },
      /* --- pixel bitmap for cmmib131 char#73 I --- */
      {  73,10176,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   12, 3,23, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x37\x53\x20\xf3\x43\x30\xf3\x33\x40\x23\x57\x33" }  },
      /* --- pixel bitmap for cmmib131 char#74 J --- */
      {  74,10994,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   12, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x67\x93\x10\xf3\x83\x20\xf2\x73\x30\x13\x33\x33\x33"
            "\x56\x60" }  },
      /* --- pixel bitmap for cmmib131 char#75 K --- */
      {  75,12211,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 18,   12, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x37\x35\x53\x62\x63\x61\x83\x41\xa3\x22\xb3\x13\xa8"
            "\x70\xf1\x33\x33\x60\x33\x43\x73\x54\x47\x26\x30" }  },
      /* --- pixel bitmap for cmmib131 char#76 L --- */
      {  76,13142,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 13,   12, 3,33, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x37\x83\x50\xf3\x43\x60\x33\x70\xf1\x33\x61\x33\x51"
            "\x33\x43\x1b\x23" }  },
      /* --- pixel bitmap for cmmib131 char#77 M --- */
      {  77,14460,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 23,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x01\x7e\xf0\x80\x0e\x74\xc0\x03\x3a\xd0\x01\x39"
            "\xe4\x80\x1c\x71\x20\x8e\x1c\x10\x27\x0e\x08\x0f\x07"
            "\x84\x83\x03\xc1\xe1\xe0\x63\xfc\x01" }  },
      /* --- pixel bitmap for cmmib131 char#78 N --- */
      {  78,15622,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 19,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\xc0\x07\x0f\x08\xf4\x20\x20\x0f\x01\x71\x08\x08"
            "\x47\x20\x78\x01\x81\x0f\x08\x78\x40\x80\x03\x01\x0c"
            "\x3e\x40\x00" }  },
      /* --- pixel bitmap for cmmib131 char#79 O --- */
      {  79,16481,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   12, 3,41, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x66\x73\x43\x42\x72\x32\x83\xf1\x13\x83\x0f\x13\x83"
            "\x13\x82\x32\x73\x33\x43\x76\x65" }  },
      /* --- pixel bitmap for cmmib131 char#80 P --- */
      {  80,17576,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   12, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3b\x63\x43\xf2\x43\x53\x43\x43\x49\x30\xf2\x33\x90"
            "\x23\xa7\x82" }  },
      /* --- pixel bitmap for cmmib131 char#81 Q --- */
      {  81,18599,                      /* character number, location */
         12, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          { 15,   16, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x0f\x38\x1c\x06\x8c\x01\xee\x00\x77\x80\x1f\xe0"
            "\x0e\x70\x07\x18\x73\x8e\xe7\x01\x3f\x02\x10\x01\x78"
            "\x00\x3c\x00\x0e" }  },
      /* --- pixel bitmap for cmmib131 char#82 R --- */
      {  82,19904,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 16,   12, 3,41, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3b\x73\x43\x10\xf1\x43\x53\x10\x43\x43\x68\x40\xf3"
            "\x33\x43\x30\x23\x53\x28\x44\x16" }  },
      /* --- pixel bitmap for cmmib131 char#83 S --- */
      {  83,20963,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   12, 3,33, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x57\x32\x52\x31\x61\x32\xa6\x77\x67\x84\xa2\x21\x71"
            "\x22\x61\x38\x43" }  },
      /* --- pixel bitmap for cmmib131 char#84 T --- */
      {  84,22015,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   12, 3,33, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x11\x43\x22\x0f\x21\x43\x31\x10\x53\x50\xf3\x43"
            "\x60\x33\x79\x43" }  },
      /* --- pixel bitmap for cmmib131 char#85 U --- */
      {  85,23031,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   12, 3,33, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07\x45\x23\x81\x20\xf3\x13\x81\x3f\x23\x81\x43\x71"
            "\x62\x61\x87\x73" }  },
      /* --- pixel bitmap for cmmib131 char#86 V --- */
      {  86,23943,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7f\x78\x0e\x08\x0f\x02\x07\x81\x43\xc0\x11\xe0\x04"
            "\xf0\x02\xf0\x00\x38\x00\x1c\x00\x06\x00" }  },
      /* --- pixel bitmap for cmmib131 char#87 W --- */
      {  87,25316,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 21,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7f\x7e\x9e\x83\x83\x70\xf8\x10\x0e\x1d\xc1\x91\x13"
            "\x78\x71\x02\x2e\x2e\xc0\xc3\x07\x78\x78\x00\x07\x07"
            "\x60\xe0\x00\x0c\x08\x00" }  },
      /* --- pixel bitmap for cmmib131 char#88 X --- */
      {  88,26455,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   12, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x36\x25\x53\x41\x84\x21\xa3\x11\xb4\xd3\xd4\xb1\x13"
            "\xa1\x24\x81\x43\x71\x53\x45\x27\x23" }  },
      /* --- pixel bitmap for cmmib131 char#89 Y --- */
      {  89,27521,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 15,   12, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x07\x44\x24\x61\x53\x51\x64\x31\x83\x21\x96\xa4\x60"
            "\xf2\x53\x70\x43\xa7\x63" }  },
      /* --- pixel bitmap for cmmib131 char#90 Z --- */
      {  90,28600,                      /* character number, location */
         12, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x3f\x06\xc7\xe0\x10\x1c\x84\x03\x70\x00\x0e\xc0"
            "\x21\x38\x08\x07\xe3\x60\xfc\x1f" }  },
      /* --- pixel bitmap for cmmib131 char#91 \flat --- */
      {  91,116280,                     /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x41\x10\x04\x41\xf0\xc5\x71\x9c\x35\x47\x00" }  },
      /* --- pixel bitmap for cmmib131 char#92 \natural --- */
      {  92,117025,                     /* character number, location */
         14, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  6,   18, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x41\x10\x04\x71\xff\x8e\x61\x18\x86\x71\xff\x8e\x20"
            "\x08" }  },
      /* --- pixel bitmap for cmmib131 char#93 \sharp --- */
      {  93,117884,                     /* character number, location */
         13, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  6,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x90\x24\xc9\xfe\x37\x49\x92\x24\xc9\xfe\x37\x49\x02" }  },
      /* --- pixel bitmap for cmmib131 char#94 \smile --- */
      {  94,118790,                     /* character number, location */
          8, 1,    3, 1,      /* topleft row,col, and botleft row,col */
          { 19,    5, 3,21, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\xe0\x31\x11\xe0\x11\x33\x93\x6b\xa7\x61" }  },
      /* --- pixel bitmap for cmmib131 char#95 \frown --- */
      {  95,119656,                     /* character number, location */
          9, 1,    3, 1,      /* topleft row,col, and botleft row,col */
          { 19,    6, 3,22, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x91\xe9\x8d\x52\xb2\x31\xe0\x11\x11\xe0\x31" }  },
      /* --- pixel bitmap for cmmib131 char#96 \ell --- */
      {  96,93222,                      /* character number, location */
         13,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          {  9,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x80\x82\x05\x05\x0b\x0e\x0c\x0c\x18\x38\x68\x80"
            "\x08\x0f" }  },
      /* --- pixel bitmap for cmmib131 char#97 a --- */
      {  97,29528,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\xcc\x89\x19\x33\x66\xec\x2c\x77" }  },
      /* --- pixel bitmap for cmmib131 char#98 b --- */
      {  98,30378,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x06\xc3\x60\xf0\x99\xc7\xe3\xf1\x68\xe6\x00" }  },
      /* --- pixel bitmap for cmmib131 char#99 c --- */
      {  99,31199,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\xc4\x46\x03\x03\x03\x43\x3e" }  },
      /* --- pixel bitmap for cmmib131 char#100 d --- */
      { 100,32157,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x01\x03\x06\x06\x0c\x9f\x39\x31\x63\xc6\x8c\x9d"
            "\xe5\x0e" }  },
      /* --- pixel bitmap for cmmib131 char#101 e --- */
      { 101,32984,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\xa3\xf0\x37\x18\x0c\x7d" }  },
      /* --- pixel bitmap for cmmib131 char#102 f --- */
      { 102,34120,                      /* character number, location */
         13, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 10,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x01\x0d\x16\x18\x60\xf0\x07\x03\x0c\x30\xc0\x00"
            "\x03\x0c\x18\x60\xa0\xc1\x02\x06\x00" }  },
      /* --- pixel bitmap for cmmib131 char#103 g --- */
      { 103,35097,                      /* character number, location */
          8,-1,   -4,-1,      /* topleft row,col, and botleft row,col */
          { 10,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x63\x8e\x18\x63\x8c\x31\xc6\x0c\x3e\xc0\x00\x23"
            "\x86\x0f" }  },
      /* --- pixel bitmap for cmmib131 char#104 h --- */
      { 104,36010,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x60\x80\x01\x03\x0c\xf0\xc3\x8c\x31\xc6\x18\x63"
            "\xe6\x58\xc3\x00" }  },
      /* --- pixel bitmap for cmmib131 char#105 i --- */
      { 105,36798,                      /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x04\x00\x00\xc0\x68\x19\xc3\x98\x16\x03" }  },
      /* --- pixel bitmap for cmmib131 char#106 j --- */
      { 106,37711,                      /* character number, location */
         14,-1,   -4,-1,      /* topleft row,col, and botleft row,col */
          {  9,   18, 3,39, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x81\xf3\x90\x53\x51\x22\x31\x22\x10\xf2\x62\x10"
            "\xf3\x52\x20\x11\x22\x44\x42" }  },
      /* --- pixel bitmap for cmmib131 char#107 k --- */
      { 107,38716,                      /* character number, location */
         13, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x30\x60\x60\xc0\x80\x19\x6b\x4b\x1e\x6c\x98\x1d"
            "\x35\x0e" }  },
      /* --- pixel bitmap for cmmib131 char#108 l --- */
      { 108,39408,                      /* character number, location */
         13, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  5,   13, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1c\x63\xc6\x18\x33\xc6\xd8\xe5\x00" }  },
      /* --- pixel bitmap for cmmib131 char#109 m --- */
      { 109,40611,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xce\x79\x74\xce\x74\x8c\x61\x18\xc3\x30\x86\x61\xa6"
            "\x61\x2c\xc3\x30" }  },
      /* --- pixel bitmap for cmmib131 char#110 n --- */
      { 110,41590,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xce\xa1\x33\x1d\xc3\x30\x0c\xc3\x98\x86\x65\x30" }  },
      /* --- pixel bitmap for cmmib131 char#111 o --- */
      { 111,42330,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\xc4\xc6\xc3\xc3\x63\x23\x1e" }  },
      /* --- pixel bitmap for cmmib131 char#112 p --- */
      { 112,43270,                      /* character number, location */
          8, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          { 10,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xdc\xd1\xac\x31\xc6\x18\x63\xc4\x19\x1f\x0c\x30\x60"
            "\xc0\x03" }  },
      /* --- pixel bitmap for cmmib131 char#113 q --- */
      { 113,44185,                      /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  8,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb8\xe6\x62\x63\x63\x63\x33\x3e\x30\x30\x18\x3c" }  },
      /* --- pixel bitmap for cmmib131 char#114 r --- */
      { 114,45050,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x6e\xda\x4d\x0c\x0c\x0c\x06\x06" }  },
      /* --- pixel bitmap for cmmib131 char#115 s --- */
      { 115,45982,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x78\xc4\x46\x3c\x78\x42\x23\x1e" }  },
      /* --- pixel bitmap for cmmib131 char#116 t --- */
      { 116,46748,                      /* character number, location */
         12, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          {  6,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x18\xc6\x30\x3f\x63\x18\x86\x39\x39" }  },
      /* --- pixel bitmap for cmmib131 char#117 u --- */
      { 117,47744,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\xd3\x58\x66\x18\xc3\x18\xc6\x32\x0b\x77" }  },
      /* --- pixel bitmap for cmmib131 char#118 v --- */
      { 118,48611,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x34\x67\x62\xc4\x88\x09\x13\x1c" }  },
      /* --- pixel bitmap for cmmib131 char#119 w --- */
      { 119,49767,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x93\xc6\x9c\x19\x31\x46\x8c\x11\x63\xc4\x9c\xe0"
            "\x1c" }  },
      /* --- pixel bitmap for cmmib131 char#120 x --- */
      { 120,50985,                      /* character number, location */
          8, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 12,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x47\xce\x62\x04\x06\x60\x20\x46\x73\xe2\x1c" }  },
      /* --- pixel bitmap for cmmib131 char#121 y --- */
      { 121,52039,                      /* character number, location */
          8, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 10,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x6b\x9c\x19\x63\x8c\x31\xc6\x0c\x3e\xc0\x88\x31"
            "\x82\x07" }  },
      /* --- pixel bitmap for cmmib131 char#122 z --- */
      { 122,52959,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x98\x7c\x20\x10\x08\x84\x7e\x39" }  },
      /* --- pixel bitmap for cmmib131 char#123 \imath --- */
      { 123,93918,                      /* character number, location */
          8, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  6,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8c\x96\x31\x8c\x69\x31" }  },
      /* --- pixel bitmap for cmmib131 char#124 \jmath --- */
      { 124,94713,                      /* character number, location */
          8,-1,   -4,-1,      /* topleft row,col, and botleft row,col */
          {  9,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x20\x23\x03\x06\x0c\x18\x18\x30\x60\xc0\xc8\xf0"
            "\x00" }  },
      /* --- pixel bitmap for cmmib131 char#125 \wp --- */
      { 125,95828,                      /* character number, location */
          8, 2,   -4, 2,      /* topleft row,col, and botleft row,col */
          { 11,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x30\xde\x8c\x17\x7c\xe0\x01\x4d\xec\x1c\x0d\x68"
            "\xc0\x01\x06\x00" }  },
      /* --- pixel bitmap for cmmib131 char#126 \bfvec --- */
      { 126,96440,                      /* character number, location */
         13, 4,    9, 4,      /* topleft row,col, and botleft row,col */
          {  8,    4, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\xff\xff\x38" }  },
      /* --- pixel bitmap for cmmib131 char#127 (noname) --- */
      { 127,96978,                      /* character number, location */
         12, 6,   10, 6,      /* topleft row,col, and botleft row,col */
          {  8,    2, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7e\x81" }  },
      /* --- trailer  --- */
      { -99, -999,  0,0,0,0, { 0,0,0,0, (pixbyte *)"\0" }  }
   } ;


/* --- size=4 for .160gf ---
 * mf '\mode=preview; mag=magstep(-15.29639112828755784636); input cmmib10'
 * --------------------------------------------------------------------- */
/* --- fontdef for cmmib160 --- */
static	chardef  cmmib160[] =
   {
      /* --- pixel bitmap for cmmib160 char#0 \Gamma --- */
      {   0,54473,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   15, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3d\xf1\x53\x62\xf1\x53\x71\xf3\x43\x90\xf3\x33\xa0"
            "\x23\xb8\x86" }  },
      /* --- pixel bitmap for cmmib160 char#1 \Delta --- */
      {   1,55378,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   15, 3,58, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc2\xe0\x23\xe0\x24\xe1\x13\xd1\x23\xc1\x34\xa1\x53"
            "\x92\x53\x91\x64\x71\x83\x61\x93\x51\xa4\x3e\x02\x2e"
            "\x03\x1e\x05" }  },
      /* --- pixel bitmap for cmmib160 char#2 \Theta --- */
      {   2,56521,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   15, 3,61, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x77\x93\x53\x53\x83\x33\xa3\x13\xb3\x13\x11\x61\x23"
            "\x0f\x23\x28\x23\x03\x11\x61\x23\x13\xb3\x13\xa3\x32"
            "\x93\x53\x53\x88\x72" }  },
      /* --- pixel bitmap for cmmib160 char#3 \Lambda --- */
      {   3,57479,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 16,   15, 3,58, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb1\x40\xf1\xa3\x30\x94\x30\xf1\x81\x13\x30\x71\x23"
            "\x91\x33\x91\x34\x71\x44\x62\x53\x61\x63\x51\x73\x42"
            "\x73\x25\x47" }  },
      /* --- pixel bitmap for cmmib160 char#4 \Xi --- */
      {   4,58904,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   15, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4e\x01\x3e\x01\x10\xf1\x31\xd1\x10\xe0\xa1\x71\x50"
            "\xf1\x59\x50\x51\x71\x50\xf1\xe0\x50\xf1\x11\xd1\x3f"
            "\x1e\x01\x47" }  },
      /* --- pixel bitmap for cmmib160 char#5 \Pi --- */
      {   5,60139,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 22,   15, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\x05\xf3\x53\x83\x30\xf3\x43\x83\x40\xf3\x33\x83"
            "\x50\x23\x83\x68\x38\x30" }  },
      /* --- pixel bitmap for cmmib160 char#6 \Sigma --- */
      {   6,61318,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   15, 3,61, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x4e\x01\x44\x83\x53\x92\x54\x91\x63\x91\x64\xe0\x23"
            "\xe0\x24\xe0\x22\xe0\x21\x81\x81\x91\x62\x91\x61\x93"
            "\x4e\x01\x3e\x01\x42" }  },
      /* --- pixel bitmap for cmmib160 char#7 \Upsilon --- */
      {   7,62376,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 18,   15, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x25\x64\x27\x38\x43\x32\x41\x63\x12\x60\xf1\x74\x70"
            "\xf2\x73\x80\xf3\x63\x90\x53\xc9\x71" }  },
      /* --- pixel bitmap for cmmib160 char#8 \Phi --- */
      {   8,63396,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 16,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x7f\x00\x07\x00\x07\xe0\x1f\x1c\x77\x8e\xe3\x87"
            "\xe3\x87\xe3\x87\x63\xc7\x71\xce\x1d\xf8\x07\xc0\x01"
            "\xe0\x00\xfc\x07" }  },
      /* --- pixel bitmap for cmmib160 char#9 \Psi --- */
      {   9,64505,                      /* character number, location */
         15, 0,    0, 0,      /* topleft row,col, and botleft row,col */
          { 18,   15, 3,57, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x69\x30\xf1\x83\x73\x53\x34\x13\x43\x23\x20\xf2\x13"
            "\x33\x23\x30\x13\x33\x13\x62\x23\x22\x73\x16\xa7\xd3"
            "\xe3\xc9\x79" }  },
      /* --- pixel bitmap for cmmib160 char#10 \Omega --- */
      {  10,65718,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 18,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x3f\xc0\x83\x83\x03\x1c\x07\xe0\x1c\x80\x3b\x00"
            "\xe7\x00\x1c\x03\x38\x1c\x60\x60\xc0\x90\x81\x49\x04"
            "\x22\x1f\x7c\x7c\xf8\xf1\xe1\x03" }  },
      /* --- pixel bitmap for cmmib160 char#11 \alpha --- */
      {  11,66730,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x01\x0c\x21\x81\xd1\x80\x35\xc0\x1a\xe0\x0c\x30"
            "\x06\x18\x06\x0f\x7e\x1c" }  },
      /* --- pixel bitmap for cmmib160 char#12 \beta --- */
      {  12,67801,                      /* character number, location */
         15, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 13,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x07\x08\x81\x60\x08\x0c\x81\x90\x1f\xf2\x41\x60"
            "\x08\x8c\x80\x11\x30\x02\x46\x60\x14\x86\x3c\x10\x00"
            "\x02\x20\x00\x04\x00" }  },
      /* --- pixel bitmap for cmmib160 char#13 \gamma --- */
      {  13,68742,                      /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 13,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\xd0\x0f\x0e\xa3\xc0\x04\x50\x00\x0a\xc0\x00\x18"
            "\x00\x03\x20\x00\x04\x80\x00\x08\x00\x01" }  },
      /* --- pixel bitmap for cmmib160 char#14 \delta --- */
      {  14,69695,                      /* character number, location */
         16, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   16, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x60\xc0\x0f\x11\x04\x30\x80\x01\x0f\x76\x84\x19\x36"
            "\xd8\x60\x83\x0d\x62\x04\x0f" }  },
      /* --- pixel bitmap for cmmib160 char#15 \epsilon --- */
      {  15,70557,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x0c\x06\x06\x7f\x03\x03\x03\x86\x7c" }  },
      /* --- pixel bitmap for cmmib160 char#16 \zeta --- */
      {  16,71463,                      /* character number, location */
         15, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 11,   19, 3,39, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x71\x91\xb4\x56\x41\x91\x92\x70\xf1\x12\x8f\x22\x93"
            "\x93\x96\x75\x92\xa1\x73\x32" }  },
      /* --- pixel bitmap for cmmib160 char#17 \eta --- */
      {  17,72334,                      /* character number, location */
         10, 2,   -4, 2,      /* topleft row,col, and botleft row,col */
          { 12,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8e\x97\xc7\x19\x9c\xc1\x0c\xc6\x60\x0c\xc6\x60\x06"
            "\x63\x30\x00\x03\x30\x80\x01\x18" }  },
      /* --- pixel bitmap for cmmib160 char#18 \theta --- */
      {  18,73094,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x81\x11\x86\x11\xcc\x60\x02\x1b\xd8\xff\x06\x16"
            "\xd8\xc0\x04\x23\x08\x23\xf0\x00" }  },
      /* --- pixel bitmap for cmmib160 char#19 \iota --- */
      {  19,73735,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  7,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x06\x83\x61\x30\x18\x47\x33\x07" }  },
      /* --- pixel bitmap for cmmib160 char#20 \kappa --- */
      {  20,74641,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x8e\xa1\x31\x03\x16\xe0\x07\x8c\x83\xc1\x34\x98"
            "\x03\x6b\xc0\x00" }  },
      /* --- pixel bitmap for cmmib160 char#21 \lambda --- */
      {  21,75474,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x00\x0c\x80\x01\x60\x00\x0c\x80\x03\x60\x00\x1c"
            "\x80\x03\x6c\xc0\x18\x0c\xc3\xc0\x0c\x98\x00\x06" }  },
      /* --- pixel bitmap for cmmib160 char#22 \mu --- */
      {  22,76480,                      /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 14,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x10\x08\x06\x83\xc1\x60\x30\x0c\x06\x83\xc1\x60\x32"
            "\x9c\x8e\x97\x1f\x63\x00\x18\x00\x03\xc0\x00\x00" }  },
      /* --- pixel bitmap for cmmib160 char#23 \nu --- */
      {  23,77271,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\xc8\xc0\x0c\xcc\x60\x06\x62\x30\x86\x61\x06\x3b"
            "\x70\x00" }  },
      /* --- pixel bitmap for cmmib160 char#24 \xi --- */
      {  24,78391,                      /* character number, location */
         15, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 10,   19, 3,45, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x61\x81\x95\x32\x14\x22\x60\xf1\x12\x70\xf1\x26\x20"
            "\x12\x7f\x22\x83\x85\x76\x73\x91\x54\x20" }  },
      /* --- pixel bitmap for cmmib160 char#25 \pi --- */
      {  25,79287,                      /* character number, location */
         10, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 13,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xdf\xff\x47\x04\x88\x00\x19\x30\x03\x62\x60\x0c"
            "\x8c\x83\x20\x00" }  },
      /* --- pixel bitmap for cmmib160 char#26 \rho --- */
      {  26,80123,                      /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 12,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xc0\x07\xc3\x10\x8c\x81\x0c\xcc\xc0\x0c\xcc\x60\x0e"
            "\x63\x1f\x06\x60\x00\x03\x30\x00" }  },
      /* --- pixel bitmap for cmmib160 char#27 \sigma --- */
      {  27,81021,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   10, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x49\x3a\x22\x42\x42\x52\x3f\x22\x62\x32\x52\x51\x42"
            "\x75\x62" }  },
      /* --- pixel bitmap for cmmib160 char#28 \tau --- */
      {  28,81766,                      /* character number, location */
         10, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 12,   10, 3,25, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x2a\x1c\x41\x60\xf1\x51\x60\xf2\x42\x60\xf1\x32\x72" }  },
      /* --- pixel bitmap for cmmib160 char#29 \upsilon --- */
      {  29,82649,                      /* character number, location */
         10, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 12,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\xac\xc1\x19\x9c\x81\x0c\xc4\x40\x0c\xc4\x20\x0c"
            "\x01\x0f" }  },
      /* --- pixel bitmap for cmmib160 char#30 \phi --- */
      {  30,83543,                      /* character number, location */
         15, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 14,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x02\x80\x00\x20\x00\x04\x00\x01\xf8\x83\x91\x31"
            "\xc2\x86\xf0\x20\x3c\x08\x0f\xc1\x42\x98\x91\x83\x3f"
            "\x80\x00\x20\x00\x08\x00\x02\x00" }  },
      /* --- pixel bitmap for cmmib160 char#31 \chi --- */
      {  31,84604,                      /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 14,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x60\x06\x84\x83\xc0\x10\x70\x02\x58\x00\x0e\x00"
            "\x03\xe0\x01\x64\x80\x38\x10\x0c\x02\x57\x00\x07" }  },
      /* --- pixel bitmap for cmmib160 char#32 \psi --- */
      {  32,85661,                      /* character number, location */
         15, 2,   -4, 2,      /* topleft row,col, and botleft row,col */
          { 15,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x04\x00\x02\x80\x00\x40\x00\x20\x60\x10\x6b\x84"
            "\x33\xc2\x19\x41\x86\x10\x23\x88\x11\xc2\x88\xc0\x24"
            "\xc0\x0f\x80\x00\x40\x00\x20\x00\x08\x00" }  },
      /* --- pixel bitmap for cmmib160 char#33 \omega --- */
      {  33,86760,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0c\x60\x02\xb0\x00\x58\x10\x1c\x0c\x0a\x06\x05\xc3"
            "\xc6\x33\xbe\x0f\x8e\x03" }  },
      /* --- pixel bitmap for cmmib160 char#34 \varepsilon --- */
      {  34,87735,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\xf1\x6f\x90\x00\x7e\xe8\x11\x40\x40\xff\xf0\x01" }  },
      /* --- pixel bitmap for cmmib160 char#35 \vartheta --- */
      {  35,88696,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 13,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x07\x88\x81\x30\x10\x04\xc2\x9c\x58\xe6\xcb\xe0"
            "\x19\x8c\xc1\x30\x18\x06\xc1\x30\x18\x03\x1e\x00" }  },
      /* --- pixel bitmap for cmmib160 char#36 \varpi --- */
      {  36,89895,                      /* character number, location */
         10, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 20,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfc\xff\xef\xff\xff\x11\x00\x82\x00\x20\x08\x02\x42"
            "\x20\x20\x04\x07\x43\x58\x18\xfc\xfc\x80\x83\x07" }  },
      /* --- pixel bitmap for cmmib160 char#37 \varrho --- */
      {  37,90796,                      /* character number, location */
         10, 2,   -4, 2,      /* topleft row,col, and botleft row,col */
          { 11,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\xc3\x30\x82\x19\x68\x60\x03\x1b\xd8\x60\x85\xc9"
            "\x47\x00\x02\xf0\x1f\xff\x00" }  },
      /* --- pixel bitmap for cmmib160 char#38 \varsigma --- */
      {  38,91617,                      /* character number, location */
         10, 0,   -2, 0,      /* topleft row,col, and botleft row,col */
          { 10,   12, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x73\x68\x80\x01\x07\x18\xe0\x01\x1f\xf0\x00\x03"
            "\x0c\x1c" }  },
      /* --- pixel bitmap for cmmib160 char#39 \varphi --- */
      {  39,92548,                      /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 14,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\x1c\xc1\x2f\x18\x0a\x82\x41\x60\x10\x18\x02\x99"
            "\x70\xfc\x07\xfc\x00\x03\xc0\x00\x18\x00\x06\x00" }  },
      /* --- pixel bitmap for cmmib160 char#40 \bfleftharpoonup --- */
      {  40,108166,                     /* character number, location */
         12, 1,    5, 1,      /* topleft row,col, and botleft row,col */
          { 23,    7, 3,28, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x52\xe0\x20\x42\xe0\x63\xe0\x53\xe0\x5e\x0e\x0e"
            "\x03" }  },
      /* --- pixel bitmap for cmmib160 char#41 \bfleftharpoondown --- */
      {  41,109194,                     /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 23,    7, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x0e\x09\x1e\x08\x23\xe0\x73\xe0\x72\xe0\x30\xf1\x52"
            "\xe0\x22" }  },
      /* --- pixel bitmap for cmmib160 char#42 \bfrightharpoonup --- */
      {  42,110220,                     /* character number, location */
         12, 1,    5, 1,      /* topleft row,col, and botleft row,col */
          { 23,    7, 3,26, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\xe0\x22\x50\xe0\x32\xe0\x73\xe0\x73\x2f\x1e\x09" }  },
      /* --- pixel bitmap for cmmib160 char#43 \bfrightharpoondown --- */
      {  43,111249,                     /* character number, location */
          7, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 23,    7, 3,27, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x0e\x09\xe0\x43\xe0\x53\xe0\x62\x40\xf1\xe0\x22"
            "\x50" }  },
      /* --- pixel bitmap for cmmib160 char#44 ` --- */
      {  44,111670,                     /* character number, location */
         13, 1,    5, 1,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xd8\x9f\x31\x8e\xc7" }  },
      /* --- pixel bitmap for cmmib160 char#45 ' --- */
      {  45,112094,                     /* character number, location */
         13, 1,    5, 1,      /* topleft row,col, and botleft row,col */
          {  5,    8, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe3\x71\x8c\xf9\x1b" }  },
      /* --- pixel bitmap for cmmib160 char#46 \triangleright --- */
      {  46,112635,                     /* character number, location */
         13, 0,   -1, 0,      /* topleft row,col, and botleft row,col */
          { 13,   14, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\xb4\x96\x72\x23\x62\x34\x42\x54\x2f\x12\x74\x02"
            "\x54\x22\x34\x42\x23\x66\x74\x92\xb6" }  },
      /* --- pixel bitmap for cmmib160 char#47 \triangleleft --- */
      {  47,113203,                     /* character number, location */
         13, 0,   -1, 0,      /* topleft row,col, and botleft row,col */
          { 13,   14, 3,42, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb2\x94\x76\x54\x22\x43\x42\x24\x52\x0f\x14\x72\x24"
            "\x52\x43\x42\x54\x22\x76\x94\xb2" }  },
      /* --- pixel bitmap for cmmib160 char#48 \0 --- */
      {  48,98787,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   10, 3,19, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x27\x32\x52\x1f\x52\x72\x12\x52\x37\x21" }  },
      /* --- pixel bitmap for cmmib160 char#49 \1 --- */
      {  49,99550,                      /* character number, location */
         10, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  8,   10, 3,12, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x41\x35\x30\xf6\x32\x38" }  },
      /* --- pixel bitmap for cmmib160 char#50 \2 --- */
      {  50,100516,                     /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xfe\x09\xd8\x80\x01\x0c\x30\xc0\x80\x11\xff\xfe\xfb"
            "\x1f" }  },
      /* --- pixel bitmap for cmmib160 char#51 \3 --- */
      {  51,101537,                     /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 11,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x30\x8c\xe1\x08\x07\x38\xe0\xe0\x03\x70\x00\x07"
            "\xf8\xc1\x0f\x2e\x38\x7e\x00" }  },
      /* --- pixel bitmap for cmmib160 char#52 \4 --- */
      {  52,102460,                     /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 11,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x80\x01\x0e\x70\x40\x03\x19\xc4\x10\xc6\x30\x83\xf9"
            "\x3f\x60\x00\x03\x18\xf8\x03" }  },
      /* --- pixel bitmap for cmmib160 char#53 \5 --- */
      {  53,103495,                     /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 11,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x04\xe3\x0f\x3f\x28\x40\x00\x7a\x30\x8e\x60\x00\x07"
            "\xf8\xc0\x07\x26\x18\x7e\x00" }  },
      /* --- pixel bitmap for cmmib160 char#54 \6 --- */
      {  54,104390,                     /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\xc1\x18\xc1\x0c\x30\x80\x79\x3c\x6c\x40\x03\x1e"
            "\xb0\x80\x0d\xc4\x30\x7c\x00" }  },
      /* --- pixel bitmap for cmmib160 char#55 \7 --- */
      {  55,105291,                     /* character number, location */
         11, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 12,   15, 3,31, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x11\xbb\x1a\x11\x81\x21\x71\xa1\xa2\xa1\xa2\xa1\x60"
            "\xf4\x42\x62" }  },
      /* --- pixel bitmap for cmmib160 char#56 \8 --- */
      {  56,106210,                     /* character number, location */
         14, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x20\x8c\xc1\x0c\xe6\x31\xfe\xe0\x87\x7f\xc6\x1f"
            "\xf8\x80\x07\x6c\x30\x7e\x00" }  },
      /* --- pixel bitmap for cmmib160 char#57 \9 --- */
      {  57,107107,                     /* character number, location */
         10, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 11,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x30\x88\xc0\x06\x3c\xe0\x01\x0b\xd8\xf0\x78\x06"
            "\x30\xc0\x0c\x66\x18\x3e\x00" }  },
      /* --- pixel bitmap for cmmib160 char#58 . --- */
      {  58,113700,                     /* character number, location */
          3, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  3,    3, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x00" }  },
      /* --- pixel bitmap for cmmib160 char#59 , --- */
      {  59,114261,                     /* character number, location */
          3, 2,   -4, 2,      /* topleft row,col, and botleft row,col */
          {  3,    7, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xba\x49\x05" }  },
      /* --- pixel bitmap for cmmib160 char#60 < --- */
      {  60,114921,                     /* character number, location */
         14, 2,   -2, 2,      /* topleft row,col, and botleft row,col */
          { 16,   16, 3,34, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe2\xc4\xa4\xa4\xa4\xa4\xa4\xaf\x14\xc0\x24\xe4\xe4"
            "\xe4\xe4\xe4\xe2" }  },
      /* --- pixel bitmap for cmmib160 char#61 / --- */
      {  61,115455,                     /* character number, location */
         17, 1,   -6, 1,      /* topleft row,col, and botleft row,col */
          { 11,   23, 3,55, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x92\x83\x82\x83\x82\x83\x20\xf1\x62\x30\x53\x82"
            "\x83\x82\x83\x50\xf1\x32\x60\x23\x82\x83\x82\x83\x8f"
            "\x12\x92" }  },
      /* --- pixel bitmap for cmmib160 char#62 > --- */
      {  62,116150,                     /* character number, location */
         14, 2,   -2, 2,      /* topleft row,col, and botleft row,col */
          { 16,   16, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x02\xe4\xe4\xe4\xe4\xe4\xe4\x20\xf1\xc4\xa4\xa4\xa4"
            "\xa4\xa4\xa4\xc2\xe1" }  },
      /* --- pixel bitmap for cmmib160 char#63 \star --- */
      {  63,116859,                     /* character number, location */
         12, 0,    1, 0,      /* topleft row,col, and botleft row,col */
          { 13,   11, 3,29, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf3\x61\x62\x41\x42\x29\x65\x93\x92\x12\x81\x31\x71"
            "\x51\x34" }  },
      /* --- pixel bitmap for cmmib160 char#64 \partial --- */
      {  64,93528,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\x03\x82\x60\x20\x0c\x0c\x80\x01\x30\x7c\x66\xd0"
            "\x06\x7c\x80\x0d\xb0\x01\x33\x20\x0c\x03\x3f\x00" }  },
      /* --- pixel bitmap for cmmib160 char#65 A --- */
      {  65, 1026,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   15, 3,52, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\xb2\x40\xa3\xd4\xd5\xb1\x23\x30\xf1\x71\x33\x30"
            "\x61\x43\x81\x53\x8a\x61\x73\x20\xf1\x31\x83\x26\x47" }  },
      /* --- pixel bitmap for cmmib160 char#66 B --- */
      {  66, 2374,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   15, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3d\x73\x63\x10\xf2\x53\x73\x43\x73\x53\x54\x6c\x63"
            "\x73\x10\xf2\x33\x83\x10\x33\x73\x43\x73\x3d\x56" }  },
      /* --- pixel bitmap for cmmib160 char#67 C --- */
      {  67, 3339,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   15, 3,47, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x77\x22\x53\x63\x43\x92\x33\xb1\x23\xc1\x23\xef\x33"
            "\xe0\x1f\x13\xb1\x30\x12\xa1\x63\x62\x97\x7d" }  },
      /* --- pixel bitmap for cmmib160 char#68 D --- */
      {  68, 4469,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 20,   15, 3,47, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3d\x93\x73\x73\x92\x10\xf1\x53\x93\xf3\x43\xa3\xf1"
            "\x33\xa3\x10\x33\x93\x53\x83\x53\x73\x5d\x7d" }  },
      /* --- pixel bitmap for cmmib160 char#69 E --- */
      {  69, 5888,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   15, 3,61, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\x01\xf1\x53\x82\x53\x91\x53\x41\x41\xf1\x43\x41"
            "\x60\x48\xa3\x32\x60\xf1\x33\x41\x41\x20\xf1\x33\x81"
            "\x30\x23\x73\x3e\x40" }  },
      /* --- pixel bitmap for cmmib160 char#70 F --- */
      {  70, 7117,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   15, 3,53, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3e\xf1\x53\x72\x53\x81\x53\x41\x31\xf1\x43\x41\x50"
            "\x48\x93\x32\x50\xf1\x33\x41\x60\xf1\x33\xb0\x23\xc8"
            "\x90" }  },
      /* --- pixel bitmap for cmmib160 char#71 G --- */
      {  71, 8298,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   15, 3,53, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x77\x22\x53\x63\x43\x92\x33\xb1\x23\xc1\x23\xef\x13"
            "\xe0\x13\x68\x1f\x23\x93\x30\x12\x93\x53\x63\x87\x21"
            "\x40" }  },
      /* --- pixel bitmap for cmmib160 char#72 H --- */
      {  72, 9541,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 22,   15, 3,45, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x38\xf3\x53\x83\x30\xf1\x43\x83\x40\x4e\x83\x83"
            "\x40\xf3\x33\x83\x50\x23\x83\x68\x38\x33" }  },
      /* --- pixel bitmap for cmmib160 char#73 I --- */
      {  73,10264,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   15, 3,25, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x49\xf3\x63\x40\xf3\x53\x50\xf3\x43\x60\x33\x79\x43" }  },
      /* --- pixel bitmap for cmmib160 char#74 J --- */
      {  74,11114,                      /* character number, location */
         15, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 13,   15, 3,33, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x58\xf3\x83\x20\xf3\x73\x30\xf1\x63\x42\x43\x43\x33"
            "\x42\x33\x65\x73" }  },
      /* --- pixel bitmap for cmmib160 char#75 K --- */
      {  75,12313,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 21,   15, 3,61, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x38\x55\x53\x91\x83\x72\x93\x61\xb3\x42\xb3\x41\xd3"
            "\x23\xd3\x14\xd4\x23\xb3\x43\xb3\x53\xa3\x54\x93\x63"
            "\x83\x83\x58\x37\x30" }  },
      /* --- pixel bitmap for cmmib160 char#76 L --- */
      {  76,13284,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 14,   15, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x39\x20\xf3\x53\x60\xf3\x43\x70\xf1\x33\x71\xf1\x33"
            "\x61\x10\x23\x53\x1c\x23" }  },
      /* --- pixel bitmap for cmmib160 char#77 M --- */
      {  77,14610,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 26,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf8\x01\xf0\x83\x0e\xe0\x01\x3a\x40\x07\xe8\x00\x1d"
            "\xa0\x03\x72\x40\x0e\xe4\x00\x71\x90\x03\xc4\x21\x0e"
            "\x10\x47\x38\x20\x9c\x70\x80\xe0\xc2\x01\x82\x07\x07"
            "\x08\x0e\x1c\x10\x38\x38\xf0\x63\xf8\x07" }  },
      /* --- pixel bitmap for cmmib160 char#78 N --- */
      {  78,15798,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 22,   15, 3,77, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x36\x76\x55\x81\x81\x13\x81\x81\x23\x71\x81\x24\x61"
            "\x71\x43\x51\x81\x53\x41\x81\x54\x31\x81\x63\x31\x71"
            "\x83\x11\x81\x85\x81\x94\x81\xa3\x71\xb2\x66\x91\x61" }  },
      /* --- pixel bitmap for cmmib160 char#79 O --- */
      {  79,16701,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   15, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x77\x73\x53\x53\x82\x33\x93\x13\xa3\x12\xb3\x0f\x23"
            "\xb3\x0f\x13\xa3\x13\x93\x23\x83\x43\x53\x87\x71" }  },
      /* --- pixel bitmap for cmmib160 char#80 P --- */
      {  80,17808,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   15, 3,39, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3d\x73\x63\x10\xf2\x53\x73\x43\x73\x53\x63\x6a\x83"
            "\xb0\xf3\x33\xc0\x23\xd8\xa3" }  },
      /* --- pixel bitmap for cmmib160 char#81 Q --- */
      {  81,18839,                      /* character number, location */
         15, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          { 17,   19, 3,65, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x77\x73\x53\x53\x82\x33\x93\xf1\x13\xa3\x0f\x23\xb3"
            "\x0f\x13\xa3\x13\x93\x23\x23\x33\x44\x34\x87\x41\xb1"
            "\x41\x20\xf1\x95\x30\xa2\x51" }  },
      /* --- pixel bitmap for cmmib160 char#82 R --- */
      {  82,20156,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   15, 3,47, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x83\x63\x10\xf2\x53\x73\x43\x73\x53\x63\x6a\x83"
            "\x53\x30\xf3\x33\x63\x30\x23\x73\x29\x54\x17" }  },
      /* --- pixel bitmap for cmmib160 char#83 S --- */
      {  83,21227,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 15,   15, 3,47, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x66\x12\x51\x62\x51\x81\x42\x81\x42\xd5\xa8\x88\xa6"
            "\xc3\xd2\x31\x92\x31\x82\x32\x72\x41\x17\x67" }  },
      /* --- pixel bitmap for cmmib160 char#84 T --- */
      {  84,22267,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 17,   15, 3,35, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\x04\x53\x51\x1f\x21\x63\x51\x10\xf3\x63\x80\xf3"
            "\x53\x90\x43\xba\x61" }  },
      /* --- pixel bitmap for cmmib160 char#85 U --- */
      {  85,23289,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 19,   15, 3,37, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x56\xf3\x23\xa1\x30\xf3\x13\xa1\x4f\x23\xa1\x50"
            "\x12\x91\x82\x62\xa7\x92" }  },
      /* --- pixel bitmap for cmmib160 char#86 V --- */
      {  86,24213,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   15, 3,61, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x55\x23\x91\x54\x81\x63\x71\x40\xf1\x33\x61\x50"
            "\x33\x51\x94\x31\xb3\x22\xb3\x21\xc3\x11\x90\xf1\x44"
            "\xa0\x52\xe0\x21\xc0" }  },
      /* --- pixel bitmap for cmmib160 char#87 W --- */
      {  87,25598,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 25,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x7f\xfc\xf1\x39\xe0\x80\x70\xe0\x81\xe0\xc0\x83\xc1"
            "\x41\x07\x81\xc7\x0e\x01\x8e\x1c\x02\x9c\x78\x02\x38"
            "\xe1\x02\x70\xc1\x05\xe0\x81\x07\xc0\x03\x0f\x80\x03"
            "\x0e\x00\x07\x0c\x00\x04\x18\x00" }  },
      /* --- pixel bitmap for cmmib160 char#88 X --- */
      {  88,26759,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 20,   15, 3,59, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x47\x27\x63\x62\xa3\x41\xc3\x31\xd4\x11\x70\xf1\x84"
            "\x80\x93\xe0\x25\xe1\x23\xd1\x34\xb1\x53\xa1\x64\x81"
            "\x83\x56\x47\x31" }  },
      /* --- pixel bitmap for cmmib160 char#89 Y --- */
      {  89,27835,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   15, 3,47, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x08\x55\x24\x81\x63\x71\x74\x52\x83\x42\x93\x32\xa4"
            "\x21\xc3\x11\xd4\x90\xf3\x53\xa0\x43\xd7\x91" }  },
      /* --- pixel bitmap for cmmib160 char#90 Z --- */
      {  90,28926,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 18,   15, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x5d\x43\x64\x52\x64\x61\x64\x71\x54\xd4\xd4\xd4\xd3"
            "\xe3\x61\x73\x71\x63\x81\x53\x82\x43\x82\x4e\x44" }  },
      /* --- pixel bitmap for cmmib160 char#91 \flat --- */
      {  91,117548,                     /* character number, location */
         17, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  8,   17, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\x01\x01\x01\x01\x01\x01\x7f\xc3\xc1\xc1\xc1\x61"
            "\x31\x19\x07\x01" }  },
      /* --- pixel bitmap for cmmib160 char#92 \natural --- */
      {  92,118303,                     /* character number, location */
         16, 2,   -4, 2,      /* topleft row,col, and botleft row,col */
          {  6,   20, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x41\x10\x04\x71\xff\x8e\x61\x18\x86\x61\x18\xf7\xef"
            "\x08\x82" }  },
      /* --- pixel bitmap for cmmib160 char#93 \sharp --- */
      {  93,119170,                     /* character number, location */
         15, 1,   -4, 1,      /* topleft row,col, and botleft row,col */
          {  8,   19, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x40\x42\x42\xc2\xfe\x7f\x43\x42\x42\x42\x42\x42\x42"
            "\xc2\xfe\x7f\x43\x42\x02" }  },
      /* --- pixel bitmap for cmmib160 char#94 \smile --- */
      {  94,120084,                     /* character number, location */
          9, 1,    3, 1,      /* topleft row,col, and botleft row,col */
          { 23,    6, 3,27, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x01\xe0\x71\x11\xe0\x51\x32\xe0\x12\x54\x94\x8d\xd7"
            "\x81" }  },
      /* --- pixel bitmap for cmmib160 char#95 \frown --- */
      {  95,120954,                     /* character number, location */
         10, 1,    3, 1,      /* topleft row,col, and botleft row,col */
          { 23,    7, 3,32, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xb1\xe0\x3b\xae\x01\x72\xd2\x51\xe0\x31\x31\xe0\x51"
            "\x11\xe0\x71" }  },
      /* --- pixel bitmap for cmmib160 char#96 \ell --- */
      {  96,94294,                      /* character number, location */
         15,-1,    0,-1,      /* topleft row,col, and botleft row,col */
          { 11,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x03\x24\x30\xc1\x08\x26\x18\xc1\x04\x16\x70\xc0"
            "\x01\x06\x38\x20\x01\x18\x83\x07" }  },
      /* --- pixel bitmap for cmmib160 char#97 a --- */
      {  97,29862,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x70\xc2\x38\x06\x63\x30\x83\x31\x18\x83\x39\x98\xe2"
            "\xc5\x31" }  },
      /* --- pixel bitmap for cmmib160 char#98 b --- */
      {  98,30724,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  9,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x1e\x18\x30\x60\xc0\xc0\x9e\x63\x83\x06\x07\x0f\x1e"
            "\x3c\x4c\x0c\x0f" }  },
      /* --- pixel bitmap for cmmib160 char#99 c --- */
      {  99,31529,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x61\x48\xb0\x01\x03\x0c\x30\xc0\x80\x86\xf1\x01" }  },
      /* --- pixel bitmap for cmmib160 char#100 d --- */
      { 100,32493,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 12,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x00\x0f\x60\x00\x06\x60\x00\x06\x37\x8c\x63\x30\x06"
            "\x33\x18\x83\x31\x98\x83\x29\x5e\x1c\x03" }  },
      /* --- pixel bitmap for cmmib160 char#101 e --- */
      { 101,33332,                      /* character number, location */
         10, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 10,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf0\x30\x64\x90\x21\x7f\x0c\x30\xc0\x80\x86\xf1\x01" }  },
      /* --- pixel bitmap for cmmib160 char#102 f --- */
      { 102,34476,                      /* character number, location */
         15, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          { 13,   19, 3,49, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x93\x92\x21\x82\x12\xf1\x72\x40\x48\x10\xf2\x72\x40"
            "\xf4\x62\x50\xf1\x52\x60\x11\x32\x62\x31\x84\x84" }  },
      /* --- pixel bitmap for cmmib160 char#103 g --- */
      { 103,35457,                      /* character number, location */
         10, 0,   -4, 0,      /* topleft row,col, and botleft row,col */
          { 11,   14, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xe0\xc4\x38\x83\x19\x6c\x30\x83\x19\xcc\x60\xc4\xc1"
            "\x0d\x60\x00\x23\x0c\x3f\x00" }  },
      /* --- pixel bitmap for cmmib160 char#104 h --- */
      { 104,36382,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 13,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\x00\x03\x60\x00\x0c\x80\x01\x98\x07\x8f\x61\x30"
            "\x0c\xc6\x60\x18\x0c\x83\x69\x18\x07\xd3\xc0\x01" }  },
      /* --- pixel bitmap for cmmib160 char#105 i --- */
      { 105,37208,                      /* character number, location */
         16, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          {  6,   16, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x30\x04\x00\x00\xe0\x64\x59\xc3\x30\xa6\x69\x31" }  },
      /* --- pixel bitmap for cmmib160 char#106 j --- */
      { 106,38129,                      /* character number, location */
         16,-1,   -4,-1,      /* topleft row,col, and botleft row,col */
          { 11,   20, 3,43, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\xf1\x92\xf3\xb0\x63\x71\x22\x10\xf1\x41\x32\x10\xf3"
            "\x72\x20\xf3\x62\x30\x11\x32\x54\x62" }  },
      /* --- pixel bitmap for cmmib160 char#107 k --- */
      { 107,39140,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          { 11,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x3c\xc0\x00\x06\x30\x80\x01\x86\x33\x9a\xc9\x3c\xf0"
            "\x80\x1d\x8c\x69\xcc\x61\x0d\x06" }  },
      /* --- pixel bitmap for cmmib160 char#108 l --- */
      { 108,39866,                      /* character number, location */
         15, 1,    0, 1,      /* topleft row,col, and botleft row,col */
          {  5,   15, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x9e\x31\xc6\x8c\x31\x66\x8c\x39\x97\x01" }  },
      /* --- pixel bitmap for cmmib160 char#109 m --- */
      { 109,41075,                      /* character number, location */
         10, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 20,   10, 1, 1, (pixbyte *) /* width,ht, fmt,pixsz,map... */
            "\x8e\xe7\x91\xc7\x31\x19\x0c\x93\xc1\x30\x0c\x86\xc1"
            "\x60\x18\x0c\x86\xc9\x60\x8c\x06\xc3\x64\x30\x38" }  },
      /* --- pixel bitmap for cmmib160 char#110 n --- */
      { 110,42096,                      /* character number, location */
         10, 2,    0, 2,      /* topleft row,col, and botleft row,col */
          { 13,   10, 1, 1, (pixbyte *) /* width,ht