/* $Id: i18n.c,v 1.7 2001/05/22 23:42:06 kuhlmann Exp $ */

/*
 * Poor man's gettext; handles internationalization of texts.
 *
 * This file is  Rdiger Kuhlmann; it may be distributed under the lastest
 * version of your choice of the GPL or BSD licence.
 */

#include "micq.h"
#include "i18n.h"
#include "util_ui.h"
#include <string.h>

#define i18nSLOTS  900

char *i18nStrings[i18nSLOTS] = { 0 };

/*
 * Opens and reads the localization file defined by parameter or the
 * environment variables LANG, LC_ALL, LC_MESSAGES.
 */
int i18nOpen (const char *loc)
{
    char buf[2048];
    int i, j = 0, debug = 0;
    FD_T i18nf;

    if (!strncmp (loc, "debug", 5))
    {
        debug = 1;
        loc += 5;
    }

    if (!strcmp (loc, "!") || !strcmp (loc, "auto") || !strcmp (loc, "default"))
        loc = NULL;

    if (!loc)
        loc = getenv ("LANG");
    if (!loc)
        loc = getenv ("LC_ALL");
    if (!loc)
        loc = getenv ("LC_MESSAGES");
    if (!loc)
        return 0;

        i18nf = M_fdopen (PREFIX "/share/micq/%s.i18n", loc);
    if (i18nf == -1 && strchr (loc, '_'))
        i18nf = M_fdopen (PREFIX "/share/micq/%.*s.i18n", strrchr (loc, '_') - loc, loc);
    if (i18nf == -1 && strchr (loc, '_'))
        i18nf = M_fdopen (PREFIX "/share/micq/%.*s.i18n", strchr (loc, '_') - loc, loc);
    if (i18nf == -1)
        i18nf = M_fdopen ("%s/.micq/%s.i18n", getenv ("HOME") ? getenv ("HOME") : "", loc);
    if (i18nf == -1 && strchr (loc, '_'))
        i18nf = M_fdopen ("%s/.micq/%.*s.i18n", getenv ("HOME") ? getenv ("HOME") : "", strrchr (loc, '_') - loc, loc);
    if (i18nf == -1 && strchr (loc, '_'))
        i18nf = M_fdopen ("%s/.micq/%.*s.i18n", getenv ("HOME") ? getenv ("HOME") : "", strchr (loc, '_') - loc, loc);
    if (i18nf == -1)
        return -1;

    i18nClose ();

    for (i = 0; i < i18nSLOTS; i++)
        i18nStrings[i] = NULL;

    while (M_fdnreadln (i18nf, buf, sizeof (buf)) != -1)
    {
        int i;
        char *p;

        i = strtol (buf, &p, 10);

        if (p == buf || i < 0 || i >= i18nSLOTS)
            continue;
        if (debug)
            i18nStrings[i] = p = strdup (buf);
        else
            i18nStrings[i] = p = strdup (++p);
        j++;
        for (; *p; p++)
            if (*p == '')
                *p = '\n';
    }
    close (i18nf);
    return j;
}

/*
 * Frees all internationalization strings.
 */
void i18nClose (void)
{
    char **p, **q;
    
    q = i18nStrings + i18nSLOTS;
    for (p = i18nStrings; p < q; p++)
    {
        if (*p)
            free (*p);
        *p = NULL;
    }
}

/*
 * Looks up the localized text by number, using the given text as default if
 * it is not found. If the text number is -1, the number is in the string as
 * constructed by the _i18n macro for static localized data.
 */
const char *i18n (int i, const char *txt)
{
    const char *p;

    if (i == -1)
    {
        char *q;
        i = strtol (txt, &q, 10);
        txt = ++q;
    }

    if (i >= 0 && i < i18nSLOTS)
        if ((p = i18nStrings[i]))
            return p;

    return txt;
}
