
#include "philo_ccm.h"

class Registrator_impl : virtual public CCM_Dinner::Registrator {
private:
  CORBA::ULong _i;

public:
  Registrator_impl ()
    {
      _i = 0;
    }

  char * _cxx_register ()
    {
      char tmp[42];
      sprintf (tmp, "# %lu", ++_i);
      return CORBA::string_dup (tmp);
    }
};

class Chopstick_impl : virtual public CCM_Dinner::Chopstick {
private:
  bool _inuse;

public:
  Chopstick_impl ()
    {
      _inuse = false;
    }

  void get ()
    {
      if (_inuse) {
	throw Dinner::InUse ();
      }

      _inuse = true;
    }

  void release ()
    {
      assert (_inuse);
      _inuse = false;
    }
};

class Philosopher_impl :
  virtual public CCM_Dinner::Philosopher,
  virtual public CORBA::DispatcherCallback
{
private:
  CORBA::Dispatcher * _disp;
  CORBA::ULong _state;
  CORBA::ULong _speed;
  bool _have_left_fork;
  bool _have_right_fork;
  bool _have_registered;
  CORBA::String_var _name;

public:
  Philosopher_impl ()
    {
      _disp = 0;
      _state = 0;
      _have_left_fork = false;
      _have_right_fork = false;
      _have_registered = false;
      _speed = 1500 + (rand() % 13) * 300;
    }

  void ccm_activate ()
    {
      CORBA::ORB_var orb = CORBA::ORB_instance ("mico-local-orb");
      _disp = orb->dispatcher ();
      _disp->tm_event (this, _speed);
      cout << "Philosopher " << _name << " is active, speed is "
	   << _speed << endl;
    }

  void ccm_passivate ()
    {
      if (_disp) {
	_disp->remove (this, CORBA::Dispatcher::Timer);
      }

      cout << "Philosopher " << _name << " is inactive." << endl;

      if (_have_left_fork) {
	Dinner::Cutlery_var _left = _get_connection_left ();
	_left->release ();
	_have_left_fork = false;
      }

      if (_have_right_fork) {
	Dinner::Cutlery_var _right = _get_connection_right ();
	_right->release ();
	_have_right_fork = false;
      }
    }

  char * name ()
    {
      return CORBA::string_dup (_name.in());
    }

  Dinner::Status howami ()
    {
      Dinner::Status s;
      s.hungry = _state;
      s.has_left_fork = _have_left_fork;
      s.has_right_fork = _have_right_fork;
      return s;
    }

  void callback (CORBA::Dispatcher * d, CORBA::Dispatcher::Event e)
    {
      assert (e == CORBA::Dispatcher::Timer);

      _disp->tm_event (this, _speed);

      if (_have_left_fork && _have_right_fork) {
	/*
	 * Eating
	 */
	if (_state > 3) {
	  _state -= 3;
	  return;
	}
	_state = 0;
	Dinner::Cutlery_var _left = _get_connection_left ();
	_left->release ();
	_have_left_fork = false;
	Dinner::Cutlery_var _right = _get_connection_right ();
	_right->release ();
	_have_right_fork = false;
	cout << "Philosopher " << _name << " has eaten." << endl;
	return;
      }

      _state++;

      if (_state < 3) {
	return;
      }

      if (!_have_registered) {
	Dinner::Registration_var _register = _get_connection_register ();
	if (!CORBA::is_nil (_register)) {
	  _name = _register->_cxx_register ();
	  _have_registered = true;
	}
      }

      if (_state == 3) {
	cout << "Philosopher " << _name << " is becoming hungry." << endl;
      }
      else if (_state >= 10) {
	cout << "Philosopher " << _name << " is starving." << endl;
      }

      Dinner::Cutlery_var _left = _get_connection_left ();

      if (!_have_left_fork && !CORBA::is_nil (_left)) {
	try {
	  _left->get ();
	  _have_left_fork = true;
	}
	catch (Dinner::InUse & ex) {
	}

	if (_have_left_fork) {
	  cout << "Philosopher " << _name << " has got the left fork." << endl;
	  return;
	}
	else {
	  cout << "Philosopher " << _name << " did not get the left fork." << endl;
	}
      }

      Dinner::Cutlery_var _right = _get_connection_right ();

      if (!_have_right_fork && !CORBA::is_nil (_right)) {
	try {
	  _right->get ();
	  _have_right_fork = true;
	}
	catch (Dinner::InUse & ex) {
	}

	if (_have_right_fork) {
	  cout << "Philosopher " << _name << " has got the right fork."
	       << endl;
	  return;
	}
	else {
	  cout << "Philosopher " << _name << " did not get the right fork."
	       << endl;
	}
      }

      if (((_have_left_fork && !_have_right_fork) ||
	   (!_have_left_fork && _have_right_fork)) && ((rand() % 3) == 0)) {
	if (_have_left_fork) {
	  _left->release ();
	  _have_left_fork = false;
	  cout << "Deadlock prevention! Philosopher " << _name
	       << " releases the left fork." << endl;
	}
	if (_have_right_fork) {
	  _right->release ();
	  _have_right_fork = false;
	  cout << "Deadlock prevention! Philosopher " << _name
	       << " releases the right fork." << endl;
	}
      }
    }
};

class RegTP_impl : virtual public CCM_Dinner::RegTP {
public:
  CCM_Dinner::Registrator_ptr create ()
    {
      return new Registrator_impl;
    }
};

class PhilosopherHome_impl : virtual public CCM_Dinner::PhilosopherHome {
public:
  CCM_Dinner::Philosopher_ptr create ()
    {
      return new Philosopher_impl;
    }
};

class ChopstickHome_impl : virtual public CCM_Dinner::ChopstickHome {
public:
  CCM_Dinner::Chopstick_ptr create ()
    {
      return new Chopstick_impl;
    }
};

extern "C" {
  CCM_Dinner::RegTP_ptr create_Dinner_RegTP ()
  {
    return new RegTP_impl;
  }
  CCM_Dinner::PhilosopherHome_ptr create_Dinner_PhilosopherHome ()
  {
    return new PhilosopherHome_impl;
  }
  CCM_Dinner::ChopstickHome_ptr create_Dinner_ChopstickHome ()
  {
    return new ChopstickHome_impl;
  }
}

