#include <mico/CosNaming.h>
#include "philo.h"

int
main (int argc, char *argv[])
{
  CORBA::ORB_var orb = CORBA::ORB_init (argc, argv);
  CORBA::Object_var obj = orb->resolve_initial_references ("NameService");
  CosNaming::NamingContextExt_var nc =
    CosNaming::NamingContextExt::_narrow (obj);

  CORBA::ULong i=3;

  if (argc == 2 && *argv[1] > '1' && *argv[1] < '9') {
    if ((i = atoi (argv[1])) == 0) {
      i = 3;
    }
  }

  cout << "creating Registration ... " << flush;

  obj = nc->resolve_str ("RegTP");

  Dinner::RegTP_var regtp = Dinner::RegTP::_narrow (obj);
  Dinner::Registrator_var reg = regtp->create ();

  cout << "done." << endl;
  cout << "creating Chopsticks ... " << flush;

  obj = nc->resolve_str ("ChopstickHome");

  Dinner::ChopstickHome_var csh = Dinner::ChopstickHome::_narrow (obj);
  Dinner::Chopstick_var f[i];

  for (CORBA::ULong j1=0; j1<i; j1++) {
    f[j1] = csh->create ();
  }

  cout << "done." << endl;
  cout << "creating Philosophers ... " << flush;

  obj = nc->resolve_str ("PhilosopherHome");

  Dinner::PhilosopherHome_var ph = Dinner::PhilosopherHome::_narrow (obj);
  Dinner::Philosopher_var p[i];

  for (CORBA::ULong j2=0; j2<i; j2++) {
    p[j2] = ph->create ();
  }

  cout << "done." << endl;
  cout << "configuring Philosophers ... " << flush;

  for (CORBA::ULong j3=0; j3<i; j3++) {
    p[j3]->connect_register (reg);
  }

  for (CORBA::ULong j4=0; j4<i; j4++) {
    p[j4]->connect_left (f[j4]);
    p[j4]->connect_right (f[(j4+1)%i]);
  }

  cout << "done." << endl;
  return 0;
}
