<?php
/** Armenian (Հայերեն)
  *
  * @addtogroup Language
  *
  * Based on MessagesEn.php revision 18716 (2007-21-02)
  * and hy.wikipedia MediaWiki namespace (2007-24-04)
  *
  * Maintainer: Ruben Vardanyan (me@RubenVardanyan.com)
  * 
  * ՈՒՇԱԴՐՈՒԹՅՈՒՆ, ՄԻ ՓՈՓՈԽԵՔ ԱՅՍ ՖԱՅԼԸ
  *
  * Եթե անհրաժեշտ է կատարել փոփոխություն ինտերֆեյսի առանձին տողերի մեջ,
  * ապա կատարեք դա խմբագրելով MediaWiki:* տիպի ֆայլերը։
  * Դրանց ցուցակը կարող եք տեսնել այս էջում՝ Special:Allmessages։
  *
  */

/**
 * Transform table for decimal point '.' and thousands separator ','
 */
$separatorTransformTable = array(
	',' => "\xc2\xa0", # nbsp
	'.' => ','
);


/**
 * URLs do not specify their encoding. UTF-8 is used by default, but if the 
 * URL is not a valid UTF-8 sequence, we have to try to guess what the real
 * encoding is. The encoding used in this case is defined below, and must be
 * supported by iconv(). 
 */
$fallback8bitEncoding = 'UTF-8';

/**
 * To allow "foo[[bar]]" to extend the link over the whole word "foobar"
 */
$linkPrefixExtension = true;

/**
 * Namespace names. NS_PROJECT is always set to $wgMetaNamespace after the 
 * settings are loaded, it will be ignored even if you specify it here. 
 *
 * NS_PROJECT_TALK will be set to $wgMetaNamespaceTalk if that variable is
 * set, otherwise the string specified here will be used. The string may 
 * contain "$1", which will be replaced by the name of NS_PROJECT. It may 
 * also contain a grammatical transformation, e.g. 
 *
 *     NS_PROJECT_TALK => 'Keskustelu_{{grammar:elative|$1}}'
 *
 * Only one grammatical transform may be specified in the string. For 
 * performance reasons, this transformation is done locally by the language 
 * module rather than by the full wikitext parser. As a result, no other 
 * parser features are available. 
 */
$namespaceNames = array(
	NS_MEDIA            => 'Մեդիա',
	NS_SPECIAL          => 'Սպասարկողէջ',
	NS_MAIN	            => '',
	NS_TALK	            => 'Քննարկում',
	NS_USER             => 'Մասնակից',
	NS_USER_TALK        => 'Մասնակցի_քննարկում',
	# NS_PROJECT set by $wgMetaNamespace
	NS_PROJECT_TALK     => '{{grammar:genitive|$1}}_քննարկում',
	NS_IMAGE            => 'Պատկեր',
	NS_IMAGE_TALK       => 'Պատկերի_քննարկում',
	NS_MEDIAWIKI        => 'MediaWiki',
	NS_MEDIAWIKI_TALK   => 'MediaWiki_քննարկում',
	NS_TEMPLATE         => 'Կաղապար',
	NS_TEMPLATE_TALK    => 'Կաղապարի_քննարկում',
	NS_HELP             => 'Օգնություն',
	NS_HELP_TALK        => 'Օգնության_քննարկում',
	NS_CATEGORY         => 'Կատեգորիա',
	NS_CATEGORY_TALK    => 'Կատեգորիայի_քննարկում',
);


/**
 * A list of date format preference keys which can be selected in user 
 * preferences. New preference keys can be added, provided they are supported
 * by the language class's timeanddate(). Only the 5 keys listed below are 
 * supported by the wikitext converter (DateFormatter.php).
 *
 * The special key "default" is an alias for either dmy or mdy depending on 
 * $wgAmericanDates
 */
$datePreferences = array(
	'default',
	'mdy',
	'dmy',
	'ymd',
	'ISO 8601',
);

/**
 * The date format to use for generated dates in the user interface.
 * This may be one of the above date preferences, or the special value 
 * "dmy or mdy", which uses mdy if $wgAmericanDates is true, and dmy 
 * if $wgAmericanDates is false.
 */
$defaultDateFormat = 'dmy or mdy';

/**
 * Associative array mapping old numeric date formats, which may still be 
 * stored in user preferences, to the new string formats.
 */
$datePreferenceMigrationMap = array(
	'default',
	'mdy',
	'dmy',
	'ymd'
);

/**
 * These are formats for dates generated by MediaWiki (as opposed to the wikitext
 * DateFormatter). Documentation for the format string can be found in 
 * Language.php, search for sprintfDate. 
 *
 * This array is automatically inherited by all subclasses. Individual keys can be
 * overridden.
 */
$dateFormats = array(
	'mdy time' => 'H:i',
	'mdy date' => 'xg j, Y',
	'mdy both' => 'H:i, xg j, Y',

	'dmy time' => 'H:i',
	'dmy date' => 'j xg Y',
	'dmy both' => 'H:i, j xg Y',

	'ymd time' => 'H:i',
	'ymd date' => 'Y xg j',
	'ymd both' => 'H:i, Y xg j',

	'ISO 8601 time' => 'xnH:xni:xns',
	'ISO 8601 date' => 'xnY-xnm-xnd',
	'ISO 8601 both' => 'xnY-xnm-xnd"T"xnH:xni:xns',
);

$bookstoreList = array(
	'Amazon.com' => 'http://www.amazon.com/exec/obidos/ISBN=$1'
);

/**
 * Magic words
 * Customisable syntax for wikitext and elsewhere
 *
 * Note to translators:
 *   Please include the English words as synonyms.  This allows people
 *   from other wikis to contribute more easily.
 *
 * This array can be modified at runtime with the LanguageGetMagic hook
 */
$magicWords = array(
#   ID                                 CASE  SYNONYMS
	'redirect'               => array( 0,    '#REDIRECT', '#ՎԵՐԱՀՂՈՒՄ' ),
	'notoc'                  => array( 0,    '__NOTOC__', '__ԱՌԱՆՑ_ԲՈՎ__' ),
	'nogallery'              => array( 0,    '__NOGALLERY__', '__ԱՌԱՆՑ_ՍՐԱՀԻ__' ),
	'forcetoc'               => array( 0,    '__FORCETOC__', '__ՍՏԻՊԵԼ_ԲՈՎ__'),
	'toc'                    => array( 0,    '__TOC__' , '__ԲՈՎ__' ),
	'noeditsection'          => array( 0,    '__NOEDITSECTION__', '__ԱՌԱՆՑ_ԲԱԺՆԻ_ԽՄԲԱԳՐՄԱՆ__' ),
	'start'                  => array( 0,    '__START__', '__ՍԿԻԶԲ__' ),
	'currentmonth'           => array( 1,    'CURRENTMONTH', 'ԸՆԹԱՑԻՔ_ԱՄԻՍԸ' ),
	'currentmonthname'       => array( 1,    'CURRENTMONTHNAME', 'ԸՆԹԱՑԻՔ_ԱՄՍՎԱ_ԱՆՈՒՆԸ' ),
	'currentmonthnamegen'    => array( 1,    'CURRENTMONTHNAMEGEN', 'ԸՆԹԱՑԻՔ_ԱՄՍՎԱ_ԱՆՈՒՆԸ_ՍԵՌ' ),
	'currentmonthabbrev'     => array( 1,    'CURRENTMONTHABBREV', 'ԸՆԹԱՑԻՔ_ԱՄՍՎԱ_ԱՆՎԱՆ_ՀԱՊԱՎՈՒՄԸ' ),
	'currentday'             => array( 1,    'CURRENTDAY', 'ԸՆԹԱՑԻՔ_ՕՐԸ' ),
	'currentday2'            => array( 1,    'CURRENTDAY2', 'ԸՆԹԱՑԻՔ_ՕՐԸ_2' ),
	'currentdayname'         => array( 1,    'CURRENTDAYNAME', 'ԸՆԹԱՑԻՔ_ՕՐՎԱ_ԱՆՈՒՆԸ' ),
	'currentyear'            => array( 1,    'CURRENTYEAR', 'ԸՆԹԱՑԻՔ_ՏԱՐԻՆ' ),
	'currenttime'            => array( 1,    'CURRENTTIME', 'ԸՆԹԱՑԻՔ_ԺԱՄԱՆԱԿԸ' ),
	'currenthour'            => array( 1,    'CURRENTHOUR', 'ԸՆԹԱՑԻՔ_ԺԱՄԸ' ),
	'localmonth'             => array( 1,    'LOCALMONTH', 'ՏԵՂԱԿԱՆ_ԱՄԻՍԸ' ),
	'localmonthname'         => array( 1,    'LOCALMONTHNAME', 'ՏԵՂԱԿԱՆ_ԱՄՍՎԱ_ԱՆՈՒՆԸ' ),
	'localmonthnamegen'      => array( 1,    'LOCALMONTHNAMEGEN', 'ՏԵՂԱԿԱՆ_ԱՄՍՎԱ_ԱՆՈՒՆԸ_ՍԵՌ' ),
	'localmonthabbrev'       => array( 1,    'LOCALMONTHABBREV', 'ՏԵՂԱԿԱՆ_ԱՄՍՎԱ_ԱՆՎԱՆ_ՀԱՊԱՎՈՒՄԸ' ),
	'localday'               => array( 1,    'LOCALDAY', 'ՏԵՂԱԿԱՆ_ՕՐԸ' ),
	'localday2'              => array( 1,    'LOCALDAY2', 'ՏԵՂԱԿԱՆ_ՕՐԸ_2' ),
	'localdayname'           => array( 1,    'LOCALDAYNAME', 'ՏԵՂԱԿԱՆ_ՕՐՎԱ_ԱՆՈՒՆԸ' ),
	'localyear'              => array( 1,    'LOCALYEAR', 'ՏԵՂԱԿԱՆ_ՏԱՐԻՆ' ),
	'localtime'              => array( 1,    'LOCALTIME','ՏԵՂԱԿԱՆ_ԺԱՄԱՆԱԿԸ' ),
	'localhour'              => array( 1,    'LOCALHOUR','ՏԵՂԱԿԱՆ_ԺԱՄԸ' ),
	'numberofpages'          => array( 1,    'NUMBEROFPAGES','ԷՋԵՐԻ_ՔԱՆԱԿԸ' ),
	'numberofarticles'       => array( 1,    'NUMBEROFARTICLES','ՀՈԴՎԱԾՆԵՐԻ_ՔԱՆԱԿԸ' ),
	'numberoffiles'          => array( 1,    'NUMBEROFFILES','ՖԱՅԼԵՐԻ_ՔԱՆԱԿԸ' ),
	'numberofusers'          => array( 1,    'NUMBEROFUSERS','ՄԱՍՆԱԿԻՑՆԵՐԻ_ՔԱՆԱԿԸ' ),
	'pagename'               => array( 1,    'PAGENAME','ԷՋԻ_ԱՆՈՒՆԸ' ),
	'pagenamee'              => array( 1,    'PAGENAMEE','ԷՋԻ_ԱՆՈՒՆԸ_2' ),
	'namespace'              => array( 1,    'NAMESPACE','ԱՆՎԱՆԱՏԱՐԱԾՔ' ),
	'namespacee'             => array( 1,    'NAMESPACEE','ԱՆՎԱՆԱՏԱՐԱԾՔ_2' ),
	'talkspace'              => array( 1,    'TALKSPACE','ՔՆՆԱՐԿՄԱՆ_ՏԱՐԱԾՔԸ' ),
	'talkspacee'             => array( 1,    'TALKSPACEE','ՔՆՆԱՐԿՄԱՆ_ՏԱՐԱԾՔԸ_2' ),
	'subjectspace'           => array( 1,    'SUBJECTSPACE', 'ARTICLESPACE', 'ՀՈԴՎԱԾՆԵՐԻ_ՏԱՐԱԾՔԸ' ),
	'subjectspacee'          => array( 1,    'SUBJECTSPACEE', 'ARTICLESPACEE', 'ՀՈԴՎԱԾՆԵՐԻ_ՏԱՐԱԾՔԸ_2' ),
	'fullpagename'           => array( 1,    'FULLPAGENAME', 'ARTICLESPACE', 'ԷՋԻ_ԼՐԻՎ_ԱՆՎԱՆՈՒՄԸ' ),
	'fullpagenamee'          => array( 1,    'FULLPAGENAMEE', 'ԷՋԻ_ԼՐԻՎ_ԱՆՎԱՆՈՒՄԸ_2' ),
	'subpagename'            => array( 1,    'SUBPAGENAME', 'ԵՆԹԱԷՋԻ_ԱՆՎԱՆՈՒՄԸ' ),
	'subpagenamee'           => array( 1,    'SUBPAGENAMEE', 'ԵՆԹԱԷՋԻ_ԱՆՎԱՆՈՒՄԸ_2' ),
	'basepagename'           => array( 1,    'BASEPAGENAME', 'ՀԻՄՆԱԿԱՆ_ԷՋԻ_ԱՆՎԱՆՈՒՄԸ' ),
	'basepagenamee'          => array( 1,    'BASEPAGENAMEE', 'ՀԻՄՆԱԿԱՆ_ԷՋԻ_ԱՆՎԱՆՈՒՄԸ_2' ),
	'talkpagename'           => array( 1,    'TALKPAGENAME', 'ՔՆՆԱՐԿՄԱՆ_ԷՋԻ_ԱՆՎԱՆՈՒՄԸ' ),
	'talkpagenamee'          => array( 1,    'TALKPAGENAMEE', 'ՔՆՆԱՐԿՄԱՆ_ԷՋԻ_ԱՆՎԱՆՈՒՄԸ_2' ),
	'subjectpagename'        => array( 1,    'SUBJECTPAGENAME', 'ARTICLEPAGENAME', 'ՀՈԴՎԱԾԻ_ԷՋԻ_ԱՆՎԱՆՈՒՄԸ' ),
	'subjectpagenamee'       => array( 1,    'SUBJECTPAGENAMEE', 'ARTICLEPAGENAMEE', 'ՀՈԴՎԱԾԻ_ԷՋԻ_ԱՆՎԱՆՈՒՄԸ_2' ),
	'msg'                    => array( 0,    'MSG:', 'ՀՈՂՈՐԴ՝' ),
	'subst'                  => array( 0,    'SUBST:' ),
	'msgnw'                  => array( 0,    'MSGNW:', 'ՀՈՂՈՐԴ_ԱՌԱՆՑ_ՎԻՔԻԻ՝' ),
	'end'                    => array( 0,    '__END__','__ԱՎԱՐՏ__' ),
	'img_thumbnail'          => array( 1,    'thumbnail', 'thumb', 'մինի' ),
	'img_manualthumb'        => array( 1,    'thumbnail=$1', 'thumb=$1', 'մինի=$1'),
	'img_right'              => array( 1,    'right', 'աջից' ),
	'img_left'               => array( 1,    'left', 'ձախից' ),
	'img_none'               => array( 1,    'none', 'առանց' ),
	'img_width'              => array( 1,    '$1px', '$1փքս' ),
	'img_center'             => array( 1,    'center', 'centre', 'կենտրոն' ),
	'img_framed'             => array( 1,    'framed', 'enframed', 'frame', 'շրջափակել' ),
	'img_page'               => array( 1,    'page=$1', 'page $1', 'էջը=$1', 'էջ $1' ),
	'int'                    => array( 0,    'INT:' , 'ՆԵՐՔ՝' ),
	'sitename'               => array( 1,    'SITENAME', 'ԿԱՅՔԻ_ԱՆՈՒՆԸ' ),
	'ns'                     => array( 0,    'NS:', 'ԱՏ՝' ),
	'localurl'               => array( 0,    'LOCALURL:', 'ՏԵՂԱԿԱՆ_ՀԱՍՑԵՆ՝' ),
	'localurle'              => array( 0,    'LOCALURLE:', 'ՏԵՂԱԿԱՆ_ՀԱՍՑԵՆ_2՝' ),
	'server'                 => array( 0,    'SERVER', 'ՍԵՐՎԵՐԸ' ),
	'servername'             => array( 0,    'SERVERNAME', 'ՍԵՐՎԵՐԻ_ԱՆՈՒՆԸ' ),
	'scriptpath'             => array( 0,    'SCRIPTPATH', 'ՍՔՐԻՊՏԻ_ՃԱՆԱՊԱՐՀԸ' ),
	'grammar'                => array( 0,    'GRAMMAR:' , 'ՀՈԼՈՎ՛' ),
	'notitleconvert'         => array( 0,    '__NOTITLECONVERT__', '__NOTC__', '__ԱՌԱՆՑ_ՎԵՐՆԱԳՐԻ_ՓՈՓՈԽՄԱՆ__' ),
	'nocontentconvert'       => array( 0,    '__NOCONTENTCONVERT__', '__NOCC__', '__ԱՌԱՆՑ_ՊԱՐՈՒՆԱԿՈՒԹՅԱՆ_ՓՈՓՈԽՄԱՆ__' ),
	'currentweek'            => array( 1,    'CURRENTWEEK', 'ԸՆԹԱՑԻՔ_ՇԱԲԱԹԸ' ),
	'currentdow'             => array( 1,    'CURRENTDOW', 'ԸՆԹԱՑԻՔ_ՇԱԲԱԹՎԱ_ՕՐԸ' ),
	'localweek'              => array( 1,    'LOCALWEEK', 'ՏԵՂԱԿԱՆ_ՇԱԲԱԹՎԸ' ),
	'localdow'               => array( 1,    'LOCALDOW', 'ՏԵՂԱԿԱՆ_ՇԱԲԱԹՎԱ_ՕՐԸ' ),
	'revisionid'             => array( 1,    'REVISIONID', 'ՏԱՐԲԵՐԱԿԻ_ՀԱՄԱՐԸ' ),
	'revisionday'            => array( 1,    'REVISIONDAY', 'ՏԱՐԲԵՐԱԿԻ_ՕՐԸ' ),
	'revisionday2'           => array( 1,    'REVISIONDAY2', 'ՏԱՐԲԵՐԱԿԻ_ՕՐԸ_2' ),
	'revisionmonth'          => array( 1,    'REVISIONMONTH', 'ՏԱՐԲԵՐԱԿԻ_ԱՄԻՍԸ' ),
	'revisionyear'           => array( 1,    'REVISIONYEAR', 'ՏԱՐԲԵՐԱԿԻ_ՏԱՐԻՆ' ),
	'revisiontimestamp'      => array( 1,    'REVISIONTIMESTAMP' ),
	'plural'                 => array( 0,    'PLURAL:', 'ՀՈԳՆԱԿԻ՝' ),
	'fullurl'                => array( 0,    'FULLURL:', 'ԼՐԻՎ_ՀԱՍՑԵՆ՝' ),
	'fullurle'               => array( 0,    'FULLURLE:', 'ԼՐԻՎ_ՀԱՍՑԵՆ_2՝' ),
	'lcfirst'                => array( 0,    'LCFIRST:', 'ՓՈՔՐԱՏԱՌ_ՍԿԶԲՆԱՏԱՌ՝' ),
	'ucfirst'                => array( 0,    'UCFIRST:', 'ՄԵԾԱՏԱՌ_ՍԿԶԲՆԱՏԱՌ՝' ),
	'lc'                     => array( 0,    'LC:', 'ՓՈՔՐԱՏԱՌ՝' ),
	'uc'                     => array( 0,    'UC:', 'ՄԵԾԱՏԱՌ՝' ),
	'raw'                    => array( 0,    'RAW:' ),
	'displaytitle'           => array( 1,    'DISPLAYTITLE', 'ՑՈՒՅՑ_ՏԱԼ_ՎԵՐՆԱԳԻՐԸ' ),
	'rawsuffix'              => array( 1,    'R', 'Չ' ),
	'newsectionlink'         => array( 1,    '__NEWSECTIONLINK__', '__ՀՂՈՒՄ_ՆՈՐ_ԲԱԺՆԻ_ՎՐԱ__' ),
	'currentversion'         => array( 1,    'CURRENTVERSION', 'ԸՆԹԱՑԻՔ_ՏԱՐԲԵՐԱԿԸ' ),
	'urlencode'              => array( 0,    'URLENCODE:', 'ՄՇԱԿՎԱԾ_ՀԱՍՑԵ՛' ),
	'anchorencode'           => array( 0,    'ANCHORENCODE' ),
	'currenttimestamp'       => array( 1,    'CURRENTTIMESTAMP', 'ԸՆԹԱՑԻՔ_ԺԱՄԱՆԱԿԻ_ԴՐՈՇՄ' ),
	'localtimestamp'         => array( 1,    'LOCALTIMESTAMP', 'ՏԵՂԱԿԱՆ_ԺԱՄԱՆԱԿԻ_ԴՐՈՇՄ' ),
	'directionmark'          => array( 1,    'DIRECTIONMARK', 'DIRMARK', 'ՆԱՄԱԿԻ_ՈՒՂՂՈՒԹՅՈՒՆԸ' ),
	'language'               => array( 0,    '#LANGUAGE:', '#ԼԵԶՈՒ՝' ),
	'contentlanguage'        => array( 1,    'CONTENTLANGUAGE', 'CONTENTLANG', 'ՊԱՐՈՒՆԱԿՈՒԹՅԱՆ_ԼԵԶՈՒՆ' ),
	'pagesinnamespace'       => array( 1,    'PAGESINNAMESPACE:', 'PAGESINNS:', 'ԷՋԵՐ_ԱՆՎԱՆԱՏԱՐԱԾՔՈՒՄ՝' ),
	'numberofadmins'         => array( 1,    'NUMBEROFADMINS', 'ԱԴՄԻՆՆԵՐԻ_ՔԱՆԱԿԸ' ),
	'formatnum'              => array( 0,    'FORMATNUM', 'ՁԵՎԵԼ_ԹԻՎԸ' ),
	'padleft'                => array( 0,    'PADLEFT', 'ԼՐԱՑՆԵԼ_ՁԱԽԻՑ' ),
	'padright'               => array( 0,    'PADRIGHT', 'ԼՐԱՑՆԵԼ_ԱՋԻՑ' ),
	'special'                => array( 0,    'special', 'սպասարկող' ),
	'defaultsort'			 => array( 1,	 'DEFAULTSORT:', 'ԼՌՈՒԹՅԱՄԲ_ԴԱՍԱՎՈՐՈՒՄ՝' ),
);

/**
 * Alternate names of special pages. All names are case-insensitive. The first
 * listed alias will be used as the default. Aliases from the fallback 
 * localisation (usually English) will be included by default. 
 * 
 * This array may be altered at runtime using the LangugeGetSpecialPageAliases 
 * hook. 
 */
$specialPageAliases = array(
	'DoubleRedirects'           => array( 'Կրկնակիվերահղումները' ),
	'BrokenRedirects'           => array( 'Կոտրվածվերահղումները' ),
	'Disambiguations'           => array( 'Երկիմաստէջերը' ),
	'Userlogin'                 => array( 'Մասնակցիմուտք' ),
	'Userlogout'                => array( 'Մասնակցիելք' ),
	'Preferences'               => array( 'Նախընտրությունները' ),
	'Watchlist'                 => array( 'Հսկողությանցանկը' ),
	'Recentchanges'             => array( 'Վերջինփոփոխությունները' ),
	'Upload'                    => array( 'Բեռնել' ),
	'Imagelist'                 => array( 'Պատկերներիցանկը' ),
	'Newimages'                 => array( 'Նորպատկերներ' ),
	'Listusers'                 => array( 'Մասնակիցներիցանկը' ),
	'Statistics'                => array( 'Վիճակագրություն' ),
	'Randompage'                => array( 'Պատահականէջ' ),
	'Lonelypages'               => array( 'Միայնակէջերը' ),
	'Uncategorizedpages'        => array( 'Չդասակարգվածէջերը' ),
	'Uncategorizedcategories'   => array( 'Չդասակարգվածկատեգորիաները' ),
	'Uncategorizedimages'       => array( 'Չդասակարգվածպատկերները' ),
	'Unusedcategories'          => array( 'Չօգտագործվածկատեգորիաները' ),
	'Unusedimages'              => array( 'Չօգտագործվածպատկերները' ),
	'Wantedpages'               => array( 'Անհրաժեշտէջերը' ),
	'Wantedcategories'          => array( 'Անհրաժեշտկատեգորիաները' ),
	'Mostlinked'                => array( 'Ամենաշատհղումներով' ),
	'Mostlinkedcategories'      => array( 'Շատհղվողկատեգորիաները' ),
	'Mostcategories'            => array( 'Ամենաշատկատեգորիաներով' ),
	'Mostimages'                => array( 'Ամենաշատօգտագործվողնկարները' ),
	'Mostrevisions'             => array( 'Ամենաշատփոփոխվող' ),
	'Shortpages'                => array( 'Կարճէջերը' ),
	'Longpages'                 => array( 'Երկարէջերը' ),
	'Newpages'                  => array( 'Նորէջերը' ),
	'Ancientpages'              => array( 'Ամենահինէջերը' ),
	'Deadendpages'              => array( 'Հղումչպարունակողէջերը' ),
	'Allpages'                  => array( 'Բոլորէջերը' ),
	'Prefixindex'               => array( 'Որոնումնախածանցով' ) ,
	'Ipblocklist'               => array( 'ԱրգելափակվածIPները' ),
	'Specialpages'              => array( 'Սպասարկողէջերը' ),
	'Contributions'             => array( 'Ներդրումները' ),
	'Emailuser'                 => array( 'Գրելնամակ' ),
	'Whatlinkshere'             => array( 'Այստեղհղվողէջերը' ),
	'Recentchangeslinked'       => array( 'Կապվածէջերիփոփոխությունները' ),
	'Movepage'                  => array( 'Տեղափոխելէջը' ),
	'Blockme'                   => array( 'Արգելափակել' ),
	'Booksources'               => array( 'Գրքայինաղբյուրները' ),
	'Categories'                => array( 'Կատեգորիաները' ),
	'Export'                    => array( 'Արտահանելէջերը' ),
	'Version'                   => array( 'Տարբերակ' ),
	'Allmessages'               => array( 'Բոլորուղերձները' ),
	'Log'                       => array( 'Տեղեկամատյան' ),
	'Blockip'                   => array( 'Արգելափակելip' ),
	'Undelete'                  => array( 'Վերականգնել' ),
	'Import'                    => array( 'Ներմուծել' ),
	'Lockdb'                    => array( 'Կողպելտհ' ),
	'Unlockdb'                  => array( 'Բացանելտհ' ),
	'Userrights'                => array( 'Մասնակցիիրավունքները' ),
	'MIMEsearch'                => array( 'MIMEՈրոնում' ),
	'Unwatchedpages'            => array( 'Չհսկվողէջերը' ),
	'Listredirects'             => array( 'Ցույցտալվերահղումները' ),
	'Listinterwikis'            => array( 'Ցույցտալինտերվիքիները' ),
	'Revisiondelete'            => array( 'Տարբերակիհեռացում' ),
	'Unusedtemplates'           => array( 'Չօգտագործվողկաղապարները' ),
	'Randomredirect'            => array( 'Պատահականվերահղում' ),
	'Mypage'                    => array( 'Իմէջը' ),
	'Mytalk'                    => array( 'Իմքննարկումները' ),
	'Mycontributions'           => array( 'Իմներդրումները' ),
	'Listadmins'                => array( 'Ադմիններիցանկը' ),
	'Popularpages'              => array( 'Հանրաճանաչէջերը' ),
	'Search'                    => array( 'Որոնել' ),
	'Resetpass'                 => array( 'Նորգաղտնաբառ' ),
);

/**
 * Regular expression matching the "link trail", e.g. "ed" in [[Toast]]ed, as 
 * the first group, and the remainder of the string as the second group.
 */
$linkTrail = '/^([a-zաբգդեզէըթժիլխծկհձղճմյնշոչպջռսվտրցւփքօֆև«»]+)(.*)$/sDu';

#-------------------------------------------------------------------
# Default messages
#-------------------------------------------------------------------
# Allowed characters in keys are: A-Z, a-z, 0-9, underscore (_) and
# hyphen (-). If you need more characters, you may be able to change
# the regex in MagicWord::initRegex

$messages = array(
'skinpreview' => '(Դիտել տեսքը)',

# Dates
'sunday'        => 'Կիրակի',
'monday'        => 'Երկուշաբթի',
'tuesday'       => 'Երեքշաբթի',
'wednesday'     => 'Չորեքշաբթի',
'thursday'      => 'Հինգշաբթի',
'friday'        => 'Ուրբաթ',
'saturday'      => 'Շաբաթ',
'sun'           => 'Կիր',
'mon'           => 'Երկ',
'tue'           => 'Երեք',
'wed'           => 'Չոր',
'thu'           => 'Հինգ',
'fri'           => 'Ուրբ',
'sat'           => 'Շաբ',
'january'       => 'Հունվար',
'february'      => 'Փետրվար',
'march'         => 'Մարտ',
'april'         => 'Ապրիլ',
'may_long'      => 'Մայիս',
'june'          => 'Հունիս',
'july'          => 'Հուլիս',
'august'        => 'Օգոստոս',
'september'     => 'Սեպտեմբեր',
'october'       => 'Հոկտեմբեր',
'november'      => 'Նոյեմբեր',
'december'      => 'Դեկտեմբեր',
'january-gen'   => 'Հունվարի',
'february-gen'  => 'Փետրվարի',
'march-gen'     => 'Մարտի',
'april-gen'     => 'Ապրիլի',
'may-gen'       => 'Մայիսի',
'june-gen'      => 'Հունիսի',
'july-gen'      => 'Հուլիսի',
'august-gen'    => 'Օգոստոսի',
'september-gen' => 'Սեպտեմբերի',
'october-gen'   => 'Հոկտեմբերի',
'november-gen'  => 'Նոյեմբերի',
'december-gen'  => 'Դեկտեմբերի',
'jan'           => 'հունվ',
'feb'           => 'փետ',
'mar'           => 'մարտ',
'apr'           => 'ապր',
'may'           => 'մայիս',
'jun'           => 'հուն',
'jul'           => 'հուլ',
'aug'           => 'օգոս',
'sep'           => 'սեպ',
'oct'           => 'հոկ',
'nov'           => 'նոյ',
'dec'           => 'դեկ',

# Bits of text used by many pages
'categories'            => 'Հոդվածների կատեգորիաներ',
'pagecategories'        => '{{PLURAL:$1|Կատեգորիա|Կատեգորիաներ}}',
'category_header'       => '"$1" կատեգորիայի հոդվածները',
'subcategories'         => 'Ենթակատեգորիաներ',
'category-media-header' => '"$1" կատեգորիայի մեդիան:',

'linkprefix'        => '/^(.*?)([a-zA-Z\x80-\xff]+)$/sD',
'mainpagetext'      => "<big>'''MediaWiki-ն բարեհաջող ձայնագրվել է։'''</big>",
'mainpagedocfooter' => "Տեսեք [http://meta.wikimedia.org/wiki/Help:Contents User's Guide]-ը՝ վիքի ծրագրային ապահովման մասին տեղեկություն ստանալու համար։

== Որոշ ռեսուրսներ ==

* [http://www.mediawiki.org/wiki/Help:Configuration_settings Configuration settings list]
* [http://www.mediawiki.org/wiki/Help:FAQ MediaWiki FAQ]
* [http://mail.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",

'about'          => 'Նկարագրությունը',
'article'        => 'Հոդված',
'newwindow'      => '(բացվելու է նոր պատուհանի մեջ)',
'cancel'         => 'Բեկանել',
'qbfind'         => 'Գտնել',
'qbbrowse'       => 'Թերթել',
'qbedit'         => 'Խմբագրել',
'qbpageoptions'  => 'Այս էջը',
'qbpageinfo'     => 'Տվյալներ հոդվածի մասին',
'qbmyoptions'    => 'Իմ էջերը',
'qbspecialpages' => 'Սպասարկող էջերը',
'moredotdotdot'  => 'Ավելին...',
'mypage'         => 'Իմ էջը',
'mytalk'         => 'Իմ քննարկումները',
'anontalk'       => 'Կարծիք հայտնեք այս IP-ի մասին։',
'navigation'     => 'Շրջել կայքում',

# Metadata in edit box
'metadata_help' => 'Մեթատվյալներ (բացատրության համար տես՝ [[{{ns:project}}:Մեթատվյալներ]])։',

'errorpagetitle'    => 'Սխալ',
'returnto'          => 'Վերադարնալ $1:',
'tagline'           => '{{grammar:genitive|{{SITENAME}}}} հոդված։',
'help'              => 'Օգնություն',
'search'            => 'Որոնել',
'searchbutton'      => 'Որոնել',
'go'                => 'Անցնել',
'searcharticle'     => 'Անցնել',
'history'           => 'Էջի պատմությունը',
'history_short'     => 'Պատմությունը',
'updatedmarker'     => 'Թարմացվել է իմ վերջին հաճախումից',
'info_short'        => 'Տեղեկություն',
'printableversion'  => 'Տպելու տարբերակ',
'permalink'         => 'Մշտական հղում',
'print'             => 'Տպել',
'edit'              => 'Խմբագրել',
'editthispage'      => 'Խմբագրել այս էջը',
'delete'            => 'Ջնջել',
'deletethispage'    => 'Ջնջել այս էջը',
'undelete_short'    => 'Վերականգնել {{PLURAL:$1|մեկ խմբագրում|$1 խմբագրումներ}}',
'protect'           => 'Պաշտպանել',
'protectthispage'   => 'Պաշտպանել այս էջը',
'unprotect'         => 'Հանել պաշտպանությունից',
'unprotectthispage' => 'Հանել այս էջը պաշտպանությունից',
'newpage'           => 'Նոր էջ',
'talkpage'          => 'Քննարկել այս էջը',
'specialpage'       => 'Սպասարկող էջ',
'personaltools'     => 'Անձնական գործիքներ',
'postcomment'       => 'Մեկնաբանել',
'articlepage'       => 'Տեսնել բովանդակության էջը',
'talk'              => 'Քննարկում',
'views'             => 'Դիտումները',
'toolbox'           => 'Գործիքներ',
'userpage'          => 'Դիտել մասնակցի էջը',
'projectpage'       => 'Դիտել նախագծի էջը',
'imagepage'         => 'Դիտել պատկերի էջը',
'mediawikipage'     => 'Դիտել հաղորդագրության էջը',
'templatepage'      => 'Դիտել կաղապարի էջը',
'viewhelppage'      => 'Դիտել օգնության էջը',
'categorypage'      => 'Դիտել կատեգորիաների էջը',
'viewtalkpage'      => 'Դիտել քննարկումը',
'otherlanguages'    => 'Այլ լեզուներով',
'redirectedfrom'    => '(Վերահղված է $1-ից)',
'redirectpagesub'   => 'Վերահղող էջը',
'lastmodifiedat'    => 'Այս էջը վերջին անգամ փոփոխվել է  $2, $1։', # $1 date, $2 time
'viewcount'         => 'Այս էջին դիմել են {{plural:$1|մեկ անգամ|$1 անգամ}}։',
'protectedpage'     => 'Պաշտպանված էջ',
'jumpto'            => 'Անցնել՝',
'jumptosearch'      => 'որոնում',

# All link text and link target definitions of links into project namespace that get used by other message strings, with the exception of user group pages (see grouppage) and the disambiguation template definition (see disambiguations).
'aboutsite'         => '{{grammar:genitive|{{SITENAME}}}} մասին',
'aboutpage'         => '{{ns:project}}:Նկարագրություն',
'bugreports'        => 'Սխալների զգուշացում',
'bugreportspage'    => '{{ns:project}}Սխալների զգուշացում',
'copyright'         => 'Կայքի բովանդակությունը գտնվում է $1 լիցենզիայի տակ։',
'copyrightpagename' => '{{SITENAME}} հեղինակային իրավունքները',
'currentevents'     => 'Ընթացիկ իրադարձություններ',
'currentevents-url' => 'Ընթացիկ իրադարձություններ',
'disclaimers'       => 'Ազատում պատասխանատվությունից',
'edithelp'          => 'Խմբագրման ուղեցույց',
'edithelppage'      => '{{ns:project}}:Խմբագրական խորհուրդներ',
'faq'               => 'ՀՏՀ',
'faqpage'           => '{{ns:project}}:ՀՏՀ',
'helppage'          => '{{ns:project}}:Օգնություն',
'mainpage'          => 'Գլխավոր Էջ',
'portal'            => 'Խորհրդարան',
'portal-url'        => '{{ns:project}}:Խորհրդարան',
'sitesupport'       => 'Դրամական նվիրատվություն',
'sitesupport-url'   => '{{ns:project}}:Դրամական նվիրատվություն',

'badaccess'        => 'Թուլատրման սխալ',
'badaccess-group0' => 'Ձեզ չի թույլատրվում կատարել տվյալ գործողությունը:',
'badaccess-group1' => 'Ձեր պահանջած գործողությունը սահմանափակ է $1 խմբի օգտագործողների համար:',
'badaccess-group2' => 'Ձեր պահանջած գործողությունը սահմանափակ է $1 խմբերից մեկի օգտագործողների համար:',
'badaccess-groups' => 'Ձեր պահանջած գործողությունը սահմանափակ է $1 խմբերից մեկի օգտագործողների համար:',

'newmessageslink' => 'նոր ուղերձներ',
'editsection'     => 'խմբագրել',
'showtoc'         => 'ցույց տալ',
'hidetoc'         => 'Ցույց տալ',
'thisisdeleted'   => 'Դիտե՞լ, թե՞ վերականգնել $1։',

# Short words for each namespace, by default used in the 'article' tab in monobook
'nstab-main'      => 'Հոդված',
'nstab-user'      => 'Մասնակցի անձնական էջ',
'nstab-media'     => 'Մեդիա էջ',
'nstab-special'   => 'Սպասարկող էջ',
'nstab-project'   => 'Նախագծի էջ',
'nstab-image'     => 'Ֆայլ',
'nstab-mediawiki' => 'Ուղերձ',
'nstab-template'  => 'Կաղապար',
'nstab-help'      => 'Օգնության էջ',
'nstab-category'  => 'Կատեգորիա',

# Main script and global functions
'nosuchaction'      => 'Նման գործողություն չկա։',
'nosuchspecialpage' => 'Նման սպասարկող էջ չկա։',

# General errors
'error'           => 'Սխալ',
'databaseerror'   => 'Տվյալների հենքի սխալ',
'cachederror'     => 'Տվյալ նյութը ձեր հարցումին համապատասխանող էջի հին, թաքցված օրինակներից  է, և  կարող է  տարբերվել ներկա էջից։',
'internalerror'   => 'Ներքին սխալ',
'filerenameerror' => 'Չկարողացա  "$1" ֆայլի անունը փոխել "$2"-ի։',
'filenotfound'    => 'Չկարողացա գտնել "$1" ֆայլը։',
'badarticleerror' => 'Տվյալ  գործողությունը չի կարող կատարվել այս էջում։',
'cannotdelete'    => 'Չեմ կարող ջնջել ընտրված էջը կամ պատկերը։ (Հնարավոր է, որ այն արդեն ջնջվել է ուրիշ մեկի կողմից։)',
'badtitle'        => 'Վերնագիրը սխալ է։',
'badtitletext'    => 'Հարցված էջի անվանումը անկատար է, դատարկ կամ սխալ է կապակցված հայերեն լեզվով գրված կամ հայկական վիքիում եղած վերնագրի հետ։',

# Login and logout pages
'logouttitle'                => 'Մասնակցի ելք',
'logouttext'                 => '<strong>Դուք դուրս եք եկել համակարգից։</strong><br />
Դուք կարող եք շարունակել օգտագործել {{SITENAME}} կայքը անանուն, կամ դուք կարող եք կրկին մուտք գործել համակարգ,
որպես նույն մասնակից, կամ, որպես մեկ այլ մասնակից։ Նկատի ունեցեք, որ որոշ էջեր դեռ ցույց կտան, որ դուք համակարգի մեջ եք, մինչև որ չջնջեք ձեր բրաուզերի քէշը։',
'welcomecreation'            => '== Բարի գալուստ, $1 ==

Ձեր հաշիվը ստեղծված է։ Չմոռանաք փոփոխել ձեր [[{{ns:special}}:Նախընտրությունները|նախընտրությունները]]։',
'loginpagetitle'             => 'Մասնակցի գրանցում',
'yourname'                   => 'Ձեր անունը(այն անունը, որով ուզում եք գրանցվել որպես մասնակից)',
'yourpassword'               => 'Ձեր գաղտնաբառը',
'yourpasswordagain'          => 'Կրկնեք գաղտնաբառը',
'remembermypassword'         => 'Հիշել իմ մուտքագրված տվյալները',
'loginproblem'               => '<b>Ձեր գրանցման ժամանակ անորոշ խնդիր է ծագել։</b><br /> Փորձեք կրկին։',
'alreadyloggedin'            => '<font color=red><b>Մասնակից  $1, դուք արդեն գրանցված եք համակարգի մեջ։</b></font><br />',
'login'                      => 'Գրանցվել',
'loginprompt'                => 'Ձեր քուքիները պետք է միացված լինեն՝ {{SITENAME}} մուտք գործելու համար։',
'userlogin'                  => 'Ստեղծել հաշիվ կամ մուտք գործել համակարգ',
'logout'                     => 'Դուրս գալ',
'userlogout'                 => 'Դուրս գալ',
'notloggedin'                => 'Դուք մուտք չեք գործել համակարգ',
'nologin'                    => 'Դեռևս չե՞ք գրանցվել։ $1։',
'nologinlink'                => 'Ստեղծել հաշիվ',
'createaccount'              => 'Ստեղծել նոր մասնակցային հաշիվ',
'gotaccount'                 => 'Դուք արդեն գրանցվա՞ծ եք։ $1։',
'gotaccountlink'             => 'Մուտք գործել',
'createaccountmail'          => 'էմակով',
'badretype'                  => 'Ձեր գրած նշանաբառերը չեն համընկնում։',
'userexists'                 => 'Այս անունը արդեն զբաղված է։ Խնդրում ենք ընտրել մեկ ուրիշը։',
'youremail'                  => 'Ձեր էլ-փոստի հասցեն*',
'username'                   => 'Գրանցման անունը՝',
'uid'                        => 'Մասնակցի իդենտիֆիկատորը՝',
'yourrealname'               => 'Ձեր իրական անունը*',
'yourlanguage'               => 'Ինտերֆեյսի լեզուն',
'yourvariant'                => 'Լեզվական տարբերակ',
'yournick'                   => 'Ձեր կեղծանունը (ստորագրությունների համար)',
'badsig'                     => 'Սխալ "raw" ստորագրություն, ստուգեք HTML թեգերը:',
'email'                      => 'Էլ-փոստ',
'loginerror'                 => 'Գրանցման ժամանակ սխալ է եղել',
'loginsuccesstitle'          => 'Բարեհաջող մուտք',
'loginsuccess'               => "'''Դուք մուտք գործեցիք {{SITENAME}}, որպես \"\$1\"։'''",
'wrongpassword'              => 'Ձեր գրած գաղտնաբառը սխալ է։ Խնդրում ենք կրկին փորձել։',
'wrongpasswordempty'         => 'Ձեր գրած գաղտնաբառը դատարկ է։ Խնդրում ենք կրկին փորձել։',
'noemail'                    => '"$1" մասնակցի անունով գրանցված  է-մակ հասցե չկա։',
'blocked-mailpassword'       => 'Ձեր IP-ն արգելափակված է խմբագրման համար, հետևաբար նաև արգելված է նշանաբառ վերականգնող ֆունկցիան կատարելը:',
'acct_creation_throttle_hit' => 'Ներեցեք, դուք արդեն ստեղծել եք $1 մասնակցային հաշիվ։ Չեք կարող ավելին ստեղծել։',
'accountcreated'             => 'Հաշիվը ստեղծված է',
'accountcreatedtext'         => 'Օգտագործողի հաշիվը $1-ի համար, ստեղծված է:',

# Edit page toolbar
'bold_sample'     => 'Թավատառ տեքստ',
'bold_tip'        => 'Թավատառ տեքստ',
'italic_sample'   => 'Շեղատառ տեքստ',
'italic_tip'      => 'Շեղատառ տեքստ',
'link_sample'     => 'Կապ տալ վերնագրին',
'link_tip'        => 'Ներքին կապ',
'extlink_sample'  => 'http://www.example.com հղում վերնագիր',
'extlink_tip'     => 'Արտաքին հղում (հիշեք http:// նախածանցը)',
'headline_sample' => 'Ենթագլուխ',
'headline_tip'    => 'Ենթագլուխ',
'math_sample'     => 'Գրեք բանաձևը այստեղ',
'math_tip'        => 'Մաթեմատիկական բանաձև (LaTeX)',
'nowiki_sample'   => 'Գրեք առանց ձևումի տեքստը այստեղ',
'nowiki_tip'      => 'Անտեսել Վիքի ձևումը',
'image_tip'       => 'Ներառված պատկեր',
'media_tip'       => 'Հղում Մեդիա Ֆայլին',
'sig_tip'         => 'Ձեր ստորագրությունը ամսաթվով',
'hr_tip'          => 'Հորիզոնական գիծ (միայն անհրաժեշտության դեպքում)',

# Edit pages
'summary'               => 'Ամփոփումը՝',
'subject'               => 'Վերնագիր',
'minoredit'             => 'Սա չնչին ուղղում է',
'watchthis'             => 'Հսկել այս էջը',
'savearticle'           => 'Հիշել էջը',
'showpreview'           => 'Նախադիտել',
'showdiff'              => 'Ցույց տալ փոփոխությունները',
'anoneditwarning'       => 'Դուք գրանցված չեք։ Ձեր IP հասցեն կգրանցվի այս էջի խմբագրումների պատմության մեջ։',
'blockedtitle'          => 'Մասնակցի մուտքը արգելափակված է։',
'blockedtext'           => 'Որպես մասնակից ձեր անունը կամ  IP հասցեն արգելափակվել է  $1-ի կողմից։
Պատճառը սա է` <br />\'\'$2\'\'<p> Դուք կարող եք կապվել  $1-ի  կամ մեկ ուրիշ ադմինիստրատորի հետ, տես`[[{{ns:project}}:Administrators|Ադմինիստրատորներ]] ձեր մուտքի արգելափակման հարցը քննարկելու համար։

Դուք չեք կարող օգտվել` "է-մակ ուղարկել այս մասնակցին" հնարավորությունից, քանի դեռ ինքներդ գործող է-մակ հասցե չէք գրանցել ձեր [[{{ns:special}}:Preferences|Մասնակցի նախընտրությունները]] էջում։

Ձեր IP հասցեն սա է` $3, իսկ արգելափակման իդենտիֆիկատորը՝ $5։ Խնդրում ենք ձեր բոլոր հարցումներում  նշել  այս հասցեն։',
'blockedoriginalsource' => "'''$1'''-ի հիմքը ցույց է տրված ներքևում:",
'blockededitsource'     => "'''ձեր խմբագրումներ'''-ից '''$1'''-ի տեքստը հետևյալն է:",
'whitelistacctitle'     => 'Ձեզ չի թույլատրվում անձնական հաշիվ ստեղծել',
'accmailtitle'          => 'Նշանաբառն ուղարկված է։',
'accmailtext'           => "'$1'-ի նշանաբառը ուղարկվել է $2-ին:",
'newarticle'            => '(Նոր)',
'anontalkpagetext'      => "----''Տվյալ  քննարկման էջը պատկանում է դեռևս գրանցման հաշիվ չունեցող կամ գրանցումից չօգտվող  մասնակցի։Այդ իսկ պատճառով օգտագործվում է  մասնկացի թվային հասցեն [[IP address]] նրան/ներան  ճանաչելու համար։ Նման IP հասցեից կարող են օգտվել մի քանի մասնակիցներ։ Եթե դուք անանուն մասնակից եք, բայց կարծում եք, որ ուրիշներին վերաբերող դիտողությունները  արվում են ձեր հասցեով, ապա խնդրում ենք պարզապես գրանցվել [[{{ns:special}}:Userlogin|այստեղ]], որպեսզի հետագայում ձեզ չշփոթեն  այլ մասնակիցների հետ և ձեզ չվերագրեն նրանց արած գործողությունները։''",
'noarticletext'         => '(Ներկայումս այս էջում որևէ տեքստ չկա)',
'yourtext'              => 'Ձեր տեքստը',
'yourdiff'              => 'Տարբերությունները',
'copyrightwarning'      => 'Խնդրում ենք նկատի ունենալ, որ {{SITENAME}} արված բոլոր ներդրումները հանդես են գալու "$2" լիցենզիայի տակ (տես` $1 մանրամասնության համար): Եթե դուք չեք ցանկանում, որ ձեր նյութը խմբագրվի և անվճար բաժանվի, ապա մի՛ ներմուծեք այն այստեղ:<br /> Դուք նաև խոստանում եք մեզ, որ գրել եք նյութը ինքներդ կամ վերցրել եք այն անվճար աղբյուրներից: <strong>Չ՛ՀՐԱՏԱՐԱԿԵՔ ԱՐՏՈՆԱԳՐՎԱԾ ԱՇԽԱՏԱՆՔՆԵՐ ԱՌԱՆՑ ԹՈՒՅԼԱՏՐՈՒԹՅԱՆ:</strong>',
'copyrightwarning2'     => 'Խնդրում ենք նկատի ունենալ, որ {{SITENAME}} արված բոլոր ներդրումները կարող են խմբագրվել, վերամշակվել կամ ջնջվել ուրիշ օգտագործողների կողմից: Եթե դուք չեք ցանկանում, որ ձեր նյութը խմբագրվի և անվճար բաժանվի, ապա մի՛ ներմուծեք այն այստեղ:<br /> Դուք նաև խոստանում եք մեզ, որ գրել եք նյութը ինքներդ կամ վերցրել եք այն անվճար աղբյուրներից (տես` $1 մանրամասնությունների համար): <strong>Չ՛ՀՐԱՏԱՐԱԿԵՔ ԱՐՏՈՆԱԳՐՎԱԾ ԱՇԽԱՏԱՆՔՆԵՐ ԱՌԱՆՑ ԹՈՒՅԼԱՏՐՈՒԹՅԱՆ:</strong>',
'protectedpagewarning'  => '<strong>ԶԳՈՒՇԱՑՈՒՄ. Այս էջը կարող են խմբագրել միայն ՍիսՕպ իրավունքներ ունեցող անձիք: Ճշտեք, թե արդյո՞ք դուք գործում եք [[{{ns:project}}:պաշտպանված_էջերի_մասին_օրենք|պաշտպանված էջերի մասին օրենքի]] շրջանակներում:</strong>',

# Account creation failure
'cantcreateaccounttitle' => 'Հաշվի բացումը չի իրականացել',
'cantcreateaccounttext'  => 'Այս`(<b>$1</b>) IP հասցեից հաշվի բացումն արգելված է: Գործողությունը կիրառվում է ձեր դպրոցից կամ ինտերնետ ակումբից վանդալիզմը կանխելու նպատակով:',

# History pages
'revhistory'          => 'Վերանայման պատմություն',
'viewpagelogs'        => 'Դիտել այս էջի տեղեկամատյանը',
'nohistory'           => 'Այս էջում խմբագրումների պատմություն չկա։',
'loadhist'            => 'Լցնում եմ էջի պատմությունը',
'currentrev'          => 'Ընթացիկ խմբագրում',
'revisionasof'        => '$1-ի տարբերակ',
'currentrevisionlink' => 'տեսնել ընթացիկ խմբագրումները',
'next'                => 'հաջորդ',
'last'                => 'վերջինը',
'histfirst'           => 'Առաջինը',
'histlast'            => 'Վերջինը',

# Diffs
'difference'              => '(Խմբագրումների միջև եղած տարբերությունները)',
'lineno'                  => 'Տող  $1.',
'editcurrent'             => 'Խմբագրել այս էջի ներկա տարբերակը',
'compareselectedversions' => 'Համեմատել ընտրված տարբերակները',

# Search results
'searchresults'     => 'Որոնումի արդյունքները',
'searchresulttext'  => '{{SITENAME}}յի որոնման ինֆորմացիայի համար, տես [[Պրոյեկտ:Որոնում|{{SITENAME}}յի որոնում]] էջը:',
'badquery'          => 'Որոնումի հարցը սխալ է ձևակերպվել։',
'badquerytext'      => 'Մենք չկարողացանք գտնել ձեր հարցումի պատասխանը։ 
Սա կարող է լինել մի քանի պատճառներով. կամ դուք փորձել եք գտնել մի բառ, որը երեքից քիչ  տառ է պարունակում, կամ բառի մասին համապատասխան հոդված առայժմ չկա։ Հնարավոր է նաև, որ սխալ եք հավաքել արտահայտությունը, օրինակ "չափ ու  ու  քանակի միավորներ"։ Խնդրում ենք այլ կերպ ձևակերպել հարցը, կամ փորձել հարցնել այլ  բառի մասին։',
'prevn'             => 'նախորդ $1',
'nextn'             => 'հաջորդ $1',
'viewprevnext'      => 'Դիտել ($1) ($2) ($3):',
'showingresults'    => 'Ստորև բերված են <b>$1</b> արդյունքներ` սկսած #<b>$2</b>-ից:',
'showingresultsnum' => 'Ստորև բերված են <b>$3</b> արդյունքներ` սկսած #<b>$2</b>-ից:',
'blanknamespace'    => '(Գլխավոր)',

# Preferences page
'preferences'              => 'Նախընտրությունները',
'mypreferences'            => 'Իմ նախընտրությունները',
'qbsettings-none'          => 'Թաքցնել',
'qbsettings-fixedleft'     => 'Ձախից անշարժ',
'qbsettings-fixedright'    => 'Աջից անշարժ',
'qbsettings-floatingleft'  => 'Ձախից լողացող',
'qbsettings-floatingright' => 'Աջից լողացող',
'changepassword'           => 'Փոխել նշանաբառը',
'skin'                     => 'Տեսք',
'saveprefs'                => 'Հիշել',
'resetprefs'               => 'Անտեսել փոփոխությունները',
'newpassword'              => 'Նոր նշանաբառը',
'retypenew'                => 'Հաստատեք նոր գաղտնաբառը`',
'rows'                     => 'Տողերի քանակը`',
'columns'                  => 'Սյունակներ',
'searchresultshead'        => 'Որոնել',
'recentchangescount'       => 'Վերնագրերի քանակը վերջին փոփոխություններում`',
'savedprefs'               => 'Ձեր հարմարությունները մտապահված են:',
'allowemail'               => 'Ցույց տալ էլ. փոստի հասցեն ուրիշ մասնակիցներին',

# Recent changes
'recentchanges'     => 'Վերջին փոփոխությունները',
'recentchangestext' => 'Հետևեք վիքիում արված վերջին փոփոխությունները այս էջում:',
'rcnote'            => 'Ստորև բերված են վերջին <strong>$1</strong> փոփոխությունները վերջին <strong>$2</strong> {{plural:$2|օրվա|օրերի}} ընթացքում, $3-ի դրությամբ։',
'rclistfrom'        => 'Ցույց տալ նոր փոփոխությունները սկսած $1',
'rclinks'           => 'Ցույց տալ վերջին $1 փոփոխությունները վերջին $2 օրվա ընթացքում<br />$3',
'diff'              => 'տարբ.',
'hist'              => 'պատմ',
'newpageletter'     => 'Ն',
'boteditletter'     => 'բ',

# Recent changes linked
'recentchangeslinked' => 'Կապված էջերի փոփոխություններ',

# Upload
'upload'         => 'Բեռնել ֆայլ',
'uploadbtn'      => 'Ավելացնել ֆայլը',
'filename'       => 'Ֆայլի անունը',
'filedesc'       => 'Ամփոփում',
'filestatus'     => 'Հեղինակային իրավունքի կարգավիճակ',
'filesource'     => 'Աղբյուրը',
'ignorewarning'  => 'Անտեսել զգուշացումը և պահպանել ֆայլը ամեն դեպքում։',
'badfilename'    => 'Պատկերի անունը փոխվել է` "$1"։',
'savefile'       => 'Հիշել ֆայլը',
'sourcefilename' => 'Սկզբնական ֆայլի անունը',

# Image list
'imagelist'           => 'Նկարների ցանկ',
'ilsubmit'            => 'Որոնել',
'showlast'            => 'Ցույց տալ վերջին $1 ֆայլերը, դասավորված $2:',
'byname'              => 'ըստ անվանումի',
'bydate'              => 'ըստ ամսաթվի',
'bysize'              => 'ըստ չափի',
'revertimg'           => 'վերականգնել',
'deleteimgcompletely' => 'Ջնջել բոլոր փոփոխությունները',
'linkstoimage'        => 'Հետևյալ էջերը կապ ունեն տվյալ պատկերի հետ.',
'nolinkstoimage'      => 'Այս պատկերի հետ ընդհանուր կապ ունեցող ոչ մի էջ չկա։',

# MIME search
'mimesearch' => 'Որոնում MIME-ով',

# List redirects
'listredirects' => 'Ցույց տալ վերահղումները',

# Unused templates
'unusedtemplates' => 'Չօգտագործվող կաղապարները',

# Random redirect
'randomredirect' => 'Պատահական վերահղում',

# Statistics
'statistics' => 'Վիճակագրություն',
'sitestats'  => 'Կայքի վիճակագրությունը',

'disambiguations'     => 'Երկիմաստ էջեր',
'disambiguationspage' => "Ադմիններ, խնդրում ենք պահպանել այս էջը իր հակասող շաբլոններով և բոլոր վերահղումներով:

Այս ցանկը կիրառվում է [[{{ns:special}}:Disambiguations]]-ի կողմից, բոլոր դեպի հակասող շաբլոններ վերահղումներ պարունակող հոդվածները ցույց տալու համար: Տվյալ ցանկը պգտագործվում է նաև տարբեր համաարգչային ծագում ունեցող վերահսկողների (bots) կողմից:

<small>Նշում. Այս էջը կարող է թարգմանվել և վերախմբագրվել: Բոլոր հղումները դեպի '''<nowiki>[[template:...]]</nowiki>''' կնայվեն ինչպես հղումներ դեպի հակասող շաբլոններ:</small>

* [[Template:Disambig]]",

'doubleredirects' => 'Կրկնակի վերահղումները',

'brokenredirects'         => 'Կոտրված վերահղումներ',
'brokenredirects-summary' => 'Կոտրված վերահղումներ` հակիրճ',
'brokenredirectstext'     => 'Հետևյալ վերահղումները ուղղված են գոյություն չունեցող էջեր:',

# Miscellaneous special pages
'nbytes'                  => '$1 բայթ',
'lonelypages'             => 'Միայնակ էջերը',
'uncategorizedpages'      => 'Չդասակարգված էջեր',
'uncategorizedcategories' => 'Չդասակարգված կատեգորիաներ',
'uncategorizedimages'     => 'Ոչ կատեգորիզացված նկարները',
'unusedcategories'        => 'Չօգտագործված կատեգորիաներ',
'unusedimages'            => 'Չօգտագործված նկարներ',
'wantedcategories'        => 'Անհրաժեշտ կատեգորիաներ',
'wantedpages'             => 'Անհրաժեշտ էջեր',
'mostlinked'              => 'Ամենաշատ հղումներով էջեր',
'mostlinkedcategories'    => 'Շատ հղվող կատեգորիաները',
'mostcategories'          => 'Ամենաշատ կատեգորիաներով էջեր',
'mostimages'              => 'Ամենաշատ օգտագործվող նկարները',
'mostrevisions'           => 'Ամենաշատ փոփոխվող էջեր',
'allpages'                => 'Բոլոր էջերը',
'prefixindex'             => 'Որոնում նախածանցով',
'randompage'              => 'Պատահական էջ',
'shortpages'              => 'Կարճ էջեր',
'longpages'               => 'Երկար էջեր',
'deadendpages'            => 'Հղում չպարունակող էջեր',
'listusers'               => 'Մասնակիցների ցանկը',
'specialpages'            => 'Սպասարկող էջեր',
'spheading'               => 'Սպասարկող էջեր բոլոր մասնակիցների համար',
'restrictedpheading'      => 'Արգելափակված սպասարկող էջեր',
'rclsub'                  => '(to pages linked from "$1")',
'newpages'                => 'Նոր էջեր',
'ancientpages'            => 'Ամենահին էջերը',
'intl'                    => 'Միջլեզվական լինքեր',
'move'                    => 'Տեղափոխել',
'movethispage'            => 'Տեղափոխել այս էջը',

# Book sources
'booksources' => 'Գրքային աղբյուրներ',

'categoriespagetext' => 'Հայերեն վիքիում կան հետևյալ կատեգորիաները՝',
'alphaindexline'     => '$1 -ից` $2',
'version'            => 'Տարբերակ',

# Special:Log
'log'         => 'Տեղեկամատյան',
'alllogstext' => 'Սա ներլցման (upload), ջնջումների , պաշտպանության, արգելափակման  (blocking) և  համակարգային օպերատորների (սիսոփների) գործողությունների  համախմբված ցանկն է։ Կարող եք նեղացնել դիտումի սահմանները` ընտրելով որևէ  ցանկի տեսակը, որևէ մասնակցի անունը կամ փոփոխության ենթարկված էջը։',

# Special:Allpages
'nextpage'          => 'Հաջորդ էջը ($1)',
'allpagesfrom'      => 'Ցույց տալ էջերը, որոնք սկսվում են`',
'allarticles'       => 'Բոլոր հոդվածները',
'allinnamespace'    => 'Բոլոր էջերը ($1 անվանակարգ)',
'allnotinnamespace' => 'Բոլոր էջերը (ոչ $1 անվանակարգում)',
'allpagesprev'      => 'Նախորդը',
'allpagesnext'      => 'Հաջորդը',
'allpagessubmit'    => 'Սկսել',
'allpagesprefix'    => 'Ցույց տալ հետևյալ նախածանցով էջերը`',
'allpagesbadtitle'  => 'Տվյալ էջի անունը սխալ է, կամ պարունակում է միջ-լեզվային, կամ միջ-wiki նախածանց: Այն կարող է պարունակել մեկ կամ ավելի սիմվոլներ, որոնք չի կարելի օգտագործել անվանումների մեջ:',

# E-mail user
'emailuser'     => 'Է-մակ ուղարկել այս մասնակցին',
'emailpage'     => 'Է-մակ ուղարկել մասնակցին',
'emailfrom'     => 'Ումից',
'emailto'       => 'Ում՝',
'emailsubject'  => 'Ինչի մասին՝',
'emailmessage'  => 'Ուղերձ',
'emailsend'     => 'Ուղարկել',
'emailsent'     => 'Է-մակը ուղարկված է',
'emailsenttext' => 'Ձեր է-մակ ուղերձն ուղարկված է։',

# Watchlist
'watchlist'         => 'Իմ հսկողության ցանկը',
'watchlistfor'      => "('''$1'''-ի համար)",
'addedwatch'        => 'Ավելացված է վերահսկման ցանկին',
'addedwatchtext'    => "\"\$1\" էջը ավելացվել է ձեր [[{{ns:special}}:Watchlist|վերահսկման ցանկին]]:

Այս էջի և նրան կապված քննարկումների էջի հետագա փոփոխությունները  կգրանցվեն այդտեղ, և էջը կհայտնվի '''հաստ''' ֆոնտով [[{{ns:special}}:Recentchanges|վերջին փոփոխությունների]] ցուցակի մեջ:

<p>Եթե դուք հետո ցանկանաք հանել էջը վերահսկման ցանկից, ապա սեղմեք \"Հանել վերահսկումից\" կոճակը:",
'removedwatch'      => 'Հանված է վերահսկման ցանկից',
'removedwatchtext'  => '"$1" էջը հանվել է ձեր վերահսկման ցանկից:',
'watch'             => 'Հսկել',
'watchthispage'     => 'Հսկել այս էջը',
'unwatch'           => 'Հանել հսկումից',
'watchdetails'      => '*  հսկվում {{PLURAL:$1|է $1 էջ|են $1 էջեր}}` չհաշված քննարկման էջերը
* [[{{ns:special}}:Watchlist/edit|Ցուցադրել և խմբագրել հսկողության լրիվ ցանկը]]
* [[{{ns:special}}:Watchlist/clear|Հանել բոլոր էջերը]]',
'watchlistcontains' => 'Ձեր հսկողության ցանկում կա  $1 էջ։',
'wlshowlast'        => 'Ցուցադրել վերջին $1 ժամերը $2 օրերը $3',

# Delete/protect/revert
'deletepage'           => 'Ջնջել էջը',
'confirm'              => 'Հաստատել',
'excontent'            => 'բովանդակությունը սա էր` «$1»',
'exblank'              => 'էջը դատարկ էր',
'confirmdelete'        => 'Հաստատել ջնջումը',
'historywarning'       => 'Զգուշացում. այս էջը, որը դուք պատրաստվում եք ջնջել, պատմություն ունի։',
'actioncomplete'       => 'Գործողությունը ավարտված  է',
'deletedarticle'       => 'ջնջված է "$1"',
'dellogpagetext'       => 'Ստորև կտեսնեք ամենավերջին ջնջումների ցանկը։',
'deletecomment'        => 'Ջնջելու պատճառը',
'cantrollback'         => 'Չեմ կարող վերականգնել նախորդ խմբագրման էջը։ Վերջին ուղղում կատարողը այս էջի հեղինակն է։',
'alreadyrolled'        => 'Չեմ կարող վերականգնել [[User:$2|$2]]–ի վերջին ուղղումը [[$1]]-ի մեջ ([[User talk:$2|Talk]])։ Ինչ-որ մեկն արդեն վերականգնել է  այն կամ ուղղում է կատարել այդ էջում։ 
Վերջին ուղղումն արվել է [[User:$3|$3]]-ի կողմից ([[User talk:$3|Talk]])։',
'protectlogpage'       => 'Պաշտպանությունների_տեղեկամատյան',
'protectlogtext'       => 'Ստորև բերված է պաշտպանված և պաշտպանությունից հանված էջերի ցանկը: Մանրամասնությունների համար, տես` [[Պրոյեկտ:Պաշտպանված էջ]]:',
'protectsub'           => '("$1" էջի պաշտպանում)',
'confirmprotecttext'   => 'Դուք իրո՞ք  ուզում եք պաշտպանել այս էջը։',
'confirmprotect'       => 'Հաստատել պաշտպանությունը',
'protectmoveonly'      => 'Պաշտպանել միայն տեղաշարժերից',
'protectcomment'       => 'Պաշտպանման պատճառը',
'confirmunprotecttext' => 'Դուք իրո՞ք ուզում եք պաշտպանությունից հանել այս էջը։',
'confirmunprotect'     => 'Հաստատել պաշտպանությունից հանելը',
'protect-text'         => 'Այստեղ դուք կարող եք տեսնել և փոխել [[$1]] էջի պաշտպանության աստիճանը: Խնդրում ենք համոզվեք, որ դուք գործում եք [[{{ns:project}}:Protected page|պրոյեկտի կանոնակարգի]] ներքո:',

# Undelete
'cannotundelete' => 'Հակաջնջումը չստացվեց, գուցե մեկ ուրիշն արդեն հակաջնջել է տվյալ էջը:',

# Contributions
'contributions' => 'Մասնակցի խմբագրումները',
'mycontris'     => 'Իմ խմբագրումները',
'contribsub2'    => '$1 ($2)-ի համար',

# What links here
'whatlinkshere' => 'Այստեղ հղվող էջերը',
'linklistsub'   => '(Կապերի ցանկը)',
'linkshere'     => "Հետևյալ էջերը հղում են '''[[:$1]]'''-ի վրա՝",
'nolinkshere'   => "Ուրիշ էջերից '''[[:$1]]''' էջի վրա հղումներ չկան։",
'isredirect'    => 'ռեդիրեքտ էջ',

# Block/unblock
'blockip'            => 'Արգելափակել մասնակցի մուտքը',
'blockiptext'        => 'Օգտվելով ստորև զետեղված ձևից կարող եք արգելափակել որևէ  առնաձին  IP հասցեից կամ մասնակցի անունից գրելու հնարավորությունը։ 
Նման բան կարելի է անել միայն վանդալիզմի կանխարգելման նպատակով և  համաձայն Ծրագրի 
[[{{ns:project}}:Policy|Ներքին քաղաքականության]] պահանջների։Նշեք արգելափակելու պատճառը (օրինակ նշեք այն էջը, որտեղ վանդալիզմ է տեղի ունեցել)։',
'ipaddress'          => 'IP հասցե/մասնակցի անուն',
'ipbexpiry'          => 'Մարման ժամկետը',
'ipbreason'          => 'Պատճառը',
'ipbsubmit'          => 'Արգելափակել տվյալ մասնակցի մուտքը',
'badipaddress'       => 'Սխալ  IP հասցե',
'blockipsuccesssub'  => 'Արգելափակումը կատարված է',
'blockipsuccesstext' => '"$1" -ի մուտքը արգելափակված է։
<br />Տես` [[{{ns:special}}:Ipblocklist|Արգելափակված IP-ների ցանկ]] բոլոր արգելափակումներին  ծանոթանալու  համար։',
'ipusubmit'          => 'Արգելափակումից հանել այս հասցեն',
'ipblocklist'        => 'Արգելափակված IP հասցեների և մասնակիցների ցանկը',
'blocklistline'      => '$1, $2 արգելափակել  է $3 (մինչև  $4)',
'anononlyblock'      => 'միայն անանունները',
'blocklink'          => 'արգելափակել',
'contribslink'       => 'խմբագրումներ',
'autoblocker'        => 'Արգելափակվել  է ինքն իրեն, որովհետև դուք  օգտվում եք  "$1"-ի  IP հասցեից։ Պատճառը սա է՝ "$2"։',
'blocklogpage'       => 'Արգելափակումների_մատյան',
'blocklogentry'      => 'արգելափակվել է  "$1"՝  արգելափակման դադարեցման  $2 ժամկետով',
'blocklogtext'       => 'Սա մասնակիցների մուտքը արգելափակելու և արգելափակումից հանելու գործողությունների մատյանն է։Ինքն իրեն արգելափակվող IP հասցեներն այստեղ չեն նշվում։Տես` [[{{ns:special}}:Ipblocklist|IP արգելափակումների ցանկը]] ներկայումս գործող արգելափակումների և ժամանակավոր կասեցումների ցանկի հետ ծանոթանալու համար։',

# Developer tools
'lockdb'           => 'Փակել տվյալների բազան',
'lockconfirm'      => 'Այո, ես իրոք ուզում եմ փակել տվյալների բազան։',
'lockbtn'          => 'Փակել տվյալների բազան',
'lockdbsuccesssub' => 'Տվյալների բազան փակված է',

# Move page
'movepage'        => 'Տեղափոխել էջը',
'movepagebtn'     => 'Տեղափոխել էջը',
'articleexists'   => 'Այս անվանումով էջ արդեն գոյություն ունի, կամ ձեր ընտրած անվանումը կիրառելի չէ։ Խնդրում ենք այլ անվանում ընտրել։',
'movedto'         => 'տեղափոխված է`',
'1movedto2'       => '[[$1]]-ից տեղափոխված է` [[$2]]',
'1movedto2_redir' => '[[$1]] -ից տեղափոխված է [[$2]]` ռեդիրեքտով',

# Export
'export' => 'Արտահանել էջերը',

# Namespace 8 related
'allmessages'               => 'Բոլոր համակարգային ուղերձները',
'allmessagesname'           => 'Անունը',
'allmessagesdefault'        => 'Լռությամբ տեքստը',
'allmessagescurrent'        => 'Տվյալ տեքստը',
'allmessagestext'           => 'Սա ` MediaWiki: անվանական տողերում  առկա  բոլոր համակարգային ուղերձների ցանկն է։',
'allmessagesnotsupportedUI' => 'Ձեր ընթացիկ ինտերֆեյսի լեզուն  <b>$1</b> չի  ընդունվում  այս կայքի {{ns:special}}:AllMessages համակարգի կողմից։',
'allmessagesnotsupportedDB' => '{{ns:special}}:AllMessages չի գործում, որովհետև  wgUseDatabaseMessages միացրած չէ:',
'allmessagesfilter'         => 'Ուղղերձների անվան ֆիլտր.',
'allmessagesmodified'       => 'Ցույց տալ միայն փոփոխվածները',

# Thumbnails
'filemissing' => 'Նման ֆայլ չկա',

# Special:Import
'importnotext' => 'Դատարկ է կամ տեքստ չկա։',

# Attribution
'anonymous'        => '{{SITENAME}}յի անանուն մասնակից(ներ)',
'lastmodifiedatby' => 'Այս էջը վերջին անգամ փոփոխվել է $2, $1 $3-ի կողմից:', # $1 date, $2 time, $3 user
'and'              => 'և',

# Spam protection
'categoryarticlecount'   => 'Այս կատեգորիայում կա  $1 հոդված։',
'category-media-count'   => 'Այս կատեգորիայում {{PLURAL:$1|կա մեկ ֆայլ|կան $1 ֆայլեր}}:',
'listingcontinuesabbrev' => ' շարունակ.',

# Image deletion
'deletedrevision' => 'Ջնջված է հին տարբերակը $1։',

'newimages' => 'Նոր ֆայլերի սրահ',
'noimages'  => 'Տեսնելու բան չկա։',

# 'all' in various places, this might be different for inflected languages
'watchlistall1' => 'բոլորը',
'watchlistall2' => 'բոլորը',

# Delete conflict
'deletedwhileediting' => 'Զգուշացում` Այս էջը ջնջվել է ձեր խմբագրման ընթացքում:',

'articletitles' => "Հոդվածներ, որոնք սկսվում են ''$1''-ով:",

# Table pager
'ascending_abbrev' => 'աճմ. կարգ.',

# Auto-summaries
'autosumm-blank'   => 'Ջնջվում է էջի ամբողջ պարունակությունը',
'autosumm-replace' => "Փոխվում է էջը '$1'-ով",
'autoredircomment' => 'Վերահղվում է դեպի [[$1]]', # This should be changed to the new naming convention, but existed beforehand
'autosumm-new'     => 'Նոր էջ. $1',

);

?>
