/*
 *    Copyright (C) 1998,1999,2000 Nikos Mavroyanopoulos
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: xmalloc.c,v 1.1.1.1 2000/05/22 13:09:35 nmav Exp $ */

#ifndef DEFINES_H
#define DEFINES_H
#include <defines.h>
#endif

#include <xmalloc.h>

static char rcsid[] = "$Id: xmalloc.c,v 1.1.1.1 2000/05/22 13:09:35 nmav Exp $";

/* memory allocation */
void *
 mcrypt_malloc(size_t size)
{
	char *x;

	x = malloc(size);
	if (x != NULL) {
		return x;
	} else {
		sleep(1);
		x = malloc(size);
		if (x != NULL) {
			return x;
		} else {
			fprintf(stderr, _("Cannot allocate memory\n"));
			exit(-1);
		}
	}
/* Not really needed */
	return x;
}

void *
 mcrypt_calloc(size_t nmemb, size_t size)
{
	char *x;

	x = calloc(nmemb, size);
	if (x != NULL) {
		return x;
	} else {
		sleep(1);
		x = calloc(nmemb, size);
		if (x != NULL) {
			return x;
		} else {
			fprintf(stderr, _("Cannot allocate memory\n"));
			exit(-1);
		}
	}
/* Not really needed */
	return x;

}

void *
 mcrypt_realloc(void *ptr, size_t size)
{
	char *x;

	x = realloc(ptr, size);
	if (x != NULL) {
		return x;
	} else {
		sleep(1);
		x = realloc(ptr, size);
		if (x != NULL) {
			return x;
		} else {
			fprintf(stderr, _("Cannot allocate memory\n"));
			exit(-1);
		}
	}
/* Not really needed */
	return x;

}



void *
 secure_mcrypt_malloc(size_t size)
{
	char *x;

	x = malloc(size);
	if (x != NULL) {
		return x;
	} else {
		sleep(1);
		x = malloc(size);
		if (x != NULL) {
			return x;
		} else {
			fprintf(stderr, _("Cannot allocate memory\n"));
			exit(-1);
		}
	}
/* Not really needed */
	return x;
}

void *
 secure_mcrypt_calloc(size_t nmemb, size_t size)
{
	char *x;

	x = calloc(nmemb, size);
	if (x != NULL) {
		return x;
	} else {
		sleep(1);
		x = calloc(nmemb, size);
		if (x != NULL) {
			return x;
		} else {
			fprintf(stderr, _("Cannot allocate memory\n"));
			exit(-1);
		}
	}
/* Not really needed */
	return x;

}

void *
 secure_mcrypt_realloc(void *ptr, size_t size)
{
	char *x;

	x = realloc(ptr, size);
	if (x != NULL) {
		return x;
	} else {
		sleep(1);
		x = realloc(ptr, size);
		if (x != NULL) {
			return x;
		} else {
			fprintf(stderr, _("Cannot allocate memory\n"));
			exit(-1);
		}
	}
/* Not really needed */
	return x;

}

void mcrypt_free( void* ptr) {
	free(ptr);
}

void secure_mcrypt_free( void* ptr, int size) {
	Bzero(ptr, size);
	free(ptr);
}

