/*           Copyright (C) 1999, 2000, 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of MCL.  You can redistribute and/or modify MCL under the
 * terms of the GNU General Public License; either version 2 of the License or
 * (at your option) any later version.  You should have received a copy of the
 * GPL along with MCL, in the file COPYING.
*/

#ifndef mcl_mcl_h
#define mcl_mcl_h

#include "interpret.h"
#include "expand.h"

#include "impala/matrix.h"
#include "taurus/ilist.h"

#include "util/opt.h"
#include "util/ting.h"

#include <pthread.h>


typedef struct
{  mcxIO*               outFile

;  int                  n_ithreads

;  int                  n_ethreads
;  mcxbool              cloneMatrices
;  mcxbool              cloneBarrier

;  mclExpandParam       *mxp

;  int                  marks[5]
;  mcxTing              *massLog    /* expand log, really */

;  int                  devel

;  mcxbool              dumpIterands
;  mcxbool              dumpClusters
;  mcxbool              dumpChr
;  int                  dumpModulo
;  int                  dumpOffset
;  int                  dumpBound
;  const char*          dumpStem
;  char                 dumpMode

;  double               chaosLimit
;  double               lap
;  int                  n_ite

;  mclVector*           vec_attr

;  double               mainInflation
;  int                  mainLoopLength
                                                     
;  double               initInflation
;  int                  initLoopLength
                                                     
;  int                  printMatrix
;  int                  printDigits

;  mcxbool              inflateFirst
;  mcxbool              expandOnly

;  mclIpretParam*       ipretParam
;  int                  dimension /* of input matrix */
;
}  mclProcParam         ;


/* default initialization */

mclProcParam* mclProcParamNew
(  void
)  ;

void mclProcParamFree
(  mclProcParam** ppp
)  ;


/* initialization part that depends on the graph cardinality */

void mclProcPrintInfo
(  FILE* fp
,  mclProcParam* mpp  
)  ;


/*
 * functions in two different modes, depending whether map->mpp->expandOnly
 * is set or not. Returns intermediate matrix if yes, cluster matrix
 * otherwise.
*/

mclMatrix*  mclProcess
(  mclMatrix*      mxEven
,  mclProcParam*   map
)  ;

/*
 * description       Change the return probabilities in mx (or add them if
 *                   missing) with such values that in each column the return
 *                   probability would not change under one application of
 *                   inflation (with power factor 2).
 *
 *                   The idea is that this value is a good value
 *                   representing `indifference' of the node with regard
 *                   to being attracted or being attractive.
*/


void mclxCenter
(  mclMatrix*  mx
,  double      w_center
,  double      w_selfval
)  ;

#endif

