/*           Copyright (C) 1999, 2000, 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of MCL.  You can redistribute and/or modify MCL under the
 * terms of the GNU General Public License; either version 2 of the License or
 * (at your option) any later version.  You should have received a copy of the
 * GPL along with MCL, in the file COPYING.
*/

#ifndef impala_io_h
#define impala_io_h

#include <math.h>
#include <stdio.h>

#include "vector.h"
#include "matrix.h"

#include "util/io.h"
#include "util/types.h"


#define mclxCanary   0x4D545833     /* MTX3 */
#define mclvCanary   0x56454331     /* VEC1 */


/* TODO: make ascii format parsing stricter. */


mclMatrix* mclxRead
(  mcxIO*            xfIn
,  mcxOnFail         ON_FAIL
)  ;


mcxstatus mclxFilePeek
(  mcxIO*            xfIn
,  int               *n_cols
,  int               *n_rows
,  mcxOnFail         ON_FAIL
)  ;


mclMatrix* mclxMaskedRead
(  mcxIO*            xfIn
,  const mclVector*  selector
,  mcxOnFail         ON_FAIL
)  ;


/* returns next (mcl line */

mcxTing* mclxReadAsciiHeader
(  mcxIO* xf
,  mclVector **dom_rowspp    /* *dom_rowspp should not point to object */
,  mclVector **dom_colspp    /* *dom_colspp should not point to object */
,  mcxstatus *status
)  ;


mclMatrix* mclxReadAscii
(  mcxIO*            xfIn
,  mcxOnFail         ON_FAIL
)  ;


enum
{  MCLXR_ENTRIES_ADD
,  MCLXR_ENTRIES_MAX
,  MCLXR_ENTRIES_MUL
,  MCLXR_ENTRIES_POP
,  MCLXR_ENTRIES_PUSH

,  MCLXR_VECTORS_ADD
,  MCLXR_VECTORS_MAX
,  MCLXR_VECTORS_MUL
,  MCLXR_VECTORS_POP
,  MCLXR_VECTORS_PUSH
}  ;


mclVector* mclvReadAsciiRaw
(  mcxIO          *xf
,  mclpAR*        ar
,  mcxOnFail      ON_FAIL
,  int            finalToken     /* e.g. EOF or '$' */
,  mcxbits        warn_repeat
,  void (*ivpmerge)(void* ivp1, const void* ivp2)
)  ;


mcxstatus mclxReadAsciiRaw
(  mcxIO          *xf
,  mclMatrix      *mx
,  mcxOnFail      ON_FAIL
,  int            finalToken     /* e.g. EOF or ')' */
,  mcxbits        warn_repeat
,  void (*ivpmerge)(void* ivp1, const void* ivp2)
,  double (*fltbinary)(pval val1, pval val2)
)  ;


mcxstatus  mclxWriteBinary
(  const mclMatrix*  mtx
,  mcxIO*            xfOut
,  mcxOnFail         ON_FAIL
)  ;


void mcxPrettyPrint
(  const mclMatrix*  mx
,  FILE*             fp
,  int               width
,  int               digits
,  const char        msg[]
)  ;


void mclFlowPrettyPrint
(  const mclMatrix*  mx
,  FILE*             fp
,  int               digits
,  const char        msg[]
)  ;


mcxstatus mclxTaggedWrite
(  const mclMatrix*  mx
,  const mclMatrix*  dom
,  mcxIO*            xfOut
,  int               valdigits
,  mcxOnFail         ON_FAIL
)  ;


mcxstatus mclxWriteAscii
(  const mclMatrix*  mx
,  mcxIO*            xfOut
,  int               valdigits
,  mcxOnFail         ON_FAIL
)  ;


void                 mclxBoolPrint
(  mclMatrix*        mx
,  int               mode
)  ;


mcxstatus mclvEmbedRead
(  mclVector*        vec
,  mcxIO*            xfIn
,  mcxOnFail         ON_FAIL
)  ;


mcxstatus mclvWrite
(  const mclVector*  vec
,  mcxIO*            xfOut
,  mcxOnFail         ON_FAIL
)  ;


mcxstatus mclvEmbedWrite
(  const mclVector*  vec
,  mcxIO*            xfOut
)  ;


void mclvWriteAscii
(  const mclVector*  vec
,  FILE*             fp
,  int               valdigits
)  ;


void mclvDumpAscii
(  const mclVector*  vec
,  FILE*             fp
,  int               idxwidth
,  int               valdigits
,  mcxbool           doHeader
)  ;


mclpAR *mclpReadAsciiRaw
(  mcxIO       *xf
,  mcxOnFail   ON_FAIL
,  int         finalToken     /* e.g. EOF or '$' */
)  ;


#endif

