/* -*- C -*- 
  mboxgrep - scan mailbox for messages matching a regular expression
  Copyright (C) 2000, 2001  Daniel Spiljar

  Mboxgrep is free software; you can redistribute it and/or modify it 
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  Mboxgrep is distributed in the hope that it will be useful, but 
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with mboxgrep; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: mh.c,v 1.6 2001/11/19 00:47:14 dspiljar Exp $ */

#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <sys/types.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>

#include "mboxgrep.h"
#include "misc.h"
#include "mh.h"
#include "wrap.h"

DIR *mh_open(const char *path)
{
  DIR *dp;
  extern int merr;

  dp = opendir(path);
  if (dp == NULL)
    {
      if (merr)
	{
	  fprintf(stderr, "%s: %s: ", APPNAME, path);
	  perror(NULL);
	}
      errno = 0;
      return NULL;
    }
  return dp;
} /* mh_open */

void mh_close(DIR *dp)
{
  closedir(dp);
} /* mh_close */

message_t *mh_read_message(DIR *dp)
{
  int isheaders = 1;
  int have_from = 0, have_to = 0, have_message_id = 0, have_return_path = 0;
  static int s;
  message_t *message;
  struct dirent *d_content;
  char buffer[BUFSIZ], *filename;
  FILE *fp;
  extern format_t format;
  extern char *boxname;
  extern int merr;

  message = (message_t *) xmalloc (sizeof (message_t));

  message->headers = (char *) xmalloc (sizeof (char));
  message->headers[0] = '\0';
  message->hbytes = 0;

  message->body = (char *) xmalloc (sizeof (char));
  message->body[0] = '\0';
  message->bbytes = 0;

  for(;;)
    {
      d_content = readdir(dp);
      if (d_content == NULL) return NULL;
      if (d_content->d_name[0] == '.')
	continue;

      filename = 
	(char *) xmalloc((strlen(d_content->d_name)) + (strlen(boxname)) + 2);

      filename[0] = '\0';
      sprintf(filename, "%s/%s", boxname, d_content->d_name);
      fp = m_fopen(filename, "r");
      isheaders = 1;
      if (fp == NULL)
	  continue;

      fgets (buffer, BUFSIZ, fp);
      if (format == NNML || format == NNMH)
	{
	  if (0 != strncmp("X-From-Line: ", buffer, 13))
	    {
	      if (merr)
		fprintf(stderr, "%s: %s: Not a Gnus folder message\n", 
			APPNAME, filename);
	      fclose(fp);
	      continue;
	    }
	}
      
      fseek(fp, 0, SEEK_SET);
      while (fgets (buffer, BUFSIZ, fp) != NULL)
	{
	  s = strlen (buffer);
	  if (0 == strncmp ("\n", buffer, 1) && isheaders == 1)
	    {
	      isheaders = 0;
	      continue;
	    } /* if */
	  if (isheaders)
	    {
	      if (0 == strncmp ("Date: ", buffer, 6) && isheaders == 1)
		message->date = parse_date(buffer);
	      if (0 == strncasecmp ("From: ", buffer, 6))
		have_from = 1;
	      if (0 == strncasecmp ("To: ", buffer, 4))
		have_to = 1;
	      if (0 == strncasecmp ("Message-ID: ", buffer, 12))
		have_message_id = 1;
	      if (0 == strncasecmp ("Return-Path: ", buffer, 13))
		{
		  have_return_path = 1;
		  message->from = parse_return_path(buffer);
		}

	      message->headers =
		(char *) realloc (message->headers,
				  ((1 + s + message->hbytes) * sizeof (char)));
	      strcpy (message->headers + message->hbytes, buffer);
	      message->hbytes += s;
	    } /* if */
	  else
	    {
	      message->body =
		(char *) realloc (message->body,
				  ((1 + s + message->bbytes) * sizeof (char)));
	      strcpy (message->body + message->bbytes, buffer);
	      message->bbytes += s;
	    } /* else */
	} /* while */
      if (format == MH)
	{
/*      if (!have_from || !have_to || !have_message_id || !have_return_path) */
	  if (!have_from || !have_to || !have_message_id)
	    {
	      if (merr)
		fprintf(stderr, "%s: %s: Not a RFC 2822 message\n",
			APPNAME, filename);
	      fclose(fp);
	      continue;
	    }
	}
      message->filename = (char *) strdup(filename);
      fclose (fp);
      free(filename);

      return message;
    } /* for */
} /* mh_read_message */

void mh_write_message(message_t *m, const char *path)
{
  struct dirent *dc;
  int x, y = 0;
  char s1[BUFSIZ];
  DIR *d; FILE *f;

  d = m_opendir(path);
  rewinddir(d);

  while ((dc = readdir (d)) != NULL)
    {
      x = strtol (dc->d_name, NULL, 10);
      if (x > y)
	y = x;
    }
  y++;
  sprintf (s1, "%s/%i", path, y);
  
  f = m_fopen(s1, "w");
  fprintf(f, "%s\n%s", m->headers, m->body);
  fclose(f);
}
