/*
 * This file contains a prototype main() for a Mathomatic library.
 * Refer to this, if you are going to use the Mathomatic code in other projects.
 *
 * The idea is to copy this code into the main() of the project using the Mathomatic code.
 * It is necessary for proper functioning.
 *
 * Mathomatic Copyright (c) 1996 George Gesslein II.
 */

#include "../includes.h"
#include <signal.h>

int
main(int argc, char **argv)
{
	int	i;
	char	*cp;

	init_gvars();
	gfp = stdout;

	if (!init_mem()) {
		fprintf(stderr, _("Not enough memory.\n"));
		exit(1);
	}
	if ((i = setjmp(jmp_save)) != 0) {
		clean_up();	/* Mathomatic processing was interrupted, so do a clean up. */
		/* Handle longjmp() errors here. */
	} else {
		signal(SIGFPE, fphandler);
	}
	/* Mathomatic is ready for use. */
	/* This is an input/output loop for testing. */
	for (;;) {
		snprintf(prompt_str, sizeof(prompt_str), "%d%s", cur_equation + 1, html_flag ? HTML_PROMPT : PROMPT);
		if ((cp = getstring((char *) tlhs, n_tokens * sizeof(token_type))) == NULL)
			break;
		process(cp);
	}
	exit_program(0);
}

void
fphandler(int sig)
{
	/* a floating point exception occured */
	signal(SIGFPE, fphandler);
	longjmp(jmp_save, 2);
}

/*
 * Exit this program and return to the Operating System.
 */
void
exit_program(int exit_value)
{
	exit(exit_value);
}
