/*
 * Main include file for Mathomatic.
 */

#define	true	1
#define	false	0

#ifndef	max
#define max(a,b)    (((a) > (b)) ? (a) : (b))
#endif
#ifndef	min
#define min(a,b)    (((a) < (b)) ? (a) : (b))
#endif
#ifndef	isfinite
#define	isfinite(d)	finite(d)
#endif

#undef	PI
#define	PI	3.141592653589793238
#define	E	2.718281828459045235

#define	ARR_CNT(a)	(sizeof(a)/sizeof(a[0]))	/* returns the number of elements in an array */

#define	MAX_K_INTEGER	1.0e14	/* 14 digits for doubles */

#define	blt(dst, src, cnt)	memmove((char *) (dst), (char *) (src), (size_t) (cnt))	/* memory copy function for Mathomatic */
#define always_positive(power)	(fmod((double) (power), 2.0) == 0.0)	/* true if all real numbers raised to "power" result in positive, real numbers */

#if	I18N	/* internationalization */
#define _(str)		gettext(str)
#else
#define _(str)		str
#endif

#define	TMP_FILE	"/tmp/mathomatic.XXXXXX"	/* temp file template */

#define	PROMPT		"-> "	/* user interface prompt string */
#define	HTML_PROMPT	"-&gt; "

#define	EPSILON		true	/* true if we want to take into account floating point inaccuracies */

#define	MAX_CMD_LEN	500	/* maximum command line length (not equations), also max file name length */

#if	CYGWIN
#define RC_FILE		"mathomatic.rc"
#else
#define RC_FILE		".mathomaticrc"	/* file of set options read at startup from $HOME */
#endif

/*
 * The following defines the maximum number of equation spaces
 * that will be allocated.
 */
#define	N_EQUATIONS	40

/*
 * The following defines the default maximum mathematical expression size.
 */
#define	DEFAULT_N_TOKENS	7500

#define	DIVISOR_SIZE	(DEFAULT_N_TOKENS / 2)	/* A nice maximum divisor size. */

#define	MAX_VAR_NAMES	8000	/* Maximum number of long variable names. Keep this under (VAR_MASK - VAR_OFFSET). */
#define	MAX_VAR_LEN	80	/* Maximum size of long variable names */

#define	MAX_VARS	500	/* Maximum number of unique variables handled in each equation */

#define	VAR_OFFSET	'A'	/* makes space for predefined variables */
#define	VAR_MASK	0x3fffL	/* mask for bits containing the variable name */
#define	VAR_SHIFT	14	/* number of bits set in VAR_MASK */
#define	SUBSCRIPT_MASK	63	/* mask for variable subscript after shifting VAR_SHIFT */
#define	MAX_SUBSCRIPT	(SUBSCRIPT_MASK - 1)	/* maximum variable subscript */
#define PRIME_INCREMENT	0x10000000L	/* value to add to increment the number of primes */

typedef	char	sign_array_type[MAX_SUBSCRIPT+2];

/*
 * The following structure is used for each Mathomatic command.
 */
typedef	struct {
	char	*name;		/* command name to be typed by user */
	int	(*func)();	/* function that handles this command */
				/* function is passed a char pointer and returns true if successful */
	char	*usage;		/* command syntax */
	char	*info;		/* short description of command */
} com_type;

enum kind_list {		/* kinds of tokens specified in the union below */
	CONSTANT,
	VARIABLE,
	OPERATOR
};

typedef union {
	double	constant;	/* internal storage for mathematical constants */
	long	variable;	/* internal storage for mathematical variables */
/* predefined variables follow (order is important) */
#define	V_NULL		0L	/* null variable (display nothing) */
#define	V_E		1L	/* the constant "e" */
#define	V_PI		2L	/* the constant "pi" */
#define	IMAGINARY	3L	/* the imaginary constant "i#" */
#define	SIGN		4L	/* the "sign" variable */
#define	MATCH_ANY	5L	/* match any variable (wild-card variable) */
#define	V_ANSWER	6L	/* the "answer" variable */
#define V_TEMP		7L	/* the "temp" variable */
#define	V_INTEGER	8L	/* the "integer" variable */
	int	operatr;	/* internal storage for operators */
/* valid operators follow */
#define	PLUS		1
#define	MINUS		2
#define	TIMES		3
#define	DIVIDE		4
#define	POWER		5
#define	FACTORIAL	6
#define	NEGATE		7
#define	MODULUS		8
} storage_type;

/*
 * The following structure defines the storage for each token in an expression.
 */
typedef	struct {
	enum kind_list	kind;
	int		level;	/* level of parentheses, origin 1 */
	storage_type	token;
} token_type;

typedef struct complexs {	/* complex number structure */
	double	re;		/* real part */
	double	im;		/* imaginary part */
} complexs;

typedef struct {		/* variable sort data structure */
	long	v;
	int	count;
} sort_type;

#if	SILENT
#define	list_tdebug(level)
#define	side_debug(level, p1, n1)
#define debug_string(level, str)
#else
#define list_tdebug(level)		list_debug(level, tlhs, n_tlhs, trhs, n_trhs)
#define	side_debug(level, p1, n1)	list_debug(level, p1, n1, NULL, 0)
#define debug_string(level, str)	{ if (debug_level >= level) printf("%s\n", str); }
#endif
