/* $Id: section_index.h,v 1.7 2003/04/22 06:30:12 jtalkington Exp $ */

#ifndef DISABLE_SECTION_INDEXES

#define INDEX_HREF "<a href=\"%s\?program=%s&amp;section=%s\">%s</a>"
#define INDEX_TOP_HREF "<a href=\"#%p\">[%c]</a> "

struct index_prog_node {
	char *name;
	struct index_prog_node *left;
	struct index_prog_node *right;
};

struct index_alpha_node {
	char name;
	struct index_prog_node *data;
	struct index_alpha_node *right;
	struct index_alpha_node *left;
};

struct pathlist_struct {
	char *name;
	struct pathlist_struct *next;
};

#define MANDIR_PREFIX_COUNT 2
char *mandir_prefixes[] = {
	"man",
	"sman"
};

void add_to_index(struct index_alpha_node **node, char index, char *name);
void add_index_prog_node(struct index_prog_node **node, char *name);
void output_index_alpha_node(struct index_alpha_node **node, char *script_name, char *section);
void output_index_prog_node(struct index_prog_node **node, char *script_name, char *section);
void add_to_manpath_list(struct pathlist_struct *node);
void generate_manpath_list(void);
void add_dir_to_index(DIR *dir, char *section);
char *gen_index_url(char *script_name, char *program, char *section);
void output_index_top(struct index_alpha_node **node);
char *gen_top_url(struct index_alpha_node **node);

#ifdef M2W_CLEANUP
void cleanup_index_alpha_node(struct index_alpha_node **node);
void cleanup_index_prog_node(struct index_prog_node **node);
void cleanup_manpath_list(struct pathlist_struct *mp);

#endif /* M2W_CLEANUP */

#endif /* DISABLE_SECTION_INDEXES */

void output_index_denied(void);
