/* $Id: output_man.h,v 1.7 2003/04/28 00:39:28 jtalkington Exp $ */

/* states of format_state */
#define BOLD (1<<0)
#define UNDERLINE (1<<1)
#define BLANK (1<<2)    
#define IN_SPAN (1<<3)

/* masks for special html symbols 
 *
 * these seem to be in between ascii and ISO 8559-x character sets,
 * so man should (theoretically) not use them, but but I'm not sure 
 * what they are for.  Let's use them and see what happens!
 */
const char LT_MASK = 0x80;
const char GT_MASK = 0x81;
const char AMP_MASK = 0x82;
const char BOLD_MASK = 0x83;
const char UNDERLINE_MASK = 0x84;
const char SPAN_MASK = 0x85;
const char BULLET_MASK = 0x86;

const char invalid_url[] = {
	' ', '<', '>', '%', '"', '{', '}', 
	'|', '\\', '^', '[', ']', '\'', '`'
};

/* html tags */
#define BOLD_START "<span class=\"bold\">"
#define UNDERLINE_START "<span class=\"underline\">"
#define SPAN_END "</span>"
#define MAN_HREF "<a href=\"%s\?program=%s&amp;section=%s\">%s</a>(%s)"
#define HTTP_START "http://"
#define FTP_START "ftp://"
#define EXT_HREF "<a href=\"%s\">%s</a>"


/* 
 * realloc() and calloc() seem to be broken on my system (glibc-2.2.93 on 
 * RedHat 8.0), so use my_str_realloc...
 */

/* private prototypes */
char *do_convert(char *line);

/* special characters and bold/underline */
char *mask_special(char *line);
char *demask_special(char *line);
char *make_iso_string(char c);

/* link generation functions */
char *add_ext_links(char *line);
char *gen_ext_url(char *url_start, char *url_end);
char *find_url_end(char *url_start);
char *ext_linkify(char *line, char *prefix);
char *gen_script_url(char *script_name, char *program, char *section);
char *add_man_links(char *line);
char *extract_section(char *input);
