/* $Id: m2wconfig.c,v 1.12 2003/04/01 03:00:41 jtalkington Exp $ */

#include "common.h"
#include "m2wconfig.h"

/* the Config struct */
struct Config_struct Config;

/* init_config()
 * reads the configuration file and populates the Config struct
 * returns 0 on success or the line number of the file that
 * was invalid
 */
int
init_config() {
#ifndef DISABLE_CONFIG_FILE
	FILE *config_fh = NULL;
	char line[BUFSIZ];
	int i = 0;
#endif /* DISABLE_CONFIG_FILE */

#ifdef DEFAULT_MANPATH_SWITCH
	Config.manpath_sw = strdup(DEFAULT_MANPATH_SWITCH);
#endif

#ifndef DISABLE_APROPOS
#ifdef DEFAULT_APROPOS
	Config.apropos = strdup(DEFAULT_APROPOS);
#endif
#endif

#ifdef DEFAULT_SECTION_SWITCH
	Config.section_sw = strdup(DEFAULT_SECTION_SWITCH);
#endif

#ifndef DISABLE_CONFIG_FILE
	if((config_fh = fopen(CONFIG_FILE, "r")) != NULL) {
		while(fgets(line, sizeof(line), config_fh) != NULL) {
			i++;
				if(parse_config_line(line) != 0) {
					fclose(config_fh);
					Config.disabled |= CONFIG_INVALID;
					return(i);
				}
		}
		fclose(config_fh);
	}
#endif /* !DISABLE_CONFIG_FILE */

	if(Config.style_sheet == NULL) {
		init_default_style_sheet();
	}

	if(Config.man_command == NULL) {
		Config.man_command = strdup(DEFAULT_MAN_COMMAND);
	}

	if(Config.sections == NULL) {
		init_default_sections();
	}

#ifdef DEFAULT_MANPATH
	if(Config.manpath == NULL) {
		Config.manpath = strdup(DEFAULT_MANPATH);
	}
#endif

	return(0);

}

#ifndef DISABLE_CONFIG_FILE

/* parse_config_line 
 * takes a line that was read from the config file and parses it
 * returns 0 on success, 1 of the line was invalid
 */
int
parse_config_line(char *line) {
	char *cur = NULL;
	char *value = NULL;

	if(line == NULL) {
		return(1);
	}

	/* kill the trailing newline/return */
	cur = line + strlen(line) - 1;
	while(*cur == '\n' || *cur == '\r') {
		memset(cur, '\0',1);
		cur--;
	}
	cur = line;
	
	/* kill leading whitespace */
	while(*cur == ' ' || *cur == '\t') {
		cur++;
	}

	/* skip lines that are comments or blank */
	if(*cur == '#' || *cur == '\0') {
		return(0);
	}

	/* MANPATH_SWITCH must come before MANPATH */
	if(strncmp(cur, "MANPATH_SWITCH", 14) == 0) {
		value = skip_white(cur + 14);
		
		if(Config.manpath_sw != NULL) {
			free(Config.manpath_sw);
			Config.manpath_sw = NULL;
		}

		if(value != NULL) {
			Config.manpath_sw = strdup(value);
		}
		
		return(0);

	} else if(strncmp(cur, "MANPATH", 7) == 0) {
		value = skip_white(cur + 7);

		/* append to the manpath, to allow for man.config style
		 * entries
		 */
		if(value != NULL) {
			if(Config.manpath != NULL) {
				Config.manpath = str_app_c(Config.manpath, ':');
			}
			Config.manpath = str_app_s(Config.manpath, value);
		}

		return(0);

	} else if(strncmp(cur, "MAN_COMMAND", 11) == 0) {
		value = skip_white(cur + 11);

		if(Config.man_command != NULL) {
			free(Config.man_command);
			Config.man_command = NULL;
		}

		if(value != NULL) {
			Config.man_command = strdup(value);
			return(0);
		} else {
			/* we can't have a NULL man command */
			return(1);
		}

	} else if(strncmp(cur, "SECTION_SWITCH", 14) == 0) {
		value = skip_white(cur + 14);

		if(Config.section_sw != NULL) {
			free(Config.section_sw);
			Config.section_sw = NULL;
		}

		if(value != NULL) {
			Config.section_sw = strdup(value);
		}

		return(0);
	} else if(strncmp(cur, "APROPOS", 7) == 0) {
		value = skip_white(cur + 7);

#ifndef DISABLE_APROPOS
		if(Config.apropos != NULL) {
			free(Config.apropos);
			Config.apropos = NULL;
		}

		if(value != NULL) {
			Config.apropos = strdup(value);
		}
#endif /* DISABLE_APROPOS */
		return(0);

	} else if(strncmp(cur, "STYLE", 5) == 0) {
		value = skip_white(cur + 5);

		if(value != NULL) {
			add_to_style_sheet(value);
		} else {
			return(1);
		}
	} else if(strncmp(cur, "SECTION", 7) == 0) {
		value = skip_white(cur + 7);

		if(value != NULL) {
			return(parse_section_line(value));
		} else {
			return(1);
		}

	} else if(strncmp(cur, "DISABLE", 7) == 0) {
		value = skip_white(cur + 7);

		if(value != NULL) {
			if(strncmp(cur, "APROPOS", 7) == 0) {
				Config.disabled |= D_APROPOS;
			} else if(strncmp(cur, "INDEXES", 7) == 0) {
				Config.disabled |= D_INDEXES;
			} else {
				return(1);
			}
		} else {
			return(1);
		}
	} else {
		/* invalid line */
		return(1);
	}

	return(0);
}
#endif /* DISABLE_CONFIG_FILE */

/* print out the config file, or defaults if there isn't one */
void
output_config() {
	
	printf("MAN_COMMAND %s\n\n", Config.man_command);

	if(Config.manpath_sw != NULL) {
		printf("MANPATH_SWITCH %s\n\n", Config.manpath_sw);
	} else {
		printf("MANPATH_SWITCH\n\n");
	}

	if(Config.manpath != NULL) {
		printf("MANPATH %s\n\n", Config.manpath);
	} else {
		printf("MANPATH\n\n");
	}

	if(Config.section_sw != NULL) {
		printf("SECTION_SWITCH %s\n\n", Config.section_sw);
	} else {
		printf("SECTION_SWITCH\n\n");
	}

	if(Config.apropos != NULL) {
		printf("APROPOS %s\n\n", Config.apropos);
	} else {
		printf("APROPOS\n\n");
	}

	if(Config.disabled & D_INDEXES) {
		printf("DISABLE INDEXES\n\n");
	}

	if(Config.disabled & D_APROPOS) {
		printf("DISABLE APROPOS\n\n");
	}

	output_section_config();
	printf("\n");
	output_style_sheet_config();
}

#ifdef M2W_CLEANUP
void
cleanup_config() {
	if(Config.man_command != NULL) {
		free(Config.man_command);
	}

	if(Config.manpath_sw != NULL) {
		free(Config.manpath_sw);
	}

	if(Config.manpath != NULL) {
		free(Config.manpath);
	}

	if(Config.section_sw != NULL) {
		free(Config.section_sw);
	}

	if(Config.apropos != NULL) {
		free(Config.apropos);
	}
	
	cleanup_style_sheet();
	cleanup_sections();
}
#endif /* M2W_CLEANUP */



